from stripe import api_requestor as api_requestor
from stripe.api_resources.abstract import (
    CreateableAPIResource as CreateableAPIResource,
    DeletableAPIResource as DeletableAPIResource,
    ListableAPIResource as ListableAPIResource,
    UpdateableAPIResource as UpdateableAPIResource,
    custom_method as custom_method,
    nested_resource_class_methods as nested_resource_class_methods,
)

class Customer(CreateableAPIResource, DeletableAPIResource, ListableAPIResource, UpdateableAPIResource):
    OBJECT_NAME: str
    def delete_discount(self, **params) -> None: ...
    @classmethod
    def balance_transactions_url(cls, id, nested_id=...): ...
    @classmethod
    def balance_transactions_request(
        cls, method, url, api_key=..., idempotency_key=..., stripe_version=..., stripe_account=..., **params
    ): ...
    @classmethod
    def create_balance_transaction(cls, id, **params): ...
    @classmethod
    def retrieve_balance_transaction(cls, id, nested_id, **params): ...
    @classmethod
    def modify_balance_transaction(cls, id, nested_id, **params): ...
    @classmethod
    def list_balance_transactions(cls, id, **params): ...
    @classmethod
    def sources_url(cls, id, nested_id=...): ...
    @classmethod
    def sources_request(cls, method, url, api_key=..., idempotency_key=..., stripe_version=..., stripe_account=..., **params): ...
    @classmethod
    def create_source(cls, id, **params): ...
    @classmethod
    def retrieve_source(cls, id, nested_id, **params): ...
    @classmethod
    def modify_source(cls, id, nested_id, **params): ...
    @classmethod
    def delete_source(cls, id, nested_id, **params): ...
    @classmethod
    def list_sources(cls, id, **params): ...
    @classmethod
    def tax_ids_url(cls, id, nested_id=...): ...
    @classmethod
    def tax_ids_request(cls, method, url, api_key=..., idempotency_key=..., stripe_version=..., stripe_account=..., **params): ...
    @classmethod
    def create_tax_id(cls, id, **params): ...
    @classmethod
    def retrieve_tax_id(cls, id, nested_id, **params): ...
    @classmethod
    def delete_tax_id(cls, id, nested_id, **params): ...
    @classmethod
    def list_tax_ids(cls, id, **params): ...
