#
# verify.py
#
# Copyright (C) 2005  Dr. Stephane Gagne
# the full copyright notice is found in the LICENSE file in this directory
#
# This program is free software; 
# you can redistribute it and/or modify it under the terms of the 
# GNU General Public License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, Inc., 
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Contact:  nmr@rsvs.ulaval.ca
#
# --------------------------------------------------------------------
# author:  Leigh Willard
# lab:     Stephane Gagne, Laval Universite
# date:    jan 2004
# --------------------------------------------------------------------
#



from pymol import cmd
from Tkinter import *
from tkFileDialog import *
import string, sys, time, math, os
import ltorsions as ltorsions 


#........................................................................
def saved_output(fname):
    """ routine to save output """
    global myverify

#       get name of output file.  open file.
    fp = asksaveasfile(initialfile=fname)

    print >> fp, "#"
    print >> fp, "# PyNMR violations"
    print >> fp, "#"
    print >> fp, "# Restraints file: ", myverify.maingui.fname.get()
    print >> fp, "# Date: ", time.asctime(time.localtime(time.time()))
    print >> fp, "#\n"
    print >> fp,  "%s  %s  %s          %s  %s  %s  %s %s  %s"% ("VIOL#", 
        "      OBJECT",
        "RES", "TYPE", "RST", "LOWER", "UPPER",
        "ACTUAL", "VIOLATION")

#       idxL is a sorted array of indexes.  The user
#       can sort the output in a couple of different ways.
#       only the indexes get sorted, making this portion easy.

    for idx in xrange(myverify.violations.numviol):
        idx1 = '%d.0'%(idx+1)
        idx2 = '%d.end'%(idx+1)
        print >> fp, "%3s  %12s  %4s  %3s  %5s  %7s  %7s  %7s  %7s"% \
        ( myverify.violations.col0.lb.get(idx1, idx2),
        myverify.violations.col1.lb.get(idx1, idx2),
        myverify.violations.col8.lb.get(idx1, idx2),
        myverify.violations.col2.lb.get(idx1, idx2),
        myverify.violations.col3.lb.get(idx1, idx2),
        myverify.violations.col4.lb.get(idx1, idx2),
        myverify.violations.col5.lb.get(idx1, idx2),
        myverify.violations.col6.lb.get(idx1, idx2),
        myverify.violations.col7.lb.get(idx1, idx2))
        

#.........................................................................
def doVerify():
    """ called when the CALCULATE button is pressed """

    global myverify

    # now we know what type of constraints, 
    # initialize the rest of our main object.
    type = myverify.maingui.type.get()
    cmd.delete("viol_*")

    # NOE 
    if type == 1:
        myverify.distances = NOEDistances()
        myverify.constraints = NOEConstraints()
        print "Reading Constraints."
        myverify.constraints.readCnsts(myverify.maingui)
        print "Number of constraints: ", myverify.constraints.numCsts
        myverify.violations = NoeViolation()
        myverify.violations.doVerifyNOE(myverify)

    # DIHEDRAL
    else:
        myverify.distances = list()
        myverify.constraints = DihConstraints()
        myverify.constraints.readCnsts(myverify.maingui)
        myverify.violations = DihViolation()
        myverify.violations.doVerifyDih(myverify)


    print "*** TOTAL NUMBER OF VIOLATIONS: ", myverify.violations.numviol_actual
    myverify.maingui.drawB.config(state="normal")
    myverify.maingui.clearB.config(state="normal")
    violations = myverify.violations
    violations.cleanup_old()
    violations.draw(type)
    violations.printViolations()


#---------------------------------------------------------------------------
def calcdraw():
    """  called when the CALCULATE & DRAW button is pressed """
    doVerify()
    colorObjects()


def colorObjects():
    """ store the color value objects on the pymol screen """

    global myverify

    violations = myverify.violations
    maingui = myverify.maingui

    if maingui.bbonly.get() == 0:
        cmd.show("lines")
    if maingui.bbonly.get() == 1:
        cmd.hide("lines")
        cmd.show("lines", "n. n+c+ca+o")


    cmd.delete("viol_*")

    try: test = violations.Lidx
    except AttributeError: return
    cmd.color(maingui.initc.get())
    for i in violations.Lidx:

        lower = maingui.colorcutoff.get() 
        deviation = violations.columns['viol'][i]
        if deviation < lower:
            continue

#           devname, atom1, atom2, upperbound, mode, zoom, width, length,
#           gap, label, quiet

#           determine the atoms to color between

        at1 = violations.columns['obj'][i]+"///"
        at2 = violations.columns['obj'][i]+"///"
        if violations.columns['type'][i] == "phi":
            at1 = "%s%d/N" % (at1, violations.columns['res'][i]);
            at2 = "%s%d/CA" % (at2, violations.columns['res'][i]);
        elif violations.columns['type'][i] == "psi":
            at1 = "%s%d/CA" % (at1, violations.columns['res'][i]);
            at2 = "%s%d/C" % (at2, violations.columns['res'][i]);
        elif violations.columns['type'][i] == "NOE":
            objects = violations.columns['res'][i].split()
            fields0 = objects[0].split('.')
            fields1 = objects[1].split('.')
            atom1 = violations.columns['hidden1'][i]
            atom2 = violations.columns['hidden2'][i]
            at1 = "%s%s/%s" % (at1, fields0[0], atom1);
            at2 = "%s%s/%s" % (at2, fields1[0], atom2);
        else:
            at1 = "%s%d/C" % (at1, violations.columns['res'][i]);
            at2 = "%s%d/N" % (at2, violations.columns['res'][i+1]);
# syntax: distance myobj, aria_10///28/c,aria_10///28/ca,-1,-1,0,5,1,0,0,0
        cmd.distance("viol_%d" % (violations.columns['name'][i]), at1, at2,
            -1, -1, 0, maingui.lwidth.get(), 1, 0, 0, 1)
        # debug
        # at1 or at2 can contain *
#        print " command = ", violations.columns['name'][i], at1, at2, -1, -1, 0, maingui.lwidth.get(), 1, 0, 0, 1

#           decide what color this will be drawn as
#        lower = maingui.cutoff.get()
        idx = 0
        color = maingui.initc.get()
        for limit in maingui.limits:
            upper = limit.get()
            if ((deviation >= lower) and (deviation <= upper)):
                color = maingui.colors[idx].get()
                break
            lower = upper
            idx = idx + 1

        cmd.color(color, "viol_%d" % (violations.columns['name'][i]))




#---------------------------------------------------------------------------
def checkRst(parent, nmrframe):
    """ this is called from the main pynmr module. """

    global myverify

    # create central object to hold all data.
    myverify = Verify(parent, nmrframe)

    maingui = myverify.maingui

    # from here on in we wait for user input and respond
    maingui.draw()
    maingui.nmrframe.update_idletasks()
    maingui.nmrframe.update()

    # read in all of the pdb files right now - while the user
    # is looking at the gui and before we do calculations

    #print "reading data... please wait."
    #pdb.readall(myverify)
    #print "done reading."

from verify_common import *
from common import *
from noe import *
from dihedral import *
