id = "fff074c3c0773879d2ccd8bed1043152668944a5"
date = "2015-09-17 17:32:00 +0000"
branch = "master"
tag = "None"
if tag == "None":
    tag = None
author = "Kipp Cannon <kipp.cannon@ligo.org>"
builder = "Kipp Cannon <kipp.cannon@ligo.org>"
committer = "Kipp Cannon <kipp.cannon@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: master
Tag: None
Id: fff074c3c0773879d2ccd8bed1043152668944a5

Builder: Kipp Cannon <kipp.cannon@ligo.org>
Build date: 2015-09-17 17:32:48 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "fff074c3c0773879d2ccd8bed1043152668944a5":
        return
    msg = "Program id (fff074c3c0773879d2ccd8bed1043152668944a5) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

