id = "359a04aa520841cc8a4d9ef28fedb8642d58abd0"
date = "2015-07-23 23:40:23 +0000"
branch = "master"
tag = "pylal-v0.8.0-v1"
if tag == "None":
    tag = None
author = "Kipp Cannon <kipp.cannon@ligo.org>"
builder = "Kipp Cannon <kipp.cannon@ligo.org>"
committer = "Kipp Cannon <kipp.cannon@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: master
Tag: pylal-v0.8.0-v1
Id: 359a04aa520841cc8a4d9ef28fedb8642d58abd0

Builder: Kipp Cannon <kipp.cannon@ligo.org>
Build date: 2015-07-23 23:41:54 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "359a04aa520841cc8a4d9ef28fedb8642d58abd0":
        return
    msg = "Program id (359a04aa520841cc8a4d9ef28fedb8642d58abd0) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

