id = "127f772a85ce01e58e3559db1487119cf4c26ec8"
date = "2014-11-19 20:10:17 +0000"
branch = "pylal-0.6.x"
tag = "pylal-v0.6.0-v1"
if tag == "None":
    tag = None
author = "Kipp Cannon <kipp.cannon@ligo.org>"
builder = "Kipp Cannon <kipp.cannon@ligo.org>"
committer = "Kipp Cannon <kipp.cannon@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: pylal-0.6.x
Tag: pylal-v0.6.0-v1
Id: 127f772a85ce01e58e3559db1487119cf4c26ec8

Builder: Kipp Cannon <kipp.cannon@ligo.org>
Build date: 2014-11-19 20:18:30 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "127f772a85ce01e58e3559db1487119cf4c26ec8":
        return
    msg = "Program id (127f772a85ce01e58e3559db1487119cf4c26ec8) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

