id = "17484cab96a2d0eb9a30d9af5f100a63216c981e"
date = "2014-01-27 16:12:56 +0000"
branch = "master"
tag = "None"
if tag == "None":
    tag = None
author = "Yuanhao Zhang <yuanhao.zhang@ligo.org>"
builder = "Kipp Cannon <kipp.cannon@ligo.org>"
committer = "Yuanhao Zhang <yuanhao.zhang@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: master
Tag: None
Id: 17484cab96a2d0eb9a30d9af5f100a63216c981e

Builder: Kipp Cannon <kipp.cannon@ligo.org>
Build date: 2014-01-27 18:12:00 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "17484cab96a2d0eb9a30d9af5f100a63216c981e":
        return
    msg = "Program id (17484cab96a2d0eb9a30d9af5f100a63216c981e) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

