id = "ab01f4b1ec69973f827154b1be58e77c546d96b8"
date = "2016-10-18 09:26:01 +0000"
branch = "master"
tag = "None"
if tag == "None":
    tag = None
author = "Kipp Cannon <kipp.cannon@ligo.org>"
builder = "Kipp Cannon <kipp.cannon@ligo.org>"
committer = "Kipp Cannon <kipp.cannon@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: master
Tag: None
Id: ab01f4b1ec69973f827154b1be58e77c546d96b8

Builder: Kipp Cannon <kipp.cannon@ligo.org>
Build date: 2016-10-18 09:26:39 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "ab01f4b1ec69973f827154b1be58e77c546d96b8":
        return
    msg = "Program id (ab01f4b1ec69973f827154b1be58e77c546d96b8) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

