# This file was created automatically by SWIG.
# Don't modify this file, modify the SWIG interface instead.
# This file is compatible with both classic and new-style classes.
import _yenc
def _swig_setattr(self,class_type,name,value):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    self.__dict__[name] = value

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


encode = _yenc.encode

decode = _yenc.decode

import sys
E_CRC32		= 3
E_PARMS		= 4
class Error(Exception):
	def __init__(self,value="",code=E_CRC32):
		self.value = value
	def __str__(self):
		return "yenc.Error: %s\n" % self.value, self.value
def check_args_type(file_in, file_out, bytes):
	if bytes < 0: raise Error("No. of bytes can't be negative", E_PARMS)
	if type(file_in) == str:
		if file_in == "-":
			if bytes == 0: raise Error("No. of bytes not specified while reading from stdin", E_PARMS)
			file_in = sys.stdin
		else: file_in = open(file_in,"rb")
	if type(file_out) == str:
		if file_out == "-": file_out = sys.stdout
		else: file_out = open(file_out,"wb")
	return file_in, file_out, bytes
def encode(file_in, file_out, bytes=0):
	file_in, file_out, bytes = check_args_type(file_in, file_out, bytes)
	encoded, crc32 = _yenc.encode(file_in, file_out, bytes)
	crc_hex = hex(crc32)[2:]
	return encoded, crc_hex
def decode(file_in, file_out, bytes=0, crc_in=""):
	file_in, file_out, bytes = check_args_type(file_in, file_out, bytes)
	decoded, crc32 = _yenc.decode(file_in, file_out, bytes)
	crc_hex = hex(crc32)[2:]
	if crc_in and not cmp(crc_hex,crc_in.lower()):
		raise Error("crc32 error", E_CRC32)
	else:
		return decoded, crc_hex



