%module yenc
%include "typemaps.i"

%{
#include "yenc.h"
%}

%typemap(in) FILE * {
	if PyFile_Check($input) {
		$1 = PyFile_AsFile($input);
	} else {
		PyErr_SetString(PyExc_TypeError,"expected a file object");
		return NULL;
	}
}

%typemap(out) unsigned long *OUTPUT {
	$result = PyTuple_New(2);
	PyTuple_SetItem($result,0,PyLong_FromUnsignedLong($1[0]));
	PyTuple_SetItem($result,1,PyInt_FromLong($1[1]));
	free($1);
}

%exception {
	char *err;
	clear_exception();
	$action;
	if((err = check_exception())){
		PyObject *errvalue;
		switch(err_code){
			case E_MODE:
				errvalue = PyExc_ValueError;
				break;
			case E_EOF:
				errvalue = PyExc_EOFError;
				break;
			case E_IO:
				errvalue = PyExc_IOError;
				break;
			default:
				errvalue = PyExc_Exception;
		}
		PyErr_SetString(errvalue,err);
		return NULL;
	}
}

%apply unsigned long *OUTPUT { unsigned long *encode };
unsigned long *encode(FILE *infile, FILE *outfile, unsigned long);
%clear unsigned long *encode;

%apply unsigned long *OUTPUT { unsigned long *decode };
unsigned long *decode(FILE *infile, FILE *outfile, unsigned long);
%clear unsigned long *encode;

%exception;

%pythoncode %{

import sys

E_CRC32		= 3
E_PARMS		= 4

class Error(Exception):
	def __init__(self,value="",code=E_CRC32):
		self.value = value

	def __str__(self):
		return "yenc.Error: %s\n" % self.value, self.value

def check_args_type(file_in, file_out, bytes):
	if bytes < 0: raise Error("No. of bytes can't be negative", E_PARMS)
	if type(file_in) == str:
		if file_in == "-":
			if bytes == 0: raise Error("No. of bytes not specified while reading from stdin", E_PARMS)
			file_in = sys.stdin
		else: file_in = open(file_in,"rb")
	if type(file_out) == str:
		if file_out == "-": file_out = sys.stdout
		else: file_out = open(file_out,"wb")
	return file_in, file_out, bytes

def encode(file_in, file_out, bytes=0):
	file_in, file_out, bytes = check_args_type(file_in, file_out, bytes)
	encoded, crc32 = _yenc.encode(file_in, file_out, bytes)
	crc_hex = hex(crc32)[2:]
	return encoded, crc_hex

def decode(file_in, file_out, bytes=0, crc_in=""):
	file_in, file_out, bytes = check_args_type(file_in, file_out, bytes)
	decoded, crc32 = _yenc.decode(file_in, file_out, bytes)
	crc_hex = hex(crc32)[2:]
	if crc_in and not cmp(crc_hex,crc_in.lower()):
		raise Error("crc32 error", E_CRC32)
	else:
		return decoded, crc_hex
%}


