---
name: Bug report
about: Tell us about decompyle3 bugs

---

<!-- __Note:__ If you are using this program to do something illegal - don't.
The issue may flagged to make it easier for those looking for illegal activity.

Bugs are not for asking questions about a problem you
are trying to solve that involve the use of xdis along the way,
although I may be more tolerent of this if you sponsor the project.

Bugs are also not for general or novice kind help on how to install
this Python program in your environment in the way you would like to
have it set up, or how to interpret a Python traceback e.g. that winds
up saying Python X.Y.Z is not supported.

For these kinds of things, you will save yourself time by asking
instead on forums like StackOverflow that are geared to helping people
for such general or novice kinds questions and tasks. And unless you
are a sponsor of the project, if your question seems to be of this
category, the issue may just be closed.

Also, the unless you are a sponsor of the project, it may take a
while, maybe a week or so, before the bug report is noticed, let alone
acted upon.

To set expectations, some legitimate bugs can take years to fix, but
they eventually do get fixed.

Funding the project was added to partially address the problem that there are
lots of people seeking help and reporting bugs, but few people who are
willing or capable of providing help or fixing bugs.

Tasks or the kinds of things others can do but you can't do or don't
want to do yourself are typically the kind of thing that you pay
someone to do, especially when you are the primary beneficiary of the
work, or the task is complex, long, or tedious. If your code is over
30 lines long, it fits into this category.


-->

## Description

<!-- Please add a clear and concise description of the bug. Try to narrow the problem down to the smallest that exhibits the bug.-->

## How to Reproduce

<!-- Please show both the *input* you gave and the
output you got in describing how to reproduce the bug:

or give a complete console log with input and output

```console
$ decompyle3 <command-line-options>
...
$
```

Provide links to the Python bytecode. For example you can create a
gist with the information. If you have the correct source code, you
can add that too.

-->

## Output Given

<!--
Please include not just the error message but all output leading to the message which includes echoing input and messages up to the error.
For a command-line environment include command invocation and all the output produced.

If this is too long, then try narrowing the problem to something short.
-->


## Expected behavior

<!-- Add a clear and concise description of what you expected to happen. -->

## Environment

<!-- _This section sometimes is optional but helpful to us._

Please modify for your setup

- Decompyle3 version: output from  `decompyle3 --version` or `pip show decompyle3`
- Python version for the version of Python the byte-compiled the file: `python -c "import sys; print(sys.version)"` where `python` is the correct CPython or PyPy binary.
- OS and Version: [e.g. Ubuntu bionic]

-->

## Workarounds

<!-- If there is a workaround for the problem, describe that here. -->

## Priority

<!-- If this is important for a particular public good state that here.
     If this is blocking some important activity let us know what activity it blocks.

	 Otherwise, we'll assume this has the lowest priority in addressing.
	 -->

## Additional Context

<!-- _This section is optional._

Add any other context about the problem here or special environment setup.

-->
