/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxTextBoxAttr_Init, "Init()\n"
"\n"
"Initialises this object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_Init(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_Init(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Init();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_Init, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_Reset, "Reset()\n"
"\n"
"Resets this object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_Reset(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_Reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_Reset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_EqPartial, "EqPartial(attr, weakTest=True) -> bool\n"
"\n"
"Partial equality test, ignoring unset attributes.");

extern "C" {static PyObject *meth_wxTextBoxAttr_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr* attr;
        bool weakTest = 1;
        const  ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|b", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &attr, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*attr,weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_EqPartial, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_Apply, "Apply(style, compareWith=None) -> bool\n"
"\n"
"Merges the given attributes.");

extern "C" {static PyObject *meth_wxTextBoxAttr_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr* style;
        const  ::wxTextBoxAttr* compareWith = 0;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &style, sipType_wxTextBoxAttr, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*style,compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_Apply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr)\n"
"\n"
"Collects the attributes that are common to a range of content,\n"
"building up a note of which attributes are absent in some objects and\n"
"which clash in some objects.");

extern "C" {static PyObject *meth_wxTextBoxAttr_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr* attr;
         ::wxTextBoxAttr* clashingAttr;
         ::wxTextBoxAttr* absentAttr;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &attr, sipType_wxTextBoxAttr, &clashingAttr, sipType_wxTextBoxAttr, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr,*clashingAttr,*absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_CollectCommonAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_RemoveStyle, "RemoveStyle(attr) -> bool\n"
"\n"
"Removes the specified attributes from this object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_RemoveStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_RemoveStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr* attr;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveStyle(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_RemoveStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets the flags.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns the flags.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasFlag, "HasFlag(flag) -> bool\n"
"\n"
"Is this flag present?");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrFlags flag;
        const  ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFlags, &flag))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_RemoveFlag, "RemoveFlag(flag)\n"
"\n"
"Removes this flag.");

extern "C" {static PyObject *meth_wxTextBoxAttr_RemoveFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_RemoveFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrFlags flag;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFlags, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_RemoveFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_AddFlag, "AddFlag(flag)\n"
"\n"
"Adds this flag.");

extern "C" {static PyObject *meth_wxTextBoxAttr_AddFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_AddFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrFlags flag;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFlags, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_AddFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_IsDefault, "IsDefault() -> bool\n"
"\n"
"Returns true if no attributes are set.");

extern "C" {static PyObject *meth_wxTextBoxAttr_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_IsDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetFloatMode, "GetFloatMode() -> TextBoxAttrFloatStyle\n"
"\n"
"Returns the float mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetFloatMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetFloatMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrFloatStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFloatMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrFloatStyle);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetFloatMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetFloatMode, "SetFloatMode(mode)\n"
"\n"
"Sets the float mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetFloatMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetFloatMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrFloatStyle mode;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFloatStyle, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFloatMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetFloatMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasFloatMode, "HasFloatMode() -> bool\n"
"\n"
"Returns true if float mode is active.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasFloatMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasFloatMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFloatMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasFloatMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_IsFloating, "IsFloating() -> bool\n"
"\n"
"Returns true if this object is floating.");

extern "C" {static PyObject *meth_wxTextBoxAttr_IsFloating(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_IsFloating(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFloating();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_IsFloating, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetClearMode, "GetClearMode() -> TextBoxAttrClearStyle\n"
"\n"
"Returns the clear mode - whether to wrap text after object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetClearMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetClearMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrClearStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClearMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrClearStyle);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetClearMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetClearMode, "SetClearMode(mode)\n"
"\n"
"Set the clear mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetClearMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetClearMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrClearStyle mode;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrClearStyle, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClearMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetClearMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasClearMode, "HasClearMode() -> bool\n"
"\n"
"Returns true if we have a clear flag.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasClearMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasClearMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasClearMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasClearMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetCollapseBorders, "GetCollapseBorders() -> TextBoxAttrCollapseMode\n"
"\n"
"Returns the collapse mode - whether to collapse borders.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetCollapseBorders(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetCollapseBorders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrCollapseMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCollapseBorders();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrCollapseMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetCollapseBorders, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetCollapseBorders, "SetCollapseBorders(collapse)\n"
"\n"
"Sets the collapse mode - whether to collapse borders.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetCollapseBorders(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetCollapseBorders(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrCollapseMode collapse;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_collapse,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrCollapseMode, &collapse))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCollapseBorders(collapse);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetCollapseBorders, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasCollapseBorders, "HasCollapseBorders() -> bool\n"
"\n"
"Returns true if the collapse borders flag is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasCollapseBorders(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasCollapseBorders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCollapseBorders();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasCollapseBorders, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetWhitespaceMode, "GetWhitespaceMode() -> TextBoxAttrWhitespaceMode\n"
"\n"
"Returns the whitespace mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetWhitespaceMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetWhitespaceMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrWhitespaceMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWhitespaceMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrWhitespaceMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetWhitespaceMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetWhitespaceMode, "SetWhitespaceMode(whitespace)\n"
"\n"
"Sets the whitespace mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetWhitespaceMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetWhitespaceMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrWhitespaceMode whitespace;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_whitespace,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrWhitespaceMode, &whitespace))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWhitespaceMode(whitespace);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetWhitespaceMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasWhitespaceMode, "HasWhitespaceMode() -> bool\n"
"\n"
"Returns true if the whitespace flag is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasWhitespaceMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasWhitespaceMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasWhitespaceMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasWhitespaceMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasCornerRadius, "HasCornerRadius() -> bool\n"
"\n"
"Returns true if the corner radius flag is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasCornerRadius(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasCornerRadius(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCornerRadius();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasCornerRadius, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetCornerRadius, "GetCornerRadius() -> TextAttrDimension");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetCornerRadius(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetCornerRadius(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetCornerRadius();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetCornerRadius, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetCornerRadius, "SetCornerRadius(dim)\n"
"\n"
"Sets the corner radius value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetCornerRadius(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetCornerRadius(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* dim;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrDimension, &dim))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCornerRadius(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetCornerRadius, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetVerticalAlignment, "GetVerticalAlignment() -> TextBoxAttrVerticalAlignment\n"
"\n"
"Returns the vertical alignment.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetVerticalAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetVerticalAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrVerticalAlignment sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVerticalAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrVerticalAlignment);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetVerticalAlignment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetVerticalAlignment, "SetVerticalAlignment(verticalAlignment)\n"
"\n"
"Sets the vertical alignment.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetVerticalAlignment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetVerticalAlignment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttrVerticalAlignment verticalAlignment;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_verticalAlignment,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrVerticalAlignment, &verticalAlignment))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetVerticalAlignment(verticalAlignment);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetVerticalAlignment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasVerticalAlignment, "HasVerticalAlignment() -> bool\n"
"\n"
"Returns true if a vertical alignment flag is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasVerticalAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasVerticalAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasVerticalAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasVerticalAlignment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetMargins, "GetMargins() -> TextAttrDimensions\n"
"\n"
"Returns the margin values.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetMargins(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetMargins(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimensions*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetMargins();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimensions,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftMargin, "GetLeftMargin() -> TextAttrDimension\n"
"\n"
"Returns the left margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftMargin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightMargin, "GetRightMargin() -> TextAttrDimension\n"
"\n"
"Returns the right margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightMargin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopMargin, "GetTopMargin() -> TextAttrDimension\n"
"\n"
"Returns the top margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopMargin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomMargin, "GetBottomMargin() -> TextAttrDimension\n"
"\n"
"Returns the bottom margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomMargin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetPosition, "GetPosition() -> TextAttrDimensions\n"
"\n"
"Returns the position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimensions*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimensions,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeft, "GetLeft() -> TextAttrDimension\n"
"\n"
"Returns the left position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeft(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeft();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeft, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRight, "GetRight() -> TextAttrDimension\n"
"\n"
"Returns the right position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRight(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTop, "GetTop() -> TextAttrDimension\n"
"\n"
"Returns the top position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTop(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTop();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTop, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottom, "GetBottom() -> TextAttrDimension\n"
"\n"
"Returns the bottom position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottom(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottom();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetPadding, "GetPadding() -> TextAttrDimensions\n"
"\n"
"Returns the padding values.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimensions*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimensions,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetPadding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftPadding, "GetLeftPadding() -> TextAttrDimension\n"
"\n"
"Returns the left padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftPadding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightPadding, "GetRightPadding() -> TextAttrDimension\n"
"\n"
"Returns the right padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightPadding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopPadding, "GetTopPadding() -> TextAttrDimension\n"
"\n"
"Returns the top padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopPadding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomPadding, "GetBottomPadding() -> TextAttrDimension\n"
"\n"
"Returns the bottom padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomPadding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBorder, "GetBorder() -> TextAttrBorders\n"
"\n"
"Returns the borders.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorders*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorders,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftBorder, "GetLeftBorder() -> TextAttrBorder\n"
"\n"
"Returns the left border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopBorder, "GetTopBorder() -> TextAttrBorder\n"
"\n"
"Returns the top border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightBorder, "GetRightBorder() -> TextAttrBorder\n"
"\n"
"Returns the right border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomBorder, "GetBottomBorder() -> TextAttrBorder\n"
"\n"
"Returns the bottom border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetOutline, "GetOutline() -> TextAttrBorders\n"
"\n"
"Returns the outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorders*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorders,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetOutline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftOutline, "GetLeftOutline() -> TextAttrBorder\n"
"\n"
"Returns the left outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftOutline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopOutline, "GetTopOutline() -> TextAttrBorder\n"
"\n"
"Returns the top outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopOutline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightOutline, "GetRightOutline() -> TextAttrBorder\n"
"\n"
"Returns the right outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightOutline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomOutline, "GetBottomOutline() -> TextAttrBorder\n"
"\n"
"Returns the bottom outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomOutline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetSize, "GetSize() -> TextAttrSize\n"
"\n"
"Returns the object size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetMinSize, "GetMinSize() -> TextAttrSize\n"
"\n"
"Returns the object minimum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetMinSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetMinSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetMinSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetMinSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetMaxSize, "GetMaxSize() -> TextAttrSize\n"
"\n"
"Returns the object maximum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetMaxSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetMaxSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetMaxSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetMaxSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetSize, "SetSize(sz)\n"
"\n"
"Sets the object size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrSize* sz;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrSize, &sz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSize(*sz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetMinSize, "SetMinSize(sz)\n"
"\n"
"Sets the object minimum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetMinSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetMinSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrSize* sz;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrSize, &sz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMinSize(*sz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetMinSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetMaxSize, "SetMaxSize(sz)\n"
"\n"
"Sets the object maximum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetMaxSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetMaxSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrSize* sz;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrSize, &sz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMaxSize(*sz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetMaxSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetWidth, "GetWidth() -> TextAttrDimension\n"
"\n"
"Returns the object width.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetHeight, "GetHeight() -> TextAttrDimension\n"
"\n"
"Returns the object height.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBoxStyleName, "GetBoxStyleName() -> String\n"
"\n"
"Returns the box style name.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBoxStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBoxStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBoxStyleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBoxStyleName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetBoxStyleName, "SetBoxStyleName(name)\n"
"\n"
"Sets the box style name.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetBoxStyleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetBoxStyleName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxString, &name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBoxStyleName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetBoxStyleName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasBoxStyleName, "HasBoxStyleName() -> bool\n"
"\n"
"Returns true if the box style name is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasBoxStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasBoxStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBoxStyleName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasBoxStyleName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetShadow, "GetShadow() -> TextAttrShadow\n"
"\n"
"Returns the box shadow attributes.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetShadow(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetShadow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrShadow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetShadow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrShadow,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetShadow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxTextBoxAttr___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxTextBoxAttr___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextBoxAttr));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr* attr;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextBoxAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp-> ::wxTextBoxAttr::operator==(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxTextBoxAttr, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTextBoxAttr___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxTextBoxAttr___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextBoxAttr));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextBoxAttr* attr;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextBoxAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTextBoxAttr::operator==(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxTextBoxAttr, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextBoxAttr(void *, int);}
static void release_wxTextBoxAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextBoxAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxTextBoxAttr(Py_ssize_t);}
static void *array_wxTextBoxAttr(Py_ssize_t sipNrElem)
{
    return new  ::wxTextBoxAttr[sipNrElem];
}


extern "C" {static void assign_wxTextBoxAttr(void *, Py_ssize_t, void *);}
static void assign_wxTextBoxAttr(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextBoxAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextBoxAttr *>(sipSrc);
}


extern "C" {static void *copy_wxTextBoxAttr(const void *, Py_ssize_t);}
static void *copy_wxTextBoxAttr(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxTextBoxAttr(reinterpret_cast<const  ::wxTextBoxAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextBoxAttr(sipSimpleWrapper *);}
static void dealloc_wxTextBoxAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextBoxAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextBoxAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextBoxAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTextBoxAttr *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextBoxAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTextBoxAttr* attr;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxTextBoxAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextBoxAttr(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTextBoxAttr[] = {
    {(void *)slot_wxTextBoxAttr___ne__, ne_slot},
    {(void *)slot_wxTextBoxAttr___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTextBoxAttr[] = {
    {sipName_AddFlag, SIP_MLMETH_CAST(meth_wxTextBoxAttr_AddFlag), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_AddFlag},
    {sipName_Apply, SIP_MLMETH_CAST(meth_wxTextBoxAttr_Apply), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_Apply},
    {sipName_CollectCommonAttributes, SIP_MLMETH_CAST(meth_wxTextBoxAttr_CollectCommonAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_CollectCommonAttributes},
    {sipName_EqPartial, SIP_MLMETH_CAST(meth_wxTextBoxAttr_EqPartial), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_EqPartial},
    {sipName_GetBorder, meth_wxTextBoxAttr_GetBorder, METH_VARARGS, doc_wxTextBoxAttr_GetBorder},
    {sipName_GetBottom, meth_wxTextBoxAttr_GetBottom, METH_VARARGS, doc_wxTextBoxAttr_GetBottom},
    {sipName_GetBottomBorder, meth_wxTextBoxAttr_GetBottomBorder, METH_VARARGS, doc_wxTextBoxAttr_GetBottomBorder},
    {sipName_GetBottomMargin, meth_wxTextBoxAttr_GetBottomMargin, METH_VARARGS, doc_wxTextBoxAttr_GetBottomMargin},
    {sipName_GetBottomOutline, meth_wxTextBoxAttr_GetBottomOutline, METH_VARARGS, doc_wxTextBoxAttr_GetBottomOutline},
    {sipName_GetBottomPadding, meth_wxTextBoxAttr_GetBottomPadding, METH_VARARGS, doc_wxTextBoxAttr_GetBottomPadding},
    {sipName_GetBoxStyleName, meth_wxTextBoxAttr_GetBoxStyleName, METH_VARARGS, doc_wxTextBoxAttr_GetBoxStyleName},
    {sipName_GetClearMode, meth_wxTextBoxAttr_GetClearMode, METH_VARARGS, doc_wxTextBoxAttr_GetClearMode},
    {sipName_GetCollapseBorders, meth_wxTextBoxAttr_GetCollapseBorders, METH_VARARGS, doc_wxTextBoxAttr_GetCollapseBorders},
    {sipName_GetCornerRadius, meth_wxTextBoxAttr_GetCornerRadius, METH_VARARGS, doc_wxTextBoxAttr_GetCornerRadius},
    {sipName_GetFlags, meth_wxTextBoxAttr_GetFlags, METH_VARARGS, doc_wxTextBoxAttr_GetFlags},
    {sipName_GetFloatMode, meth_wxTextBoxAttr_GetFloatMode, METH_VARARGS, doc_wxTextBoxAttr_GetFloatMode},
    {sipName_GetHeight, meth_wxTextBoxAttr_GetHeight, METH_VARARGS, doc_wxTextBoxAttr_GetHeight},
    {sipName_GetLeft, meth_wxTextBoxAttr_GetLeft, METH_VARARGS, doc_wxTextBoxAttr_GetLeft},
    {sipName_GetLeftBorder, meth_wxTextBoxAttr_GetLeftBorder, METH_VARARGS, doc_wxTextBoxAttr_GetLeftBorder},
    {sipName_GetLeftMargin, meth_wxTextBoxAttr_GetLeftMargin, METH_VARARGS, doc_wxTextBoxAttr_GetLeftMargin},
    {sipName_GetLeftOutline, meth_wxTextBoxAttr_GetLeftOutline, METH_VARARGS, doc_wxTextBoxAttr_GetLeftOutline},
    {sipName_GetLeftPadding, meth_wxTextBoxAttr_GetLeftPadding, METH_VARARGS, doc_wxTextBoxAttr_GetLeftPadding},
    {sipName_GetMargins, meth_wxTextBoxAttr_GetMargins, METH_VARARGS, doc_wxTextBoxAttr_GetMargins},
    {sipName_GetMaxSize, meth_wxTextBoxAttr_GetMaxSize, METH_VARARGS, doc_wxTextBoxAttr_GetMaxSize},
    {sipName_GetMinSize, meth_wxTextBoxAttr_GetMinSize, METH_VARARGS, doc_wxTextBoxAttr_GetMinSize},
    {sipName_GetOutline, meth_wxTextBoxAttr_GetOutline, METH_VARARGS, doc_wxTextBoxAttr_GetOutline},
    {sipName_GetPadding, meth_wxTextBoxAttr_GetPadding, METH_VARARGS, doc_wxTextBoxAttr_GetPadding},
    {sipName_GetPosition, meth_wxTextBoxAttr_GetPosition, METH_VARARGS, doc_wxTextBoxAttr_GetPosition},
    {sipName_GetRight, meth_wxTextBoxAttr_GetRight, METH_VARARGS, doc_wxTextBoxAttr_GetRight},
    {sipName_GetRightBorder, meth_wxTextBoxAttr_GetRightBorder, METH_VARARGS, doc_wxTextBoxAttr_GetRightBorder},
    {sipName_GetRightMargin, meth_wxTextBoxAttr_GetRightMargin, METH_VARARGS, doc_wxTextBoxAttr_GetRightMargin},
    {sipName_GetRightOutline, meth_wxTextBoxAttr_GetRightOutline, METH_VARARGS, doc_wxTextBoxAttr_GetRightOutline},
    {sipName_GetRightPadding, meth_wxTextBoxAttr_GetRightPadding, METH_VARARGS, doc_wxTextBoxAttr_GetRightPadding},
    {sipName_GetShadow, meth_wxTextBoxAttr_GetShadow, METH_VARARGS, doc_wxTextBoxAttr_GetShadow},
    {sipName_GetSize, meth_wxTextBoxAttr_GetSize, METH_VARARGS, doc_wxTextBoxAttr_GetSize},
    {sipName_GetTop, meth_wxTextBoxAttr_GetTop, METH_VARARGS, doc_wxTextBoxAttr_GetTop},
    {sipName_GetTopBorder, meth_wxTextBoxAttr_GetTopBorder, METH_VARARGS, doc_wxTextBoxAttr_GetTopBorder},
    {sipName_GetTopMargin, meth_wxTextBoxAttr_GetTopMargin, METH_VARARGS, doc_wxTextBoxAttr_GetTopMargin},
    {sipName_GetTopOutline, meth_wxTextBoxAttr_GetTopOutline, METH_VARARGS, doc_wxTextBoxAttr_GetTopOutline},
    {sipName_GetTopPadding, meth_wxTextBoxAttr_GetTopPadding, METH_VARARGS, doc_wxTextBoxAttr_GetTopPadding},
    {sipName_GetVerticalAlignment, meth_wxTextBoxAttr_GetVerticalAlignment, METH_VARARGS, doc_wxTextBoxAttr_GetVerticalAlignment},
    {sipName_GetWhitespaceMode, meth_wxTextBoxAttr_GetWhitespaceMode, METH_VARARGS, doc_wxTextBoxAttr_GetWhitespaceMode},
    {sipName_GetWidth, meth_wxTextBoxAttr_GetWidth, METH_VARARGS, doc_wxTextBoxAttr_GetWidth},
    {sipName_HasBoxStyleName, meth_wxTextBoxAttr_HasBoxStyleName, METH_VARARGS, doc_wxTextBoxAttr_HasBoxStyleName},
    {sipName_HasClearMode, meth_wxTextBoxAttr_HasClearMode, METH_VARARGS, doc_wxTextBoxAttr_HasClearMode},
    {sipName_HasCollapseBorders, meth_wxTextBoxAttr_HasCollapseBorders, METH_VARARGS, doc_wxTextBoxAttr_HasCollapseBorders},
    {sipName_HasCornerRadius, meth_wxTextBoxAttr_HasCornerRadius, METH_VARARGS, doc_wxTextBoxAttr_HasCornerRadius},
    {sipName_HasFlag, SIP_MLMETH_CAST(meth_wxTextBoxAttr_HasFlag), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_HasFlag},
    {sipName_HasFloatMode, meth_wxTextBoxAttr_HasFloatMode, METH_VARARGS, doc_wxTextBoxAttr_HasFloatMode},
    {sipName_HasVerticalAlignment, meth_wxTextBoxAttr_HasVerticalAlignment, METH_VARARGS, doc_wxTextBoxAttr_HasVerticalAlignment},
    {sipName_HasWhitespaceMode, meth_wxTextBoxAttr_HasWhitespaceMode, METH_VARARGS, doc_wxTextBoxAttr_HasWhitespaceMode},
    {sipName_Init, meth_wxTextBoxAttr_Init, METH_VARARGS, doc_wxTextBoxAttr_Init},
    {sipName_IsDefault, meth_wxTextBoxAttr_IsDefault, METH_VARARGS, doc_wxTextBoxAttr_IsDefault},
    {sipName_IsFloating, meth_wxTextBoxAttr_IsFloating, METH_VARARGS, doc_wxTextBoxAttr_IsFloating},
    {sipName_RemoveFlag, SIP_MLMETH_CAST(meth_wxTextBoxAttr_RemoveFlag), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_RemoveFlag},
    {sipName_RemoveStyle, SIP_MLMETH_CAST(meth_wxTextBoxAttr_RemoveStyle), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_RemoveStyle},
    {sipName_Reset, meth_wxTextBoxAttr_Reset, METH_VARARGS, doc_wxTextBoxAttr_Reset},
    {sipName_SetBoxStyleName, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetBoxStyleName), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetBoxStyleName},
    {sipName_SetClearMode, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetClearMode), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetClearMode},
    {sipName_SetCollapseBorders, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetCollapseBorders), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetCollapseBorders},
    {sipName_SetCornerRadius, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetCornerRadius), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetCornerRadius},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetFlags},
    {sipName_SetFloatMode, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetFloatMode), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetFloatMode},
    {sipName_SetMaxSize, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetMaxSize), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetMaxSize},
    {sipName_SetMinSize, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetMinSize), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetMinSize},
    {sipName_SetSize, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetSize), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetSize},
    {sipName_SetVerticalAlignment, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetVerticalAlignment), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetVerticalAlignment},
    {sipName_SetWhitespaceMode, SIP_MLMETH_CAST(meth_wxTextBoxAttr_SetWhitespaceMode), METH_VARARGS|METH_KEYWORDS, doc_wxTextBoxAttr_SetWhitespaceMode}
};


extern "C" {static PyObject *varget_wxTextBoxAttr_m_border(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_border(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -8);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_border;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrBorders, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -7, sipPySelf);
        sipKeepReference(sipPySelf, -8, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_border(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_border(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrBorders *>(sipForceConvertToType(sipPy, sipType_wxTextAttrBorders, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_border = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_boxStyleName(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_boxStyleName(void *sipSelf, PyObject *, PyObject *)
{
     ::wxString*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_boxStyleName;

    return sipConvertFromType(sipVal, sipType_wxString, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextBoxAttr_m_boxStyleName(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_boxStyleName(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxString*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast< ::wxString *>(sipForceConvertToType(sipPy, sipType_wxString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_boxStyleName = *sipVal;

    sipReleaseType(sipVal, sipType_wxString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_clearMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_clearMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrClearStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_clearMode;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_wxTextBoxAttrClearStyle);
}


extern "C" {static int varset_wxTextBoxAttr_m_clearMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_clearMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrClearStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrClearStyle)sipConvertToEnum(sipPy, sipType_wxTextBoxAttrClearStyle);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_clearMode = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_collapseMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_collapseMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrCollapseMode sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_collapseMode;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_wxTextBoxAttrCollapseMode);
}


extern "C" {static int varset_wxTextBoxAttr_m_collapseMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_collapseMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrCollapseMode sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrCollapseMode)sipConvertToEnum(sipPy, sipType_wxTextBoxAttrCollapseMode);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_collapseMode = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_cornerRadius(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_cornerRadius(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrDimension*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -10);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_cornerRadius;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -9, sipPySelf);
        sipKeepReference(sipPySelf, -10, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_cornerRadius(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_cornerRadius(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_cornerRadius = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_flags(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_flags(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_flags;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextBoxAttr_m_flags(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_flags(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_flags = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_floatMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_floatMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrFloatStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_floatMode;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_wxTextBoxAttrFloatStyle);
}


extern "C" {static int varset_wxTextBoxAttr_m_floatMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_floatMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrFloatStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrFloatStyle)sipConvertToEnum(sipPy, sipType_wxTextBoxAttrFloatStyle);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_floatMode = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_margins(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_margins(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -12);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_margins;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrDimensions, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -11, sipPySelf);
        sipKeepReference(sipPySelf, -12, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_margins(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_margins(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrDimensions *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimensions, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_margins = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_maxSize(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_maxSize(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -14);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_maxSize;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -13, sipPySelf);
        sipKeepReference(sipPySelf, -14, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_maxSize(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_maxSize(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrSize *>(sipForceConvertToType(sipPy, sipType_wxTextAttrSize, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_maxSize = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_minSize(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_minSize(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -16);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_minSize;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -15, sipPySelf);
        sipKeepReference(sipPySelf, -16, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_minSize(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_minSize(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrSize *>(sipForceConvertToType(sipPy, sipType_wxTextAttrSize, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_minSize = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_outline(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_outline(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -18);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_outline;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrBorders, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -17, sipPySelf);
        sipKeepReference(sipPySelf, -18, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_outline(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_outline(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrBorders *>(sipForceConvertToType(sipPy, sipType_wxTextAttrBorders, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_outline = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_padding(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_padding(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -20);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_padding;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrDimensions, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -19, sipPySelf);
        sipKeepReference(sipPySelf, -20, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_padding(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_padding(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrDimensions *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimensions, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_padding = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_position(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_position(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -22);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_position;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrDimensions, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -21, sipPySelf);
        sipKeepReference(sipPySelf, -22, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_position(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_position(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrDimensions *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimensions, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_position = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_shadow(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_shadow(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrShadow*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -24);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_shadow;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrShadow, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -23, sipPySelf);
        sipKeepReference(sipPySelf, -24, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_shadow(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_shadow(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrShadow*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrShadow *>(sipForceConvertToType(sipPy, sipType_wxTextAttrShadow, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_shadow = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_size(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_size(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -26);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_size;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -25, sipPySelf);
        sipKeepReference(sipPySelf, -26, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextBoxAttr_m_size(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_size(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrSize *>(sipForceConvertToType(sipPy, sipType_wxTextAttrSize, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_size = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_verticalAlignment(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_verticalAlignment(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrVerticalAlignment sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_verticalAlignment;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_wxTextBoxAttrVerticalAlignment);
}


extern "C" {static int varset_wxTextBoxAttr_m_verticalAlignment(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_verticalAlignment(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrVerticalAlignment sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrVerticalAlignment)sipConvertToEnum(sipPy, sipType_wxTextBoxAttrVerticalAlignment);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_verticalAlignment = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_whitespaceMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_whitespaceMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrWhitespaceMode sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_whitespaceMode;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_wxTextBoxAttrWhitespaceMode);
}


extern "C" {static int varset_wxTextBoxAttr_m_whitespaceMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_whitespaceMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrWhitespaceMode sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrWhitespaceMode)sipConvertToEnum(sipPy, sipType_wxTextBoxAttrWhitespaceMode);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_whitespaceMode = sipVal;

    return 0;
}

sipVariableDef variables_wxTextBoxAttr[] = {
    {PropertyVariable, sipName_Width, &methods_wxTextBoxAttr[42], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_WhitespaceMode, &methods_wxTextBoxAttr[41], &methods_wxTextBoxAttr[67], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VerticalAlignment, &methods_wxTextBoxAttr[40], &methods_wxTextBoxAttr[66], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TopPadding, &methods_wxTextBoxAttr[39], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TopOutline, &methods_wxTextBoxAttr[38], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TopMargin, &methods_wxTextBoxAttr[37], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TopBorder, &methods_wxTextBoxAttr[36], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Top, &methods_wxTextBoxAttr[35], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Size, &methods_wxTextBoxAttr[34], &methods_wxTextBoxAttr[65], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Shadow, &methods_wxTextBoxAttr[33], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RightPadding, &methods_wxTextBoxAttr[32], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RightOutline, &methods_wxTextBoxAttr[31], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RightMargin, &methods_wxTextBoxAttr[30], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RightBorder, &methods_wxTextBoxAttr[29], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Right, &methods_wxTextBoxAttr[28], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Position, &methods_wxTextBoxAttr[27], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Padding, &methods_wxTextBoxAttr[26], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Outline, &methods_wxTextBoxAttr[25], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MinSize, &methods_wxTextBoxAttr[24], &methods_wxTextBoxAttr[64], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MaxSize, &methods_wxTextBoxAttr[23], &methods_wxTextBoxAttr[63], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Margins, &methods_wxTextBoxAttr[22], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LeftPadding, &methods_wxTextBoxAttr[21], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LeftOutline, &methods_wxTextBoxAttr[20], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LeftMargin, &methods_wxTextBoxAttr[19], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LeftBorder, &methods_wxTextBoxAttr[18], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Left, &methods_wxTextBoxAttr[17], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Height, &methods_wxTextBoxAttr[16], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FloatMode, &methods_wxTextBoxAttr[15], &methods_wxTextBoxAttr[62], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxTextBoxAttr[14], &methods_wxTextBoxAttr[61], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CornerRadius, &methods_wxTextBoxAttr[13], &methods_wxTextBoxAttr[60], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CollapseBorders, &methods_wxTextBoxAttr[12], &methods_wxTextBoxAttr[59], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ClearMode, &methods_wxTextBoxAttr[11], &methods_wxTextBoxAttr[58], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BoxStyleName, &methods_wxTextBoxAttr[10], &methods_wxTextBoxAttr[57], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BottomPadding, &methods_wxTextBoxAttr[9], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BottomOutline, &methods_wxTextBoxAttr[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BottomMargin, &methods_wxTextBoxAttr[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BottomBorder, &methods_wxTextBoxAttr[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Bottom, &methods_wxTextBoxAttr[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Border, &methods_wxTextBoxAttr[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_border, (PyMethodDef *)varget_wxTextBoxAttr_m_border, (PyMethodDef *)varset_wxTextBoxAttr_m_border, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_boxStyleName, (PyMethodDef *)varget_wxTextBoxAttr_m_boxStyleName, (PyMethodDef *)varset_wxTextBoxAttr_m_boxStyleName, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_clearMode, (PyMethodDef *)varget_wxTextBoxAttr_m_clearMode, (PyMethodDef *)varset_wxTextBoxAttr_m_clearMode, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_collapseMode, (PyMethodDef *)varget_wxTextBoxAttr_m_collapseMode, (PyMethodDef *)varset_wxTextBoxAttr_m_collapseMode, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_cornerRadius, (PyMethodDef *)varget_wxTextBoxAttr_m_cornerRadius, (PyMethodDef *)varset_wxTextBoxAttr_m_cornerRadius, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_flags, (PyMethodDef *)varget_wxTextBoxAttr_m_flags, (PyMethodDef *)varset_wxTextBoxAttr_m_flags, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_floatMode, (PyMethodDef *)varget_wxTextBoxAttr_m_floatMode, (PyMethodDef *)varset_wxTextBoxAttr_m_floatMode, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_margins, (PyMethodDef *)varget_wxTextBoxAttr_m_margins, (PyMethodDef *)varset_wxTextBoxAttr_m_margins, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_maxSize, (PyMethodDef *)varget_wxTextBoxAttr_m_maxSize, (PyMethodDef *)varset_wxTextBoxAttr_m_maxSize, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_minSize, (PyMethodDef *)varget_wxTextBoxAttr_m_minSize, (PyMethodDef *)varset_wxTextBoxAttr_m_minSize, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_outline, (PyMethodDef *)varget_wxTextBoxAttr_m_outline, (PyMethodDef *)varset_wxTextBoxAttr_m_outline, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_padding, (PyMethodDef *)varget_wxTextBoxAttr_m_padding, (PyMethodDef *)varset_wxTextBoxAttr_m_padding, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_position, (PyMethodDef *)varget_wxTextBoxAttr_m_position, (PyMethodDef *)varset_wxTextBoxAttr_m_position, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_shadow, (PyMethodDef *)varget_wxTextBoxAttr_m_shadow, (PyMethodDef *)varset_wxTextBoxAttr_m_shadow, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_size, (PyMethodDef *)varget_wxTextBoxAttr_m_size, (PyMethodDef *)varset_wxTextBoxAttr_m_size, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_verticalAlignment, (PyMethodDef *)varget_wxTextBoxAttr_m_verticalAlignment, (PyMethodDef *)varset_wxTextBoxAttr_m_verticalAlignment, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_whitespaceMode, (PyMethodDef *)varget_wxTextBoxAttr_m_whitespaceMode, (PyMethodDef *)varset_wxTextBoxAttr_m_whitespaceMode, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxTextBoxAttr, "TextBoxAttr()\n"
"TextBoxAttr(attr)\n"
"\n"
"A class representing the box attributes of a rich text object.");


sipClassTypeDef sipTypeDef__richtext_wxTextBoxAttr = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextBoxAttr,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_TextBoxAttr,
        {0, 0, 1},
        68, methods_wxTextBoxAttr,
        0, SIP_NULLPTR,
        56, variables_wxTextBoxAttr,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTextBoxAttr,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxTextBoxAttr,
    init_type_wxTextBoxAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTextBoxAttr,
    assign_wxTextBoxAttr,
    array_wxTextBoxAttr,
    copy_wxTextBoxAttr,
    release_wxTextBoxAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
