/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/colour.h>
    int _wxTextAttrBorder___nonzero__(wxTextAttrBorder* self)
    {
        return self->IsValid();
    }
    int _wxTextAttrBorder___bool__(wxTextAttrBorder* self)
    {
        return self->IsValid();
    }


PyDoc_STRVAR(doc_wxTextAttrBorder_Reset, "Reset()\n"
"\n"
"Resets the border style, colour, width and flags.");

extern "C" {static PyObject *meth_wxTextAttrBorder_Reset(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_Reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_Reset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_EqPartial, "EqPartial(border, weakTest=True) -> bool\n"
"\n"
"Partial equality test.");

extern "C" {static PyObject *meth_wxTextAttrBorder_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder* border;
        bool weakTest = 1;
        const  ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_border,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|b", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, sipType_wxTextAttrBorder, &border, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*border,weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_EqPartial, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_Apply, "Apply(border, compareWith=None) -> bool\n"
"\n"
"Applies the border to this object, but not if the same as compareWith.");

extern "C" {static PyObject *meth_wxTextAttrBorder_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder* border;
        const  ::wxTextAttrBorder* compareWith = 0;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_border,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, sipType_wxTextAttrBorder, &border, sipType_wxTextAttrBorder, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*border,compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_Apply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_RemoveStyle, "RemoveStyle(attr) -> bool\n"
"\n"
"Removes the specified attributes from this object.");

extern "C" {static PyObject *meth_wxTextAttrBorder_RemoveStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_RemoveStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder* attr;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, sipType_wxTextAttrBorder, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveStyle(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_RemoveStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr)\n"
"\n"
"Collects the attributes that are common to a range of content,\n"
"building up a note of which attributes are absent in some objects and\n"
"which clash in some objects.");

extern "C" {static PyObject *meth_wxTextAttrBorder_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder* attr;
         ::wxTextAttrBorder* clashingAttr;
         ::wxTextAttrBorder* absentAttr;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, sipType_wxTextAttrBorder, &attr, sipType_wxTextAttrBorder, &clashingAttr, sipType_wxTextAttrBorder, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr,*clashingAttr,*absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_CollectCommonAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_SetStyle, "SetStyle(style)\n"
"\n"
"Sets the border style.");

extern "C" {static PyObject *meth_wxTextAttrBorder_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int style;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_SetStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_GetStyle, "GetStyle() -> int\n"
"\n"
"Gets the border style.");

extern "C" {static PyObject *meth_wxTextAttrBorder_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_GetStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_SetColour, "SetColour(colour)\n"
"SetColour(colour)\n"
"\n"
"Sets the border colour.\n"
"");

extern "C" {static PyObject *meth_wxTextAttrBorder_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned long colour;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bm", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, &colour))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(colour);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_GetColourLong, "GetColourLong() -> unsignedlong\n"
"\n"
"Gets the colour as a long.");

extern "C" {static PyObject *meth_wxTextAttrBorder_GetColourLong(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_GetColourLong(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            unsigned long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColourLong();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_GetColourLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_GetColour, "GetColour() -> wx.Colour\n"
"\n"
"Gets the colour.");

extern "C" {static PyObject *meth_wxTextAttrBorder_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_GetWidth, "GetWidth() -> TextAttrDimension\n"
"\n"
"Gets the border width.");

extern "C" {static PyObject *meth_wxTextAttrBorder_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_SetWidth, "SetWidth(width)\n"
"SetWidth(value, units=TEXT_ATTR_UNITS_TENTHS_MM)\n"
"\n"
"Sets the border width.\n"
"");

extern "C" {static PyObject *meth_wxTextAttrBorder_SetWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_SetWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* width;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, sipType_wxTextAttrDimension, &width))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(*width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int value;
         ::wxTextAttrUnits units = wxTEXT_ATTR_UNITS_TENTHS_MM;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_units,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|E", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, &value, sipType_wxTextAttrUnits, &units))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(value,units);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_SetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_HasStyle, "HasStyle() -> bool\n"
"\n"
"True if the border has a valid style.");

extern "C" {static PyObject *meth_wxTextAttrBorder_HasStyle(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_HasStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_HasStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_HasColour, "HasColour() -> bool\n"
"\n"
"True if the border has a valid colour.");

extern "C" {static PyObject *meth_wxTextAttrBorder_HasColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_HasColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_HasColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_HasWidth, "HasWidth() -> bool\n"
"\n"
"True if the border has a valid width.");

extern "C" {static PyObject *meth_wxTextAttrBorder_HasWidth(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_HasWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_HasWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_IsValid, "IsValid() -> bool\n"
"\n"
"True if the border is valid.");

extern "C" {static PyObject *meth_wxTextAttrBorder_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_IsDefault, "IsDefault() -> bool\n"
"\n"
"True if the border has no attributes set.");

extern "C" {static PyObject *meth_wxTextAttrBorder_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_IsDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_MakeValid, "MakeValid()\n"
"\n"
"Set the valid flag for this border.");

extern "C" {static PyObject *meth_wxTextAttrBorder_MakeValid(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_MakeValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MakeValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_MakeValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns the border flags.");

extern "C" {static PyObject *meth_wxTextAttrBorder_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets the border flags.");

extern "C" {static PyObject *meth_wxTextAttrBorder_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_AddFlag, "AddFlag(flag)\n"
"\n"
"Adds a border flag.");

extern "C" {static PyObject *meth_wxTextAttrBorder_AddFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_AddFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flag;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_AddFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder_RemoveFlag, "RemoveFlag(flag)\n"
"\n"
"Removes a border flag.");

extern "C" {static PyObject *meth_wxTextAttrBorder_RemoveFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder_RemoveFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flag;
         ::wxTextAttrBorder *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrBorder, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName_RemoveFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrBorder___nonzero__, "__nonzero__() -> int");

extern "C" {static PyObject *meth_wxTextAttrBorder___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrBorder___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrBorder *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrBorder, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxTextAttrBorder___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrBorder, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxTextAttrBorder___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxTextAttrBorder___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrBorder));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder* border;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrBorder, &border))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp-> ::wxTextAttrBorder::operator==(*border);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxTextAttrBorder, sipSelf, sipArg);
}


extern "C" {static int slot_wxTextAttrBorder___bool__(PyObject *);}
static int slot_wxTextAttrBorder___bool__(PyObject *sipSelf)
{
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrBorder));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxTextAttrBorder___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxTextAttrBorder___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxTextAttrBorder___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrBorder));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrBorder* border;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrBorder, &border))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTextAttrBorder::operator==(*border);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxTextAttrBorder, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextAttrBorder(void *, int);}
static void release_wxTextAttrBorder(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextAttrBorder *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxTextAttrBorder(Py_ssize_t);}
static void *array_wxTextAttrBorder(Py_ssize_t sipNrElem)
{
    return new  ::wxTextAttrBorder[sipNrElem];
}


extern "C" {static void assign_wxTextAttrBorder(void *, Py_ssize_t, void *);}
static void assign_wxTextAttrBorder(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextAttrBorder *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextAttrBorder *>(sipSrc);
}


extern "C" {static void *copy_wxTextAttrBorder(const void *, Py_ssize_t);}
static void *copy_wxTextAttrBorder(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxTextAttrBorder(reinterpret_cast<const  ::wxTextAttrBorder *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextAttrBorder(sipSimpleWrapper *);}
static void dealloc_wxTextAttrBorder(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextAttrBorder(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextAttrBorder(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextAttrBorder(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTextAttrBorder *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTextAttrBorder* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxTextAttrBorder, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrBorder(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTextAttrBorder[] = {
    {(void *)slot_wxTextAttrBorder___ne__, ne_slot},
    {(void *)slot_wxTextAttrBorder___bool__, bool_slot},
    {(void *)slot_wxTextAttrBorder___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTextAttrBorder[] = {
    {sipName_AddFlag, SIP_MLMETH_CAST(meth_wxTextAttrBorder_AddFlag), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_AddFlag},
    {sipName_Apply, SIP_MLMETH_CAST(meth_wxTextAttrBorder_Apply), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_Apply},
    {sipName_CollectCommonAttributes, SIP_MLMETH_CAST(meth_wxTextAttrBorder_CollectCommonAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_CollectCommonAttributes},
    {sipName_EqPartial, SIP_MLMETH_CAST(meth_wxTextAttrBorder_EqPartial), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_EqPartial},
    {sipName_GetColour, meth_wxTextAttrBorder_GetColour, METH_VARARGS, doc_wxTextAttrBorder_GetColour},
    {sipName_GetColourLong, meth_wxTextAttrBorder_GetColourLong, METH_VARARGS, doc_wxTextAttrBorder_GetColourLong},
    {sipName_GetFlags, meth_wxTextAttrBorder_GetFlags, METH_VARARGS, doc_wxTextAttrBorder_GetFlags},
    {sipName_GetStyle, meth_wxTextAttrBorder_GetStyle, METH_VARARGS, doc_wxTextAttrBorder_GetStyle},
    {sipName_GetWidth, meth_wxTextAttrBorder_GetWidth, METH_VARARGS, doc_wxTextAttrBorder_GetWidth},
    {sipName_HasColour, meth_wxTextAttrBorder_HasColour, METH_VARARGS, doc_wxTextAttrBorder_HasColour},
    {sipName_HasStyle, meth_wxTextAttrBorder_HasStyle, METH_VARARGS, doc_wxTextAttrBorder_HasStyle},
    {sipName_HasWidth, meth_wxTextAttrBorder_HasWidth, METH_VARARGS, doc_wxTextAttrBorder_HasWidth},
    {sipName_IsDefault, meth_wxTextAttrBorder_IsDefault, METH_VARARGS, doc_wxTextAttrBorder_IsDefault},
    {sipName_IsValid, meth_wxTextAttrBorder_IsValid, METH_VARARGS, doc_wxTextAttrBorder_IsValid},
    {sipName_MakeValid, meth_wxTextAttrBorder_MakeValid, METH_VARARGS, doc_wxTextAttrBorder_MakeValid},
    {sipName_RemoveFlag, SIP_MLMETH_CAST(meth_wxTextAttrBorder_RemoveFlag), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_RemoveFlag},
    {sipName_RemoveStyle, SIP_MLMETH_CAST(meth_wxTextAttrBorder_RemoveStyle), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_RemoveStyle},
    {sipName_Reset, meth_wxTextAttrBorder_Reset, METH_VARARGS, doc_wxTextAttrBorder_Reset},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxTextAttrBorder_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_SetColour},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxTextAttrBorder_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_SetFlags},
    {sipName_SetStyle, SIP_MLMETH_CAST(meth_wxTextAttrBorder_SetStyle), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_SetStyle},
    {sipName_SetWidth, SIP_MLMETH_CAST(meth_wxTextAttrBorder_SetWidth), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrBorder_SetWidth},
    {sipName___nonzero__, meth_wxTextAttrBorder___nonzero__, METH_VARARGS, doc_wxTextAttrBorder___nonzero__}
};


extern "C" {static PyObject *varget_wxTextAttrBorder_m_borderColour(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrBorder_m_borderColour(void *sipSelf, PyObject *, PyObject *)
{
    unsigned long sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipVal = sipCpp->m_borderColour;

    return PyLong_FromUnsignedLong(sipVal);
}


extern "C" {static int varset_wxTextAttrBorder_m_borderColour(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrBorder_m_borderColour(void *sipSelf, PyObject *sipPy, PyObject *)
{
    unsigned long sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipVal = sipLong_AsUnsignedLong(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_borderColour = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrBorder_m_borderStyle(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrBorder_m_borderStyle(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipVal = sipCpp->m_borderStyle;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextAttrBorder_m_borderStyle(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrBorder_m_borderStyle(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_borderStyle = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrBorder_m_borderWidth(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrBorder_m_borderWidth(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -46);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->m_borderWidth;

    sipPy = sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -45, sipPySelf);
        sipKeepReference(sipPySelf, -46, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxTextAttrBorder_m_borderWidth(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrBorder_m_borderWidth(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_borderWidth = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrBorder_m_flags(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrBorder_m_flags(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipVal = sipCpp->m_flags;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextAttrBorder_m_flags(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrBorder_m_flags(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxTextAttrBorder *sipCpp = reinterpret_cast< ::wxTextAttrBorder *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_flags = sipVal;

    return 0;
}

sipVariableDef variables_wxTextAttrBorder[] = {
    {PropertyVariable, sipName_Width, &methods_wxTextAttrBorder[8], &methods_wxTextAttrBorder[21], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Style, &methods_wxTextAttrBorder[7], &methods_wxTextAttrBorder[20], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxTextAttrBorder[6], &methods_wxTextAttrBorder[19], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ColourLong, &methods_wxTextAttrBorder[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Colour, &methods_wxTextAttrBorder[4], &methods_wxTextAttrBorder[18], SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_borderColour, (PyMethodDef *)varget_wxTextAttrBorder_m_borderColour, (PyMethodDef *)varset_wxTextAttrBorder_m_borderColour, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_borderStyle, (PyMethodDef *)varget_wxTextAttrBorder_m_borderStyle, (PyMethodDef *)varset_wxTextAttrBorder_m_borderStyle, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_borderWidth, (PyMethodDef *)varget_wxTextAttrBorder_m_borderWidth, (PyMethodDef *)varset_wxTextAttrBorder_m_borderWidth, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_flags, (PyMethodDef *)varget_wxTextAttrBorder_m_flags, (PyMethodDef *)varset_wxTextAttrBorder_m_flags, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxTextAttrBorder, "TextAttrBorder()\n"
"\n"
"A class representing a rich text object border.");


sipClassTypeDef sipTypeDef__richtext_wxTextAttrBorder = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextAttrBorder,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_TextAttrBorder,
        {0, 0, 1},
        23, methods_wxTextAttrBorder,
        0, SIP_NULLPTR,
        9, variables_wxTextAttrBorder,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTextAttrBorder,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxTextAttrBorder,
    init_type_wxTextAttrBorder,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTextAttrBorder,
    assign_wxTextAttrBorder,
    array_wxTextAttrBorder,
    copy_wxTextAttrBorder,
    release_wxTextAttrBorder,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
