/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"
        #include <wx/html/htmlfilt.h>
        #include <wx/filesys.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxHtmlFilter : public  ::wxHtmlFilter
{
public:
    sipwxHtmlFilter();
    sipwxHtmlFilter(const  ::wxHtmlFilter&);
    virtual ~sipwxHtmlFilter();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxString ReadFile(const  ::wxFSFile&) const SIP_OVERRIDE;
    bool CanRead(const  ::wxFSFile&) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxHtmlFilter(const sipwxHtmlFilter &);
    sipwxHtmlFilter &operator = (const sipwxHtmlFilter &);

    char sipPyMethods[2];
};

sipwxHtmlFilter::sipwxHtmlFilter():  ::wxHtmlFilter(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHtmlFilter::sipwxHtmlFilter(const  ::wxHtmlFilter& a0):  ::wxHtmlFilter(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHtmlFilter::~sipwxHtmlFilter()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxString sipwxHtmlFilter::ReadFile(const  ::wxFSFile& file) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_HtmlFilter, sipName_ReadFile);

    if (!sipMeth)
        return  ::wxString();

    extern  ::wxString sipVH__html_15(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxFSFile&);

    return sipVH__html_15(sipGILState, 0, sipPySelf, sipMeth, file);
}

bool sipwxHtmlFilter::CanRead(const  ::wxFSFile& file) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_HtmlFilter, sipName_CanRead);

    if (!sipMeth)
        return 0;

    extern bool sipVH__html_14(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxFSFile&);

    return sipVH__html_14(sipGILState, 0, sipPySelf, sipMeth, file);
}


PyDoc_STRVAR(doc_wxHtmlFilter_CanRead, "CanRead(file) -> bool\n"
"\n"
"Returns true if this filter is capable of reading file file.");

extern "C" {static PyObject *meth_wxHtmlFilter_CanRead(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlFilter_CanRead(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxFSFile* file;
        const  ::wxHtmlFilter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxHtmlFilter, &sipCpp, sipType_wxFSFile, &file))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlFilter, sipName_CanRead);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanRead(*file);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlFilter, sipName_CanRead, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlFilter_ReadFile, "ReadFile(file) -> String\n"
"\n"
"Reads the file and returns string with HTML document.");

extern "C" {static PyObject *meth_wxHtmlFilter_ReadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlFilter_ReadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxFSFile* file;
        const  ::wxHtmlFilter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxHtmlFilter, &sipCpp, sipType_wxFSFile, &file))
        {
             ::wxString*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlFilter, sipName_ReadFile);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->ReadFile(*file));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlFilter, sipName_ReadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlFilter(void *, const sipTypeDef *);}
static void *cast_wxHtmlFilter(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHtmlFilter *sipCpp = reinterpret_cast< ::wxHtmlFilter *>(sipCppV);

    if (targetType == sipType_wxHtmlFilter)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlFilter(void *, int);}
static void release_wxHtmlFilter(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxHtmlFilter *>(sipCppV);
    else
        delete reinterpret_cast< ::wxHtmlFilter *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlFilter(sipSimpleWrapper *);}
static void dealloc_wxHtmlFilter(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxHtmlFilter *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlFilter(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxHtmlFilter(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlFilter(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxHtmlFilter *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHtmlFilter();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxHtmlFilter* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxHtmlFilter, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHtmlFilter(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlFilter[] = {{25, 0, 1}};


static PyMethodDef methods_wxHtmlFilter[] = {
    {sipName_CanRead, SIP_MLMETH_CAST(meth_wxHtmlFilter_CanRead), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlFilter_CanRead},
    {sipName_ReadFile, SIP_MLMETH_CAST(meth_wxHtmlFilter_ReadFile), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlFilter_ReadFile}
};

PyDoc_STRVAR(doc_wxHtmlFilter, "HtmlFilter()\n"
"\n"
"This class is the parent class of input filters for wxHtmlWindow.");


sipClassTypeDef sipTypeDef__html_wxHtmlFilter = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlFilter,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_HtmlFilter,
        {0, 0, 1},
        2, methods_wxHtmlFilter,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHtmlFilter,
    -1,
    -1,
    supers_wxHtmlFilter,
    SIP_NULLPTR,
    init_type_wxHtmlFilter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxHtmlFilter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxHtmlFilter,
    cast_wxHtmlFilter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
