/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_grid.h"
        #include <wx/object.h>
        #include <wx/grid.h>


PyDoc_STRVAR(doc_wxGridCellAttrPtr_get, "get() -> T\n"
"\n"
"Gets a pointer to the reference counted object to which this class\n"
"points.");

extern "C" {static PyObject *meth_wxGridCellAttrPtr_get(PyObject *, PyObject *);}
static PyObject *meth_wxGridCellAttrPtr_get(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxGridCellAttrPtr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridCellAttrPtr, &sipCpp))
        {
             ::wxGridCellAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->get();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxGridCellAttr,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridCellAttrPtr, sipName_get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridCellAttrPtr_reset, "reset(ptr)\n"
"\n"
"Reset this class to ptr which points to a reference counted object and\n"
"calls T::DecRef() on the previously owned object.");

extern "C" {static PyObject *meth_wxGridCellAttrPtr_reset(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridCellAttrPtr_reset(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxGridCellAttr* ptr;
         ::wxGridCellAttrPtr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ptr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxGridCellAttrPtr, &sipCpp, sipType_wxGridCellAttr, &ptr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->reset(ptr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridCellAttrPtr, sipName_reset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridCellAttrPtr_release, "release() -> T\n"
"\n"
"Release the owned pointer, making caller responsible for decrementing\n"
"its reference count.");

extern "C" {static PyObject *meth_wxGridCellAttrPtr_release(PyObject *, PyObject *);}
static PyObject *meth_wxGridCellAttrPtr_release(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxGridCellAttrPtr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridCellAttrPtr, &sipCpp))
        {
             ::wxGridCellAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->release();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxGridCellAttr,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridCellAttrPtr, sipName_release, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGridCellAttrPtr(void *, int);}
static void release_wxGridCellAttrPtr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGridCellAttrPtr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGridCellAttrPtr(Py_ssize_t);}
static void *array_wxGridCellAttrPtr(Py_ssize_t sipNrElem)
{
    return new  ::wxGridCellAttrPtr[sipNrElem];
}


extern "C" {static void assign_wxGridCellAttrPtr(void *, Py_ssize_t, void *);}
static void assign_wxGridCellAttrPtr(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxGridCellAttrPtr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxGridCellAttrPtr *>(sipSrc);
}


extern "C" {static void *copy_wxGridCellAttrPtr(const void *, Py_ssize_t);}
static void *copy_wxGridCellAttrPtr(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxGridCellAttrPtr(reinterpret_cast<const  ::wxGridCellAttrPtr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGridCellAttrPtr(sipSimpleWrapper *);}
static void dealloc_wxGridCellAttrPtr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGridCellAttrPtr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGridCellAttrPtr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGridCellAttrPtr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxGridCellAttrPtr *sipCpp = SIP_NULLPTR;

    {
        const  ::wxGridCellAttrPtr* tocopy;

        static const char *sipKwdList[] = {
            sipName_tocopy,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxGridCellAttrPtr, &tocopy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGridCellAttrPtr(*tocopy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
         ::wxGridCellAttr* ptr = 0;

        static const char *sipKwdList[] = {
            sipName_ptr,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J8", sipType_wxGridCellAttr, &ptr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGridCellAttrPtr(ptr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxGridCellAttrPtr[] = {
    {sipName_get, meth_wxGridCellAttrPtr_get, METH_VARARGS, doc_wxGridCellAttrPtr_get},
    {sipName_release, meth_wxGridCellAttrPtr_release, METH_VARARGS, doc_wxGridCellAttrPtr_release},
    {sipName_reset, SIP_MLMETH_CAST(meth_wxGridCellAttrPtr_reset), METH_VARARGS|METH_KEYWORDS, doc_wxGridCellAttrPtr_reset}
};

PyDoc_STRVAR(doc_wxGridCellAttrPtr, "ObjectDataPtr(tocopy)\n"
"ObjectDataPtr(ptr=None)\n"
"\n"
"This is a helper template class primarily written to avoid memory\n"
"leaks because of missing calls to wxRefCounter::DecRef() and\n"
"wxObjectRefData::DecRef().");


sipClassTypeDef sipTypeDef__grid_wxGridCellAttrPtr = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxGridCellAttrPtr,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_GridCellAttrPtr,
        {0, 0, 1},
        3, methods_wxGridCellAttrPtr,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGridCellAttrPtr,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxGridCellAttrPtr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGridCellAttrPtr,
    assign_wxGridCellAttrPtr,
    array_wxGridCellAttrPtr,
    copy_wxGridCellAttrPtr,
    release_wxGridCellAttrPtr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
