/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_dataview.h"
        #include <wx/dataview.h>
        #include <wx/font.h>
        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxDataViewItemAttr_SetBold, "SetBold(set)\n"
"\n"
"Call this to indicate that the item shall be displayed in bold text.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_SetBold(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_SetBold(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool set;
         ::wxDataViewItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_set,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp, &set))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBold(set);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_SetBold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_SetColour, "SetColour(colour)\n"
"\n"
"Call this to indicate that the item shall be displayed with that\n"
"colour.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxDataViewItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_SetBackgroundColour, "SetBackgroundColour(colour)\n"
"\n"
"Call this to set the background colour to use.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxDataViewItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_SetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_SetItalic, "SetItalic(set)\n"
"\n"
"Call this to indicate that the item shall be displayed in italic text.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_SetItalic(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_SetItalic(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool set;
         ::wxDataViewItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_set,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp, &set))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetItalic(set);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_SetItalic, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_SetStrikethrough, "SetStrikethrough(set)\n"
"\n"
"Call this to indicate that the item shall be displayed in\n"
"strikethrough text.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_SetStrikethrough(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_SetStrikethrough(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool set;
         ::wxDataViewItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_set,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp, &set))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStrikethrough(set);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_SetStrikethrough, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_HasColour, "HasColour() -> bool\n"
"\n"
"Returns true if the colour property has been set.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_HasColour(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_HasColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_HasColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_GetColour, "GetColour() -> wx.Colour\n"
"\n"
"Returns this attribute's colour.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_HasFont, "HasFont() -> bool\n"
"\n"
"Returns true if any property affecting the font has been set.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_HasFont(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_HasFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_HasFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_GetBold, "GetBold() -> bool\n"
"\n"
"Returns value of the bold property.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_GetBold(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_GetBold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBold();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_GetBold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_GetItalic, "GetItalic() -> bool\n"
"\n"
"Returns value of the italics property.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_GetItalic(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_GetItalic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetItalic();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_GetItalic, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_HasBackgroundColour, "HasBackgroundColour() -> bool\n"
"\n"
"Returns true if the background colour property has been set.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_HasBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_HasBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBackgroundColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_HasBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_GetBackgroundColour, "GetBackgroundColour() -> wx.Colour\n"
"\n"
"Returns the colour to be used for the background.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetBackgroundColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_GetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_IsDefault, "IsDefault() -> bool\n"
"\n"
"Returns true if none of the properties have been set.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_IsDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewItemAttr_GetEffectiveFont, "GetEffectiveFont(font) -> wx.Font\n"
"\n"
"Return the font based on the given one with this attribute applied to\n"
"it.");

extern "C" {static PyObject *meth_wxDataViewItemAttr_GetEffectiveFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewItemAttr_GetEffectiveFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxFont* font;
        const  ::wxDataViewItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewItemAttr, &sipCpp, sipType_wxFont, &font))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetEffectiveFont(*font));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DataViewItemAttr, sipName_GetEffectiveFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDataViewItemAttr(void *, int);}
static void release_wxDataViewItemAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDataViewItemAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxDataViewItemAttr(Py_ssize_t);}
static void *array_wxDataViewItemAttr(Py_ssize_t sipNrElem)
{
    return new  ::wxDataViewItemAttr[sipNrElem];
}


extern "C" {static void assign_wxDataViewItemAttr(void *, Py_ssize_t, void *);}
static void assign_wxDataViewItemAttr(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxDataViewItemAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxDataViewItemAttr *>(sipSrc);
}


extern "C" {static void *copy_wxDataViewItemAttr(const void *, Py_ssize_t);}
static void *copy_wxDataViewItemAttr(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxDataViewItemAttr(reinterpret_cast<const  ::wxDataViewItemAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxDataViewItemAttr(sipSimpleWrapper *);}
static void dealloc_wxDataViewItemAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDataViewItemAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDataViewItemAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDataViewItemAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxDataViewItemAttr *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDataViewItemAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxDataViewItemAttr* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxDataViewItemAttr, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDataViewItemAttr(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxDataViewItemAttr[] = {
    {sipName_GetBackgroundColour, meth_wxDataViewItemAttr_GetBackgroundColour, METH_VARARGS, doc_wxDataViewItemAttr_GetBackgroundColour},
    {sipName_GetBold, meth_wxDataViewItemAttr_GetBold, METH_VARARGS, doc_wxDataViewItemAttr_GetBold},
    {sipName_GetColour, meth_wxDataViewItemAttr_GetColour, METH_VARARGS, doc_wxDataViewItemAttr_GetColour},
    {sipName_GetEffectiveFont, SIP_MLMETH_CAST(meth_wxDataViewItemAttr_GetEffectiveFont), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemAttr_GetEffectiveFont},
    {sipName_GetItalic, meth_wxDataViewItemAttr_GetItalic, METH_VARARGS, doc_wxDataViewItemAttr_GetItalic},
    {sipName_HasBackgroundColour, meth_wxDataViewItemAttr_HasBackgroundColour, METH_VARARGS, doc_wxDataViewItemAttr_HasBackgroundColour},
    {sipName_HasColour, meth_wxDataViewItemAttr_HasColour, METH_VARARGS, doc_wxDataViewItemAttr_HasColour},
    {sipName_HasFont, meth_wxDataViewItemAttr_HasFont, METH_VARARGS, doc_wxDataViewItemAttr_HasFont},
    {sipName_IsDefault, meth_wxDataViewItemAttr_IsDefault, METH_VARARGS, doc_wxDataViewItemAttr_IsDefault},
    {sipName_SetBackgroundColour, SIP_MLMETH_CAST(meth_wxDataViewItemAttr_SetBackgroundColour), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemAttr_SetBackgroundColour},
    {sipName_SetBold, SIP_MLMETH_CAST(meth_wxDataViewItemAttr_SetBold), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemAttr_SetBold},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxDataViewItemAttr_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemAttr_SetColour},
    {sipName_SetItalic, SIP_MLMETH_CAST(meth_wxDataViewItemAttr_SetItalic), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemAttr_SetItalic},
    {sipName_SetStrikethrough, SIP_MLMETH_CAST(meth_wxDataViewItemAttr_SetStrikethrough), METH_VARARGS|METH_KEYWORDS, doc_wxDataViewItemAttr_SetStrikethrough}
};

sipVariableDef variables_wxDataViewItemAttr[] = {
    {PropertyVariable, sipName_Italic, &methods_wxDataViewItemAttr[4], &methods_wxDataViewItemAttr[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Colour, &methods_wxDataViewItemAttr[2], &methods_wxDataViewItemAttr[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Bold, &methods_wxDataViewItemAttr[1], &methods_wxDataViewItemAttr[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxDataViewItemAttr[0], &methods_wxDataViewItemAttr[9], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxDataViewItemAttr, "DataViewItemAttr()\n"
"\n"
"This class is used to indicate to a wxDataViewCtrl that a certain item\n"
"(see wxDataViewItem) has extra font attributes for its renderer.");


sipClassTypeDef sipTypeDef__dataview_wxDataViewItemAttr = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxDataViewItemAttr,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_DataViewItemAttr,
        {0, 0, 1},
        14, methods_wxDataViewItemAttr,
        0, SIP_NULLPTR,
        4, variables_wxDataViewItemAttr,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDataViewItemAttr,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxDataViewItemAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDataViewItemAttr,
    assign_wxDataViewItemAttr,
    array_wxDataViewItemAttr,
    copy_wxDataViewItemAttr,
    release_wxDataViewItemAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
