/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/withimages.h>
        #include <wx/imaglist.h>
        #include <wx/window.h>
        #include <wx/bmpbndl.h>


class sipwxWithImages : public  ::wxWithImages
{
public:
    sipwxWithImages();
    virtual ~sipwxWithImages();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void SetImageList( ::wxImageList*) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxWithImages(const sipwxWithImages &);
    sipwxWithImages &operator = (const sipwxWithImages &);

    char sipPyMethods[1];
};

sipwxWithImages::sipwxWithImages():  ::wxWithImages(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxWithImages::~sipwxWithImages()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

void sipwxWithImages::SetImageList( ::wxImageList*imageList)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_SetImageList);

    if (!sipMeth)
    {
         ::wxWithImages::SetImageList(imageList);
        return;
    }

    extern void sipVH__core_155(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxImageList*);

    sipVH__core_155(sipGILState, 0, sipPySelf, sipMeth, imageList);
}


PyDoc_STRVAR(doc_wxWithImages_GetImageCount, "GetImageCount() -> int\n"
"\n"
"Return the number of images in this control.");

extern "C" {static PyObject *meth_wxWithImages_GetImageCount(PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_GetImageCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxWithImages *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWithImages, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetImageCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_GetImageCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWithImages_HasImages, "HasImages() -> bool\n"
"\n"
"Return true if the control has any images associated with it.");

extern "C" {static PyObject *meth_wxWithImages_HasImages(PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_HasImages(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxWithImages *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWithImages, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasImages();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_HasImages, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWithImages_SetImages, "SetImages(images)\n"
"\n"
"Set the images to use for the items in the control.");

extern "C" {static PyObject *meth_wxWithImages_SetImages(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_SetImages(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const wxVector< ::wxBitmapBundle>* images;
        int imagesState = 0;
         ::wxWithImages *sipCpp;

        static const char *sipKwdList[] = {
            sipName_images,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxWithImages, &sipCpp, sipType_wxVector_0100wxBitmapBundle, &images, &imagesState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetImages(*images);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<wxVector< ::wxBitmapBundle> *>(images), sipType_wxVector_0100wxBitmapBundle, imagesState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_SetImages, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWithImages_AssignImageList, "AssignImageList(imageList)\n"
"\n"
"Sets the image list for the page control and takes ownership of the\n"
"list.");

extern "C" {static PyObject *meth_wxWithImages_AssignImageList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_AssignImageList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxImageList* imageList;
         ::wxWithImages *sipCpp;

        static const char *sipKwdList[] = {
            sipName_imageList,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxWithImages, &sipCpp, sipType_wxImageList, &imageList))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AssignImageList(imageList);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_AssignImageList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWithImages_SetImageList, "SetImageList(imageList)\n"
"\n"
"Sets the image list to use.");

extern "C" {static PyObject *meth_wxWithImages_SetImageList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_SetImageList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxImageList* imageList;
         ::wxWithImages *sipCpp;

        static const char *sipKwdList[] = {
            sipName_imageList,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxWithImages, &sipCpp, sipType_wxImageList, &imageList))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxWithImages::SetImageList(imageList) : sipCpp->SetImageList(imageList));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_SetImageList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWithImages_GetImageList, "GetImageList() -> ImageList\n"
"\n"
"Returns the associated image list, may be NULL.");

extern "C" {static PyObject *meth_wxWithImages_GetImageList(PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_GetImageList(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxWithImages *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWithImages, &sipCpp))
        {
             ::wxImageList*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetImageList();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImageList,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_GetImageList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWithImages_GetUpdatedImageListFor, "GetUpdatedImageListFor(win) -> ImageList\n"
"\n"
"Returns the image list updated to reflect the DPI scaling used for the\n"
"given window if possible.");

extern "C" {static PyObject *meth_wxWithImages_GetUpdatedImageListFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWithImages_GetUpdatedImageListFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxWindow* win;
         ::wxWithImages *sipCpp;

        static const char *sipKwdList[] = {
            sipName_win,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxWithImages, &sipCpp, sipType_wxWindow, &win))
        {
             ::wxImageList*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUpdatedImageListFor(win);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxImageList,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WithImages, sipName_GetUpdatedImageListFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxWithImages(void *, int);}
static void release_wxWithImages(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxWithImages *>(sipCppV);
    else
        delete reinterpret_cast< ::wxWithImages *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxWithImages(sipSimpleWrapper *);}
static void dealloc_wxWithImages(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxWithImages *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxWithImages(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxWithImages(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxWithImages(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxWithImages *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxWithImages();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxWithImages[] = {
    {sipName_AssignImageList, SIP_MLMETH_CAST(meth_wxWithImages_AssignImageList), METH_VARARGS|METH_KEYWORDS, doc_wxWithImages_AssignImageList},
    {sipName_GetImageCount, meth_wxWithImages_GetImageCount, METH_VARARGS, doc_wxWithImages_GetImageCount},
    {sipName_GetImageList, meth_wxWithImages_GetImageList, METH_VARARGS, doc_wxWithImages_GetImageList},
    {sipName_GetUpdatedImageListFor, SIP_MLMETH_CAST(meth_wxWithImages_GetUpdatedImageListFor), METH_VARARGS|METH_KEYWORDS, doc_wxWithImages_GetUpdatedImageListFor},
    {sipName_HasImages, meth_wxWithImages_HasImages, METH_VARARGS, doc_wxWithImages_HasImages},
    {sipName_SetImageList, SIP_MLMETH_CAST(meth_wxWithImages_SetImageList), METH_VARARGS|METH_KEYWORDS, doc_wxWithImages_SetImageList},
    {sipName_SetImages, SIP_MLMETH_CAST(meth_wxWithImages_SetImages), METH_VARARGS|METH_KEYWORDS, doc_wxWithImages_SetImages}
};

static sipEnumMemberDef enummembers_wxWithImages[] = {
    {sipName_NO_IMAGE, static_cast<int>( ::wxWithImages::NO_IMAGE), -1},
};

sipVariableDef variables_wxWithImages[] = {
    {PropertyVariable, sipName_ImageList, &methods_wxWithImages[2], &methods_wxWithImages[5], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ImageCount, &methods_wxWithImages[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxWithImages, "WithImages()\n"
"\n"
"A mixin class to be used with other classes that use a wxImageList.");


sipClassTypeDef sipTypeDef__core_wxWithImages = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxWithImages,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_WithImages,
        {0, 0, 1},
        7, methods_wxWithImages,
        1, enummembers_wxWithImages,
        2, variables_wxWithImages,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxWithImages,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxWithImages,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxWithImages,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxWithImages,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
