/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/vidmode.h>
    int _wxVideoMode___nonzero__(wxVideoMode* self)
    {
        return self->IsOk();
    }
    int _wxVideoMode___bool__(wxVideoMode* self)
    {
        return self->IsOk();
    }


PyDoc_STRVAR(doc_wxVideoMode_Matches, "Matches(other) -> bool\n"
"\n"
"Returns true if this mode matches the other one in the sense that all\n"
"non zero fields of the other mode have the same value in this one\n"
"(except for refresh which is allowed to have a greater value).");

extern "C" {static PyObject *meth_wxVideoMode_Matches(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVideoMode_Matches(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode* other;
        const  ::wxVideoMode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxVideoMode, &sipCpp, sipType_wxVideoMode, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Matches(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VideoMode, sipName_Matches, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVideoMode_GetWidth, "GetWidth() -> int\n"
"\n"
"Returns the screen width in pixels (e.g. 640), 0 means unspecified.");

extern "C" {static PyObject *meth_wxVideoMode_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxVideoMode_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVideoMode, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VideoMode, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVideoMode_GetHeight, "GetHeight() -> int\n"
"\n"
"Returns the screen height in pixels (e.g. 480), 0 means unspecified.");

extern "C" {static PyObject *meth_wxVideoMode_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxVideoMode_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVideoMode, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VideoMode, sipName_GetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVideoMode_GetDepth, "GetDepth() -> int\n"
"\n"
"Returns bits per pixel (e.g. 32), 1 is monochrome and 0 means\n"
"unspecified/known.");

extern "C" {static PyObject *meth_wxVideoMode_GetDepth(PyObject *, PyObject *);}
static PyObject *meth_wxVideoMode_GetDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVideoMode, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VideoMode, sipName_GetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVideoMode_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the object has been initialized.");

extern "C" {static PyObject *meth_wxVideoMode_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxVideoMode_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVideoMode, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VideoMode, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVideoMode___nonzero__, "__nonzero__() -> int");

extern "C" {static PyObject *meth_wxVideoMode___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxVideoMode___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxVideoMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVideoMode, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxVideoMode___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VideoMode, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxVideoMode___bool__(PyObject *);}
static int slot_wxVideoMode___bool__(PyObject *sipSelf)
{
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxVideoMode));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxVideoMode___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxVideoMode___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxVideoMode___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxVideoMode));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode* mode;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxVideoMode, &mode))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxVideoMode::operator!=(*mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxVideoMode, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxVideoMode___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxVideoMode___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxVideoMode));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode* m;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxVideoMode, &m))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxVideoMode::operator==(*m);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxVideoMode, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVideoMode(void *, int);}
static void release_wxVideoMode(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxVideoMode *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxVideoMode(Py_ssize_t);}
static void *array_wxVideoMode(Py_ssize_t sipNrElem)
{
    return new  ::wxVideoMode[sipNrElem];
}


extern "C" {static void assign_wxVideoMode(void *, Py_ssize_t, void *);}
static void assign_wxVideoMode(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxVideoMode *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxVideoMode *>(sipSrc);
}


extern "C" {static void *copy_wxVideoMode(const void *, Py_ssize_t);}
static void *copy_wxVideoMode(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxVideoMode(reinterpret_cast<const  ::wxVideoMode *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxVideoMode(sipSimpleWrapper *);}
static void dealloc_wxVideoMode(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVideoMode(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxVideoMode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxVideoMode(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxVideoMode *sipCpp = SIP_NULLPTR;

    {
        int width = 0;
        int height = 0;
        int depth = 0;
        int freq = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_depth,
            sipName_freq,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iiii", &width, &height, &depth, &freq))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxVideoMode(width,height,depth,freq);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxVideoMode* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxVideoMode, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxVideoMode(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxVideoMode[] = {
    {(void *)slot_wxVideoMode___bool__, bool_slot},
    {(void *)slot_wxVideoMode___ne__, ne_slot},
    {(void *)slot_wxVideoMode___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxVideoMode[] = {
    {sipName_GetDepth, meth_wxVideoMode_GetDepth, METH_VARARGS, doc_wxVideoMode_GetDepth},
    {sipName_GetHeight, meth_wxVideoMode_GetHeight, METH_VARARGS, doc_wxVideoMode_GetHeight},
    {sipName_GetWidth, meth_wxVideoMode_GetWidth, METH_VARARGS, doc_wxVideoMode_GetWidth},
    {sipName_IsOk, meth_wxVideoMode_IsOk, METH_VARARGS, doc_wxVideoMode_IsOk},
    {sipName_Matches, SIP_MLMETH_CAST(meth_wxVideoMode_Matches), METH_VARARGS|METH_KEYWORDS, doc_wxVideoMode_Matches},
    {sipName___nonzero__, meth_wxVideoMode___nonzero__, METH_VARARGS, doc_wxVideoMode___nonzero__}
};


extern "C" {static PyObject *varget_wxVideoMode_bpp(void *, PyObject *, PyObject *);}
static PyObject *varget_wxVideoMode_bpp(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipCpp->bpp;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxVideoMode_bpp(void *, PyObject *, PyObject *);}
static int varset_wxVideoMode_bpp(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->bpp = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxVideoMode_h(void *, PyObject *, PyObject *);}
static PyObject *varget_wxVideoMode_h(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipCpp->h;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxVideoMode_h(void *, PyObject *, PyObject *);}
static int varset_wxVideoMode_h(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->h = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxVideoMode_refresh(void *, PyObject *, PyObject *);}
static PyObject *varget_wxVideoMode_refresh(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipCpp->refresh;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxVideoMode_refresh(void *, PyObject *, PyObject *);}
static int varset_wxVideoMode_refresh(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->refresh = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxVideoMode_w(void *, PyObject *, PyObject *);}
static PyObject *varget_wxVideoMode_w(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipCpp->w;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxVideoMode_w(void *, PyObject *, PyObject *);}
static int varset_wxVideoMode_w(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxVideoMode *sipCpp = reinterpret_cast< ::wxVideoMode *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->w = sipVal;

    return 0;
}

sipVariableDef variables_wxVideoMode[] = {
    {PropertyVariable, sipName_Width, &methods_wxVideoMode[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Height, &methods_wxVideoMode[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Depth, &methods_wxVideoMode[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_bpp, (PyMethodDef *)varget_wxVideoMode_bpp, (PyMethodDef *)varset_wxVideoMode_bpp, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_h, (PyMethodDef *)varget_wxVideoMode_h, (PyMethodDef *)varset_wxVideoMode_h, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_refresh, (PyMethodDef *)varget_wxVideoMode_refresh, (PyMethodDef *)varset_wxVideoMode_refresh, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_w, (PyMethodDef *)varget_wxVideoMode_w, (PyMethodDef *)varset_wxVideoMode_w, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxVideoMode, "VideoMode(width=0, height=0, depth=0, freq=0)\n"
"\n"
"Determines the sizes and locations of displays connected to the\n"
"system.");


sipClassTypeDef sipTypeDef__core_wxVideoMode = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxVideoMode,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_VideoMode,
        {0, 0, 1},
        6, methods_wxVideoMode,
        0, SIP_NULLPTR,
        7, variables_wxVideoMode,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxVideoMode,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxVideoMode,
    init_type_wxVideoMode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxVideoMode,
    assign_wxVideoMode,
    array_wxVideoMode,
    copy_wxVideoMode,
    release_wxVideoMode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
