/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/spinctrl.h>
        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxSpinDoubleEvent : public  ::wxSpinDoubleEvent
{
public:
    sipwxSpinDoubleEvent( ::wxEventType,int,double);
    sipwxSpinDoubleEvent(const  ::wxSpinDoubleEvent&);
    virtual ~sipwxSpinDoubleEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEvent* Clone() const SIP_OVERRIDE;
     ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxSpinDoubleEvent(const sipwxSpinDoubleEvent &);
    sipwxSpinDoubleEvent &operator = (const sipwxSpinDoubleEvent &);

    char sipPyMethods[2];
};

sipwxSpinDoubleEvent::sipwxSpinDoubleEvent( ::wxEventType commandType,int winid,double value):  ::wxSpinDoubleEvent(commandType,winid,value), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxSpinDoubleEvent::sipwxSpinDoubleEvent(const  ::wxSpinDoubleEvent& event):  ::wxSpinDoubleEvent(event), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxSpinDoubleEvent::~sipwxSpinDoubleEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxEvent* sipwxSpinDoubleEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return  ::wxSpinDoubleEvent::Clone();

    extern  ::wxEvent* sipVH__core_103(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_103(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEventCategory sipwxSpinDoubleEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxSpinDoubleEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__core_104(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_104(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxSpinDoubleEvent_GetValue, "GetValue() -> double\n"
"\n"
"Returns the value associated with this spin control event.");

extern "C" {static PyObject *meth_wxSpinDoubleEvent_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxSpinDoubleEvent_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSpinDoubleEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSpinDoubleEvent, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SpinDoubleEvent, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSpinDoubleEvent_SetValue, "SetValue(value)\n"
"\n"
"Set the value associated with the event.");

extern "C" {static PyObject *meth_wxSpinDoubleEvent_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSpinDoubleEvent_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double value;
         ::wxSpinDoubleEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxSpinDoubleEvent, &sipCpp, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SpinDoubleEvent, sipName_SetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSpinDoubleEvent_Clone, "Clone(self) -> Event");

extern "C" {static PyObject *meth_wxSpinDoubleEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxSpinDoubleEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxSpinDoubleEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSpinDoubleEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxSpinDoubleEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SpinDoubleEvent, sipName_Clone, doc_wxSpinDoubleEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxSpinDoubleEvent(void *, const sipTypeDef *);}
static void *cast_wxSpinDoubleEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxSpinDoubleEvent *sipCpp = reinterpret_cast< ::wxSpinDoubleEvent *>(sipCppV);

    if (targetType == sipType_wxSpinDoubleEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxNotifyEvent)->ctd_cast(static_cast< ::wxNotifyEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSpinDoubleEvent(void *, int);}
static void release_wxSpinDoubleEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxSpinDoubleEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxSpinDoubleEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxSpinDoubleEvent(sipSimpleWrapper *);}
static void dealloc_wxSpinDoubleEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxSpinDoubleEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSpinDoubleEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxSpinDoubleEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSpinDoubleEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxSpinDoubleEvent *sipCpp = SIP_NULLPTR;

    {
         ::wxEventType commandType = wxEVT_NULL;
        int winid = 0;
        double value = 0;

        static const char *sipKwdList[] = {
            sipName_commandType,
            sipName_winid,
            sipName_value,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iid", &commandType, &winid, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxSpinDoubleEvent(commandType,winid,value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxSpinDoubleEvent* event;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxSpinDoubleEvent, &event))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxSpinDoubleEvent(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxSpinDoubleEvent[] = {{388, 255, 1}};


static PyMethodDef methods_wxSpinDoubleEvent[] = {
    {sipName_Clone, meth_wxSpinDoubleEvent_Clone, METH_VARARGS, doc_wxSpinDoubleEvent_Clone},
    {sipName_GetValue, meth_wxSpinDoubleEvent_GetValue, METH_VARARGS, doc_wxSpinDoubleEvent_GetValue},
    {sipName_SetValue, SIP_MLMETH_CAST(meth_wxSpinDoubleEvent_SetValue), METH_VARARGS|METH_KEYWORDS, doc_wxSpinDoubleEvent_SetValue}
};

sipVariableDef variables_wxSpinDoubleEvent[] = {
    {PropertyVariable, sipName_Value, &methods_wxSpinDoubleEvent[1], &methods_wxSpinDoubleEvent[2], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxSpinDoubleEvent, "SpinDoubleEvent(commandType=wxEVT_NULL, winid=0, value=0)\n"
"SpinDoubleEvent(event)\n"
"\n"
"This event class is used for the events generated by wxSpinCtrlDouble.");


sipClassTypeDef sipTypeDef__core_wxSpinDoubleEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxSpinDoubleEvent,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_SpinDoubleEvent,
        {0, 0, 1},
        3, methods_wxSpinDoubleEvent,
        0, SIP_NULLPTR,
        1, variables_wxSpinDoubleEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxSpinDoubleEvent,
    -1,
    -1,
    supers_wxSpinDoubleEvent,
    SIP_NULLPTR,
    init_type_wxSpinDoubleEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxSpinDoubleEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxSpinDoubleEvent,
    cast_wxSpinDoubleEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
