/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/help.h>
        #include <wx/window.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/frame.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxHelpControllerBase : public  ::wxHelpControllerBase
{
public:
    sipwxHelpControllerBase( ::wxWindow*);
    sipwxHelpControllerBase(const  ::wxHelpControllerBase&);
    virtual ~sipwxHelpControllerBase();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void SetViewer(const  ::wxString&,long) SIP_OVERRIDE;
    void SetParentWindow( ::wxWindow*) SIP_OVERRIDE;
    void SetFrameParameters(const  ::wxString&,const  ::wxSize&,const  ::wxPoint&,bool) SIP_OVERRIDE;
    bool Quit() SIP_OVERRIDE;
    void OnQuit() SIP_OVERRIDE;
    bool LoadFile(const  ::wxString&) SIP_OVERRIDE;
    bool KeywordSearch(const  ::wxString&, ::wxHelpSearchMode) SIP_OVERRIDE;
    bool Initialize(const  ::wxString&) SIP_OVERRIDE;
     ::wxWindow* GetParentWindow() const SIP_OVERRIDE;
     ::wxFrame* GetFrameParameters( ::wxSize*, ::wxPoint*,bool*) SIP_OVERRIDE;
    bool DisplayTextPopup(const  ::wxString&,const  ::wxPoint&) SIP_OVERRIDE;
    bool DisplaySection(int) SIP_OVERRIDE;
    bool DisplaySection(const  ::wxString&) SIP_OVERRIDE;
    bool DisplayContextPopup(int) SIP_OVERRIDE;
    bool DisplayContents() SIP_OVERRIDE;
    bool DisplayBlock(long) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxHelpControllerBase(const sipwxHelpControllerBase &);
    sipwxHelpControllerBase &operator = (const sipwxHelpControllerBase &);

    char sipPyMethods[16];
};

sipwxHelpControllerBase::sipwxHelpControllerBase( ::wxWindow*parentWindow):  ::wxHelpControllerBase(parentWindow), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHelpControllerBase::sipwxHelpControllerBase(const  ::wxHelpControllerBase& a0):  ::wxHelpControllerBase(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHelpControllerBase::~sipwxHelpControllerBase()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

void sipwxHelpControllerBase::SetViewer(const  ::wxString& viewer,long flags)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_SetViewer);

    if (!sipMeth)
    {
         ::wxHelpControllerBase::SetViewer(viewer,flags);
        return;
    }

    extern void sipVH__core_204(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,long);

    sipVH__core_204(sipGILState, 0, sipPySelf, sipMeth, viewer, flags);
}

void sipwxHelpControllerBase::SetParentWindow( ::wxWindow*parentWindow)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_SetParentWindow);

    if (!sipMeth)
    {
         ::wxHelpControllerBase::SetParentWindow(parentWindow);
        return;
    }

    extern void sipVH__core_138(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxWindow*);

    sipVH__core_138(sipGILState, 0, sipPySelf, sipMeth, parentWindow);
}

void sipwxHelpControllerBase::SetFrameParameters(const  ::wxString& titleFormat,const  ::wxSize& size,const  ::wxPoint& pos,bool newFrameEachTime)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_SetFrameParameters);

    if (!sipMeth)
    {
         ::wxHelpControllerBase::SetFrameParameters(titleFormat,size,pos,newFrameEachTime);
        return;
    }

    extern void sipVH__core_203(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxSize&,const  ::wxPoint&,bool);

    sipVH__core_203(sipGILState, 0, sipPySelf, sipMeth, titleFormat, size, pos, newFrameEachTime);
}

bool sipwxHelpControllerBase::Quit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, sipName_HelpControllerBase, sipName_Quit);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxHelpControllerBase::OnQuit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_OnQuit);

    if (!sipMeth)
    {
         ::wxHelpControllerBase::OnQuit();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxHelpControllerBase::LoadFile(const  ::wxString& file)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, sipName_HelpControllerBase, sipName_LoadFile);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_9(sipGILState, 0, sipPySelf, sipMeth, file);
}

bool sipwxHelpControllerBase::KeywordSearch(const  ::wxString& keyWord, ::wxHelpSearchMode mode)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, sipName_HelpControllerBase, sipName_KeywordSearch);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_202(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&, ::wxHelpSearchMode);

    return sipVH__core_202(sipGILState, 0, sipPySelf, sipMeth, keyWord, mode);
}

bool sipwxHelpControllerBase::Initialize(const  ::wxString& file)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_Initialize);

    if (!sipMeth)
        return  ::wxHelpControllerBase::Initialize(file);

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_9(sipGILState, 0, sipPySelf, sipMeth, file);
}

 ::wxWindow* sipwxHelpControllerBase::GetParentWindow() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetParentWindow);

    if (!sipMeth)
        return  ::wxHelpControllerBase::GetParentWindow();

    extern  ::wxWindow* sipVH__core_129(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_129(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxFrame* sipwxHelpControllerBase::GetFrameParameters( ::wxSize*size, ::wxPoint*pos,bool*newFrameEachTime)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_GetFrameParameters);

    if (!sipMeth)
        return  ::wxHelpControllerBase::GetFrameParameters(size,pos,newFrameEachTime);

    extern  ::wxFrame* sipVH__core_201(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxSize*, ::wxPoint*,bool*);

    return sipVH__core_201(sipGILState, 0, sipPySelf, sipMeth, size, pos, newFrameEachTime);
}

bool sipwxHelpControllerBase::DisplayTextPopup(const  ::wxString& text,const  ::wxPoint& pos)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_DisplayTextPopup);

    if (!sipMeth)
        return  ::wxHelpControllerBase::DisplayTextPopup(text,pos);

    extern bool sipVH__core_200(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxPoint&);

    return sipVH__core_200(sipGILState, 0, sipPySelf, sipMeth, text, pos);
}

bool sipwxHelpControllerBase::DisplaySection(int sectionNo)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[11], &sipPySelf, sipName_HelpControllerBase, sipName_DisplaySection);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, sectionNo);
}

bool sipwxHelpControllerBase::DisplaySection(const  ::wxString& section)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[12], &sipPySelf, SIP_NULLPTR, sipName_DisplaySection);

    if (!sipMeth)
        return  ::wxHelpControllerBase::DisplaySection(section);

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_9(sipGILState, 0, sipPySelf, sipMeth, section);
}

bool sipwxHelpControllerBase::DisplayContextPopup(int contextId)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[13], &sipPySelf, SIP_NULLPTR, sipName_DisplayContextPopup);

    if (!sipMeth)
        return  ::wxHelpControllerBase::DisplayContextPopup(contextId);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, contextId);
}

bool sipwxHelpControllerBase::DisplayContents()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[14], &sipPySelf, sipName_HelpControllerBase, sipName_DisplayContents);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxHelpControllerBase::DisplayBlock(long blockNo)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[15], &sipPySelf, sipName_HelpControllerBase, sipName_DisplayBlock);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_115(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, long);

    return sipVH__core_115(sipGILState, 0, sipPySelf, sipMeth, blockNo);
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayBlock, "DisplayBlock(blockNo) -> bool\n"
"\n"
"If the help viewer is not running, runs it and displays the file at\n"
"the given block number.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayBlock(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayBlock(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        long blockNo;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_blockNo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, &blockNo))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_DisplayBlock);
                return SIP_NULLPTR;
            }

            if (sipDeprecated(sipName_HelpControllerBase,sipName_DisplayBlock) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisplayBlock(blockNo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayBlock, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayContents, "DisplayContents() -> bool\n"
"\n"
"If the help viewer is not running, runs it and displays the contents.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayContents(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayContents(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_DisplayContents);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisplayContents();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayContents, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayContextPopup, "DisplayContextPopup(contextId) -> bool\n"
"\n"
"Displays the section as a popup window using a context id.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayContextPopup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayContextPopup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int contextId;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_contextId,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, &contextId))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::DisplayContextPopup(contextId) : sipCpp->DisplayContextPopup(contextId));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayContextPopup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplaySection, "DisplaySection(section) -> bool\n"
"DisplaySection(sectionNo) -> bool\n"
"\n"
"If the help viewer is not running, runs it and displays the given\n"
"section.\n"
"");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplaySection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplaySection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* section;
        int sectionState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_section,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &section, &sectionState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::DisplaySection(*section) : sipCpp->DisplaySection(*section));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(section), sipType_wxString, sectionState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int sectionNo;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sectionNo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, &sectionNo))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_DisplaySection);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisplaySection(sectionNo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplaySection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayTextPopup, "DisplayTextPopup(text, pos) -> bool\n"
"\n"
"Displays the text in a popup window, if possible.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayTextPopup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayTextPopup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxPoint* pos;
        int posState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &text, &textState, sipType_wxPoint, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::DisplayTextPopup(*text,*pos) : sipCpp->DisplayTextPopup(*text,*pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast< ::wxPoint *>(pos), sipType_wxPoint, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayTextPopup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_GetFrameParameters, "GetFrameParameters() -> (Frame, size, pos, newFrameEachTime)\n"
"\n"
"For wxHtmlHelpController, returns the latest frame size and position\n"
"settings and whether a new frame is drawn with each invocation.");

extern "C" {static PyObject *meth_wxHelpControllerBase_GetFrameParameters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_GetFrameParameters(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxSize* size;
         ::wxPoint* pos;
        bool newFrameEachTime;
         ::wxHelpControllerBase *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
             ::wxFrame*sipRes;
            size = new  ::wxSize();
            pos = new  ::wxPoint();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::GetFrameParameters(size,pos,&newFrameEachTime) : sipCpp->GetFrameParameters(size,pos,&newFrameEachTime));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            PyObject *sipResObj = sipConvertFromType(sipRes,sipType_wxFrame,SIP_NULLPTR);
            return sipBuildResult(0,"(RNNb)",sipResObj,size,sipType_wxSize,SIP_NULLPTR,pos,sipType_wxPoint,SIP_NULLPTR,newFrameEachTime);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_GetFrameParameters, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_GetParentWindow, "GetParentWindow() -> Window\n"
"\n"
"Returns the window to be used as the parent for the help window.");

extern "C" {static PyObject *meth_wxHelpControllerBase_GetParentWindow(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_GetParentWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::GetParentWindow() : sipCpp->GetParentWindow());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_GetParentWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_Initialize, "Initialize(file) -> bool\n"
"\n"
"Initializes the help instance with a help filename.");

extern "C" {static PyObject *meth_wxHelpControllerBase_Initialize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_Initialize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* file;
        int fileState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &file, &fileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::Initialize(*file) : sipCpp->Initialize(*file));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file), sipType_wxString, fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_Initialize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_KeywordSearch, "KeywordSearch(keyWord, mode=HELP_SEARCH_ALL) -> bool\n"
"\n"
"If the help viewer is not running, runs it, and searches for sections\n"
"matching the given keyword.");

extern "C" {static PyObject *meth_wxHelpControllerBase_KeywordSearch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_KeywordSearch(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* keyWord;
        int keyWordState = 0;
         ::wxHelpSearchMode mode = wxHELP_SEARCH_ALL;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keyWord,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &keyWord, &keyWordState, sipType_wxHelpSearchMode, &mode))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_KeywordSearch);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->KeywordSearch(*keyWord,mode);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(keyWord), sipType_wxString, keyWordState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_KeywordSearch, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_LoadFile, "LoadFile(file=EmptyString) -> bool\n"
"\n"
"If the help viewer is not running, runs it and loads the given file.");

extern "C" {static PyObject *meth_wxHelpControllerBase_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString& filedef = wxEmptyString;
        const  ::wxString* file = &filedef;
        int fileState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &file, &fileState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_LoadFile);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*file);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file), sipType_wxString, fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_OnQuit, "OnQuit()\n"
"\n"
"Overridable member called when this application's viewer is quit by\n"
"the user.");

extern "C" {static PyObject *meth_wxHelpControllerBase_OnQuit(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_OnQuit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::OnQuit() : sipCpp->OnQuit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_OnQuit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_Quit, "Quit() -> bool\n"
"\n"
"If the viewer is running, quits it by disconnecting.");

extern "C" {static PyObject *meth_wxHelpControllerBase_Quit(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_Quit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_Quit);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Quit();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_Quit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_SetFrameParameters, "SetFrameParameters(titleFormat, size, pos=DefaultPosition, newFrameEachTime=False)\n"
"\n"
"Set the parameters of the frame window.");

extern "C" {static PyObject *meth_wxHelpControllerBase_SetFrameParameters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_SetFrameParameters(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* titleFormat;
        int titleFormatState = 0;
        const  ::wxSize* size;
        int sizeState = 0;
        const  ::wxPoint& posdef = wxDefaultPosition;
        const  ::wxPoint* pos = &posdef;
        int posState = 0;
        bool newFrameEachTime = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_titleFormat,
            sipName_size,
            sipName_pos,
            sipName_newFrameEachTime,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|J1b", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &titleFormat, &titleFormatState, sipType_wxSize, &size, &sizeState, sipType_wxPoint, &pos, &posState, &newFrameEachTime))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::SetFrameParameters(*titleFormat,*size,*pos,newFrameEachTime) : sipCpp->SetFrameParameters(*titleFormat,*size,*pos,newFrameEachTime));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(titleFormat), sipType_wxString, titleFormatState);
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);
            sipReleaseType(const_cast< ::wxPoint *>(pos), sipType_wxPoint, posState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_SetFrameParameters, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_SetParentWindow, "SetParentWindow(parentWindow)\n"
"\n"
"Sets the window to be used as the parent for the help window.");

extern "C" {static PyObject *meth_wxHelpControllerBase_SetParentWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_SetParentWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindow* parentWindow;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parentWindow,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxWindow, &parentWindow))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::SetParentWindow(parentWindow) : sipCpp->SetParentWindow(parentWindow));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_SetParentWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_SetViewer, "SetViewer(viewer, flags=HELP_NETSCAPE)\n"
"\n"
"Sets detailed viewer information.");

extern "C" {static PyObject *meth_wxHelpControllerBase_SetViewer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_SetViewer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* viewer;
        int viewerState = 0;
        long flags = wxHELP_NETSCAPE;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_viewer,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|l", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString, &viewer, &viewerState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::SetViewer(*viewer,flags) : sipCpp->SetViewer(*viewer,flags));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(viewer), sipType_wxString, viewerState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_SetViewer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHelpControllerBase(void *, const sipTypeDef *);}
static void *cast_wxHelpControllerBase(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHelpControllerBase *sipCpp = reinterpret_cast< ::wxHelpControllerBase *>(sipCppV);

    if (targetType == sipType_wxHelpControllerBase)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHelpControllerBase(void *, int);}
static void release_wxHelpControllerBase(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxHelpControllerBase *>(sipCppV);
    else
        delete reinterpret_cast< ::wxHelpControllerBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHelpControllerBase(sipSimpleWrapper *);}
static void dealloc_wxHelpControllerBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxHelpControllerBase *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHelpControllerBase(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxHelpControllerBase(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHelpControllerBase(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxHelpControllerBase *sipCpp = SIP_NULLPTR;

    {
         ::wxWindow* parentWindow = 0;

        static const char *sipKwdList[] = {
            sipName_parentWindow,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J8", sipType_wxWindow, &parentWindow))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHelpControllerBase(parentWindow);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxHelpControllerBase* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxHelpControllerBase, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHelpControllerBase(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHelpControllerBase[] = {{390, 255, 1}};


static PyMethodDef methods_wxHelpControllerBase[] = {
    {sipName_DisplayBlock, SIP_MLMETH_CAST(meth_wxHelpControllerBase_DisplayBlock), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_DisplayBlock},
    {sipName_DisplayContents, meth_wxHelpControllerBase_DisplayContents, METH_VARARGS, doc_wxHelpControllerBase_DisplayContents},
    {sipName_DisplayContextPopup, SIP_MLMETH_CAST(meth_wxHelpControllerBase_DisplayContextPopup), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_DisplayContextPopup},
    {sipName_DisplaySection, SIP_MLMETH_CAST(meth_wxHelpControllerBase_DisplaySection), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_DisplaySection},
    {sipName_DisplayTextPopup, SIP_MLMETH_CAST(meth_wxHelpControllerBase_DisplayTextPopup), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_DisplayTextPopup},
    {sipName_GetFrameParameters, SIP_MLMETH_CAST(meth_wxHelpControllerBase_GetFrameParameters), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_GetFrameParameters},
    {sipName_GetParentWindow, meth_wxHelpControllerBase_GetParentWindow, METH_VARARGS, doc_wxHelpControllerBase_GetParentWindow},
    {sipName_Initialize, SIP_MLMETH_CAST(meth_wxHelpControllerBase_Initialize), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_Initialize},
    {sipName_KeywordSearch, SIP_MLMETH_CAST(meth_wxHelpControllerBase_KeywordSearch), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_KeywordSearch},
    {sipName_LoadFile, SIP_MLMETH_CAST(meth_wxHelpControllerBase_LoadFile), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_LoadFile},
    {sipName_OnQuit, meth_wxHelpControllerBase_OnQuit, METH_VARARGS, doc_wxHelpControllerBase_OnQuit},
    {sipName_Quit, meth_wxHelpControllerBase_Quit, METH_VARARGS, doc_wxHelpControllerBase_Quit},
    {sipName_SetFrameParameters, SIP_MLMETH_CAST(meth_wxHelpControllerBase_SetFrameParameters), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_SetFrameParameters},
    {sipName_SetParentWindow, SIP_MLMETH_CAST(meth_wxHelpControllerBase_SetParentWindow), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_SetParentWindow},
    {sipName_SetViewer, SIP_MLMETH_CAST(meth_wxHelpControllerBase_SetViewer), METH_VARARGS|METH_KEYWORDS, doc_wxHelpControllerBase_SetViewer}
};

sipVariableDef variables_wxHelpControllerBase[] = {
    {PropertyVariable, sipName_ParentWindow, &methods_wxHelpControllerBase[6], &methods_wxHelpControllerBase[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FrameParameters, &methods_wxHelpControllerBase[5], &methods_wxHelpControllerBase[12], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxHelpControllerBase, "HelpControllerBase(parentWindow=None)\n"
"\n"
"This is the abstract base class a family of classes by which\n"
"applications may invoke a help viewer to provide on-line help.");


sipClassTypeDef sipTypeDef__core_wxHelpControllerBase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHelpControllerBase,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_HelpControllerBase,
        {0, 0, 1},
        15, methods_wxHelpControllerBase,
        0, SIP_NULLPTR,
        2, variables_wxHelpControllerBase,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHelpControllerBase,
    -1,
    -1,
    supers_wxHelpControllerBase,
    SIP_NULLPTR,
    init_type_wxHelpControllerBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxHelpControllerBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxHelpControllerBase,
    cast_wxHelpControllerBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
