/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/graphics.h>
        #include <wx/graphics.h>
        #include <wx/geometry.h>
        #include <wx/geometry.h>
        #include <wx/graphics.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxGraphicsPath_AddArc, "AddArc(x, y, r, startAngle, endAngle, clockwise)\n"
"AddArc(c, r, startAngle, endAngle, clockwise)\n"
"\n"
"Adds an arc of a circle.\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_AddArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble r;
         ::wxDouble startAngle;
         ::wxDouble endAngle;
        bool clockwise;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_r,
            sipName_startAngle,
            sipName_endAngle,
            sipName_clockwise,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdddddb", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &r, &startAngle, &endAngle, &clockwise))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArc(x,y,r,startAngle,endAngle,clockwise);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* c;
        int cState = 0;
         ::wxDouble r;
         ::wxDouble startAngle;
         ::wxDouble endAngle;
        bool clockwise;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
            sipName_r,
            sipName_startAngle,
            sipName_endAngle,
            sipName_clockwise,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1dddb", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &c, &cState, &r, &startAngle, &endAngle, &clockwise))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArc(*c,r,startAngle,endAngle,clockwise);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(c), sipType_wxPoint2DDouble, cState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddArc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddArcToPoint, "AddArcToPoint(x1, y1, x2, y2, r)\n"
"\n"
"Adds an arc (of a circle with radius r) that is tangent to the line\n"
"connecting current point and (x1, y1) and to the line connecting (x1,\n"
"y1) and (x2, y2).");

extern "C" {static PyObject *meth_wxGraphicsPath_AddArcToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddArcToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x1;
         ::wxDouble y1;
         ::wxDouble x2;
         ::wxDouble y2;
         ::wxDouble r;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_r,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bddddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x1, &y1, &x2, &y2, &r))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArcToPoint(x1,y1,x2,y2,r);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddArcToPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddCircle, "AddCircle(x, y, r)\n"
"\n"
"Appends a circle around (x,y) with radius r as a new closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddCircle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddCircle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble r;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_r,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &r))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddCircle(x,y,r);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddCircle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddCurveToPoint, "AddCurveToPoint(cx1, cy1, cx2, cy2, x, y)\n"
"AddCurveToPoint(c1, c2, e)\n"
"\n"
"Adds a cubic bezier curve from the current point, using two control\n"
"points and an end point.\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_AddCurveToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddCurveToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble cx1;
         ::wxDouble cy1;
         ::wxDouble cx2;
         ::wxDouble cy2;
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cx1,
            sipName_cy1,
            sipName_cx2,
            sipName_cy2,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdddddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &cx1, &cy1, &cx2, &cy2, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddCurveToPoint(cx1,cy1,cx2,cy2,x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* c1;
        int c1State = 0;
        const  ::wxPoint2D* c2;
        int c2State = 0;
        const  ::wxPoint2D* e;
        int eState = 0;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c1,
            sipName_c2,
            sipName_e,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &c1, &c1State, sipType_wxPoint2DDouble, &c2, &c2State, sipType_wxPoint2DDouble, &e, &eState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddCurveToPoint(*c1,*c2,*e);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(c1), sipType_wxPoint2DDouble, c1State);
            sipReleaseType(const_cast< ::wxPoint2D *>(c2), sipType_wxPoint2DDouble, c2State);
            sipReleaseType(const_cast< ::wxPoint2D *>(e), sipType_wxPoint2DDouble, eState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddCurveToPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddEllipse, "AddEllipse(x, y, w, h)\n"
"\n"
"Appends an ellipse fitting into the passed in rectangle as a new\n"
"closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddEllipse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddEllipse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddEllipse(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddEllipse, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddLineToPoint, "AddLineToPoint(x, y)\n"
"AddLineToPoint(p)\n"
"\n"
"Adds a straight line from the current point to (x,y).\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_AddLineToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddLineToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddLineToPoint(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* p;
        int pState = 0;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddLineToPoint(*p);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(p), sipType_wxPoint2DDouble, pState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddLineToPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddPath, "AddPath(path)\n"
"\n"
"Adds another path onto the current path.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxGraphicsPath* path;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxGraphicsPath, &path))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddPath(*path);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddPath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddQuadCurveToPoint, "AddQuadCurveToPoint(cx, cy, x, y)\n"
"\n"
"Adds a quadratic bezier curve from the current point, using a control\n"
"point and an end point.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddQuadCurveToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddQuadCurveToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble cx;
         ::wxDouble cy;
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cx,
            sipName_cy,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &cx, &cy, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddQuadCurveToPoint(cx,cy,x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddQuadCurveToPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddRectangle, "AddRectangle(x, y, w, h)\n"
"\n"
"Appends a rectangle as a new closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddRectangle(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddRectangle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_AddRoundedRectangle, "AddRoundedRectangle(x, y, w, h, radius)\n"
"\n"
"Appends a rounded rectangle as a new closed subpath.");

extern "C" {static PyObject *meth_wxGraphicsPath_AddRoundedRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_AddRoundedRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxDouble radius;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bddddd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, &w, &h, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddRoundedRectangle(x,y,w,h,radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_AddRoundedRectangle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_CloseSubpath, "CloseSubpath()\n"
"\n"
"Closes the current sub-path.");

extern "C" {static PyObject *meth_wxGraphicsPath_CloseSubpath(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_CloseSubpath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CloseSubpath();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_CloseSubpath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_Contains, "Contains(c, fillStyle=ODDEVEN_RULE) -> bool\n"
"Contains(x, y, fillStyle=ODDEVEN_RULE) -> bool\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_Contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_Contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPoint2D* c;
        int cState = 0;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
        const  ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &c, &cState, sipType_wxPolygonFillMode, &fillStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*c,fillStyle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(c), sipType_wxPoint2DDouble, cState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
        const  ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd|E", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y, sipType_wxPolygonFillMode, &fillStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(x,y,fillStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_Contains, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_GetBox, "GetBox() -> Rect2D\n"
"\n"
"Gets the bounding box enclosing all points (possibly including control\n"
"points).");

extern "C" {static PyObject *meth_wxGraphicsPath_GetBox(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_GetBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
             ::wxRect2D*sipRes;
        if (sipCpp->IsNull()) {
            wxPyErr_SetString(PyExc_ValueError, "The GraphicsPath is not valid (likely an uninitialized or null instance)");
            return NULL;
        }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect2D(sipCpp->GetBox());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect2DDouble,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_GetBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_GetCurrentPoint, "GetCurrentPoint() -> Point2D\n"
"\n"
"Gets the last point of the current path, (0,0) if not yet set.");

extern "C" {static PyObject *meth_wxGraphicsPath_GetCurrentPoint(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_GetCurrentPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
             ::wxPoint2D*sipRes;
        if (sipCpp->IsNull()) {
            wxPyErr_SetString(PyExc_ValueError, "The GraphicsPath is not valid (likely an uninitialized or null instance)");
            return NULL;
        }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint2D(sipCpp->GetCurrentPoint());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint2DDouble,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_GetCurrentPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_GetNativePath, "GetNativePath() -> void\n"
"\n"
"Returns the native path (CGPathRef for Core Graphics, Path pointer for\n"
"GDIPlus and a cairo_path_t pointer for cairo).");

extern "C" {static PyObject *meth_wxGraphicsPath_GetNativePath(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_GetNativePath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxGraphicsPath *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsPath, &sipCpp))
        {
            void*sipRes;
        if (sipCpp->IsNull()) {
            wxPyErr_SetString(PyExc_ValueError, "The GraphicsPath is not valid (likely an uninitialized or null instance)");
            return NULL;
        }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNativePath();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_GetNativePath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_MoveToPoint, "MoveToPoint(x, y)\n"
"MoveToPoint(p)\n"
"\n"
"Begins a new subpath at (x,y).\n"
"");

extern "C" {static PyObject *meth_wxGraphicsPath_MoveToPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_MoveToPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MoveToPoint(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPoint2D* p;
        int pState = 0;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MoveToPoint(*p);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2D *>(p), sipType_wxPoint2DDouble, pState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_MoveToPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_Transform, "Transform(matrix)\n"
"\n"
"Transforms each point of this path by the matrix.");

extern "C" {static PyObject *meth_wxGraphicsPath_Transform(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_Transform(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxGraphicsMatrix* matrix;
         ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxGraphicsPath, &sipCpp, sipType_wxGraphicsMatrix, &matrix))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Transform(*matrix);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_Transform, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsPath_UnGetNativePath, "UnGetNativePath(p)\n"
"\n"
"Gives back the native path returned by GetNativePath() because there\n"
"might be some deallocations necessary (e.g.");

extern "C" {static PyObject *meth_wxGraphicsPath_UnGetNativePath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsPath_UnGetNativePath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        void* p;
        const  ::wxGraphicsPath *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv", &sipSelf, sipType_wxGraphicsPath, &sipCpp, &p))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->UnGetNativePath(p);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsPath, sipName_UnGetNativePath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGraphicsPath(void *, const sipTypeDef *);}
static void *cast_wxGraphicsPath(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxGraphicsPath *sipCpp = reinterpret_cast< ::wxGraphicsPath *>(sipCppV);

    if (targetType == sipType_wxGraphicsPath)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGraphicsObject)->ctd_cast(static_cast< ::wxGraphicsObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGraphicsPath(void *, int);}
static void release_wxGraphicsPath(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGraphicsPath *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGraphicsPath(Py_ssize_t);}
static void *array_wxGraphicsPath(Py_ssize_t sipNrElem)
{
    return new  ::wxGraphicsPath[sipNrElem];
}


extern "C" {static void assign_wxGraphicsPath(void *, Py_ssize_t, void *);}
static void assign_wxGraphicsPath(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxGraphicsPath *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxGraphicsPath *>(sipSrc);
}


extern "C" {static void *copy_wxGraphicsPath(const void *, Py_ssize_t);}
static void *copy_wxGraphicsPath(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxGraphicsPath(reinterpret_cast<const  ::wxGraphicsPath *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGraphicsPath(sipSimpleWrapper *);}
static void dealloc_wxGraphicsPath(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGraphicsPath(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGraphicsPath(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGraphicsPath(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxGraphicsPath *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGraphicsPath();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxGraphicsPath* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxGraphicsPath, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGraphicsPath(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGraphicsPath[] = {{244, 255, 1}};


static PyMethodDef methods_wxGraphicsPath[] = {
    {sipName_AddArc, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddArc), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddArc},
    {sipName_AddArcToPoint, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddArcToPoint), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddArcToPoint},
    {sipName_AddCircle, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddCircle), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddCircle},
    {sipName_AddCurveToPoint, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddCurveToPoint), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddCurveToPoint},
    {sipName_AddEllipse, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddEllipse), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddEllipse},
    {sipName_AddLineToPoint, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddLineToPoint), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddLineToPoint},
    {sipName_AddPath, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddPath), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddPath},
    {sipName_AddQuadCurveToPoint, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddQuadCurveToPoint), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddQuadCurveToPoint},
    {sipName_AddRectangle, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddRectangle), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddRectangle},
    {sipName_AddRoundedRectangle, SIP_MLMETH_CAST(meth_wxGraphicsPath_AddRoundedRectangle), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_AddRoundedRectangle},
    {sipName_CloseSubpath, meth_wxGraphicsPath_CloseSubpath, METH_VARARGS, doc_wxGraphicsPath_CloseSubpath},
    {sipName_Contains, SIP_MLMETH_CAST(meth_wxGraphicsPath_Contains), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_Contains},
    {sipName_GetBox, meth_wxGraphicsPath_GetBox, METH_VARARGS, doc_wxGraphicsPath_GetBox},
    {sipName_GetCurrentPoint, meth_wxGraphicsPath_GetCurrentPoint, METH_VARARGS, doc_wxGraphicsPath_GetCurrentPoint},
    {sipName_GetNativePath, meth_wxGraphicsPath_GetNativePath, METH_VARARGS, doc_wxGraphicsPath_GetNativePath},
    {sipName_MoveToPoint, SIP_MLMETH_CAST(meth_wxGraphicsPath_MoveToPoint), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_MoveToPoint},
    {sipName_Transform, SIP_MLMETH_CAST(meth_wxGraphicsPath_Transform), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_Transform},
    {sipName_UnGetNativePath, SIP_MLMETH_CAST(meth_wxGraphicsPath_UnGetNativePath), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsPath_UnGetNativePath}
};

sipVariableDef variables_wxGraphicsPath[] = {
    {PropertyVariable, sipName_NativePath, &methods_wxGraphicsPath[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CurrentPoint, &methods_wxGraphicsPath[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Box, &methods_wxGraphicsPath[12], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxGraphicsPath, "A wxGraphicsPath is a native representation of a geometric path.");


sipClassTypeDef sipTypeDef__core_wxGraphicsPath = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxGraphicsPath,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_GraphicsPath,
        {0, 0, 1},
        18, methods_wxGraphicsPath,
        0, SIP_NULLPTR,
        3, variables_wxGraphicsPath,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGraphicsPath,
    -1,
    -1,
    supers_wxGraphicsPath,
    SIP_NULLPTR,
    init_type_wxGraphicsPath,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGraphicsPath,
    assign_wxGraphicsPath,
    array_wxGraphicsPath,
    copy_wxGraphicsPath,
    release_wxGraphicsPath,
    cast_wxGraphicsPath,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
