/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/datetime.h>
            #include <wx/datetime.h>
        #include <wx/datetime.h>


PyDoc_STRVAR(doc_wxDateTime_TimeZone_IsLocal, "IsLocal() -> bool\n"
"\n"
"Return true if this is the local time zone.");

extern "C" {static PyObject *meth_wxDateTime_TimeZone_IsLocal(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_TimeZone_IsLocal(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDateTime::TimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime_TimeZone, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsLocal();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeZone, sipName_IsLocal, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateTime_TimeZone_GetOffset, "GetOffset() -> long\n"
"\n"
"Return the offset of this time zone from UTC, in seconds.");

extern "C" {static PyObject *meth_wxDateTime_TimeZone_GetOffset(PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_TimeZone_GetOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDateTime::TimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDateTime_TimeZone, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOffset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeZone, sipName_GetOffset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDateTime_TimeZone_Make, "Make(offset) -> DateTime.TimeZone\n"
"\n"
"Create a time zone with the given offset in seconds.");

extern "C" {static PyObject *meth_wxDateTime_TimeZone_Make(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDateTime_TimeZone_Make(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long offset;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &offset))
        {
             ::wxDateTime::TimeZone*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime::TimeZone( ::wxDateTime::TimeZone::Make(offset));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime_TimeZone,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TimeZone, sipName_Make, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDateTime_TimeZone(void *, int);}
static void release_wxDateTime_TimeZone(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDateTime::TimeZone *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxDateTime_TimeZone(Py_ssize_t);}
static void *array_wxDateTime_TimeZone(Py_ssize_t sipNrElem)
{
    return new  ::wxDateTime::TimeZone[sipNrElem];
}


extern "C" {static void assign_wxDateTime_TimeZone(void *, Py_ssize_t, void *);}
static void assign_wxDateTime_TimeZone(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxDateTime::TimeZone *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxDateTime::TimeZone *>(sipSrc);
}


extern "C" {static void *copy_wxDateTime_TimeZone(const void *, Py_ssize_t);}
static void *copy_wxDateTime_TimeZone(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxDateTime::TimeZone(reinterpret_cast<const  ::wxDateTime::TimeZone *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxDateTime_TimeZone(sipSimpleWrapper *);}
static void dealloc_wxDateTime_TimeZone(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDateTime_TimeZone(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDateTime_TimeZone(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDateTime_TimeZone(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxDateTime::TimeZone *sipCpp = SIP_NULLPTR;

    {
         ::wxDateTime::TZ tz;

        static const char *sipKwdList[] = {
            sipName_tz,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E", sipType_wxDateTime_TZ, &tz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime::TimeZone(tz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        long offset = 0;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|l", &offset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime::TimeZone(offset);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxDateTime::TimeZone* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxDateTime_TimeZone, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDateTime::TimeZone(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxDateTime_TimeZone[] = {
    {sipName_GetOffset, meth_wxDateTime_TimeZone_GetOffset, METH_VARARGS, doc_wxDateTime_TimeZone_GetOffset},
    {sipName_IsLocal, meth_wxDateTime_TimeZone_IsLocal, METH_VARARGS, doc_wxDateTime_TimeZone_IsLocal},
    {sipName_Make, SIP_MLMETH_CAST(meth_wxDateTime_TimeZone_Make), METH_VARARGS|METH_KEYWORDS, doc_wxDateTime_TimeZone_Make}
};

sipVariableDef variables_wxDateTime_TimeZone[] = {
    {PropertyVariable, sipName_Offset, &methods_wxDateTime_TimeZone[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxDateTime_TimeZone, "TimeZone(tz)\n"
"TimeZone(offset=0)\n"
"\n"
"Class representing a time zone.");


sipClassTypeDef sipTypeDef__core_wxDateTime_TimeZone = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxDateTime__TimeZone,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_TimeZone,
        {119, 255, 0},
        3, methods_wxDateTime_TimeZone,
        0, SIP_NULLPTR,
        1, variables_wxDateTime_TimeZone,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDateTime_TimeZone,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxDateTime_TimeZone,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDateTime_TimeZone,
    assign_wxDateTime_TimeZone,
    array_wxDateTime_TimeZone,
    copy_wxDateTime_TimeZone,
    release_wxDateTime_TimeZone,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
