/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/cursor.h>
        #include <wx/image.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    int _wxCursor___nonzero__(wxCursor* self)
    {
        return self->IsOk();
    }
    int _wxCursor___bool__(wxCursor* self)
    {
        return self->IsOk();
    }
    long _wxCursor_GetHandle(wxCursor* self)
    {
        #ifdef __WXMSW__
            return HandleToLong(self->GetHandle());
        #else
            return 0;
        #endif
    }
    void _wxCursor_SetHandle(wxCursor* self, long handle)
    {
        #ifdef __WXMSW__
            self->SetHandle((WXHANDLE)LongToHandle(handle));
        #endif
    }
    void _wxCursor__copyFrom(wxCursor* self, const wxCursor* other)
    {
        *self = *other;
    }


class sipwxCursor : public  ::wxCursor
{
public:
    sipwxCursor();
    sipwxCursor(const  ::wxString&, ::wxBitmapType,int,int);
    sipwxCursor( ::wxStockCursor);
    sipwxCursor(const  ::wxImage&);
    sipwxCursor(const  ::wxCursor&);
    virtual ~sipwxCursor();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool IsOk() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxCursor(const sipwxCursor &);
    sipwxCursor &operator = (const sipwxCursor &);

    char sipPyMethods[1];
};

sipwxCursor::sipwxCursor():  ::wxCursor(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCursor::sipwxCursor(const  ::wxString& cursorName, ::wxBitmapType type,int hotSpotX,int hotSpotY):  ::wxCursor(cursorName,type,hotSpotX,hotSpotY), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCursor::sipwxCursor( ::wxStockCursor cursorId):  ::wxCursor(cursorId), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCursor::sipwxCursor(const  ::wxImage& image):  ::wxCursor(image), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCursor::sipwxCursor(const  ::wxCursor& cursor):  ::wxCursor(cursor), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCursor::~sipwxCursor()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxCursor::IsOk() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsOk);

    if (!sipMeth)
        return  ::wxCursor::IsOk();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxCursor_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if cursor data is present.");

extern "C" {static PyObject *meth_wxCursor_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxCursor_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCursor::IsOk() : sipCpp->IsOk());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Cursor, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursor_GetHotSpot, "GetHotSpot() -> Point\n"
"\n"
"Returns the coordinates of the cursor hot spot.");

extern "C" {static PyObject *meth_wxCursor_GetHotSpot(PyObject *, PyObject *);}
static PyObject *meth_wxCursor_GetHotSpot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursor, &sipCpp))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->GetHotSpot());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Cursor, sipName_GetHotSpot, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursor___nonzero__, "__nonzero__() -> int");

extern "C" {static PyObject *meth_wxCursor___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxCursor___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursor, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxCursor___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Cursor, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursor_GetHandle, "GetHandle() -> long\n"
"\n"
"Get the handle for the Cursor.  Windows only.");

extern "C" {static PyObject *meth_wxCursor_GetHandle(PyObject *, PyObject *);}
static PyObject *meth_wxCursor_GetHandle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursor, &sipCpp))
        {
            long sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxCursor_GetHandle(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Cursor, sipName_GetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursor_SetHandle, "SetHandle(handle)\n"
"\n"
"Set the handle to use for this Cursor.  Windows only.");

extern "C" {static PyObject *meth_wxCursor_SetHandle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCursor_SetHandle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long handle;
         ::wxCursor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxCursor, &sipCpp, &handle))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxCursor_SetHandle(sipCpp, handle);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Cursor, sipName_SetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursor__copyFrom, "_copyFrom(other)\n"
"\n"
"For internal use only.");

extern "C" {static PyObject *meth_wxCursor__copyFrom(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCursor__copyFrom(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCursor* other;
         ::wxCursor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxCursor, &sipCpp, sipType_wxCursor, &other))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxCursor__copyFrom(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Cursor, sipName__copyFrom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxCursor___bool__(PyObject *);}
static int slot_wxCursor___bool__(PyObject *sipSelf)
{
     ::wxCursor *sipCpp = reinterpret_cast< ::wxCursor *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxCursor));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxCursor___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxCursor(void *, const sipTypeDef *);}
static void *cast_wxCursor(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxCursor *sipCpp = reinterpret_cast< ::wxCursor *>(sipCppV);

    if (targetType == sipType_wxCursor)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGDIObject)->ctd_cast(static_cast< ::wxGDIObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxCursor(void *, int);}
static void release_wxCursor(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxCursor *>(sipCppV);
    else
        delete reinterpret_cast< ::wxCursor *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxCursor(Py_ssize_t);}
static void *array_wxCursor(Py_ssize_t sipNrElem)
{
    return new  ::wxCursor[sipNrElem];
}


extern "C" {static void assign_wxCursor(void *, Py_ssize_t, void *);}
static void assign_wxCursor(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxCursor *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxCursor *>(sipSrc);
}


extern "C" {static void *copy_wxCursor(const void *, Py_ssize_t);}
static void *copy_wxCursor(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxCursor(reinterpret_cast<const  ::wxCursor *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxCursor(sipSimpleWrapper *);}
static void dealloc_wxCursor(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxCursor *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxCursor(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxCursor(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxCursor(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxCursor *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCursor();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxString* cursorName;
        int cursorNameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int hotSpotX = 0;
        int hotSpotY = 0;

        static const char *sipKwdList[] = {
            sipName_cursorName,
            sipName_type,
            sipName_hotSpotX,
            sipName_hotSpotY,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|Eii", sipType_wxString, &cursorName, &cursorNameState, sipType_wxBitmapType, &type, &hotSpotX, &hotSpotY))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCursor(*cursorName,type,hotSpotX,hotSpotY);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(cursorName), sipType_wxString, cursorNameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
         ::wxStockCursor cursorId;

        static const char *sipKwdList[] = {
            sipName_cursorId,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E", sipType_wxStockCursor, &cursorId))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCursor(cursorId);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxImage* image;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxImage, &image))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCursor(*image);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxCursor* cursor;

        static const char *sipKwdList[] = {
            sipName_cursor,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxCursor, &cursor))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCursor(*cursor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxCursor[] = {{226, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxCursor[] = {
    {(void *)slot_wxCursor___bool__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxCursor[] = {
    {sipName_GetHandle, meth_wxCursor_GetHandle, METH_VARARGS, doc_wxCursor_GetHandle},
    {sipName_GetHotSpot, meth_wxCursor_GetHotSpot, METH_VARARGS, doc_wxCursor_GetHotSpot},
    {sipName_IsOk, meth_wxCursor_IsOk, METH_VARARGS, doc_wxCursor_IsOk},
    {sipName_SetHandle, SIP_MLMETH_CAST(meth_wxCursor_SetHandle), METH_VARARGS|METH_KEYWORDS, doc_wxCursor_SetHandle},
    {sipName___nonzero__, meth_wxCursor___nonzero__, METH_VARARGS, doc_wxCursor___nonzero__},
    {sipName__copyFrom, SIP_MLMETH_CAST(meth_wxCursor__copyFrom), METH_VARARGS|METH_KEYWORDS, doc_wxCursor__copyFrom}
};

sipVariableDef variables_wxCursor[] = {
    {PropertyVariable, sipName_HotSpot, &methods_wxCursor[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Handle, &methods_wxCursor[0], &methods_wxCursor[3], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxCursor, "Cursor()\n"
"Cursor(cursorName, type=BITMAP_TYPE_ANY, hotSpotX=0, hotSpotY=0)\n"
"Cursor(cursorId)\n"
"Cursor(image)\n"
"Cursor(cursor)\n"
"\n"
"A cursor is a small bitmap usually used for denoting where the mouse\n"
"pointer is, with a picture that might indicate the interpretation of a\n"
"mouse click.");


sipClassTypeDef sipTypeDef__core_wxCursor = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxCursor,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_Cursor,
        {0, 0, 1},
        6, methods_wxCursor,
        0, SIP_NULLPTR,
        2, variables_wxCursor,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxCursor,
    -1,
    -1,
    supers_wxCursor,
    slots_wxCursor,
    init_type_wxCursor,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxCursor,
    assign_wxCursor,
    array_wxCursor,
    copy_wxCursor,
    release_wxCursor,
    cast_wxCursor,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
