/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/cmdproc.h>
        #include <wx/cmdproc.h>
        #include <wx/menu.h>
        
        typedef wxList wxCommandList;
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxCommandProcessor : public  ::wxCommandProcessor
{
public:
    sipwxCommandProcessor(int);
    virtual ~sipwxCommandProcessor();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool Undo() SIP_OVERRIDE;
    void Store( ::wxCommand*) SIP_OVERRIDE;
    bool Submit( ::wxCommand*,bool) SIP_OVERRIDE;
    void SetMenuStrings() SIP_OVERRIDE;
    bool Redo() SIP_OVERRIDE;
    bool IsDirty() const SIP_OVERRIDE;
    void Initialize() SIP_OVERRIDE;
    void ClearCommands() SIP_OVERRIDE;
    bool CanRedo() const SIP_OVERRIDE;
    bool CanUndo() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxCommandProcessor(const sipwxCommandProcessor &);
    sipwxCommandProcessor &operator = (const sipwxCommandProcessor &);

    char sipPyMethods[10];
};

sipwxCommandProcessor::sipwxCommandProcessor(int maxCommands):  ::wxCommandProcessor(maxCommands), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxCommandProcessor::~sipwxCommandProcessor()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxCommandProcessor::Undo()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_Undo);

    if (!sipMeth)
        return  ::wxCommandProcessor::Undo();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxCommandProcessor::Store( ::wxCommand*command)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_Store);

    if (!sipMeth)
    {
         ::wxCommandProcessor::Store(command);
        return;
    }

    extern void sipVH__core_241(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxCommand*);

    sipVH__core_241(sipGILState, 0, sipPySelf, sipMeth, command);
}

bool sipwxCommandProcessor::Submit( ::wxCommand*command,bool storeIt)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_Submit);

    if (!sipMeth)
        return  ::wxCommandProcessor::Submit(command,storeIt);

    extern bool sipVH__core_240(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxCommand*,bool);

    return sipVH__core_240(sipGILState, 0, sipPySelf, sipMeth, command, storeIt);
}

void sipwxCommandProcessor::SetMenuStrings()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_SetMenuStrings);

    if (!sipMeth)
    {
         ::wxCommandProcessor::SetMenuStrings();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::Redo()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_Redo);

    if (!sipMeth)
        return  ::wxCommandProcessor::Redo();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::IsDirty() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsDirty);

    if (!sipMeth)
        return  ::wxCommandProcessor::IsDirty();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxCommandProcessor::Initialize()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_Initialize);

    if (!sipMeth)
    {
         ::wxCommandProcessor::Initialize();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxCommandProcessor::ClearCommands()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_ClearCommands);

    if (!sipMeth)
    {
         ::wxCommandProcessor::ClearCommands();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::CanRedo() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_CanRedo);

    if (!sipMeth)
        return  ::wxCommandProcessor::CanRedo();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxCommandProcessor::CanUndo() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_CanUndo);

    if (!sipMeth)
        return  ::wxCommandProcessor::CanUndo();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxCommandProcessor_CanUndo, "CanUndo() -> bool\n"
"\n"
"Returns true if the currently-active command can be undone, false\n"
"otherwise.");

extern "C" {static PyObject *meth_wxCommandProcessor_CanUndo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_CanUndo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::CanUndo() : sipCpp->CanUndo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_CanUndo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_CanRedo, "CanRedo() -> bool\n"
"\n"
"Returns true if the currently-active command can be redone, false\n"
"otherwise.");

extern "C" {static PyObject *meth_wxCommandProcessor_CanRedo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_CanRedo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::CanRedo() : sipCpp->CanRedo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_CanRedo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_ClearCommands, "ClearCommands()\n"
"\n"
"Deletes all commands in the list and sets the current command pointer\n"
"to NULL.");

extern "C" {static PyObject *meth_wxCommandProcessor_ClearCommands(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_ClearCommands(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::ClearCommands() : sipCpp->ClearCommands());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_ClearCommands, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetCommands, "GetCommands() -> CommandList\n"
"\n"
"Returns the list of commands.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetCommands(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetCommands(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxCommandList*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetCommands();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxCommandList,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetCommands, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetCurrentCommand, "GetCurrentCommand() -> Command\n"
"\n"
"Returns the current command.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetCurrentCommand(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetCurrentCommand(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxCommand*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCurrentCommand();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxCommand,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetCurrentCommand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetEditMenu, "GetEditMenu() -> Menu\n"
"\n"
"Returns the edit menu associated with the command processor.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetEditMenu(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetEditMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEditMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetEditMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetMaxCommands, "GetMaxCommands() -> int\n"
"\n"
"Returns the maximum number of commands that the command processor\n"
"stores.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetMaxCommands(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetMaxCommands(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaxCommands();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetMaxCommands, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetRedoAccelerator, "GetRedoAccelerator() -> String\n"
"\n"
"Returns the string that will be appended to the Redo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetRedoAccelerator(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetRedoAccelerator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetRedoAccelerator());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetRedoAccelerator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetRedoMenuLabel, "GetRedoMenuLabel() -> String\n"
"\n"
"Returns the string that will be shown for the redo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetRedoMenuLabel(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetRedoMenuLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetRedoMenuLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetRedoMenuLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetUndoAccelerator, "GetUndoAccelerator() -> String\n"
"\n"
"Returns the string that will be appended to the Undo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetUndoAccelerator(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetUndoAccelerator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetUndoAccelerator());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetUndoAccelerator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_GetUndoMenuLabel, "GetUndoMenuLabel() -> String\n"
"\n"
"Returns the string that will be shown for the undo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_GetUndoMenuLabel(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_GetUndoMenuLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetUndoMenuLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_GetUndoMenuLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Initialize, "Initialize()\n"
"\n"
"Initializes the command processor, setting the current command to the\n"
"last in the list (if any), and updating the edit menu (if one has been\n"
"specified).");

extern "C" {static PyObject *meth_wxCommandProcessor_Initialize(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Initialize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Initialize() : sipCpp->Initialize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Initialize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_IsDirty, "IsDirty() -> bool\n"
"\n"
"Returns a boolean value that indicates if changes have been made since\n"
"the last save operation.");

extern "C" {static PyObject *meth_wxCommandProcessor_IsDirty(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_IsDirty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::IsDirty() : sipCpp->IsDirty());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_IsDirty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_MarkAsSaved, "MarkAsSaved()\n"
"\n"
"You must call this method whenever the project is saved if you plan to\n"
"use IsDirty().");

extern "C" {static PyObject *meth_wxCommandProcessor_MarkAsSaved(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_MarkAsSaved(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MarkAsSaved();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_MarkAsSaved, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Redo, "Redo() -> bool\n"
"\n"
"Executes (redoes) the current command (the command that has just been\n"
"undone if any).");

extern "C" {static PyObject *meth_wxCommandProcessor_Redo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Redo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Redo() : sipCpp->Redo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Redo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetEditMenu, "SetEditMenu(menu)\n"
"\n"
"Tells the command processor to update the Undo and Redo items on this\n"
"menu as appropriate.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetEditMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetEditMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMenu* menu;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxMenu, &menu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEditMenu(menu);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetEditMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetMenuStrings, "SetMenuStrings()\n"
"\n"
"Sets the menu labels according to the currently set menu and the\n"
"current command state.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetMenuStrings(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetMenuStrings(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::SetMenuStrings() : sipCpp->SetMenuStrings());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetMenuStrings, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetRedoAccelerator, "SetRedoAccelerator(accel)\n"
"\n"
"Sets the string that will be appended to the Redo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetRedoAccelerator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetRedoAccelerator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* accel;
        int accelState = 0;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxString, &accel, &accelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRedoAccelerator(*accel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(accel), sipType_wxString, accelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetRedoAccelerator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_SetUndoAccelerator, "SetUndoAccelerator(accel)\n"
"\n"
"Sets the string that will be appended to the Undo menu item.");

extern "C" {static PyObject *meth_wxCommandProcessor_SetUndoAccelerator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_SetUndoAccelerator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* accel;
        int accelState = 0;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxString, &accel, &accelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUndoAccelerator(*accel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(accel), sipType_wxString, accelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_SetUndoAccelerator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Submit, "Submit(command, storeIt=True) -> bool\n"
"\n"
"Submits a new command to the command processor.");

extern "C" {static PyObject *meth_wxCommandProcessor_Submit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Submit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommand* command;
        bool storeIt = 1;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_command,
            sipName_storeIt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:|b", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxCommand, &command, &storeIt))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Submit(command,storeIt) : sipCpp->Submit(command,storeIt));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Submit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Store, "Store(command)\n"
"\n"
"Just store the command without executing it.");

extern "C" {static PyObject *meth_wxCommandProcessor_Store(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Store(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommand* command;
         ::wxCommandProcessor *sipCpp;

        static const char *sipKwdList[] = {
            sipName_command,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxCommandProcessor, &sipCpp, sipType_wxCommand, &command))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Store(command) : sipCpp->Store(command));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Store, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCommandProcessor_Undo, "Undo() -> bool\n"
"\n"
"Undoes the last command executed.");

extern "C" {static PyObject *meth_wxCommandProcessor_Undo(PyObject *, PyObject *);}
static PyObject *meth_wxCommandProcessor_Undo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxCommandProcessor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCommandProcessor, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxCommandProcessor::Undo() : sipCpp->Undo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CommandProcessor, sipName_Undo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxCommandProcessor(void *, const sipTypeDef *);}
static void *cast_wxCommandProcessor(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxCommandProcessor *sipCpp = reinterpret_cast< ::wxCommandProcessor *>(sipCppV);

    if (targetType == sipType_wxCommandProcessor)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxCommandProcessor(void *, int);}
static void release_wxCommandProcessor(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxCommandProcessor *>(sipCppV);
    else
        delete reinterpret_cast< ::wxCommandProcessor *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxCommandProcessor(Py_ssize_t);}
static void *array_wxCommandProcessor(Py_ssize_t sipNrElem)
{
    return new  ::wxCommandProcessor[sipNrElem];
}


extern "C" {static void dealloc_wxCommandProcessor(sipSimpleWrapper *);}
static void dealloc_wxCommandProcessor(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxCommandProcessor *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxCommandProcessor(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxCommandProcessor(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxCommandProcessor(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxCommandProcessor *sipCpp = SIP_NULLPTR;

    {
        int maxCommands = -1;

        static const char *sipKwdList[] = {
            sipName_maxCommands,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &maxCommands))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxCommandProcessor(maxCommands);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxCommandProcessor[] = {{390, 255, 1}};


static PyMethodDef methods_wxCommandProcessor[] = {
    {sipName_CanRedo, meth_wxCommandProcessor_CanRedo, METH_VARARGS, doc_wxCommandProcessor_CanRedo},
    {sipName_CanUndo, meth_wxCommandProcessor_CanUndo, METH_VARARGS, doc_wxCommandProcessor_CanUndo},
    {sipName_ClearCommands, meth_wxCommandProcessor_ClearCommands, METH_VARARGS, doc_wxCommandProcessor_ClearCommands},
    {sipName_GetCommands, meth_wxCommandProcessor_GetCommands, METH_VARARGS, doc_wxCommandProcessor_GetCommands},
    {sipName_GetCurrentCommand, meth_wxCommandProcessor_GetCurrentCommand, METH_VARARGS, doc_wxCommandProcessor_GetCurrentCommand},
    {sipName_GetEditMenu, meth_wxCommandProcessor_GetEditMenu, METH_VARARGS, doc_wxCommandProcessor_GetEditMenu},
    {sipName_GetMaxCommands, meth_wxCommandProcessor_GetMaxCommands, METH_VARARGS, doc_wxCommandProcessor_GetMaxCommands},
    {sipName_GetRedoAccelerator, meth_wxCommandProcessor_GetRedoAccelerator, METH_VARARGS, doc_wxCommandProcessor_GetRedoAccelerator},
    {sipName_GetRedoMenuLabel, meth_wxCommandProcessor_GetRedoMenuLabel, METH_VARARGS, doc_wxCommandProcessor_GetRedoMenuLabel},
    {sipName_GetUndoAccelerator, meth_wxCommandProcessor_GetUndoAccelerator, METH_VARARGS, doc_wxCommandProcessor_GetUndoAccelerator},
    {sipName_GetUndoMenuLabel, meth_wxCommandProcessor_GetUndoMenuLabel, METH_VARARGS, doc_wxCommandProcessor_GetUndoMenuLabel},
    {sipName_Initialize, meth_wxCommandProcessor_Initialize, METH_VARARGS, doc_wxCommandProcessor_Initialize},
    {sipName_IsDirty, meth_wxCommandProcessor_IsDirty, METH_VARARGS, doc_wxCommandProcessor_IsDirty},
    {sipName_MarkAsSaved, meth_wxCommandProcessor_MarkAsSaved, METH_VARARGS, doc_wxCommandProcessor_MarkAsSaved},
    {sipName_Redo, meth_wxCommandProcessor_Redo, METH_VARARGS, doc_wxCommandProcessor_Redo},
    {sipName_SetEditMenu, SIP_MLMETH_CAST(meth_wxCommandProcessor_SetEditMenu), METH_VARARGS|METH_KEYWORDS, doc_wxCommandProcessor_SetEditMenu},
    {sipName_SetMenuStrings, meth_wxCommandProcessor_SetMenuStrings, METH_VARARGS, doc_wxCommandProcessor_SetMenuStrings},
    {sipName_SetRedoAccelerator, SIP_MLMETH_CAST(meth_wxCommandProcessor_SetRedoAccelerator), METH_VARARGS|METH_KEYWORDS, doc_wxCommandProcessor_SetRedoAccelerator},
    {sipName_SetUndoAccelerator, SIP_MLMETH_CAST(meth_wxCommandProcessor_SetUndoAccelerator), METH_VARARGS|METH_KEYWORDS, doc_wxCommandProcessor_SetUndoAccelerator},
    {sipName_Store, SIP_MLMETH_CAST(meth_wxCommandProcessor_Store), METH_VARARGS|METH_KEYWORDS, doc_wxCommandProcessor_Store},
    {sipName_Submit, SIP_MLMETH_CAST(meth_wxCommandProcessor_Submit), METH_VARARGS|METH_KEYWORDS, doc_wxCommandProcessor_Submit},
    {sipName_Undo, meth_wxCommandProcessor_Undo, METH_VARARGS, doc_wxCommandProcessor_Undo}
};

sipVariableDef variables_wxCommandProcessor[] = {
    {PropertyVariable, sipName_UndoMenuLabel, &methods_wxCommandProcessor[10], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_UndoAccelerator, &methods_wxCommandProcessor[9], &methods_wxCommandProcessor[18], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RedoMenuLabel, &methods_wxCommandProcessor[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RedoAccelerator, &methods_wxCommandProcessor[7], &methods_wxCommandProcessor[17], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MaxCommands, &methods_wxCommandProcessor[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EditMenu, &methods_wxCommandProcessor[5], &methods_wxCommandProcessor[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CurrentCommand, &methods_wxCommandProcessor[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Commands, &methods_wxCommandProcessor[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxCommandProcessor, "CommandProcessor(maxCommands=-1)\n"
"\n"
"wxCommandProcessor is a class that maintains a history of wxCommands,\n"
"with undo/redo functionality built-in.");


sipClassTypeDef sipTypeDef__core_wxCommandProcessor = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxCommandProcessor,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_CommandProcessor,
        {0, 0, 1},
        22, methods_wxCommandProcessor,
        0, SIP_NULLPTR,
        8, variables_wxCommandProcessor,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxCommandProcessor,
    -1,
    -1,
    supers_wxCommandProcessor,
    SIP_NULLPTR,
    init_type_wxCommandProcessor,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxCommandProcessor,
    SIP_NULLPTR,
    array_wxCommandProcessor,
    SIP_NULLPTR,
    release_wxCommandProcessor,
    cast_wxCommandProcessor,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
