/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"
        #include <wx/calctrl.h>
        #include <wx/colour.h>
        #include <wx/font.h>


PyDoc_STRVAR(doc_wxCalendarDateAttr_GetBackgroundColour, "GetBackgroundColour() -> wx.Colour\n"
"\n"
"Returns the background colour set for the calendar date.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetBackgroundColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_GetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_GetBorder, "GetBorder() -> CalendarDateBorder\n"
"\n"
"Returns the border set for the calendar date.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_GetBorder(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_GetBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
             ::wxCalendarDateBorder sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxCalendarDateBorder);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_GetBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_GetBorderColour, "GetBorderColour() -> wx.Colour\n"
"\n"
"Returns the border colour set for the calendar date.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_GetBorderColour(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_GetBorderColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetBorderColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_GetBorderColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_GetFont, "GetFont() -> wx.Font\n"
"\n"
"Returns the font set for the calendar date.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_GetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_GetTextColour, "GetTextColour() -> wx.Colour\n"
"\n"
"Returns the text colour set for the calendar date.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetTextColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_GetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_HasBackgroundColour, "HasBackgroundColour() -> bool\n"
"\n"
"Returns true if a non-default text background colour is set.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_HasBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_HasBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBackgroundColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_HasBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_HasBorder, "HasBorder() -> bool\n"
"\n"
"Returns true if a non-default (i.e. any) border is set.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_HasBorder(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_HasBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_HasBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_HasBorderColour, "HasBorderColour() -> bool\n"
"\n"
"Returns true if a non-default border colour is set.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_HasBorderColour(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_HasBorderColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBorderColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_HasBorderColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_HasFont, "HasFont() -> bool\n"
"\n"
"Returns true if a non-default font is set.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_HasFont(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_HasFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_HasFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_HasTextColour, "HasTextColour() -> bool\n"
"\n"
"Returns true if a non-default text foreground colour is set.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_HasTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_HasTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTextColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_HasTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_IsHoliday, "IsHoliday() -> bool\n"
"\n"
"Returns true if this calendar day is displayed as a holiday.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_IsHoliday(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_IsHoliday(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsHoliday();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_IsHoliday, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetBackgroundColour, "SetBackgroundColour(colBack)\n"
"\n"
"Sets the text background colour to use.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colBack;
        int colBackState = 0;
         ::wxCalendarDateAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colBack,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp, sipType_wxColour, &colBack, &colBackState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundColour(*colBack);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colBack), sipType_wxColour, colBackState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetBorder, "SetBorder(border)\n"
"\n"
"Sets the border to use.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetBorder(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetBorder(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCalendarDateBorder border;
         ::wxCalendarDateAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_border,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp, sipType_wxCalendarDateBorder, &border))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBorder(border);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetBorderColour, "SetBorderColour(col)\n"
"\n"
"Sets the border colour to use.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetBorderColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetBorderColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* col;
        int colState = 0;
         ::wxCalendarDateAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp, sipType_wxColour, &col, &colState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBorderColour(*col);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(col), sipType_wxColour, colState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetBorderColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetFont, "SetFont(font)\n"
"\n"
"Sets the font to use.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxFont* font;
         ::wxCalendarDateAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetHoliday, "SetHoliday(holiday)\n"
"\n"
"If holiday is true, this calendar day will be displayed as a holiday.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetHoliday(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetHoliday(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool holiday;
         ::wxCalendarDateAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_holiday,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp, &holiday))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHoliday(holiday);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetHoliday, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetTextColour, "SetTextColour(colText)\n"
"\n"
"Sets the text (foreground) colour to use.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colText;
        int colTextState = 0;
         ::wxCalendarDateAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colText,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxCalendarDateAttr, &sipCpp, sipType_wxColour, &colText, &colTextState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextColour(*colText);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colText), sipType_wxColour, colTextState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_GetMark, "GetMark() -> CalendarDateAttr\n"
"\n"
"Used (internally) by the generic wxCalendarCtrl::Mark().");

extern "C" {static PyObject *meth_wxCalendarDateAttr_GetMark(PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_GetMark(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxCalendarDateAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxCalendarDateAttr( ::wxCalendarDateAttr::GetMark());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxCalendarDateAttr,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_GetMark, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCalendarDateAttr_SetMark, "SetMark(m)\n"
"\n"
"Set the attributes that will be used to Mark() days on the generic\n"
"wxCalendarCtrl.");

extern "C" {static PyObject *meth_wxCalendarDateAttr_SetMark(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCalendarDateAttr_SetMark(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxCalendarDateAttr* m;

        static const char *sipKwdList[] = {
            sipName_m,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9", sipType_wxCalendarDateAttr, &m))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxCalendarDateAttr::SetMark(*m);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CalendarDateAttr, sipName_SetMark, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxCalendarDateAttr(void *, int);}
static void release_wxCalendarDateAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxCalendarDateAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxCalendarDateAttr(Py_ssize_t);}
static void *array_wxCalendarDateAttr(Py_ssize_t sipNrElem)
{
    return new  ::wxCalendarDateAttr[sipNrElem];
}


extern "C" {static void assign_wxCalendarDateAttr(void *, Py_ssize_t, void *);}
static void assign_wxCalendarDateAttr(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxCalendarDateAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxCalendarDateAttr *>(sipSrc);
}


extern "C" {static void *copy_wxCalendarDateAttr(const void *, Py_ssize_t);}
static void *copy_wxCalendarDateAttr(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxCalendarDateAttr(reinterpret_cast<const  ::wxCalendarDateAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxCalendarDateAttr(sipSimpleWrapper *);}
static void dealloc_wxCalendarDateAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxCalendarDateAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxCalendarDateAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxCalendarDateAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxCalendarDateAttr *sipCpp = SIP_NULLPTR;

    {
        const  ::wxColour& colTextdef = wxNullColour;
        const  ::wxColour* colText = &colTextdef;
        int colTextState = 0;
        const  ::wxColour& colBackdef = wxNullColour;
        const  ::wxColour* colBack = &colBackdef;
        int colBackState = 0;
        const  ::wxColour& colBorderdef = wxNullColour;
        const  ::wxColour* colBorder = &colBorderdef;
        int colBorderState = 0;
        const  ::wxFont& fontdef = wxNullFont;
        const  ::wxFont* font = &fontdef;
         ::wxCalendarDateBorder border = wxCAL_BORDER_NONE;

        static const char *sipKwdList[] = {
            sipName_colText,
            sipName_colBack,
            sipName_colBorder,
            sipName_font,
            sipName_border,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1J1J9E", sipType_wxColour, &colText, &colTextState, sipType_wxColour, &colBack, &colBackState, sipType_wxColour, &colBorder, &colBorderState, sipType_wxFont, &font, sipType_wxCalendarDateBorder, &border))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxCalendarDateAttr(*colText,*colBack,*colBorder,*font,border);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colText), sipType_wxColour, colTextState);
            sipReleaseType(const_cast< ::wxColour *>(colBack), sipType_wxColour, colBackState);
            sipReleaseType(const_cast< ::wxColour *>(colBorder), sipType_wxColour, colBorderState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
         ::wxCalendarDateBorder border;
        const  ::wxColour& colBorderdef = wxNullColour;
        const  ::wxColour* colBorder = &colBorderdef;
        int colBorderState = 0;

        static const char *sipKwdList[] = {
            sipName_border,
            sipName_colBorder,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E|J1", sipType_wxCalendarDateBorder, &border, sipType_wxColour, &colBorder, &colBorderState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxCalendarDateAttr(border,*colBorder);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colBorder), sipType_wxColour, colBorderState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxCalendarDateAttr* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxCalendarDateAttr, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxCalendarDateAttr(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxCalendarDateAttr[] = {
    {sipName_GetBackgroundColour, meth_wxCalendarDateAttr_GetBackgroundColour, METH_VARARGS, doc_wxCalendarDateAttr_GetBackgroundColour},
    {sipName_GetBorder, meth_wxCalendarDateAttr_GetBorder, METH_VARARGS, doc_wxCalendarDateAttr_GetBorder},
    {sipName_GetBorderColour, meth_wxCalendarDateAttr_GetBorderColour, METH_VARARGS, doc_wxCalendarDateAttr_GetBorderColour},
    {sipName_GetFont, meth_wxCalendarDateAttr_GetFont, METH_VARARGS, doc_wxCalendarDateAttr_GetFont},
    {sipName_GetMark, meth_wxCalendarDateAttr_GetMark, METH_VARARGS, doc_wxCalendarDateAttr_GetMark},
    {sipName_GetTextColour, meth_wxCalendarDateAttr_GetTextColour, METH_VARARGS, doc_wxCalendarDateAttr_GetTextColour},
    {sipName_HasBackgroundColour, meth_wxCalendarDateAttr_HasBackgroundColour, METH_VARARGS, doc_wxCalendarDateAttr_HasBackgroundColour},
    {sipName_HasBorder, meth_wxCalendarDateAttr_HasBorder, METH_VARARGS, doc_wxCalendarDateAttr_HasBorder},
    {sipName_HasBorderColour, meth_wxCalendarDateAttr_HasBorderColour, METH_VARARGS, doc_wxCalendarDateAttr_HasBorderColour},
    {sipName_HasFont, meth_wxCalendarDateAttr_HasFont, METH_VARARGS, doc_wxCalendarDateAttr_HasFont},
    {sipName_HasTextColour, meth_wxCalendarDateAttr_HasTextColour, METH_VARARGS, doc_wxCalendarDateAttr_HasTextColour},
    {sipName_IsHoliday, meth_wxCalendarDateAttr_IsHoliday, METH_VARARGS, doc_wxCalendarDateAttr_IsHoliday},
    {sipName_SetBackgroundColour, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetBackgroundColour), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetBackgroundColour},
    {sipName_SetBorder, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetBorder), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetBorder},
    {sipName_SetBorderColour, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetBorderColour), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetBorderColour},
    {sipName_SetFont, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetFont), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetFont},
    {sipName_SetHoliday, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetHoliday), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetHoliday},
    {sipName_SetMark, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetMark), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetMark},
    {sipName_SetTextColour, SIP_MLMETH_CAST(meth_wxCalendarDateAttr_SetTextColour), METH_VARARGS|METH_KEYWORDS, doc_wxCalendarDateAttr_SetTextColour}
};

sipVariableDef variables_wxCalendarDateAttr[] = {
    {PropertyVariable, sipName_TextColour, &methods_wxCalendarDateAttr[5], &methods_wxCalendarDateAttr[18], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Font, &methods_wxCalendarDateAttr[3], &methods_wxCalendarDateAttr[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BorderColour, &methods_wxCalendarDateAttr[2], &methods_wxCalendarDateAttr[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Border, &methods_wxCalendarDateAttr[1], &methods_wxCalendarDateAttr[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxCalendarDateAttr[0], &methods_wxCalendarDateAttr[12], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxCalendarDateAttr, "CalendarDateAttr(colText=wx.NullColour, colBack=wx.NullColour, colBorder=wx.NullColour, font=wx.NullFont, border=CAL_BORDER_NONE)\n"
"CalendarDateAttr(border, colBorder=wx.NullColour)\n"
"\n"
"wxCalendarDateAttr is a custom attributes for a calendar date.");


sipClassTypeDef sipTypeDef__adv_wxCalendarDateAttr = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxCalendarDateAttr,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_CalendarDateAttr,
        {0, 0, 1},
        19, methods_wxCalendarDateAttr,
        0, SIP_NULLPTR,
        5, variables_wxCalendarDateAttr,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxCalendarDateAttr,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxCalendarDateAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxCalendarDateAttr,
    assign_wxCalendarDateAttr,
    array_wxCalendarDateAttr,
    copy_wxCalendarDateAttr,
    release_wxCalendarDateAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
