Table of Contents

NAME

wnb - WordNet window-based browser interface

SYNOPSIS

wnb

DESCRIPTION

wnb() provides a window-based interface for browsing the WordNet database,
allowing synsets and relations to be displayed as formatted text. For each
search word, different searches are available based on syntactic category
and information available in the database.

wnb is written in Tcl/Tk, which is available for Unix and Windows platforms.
This allows the same code to work on all supported WordNet platforms without
modification.

WNB WINDOWS

wnb() was developed with the philosophy that only those searches and buttons
that are applicable at the current time are displayed. As a result, the
appearance of the interface changes as it is used. Use the standard
windowing system mouse functions to open and close the WordNet Browser
Window, move the window, and change its size.

The WordNet Browser Window contains the following areas, from top to bottom:

Menubar
     A menubar runs along the top of the browser window with pulldown menus
     and button entitled File , History , Options , and Help .
Search Word Entry
     Below the Menubar is a line for entering the search word. A search word
     can be a single word, hyphenated string, or a collocation. Case is
     ignored. Although only uninflected forms of words are usually stored in
     WordNet, users may search for inflected forms. WordNet's morphological
     processor finds the base form automatically.
Search Selection
     Below the Search Word Entry line is an area for selecting the search
     type and senses to search. Until a search word is entered this area is
     blank. After a search word is entered, buttons appear corresponding to
     each syntactic category (Noun , Verb , Adjective , Adverb ) in which
     the search string is defined in WordNet.

At the right edge of the Search Selection line is a box for entering sense
numbers. When this box is empty, search results for all senses of the search
word that match the search type are displayed. The search may be restricted
to one or more specific senses by entering a comma or space separated list
of sense numbers in the Senses box. These sense numbers remain in effect
until either the user changes or deletes them, or a new search word is
entered.

Results Window
     Most of the browser window consists of a large text buffer for
     displaying the results of WordNet searches. Horizontal and vertical
     scroll bars are present for scrolling through the output.
Status Line
     A status line is at the bottom of the browser window. When search
     results are displayed in the Results Window, this status line reflects
     the type of search selected. When there is no search word entered, your
     are prompted to "Enter search word and press return." If the search
     word entered is not in WordNet, the message "Sorry, no matches found."
     is displayed.

SEARCHING THE DATABASE

The WordNet browser navigates through WordNet in two steps. First a search
word is entered and an overview of all the senses of the word in all
syntactic categories is displayed in the Results Window. Then, within a
syntactic category, a specific search is selected. The desired search is
performed and the search results are displayed in the Results Window.
Additional searches on the same word can be performed, or a new search word
can be entered.

To enter a search word, click the mouse in the horizontal box labeled Search
Word , type a single word, hyphenated string, or collocation and press
RETURN.

wnb() responds by making a set of Part of Speech buttons appear in the
Search Selection line. Each button corresponds to a syntactic category in
which the search string is defined in WordNet. At the same time, an Overview
of the synsets for all senses of the search word is displayed in the Results
Window. The Overview includes the gloss for each synset and also indicates
which of the senses have appeared in the semantically tagged texts. For each
sense that has appeared in such texts, the number of semantic tags to that
sense are indicated in parentheses after the sense number.

The pulldown menus in the Search Selection line list all of the WordNet
searches that can be performed for the search word in that part of speech.
To select a search, highlight it by dragging the mouse to it, and release
the mouse while it is highlighted. Drag the mouse outside of the pulldown
list and release to hide the menu without making a selection. Dragging the
mouse across the Part of Speech buttons displays the available searches for
each syntactic category.

To restrict a search to one or more senses within a syntactic category,
enter a comma or space separated list of sense numbers in the Senses box
before selecting a search.

After a search is selected, wnb() performs the search on the WordNet
database and displays the formatted results in the Results Window. Whenever
search results are displayed, a button entitled Redisplay Overview is
present at the right edge of the Search Word Entry line. Clicking on this
button redisplays the Overview of all synsets for the search word in the
Results Window.

Changing the Search Word

A new search word can be entered at any time by moving to the Search Word
Entry box, if necessary highlighting it by clicking, erasing the old string,
typing a new one and pressing RETURN. The Senses box is cleared if
necessary, the Part of Speech buttons applicable to the new search word
appear, and the Overview for the new search word is displayed.

The middle mouse button can also be used to select a new search word by
placing the mouse over any word in the Results Window and clicking. The
selected word will replace the text in the Search Word Entry box, and the
overview for that word will automatically be displayed.

To select a new search string collocation from text in the Results Window,
highlight the text with the mouse and press CONTROL-S.

Interrupting a Search

When a search is in progress the message "Searching...(press escape to
abort)" is displayed in the Status Line. Note that most searches return very
quickly, so this message isn't noticeable. As indicated, pressing the ESCAPE
key will interrupt the search. The results of the search obtained before the
time the search was interrupted are displayed in the Results Window.

MENUS

File Menu

     Find keywords by substring
          Display a popup window for specifying a search of WordNet for
          words or collocations that contain a specific substring. If a
          search word is currently entered in the Search Word box, it
          is used as the substring to search for by default. The
          Substring Search Window contains a box for entering a
          substring, a pulldown menu to its right for specifying the
          part of speech to search, a large area for displaying the
          search results, and action buttons at the bottom entitled
          Search , Save , Print Dismiss .

     Once a substring is entered and a part of speech selected,
     clicking on the Search button causes a search to be done for all
     words and collocations in WordNet, in that syntactic category,
     that contain the substring according to the following criteria:

     1. The substring can appear at the beginning or end of a word,
     hyphenated string o collocation.

     2. The substring can appear in the middle of a hyphenated string
     or collocation, but only delimited on both sides by spaces or
     hyphens.

     The search results are displayed in the large buffer. Clicking on
     an item from the search results list causes wnb() to automatically
     enter that word in the Search Word box of the WordNet Browser
     Window and perform the Overview search.

     Clicking the Save button generates a popup dialog for specifying a
     filename to save the substring search results to. Clicking the
     Print button generates a popup dialog in which a print command can
     be specified.

     Selecting Dismiss closes the Substring Search Window.

     Save current display
          Display a popup dialog for specifying a filename to save the
          current Results Window contents to.
     Print current display
          Display a popup dialog in which to specify a print command to
          which the current Results Window contents can be piped.
     Clear current display
          Clear the Search Word and Senses boxes, and Results Window.
     Exit
          Does what you would expect.

History

This pulldown menu contains a list of the last searches performed. Selecting
an item from this list performs that search again. The maximum number of
searches stored in the list can be adjusted from the Options menu. The
default is 10.

Options

     Show help with each search
          When this checkbox is selected search results are preceded by
          some explanatory text about the type of search selected. This
          is off by default.
     Show descriptive gloss
          When this checkbox is selected, synset glosses are displayed
          in all search results. This is set by default. Note that
          glosses are always displayed in the Overview.
     Wrap Lines
          When this checkbox is selected, lines in the Results Window
          that are wider than the window are automatically wrapped.
          This is set by default. If not selected, a horizontal scroll
          bar is present if any lines are longer than the width of the
          window.
     Set advanced search options
          Selecting this item displays a popup window for setting the
          following search options: Lexical file information; Synset
          location in database file; Sense number . Choices for each
          are:

        Don't show (default)
        Show with searches
        Show with searches and overview

     When lexical file information is shown, the name of the
     lexicographer file is printed before each synset, enclosed in
     angle brackets (<  ...  > ). When both lexical file information
     and synset location information are displayed, the synset location
     information appears first. If within one lexicographer file more
     than one sense of a word is entered, an integer lex_id is appended
     onto all but one of the word's instances to uniquely identify it.
     In each synset, each word having a non-zero lex_id is printed with
     the lex_id value printed immediately following the word. If both
     lexicographer information and sense numbers are displayed, lex_id
     s, if present, precede sense numbers.

     When synset location is shown, the byte offset of the synset in
     the database "data" file corresponding to the syntactic category
     of the synset is printed before each synset, enclosed in curly
     braces ({  ...  } ). When both lexical file information and synset
     location information are displayed, the synset location
     information appears first.

     When sense numbers are shown, the sense number of each word in
     each synset is printed immediately after the word, and is preceded
     by a number sign (# ).

     Set maximum history length
          Display a popup dialog in which the maximum number of
          previous searches to be kept on the History list can be set.
     Set font
          Display a popup window for setting the font (typeface) and
          font size to use for the Results Window. Choices for typeface
          are: Courier , Helvetica , and Times (default). Font size can
          be small , medium (default), or large .

Help

     Help on using the WordNet browser
          Display this manual page.
     Help on WordNet terminology
          Display the wngloss(7WN) manual page.
     Display the WordNet license
          Display the WordNet copyright notice and license agreement.
     About the WordNet browser
          Information about this application.

SHORCUTS

Clicking on any word in the Results Window while holding down the SHIFT key
on the keyboard causes the browser to replace Search Word with the word and
display its Overview and available searches. Clicking on any word in the
Results Window with the middle mouse button does the same thing.

Pressing the CONTROL-S keys causes the browser to do as above on the text
that is currently highlighted, even it if is in another window. This method
works on hyphenated strings and collocations, as well as individual words.

Pressing the CONTROL-G keys displays the Substring Search Window.

SEARCH RESULTS

The results of a search of the WordNet database are displayed in the Results
Window. Horizontal and vertical scroll bars are present for scrolling
through the search results.

All searches other than the Overview list all senses matching the search
results in the following general format. Items enclosed in italicized square
brackets ([ ... ] ) may not be present.

     One line listing the number of senses matching the search
     selected.

     Each sense matching the search selected displayed as follows:

        Sense n
        [{synset_offset}]
     [<lex_filename>]  word1[#sense_number][,  word2...]

     Where n is the sense number of the search word, synset_offset is
     the byte offset of the synset in the data.pos file corresponding
     to the syntactic category, lex_filename is the name of the
     lexicographer file that the synset comes from, word1 is the first
     word in the synset (note that this is not necessarily the search
     word) and sense_number is the WordNet sense number assigned to the
     preceding word. synset_offset , lex_filename , and sense_number
     are generated if the appropriate Options are specified.

     The synsets matching the search selected are printed below each
     sense's synset output described above. Each line of output is
     preceded by a marker (usually => ), then a synset, formatted as
     described above. If a search traverses more one level of the tree,
     then successive lines are indented by spaces corresponding to its
     level in the hierarchy. Glosses are displayed in parentheses at
     the end of each synset if the appropriate Option is set. Each
     synset is printed on one line.

     Senses are ordered from most to least frequently used, with the
     most common sense numbered 1 . Frequency of use is determined by
     the number of times a sense is tagged in the various semantic
     concordance texts. Senses that are not semantically tagged follow
     the ordered senses. Note that this ordering is only an estimate
     based on usage in a small corpus.

     Verb senses can be grouped by similarity of meaning, rather than
     ordered by frequency of use. When the "Synonyms, grouped by
     similarity of meaning" search is selected, senses that are close
     in meaning are printed together, with a line of dashes indicating
     the end of a group. See wngroups(7WN) for a discussion how senses
     are grouped.

     When the "Sentence Frames" search is specified, sample
     illustrative sentences and generic sentence frames are displayed.
     If a sample sentence is found, the base form of the search word is
     substituted into the sentence, and it is printed below the synset,
     preceded with the EX: marker. When no sample sentences are found,
     the generic sentence frames are displayed. Sentence frames that
     are acceptable for all words in a synset are preceded by the
     marker *> . If a frame is acceptable for the search word only, it
     is preceded by the marker => .

     Search results for adjectives are slightly different from those
     for other parts of speech. When an adjective is printed, its
     direct antonym, if it has one, is also printed in parentheses.
     When the search word is in a head synset, all of the head synset's
     satellites are also displayed. The position of an adjective in
     relation to the noun may be restricted to the prenominal ,
     postnominal or predicative position. Where present, these
     restrictions are noted in parentheses.

     When an adjective is a participle of a verb, the output indicates
     the verb and displays its synset.

     When an adverb is derived from an adjective, the specific
     adjectival sense on which it is based is indicated.

     The morphological transformations performed by the search code may
     result in more than one word to search for. wnb() automatically
     performs the requested search on all of the strings and returns
     the results grouped by word. For example, the verb saw is both the
     present tense of saw and the past tense of see . When there is
     more than one word to search for, search results are grouped by
     word.

DIAGNOSTICS

If the WordNet database files cannot be opened, error messages are
displayed. This is usually corrected by setting the environment variables
described below to the proper location of the WordNet database for your
installation.

ENVIRONMENT VARIABLES

WNHOME
     Base directory for WordNet. Unix default is /usr/local/WordNet-1.7.1 ,
     Windows default is C:\WordNet 1.7.1 .
WNSEARCHDIR
     Directory in which the WordNet database has been installed. Unix
     default is WNHOME/dict , Windows default is WNHOME\dict .

FILES

All files are in the directory WNSEARCHDIR .

index.pos
     database index files (Unix)
pos .idx
     database index files (Windows)
data.pos
     database data files (Unix)
pos .dat
     database data files (Windows)
*.vrb
     files of sentences illustrating the use of verbs
pos .exc
     morphology exception lists

SEE ALSO

wnintro(1WN) , wn(1WN) , wnintro(3WN) , lexnames(5WN) , senseidx(5WN) ,
wndb(5WN) , wninput(5WN) , morphy(7WN) , wngloss(7WN) , wngroups(7WN) .

BUGS

Please reports bugs to wordnet@princeton.edu.

