#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# Setup script for url

__version__ = "$Revision: 1.51 $"[11:-2]
# $Source: /data/cvsroot/LivingLogic/Python/url/setup.py,v $

from distutils.core import setup, Extension
import textwrap

DESCRIPTION = """
ll-url provides classes for parsing and constructing RFC 2396
compliant URLs.
"""

CLASSIFIERS="""
Development Status :: 5 - Production/Stable
Environment :: Console
Environment :: Web Environment
Intended Audience :: Developers
License :: OSI Approved :: Python License (CNRI Python License)
Operating System :: OS Independent
Programming Language :: Python
Topic :: Internet
Topic :: Internet :: File Transfer Protocol (FTP)
Topic :: Internet :: WWW/HTTP
Topic :: Software Development :: Libraries :: Python Modules
"""

KEYWORDS = """
URL
RFC 2396
HTTP
FTP
"""

DESCRIPTION = "\n".join(textwrap.wrap(DESCRIPTION.strip(), width=64, replace_whitespace=True))

setup(
	name="ll-url",
	version="0.15.1",
	description="A module for parsing RFC2396 compliant URLs",
	long_description=DESCRIPTION,
	author=u"Walter Drwald",
	author_email="walter@livinglogic.de",
	url="http://www.livinglogic.de/Python/url/",
	download_url="http://www.livinglogic.de/Python/url/Download.html",
	license="Python",
	classifiers=CLASSIFIERS.strip().splitlines(),
	keywords=",".join(KEYWORDS.strip().splitlines()),
	py_modules=["ll.url"],
	package_dir={"ll": ""},
	ext_modules=[Extension("ll._url", ["_url.c"])]
)
