# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class HighriskSpecialPrefixList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, iso_code):
        """
        Initialize the HighriskSpecialPrefixList

        :param Version version: Version that contains the resource
        :param iso_code: The ISO country code

        :returns: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixList
        :rtype: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixList
        """
        super(HighriskSpecialPrefixList, self).__init__(version)

        # Path Solution
        self._solution = {'iso_code': iso_code, }
        self._uri = '/DialingPermissions/Countries/{iso_code}/HighRiskSpecialPrefixes'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams HighriskSpecialPrefixInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists HighriskSpecialPrefixInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of HighriskSpecialPrefixInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of HighriskSpecialPrefixInstance
        :rtype: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixPage
        """
        params = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(
            'GET',
            self._uri,
            params=params,
        )

        return HighriskSpecialPrefixPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of HighriskSpecialPrefixInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of HighriskSpecialPrefixInstance
        :rtype: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return HighriskSpecialPrefixPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.HighriskSpecialPrefixList>'


class HighriskSpecialPrefixPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the HighriskSpecialPrefixPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param iso_code: The ISO country code

        :returns: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixPage
        :rtype: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixPage
        """
        super(HighriskSpecialPrefixPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of HighriskSpecialPrefixInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixInstance
        :rtype: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixInstance
        """
        return HighriskSpecialPrefixInstance(self._version, payload, iso_code=self._solution['iso_code'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.HighriskSpecialPrefixPage>'


class HighriskSpecialPrefixInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, iso_code):
        """
        Initialize the HighriskSpecialPrefixInstance

        :returns: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixInstance
        :rtype: twilio.rest.voice.v1.voice_permission.country.highrisk_special_prefix.HighriskSpecialPrefixInstance
        """
        super(HighriskSpecialPrefixInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'prefix': payload['prefix'], }

        # Context
        self._context = None
        self._solution = {'iso_code': iso_code, }

    @property
    def prefix(self):
        """
        :returns: A prefix that includes the E.164 assigned country code
        :rtype: unicode
        """
        return self._properties['prefix']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.HighriskSpecialPrefixInstance>'
