# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class IntentActionsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, intent_sid):
        """
        Initialize the IntentActionsList

        :param Version version: Version that contains the resource
        :param assistant_sid: The unique ID of the parent Assistant.
        :param intent_sid: The unique ID of the Intent.

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsList
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsList
        """
        super(IntentActionsList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'intent_sid': intent_sid, }

    def get(self):
        """
        Constructs a IntentActionsContext

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        """
        return IntentActionsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            intent_sid=self._solution['intent_sid'],
        )

    def __call__(self):
        """
        Constructs a IntentActionsContext

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        """
        return IntentActionsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            intent_sid=self._solution['intent_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.IntentActionsList>'


class IntentActionsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the IntentActionsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The unique ID of the parent Assistant.
        :param intent_sid: The unique ID of the Intent.

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsPage
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsPage
        """
        super(IntentActionsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of IntentActionsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        """
        return IntentActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            intent_sid=self._solution['intent_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.IntentActionsPage>'


class IntentActionsContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, intent_sid):
        """
        Initialize the IntentActionsContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The unique ID of the parent Assistant.
        :param intent_sid: The unique ID of the Intent.

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        """
        super(IntentActionsContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'intent_sid': intent_sid, }
        self._uri = '/Assistants/{assistant_sid}/Intents/{intent_sid}/Actions'.format(**self._solution)

    def fetch(self):
        """
        Fetch a IntentActionsInstance

        :returns: Fetched IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        """
        params = values.of({})

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return IntentActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            intent_sid=self._solution['intent_sid'],
        )

    def update(self, actions=values.unset):
        """
        Update the IntentActionsInstance

        :param dict actions: The JSON actions that instruct the Assistant how to perform this task.

        :returns: Updated IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        """
        data = values.of({'Actions': serialize.object(actions), })

        payload = self._version.update(
            'POST',
            self._uri,
            data=data,
        )

        return IntentActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            intent_sid=self._solution['intent_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.IntentActionsContext {}>'.format(context)


class IntentActionsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid, intent_sid):
        """
        Initialize the IntentActionsInstance

        :returns: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        """
        super(IntentActionsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'assistant_sid': payload['assistant_sid'],
            'intent_sid': payload['intent_sid'],
            'url': payload['url'],
            'data': payload['data'],
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, 'intent_sid': intent_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: IntentActionsContext for this IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsContext
        """
        if self._context is None:
            self._context = IntentActionsContext(
                self._version,
                assistant_sid=self._solution['assistant_sid'],
                intent_sid=self._solution['intent_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account that created this Field.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The unique ID of the parent Assistant.
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def intent_sid(self):
        """
        :returns: The unique ID of the Intent.
        :rtype: unicode
        """
        return self._properties['intent_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def data(self):
        """
        :returns: The data
        :rtype: dict
        """
        return self._properties['data']

    def fetch(self):
        """
        Fetch a IntentActionsInstance

        :returns: Fetched IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        """
        return self._proxy.fetch()

    def update(self, actions=values.unset):
        """
        Update the IntentActionsInstance

        :param dict actions: The JSON actions that instruct the Assistant how to perform this task.

        :returns: Updated IntentActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.intent.intent_actions.IntentActionsInstance
        """
        return self._proxy.update(actions=actions, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.IntentActionsInstance {}>'.format(context)
