# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AssistantInitiationActionsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the AssistantInitiationActionsList

        :param Version version: Version that contains the resource
        :param assistant_sid: The assistant_sid

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsList
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsList
        """
        super(AssistantInitiationActionsList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }

    def get(self):
        """
        Constructs a AssistantInitiationActionsContext

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        """
        return AssistantInitiationActionsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
        )

    def __call__(self):
        """
        Constructs a AssistantInitiationActionsContext

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        """
        return AssistantInitiationActionsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.AssistantInitiationActionsList>'


class AssistantInitiationActionsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the AssistantInitiationActionsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The assistant_sid

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsPage
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsPage
        """
        super(AssistantInitiationActionsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AssistantInitiationActionsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        """
        return AssistantInitiationActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.AssistantInitiationActionsPage>'


class AssistantInitiationActionsContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the AssistantInitiationActionsContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The assistant_sid

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        """
        super(AssistantInitiationActionsContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }
        self._uri = '/Assistants/{assistant_sid}/InitiationActions'.format(**self._solution)

    def fetch(self):
        """
        Fetch a AssistantInitiationActionsInstance

        :returns: Fetched AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        """
        params = values.of({})

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return AssistantInitiationActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
        )

    def update(self, initiation_actions=values.unset):
        """
        Update the AssistantInitiationActionsInstance

        :param dict initiation_actions: The initiation_actions

        :returns: Updated AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        """
        data = values.of({'InitiationActions': serialize.object(initiation_actions), })

        payload = self._version.update(
            'POST',
            self._uri,
            data=data,
        )

        return AssistantInitiationActionsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.AssistantInitiationActionsContext {}>'.format(context)


class AssistantInitiationActionsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid):
        """
        Initialize the AssistantInitiationActionsInstance

        :returns: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        """
        super(AssistantInitiationActionsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'assistant_sid': payload['assistant_sid'],
            'url': payload['url'],
            'data': payload['data'],
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: AssistantInitiationActionsContext for this AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsContext
        """
        if self._context is None:
            self._context = AssistantInitiationActionsContext(
                self._version,
                assistant_sid=self._solution['assistant_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The assistant_sid
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def data(self):
        """
        :returns: The data
        :rtype: dict
        """
        return self._properties['data']

    def fetch(self):
        """
        Fetch a AssistantInitiationActionsInstance

        :returns: Fetched AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        """
        return self._proxy.fetch()

    def update(self, initiation_actions=values.unset):
        """
        Update the AssistantInitiationActionsInstance

        :param dict initiation_actions: The initiation_actions

        :returns: Updated AssistantInitiationActionsInstance
        :rtype: twilio.rest.preview.understand.assistant.assistant_initiation_actions.AssistantInitiationActionsInstance
        """
        return self._proxy.update(initiation_actions=initiation_actions, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.AssistantInitiationActionsInstance {}>'.format(context)
