# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TollFreeList(ListResource):
    """  """

    def __init__(self, version, account_sid):
        """
        Initialize the TollFreeList

        :param Version version: Version that contains the resource
        :param account_sid: The unique sid that identifies this account

        :returns: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeList
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeList
        """
        super(TollFreeList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, }
        self._uri = '/Accounts/{account_sid}/IncomingPhoneNumbers/TollFree.json'.format(**self._solution)

    def stream(self, beta=values.unset, friendly_name=values.unset,
               phone_number=values.unset, origin=values.unset, limit=None,
               page_size=None):
        """
        Streams TollFreeInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param bool beta: Include phone numbers new to the Twilio platform.
        :param unicode friendly_name: Only show the incoming phone number resources with friendly names that exactly match this name.
        :param unicode phone_number: Only show the incoming phone number resources that match this pattern.
        :param unicode origin: Include phone numbers based on the origin, by default, phone numbers of all origin are included.
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(
            beta=beta,
            friendly_name=friendly_name,
            phone_number=phone_number,
            origin=origin,
            page_size=limits['page_size'],
        )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, beta=values.unset, friendly_name=values.unset,
             phone_number=values.unset, origin=values.unset, limit=None,
             page_size=None):
        """
        Lists TollFreeInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param bool beta: Include phone numbers new to the Twilio platform.
        :param unicode friendly_name: Only show the incoming phone number resources with friendly names that exactly match this name.
        :param unicode phone_number: Only show the incoming phone number resources that match this pattern.
        :param unicode origin: Include phone numbers based on the origin, by default, phone numbers of all origin are included.
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance]
        """
        return list(self.stream(
            beta=beta,
            friendly_name=friendly_name,
            phone_number=phone_number,
            origin=origin,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, beta=values.unset, friendly_name=values.unset,
             phone_number=values.unset, origin=values.unset,
             page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of TollFreeInstance records from the API.
        Request is executed immediately

        :param bool beta: Include phone numbers new to the Twilio platform.
        :param unicode friendly_name: Only show the incoming phone number resources with friendly names that exactly match this name.
        :param unicode phone_number: Only show the incoming phone number resources that match this pattern.
        :param unicode origin: Include phone numbers based on the origin, by default, phone numbers of all origin are included.
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of TollFreeInstance
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreePage
        """
        params = values.of({
            'Beta': beta,
            'FriendlyName': friendly_name,
            'PhoneNumber': phone_number,
            'Origin': origin,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(
            'GET',
            self._uri,
            params=params,
        )

        return TollFreePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of TollFreeInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of TollFreeInstance
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return TollFreePage(self._version, response, self._solution)

    def create(self, phone_number, api_version=values.unset,
               friendly_name=values.unset, sms_application_sid=values.unset,
               sms_fallback_method=values.unset, sms_fallback_url=values.unset,
               sms_method=values.unset, sms_url=values.unset,
               status_callback=values.unset, status_callback_method=values.unset,
               voice_application_sid=values.unset,
               voice_caller_id_lookup=values.unset,
               voice_fallback_method=values.unset, voice_fallback_url=values.unset,
               voice_method=values.unset, voice_url=values.unset,
               identity_sid=values.unset, address_sid=values.unset):
        """
        Create a new TollFreeInstance

        :param unicode phone_number: The phone number you want to purchase.
        :param unicode api_version: The Twilio REST API version to use for incoming calls made to this number.
        :param unicode friendly_name: A human readable description of the new incoming phone number.
        :param unicode sms_application_sid: The 34 character sid of the application Twilio should use to handle SMSs sent to the new number.
        :param unicode sms_fallback_method: The HTTP method that should be used to request the SmsFallbackUrl.
        :param unicode sms_fallback_url: A URL that Twilio will request if an error occurs requesting or executing the TwiML defined by SmsUrl.
        :param unicode sms_method: The HTTP method that should be used to request the SmsUrl.
        :param unicode sms_url: The URL that Twilio should request when somebody sends an SMS to the phone number.
        :param unicode status_callback: The URL that Twilio will request to pass status parameters to your application.
        :param unicode status_callback_method: The HTTP method Twilio will use to make requests to the StatusCallback URL.
        :param unicode voice_application_sid: The 34 character sid of the application Twilio should use to handle phone calls to the new number.
        :param bool voice_caller_id_lookup: Do a lookup of a caller's name from the CNAM database and post it to your app.
        :param unicode voice_fallback_method: The HTTP method that should be used to request the VoiceFallbackUrl.
        :param unicode voice_fallback_url: A URL that Twilio will request if an error occurs requesting or executing the TwiML at Url.
        :param unicode voice_method: The HTTP method that should be used to request the VoiceUrl.
        :param unicode voice_url: The URL that Twilio should request when somebody dials the new phone number.
        :param unicode identity_sid: The identity_sid
        :param unicode address_sid: The 34 character sid of the address Twilio should associate with the number.

        :returns: Newly created TollFreeInstance
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance
        """
        data = values.of({
            'PhoneNumber': phone_number,
            'ApiVersion': api_version,
            'FriendlyName': friendly_name,
            'SmsApplicationSid': sms_application_sid,
            'SmsFallbackMethod': sms_fallback_method,
            'SmsFallbackUrl': sms_fallback_url,
            'SmsMethod': sms_method,
            'SmsUrl': sms_url,
            'StatusCallback': status_callback,
            'StatusCallbackMethod': status_callback_method,
            'VoiceApplicationSid': voice_application_sid,
            'VoiceCallerIdLookup': voice_caller_id_lookup,
            'VoiceFallbackMethod': voice_fallback_method,
            'VoiceFallbackUrl': voice_fallback_url,
            'VoiceMethod': voice_method,
            'VoiceUrl': voice_url,
            'IdentitySid': identity_sid,
            'AddressSid': address_sid,
        })

        payload = self._version.create(
            'POST',
            self._uri,
            data=data,
        )

        return TollFreeInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.TollFreeList>'


class TollFreePage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the TollFreePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: The unique sid that identifies this account

        :returns: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreePage
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreePage
        """
        super(TollFreePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TollFreeInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance
        """
        return TollFreeInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.TollFreePage>'


class TollFreeInstance(InstanceResource):
    """  """

    class AddressRequirement(object):
        NONE = "none"
        ANY = "any"
        LOCAL = "local"
        FOREIGN = "foreign"

    def __init__(self, version, payload, account_sid):
        """
        Initialize the TollFreeInstance

        :returns: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.toll_free.TollFreeInstance
        """
        super(TollFreeInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'address_sid': payload['address_sid'],
            'address_requirements': payload['address_requirements'],
            'api_version': payload['api_version'],
            'beta': payload['beta'],
            'capabilities': payload['capabilities'],
            'date_created': deserialize.rfc2822_datetime(payload['date_created']),
            'date_updated': deserialize.rfc2822_datetime(payload['date_updated']),
            'friendly_name': payload['friendly_name'],
            'identity_sid': payload['identity_sid'],
            'phone_number': payload['phone_number'],
            'origin': payload['origin'],
            'sid': payload['sid'],
            'sms_application_sid': payload['sms_application_sid'],
            'sms_fallback_method': payload['sms_fallback_method'],
            'sms_fallback_url': payload['sms_fallback_url'],
            'sms_method': payload['sms_method'],
            'sms_url': payload['sms_url'],
            'status_callback': payload['status_callback'],
            'status_callback_method': payload['status_callback_method'],
            'trunk_sid': payload['trunk_sid'],
            'uri': payload['uri'],
            'voice_application_sid': payload['voice_application_sid'],
            'voice_caller_id_lookup': payload['voice_caller_id_lookup'],
            'voice_fallback_method': payload['voice_fallback_method'],
            'voice_fallback_url': payload['voice_fallback_url'],
            'voice_method': payload['voice_method'],
            'voice_url': payload['voice_url'],
        }

        # Context
        self._context = None
        self._solution = {'account_sid': account_sid, }

    @property
    def account_sid(self):
        """
        :returns: The unique id of the Account responsible for this phone number.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def address_sid(self):
        """
        :returns: The 34 character sid of the address associated with this number.
        :rtype: unicode
        """
        return self._properties['address_sid']

    @property
    def address_requirements(self):
        """
        :returns: This indicates whether the phone number requires you or your customer to have an Address registered with Twilio.
        :rtype: TollFreeInstance.AddressRequirement
        """
        return self._properties['address_requirements']

    @property
    def api_version(self):
        """
        :returns: Calls to this phone number will start a new TwiML session with this API version.
        :rtype: unicode
        """
        return self._properties['api_version']

    @property
    def beta(self):
        """
        :returns: Phone numbers new to the Twilio platform are marked as beta.
        :rtype: bool
        """
        return self._properties['beta']

    @property
    def capabilities(self):
        """
        :returns: This is a set of boolean properties that indicate whether a phone number can receive calls or messages.
        :rtype: unicode
        """
        return self._properties['capabilities']

    @property
    def date_created(self):
        """
        :returns: The date that this resource was created, given as GMT RFC 2822 format.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date that this resource was last updated, given as GMT RFC 2822 format.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def friendly_name(self):
        """
        :returns: A human readable descriptive text for this resource, up to 64 characters long.
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def identity_sid(self):
        """
        :returns: The identity_sid
        :rtype: unicode
        """
        return self._properties['identity_sid']

    @property
    def phone_number(self):
        """
        :returns: The incoming phone number.
        :rtype: unicode
        """
        return self._properties['phone_number']

    @property
    def origin(self):
        """
        :returns: Twilio owned phone numbers are marked as twilio while hosted phone numbers are marked as hosted.
        :rtype: unicode
        """
        return self._properties['origin']

    @property
    def sid(self):
        """
        :returns: A 34 character string that uniquely identifies this resource.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def sms_application_sid(self):
        """
        :returns: The 34 character sid of the application Twilio should use to handle SMSs sent to this number.
        :rtype: unicode
        """
        return self._properties['sms_application_sid']

    @property
    def sms_fallback_method(self):
        """
        :returns: The HTTP method Twilio will use when requesting the above URL.
        :rtype: unicode
        """
        return self._properties['sms_fallback_method']

    @property
    def sms_fallback_url(self):
        """
        :returns: The URL that Twilio will request if an error occurs retrieving or executing the TwiML from SmsUrl.
        :rtype: unicode
        """
        return self._properties['sms_fallback_url']

    @property
    def sms_method(self):
        """
        :returns: The HTTP method Twilio will use when making requests to the SmsUrl.
        :rtype: unicode
        """
        return self._properties['sms_method']

    @property
    def sms_url(self):
        """
        :returns: The URL Twilio will request when receiving an incoming SMS message to this number.
        :rtype: unicode
        """
        return self._properties['sms_url']

    @property
    def status_callback(self):
        """
        :returns: The URL that Twilio will request to pass status parameters to your application.
        :rtype: unicode
        """
        return self._properties['status_callback']

    @property
    def status_callback_method(self):
        """
        :returns: The HTTP method Twilio will use to make requests to the StatusCallback URL.
        :rtype: unicode
        """
        return self._properties['status_callback_method']

    @property
    def trunk_sid(self):
        """
        :returns: The 34 character sid of the Trunk Twilio should use to handle phone calls to this number.
        :rtype: unicode
        """
        return self._properties['trunk_sid']

    @property
    def uri(self):
        """
        :returns: The URI for this resource, relative to https://api.
        :rtype: unicode
        """
        return self._properties['uri']

    @property
    def voice_application_sid(self):
        """
        :returns: The 34 character sid of the application Twilio should use to handle phone calls to this number.
        :rtype: unicode
        """
        return self._properties['voice_application_sid']

    @property
    def voice_caller_id_lookup(self):
        """
        :returns: Look up the caller's caller-ID name from the CNAM database.
        :rtype: bool
        """
        return self._properties['voice_caller_id_lookup']

    @property
    def voice_fallback_method(self):
        """
        :returns: The HTTP method Twilio will use when requesting the VoiceFallbackUrl.
        :rtype: unicode
        """
        return self._properties['voice_fallback_method']

    @property
    def voice_fallback_url(self):
        """
        :returns: The URL that Twilio will request if an error occurs retrieving or executing the TwiML requested by Url.
        :rtype: unicode
        """
        return self._properties['voice_fallback_url']

    @property
    def voice_method(self):
        """
        :returns: The HTTP method Twilio will use when requesting the above Url.
        :rtype: unicode
        """
        return self._properties['voice_method']

    @property
    def voice_url(self):
        """
        :returns: The URL Twilio will request when this phone number receives a call.
        :rtype: unicode
        """
        return self._properties['voice_url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.TollFreeInstance>'
