# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class CountryTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.voice_permissions \
                                .countries(iso_code="US").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/DialingPermissions/Countries/US',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "iso_code": "US",
                "name": "United States/Canada",
                "country_codes": [
                    "+1"
                ],
                "continent": "NORTH_AMERICA",
                "low_risk_numbers_enabled": false,
                "high_risk_special_numbers_enabled": false,
                "high_risk_tollfraud_numbers_enabled": false,
                "url": "https://voice.twilio.com/v1/DialingPermissions/Countries/US",
                "links": {
                    "highrisk_special_prefixes": "https://voice.twilio.com/v1/DialingPermissions/Countries/US/HighRiskSpecialPrefixes"
                }
            }
            '''
        ))

        actual = self.client.voice.v1.voice_permissions \
                                     .countries(iso_code="US").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.voice_permissions \
                                .countries.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/DialingPermissions/Countries',
        ))

    def test_read_us_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "content": [
                    {
                        "iso_code": "US",
                        "name": "United States/Canada",
                        "country_codes": [
                            "+1"
                        ],
                        "continent": "NORTH_AMERICA",
                        "low_risk_numbers_enabled": false,
                        "high_risk_special_numbers_enabled": false,
                        "high_risk_tollfraud_numbers_enabled": false,
                        "url": "https://voice.twilio.com/v1/DialingPermissions/Countries/US",
                        "links": {
                            "highrisk_special_prefixes": "https://voice.twilio.com/v1/DialingPermissions/Countries/US/HighRiskSpecialPrefixes"
                        }
                    }
                ],
                "meta": {
                    "first_page_url": "https://voice.twilio.com/v1/DialingPermissions/Countries?PageSize=50&Page=0",
                    "key": "content",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/DialingPermissions/Countries?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.voice.v1.voice_permissions \
                                     .countries.list()

        self.assertIsNotNone(actual)
