# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class WorkersStatisticsTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.taskrouter.v1.workspaces(sid="WSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .workers \
                                     .statistics().fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://taskrouter.twilio.com/v1/Workspaces/WSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Workers/Statistics',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "cumulative": {
                    "reservations_created": 0,
                    "reservations_accepted": 0,
                    "reservations_rejected": 0,
                    "reservations_timed_out": 0,
                    "reservations_canceled": 0,
                    "reservations_rescinded": 0,
                    "activity_durations": [
                        {
                            "max": 0,
                            "min": 900,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "friendly_name": "Offline",
                            "avg": 1080,
                            "total": 5400
                        },
                        {
                            "max": 0,
                            "min": 900,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "friendly_name": "Busy",
                            "avg": 1012,
                            "total": 8100
                        },
                        {
                            "max": 0,
                            "min": 0,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "friendly_name": "Idle",
                            "avg": 0,
                            "total": 0
                        },
                        {
                            "max": 0,
                            "min": 0,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "friendly_name": "Reserved",
                            "avg": 0,
                            "total": 0
                        }
                    ],
                    "start_time": "2008-01-02T00:00:00Z",
                    "end_time": "2008-01-02T00:00:00Z"
                },
                "realtime": {
                    "total_workers": 15,
                    "activity_statistics": [
                        {
                            "friendly_name": "Idle",
                            "workers": 0,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        },
                        {
                            "friendly_name": "Busy",
                            "workers": 9,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        },
                        {
                            "friendly_name": "Offline",
                            "workers": 6,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        },
                        {
                            "friendly_name": "Reserved",
                            "workers": 0,
                            "sid": "WAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        }
                    ]
                },
                "workspace_sid": "WSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://taskrouter.twilio.com/v1/Workspaces/WSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Workers/Statistics"
            }
            '''
        ))

        actual = self.client.taskrouter.v1.workspaces(sid="WSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                          .workers \
                                          .statistics().fetch()

        self.assertIsNotNone(actual)
