# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class NumberTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.pricing.v2.voice \
                                  .numbers(destination_number="+15017122661").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://pricing.twilio.com/v2/Voice/Numbers/+15017122661',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "country": "United States",
                "destination_number": "+18001234567",
                "inbound_call_price": {
                    "base_price": null,
                    "current_price": null,
                    "number_type": null
                },
                "iso_country": "US",
                "origination_number": "+987654321",
                "outbound_call_prices": [
                    {
                        "base_price": "0.013",
                        "current_price": "0.013",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    }
                ],
                "price_unit": "USD",
                "url": "https://pricing.twilio.com/v2/Voice/Numbers/+18001234567"
            }
            '''
        ))

        actual = self.client.pricing.v2.voice \
                                       .numbers(destination_number="+15017122661").fetch()

        self.assertIsNotNone(actual)
