# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class AlertTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.monitor.v1.alerts(sid="NOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://monitor.twilio.com/v1/Alerts/NOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "alert_text": "alert_text",
                "api_version": "2010-04-01",
                "date_created": "2015-07-30T20:00:00Z",
                "date_generated": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:00:00Z",
                "error_code": "error_code",
                "log_level": "log_level",
                "more_info": "more_info",
                "request_method": "GET",
                "request_url": "http://www.example.com",
                "request_variables": "request_variables",
                "resource_sid": "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "response_body": "response_body",
                "response_headers": "response_headers",
                "sid": "NOaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "http://www.example.com"
            }
            '''
        ))

        actual = self.client.monitor.v1.alerts(sid="NOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.monitor.v1.alerts(sid="NOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://monitor.twilio.com/v1/Alerts/NOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.monitor.v1.alerts(sid="NOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.monitor.v1.alerts.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://monitor.twilio.com/v1/Alerts',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "alerts": [],
                "meta": {
                    "first_page_url": "https://monitor.twilio.com/v1/Alerts?Page=0&PageSize=50",
                    "key": "alerts",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 0,
                    "previous_page_url": null,
                    "url": "https://monitor.twilio.com/v1/Alerts"
                }
            }
            '''
        ))

        actual = self.client.monitor.v1.alerts.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "alerts": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "alert_text": "alert_text",
                        "api_version": "2010-04-01",
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_generated": "2015-07-30T20:00:00Z",
                        "date_updated": "2015-07-30T20:00:00Z",
                        "error_code": "error_code",
                        "log_level": "log_level",
                        "more_info": "more_info",
                        "request_method": "GET",
                        "request_url": "http://www.example.com",
                        "resource_sid": "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "NOaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "url": "http://www.example.com"
                    }
                ],
                "meta": {
                    "first_page_url": "https://monitor.twilio.com/v1/Alerts?Page=0&PageSize=50",
                    "key": "alerts",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 1,
                    "previous_page_url": null,
                    "url": "https://monitor.twilio.com/v1/Alerts"
                }
            }
            '''
        ))

        actual = self.client.monitor.v1.alerts.list()

        self.assertIsNotNone(actual)
