<!---
Copyright 2020 The HuggingFace Team. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Examples

This folder contains actively maintained examples of use of 🤗 Transformers organized along NLP tasks. If you are looking for an example that used to be in this folder, it may have moved to the corresponding framework subfolder (pytorch, tensorflow or flax), our [research projects](https://github.com/huggingface/transformers/tree/master/examples/research_projects) subfolder (which contains frozen snapshots of research projects) or to the [legacy](https://github.com/huggingface/transformers/tree/master/examples/legacy) subfolder.

While we strive to present as many use cases as possible, the scripts in this folder are just examples. It is expected that they won't work out-of-the box on your specific problem and that you will be required to change a few lines of code to adapt them to your needs. To help you with that, most of the examples fully expose the preprocessing of the data. This way, you can easily tweak them.

This is similar if you want the scripts to report another metric than the one they currently use: look at the `compute_metrics` function inside the script. It takes the full arrays of predictions and labels and has to return a dictionary of string keys and float values. Just change it to add (or replace) your own metric to the ones already reported.

Please discuss on the [forum](https://discuss.huggingface.co/) or in an [issue](https://github.com/huggingface/transformers/issues) a feature you would like to implement in an example before submitting a PR: we welcome bug fixes but since we want to keep the examples as simple as possible, it's unlikely we will merge a pull request adding more functionality at the cost of readability.

## Important note

**Important**

To make sure you can successfully run the latest versions of the example scripts, you have to **install the library from source** and install some example-specific requirements. To do this, execute the following steps in a new virtual environment:
```bash
git clone https://github.com/huggingface/transformers
cd transformers
pip install .
```
Then cd in the example folder of your choice and run
```bash
pip install -r requirements.txt
```

To browse the examples corresponding to released versions of 🤗 Transformers, click on the line below and then on your desired version of the library:

<details>
  <summary>Examples for older versions of 🤗 Transformers</summary>

  - [v4.5.1](https://github.com/huggingface/transformers/tree/v4.5.1/examples)
  - [v4.4.2](https://github.com/huggingface/transformers/tree/v4.4.2/examples)
  - [v4.3.3](https://github.com/huggingface/transformers/tree/v4.3.3/examples)
  - [v4.2.2](https://github.com/huggingface/transformers/tree/v4.2.2/examples)
  - [v4.1.1](https://github.com/huggingface/transformers/tree/v4.1.1/examples)
  - [v4.0.1](https://github.com/huggingface/transformers/tree/v4.0.1/examples)
  - [v3.5.1](https://github.com/huggingface/transformers/tree/v3.5.1/examples)
  - [v3.4.0](https://github.com/huggingface/transformers/tree/v3.4.0/examples)
  - [v3.3.1](https://github.com/huggingface/transformers/tree/v3.3.1/examples)
  - [v3.2.0](https://github.com/huggingface/transformers/tree/v3.2.0/examples)
  - [v3.1.0](https://github.com/huggingface/transformers/tree/v3.1.0/examples)
  - [v3.0.2](https://github.com/huggingface/transformers/tree/v3.0.2/examples)
  - [v2.11.0](https://github.com/huggingface/transformers/tree/v2.11.0/examples)
  - [v2.10.0](https://github.com/huggingface/transformers/tree/v2.10.0/examples)
  - [v2.9.1](https://github.com/huggingface/transformers/tree/v2.9.1/examples)
  - [v2.8.0](https://github.com/huggingface/transformers/tree/v2.8.0/examples)
  - [v2.7.0](https://github.com/huggingface/transformers/tree/v2.7.0/examples)
  - [v2.6.0](https://github.com/huggingface/transformers/tree/v2.6.0/examples)
  - [v2.5.1](https://github.com/huggingface/transformers/tree/v2.5.1/examples)
  - [v2.4.0](https://github.com/huggingface/transformers/tree/v2.4.0/examples)
  - [v2.3.0](https://github.com/huggingface/transformers/tree/v2.3.0/examples)
  - [v2.2.0](https://github.com/huggingface/transformers/tree/v2.2.0/examples)
  - [v2.1.1](https://github.com/huggingface/transformers/tree/v2.1.0/examples)
  - [v2.0.0](https://github.com/huggingface/transformers/tree/v2.0.0/examples)
  - [v1.2.0](https://github.com/huggingface/transformers/tree/v1.2.0/examples)
  - [v1.1.0](https://github.com/huggingface/transformers/tree/v1.1.0/examples)
  - [v1.0.0](https://github.com/huggingface/transformers/tree/v1.0.0/examples)
</details>

Alternatively, you can switch your cloned 🤗 Transformers to a specific version (for instance with v3.5.1) with
```bash
git checkout tags/v3.5.1
```
and run the example command as usual afterward.
