# (C) Copyright 2020-2021 Enthought, Inc., Austin, TX
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in LICENSE.txt and may be redistributed only under
# the conditions described in the aforementioned license. The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
#
# Thanks for using Enthought open source!

from enum import IntEnum
from typing import Any

class TraitKind(IntEnum):
    trait: int = ...
    python: int = ...
    event: int = ...
    delegate: int = ...
    property: int = ...
    disallow: int = ...
    read_only: int = ...
    constant: int = ...
    generic: int = ...

class ValidateTrait(IntEnum):
    type: int = ...
    instance: int = ...
    self_type: int = ...
    int_range: int = ...
    float_range: int = ...
    enum: int = ...
    map: int = ...
    complex: int = ...
    slow: int = ...
    tuple: int = ...
    prefix_map: int = ...
    coerce: int = ...
    cast: int = ...
    function: int = ...
    python: int = ...
    adapt: int = ...
    int: int = ...
    float: int = ...
    callable: int = ...

class ComparisonMode(IntEnum):
    none: int = ...
    identity: int = ...
    equality: int = ...

NO_COMPARE: Any
OBJECT_IDENTITY_COMPARE: Any
RICH_COMPARE: Any

class DefaultValue(IntEnum):
    unspecified: int = ...
    constant: int = ...
    missing: int = ...
    object: int = ...
    list_copy: int = ...
    dict_copy: int = ...
    trait_list_object: int = ...
    trait_dict_object: int = ...
    callable_and_args: int = ...
    callable: int = ...
    trait_set_object: int = ...

MAXIMUM_DEFAULT_VALUE_TYPE: Any
default_value_map: Any
