"""	TimeFormat Test cases for TimeZone handling
	--------------------------------------------------------------------
	Copyright (c) 2004 Colin Stewart (http://www.owlfish.com/)
	All rights reserved.
	
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:
	1. Redistributions of source code must retain the above copyright
	   notice, this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright
	   notice, this list of conditions and the following disclaimer in the
	   documentation and/or other materials provided with the distribution.
	3. The name of the author may not be used to endorse or promote products
	   derived from this software without specific prior written permission.
	
	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
	IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
	NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""

import unittest, time, os
import timeformat


class strftimeTests (unittest.TestCase):
	def setUp (self):
		pass
		
	def tearDown (self):
		pass
		
	def testW3CTimeZoneEurope (self):
		os.environ['TZ'] = 'Europe/Paris'
		time.tzset()
		refDateTime = (2004, 5, 31, 18, 39, 27, 0, 152, 1)
		result = timeformat.format ('%Y-%m-%dT%H:%M:%S%z', refDateTime)
		expectedResult = '2004-05-31T18:39:27+02:00'
		self.failUnless (result == expectedResult, "W3C Time failed.  Expected %s actual result: %s" % (expectedResult, result))
		
	def testW3CTimeZoneCanada (self):
		os.environ['TZ'] = 'Canada/Eastern'
		time.tzset()
		refDateTime = (2004, 5, 31, 18, 39, 27, 0, 152, 1)
		result = timeformat.format ('%Y-%m-%dT%H:%M:%S%z', refDateTime)
		expectedResult = '2004-05-31T18:39:27-04:00'
		self.failUnless (result == expectedResult, "W3C Time failed.  Expected %s actual result: %s" % (expectedResult, result))
		
	def testW3CTimeZoneGMT (self):
		refDateTime = (2004, 5, 31, 18, 39, 27, 0, 152, 1)
		result = timeformat.format ('%Y-%m-%dT%H:%M:%S%z', refDateTime, utctime=1)
		expectedResult = '2004-05-31T18:39:27Z'
		self.failUnless (result == expectedResult, "W3C Time failed.  Expected %s actual result: %s" % (expectedResult, result))
		
	def testTimeZoneNameEurope (self):
		os.environ['TZ'] = 'Europe/Paris'
		time.tzset()
		refDateTime = (2004, 5, 31, 18, 39, 27, 0, 152, 1)
		result = timeformat.format ('%Y-%m-%dT%H:%M:%S%Z', refDateTime)
		expectedResult = '2004-05-31T18:39:27CEST'
		self.failUnless (result == expectedResult, "TimeZone Name failed.  Expected %s actual result: %s" % (expectedResult, result))
		
	def testTimeZoneNameCanada (self):
		os.environ['TZ'] = 'Canada/Eastern'
		time.tzset()
		refDateTime = (2004, 5, 31, 18, 39, 27, 0, 152, 1)
		result = timeformat.format ('%Y-%m-%dT%H:%M:%S%Z', refDateTime)
		expectedResult = '2004-05-31T18:39:27EDT'
		self.failUnless (result == expectedResult, "TimeZone Name failed.  Expected %s actual result: %s" % (expectedResult, result))
		
if __name__ == '__main__':
	unittest.main()