#!/usr/bin/env python
#
# Copyright (C) 2003 Gerome Fournier
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


DESCRIPTION = "module for creating simple ASCII tables"

LONG_DESCRIPTION = """\
texttable is a module to generate a formatted text table, using ASCII
characters."""

import sys

from distutils.core import setup
if sys.version < '2.2.3':
    from distutils.dist import DistributionMetadata
    DistributionMetadata.classifiers = None
    DistributionMetadata.download_url = None

setup(
    name = "texttable",
    version = "0.6.0",
    author = "Gerome Fournier", 
    author_email = "jefke(at)free.fr",
    url = "http://jefke.free.fr/coding/python/",
    download_url = "http://jefke.free.fr/stuff/python/texttable/texttable-0.6.0.tar.gz",
    license = "GPL",
    py_modules = ["texttable"],
    description = DESCRIPTION,
    long_description = LONG_DESCRIPTION,
    platforms = "any",
    classifiers = [
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX',
        'Operating System :: MacOS',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Text Processing',
        'Topic :: Utilities',
    ]
)
