## TFSA-2020-026: Segfault in `tf.raw_ops.Switch` in eager mode

### CVE Number
CVE-2020-15190

### Impact
The
[`tf.raw_ops.Switch`](https://www.tensorflow.org/api_docs/python/tf/raw_ops/Switch)
operation takes as input a tensor and a boolean and outputs two tensors.
Depending on the boolean value, one of the tensors is exactly the input tensor
whereas the other one should be an empty tensor.

However, the eager runtime [traverses all tensors in the
output](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/common_runtime/eager/kernel_and_device.cc#L308-L313):
```cc
  if (outputs != nullptr) {
    outputs->clear();
    for (int i = 0; i < context.num_outputs(); ++i) {
      outputs->push_back(Tensor(*context.mutable_output(i)));
    }
  }
```

Since only one of the tensors is defined, the other one is `nullptr`, hence we
are binding a reference to `nullptr`. This is undefined behavior and reported as
an error if compiling with `-fsanitize=null`. In this case, this results in a
segmentation fault.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[da8558533d925694483d2c136a9220d6d49d843c](https://github.com/tensorflow/tensorflow/commit/da8558533d925694483d2c136a9220d6d49d843c)
and will release a patch release for all affected versions.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
