/* Copyright 2020 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/
// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_SERIALIZATIONBASE_TFLITE_GPU_DATA_H_
#define FLATBUFFERS_GENERATED_SERIALIZATIONBASE_TFLITE_GPU_DATA_H_

#include "flatbuffers/flatbuffers.h"

namespace tflite {
namespace gpu {
namespace data {

struct Int4;
struct Int4Builder;

struct Int3;
struct Int3Builder;

struct Int2;
struct Int2Builder;

struct StateVariable;
struct StateVariableBuilder;

struct GPUObjectDescriptor;
struct GPUObjectDescriptorBuilder;

struct IntValue;
struct IntValueBuilder;

struct FloatValue;
struct FloatValueBuilder;

struct HalfValue;
struct HalfValueBuilder;

struct BufferDescriptor;
struct BufferDescriptorBuilder;

struct Texture2DDescriptor;
struct Texture2DDescriptorBuilder;

struct TensorLinearDescriptor;
struct TensorLinearDescriptorBuilder;

struct BHWDC;
struct BHWDCBuilder;

struct TensorDescriptor;
struct TensorDescriptorBuilder;

struct BufferDescriptorMapValue;
struct BufferDescriptorMapValueBuilder;

struct Texture2DDescriptorMapValue;
struct Texture2DDescriptorMapValueBuilder;

struct TensorLinearDescriptorMapValue;
struct TensorLinearDescriptorMapValueBuilder;

struct TensorDescriptorMapValue;
struct TensorDescriptorMapValueBuilder;

struct Arguments;
struct ArgumentsBuilder;

struct OperationDef;
struct OperationDefBuilder;

struct CompilerOption;
struct CompilerOptionBuilder;

struct GPUOperation;
struct GPUOperationBuilder;

enum class AccessType : int8_t {
  READ = 0,
  WRITE = 1,
  READ_WRITE = 2,
  MIN = READ,
  MAX = READ_WRITE
};

inline const AccessType (&EnumValuesAccessType())[3] {
  static const AccessType values[] = {
    AccessType::READ,
    AccessType::WRITE,
    AccessType::READ_WRITE
  };
  return values;
}

inline const char * const *EnumNamesAccessType() {
  static const char * const names[4] = {
    "READ",
    "WRITE",
    "READ_WRITE",
    nullptr
  };
  return names;
}

inline const char *EnumNameAccessType(AccessType e) {
  if (flatbuffers::IsOutRange(e, AccessType::READ, AccessType::READ_WRITE)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesAccessType()[index];
}

enum class DataType : int8_t {
  UNKNOWN = 0,
  FLOAT16 = 1,
  FLOAT32 = 2,
  FLOAT64 = 3,
  UINT8 = 4,
  INT8 = 5,
  UINT16 = 6,
  INT16 = 7,
  UINT32 = 8,
  INT32 = 9,
  UINT64 = 10,
  INT64 = 11,
  MIN = UNKNOWN,
  MAX = INT64
};

inline const DataType (&EnumValuesDataType())[12] {
  static const DataType values[] = {
      DataType::UNKNOWN, DataType::FLOAT16, DataType::FLOAT32,
      DataType::FLOAT64, DataType::UINT8,   DataType::INT8,
      DataType::UINT16,  DataType::INT16,   DataType::UINT32,
      DataType::INT32,   DataType::UINT64,  DataType::INT64};
  return values;
}

inline const char * const *EnumNamesDataType() {
  static const char *const names[13] = {
      "UNKNOWN", "FLOAT16", "FLOAT32", "FLOAT64", "UINT8", "INT8", "UINT16",
      "INT16",   "UINT32",  "INT32",   "UINT64",  "INT64", nullptr};
  return names;
}

inline const char *EnumNameDataType(DataType e) {
  if (flatbuffers::IsOutRange(e, DataType::UNKNOWN, DataType::INT64)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesDataType()[index];
}

enum class MemoryType : int8_t {
  GLOBAL = 0,
  CONSTANT = 1,
  LOCAL = 2,
  MIN = GLOBAL,
  MAX = LOCAL
};

inline const MemoryType (&EnumValuesMemoryType())[3] {
  static const MemoryType values[] = {
    MemoryType::GLOBAL,
    MemoryType::CONSTANT,
    MemoryType::LOCAL
  };
  return values;
}

inline const char * const *EnumNamesMemoryType() {
  static const char * const names[4] = {
    "GLOBAL",
    "CONSTANT",
    "LOCAL",
    nullptr
  };
  return names;
}

inline const char *EnumNameMemoryType(MemoryType e) {
  if (flatbuffers::IsOutRange(e, MemoryType::GLOBAL, MemoryType::LOCAL)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesMemoryType()[index];
}

enum class LinearStorageType : int8_t {
  BUFFER = 0,
  TEXTURE_2D = 1,
  MIN = BUFFER,
  MAX = TEXTURE_2D
};

inline const LinearStorageType (&EnumValuesLinearStorageType())[2] {
  static const LinearStorageType values[] = {
    LinearStorageType::BUFFER,
    LinearStorageType::TEXTURE_2D
  };
  return values;
}

inline const char * const *EnumNamesLinearStorageType() {
  static const char * const names[3] = {
    "BUFFER",
    "TEXTURE_2D",
    nullptr
  };
  return names;
}

inline const char *EnumNameLinearStorageType(LinearStorageType e) {
  if (flatbuffers::IsOutRange(e, LinearStorageType::BUFFER, LinearStorageType::TEXTURE_2D)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesLinearStorageType()[index];
}

enum class TensorStorageType : int8_t {
  UNKNOWN = 0,
  BUFFER = 1,
  IMAGE_BUFFER = 2,
  TEXTURE_2D = 3,
  TEXTURE_3D = 4,
  TEXTURE_ARRAY = 5,
  SINGLE_TEXTURE_2D = 6,
  MIN = UNKNOWN,
  MAX = SINGLE_TEXTURE_2D
};

inline const TensorStorageType (&EnumValuesTensorStorageType())[7] {
  static const TensorStorageType values[] = {
    TensorStorageType::UNKNOWN,
    TensorStorageType::BUFFER,
    TensorStorageType::IMAGE_BUFFER,
    TensorStorageType::TEXTURE_2D,
    TensorStorageType::TEXTURE_3D,
    TensorStorageType::TEXTURE_ARRAY,
    TensorStorageType::SINGLE_TEXTURE_2D
  };
  return values;
}

inline const char * const *EnumNamesTensorStorageType() {
  static const char * const names[8] = {
    "UNKNOWN",
    "BUFFER",
    "IMAGE_BUFFER",
    "TEXTURE_2D",
    "TEXTURE_3D",
    "TEXTURE_ARRAY",
    "SINGLE_TEXTURE_2D",
    nullptr
  };
  return names;
}

inline const char *EnumNameTensorStorageType(TensorStorageType e) {
  if (flatbuffers::IsOutRange(e, TensorStorageType::UNKNOWN, TensorStorageType::SINGLE_TEXTURE_2D)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesTensorStorageType()[index];
}

enum class Layout : int8_t {
  UNKNOWN = 0,
  HWC = 1,
  BHWC = 2,
  HWDC = 3,
  BHWDC = 4,
  MIN = UNKNOWN,
  MAX = BHWDC
};

inline const Layout (&EnumValuesLayout())[5] {
  static const Layout values[] = {
    Layout::UNKNOWN,
    Layout::HWC,
    Layout::BHWC,
    Layout::HWDC,
    Layout::BHWDC
  };
  return values;
}

inline const char * const *EnumNamesLayout() {
  static const char * const names[6] = {
    "UNKNOWN",
    "HWC",
    "BHWC",
    "HWDC",
    "BHWDC",
    nullptr
  };
  return names;
}

inline const char *EnumNameLayout(Layout e) {
  if (flatbuffers::IsOutRange(e, Layout::UNKNOWN, Layout::BHWDC)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesLayout()[index];
}

enum class CalculationsPrecision : int8_t {
  F32 = 0,
  F32_F16 = 1,
  F16 = 2,
  MIN = F32,
  MAX = F16
};

inline const CalculationsPrecision (&EnumValuesCalculationsPrecision())[3] {
  static const CalculationsPrecision values[] = {CalculationsPrecision::F32,
                                                 CalculationsPrecision::F32_F16,
                                                 CalculationsPrecision::F16};
  return values;
}

inline const char *const *EnumNamesCalculationsPrecision() {
  static const char *const names[4] = {"F32", "F32_F16", "F16", nullptr};
  return names;
}

inline const char *EnumNameCalculationsPrecision(CalculationsPrecision e) {
  if (flatbuffers::IsOutRange(e, CalculationsPrecision::F32,
                              CalculationsPrecision::F16))
    return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesCalculationsPrecision()[index];
}

enum class TensorToGrid : int8_t {
  CUSTOM = 0,
  WB_TO_X_HD_TO_Y_S_TO_Z = 1,
  WB_TO_X_HD_TO_Y_Z_IS_1 = 2,
  WB_TO_X_H_TO_Y_D_TO_Z = 3,
  B_TO_X_Y_IS_1_Z_IS_1 = 4,
  MIN = CUSTOM,
  MAX = B_TO_X_Y_IS_1_Z_IS_1
};

inline const TensorToGrid (&EnumValuesTensorToGrid())[5] {
  static const TensorToGrid values[] = {
      TensorToGrid::CUSTOM, TensorToGrid::WB_TO_X_HD_TO_Y_S_TO_Z,
      TensorToGrid::WB_TO_X_HD_TO_Y_Z_IS_1, TensorToGrid::WB_TO_X_H_TO_Y_D_TO_Z,
      TensorToGrid::B_TO_X_Y_IS_1_Z_IS_1};
  return values;
}

inline const char *const *EnumNamesTensorToGrid() {
  static const char *const names[6] = {"CUSTOM",
                                       "WB_TO_X_HD_TO_Y_S_TO_Z",
                                       "WB_TO_X_HD_TO_Y_Z_IS_1",
                                       "WB_TO_X_H_TO_Y_D_TO_Z",
                                       "B_TO_X_Y_IS_1_Z_IS_1",
                                       nullptr};
  return names;
}

inline const char *EnumNameTensorToGrid(TensorToGrid e) {
  if (flatbuffers::IsOutRange(e, TensorToGrid::CUSTOM,
                              TensorToGrid::B_TO_X_Y_IS_1_Z_IS_1))
    return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesTensorToGrid()[index];
}

enum class CompilerOptions : int8_t {
  ADRENO_FULL_SIMD_LINE = 0,
  ADRENO_MORE_WAVES = 1,
  CL_FAST_RELAXED_MATH = 2,
  CL_OPT_DISABLE = 3,
  CL_2_0 = 4,
  CL_3_0 = 5,
  MIN = ADRENO_FULL_SIMD_LINE,
  MAX = CL_3_0
};

inline const CompilerOptions (&EnumValuesCompilerOptions())[6] {
  static const CompilerOptions values[] = {
      CompilerOptions::ADRENO_FULL_SIMD_LINE,
      CompilerOptions::ADRENO_MORE_WAVES,
      CompilerOptions::CL_FAST_RELAXED_MATH,
      CompilerOptions::CL_OPT_DISABLE,
      CompilerOptions::CL_2_0,
      CompilerOptions::CL_3_0};
  return values;
}

inline const char *const *EnumNamesCompilerOptions() {
  static const char *const names[7] = {"ADRENO_FULL_SIMD_LINE",
                                       "ADRENO_MORE_WAVES",
                                       "CL_FAST_RELAXED_MATH",
                                       "CL_OPT_DISABLE",
                                       "CL_2_0",
                                       "CL_3_0",
                                       nullptr};
  return names;
}

inline const char *EnumNameCompilerOptions(CompilerOptions e) {
  if (flatbuffers::IsOutRange(e, CompilerOptions::ADRENO_FULL_SIMD_LINE,
                              CompilerOptions::CL_3_0))
    return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesCompilerOptions()[index];
}

struct Int4 FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int4Builder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_X = 4,
    VT_Y = 6,
    VT_Z = 8,
    VT_W = 10
  };
  int32_t x() const {
    return GetField<int32_t>(VT_X, 0);
  }
  int32_t y() const {
    return GetField<int32_t>(VT_Y, 0);
  }
  int32_t z() const {
    return GetField<int32_t>(VT_Z, 0);
  }
  int32_t w() const {
    return GetField<int32_t>(VT_W, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_X) &&
           VerifyField<int32_t>(verifier, VT_Y) &&
           VerifyField<int32_t>(verifier, VT_Z) &&
           VerifyField<int32_t>(verifier, VT_W) &&
           verifier.EndTable();
  }
};

struct Int4Builder {
  typedef Int4 Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_x(int32_t x) {
    fbb_.AddElement<int32_t>(Int4::VT_X, x, 0);
  }
  void add_y(int32_t y) {
    fbb_.AddElement<int32_t>(Int4::VT_Y, y, 0);
  }
  void add_z(int32_t z) {
    fbb_.AddElement<int32_t>(Int4::VT_Z, z, 0);
  }
  void add_w(int32_t w) {
    fbb_.AddElement<int32_t>(Int4::VT_W, w, 0);
  }
  explicit Int4Builder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Int4> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int4>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int4> CreateInt4(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t x = 0,
    int32_t y = 0,
    int32_t z = 0,
    int32_t w = 0) {
  Int4Builder builder_(_fbb);
  builder_.add_w(w);
  builder_.add_z(z);
  builder_.add_y(y);
  builder_.add_x(x);
  return builder_.Finish();
}

struct Int3 FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int3Builder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_X = 4,
    VT_Y = 6,
    VT_Z = 8
  };
  int32_t x() const {
    return GetField<int32_t>(VT_X, 0);
  }
  int32_t y() const {
    return GetField<int32_t>(VT_Y, 0);
  }
  int32_t z() const {
    return GetField<int32_t>(VT_Z, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_X) &&
           VerifyField<int32_t>(verifier, VT_Y) &&
           VerifyField<int32_t>(verifier, VT_Z) &&
           verifier.EndTable();
  }
};

struct Int3Builder {
  typedef Int3 Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_x(int32_t x) {
    fbb_.AddElement<int32_t>(Int3::VT_X, x, 0);
  }
  void add_y(int32_t y) {
    fbb_.AddElement<int32_t>(Int3::VT_Y, y, 0);
  }
  void add_z(int32_t z) {
    fbb_.AddElement<int32_t>(Int3::VT_Z, z, 0);
  }
  explicit Int3Builder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Int3> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int3>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int3> CreateInt3(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t x = 0,
    int32_t y = 0,
    int32_t z = 0) {
  Int3Builder builder_(_fbb);
  builder_.add_z(z);
  builder_.add_y(y);
  builder_.add_x(x);
  return builder_.Finish();
}

struct Int2 FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int2Builder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_X = 4,
    VT_Y = 6
  };
  int32_t x() const {
    return GetField<int32_t>(VT_X, 0);
  }
  int32_t y() const {
    return GetField<int32_t>(VT_Y, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_X) &&
           VerifyField<int32_t>(verifier, VT_Y) &&
           verifier.EndTable();
  }
};

struct Int2Builder {
  typedef Int2 Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_x(int32_t x) {
    fbb_.AddElement<int32_t>(Int2::VT_X, x, 0);
  }
  void add_y(int32_t y) {
    fbb_.AddElement<int32_t>(Int2::VT_Y, y, 0);
  }
  explicit Int2Builder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Int2> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int2>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int2> CreateInt2(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t x = 0,
    int32_t y = 0) {
  Int2Builder builder_(_fbb);
  builder_.add_y(y);
  builder_.add_x(x);
  return builder_.Finish();
}

struct StateVariable FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef StateVariableBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const flatbuffers::String *key() const {
    return GetPointer<const flatbuffers::String *>(VT_KEY);
  }
  const flatbuffers::String *value() const {
    return GetPointer<const flatbuffers::String *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           verifier.EndTable();
  }
};

struct StateVariableBuilder {
  typedef StateVariable Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_key(flatbuffers::Offset<flatbuffers::String> key) {
    fbb_.AddOffset(StateVariable::VT_KEY, key);
  }
  void add_value(flatbuffers::Offset<flatbuffers::String> value) {
    fbb_.AddOffset(StateVariable::VT_VALUE, value);
  }
  explicit StateVariableBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<StateVariable> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<StateVariable>(end);
    return o;
  }
};

inline flatbuffers::Offset<StateVariable> CreateStateVariable(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> key = 0,
    flatbuffers::Offset<flatbuffers::String> value = 0) {
  StateVariableBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline flatbuffers::Offset<StateVariable> CreateStateVariableDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    const char *value = nullptr) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  return tflite::gpu::data::CreateStateVariable(
      _fbb,
      key__,
      value__);
}

struct GPUObjectDescriptor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef GPUObjectDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_STATE_VARS = 4,
    VT_ACCESS_TYPE = 6
  };
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::StateVariable>> *state_vars() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::StateVariable>> *>(VT_STATE_VARS);
  }
  tflite::gpu::data::AccessType access_type() const {
    return static_cast<tflite::gpu::data::AccessType>(GetField<int8_t>(VT_ACCESS_TYPE, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_STATE_VARS) &&
           verifier.VerifyVector(state_vars()) &&
           verifier.VerifyVectorOfTables(state_vars()) &&
           VerifyField<int8_t>(verifier, VT_ACCESS_TYPE) &&
           verifier.EndTable();
  }
};

struct GPUObjectDescriptorBuilder {
  typedef GPUObjectDescriptor Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_state_vars(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::StateVariable>>> state_vars) {
    fbb_.AddOffset(GPUObjectDescriptor::VT_STATE_VARS, state_vars);
  }
  void add_access_type(tflite::gpu::data::AccessType access_type) {
    fbb_.AddElement<int8_t>(GPUObjectDescriptor::VT_ACCESS_TYPE, static_cast<int8_t>(access_type), 0);
  }
  explicit GPUObjectDescriptorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<GPUObjectDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<GPUObjectDescriptor>(end);
    return o;
  }
};

inline flatbuffers::Offset<GPUObjectDescriptor> CreateGPUObjectDescriptor(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::StateVariable>>> state_vars = 0,
    tflite::gpu::data::AccessType access_type = tflite::gpu::data::AccessType::READ) {
  GPUObjectDescriptorBuilder builder_(_fbb);
  builder_.add_state_vars(state_vars);
  builder_.add_access_type(access_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<GPUObjectDescriptor> CreateGPUObjectDescriptorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::StateVariable>> *state_vars = nullptr,
    tflite::gpu::data::AccessType access_type = tflite::gpu::data::AccessType::READ) {
  auto state_vars__ = state_vars ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::StateVariable>>(*state_vars) : 0;
  return tflite::gpu::data::CreateGPUObjectDescriptor(
      _fbb,
      state_vars__,
      access_type);
}

struct IntValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef IntValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VALUE = 6,
    VT_ACTIVE = 8
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  int32_t value() const {
    return GetField<int32_t>(VT_VALUE, 0);
  }
  bool active() const {
    return GetField<uint8_t>(VT_ACTIVE, 0) != 0;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<int32_t>(verifier, VT_VALUE) &&
           VerifyField<uint8_t>(verifier, VT_ACTIVE) &&
           verifier.EndTable();
  }
};

struct IntValueBuilder {
  typedef IntValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(IntValue::VT_NAME, name);
  }
  void add_value(int32_t value) {
    fbb_.AddElement<int32_t>(IntValue::VT_VALUE, value, 0);
  }
  void add_active(bool active) {
    fbb_.AddElement<uint8_t>(IntValue::VT_ACTIVE, static_cast<uint8_t>(active), 0);
  }
  explicit IntValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<IntValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<IntValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<IntValue> CreateIntValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    int32_t value = 0,
    bool active = false) {
  IntValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_name(name);
  builder_.add_active(active);
  return builder_.Finish();
}

inline flatbuffers::Offset<IntValue> CreateIntValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    int32_t value = 0,
    bool active = false) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return tflite::gpu::data::CreateIntValue(
      _fbb,
      name__,
      value,
      active);
}

struct FloatValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef FloatValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VALUE = 6,
    VT_ACTIVE = 8
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  float value() const {
    return GetField<float>(VT_VALUE, 0.0f);
  }
  bool active() const {
    return GetField<uint8_t>(VT_ACTIVE, 0) != 0;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<float>(verifier, VT_VALUE) &&
           VerifyField<uint8_t>(verifier, VT_ACTIVE) &&
           verifier.EndTable();
  }
};

struct FloatValueBuilder {
  typedef FloatValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(FloatValue::VT_NAME, name);
  }
  void add_value(float value) {
    fbb_.AddElement<float>(FloatValue::VT_VALUE, value, 0.0f);
  }
  void add_active(bool active) {
    fbb_.AddElement<uint8_t>(FloatValue::VT_ACTIVE, static_cast<uint8_t>(active), 0);
  }
  explicit FloatValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<FloatValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<FloatValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<FloatValue> CreateFloatValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    float value = 0.0f,
    bool active = false) {
  FloatValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_name(name);
  builder_.add_active(active);
  return builder_.Finish();
}

inline flatbuffers::Offset<FloatValue> CreateFloatValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    float value = 0.0f,
    bool active = false) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return tflite::gpu::data::CreateFloatValue(
      _fbb,
      name__,
      value,
      active);
}

struct HalfValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef HalfValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VALUE = 6,
    VT_ACTIVE = 8
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  float value() const {
    return GetField<float>(VT_VALUE, 0.0f);
  }
  bool active() const {
    return GetField<uint8_t>(VT_ACTIVE, 0) != 0;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<float>(verifier, VT_VALUE) &&
           VerifyField<uint8_t>(verifier, VT_ACTIVE) &&
           verifier.EndTable();
  }
};

struct HalfValueBuilder {
  typedef HalfValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(HalfValue::VT_NAME, name);
  }
  void add_value(float value) {
    fbb_.AddElement<float>(HalfValue::VT_VALUE, value, 0.0f);
  }
  void add_active(bool active) {
    fbb_.AddElement<uint8_t>(HalfValue::VT_ACTIVE, static_cast<uint8_t>(active), 0);
  }
  explicit HalfValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<HalfValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<HalfValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<HalfValue> CreateHalfValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    float value = 0.0f,
    bool active = false) {
  HalfValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_name(name);
  builder_.add_active(active);
  return builder_.Finish();
}

inline flatbuffers::Offset<HalfValue> CreateHalfValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    float value = 0.0f,
    bool active = false) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return tflite::gpu::data::CreateHalfValue(
      _fbb,
      name__,
      value,
      active);
}

struct BufferDescriptor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BufferDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BASE_OBJ = 4,
    VT_ELEMENT_TYPE = 6,
    VT_ELEMENT_SIZE = 8,
    VT_MEMORY_TYPE = 10,
    VT_ATTRIBUTES = 12,
    VT_SIZE = 14,
    VT_DATA = 16
  };
  const tflite::gpu::data::GPUObjectDescriptor *base_obj() const {
    return GetPointer<const tflite::gpu::data::GPUObjectDescriptor *>(VT_BASE_OBJ);
  }
  tflite::gpu::data::DataType element_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_ELEMENT_TYPE, 0));
  }
  int32_t element_size() const {
    return GetField<int32_t>(VT_ELEMENT_SIZE, 0);
  }
  tflite::gpu::data::MemoryType memory_type() const {
    return static_cast<tflite::gpu::data::MemoryType>(GetField<int8_t>(VT_MEMORY_TYPE, 0));
  }
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *attributes() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(VT_ATTRIBUTES);
  }
  int32_t size() const {
    return GetField<int32_t>(VT_SIZE, 0);
  }
  const flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BASE_OBJ) &&
           verifier.VerifyTable(base_obj()) &&
           VerifyField<int8_t>(verifier, VT_ELEMENT_TYPE) &&
           VerifyField<int32_t>(verifier, VT_ELEMENT_SIZE) &&
           VerifyField<int8_t>(verifier, VT_MEMORY_TYPE) &&
           VerifyOffset(verifier, VT_ATTRIBUTES) &&
           verifier.VerifyVector(attributes()) &&
           verifier.VerifyVectorOfStrings(attributes()) &&
           VerifyField<int32_t>(verifier, VT_SIZE) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           verifier.EndTable();
  }
};

struct BufferDescriptorBuilder {
  typedef BufferDescriptor Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_base_obj(flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj) {
    fbb_.AddOffset(BufferDescriptor::VT_BASE_OBJ, base_obj);
  }
  void add_element_type(tflite::gpu::data::DataType element_type) {
    fbb_.AddElement<int8_t>(BufferDescriptor::VT_ELEMENT_TYPE, static_cast<int8_t>(element_type), 0);
  }
  void add_element_size(int32_t element_size) {
    fbb_.AddElement<int32_t>(BufferDescriptor::VT_ELEMENT_SIZE, element_size, 0);
  }
  void add_memory_type(tflite::gpu::data::MemoryType memory_type) {
    fbb_.AddElement<int8_t>(BufferDescriptor::VT_MEMORY_TYPE, static_cast<int8_t>(memory_type), 0);
  }
  void add_attributes(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> attributes) {
    fbb_.AddOffset(BufferDescriptor::VT_ATTRIBUTES, attributes);
  }
  void add_size(int32_t size) {
    fbb_.AddElement<int32_t>(BufferDescriptor::VT_SIZE, size, 0);
  }
  void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(BufferDescriptor::VT_DATA, data);
  }
  explicit BufferDescriptorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<BufferDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<BufferDescriptor>(end);
    return o;
  }
};

inline flatbuffers::Offset<BufferDescriptor> CreateBufferDescriptor(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    int32_t element_size = 0,
    tflite::gpu::data::MemoryType memory_type = tflite::gpu::data::MemoryType::GLOBAL,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> attributes = 0,
    int32_t size = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data = 0) {
  BufferDescriptorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_size(size);
  builder_.add_attributes(attributes);
  builder_.add_element_size(element_size);
  builder_.add_base_obj(base_obj);
  builder_.add_memory_type(memory_type);
  builder_.add_element_type(element_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<BufferDescriptor> CreateBufferDescriptorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    int32_t element_size = 0,
    tflite::gpu::data::MemoryType memory_type = tflite::gpu::data::MemoryType::GLOBAL,
    const std::vector<flatbuffers::Offset<flatbuffers::String>> *attributes = nullptr,
    int32_t size = 0,
    const std::vector<uint8_t> *data = nullptr) {
  auto attributes__ = attributes ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(*attributes) : 0;
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  return tflite::gpu::data::CreateBufferDescriptor(
      _fbb,
      base_obj,
      element_type,
      element_size,
      memory_type,
      attributes__,
      size,
      data__);
}

struct Texture2DDescriptor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Texture2DDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BASE_OBJ = 4,
    VT_ELEMENT_TYPE = 6,
    VT_NORMALIZED = 8,
    VT_NORMALIZED_TYPE = 10,
    VT_SIZE = 12,
    VT_DATA = 14
  };
  const tflite::gpu::data::GPUObjectDescriptor *base_obj() const {
    return GetPointer<const tflite::gpu::data::GPUObjectDescriptor *>(VT_BASE_OBJ);
  }
  tflite::gpu::data::DataType element_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_ELEMENT_TYPE, 0));
  }
  bool normalized() const {
    return GetField<uint8_t>(VT_NORMALIZED, 0) != 0;
  }
  tflite::gpu::data::DataType normalized_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_NORMALIZED_TYPE, 0));
  }
  const tflite::gpu::data::Int2 *size() const {
    return GetPointer<const tflite::gpu::data::Int2 *>(VT_SIZE);
  }
  const flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BASE_OBJ) &&
           verifier.VerifyTable(base_obj()) &&
           VerifyField<int8_t>(verifier, VT_ELEMENT_TYPE) &&
           VerifyField<uint8_t>(verifier, VT_NORMALIZED) &&
           VerifyField<int8_t>(verifier, VT_NORMALIZED_TYPE) &&
           VerifyOffset(verifier, VT_SIZE) &&
           verifier.VerifyTable(size()) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           verifier.EndTable();
  }
};

struct Texture2DDescriptorBuilder {
  typedef Texture2DDescriptor Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_base_obj(flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj) {
    fbb_.AddOffset(Texture2DDescriptor::VT_BASE_OBJ, base_obj);
  }
  void add_element_type(tflite::gpu::data::DataType element_type) {
    fbb_.AddElement<int8_t>(Texture2DDescriptor::VT_ELEMENT_TYPE, static_cast<int8_t>(element_type), 0);
  }
  void add_normalized(bool normalized) {
    fbb_.AddElement<uint8_t>(Texture2DDescriptor::VT_NORMALIZED, static_cast<uint8_t>(normalized), 0);
  }
  void add_normalized_type(tflite::gpu::data::DataType normalized_type) {
    fbb_.AddElement<int8_t>(Texture2DDescriptor::VT_NORMALIZED_TYPE, static_cast<int8_t>(normalized_type), 0);
  }
  void add_size(flatbuffers::Offset<tflite::gpu::data::Int2> size) {
    fbb_.AddOffset(Texture2DDescriptor::VT_SIZE, size);
  }
  void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(Texture2DDescriptor::VT_DATA, data);
  }
  explicit Texture2DDescriptorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Texture2DDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Texture2DDescriptor>(end);
    return o;
  }
};

inline flatbuffers::Offset<Texture2DDescriptor> CreateTexture2DDescriptor(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    bool normalized = false,
    tflite::gpu::data::DataType normalized_type = tflite::gpu::data::DataType::UNKNOWN,
    flatbuffers::Offset<tflite::gpu::data::Int2> size = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data = 0) {
  Texture2DDescriptorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_size(size);
  builder_.add_base_obj(base_obj);
  builder_.add_normalized_type(normalized_type);
  builder_.add_normalized(normalized);
  builder_.add_element_type(element_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<Texture2DDescriptor> CreateTexture2DDescriptorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    bool normalized = false,
    tflite::gpu::data::DataType normalized_type = tflite::gpu::data::DataType::UNKNOWN,
    flatbuffers::Offset<tflite::gpu::data::Int2> size = 0,
    const std::vector<uint8_t> *data = nullptr) {
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  return tflite::gpu::data::CreateTexture2DDescriptor(
      _fbb,
      base_obj,
      element_type,
      normalized,
      normalized_type,
      size,
      data__);
}

struct TensorLinearDescriptor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorLinearDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BASE_OBJ = 4,
    VT_STORAGE_TYPE = 6,
    VT_ELEMENT_TYPE = 8,
    VT_MEMORY_TYPE = 10,
    VT_SIZE = 12,
    VT_DATA = 14
  };
  const tflite::gpu::data::GPUObjectDescriptor *base_obj() const {
    return GetPointer<const tflite::gpu::data::GPUObjectDescriptor *>(VT_BASE_OBJ);
  }
  tflite::gpu::data::LinearStorageType storage_type() const {
    return static_cast<tflite::gpu::data::LinearStorageType>(GetField<int8_t>(VT_STORAGE_TYPE, 0));
  }
  tflite::gpu::data::DataType element_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_ELEMENT_TYPE, 0));
  }
  tflite::gpu::data::MemoryType memory_type() const {
    return static_cast<tflite::gpu::data::MemoryType>(GetField<int8_t>(VT_MEMORY_TYPE, 0));
  }
  int32_t size() const {
    return GetField<int32_t>(VT_SIZE, 0);
  }
  const flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BASE_OBJ) &&
           verifier.VerifyTable(base_obj()) &&
           VerifyField<int8_t>(verifier, VT_STORAGE_TYPE) &&
           VerifyField<int8_t>(verifier, VT_ELEMENT_TYPE) &&
           VerifyField<int8_t>(verifier, VT_MEMORY_TYPE) &&
           VerifyField<int32_t>(verifier, VT_SIZE) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           verifier.EndTable();
  }
};

struct TensorLinearDescriptorBuilder {
  typedef TensorLinearDescriptor Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_base_obj(flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj) {
    fbb_.AddOffset(TensorLinearDescriptor::VT_BASE_OBJ, base_obj);
  }
  void add_storage_type(tflite::gpu::data::LinearStorageType storage_type) {
    fbb_.AddElement<int8_t>(TensorLinearDescriptor::VT_STORAGE_TYPE, static_cast<int8_t>(storage_type), 0);
  }
  void add_element_type(tflite::gpu::data::DataType element_type) {
    fbb_.AddElement<int8_t>(TensorLinearDescriptor::VT_ELEMENT_TYPE, static_cast<int8_t>(element_type), 0);
  }
  void add_memory_type(tflite::gpu::data::MemoryType memory_type) {
    fbb_.AddElement<int8_t>(TensorLinearDescriptor::VT_MEMORY_TYPE, static_cast<int8_t>(memory_type), 0);
  }
  void add_size(int32_t size) {
    fbb_.AddElement<int32_t>(TensorLinearDescriptor::VT_SIZE, size, 0);
  }
  void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(TensorLinearDescriptor::VT_DATA, data);
  }
  explicit TensorLinearDescriptorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<TensorLinearDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<TensorLinearDescriptor>(end);
    return o;
  }
};

inline flatbuffers::Offset<TensorLinearDescriptor> CreateTensorLinearDescriptor(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::LinearStorageType storage_type = tflite::gpu::data::LinearStorageType::BUFFER,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    tflite::gpu::data::MemoryType memory_type = tflite::gpu::data::MemoryType::GLOBAL,
    int32_t size = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data = 0) {
  TensorLinearDescriptorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_size(size);
  builder_.add_base_obj(base_obj);
  builder_.add_memory_type(memory_type);
  builder_.add_element_type(element_type);
  builder_.add_storage_type(storage_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<TensorLinearDescriptor> CreateTensorLinearDescriptorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::LinearStorageType storage_type = tflite::gpu::data::LinearStorageType::BUFFER,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    tflite::gpu::data::MemoryType memory_type = tflite::gpu::data::MemoryType::GLOBAL,
    int32_t size = 0,
    const std::vector<uint8_t> *data = nullptr) {
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  return tflite::gpu::data::CreateTensorLinearDescriptor(
      _fbb,
      base_obj,
      storage_type,
      element_type,
      memory_type,
      size,
      data__);
}

struct BHWDC FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BHWDCBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_B = 4,
    VT_H = 6,
    VT_W = 8,
    VT_D = 10,
    VT_C = 12
  };
  int32_t b() const {
    return GetField<int32_t>(VT_B, 0);
  }
  int32_t h() const {
    return GetField<int32_t>(VT_H, 0);
  }
  int32_t w() const {
    return GetField<int32_t>(VT_W, 0);
  }
  int32_t d() const {
    return GetField<int32_t>(VT_D, 0);
  }
  int32_t c() const {
    return GetField<int32_t>(VT_C, 0);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_B) &&
           VerifyField<int32_t>(verifier, VT_H) &&
           VerifyField<int32_t>(verifier, VT_W) &&
           VerifyField<int32_t>(verifier, VT_D) &&
           VerifyField<int32_t>(verifier, VT_C) &&
           verifier.EndTable();
  }
};

struct BHWDCBuilder {
  typedef BHWDC Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_b(int32_t b) {
    fbb_.AddElement<int32_t>(BHWDC::VT_B, b, 0);
  }
  void add_h(int32_t h) {
    fbb_.AddElement<int32_t>(BHWDC::VT_H, h, 0);
  }
  void add_w(int32_t w) {
    fbb_.AddElement<int32_t>(BHWDC::VT_W, w, 0);
  }
  void add_d(int32_t d) {
    fbb_.AddElement<int32_t>(BHWDC::VT_D, d, 0);
  }
  void add_c(int32_t c) {
    fbb_.AddElement<int32_t>(BHWDC::VT_C, c, 0);
  }
  explicit BHWDCBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<BHWDC> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<BHWDC>(end);
    return o;
  }
};

inline flatbuffers::Offset<BHWDC> CreateBHWDC(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t b = 0,
    int32_t h = 0,
    int32_t w = 0,
    int32_t d = 0,
    int32_t c = 0) {
  BHWDCBuilder builder_(_fbb);
  builder_.add_c(c);
  builder_.add_d(d);
  builder_.add_w(w);
  builder_.add_h(h);
  builder_.add_b(b);
  return builder_.Finish();
}

struct TensorDescriptor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BASE_OBJ = 4,
    VT_DATA_TYPE = 6,
    VT_STORAGE_TYPE = 8,
    VT_LAYOUT = 10,
    VT_SHAPE = 12,
    VT_DATA = 14
  };
  const tflite::gpu::data::GPUObjectDescriptor *base_obj() const {
    return GetPointer<const tflite::gpu::data::GPUObjectDescriptor *>(VT_BASE_OBJ);
  }
  tflite::gpu::data::DataType data_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_DATA_TYPE, 0));
  }
  tflite::gpu::data::TensorStorageType storage_type() const {
    return static_cast<tflite::gpu::data::TensorStorageType>(GetField<int8_t>(VT_STORAGE_TYPE, 0));
  }
  tflite::gpu::data::Layout layout() const {
    return static_cast<tflite::gpu::data::Layout>(GetField<int8_t>(VT_LAYOUT, 0));
  }
  const tflite::gpu::data::BHWDC *shape() const {
    return GetPointer<const tflite::gpu::data::BHWDC *>(VT_SHAPE);
  }
  const flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BASE_OBJ) &&
           verifier.VerifyTable(base_obj()) &&
           VerifyField<int8_t>(verifier, VT_DATA_TYPE) &&
           VerifyField<int8_t>(verifier, VT_STORAGE_TYPE) &&
           VerifyField<int8_t>(verifier, VT_LAYOUT) &&
           VerifyOffset(verifier, VT_SHAPE) &&
           verifier.VerifyTable(shape()) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           verifier.EndTable();
  }
};

struct TensorDescriptorBuilder {
  typedef TensorDescriptor Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_base_obj(flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj) {
    fbb_.AddOffset(TensorDescriptor::VT_BASE_OBJ, base_obj);
  }
  void add_data_type(tflite::gpu::data::DataType data_type) {
    fbb_.AddElement<int8_t>(TensorDescriptor::VT_DATA_TYPE, static_cast<int8_t>(data_type), 0);
  }
  void add_storage_type(tflite::gpu::data::TensorStorageType storage_type) {
    fbb_.AddElement<int8_t>(TensorDescriptor::VT_STORAGE_TYPE, static_cast<int8_t>(storage_type), 0);
  }
  void add_layout(tflite::gpu::data::Layout layout) {
    fbb_.AddElement<int8_t>(TensorDescriptor::VT_LAYOUT, static_cast<int8_t>(layout), 0);
  }
  void add_shape(flatbuffers::Offset<tflite::gpu::data::BHWDC> shape) {
    fbb_.AddOffset(TensorDescriptor::VT_SHAPE, shape);
  }
  void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(TensorDescriptor::VT_DATA, data);
  }
  explicit TensorDescriptorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<TensorDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<TensorDescriptor>(end);
    return o;
  }
};

inline flatbuffers::Offset<TensorDescriptor> CreateTensorDescriptor(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType data_type = tflite::gpu::data::DataType::UNKNOWN,
    tflite::gpu::data::TensorStorageType storage_type = tflite::gpu::data::TensorStorageType::UNKNOWN,
    tflite::gpu::data::Layout layout = tflite::gpu::data::Layout::UNKNOWN,
    flatbuffers::Offset<tflite::gpu::data::BHWDC> shape = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data = 0) {
  TensorDescriptorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_shape(shape);
  builder_.add_base_obj(base_obj);
  builder_.add_layout(layout);
  builder_.add_storage_type(storage_type);
  builder_.add_data_type(data_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<TensorDescriptor> CreateTensorDescriptorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType data_type = tflite::gpu::data::DataType::UNKNOWN,
    tflite::gpu::data::TensorStorageType storage_type = tflite::gpu::data::TensorStorageType::UNKNOWN,
    tflite::gpu::data::Layout layout = tflite::gpu::data::Layout::UNKNOWN,
    flatbuffers::Offset<tflite::gpu::data::BHWDC> shape = 0,
    const std::vector<uint8_t> *data = nullptr) {
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  return tflite::gpu::data::CreateTensorDescriptor(
      _fbb,
      base_obj,
      data_type,
      storage_type,
      layout,
      shape,
      data__);
}

struct BufferDescriptorMapValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BufferDescriptorMapValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const flatbuffers::String *key() const {
    return GetPointer<const flatbuffers::String *>(VT_KEY);
  }
  const tflite::gpu::data::BufferDescriptor *value() const {
    return GetPointer<const tflite::gpu::data::BufferDescriptor *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyTable(value()) &&
           verifier.EndTable();
  }
};

struct BufferDescriptorMapValueBuilder {
  typedef BufferDescriptorMapValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_key(flatbuffers::Offset<flatbuffers::String> key) {
    fbb_.AddOffset(BufferDescriptorMapValue::VT_KEY, key);
  }
  void add_value(flatbuffers::Offset<tflite::gpu::data::BufferDescriptor> value) {
    fbb_.AddOffset(BufferDescriptorMapValue::VT_VALUE, value);
  }
  explicit BufferDescriptorMapValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<BufferDescriptorMapValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<BufferDescriptorMapValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<BufferDescriptorMapValue> CreateBufferDescriptorMapValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> key = 0,
    flatbuffers::Offset<tflite::gpu::data::BufferDescriptor> value = 0) {
  BufferDescriptorMapValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline flatbuffers::Offset<BufferDescriptorMapValue> CreateBufferDescriptorMapValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    flatbuffers::Offset<tflite::gpu::data::BufferDescriptor> value = 0) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  return tflite::gpu::data::CreateBufferDescriptorMapValue(
      _fbb,
      key__,
      value);
}

struct Texture2DDescriptorMapValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Texture2DDescriptorMapValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const flatbuffers::String *key() const {
    return GetPointer<const flatbuffers::String *>(VT_KEY);
  }
  const tflite::gpu::data::Texture2DDescriptor *value() const {
    return GetPointer<const tflite::gpu::data::Texture2DDescriptor *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyTable(value()) &&
           verifier.EndTable();
  }
};

struct Texture2DDescriptorMapValueBuilder {
  typedef Texture2DDescriptorMapValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_key(flatbuffers::Offset<flatbuffers::String> key) {
    fbb_.AddOffset(Texture2DDescriptorMapValue::VT_KEY, key);
  }
  void add_value(flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptor> value) {
    fbb_.AddOffset(Texture2DDescriptorMapValue::VT_VALUE, value);
  }
  explicit Texture2DDescriptorMapValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Texture2DDescriptorMapValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Texture2DDescriptorMapValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<Texture2DDescriptorMapValue> CreateTexture2DDescriptorMapValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> key = 0,
    flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptor> value = 0) {
  Texture2DDescriptorMapValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline flatbuffers::Offset<Texture2DDescriptorMapValue> CreateTexture2DDescriptorMapValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptor> value = 0) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  return tflite::gpu::data::CreateTexture2DDescriptorMapValue(
      _fbb,
      key__,
      value);
}

struct TensorLinearDescriptorMapValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorLinearDescriptorMapValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const flatbuffers::String *key() const {
    return GetPointer<const flatbuffers::String *>(VT_KEY);
  }
  const tflite::gpu::data::TensorLinearDescriptor *value() const {
    return GetPointer<const tflite::gpu::data::TensorLinearDescriptor *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyTable(value()) &&
           verifier.EndTable();
  }
};

struct TensorLinearDescriptorMapValueBuilder {
  typedef TensorLinearDescriptorMapValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_key(flatbuffers::Offset<flatbuffers::String> key) {
    fbb_.AddOffset(TensorLinearDescriptorMapValue::VT_KEY, key);
  }
  void add_value(flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptor> value) {
    fbb_.AddOffset(TensorLinearDescriptorMapValue::VT_VALUE, value);
  }
  explicit TensorLinearDescriptorMapValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<TensorLinearDescriptorMapValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<TensorLinearDescriptorMapValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<TensorLinearDescriptorMapValue> CreateTensorLinearDescriptorMapValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> key = 0,
    flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptor> value = 0) {
  TensorLinearDescriptorMapValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline flatbuffers::Offset<TensorLinearDescriptorMapValue> CreateTensorLinearDescriptorMapValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptor> value = 0) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  return tflite::gpu::data::CreateTensorLinearDescriptorMapValue(
      _fbb,
      key__,
      value);
}

struct TensorDescriptorMapValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorDescriptorMapValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const flatbuffers::String *key() const {
    return GetPointer<const flatbuffers::String *>(VT_KEY);
  }
  const tflite::gpu::data::TensorDescriptor *value() const {
    return GetPointer<const tflite::gpu::data::TensorDescriptor *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyTable(value()) &&
           verifier.EndTable();
  }
};

struct TensorDescriptorMapValueBuilder {
  typedef TensorDescriptorMapValue Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_key(flatbuffers::Offset<flatbuffers::String> key) {
    fbb_.AddOffset(TensorDescriptorMapValue::VT_KEY, key);
  }
  void add_value(flatbuffers::Offset<tflite::gpu::data::TensorDescriptor> value) {
    fbb_.AddOffset(TensorDescriptorMapValue::VT_VALUE, value);
  }
  explicit TensorDescriptorMapValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<TensorDescriptorMapValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<TensorDescriptorMapValue>(end);
    return o;
  }
};

inline flatbuffers::Offset<TensorDescriptorMapValue> CreateTensorDescriptorMapValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> key = 0,
    flatbuffers::Offset<tflite::gpu::data::TensorDescriptor> value = 0) {
  TensorDescriptorMapValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline flatbuffers::Offset<TensorDescriptorMapValue> CreateTensorDescriptorMapValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    flatbuffers::Offset<tflite::gpu::data::TensorDescriptor> value = 0) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  return tflite::gpu::data::CreateTensorDescriptorMapValue(
      _fbb,
      key__,
      value);
}

struct Arguments FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ArgumentsBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_INT_VALUES = 4,
    VT_FLOAT_VALUES = 6,
    VT_HALF_VALUES = 8,
    VT_BUFFER_REFS = 10,
    VT_TEXTURE2D_REFS = 12,
    VT_TENSOR_LINEAR_REFS = 14,
    VT_TENSOR_REFS = 16,
    VT_BUFFER_OBJECTS = 18,
    VT_TEXTURE2D_OBJECTS = 20,
    VT_TENSOR_LINEAR_OBJECTS = 22,
    VT_TENSOR_OBJECTS = 24
  };
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::IntValue>> *int_values() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::IntValue>> *>(VT_INT_VALUES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::FloatValue>> *float_values() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::FloatValue>> *>(VT_FLOAT_VALUES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::HalfValue>> *half_values() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::HalfValue>> *>(VT_HALF_VALUES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_refs() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *>(VT_BUFFER_REFS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>> *texture2d_refs() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>> *>(VT_TEXTURE2D_REFS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>> *tensor_linear_refs() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>> *>(VT_TENSOR_LINEAR_REFS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_refs() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *>(VT_TENSOR_REFS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_objects() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *>(VT_BUFFER_OBJECTS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>> *texture2d_objects() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>> *>(VT_TEXTURE2D_OBJECTS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>> *tensor_linear_objects() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>> *>(VT_TENSOR_LINEAR_OBJECTS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_objects() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *>(VT_TENSOR_OBJECTS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_INT_VALUES) &&
           verifier.VerifyVector(int_values()) &&
           verifier.VerifyVectorOfTables(int_values()) &&
           VerifyOffset(verifier, VT_FLOAT_VALUES) &&
           verifier.VerifyVector(float_values()) &&
           verifier.VerifyVectorOfTables(float_values()) &&
           VerifyOffset(verifier, VT_HALF_VALUES) &&
           verifier.VerifyVector(half_values()) &&
           verifier.VerifyVectorOfTables(half_values()) &&
           VerifyOffset(verifier, VT_BUFFER_REFS) &&
           verifier.VerifyVector(buffer_refs()) &&
           verifier.VerifyVectorOfTables(buffer_refs()) &&
           VerifyOffset(verifier, VT_TEXTURE2D_REFS) &&
           verifier.VerifyVector(texture2d_refs()) &&
           verifier.VerifyVectorOfTables(texture2d_refs()) &&
           VerifyOffset(verifier, VT_TENSOR_LINEAR_REFS) &&
           verifier.VerifyVector(tensor_linear_refs()) &&
           verifier.VerifyVectorOfTables(tensor_linear_refs()) &&
           VerifyOffset(verifier, VT_TENSOR_REFS) &&
           verifier.VerifyVector(tensor_refs()) &&
           verifier.VerifyVectorOfTables(tensor_refs()) &&
           VerifyOffset(verifier, VT_BUFFER_OBJECTS) &&
           verifier.VerifyVector(buffer_objects()) &&
           verifier.VerifyVectorOfTables(buffer_objects()) &&
           VerifyOffset(verifier, VT_TEXTURE2D_OBJECTS) &&
           verifier.VerifyVector(texture2d_objects()) &&
           verifier.VerifyVectorOfTables(texture2d_objects()) &&
           VerifyOffset(verifier, VT_TENSOR_LINEAR_OBJECTS) &&
           verifier.VerifyVector(tensor_linear_objects()) &&
           verifier.VerifyVectorOfTables(tensor_linear_objects()) &&
           VerifyOffset(verifier, VT_TENSOR_OBJECTS) &&
           verifier.VerifyVector(tensor_objects()) &&
           verifier.VerifyVectorOfTables(tensor_objects()) &&
           verifier.EndTable();
  }
};

struct ArgumentsBuilder {
  typedef Arguments Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_int_values(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::IntValue>>> int_values) {
    fbb_.AddOffset(Arguments::VT_INT_VALUES, int_values);
  }
  void add_float_values(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::FloatValue>>> float_values) {
    fbb_.AddOffset(Arguments::VT_FLOAT_VALUES, float_values);
  }
  void add_half_values(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::HalfValue>>> half_values) {
    fbb_.AddOffset(Arguments::VT_HALF_VALUES, half_values);
  }
  void add_buffer_refs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_refs) {
    fbb_.AddOffset(Arguments::VT_BUFFER_REFS, buffer_refs);
  }
  void add_texture2d_refs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>>> texture2d_refs) {
    fbb_.AddOffset(Arguments::VT_TEXTURE2D_REFS, texture2d_refs);
  }
  void add_tensor_linear_refs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>>> tensor_linear_refs) {
    fbb_.AddOffset(Arguments::VT_TENSOR_LINEAR_REFS, tensor_linear_refs);
  }
  void add_tensor_refs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_refs) {
    fbb_.AddOffset(Arguments::VT_TENSOR_REFS, tensor_refs);
  }
  void add_buffer_objects(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_objects) {
    fbb_.AddOffset(Arguments::VT_BUFFER_OBJECTS, buffer_objects);
  }
  void add_texture2d_objects(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>>> texture2d_objects) {
    fbb_.AddOffset(Arguments::VT_TEXTURE2D_OBJECTS, texture2d_objects);
  }
  void add_tensor_linear_objects(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>>> tensor_linear_objects) {
    fbb_.AddOffset(Arguments::VT_TENSOR_LINEAR_OBJECTS, tensor_linear_objects);
  }
  void add_tensor_objects(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_objects) {
    fbb_.AddOffset(Arguments::VT_TENSOR_OBJECTS, tensor_objects);
  }
  explicit ArgumentsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Arguments> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Arguments>(end);
    return o;
  }
};

inline flatbuffers::Offset<Arguments> CreateArguments(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::IntValue>>> int_values = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::FloatValue>>> float_values = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::HalfValue>>> half_values = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_refs = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>>> texture2d_refs = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>>> tensor_linear_refs = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_refs = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_objects = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>>> texture2d_objects = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>>> tensor_linear_objects = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_objects = 0) {
  ArgumentsBuilder builder_(_fbb);
  builder_.add_tensor_objects(tensor_objects);
  builder_.add_tensor_linear_objects(tensor_linear_objects);
  builder_.add_texture2d_objects(texture2d_objects);
  builder_.add_buffer_objects(buffer_objects);
  builder_.add_tensor_refs(tensor_refs);
  builder_.add_tensor_linear_refs(tensor_linear_refs);
  builder_.add_texture2d_refs(texture2d_refs);
  builder_.add_buffer_refs(buffer_refs);
  builder_.add_half_values(half_values);
  builder_.add_float_values(float_values);
  builder_.add_int_values(int_values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Arguments> CreateArgumentsDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::IntValue>> *int_values = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::FloatValue>> *float_values = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::HalfValue>> *half_values = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_refs = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>> *texture2d_refs = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>> *tensor_linear_refs = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_refs = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_objects = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>> *texture2d_objects = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>> *tensor_linear_objects = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_objects = nullptr) {
  auto int_values__ = int_values ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::IntValue>>(*int_values) : 0;
  auto float_values__ = float_values ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::FloatValue>>(*float_values) : 0;
  auto half_values__ = half_values ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::HalfValue>>(*half_values) : 0;
  auto buffer_refs__ = buffer_refs ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>(*buffer_refs) : 0;
  auto texture2d_refs__ = texture2d_refs ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>>(*texture2d_refs) : 0;
  auto tensor_linear_refs__ = tensor_linear_refs ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>>(*tensor_linear_refs) : 0;
  auto tensor_refs__ = tensor_refs ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>(*tensor_refs) : 0;
  auto buffer_objects__ = buffer_objects ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>(*buffer_objects) : 0;
  auto texture2d_objects__ = texture2d_objects ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::Texture2DDescriptorMapValue>>(*texture2d_objects) : 0;
  auto tensor_linear_objects__ = tensor_linear_objects ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::TensorLinearDescriptorMapValue>>(*tensor_linear_objects) : 0;
  auto tensor_objects__ = tensor_objects ? _fbb.CreateVector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>(*tensor_objects) : 0;
  return tflite::gpu::data::CreateArguments(
      _fbb,
      int_values__,
      float_values__,
      half_values__,
      buffer_refs__,
      texture2d_refs__,
      tensor_linear_refs__,
      tensor_refs__,
      buffer_objects__,
      texture2d_objects__,
      tensor_linear_objects__,
      tensor_objects__);
}

struct OperationDef FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef OperationDefBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_PRECISION = 4,
    VT_SRC_TENSORS = 6,
    VT_DST_TENSORS = 8
  };
  tflite::gpu::data::CalculationsPrecision precision() const {
    return static_cast<tflite::gpu::data::CalculationsPrecision>(
        GetField<int8_t>(VT_PRECISION, 0));
  }
  const flatbuffers::Vector<
      flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>
      *src_tensors() const {
    return GetPointer<const flatbuffers::Vector<
        flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *>(
        VT_SRC_TENSORS);
  }
  const flatbuffers::Vector<
      flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>
      *dst_tensors() const {
    return GetPointer<const flatbuffers::Vector<
        flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *>(
        VT_DST_TENSORS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_PRECISION) &&
           VerifyOffset(verifier, VT_SRC_TENSORS) &&
           verifier.VerifyVector(src_tensors()) &&
           verifier.VerifyVectorOfTables(src_tensors()) &&
           VerifyOffset(verifier, VT_DST_TENSORS) &&
           verifier.VerifyVector(dst_tensors()) &&
           verifier.VerifyVectorOfTables(dst_tensors()) && verifier.EndTable();
  }
};

struct OperationDefBuilder {
  typedef OperationDef Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_precision(tflite::gpu::data::CalculationsPrecision precision) {
    fbb_.AddElement<int8_t>(OperationDef::VT_PRECISION,
                            static_cast<int8_t>(precision), 0);
  }
  void add_src_tensors(
      flatbuffers::Offset<flatbuffers::Vector<
          flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>>
          src_tensors) {
    fbb_.AddOffset(OperationDef::VT_SRC_TENSORS, src_tensors);
  }
  void add_dst_tensors(
      flatbuffers::Offset<flatbuffers::Vector<
          flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>>
          dst_tensors) {
    fbb_.AddOffset(OperationDef::VT_DST_TENSORS, dst_tensors);
  }
  explicit OperationDefBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<OperationDef> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<OperationDef>(end);
    return o;
  }
};

inline flatbuffers::Offset<OperationDef> CreateOperationDef(
    flatbuffers::FlatBufferBuilder &_fbb,
    tflite::gpu::data::CalculationsPrecision precision =
        tflite::gpu::data::CalculationsPrecision::F32,
    flatbuffers::Offset<flatbuffers::Vector<
        flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>>
        src_tensors = 0,
    flatbuffers::Offset<flatbuffers::Vector<
        flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>>
        dst_tensors = 0) {
  OperationDefBuilder builder_(_fbb);
  builder_.add_dst_tensors(dst_tensors);
  builder_.add_src_tensors(src_tensors);
  builder_.add_precision(precision);
  return builder_.Finish();
}

inline flatbuffers::Offset<OperationDef> CreateOperationDefDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    tflite::gpu::data::CalculationsPrecision precision =
        tflite::gpu::data::CalculationsPrecision::F32,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>
        *src_tensors = nullptr,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>
        *dst_tensors = nullptr) {
  auto src_tensors__ =
      src_tensors
          ? _fbb.CreateVector<
                flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>(
                *src_tensors)
          : 0;
  auto dst_tensors__ =
      dst_tensors
          ? _fbb.CreateVector<
                flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>(
                *dst_tensors)
          : 0;
  return tflite::gpu::data::CreateOperationDef(_fbb, precision, src_tensors__,
                                               dst_tensors__);
}

struct CompilerOption FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef CompilerOptionBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_OPTION = 4
  };
  tflite::gpu::data::CompilerOptions option() const {
    return static_cast<tflite::gpu::data::CompilerOptions>(
        GetField<int8_t>(VT_OPTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_OPTION) && verifier.EndTable();
  }
};

struct CompilerOptionBuilder {
  typedef CompilerOption Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_option(tflite::gpu::data::CompilerOptions option) {
    fbb_.AddElement<int8_t>(CompilerOption::VT_OPTION,
                            static_cast<int8_t>(option), 0);
  }
  explicit CompilerOptionBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<CompilerOption> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<CompilerOption>(end);
    return o;
  }
};

inline flatbuffers::Offset<CompilerOption> CreateCompilerOption(
    flatbuffers::FlatBufferBuilder &_fbb,
    tflite::gpu::data::CompilerOptions option =
        tflite::gpu::data::CompilerOptions::ADRENO_FULL_SIMD_LINE) {
  CompilerOptionBuilder builder_(_fbb);
  builder_.add_option(option);
  return builder_.Finish();
}

struct GPUOperation FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef GPUOperationBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ARGUMENTS = 4,
    VT_CODE = 6,
    VT_WORK_GROUP_SIZE = 8,
    VT_COMPILER_OPTIONS = 10,
    VT_TENSOR_TO_GRID = 12,
    VT_ELEMENTWISE = 14,
    VT_LINKABLE = 16,
    VT_CHECK_SRC_CHANNELS_SIZE = 18,
    VT_DEFINITION = 20,
    VT_GRID_DIMENSION = 22,
    VT_WORK_GROUP_LAUNCH_ORDER = 24,
    VT_GRID_SIZE = 26,
    VT_SRC_TENSORS_NAMES = 28,
    VT_DST_TENSORS_NAMES = 30,
    VT_WORK_GROUPS_COUNT = 32,
    VT_LINKABLE_COUNT = 34,
    VT_ELEMENTWISE_CODE = 36
  };
  const tflite::gpu::data::Arguments *arguments() const {
    return GetPointer<const tflite::gpu::data::Arguments *>(VT_ARGUMENTS);
  }
  const flatbuffers::String *code() const {
    return GetPointer<const flatbuffers::String *>(VT_CODE);
  }
  const tflite::gpu::data::Int3 *work_group_size() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_WORK_GROUP_SIZE);
  }
  const flatbuffers::Vector<
      flatbuffers::Offset<tflite::gpu::data::CompilerOption>>
      *compiler_options() const {
    return GetPointer<const flatbuffers::Vector<
        flatbuffers::Offset<tflite::gpu::data::CompilerOption>> *>(
        VT_COMPILER_OPTIONS);
  }
  tflite::gpu::data::TensorToGrid tensor_to_grid() const {
    return static_cast<tflite::gpu::data::TensorToGrid>(
        GetField<int8_t>(VT_TENSOR_TO_GRID, 0));
  }
  bool elementwise() const { return GetField<uint8_t>(VT_ELEMENTWISE, 0) != 0; }
  bool linkable() const { return GetField<uint8_t>(VT_LINKABLE, 0) != 0; }
  bool check_src_channels_size() const {
    return GetField<uint8_t>(VT_CHECK_SRC_CHANNELS_SIZE, 0) != 0;
  }
  const tflite::gpu::data::OperationDef *definition() const {
    return GetPointer<const tflite::gpu::data::OperationDef *>(VT_DEFINITION);
  }
  int32_t grid_dimension() const {
    return GetField<int32_t>(VT_GRID_DIMENSION, 0);
  }
  const tflite::gpu::data::Int3 *work_group_launch_order() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(
        VT_WORK_GROUP_LAUNCH_ORDER);
  }
  const tflite::gpu::data::Int3 *grid_size() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_GRID_SIZE);
  }
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>
      *src_tensors_names() const {
    return GetPointer<
        const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(
        VT_SRC_TENSORS_NAMES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>
      *dst_tensors_names() const {
    return GetPointer<
        const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(
        VT_DST_TENSORS_NAMES);
  }
  const tflite::gpu::data::Int3 *work_groups_count() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_WORK_GROUPS_COUNT);
  }
  int32_t linkable_count() const {
    return GetField<int32_t>(VT_LINKABLE_COUNT, 0);
  }
  const flatbuffers::String *elementwise_code() const {
    return GetPointer<const flatbuffers::String *>(VT_ELEMENTWISE_CODE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_ARGUMENTS) &&
           verifier.VerifyTable(arguments()) &&
           VerifyOffset(verifier, VT_CODE) && verifier.VerifyString(code()) &&
           VerifyOffset(verifier, VT_WORK_GROUP_SIZE) &&
           verifier.VerifyTable(work_group_size()) &&
           VerifyOffset(verifier, VT_COMPILER_OPTIONS) &&
           verifier.VerifyVector(compiler_options()) &&
           verifier.VerifyVectorOfTables(compiler_options()) &&
           VerifyField<int8_t>(verifier, VT_TENSOR_TO_GRID) &&
           VerifyField<uint8_t>(verifier, VT_ELEMENTWISE) &&
           VerifyField<uint8_t>(verifier, VT_LINKABLE) &&
           VerifyField<uint8_t>(verifier, VT_CHECK_SRC_CHANNELS_SIZE) &&
           VerifyOffset(verifier, VT_DEFINITION) &&
           verifier.VerifyTable(definition()) &&
           VerifyField<int32_t>(verifier, VT_GRID_DIMENSION) &&
           VerifyOffset(verifier, VT_WORK_GROUP_LAUNCH_ORDER) &&
           verifier.VerifyTable(work_group_launch_order()) &&
           VerifyOffset(verifier, VT_GRID_SIZE) &&
           verifier.VerifyTable(grid_size()) &&
           VerifyOffset(verifier, VT_SRC_TENSORS_NAMES) &&
           verifier.VerifyVector(src_tensors_names()) &&
           verifier.VerifyVectorOfStrings(src_tensors_names()) &&
           VerifyOffset(verifier, VT_DST_TENSORS_NAMES) &&
           verifier.VerifyVector(dst_tensors_names()) &&
           verifier.VerifyVectorOfStrings(dst_tensors_names()) &&
           VerifyOffset(verifier, VT_WORK_GROUPS_COUNT) &&
           verifier.VerifyTable(work_groups_count()) &&
           VerifyField<int32_t>(verifier, VT_LINKABLE_COUNT) &&
           VerifyOffset(verifier, VT_ELEMENTWISE_CODE) &&
           verifier.VerifyString(elementwise_code()) && verifier.EndTable();
  }
};

struct GPUOperationBuilder {
  typedef GPUOperation Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_arguments(
      flatbuffers::Offset<tflite::gpu::data::Arguments> arguments) {
    fbb_.AddOffset(GPUOperation::VT_ARGUMENTS, arguments);
  }
  void add_code(flatbuffers::Offset<flatbuffers::String> code) {
    fbb_.AddOffset(GPUOperation::VT_CODE, code);
  }
  void add_work_group_size(
      flatbuffers::Offset<tflite::gpu::data::Int3> work_group_size) {
    fbb_.AddOffset(GPUOperation::VT_WORK_GROUP_SIZE, work_group_size);
  }
  void add_compiler_options(
      flatbuffers::Offset<flatbuffers::Vector<
          flatbuffers::Offset<tflite::gpu::data::CompilerOption>>>
          compiler_options) {
    fbb_.AddOffset(GPUOperation::VT_COMPILER_OPTIONS, compiler_options);
  }
  void add_tensor_to_grid(tflite::gpu::data::TensorToGrid tensor_to_grid) {
    fbb_.AddElement<int8_t>(GPUOperation::VT_TENSOR_TO_GRID,
                            static_cast<int8_t>(tensor_to_grid), 0);
  }
  void add_elementwise(bool elementwise) {
    fbb_.AddElement<uint8_t>(GPUOperation::VT_ELEMENTWISE,
                             static_cast<uint8_t>(elementwise), 0);
  }
  void add_linkable(bool linkable) {
    fbb_.AddElement<uint8_t>(GPUOperation::VT_LINKABLE,
                             static_cast<uint8_t>(linkable), 0);
  }
  void add_check_src_channels_size(bool check_src_channels_size) {
    fbb_.AddElement<uint8_t>(GPUOperation::VT_CHECK_SRC_CHANNELS_SIZE,
                             static_cast<uint8_t>(check_src_channels_size), 0);
  }
  void add_definition(
      flatbuffers::Offset<tflite::gpu::data::OperationDef> definition) {
    fbb_.AddOffset(GPUOperation::VT_DEFINITION, definition);
  }
  void add_grid_dimension(int32_t grid_dimension) {
    fbb_.AddElement<int32_t>(GPUOperation::VT_GRID_DIMENSION, grid_dimension,
                             0);
  }
  void add_work_group_launch_order(
      flatbuffers::Offset<tflite::gpu::data::Int3> work_group_launch_order) {
    fbb_.AddOffset(GPUOperation::VT_WORK_GROUP_LAUNCH_ORDER,
                   work_group_launch_order);
  }
  void add_grid_size(flatbuffers::Offset<tflite::gpu::data::Int3> grid_size) {
    fbb_.AddOffset(GPUOperation::VT_GRID_SIZE, grid_size);
  }
  void add_src_tensors_names(
      flatbuffers::Offset<
          flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>>
          src_tensors_names) {
    fbb_.AddOffset(GPUOperation::VT_SRC_TENSORS_NAMES, src_tensors_names);
  }
  void add_dst_tensors_names(
      flatbuffers::Offset<
          flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>>
          dst_tensors_names) {
    fbb_.AddOffset(GPUOperation::VT_DST_TENSORS_NAMES, dst_tensors_names);
  }
  void add_work_groups_count(
      flatbuffers::Offset<tflite::gpu::data::Int3> work_groups_count) {
    fbb_.AddOffset(GPUOperation::VT_WORK_GROUPS_COUNT, work_groups_count);
  }
  void add_linkable_count(int32_t linkable_count) {
    fbb_.AddElement<int32_t>(GPUOperation::VT_LINKABLE_COUNT, linkable_count,
                             0);
  }
  void add_elementwise_code(
      flatbuffers::Offset<flatbuffers::String> elementwise_code) {
    fbb_.AddOffset(GPUOperation::VT_ELEMENTWISE_CODE, elementwise_code);
  }
  explicit GPUOperationBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<GPUOperation> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<GPUOperation>(end);
    return o;
  }
};

inline flatbuffers::Offset<GPUOperation> CreateGPUOperation(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::Arguments> arguments = 0,
    flatbuffers::Offset<flatbuffers::String> code = 0,
    flatbuffers::Offset<tflite::gpu::data::Int3> work_group_size = 0,
    flatbuffers::Offset<flatbuffers::Vector<
        flatbuffers::Offset<tflite::gpu::data::CompilerOption>>>
        compiler_options = 0,
    tflite::gpu::data::TensorToGrid tensor_to_grid =
        tflite::gpu::data::TensorToGrid::CUSTOM,
    bool elementwise = false, bool linkable = false,
    bool check_src_channels_size = false,
    flatbuffers::Offset<tflite::gpu::data::OperationDef> definition = 0,
    int32_t grid_dimension = 0,
    flatbuffers::Offset<tflite::gpu::data::Int3> work_group_launch_order = 0,
    flatbuffers::Offset<tflite::gpu::data::Int3> grid_size = 0,
    flatbuffers::Offset<
        flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>>
        src_tensors_names = 0,
    flatbuffers::Offset<
        flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>>
        dst_tensors_names = 0,
    flatbuffers::Offset<tflite::gpu::data::Int3> work_groups_count = 0,
    int32_t linkable_count = 0,
    flatbuffers::Offset<flatbuffers::String> elementwise_code = 0) {
  GPUOperationBuilder builder_(_fbb);
  builder_.add_elementwise_code(elementwise_code);
  builder_.add_linkable_count(linkable_count);
  builder_.add_work_groups_count(work_groups_count);
  builder_.add_dst_tensors_names(dst_tensors_names);
  builder_.add_src_tensors_names(src_tensors_names);
  builder_.add_grid_size(grid_size);
  builder_.add_work_group_launch_order(work_group_launch_order);
  builder_.add_grid_dimension(grid_dimension);
  builder_.add_definition(definition);
  builder_.add_compiler_options(compiler_options);
  builder_.add_work_group_size(work_group_size);
  builder_.add_code(code);
  builder_.add_arguments(arguments);
  builder_.add_check_src_channels_size(check_src_channels_size);
  builder_.add_linkable(linkable);
  builder_.add_elementwise(elementwise);
  builder_.add_tensor_to_grid(tensor_to_grid);
  return builder_.Finish();
}

inline flatbuffers::Offset<GPUOperation> CreateGPUOperationDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<tflite::gpu::data::Arguments> arguments = 0,
    const char *code = nullptr,
    flatbuffers::Offset<tflite::gpu::data::Int3> work_group_size = 0,
    const std::vector<flatbuffers::Offset<tflite::gpu::data::CompilerOption>>
        *compiler_options = nullptr,
    tflite::gpu::data::TensorToGrid tensor_to_grid =
        tflite::gpu::data::TensorToGrid::CUSTOM,
    bool elementwise = false, bool linkable = false,
    bool check_src_channels_size = false,
    flatbuffers::Offset<tflite::gpu::data::OperationDef> definition = 0,
    int32_t grid_dimension = 0,
    flatbuffers::Offset<tflite::gpu::data::Int3> work_group_launch_order = 0,
    flatbuffers::Offset<tflite::gpu::data::Int3> grid_size = 0,
    const std::vector<flatbuffers::Offset<flatbuffers::String>>
        *src_tensors_names = nullptr,
    const std::vector<flatbuffers::Offset<flatbuffers::String>>
        *dst_tensors_names = nullptr,
    flatbuffers::Offset<tflite::gpu::data::Int3> work_groups_count = 0,
    int32_t linkable_count = 0, const char *elementwise_code = nullptr) {
  auto code__ = code ? _fbb.CreateString(code) : 0;
  auto compiler_options__ =
      compiler_options
          ? _fbb.CreateVector<
                flatbuffers::Offset<tflite::gpu::data::CompilerOption>>(
                *compiler_options)
          : 0;
  auto src_tensors_names__ =
      src_tensors_names
          ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(
                *src_tensors_names)
          : 0;
  auto dst_tensors_names__ =
      dst_tensors_names
          ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(
                *dst_tensors_names)
          : 0;
  auto elementwise_code__ =
      elementwise_code ? _fbb.CreateString(elementwise_code) : 0;
  return tflite::gpu::data::CreateGPUOperation(
      _fbb, arguments, code__, work_group_size, compiler_options__,
      tensor_to_grid, elementwise, linkable, check_src_channels_size,
      definition, grid_dimension, work_group_launch_order, grid_size,
      src_tensors_names__, dst_tensors_names__, work_groups_count,
      linkable_count, elementwise_code__);
}

}  // namespace data
}  // namespace gpu
}  // namespace tflite

#endif  // FLATBUFFERS_GENERATED_SERIALIZATIONBASE_TFLITE_GPU_DATA_H_
