// Copyright 2017 The TensorFlow Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// DO NOT EDIT
// This file was machine generated by github.com/tensorflow/tensorflow/tensorflow/go/genop/internal
//
// WARNING: This generation of wrapper function for TensorFlow ops is in an
// experimental state. The generated API can change without notice.

package op

import tf "github.com/tensorflow/tensorflow/tensorflow/go"

// optionalAttr is an intentionally un-exported type to hide
// details of how optional attributes to operations are implemented.
type optionalAttr map[string]interface{}

func makeOutputList(op *tf.Operation, start int, output string) ([]tf.Output, int, error) {
	size, err := op.OutputListSize(output)
	if err != nil {
		return nil, start, err
	}
	list := make([]tf.Output, size)
	for i := 0; i < size; i++ {
		list[i] = op.Output(start + i)
	}
	return list, start + size, nil
}

// TPUPartitionedInputAttr is an optional argument to TPUPartitionedInput.
type TPUPartitionedInputAttr func(optionalAttr)

// TPUPartitionedInputPartitionDim sets the optional partition_dim attribute to value.
//
// value: An integer describles which dimension is partitioned. -1 means
// those inputs are replicated.
// If not specified, defaults to 0
func TPUPartitionedInputPartitionDim(value int64) TPUPartitionedInputAttr {
	return func(m optionalAttr) {
		m["partition_dim"] = value
	}
}

// An op that groups a list of partitioned inputs together. This op
//
// Arguments:
//	inputs: A list of partitioned inputs which must have the same shape.
//
// Returns A handle which represents the full shape of partitioned tensors.
func TPUPartitionedInput(scope *Scope, inputs []tf.Output, optional ...TPUPartitionedInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TPUPartitionedInput",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Op that loads and executes a TPU program on a TPU device.
//
// For the internal use of the distributed TPU compiler.
func TPUExecute(scope *Scope, args []tf.Output, key tf.Output, Tresults []tf.DataType) (results []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tresults": Tresults}
	opspec := tf.OpSpec{
		Type: "TPUExecute",
		Input: []tf.Input{
			tf.OutputList(args), key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if results, idx, err = makeOutputList(op, idx, "results"); err != nil {
		scope.UpdateErr("TPUExecute", err)
		return
	}
	return results
}

// Returns the result of a TPU compilation.
//
// This operation returns the result of a TPU compilation as a serialized
// CompilationResultProto, which holds a status and an error message if an error
// occurred during compilation.
func TPUCompilationResult(scope *Scope) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TPUCompilationResult",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A TPU core selector Op.
//
// This Op produces a set of TPU cores (for warm-up) or a single TPU core
// (for regular inference) to execute the TPU program on. The output is
// consumed by TPUPartitionedCall.
//
// Returns A vector 1 or more TPU cores.
func TPUOrdinalSelector(scope *Scope) (device_ordinals tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TPUOrdinalSelector",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Retrieves a single tensor from the computation outfeed. Device ordinal is a
// tensor allowing dynamic outfeed.
//
// This operation will block indefinitely until data is available.
//
// Arguments:
//	device_ordinal: An int scalar tensor, representing the TPU device to use. This should be -1 when
// the Op is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be read from the device outfeed.
func OutfeedDequeueV2(scope *Scope, device_ordinal tf.Output, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeueV2",
		Input: []tf.Input{
			device_ordinal,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OutfeedDequeueTupleAttr is an optional argument to OutfeedDequeueTuple.
type OutfeedDequeueTupleAttr func(optionalAttr)

// OutfeedDequeueTupleDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func OutfeedDequeueTupleDeviceOrdinal(value int64) OutfeedDequeueTupleAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Retrieve multiple values from the computation outfeed.
//
// This operation will block indefinitely until data is available. Output `i`
// corresponds to XLA tuple element `i`.
//
// Arguments:
//	dtypes: The element types of each element in `outputs`.
//	shapes: The shapes of each tensor in `outputs`.
//
// Returns A list of tensors that will be read from the outfeed.
func OutfeedDequeueTuple(scope *Scope, dtypes []tf.DataType, shapes []tf.Shape, optional ...OutfeedDequeueTupleAttr) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes, "shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeueTuple",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("OutfeedDequeueTuple", err)
		return
	}
	return outputs
}

// Enqueue a Tensor on the computation outfeed.
//
// Arguments:
//	input: A tensor that will be inserted into the outfeed queue.
//
// Returns the created operation.
func OutfeedEnqueue(scope *Scope, input tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OutfeedEnqueue",
		Input: []tf.Input{
			input,
		},
	}
	return scope.AddOperation(opspec)
}

// InfeedEnqueuePrelinearizedBufferAttr is an optional argument to InfeedEnqueuePrelinearizedBuffer.
type InfeedEnqueuePrelinearizedBufferAttr func(optionalAttr)

// InfeedEnqueuePrelinearizedBufferDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op is running on a TPU device
// and = 0 when the Op is running on the CPU device.
// If not specified, defaults to -1
func InfeedEnqueuePrelinearizedBufferDeviceOrdinal(value int64) InfeedEnqueuePrelinearizedBufferAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op which enqueues prelinearized buffer into TPU infeed.
//
// Arguments:
//	input: A variant tensor representing linearized output.
//
// Returns the created operation.
func InfeedEnqueuePrelinearizedBuffer(scope *Scope, input tf.Output, optional ...InfeedEnqueuePrelinearizedBufferAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueuePrelinearizedBuffer",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// PrelinearizeAttr is an optional argument to Prelinearize.
type PrelinearizeAttr func(optionalAttr)

// PrelinearizeShape sets the optional shape attribute to value.
//
// value: The shape of the tensor.
// If not specified, defaults to <>
func PrelinearizeShape(value tf.Shape) PrelinearizeAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// PrelinearizeLayout sets the optional layout attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence. If a layout
// attribute is passed but its values are all -1 the layout will be computed by
// the infeed operation.
// If not specified, defaults to <>
func PrelinearizeLayout(value []int64) PrelinearizeAttr {
	return func(m optionalAttr) {
		m["layout"] = value
	}
}

// An op which linearizes one Tensor value to an opaque variant tensor.
//
// Arguments:
//	input: A tensor that will be linearized.
func Prelinearize(scope *Scope, input tf.Output, optional ...PrelinearizeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Prelinearize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// InfeedEnqueueTupleAttr is an optional argument to InfeedEnqueueTuple.
type InfeedEnqueueTupleAttr func(optionalAttr)

// InfeedEnqueueTupleLayouts sets the optional layouts attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence for
// all the tuple shapes, in the order the shapes appear in the "shapes" input.
// The layout elements for a sub-shape can be set to -1, in which case the
// corresponding layout will be computed by the infeed operation.
// If not specified, defaults to <>
func InfeedEnqueueTupleLayouts(value []int64) InfeedEnqueueTupleAttr {
	return func(m optionalAttr) {
		m["layouts"] = value
	}
}

// InfeedEnqueueTupleDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func InfeedEnqueueTupleDeviceOrdinal(value int64) InfeedEnqueueTupleAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Feeds multiple Tensor values into the computation as an XLA tuple.
//
// Arguments:
//	inputs: A list of tensors that will be provided using the infeed mechanism.
//	shapes: The shapes of each tensor in `inputs`.
//
// Returns the created operation.
func InfeedEnqueueTuple(scope *Scope, inputs []tf.Output, shapes []tf.Shape, optional ...InfeedEnqueueTupleAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueueTuple",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Worker heartbeat op.
//
// Heartbeats may be sent periodically to indicate the coordinator is still active,
// to retrieve the current worker status and to expedite shutdown when necessary.
//
// Arguments:
//	request: A string tensor containing a serialized WorkerHeartbeatRequest
//
// Returns A string tensor containing a serialized WorkerHeartbeatResponse
func WorkerHeartbeat(scope *Scope, request tf.Output) (response tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WorkerHeartbeat",
		Input: []tf.Input{
			request,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingFrequencyEstimatorParametersAttr is an optional argument to RetrieveTPUEmbeddingFrequencyEstimatorParameters.
type RetrieveTPUEmbeddingFrequencyEstimatorParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingFrequencyEstimatorParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingFrequencyEstimatorParametersTableId(value int64) RetrieveTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingFrequencyEstimatorParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingFrequencyEstimatorParametersTableName(value string) RetrieveTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingFrequencyEstimatorParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingFrequencyEstimatorParametersConfig(value string) RetrieveTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve frequency estimator embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the frequency estimator optimization algorithm.
//	last_hit_step: Parameter last_hit_step updated by the frequency estimator optimization
// algorithm.
func RetrieveTPUEmbeddingFrequencyEstimatorParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingFrequencyEstimatorParametersAttr) (parameters tf.Output, last_hit_step tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingFrequencyEstimatorParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingProximalAdagradParametersGradAccumDebug.
type LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load proximal Adagrad embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the proximal Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the proximal Adagrad optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the proximal Adagrad optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingProximalAdagradParametersGradAccumDebug(scope *Scope, parameters tf.Output, accumulators tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingProximalAdagradParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, accumulators, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingAdadeltaParametersAttr is an optional argument to LoadTPUEmbeddingAdadeltaParameters.
type LoadTPUEmbeddingAdadeltaParametersAttr func(optionalAttr)

// LoadTPUEmbeddingAdadeltaParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingAdadeltaParametersTableId(value int64) LoadTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdadeltaParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdadeltaParametersTableName(value string) LoadTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingAdadeltaParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdadeltaParametersConfig(value string) LoadTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Adadelta embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Adadelta optimization algorithm.
//	accumulators: Value of accumulators used in the Adadelta optimization algorithm.
//	updates: Value of updates used in the Adadelta optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingAdadeltaParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, updates tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdadeltaParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdadeltaParameters",
		Input: []tf.Input{
			parameters, accumulators, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingMDLAdagradLightParametersAttr is an optional argument to LoadTPUEmbeddingMDLAdagradLightParameters.
type LoadTPUEmbeddingMDLAdagradLightParametersAttr func(optionalAttr)

// LoadTPUEmbeddingMDLAdagradLightParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingMDLAdagradLightParametersTableId(value int64) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMDLAdagradLightParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMDLAdagradLightParametersTableName(value string) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingMDLAdagradLightParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMDLAdagradLightParametersConfig(value string) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load MDL Adagrad Light embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the MDL Adagrad Light optimization algorithm.
//	accumulators: Value of accumulators used in the MDL Adagrad Light optimization algorithm.
//	weights: Value of weights used in the MDL Adagrad Light optimization algorithm.
//	benefits: Value of benefits used in the MDL Adagrad Light optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingMDLAdagradLightParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, weights tf.Output, benefits tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMDLAdagradLightParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMDLAdagradLightParameters",
		Input: []tf.Input{
			parameters, accumulators, weights, benefits,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingRMSPropParametersGradAccumDebug.
type LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load RMSProp embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the RMSProp optimization algorithm.
//	ms: Value of ms used in the RMSProp optimization algorithm.
//	mom: Value of mom used in the RMSProp optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the RMSProp optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingRMSPropParametersGradAccumDebug(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingRMSPropParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, ms, mom, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingRMSPropParametersAttr is an optional argument to LoadTPUEmbeddingRMSPropParameters.
type LoadTPUEmbeddingRMSPropParametersAttr func(optionalAttr)

// LoadTPUEmbeddingRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingRMSPropParametersTableId(value int64) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersTableName(value string) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersConfig(value string) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load RMSProp embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the RMSProp optimization algorithm.
//	ms: Value of ms used in the RMSProp optimization algorithm.
//	mom: Value of mom used in the RMSProp optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingRMSPropParameters(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingRMSPropParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingRMSPropParameters",
		Input: []tf.Input{
			parameters, ms, mom,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingMomentumParametersGradAccumDebug.
type RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebugConfig(value string) RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve Momentum embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the Momentum optimization algorithm.
//	momenta: Parameter momenta updated by the Momentum optimization algorithm.
//	gradient_accumulators: Parameter gradient_accumulators updated by the Momentum optimization algorithm.
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr) (parameters tf.Output, momenta tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingMomentumParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RetrieveTPUEmbeddingMomentumParametersAttr is an optional argument to RetrieveTPUEmbeddingMomentumParameters.
type RetrieveTPUEmbeddingMomentumParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingMomentumParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingMomentumParametersTableId(value int64) RetrieveTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingMomentumParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMomentumParametersTableName(value string) RetrieveTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingMomentumParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMomentumParametersConfig(value string) RetrieveTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve Momentum embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the Momentum optimization algorithm.
//	momenta: Parameter momenta updated by the Momentum optimization algorithm.
func RetrieveTPUEmbeddingMomentumParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingMomentumParametersAttr) (parameters tf.Output, momenta tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingMomentumParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingMomentumParametersGradAccumDebug.
type LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingMomentumParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingMomentumParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Momentum embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Momentum optimization algorithm.
//	momenta: Value of momenta used in the Momentum optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the Momentum optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingMomentumParametersGradAccumDebug(scope *Scope, parameters tf.Output, momenta tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMomentumParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, momenta, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingFrequencyEstimatorParametersAttr is an optional argument to LoadTPUEmbeddingFrequencyEstimatorParameters.
type LoadTPUEmbeddingFrequencyEstimatorParametersAttr func(optionalAttr)

// LoadTPUEmbeddingFrequencyEstimatorParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingFrequencyEstimatorParametersTableId(value int64) LoadTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingFrequencyEstimatorParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFrequencyEstimatorParametersTableName(value string) LoadTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingFrequencyEstimatorParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFrequencyEstimatorParametersConfig(value string) LoadTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load frequency estimator embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the frequency estimator optimization algorithm.
//	last_hit_step: Value of last_hit_step used in the frequency estimator optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingFrequencyEstimatorParameters(scope *Scope, parameters tf.Output, last_hit_step tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingFrequencyEstimatorParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingFrequencyEstimatorParameters",
		Input: []tf.Input{
			parameters, last_hit_step,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingADAMParametersAttr is an optional argument to LoadTPUEmbeddingADAMParameters.
type LoadTPUEmbeddingADAMParametersAttr func(optionalAttr)

// LoadTPUEmbeddingADAMParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingADAMParametersTableId(value int64) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingADAMParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersTableName(value string) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingADAMParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersConfig(value string) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load ADAM embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the ADAM optimization algorithm.
//	momenta: Value of momenta used in the ADAM optimization algorithm.
//	velocities: Value of velocities used in the ADAM optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingADAMParameters(scope *Scope, parameters tf.Output, momenta tf.Output, velocities tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingADAMParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingADAMParameters",
		Input: []tf.Input{
			parameters, momenta, velocities,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingFTRLParametersGradAccumDebug.
type LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingFTRLParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingFTRLParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load FTRL embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the FTRL optimization algorithm.
//	accumulators: Value of accumulators used in the FTRL optimization algorithm.
//	linears: Value of linears used in the FTRL optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the FTRL optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingFTRLParametersGradAccumDebug(scope *Scope, parameters tf.Output, accumulators tf.Output, linears tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingFTRLParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, accumulators, linears, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingFTRLParametersAttr is an optional argument to LoadTPUEmbeddingFTRLParameters.
type LoadTPUEmbeddingFTRLParametersAttr func(optionalAttr)

// LoadTPUEmbeddingFTRLParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingFTRLParametersTableId(value int64) LoadTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersTableName(value string) LoadTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersConfig(value string) LoadTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load FTRL embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the FTRL optimization algorithm.
//	accumulators: Value of accumulators used in the FTRL optimization algorithm.
//	linears: Value of linears used in the FTRL optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingFTRLParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, linears tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingFTRLParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingFTRLParameters",
		Input: []tf.Input{
			parameters, accumulators, linears,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingStochasticGradientDescentParametersAttr is an optional argument to LoadTPUEmbeddingStochasticGradientDescentParameters.
type LoadTPUEmbeddingStochasticGradientDescentParametersAttr func(optionalAttr)

// LoadTPUEmbeddingStochasticGradientDescentParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingStochasticGradientDescentParametersTableId(value int64) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersTableName(value string) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersConfig(value string) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load SGD embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the stochastic gradient descent optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingStochasticGradientDescentParameters(scope *Scope, parameters tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingStochasticGradientDescentParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingStochasticGradientDescentParameters",
		Input: []tf.Input{
			parameters,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingAdagradParametersGradAccumDebug.
type RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebugConfig(value string) RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve Adagrad embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the Adagrad optimization algorithm.
//	accumulators: Parameter accumulators updated by the Adagrad optimization algorithm.
//	gradient_accumulators: Parameter gradient_accumulators updated by the Adagrad optimization algorithm.
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr) (parameters tf.Output, accumulators tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingAdagradParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// LoadTPUEmbeddingAdagradParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingAdagradParametersGradAccumDebug.
type LoadTPUEmbeddingAdagradParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingAdagradParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingAdagradParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdagradParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingAdagradParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Adagrad embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the Adagrad optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the Adagrad optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingAdagradParametersGradAccumDebug(scope *Scope, parameters tf.Output, accumulators tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdagradParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdagradParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, accumulators, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingAdagradParametersAttr is an optional argument to LoadTPUEmbeddingAdagradParameters.
type LoadTPUEmbeddingAdagradParametersAttr func(optionalAttr)

// LoadTPUEmbeddingAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingAdagradParametersTableId(value int64) LoadTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradParametersTableName(value string) LoadTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingAdagradParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradParametersConfig(value string) LoadTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Adagrad embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the Adagrad optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingAdagradParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdagradParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdagradParameters",
		Input: []tf.Input{
			parameters, accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingRaggedTensorBatchAttr is an optional argument to EnqueueTPUEmbeddingRaggedTensorBatch.
type EnqueueTPUEmbeddingRaggedTensorBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingRaggedTensorBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingRaggedTensorBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingRaggedTensorBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingRaggedTensorBatchCombiners(value []string) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// EnqueueTPUEmbeddingRaggedTensorBatchMaxSequenceLengths sets the optional max_sequence_lengths attribute to value.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingRaggedTensorBatchMaxSequenceLengths(value []int64) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["max_sequence_lengths"] = value
	}
}

// EnqueueTPUEmbeddingRaggedTensorBatchNumFeatures sets the optional num_features attribute to value.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingRaggedTensorBatchNumFeatures(value []int64) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["num_features"] = value
	}
}

// Eases the porting of code that uses tf.nn.embedding_lookup().
//
// sample_splits[i], embedding_indices[i] and aggregation_weights[i] correspond
// to the ith feature. table_ids[i] indicates which embedding table to look up ith
// feature.
//
// The tensors at corresponding positions in two of the input lists,
// embedding_indices and aggregation_weights, must have the same shape, i.e. rank 1
// with dim_size() equal to the total number of lookups into the table described by
// the corresponding feature.
//
// Arguments:
//	sample_splits: A list of rank 1 Tensors specifying the break points for splitting
// embedding_indices and aggregation_weights into rows.
// It corresponds to ids.row_splits in embedding_lookup(), when ids is a
// RaggedTensor.
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
// It corresponds to ids.values in embedding_lookup(), when ids is a RaggedTensor.
//	aggregation_weights: A list of rank 1 Tensors containing per training example
// aggregation weights. It corresponds to the values field of a RaggedTensor
// with the same row_splits as ids in embedding_lookup(), when ids is a
// RaggedTensor.
//	mode_override: A string input that overrides the mode specified in the
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//	table_ids: A list of integers specifying the identifier of the embedding table
// (offset of TableDescriptor in the TPUEmbeddingConfiguration) to lookup the
// corresponding input. The ith input is looked up using table_ids[i]. The size
// of the table_ids list must be equal to that of sample_indices,
// embedding_indices and aggregation_weights.
//
// Returns the created operation.
func EnqueueTPUEmbeddingRaggedTensorBatch(scope *Scope, sample_splits []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, table_ids []int64, optional ...EnqueueTPUEmbeddingRaggedTensorBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"table_ids": table_ids}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingRaggedTensorBatch",
		Input: []tf.Input{
			tf.OutputList(sample_splits), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingSparseTensorBatchAttr is an optional argument to EnqueueTPUEmbeddingSparseTensorBatch.
type EnqueueTPUEmbeddingSparseTensorBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingSparseTensorBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingSparseTensorBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingSparseTensorBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingSparseTensorBatchCombiners(value []string) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// EnqueueTPUEmbeddingSparseTensorBatchMaxSequenceLengths sets the optional max_sequence_lengths attribute to value.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingSparseTensorBatchMaxSequenceLengths(value []int64) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["max_sequence_lengths"] = value
	}
}

// EnqueueTPUEmbeddingSparseTensorBatchNumFeatures sets the optional num_features attribute to value.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingSparseTensorBatchNumFeatures(value []int64) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["num_features"] = value
	}
}

// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
//
// sample_indices[i], embedding_indices[i] and aggregation_weights[i] correspond
// to the ith feature. table_ids[i] indicates which embedding table to look up ith
// feature.
//
// The tensors at corresponding positions in the three input lists (sample_indices,
// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
// with dim_size() equal to the total number of lookups into the table described by
// the corresponding feature.
//
// Arguments:
//	sample_indices: A list of rank 1 Tensors specifying the training example to
// which the corresponding embedding_indices and aggregation_weights values
// belong. It corresponds to sp_ids.indices[:,0] in  embedding_lookup_sparse().
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
// It corresponds to sp_ids.values in embedding_lookup_sparse().
//	aggregation_weights: A list of rank 1 Tensors containing per training example
// aggregation weights. It corresponds to sp_weights.values in
// embedding_lookup_sparse().
//	mode_override: A string input that overrides the mode specified in the
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//	table_ids: A list of integers specifying the identifier of the embedding table
// (offset of TableDescriptor in the TPUEmbeddingConfiguration) to lookup the
// corresponding input. The ith input is looked up using table_ids[i]. The size
// of the table_ids list must be equal to that of sample_indices,
// embedding_indices and aggregation_weights.
//
// Returns the created operation.
func EnqueueTPUEmbeddingSparseTensorBatch(scope *Scope, sample_indices []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, table_ids []int64, optional ...EnqueueTPUEmbeddingSparseTensorBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"table_ids": table_ids}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingSparseTensorBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingIntegerBatchAttr is an optional argument to EnqueueTPUEmbeddingIntegerBatch.
type EnqueueTPUEmbeddingIntegerBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingIntegerBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingIntegerBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingIntegerBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op that enqueues a list of input batch tensors to TPUEmbedding.
//
// Arguments:
//	batch: A list of 1D tensors, one for each embedding table, containing the
// indices into the tables.
//	mode_override: A string input that overrides the mode specified in the
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingIntegerBatch(scope *Scope, batch []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingIntegerBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingIntegerBatch",
		Input: []tf.Input{
			tf.OutputList(batch), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// An op enabling differentiation of TPU Embeddings.
//
// This op simply returns its first input, which is assumed to have been sliced
// from the Tensors returned by TPUEmbeddingDequeueActivations. The presence of
// this op, and its first argument being a trainable Variable, enables automatic
// differentiation of graphs containing embeddings via the TPU Embedding Python
// libraries.
//
// Arguments:
//	embedding_variable: A trainable variable, enabling optimizers to find this op.
//	sliced_activations: The embedding activations Tensor to return.
//	table_id: The id of the table in the embedding layer configuration from which
// these activations were computed.
//	lookup_id: Identifier of the set of embedding indices which produced these
// activations.
func TPUEmbeddingActivations(scope *Scope, embedding_variable tf.Output, sliced_activations tf.Output, table_id int64, lookup_id int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"table_id": table_id, "lookup_id": lookup_id}
	opspec := tf.OpSpec{
		Type: "TPUEmbeddingActivations",
		Input: []tf.Input{
			embedding_variable, sliced_activations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that receives embedding activations on the TPU.
//
// The TPU system performs the embedding lookups and aggregations specified by
// the arguments to TPUEmbeddingEnqueue(Integer/Sparse/SparseTensor)Batch. The
// results of these aggregations are visible to the Tensorflow Graph as the
// outputs of a RecvTPUEmbeddingActivations op. This op returns a list containing
// one Tensor of activations per table specified in the model. There can be at
// most one RecvTPUEmbeddingActivations op in the TPU graph.
//
// Arguments:
//	num_outputs: The number of output activation tensors, equal to the number of
// embedding tables in the model.
//	config: Serialized TPUEmbeddingConfiguration proto.
//
// Returns A TensorList of embedding activations containing one Tensor per
// embedding table in the model.
func RecvTPUEmbeddingActivations(scope *Scope, num_outputs int64, config string) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_outputs": num_outputs, "config": config}
	opspec := tf.OpSpec{
		Type: "RecvTPUEmbeddingActivations",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("RecvTPUEmbeddingActivations", err)
		return
	}
	return outputs
}

// Sets up TPUEmbedding in a distributed TPU system.
//
// Arguments:
//	config: Serialized tensorflow.tpu.TPUEmbeddingConfiguration that
// describes the embedding lookups of the program.
//
// Returns the created operation.
func ConfigureTPUEmbedding(scope *Scope, config string) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "ConfigureTPUEmbedding",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Shuts down a running distributed TPU system.
//
// The op returns an error if no system is running.
//
// Returns the created operation.
func ShutdownDistributedTPU(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ShutdownDistributedTPU",
	}
	return scope.AddOperation(opspec)
}

// ConfigureDistributedTPUAttr is an optional argument to ConfigureDistributedTPU.
type ConfigureDistributedTPUAttr func(optionalAttr)

// ConfigureDistributedTPUEmbeddingConfig sets the optional embedding_config attribute to value.
//
// value: Reserved. Do not use.
// If not specified, defaults to ""
func ConfigureDistributedTPUEmbeddingConfig(value string) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["embedding_config"] = value
	}
}

// ConfigureDistributedTPUTpuEmbeddingConfig sets the optional tpu_embedding_config attribute to value.
//
// value: Serialized tensorflow.tpu.TPUEmbeddingConfiguration that
// describes the embedding lookups of the program.
// If not specified, defaults to ""
func ConfigureDistributedTPUTpuEmbeddingConfig(value string) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["tpu_embedding_config"] = value
	}
}

// ConfigureDistributedTPUIsGlobalInit sets the optional is_global_init attribute to value.
//
// value: Reserved. Do not use.
// If not specified, defaults to false
func ConfigureDistributedTPUIsGlobalInit(value bool) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["is_global_init"] = value
	}
}

// ConfigureDistributedTPUEnableWholeMeshCompilations sets the optional enable_whole_mesh_compilations attribute to value.
// If not specified, defaults to false
func ConfigureDistributedTPUEnableWholeMeshCompilations(value bool) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["enable_whole_mesh_compilations"] = value
	}
}

// ConfigureDistributedTPUCompilationFailureClosesChips sets the optional compilation_failure_closes_chips attribute to value.
// If not specified, defaults to true
func ConfigureDistributedTPUCompilationFailureClosesChips(value bool) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["compilation_failure_closes_chips"] = value
	}
}

// Sets up the centralized structures for a distributed TPU system.
//
// Returns A serialized tensorflow.tpu.TopologyProto that describes the TPU
// topology.
func ConfigureDistributedTPU(scope *Scope, optional ...ConfigureDistributedTPUAttr) (topology tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ConfigureDistributedTPU",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyAddSignAttr is an optional argument to ResourceApplyAddSign.
type ResourceApplyAddSignAttr func(optionalAttr)

// ResourceApplyAddSignUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and m tensors is
// protected by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAddSignUseLocking(value bool) ResourceApplyAddSignAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the AddSign update.
//
// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
// update <- (alpha + sign_decay * sign(g) *sign(m)) * g
// variable <- variable - lr_t * update
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	alpha: Must be a scalar.
//	sign_decay: Must be a scalar.
//	beta: Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAddSign(scope *Scope, var_ tf.Output, m tf.Output, lr tf.Output, alpha tf.Output, sign_decay tf.Output, beta tf.Output, grad tf.Output, optional ...ResourceApplyAddSignAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAddSign",
		Input: []tf.Input{
			var_, m, lr, alpha, sign_decay, beta, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// An op to send a tensor to the host.
//
// input: the tensor that will be sent to the host.
// Tinput: element type for input.
// key: A unique identifier for this region used to match up host transfers.
//
// Returns the created operation.
func XlaSendToHost(scope *Scope, input tf.Output, key string) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key": key}
	opspec := tf.OpSpec{
		Type: "XlaSendToHost",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyRMSPropAttr is an optional argument to ResourceSparseApplyRMSProp.
type ResourceSparseApplyRMSPropAttr func(optionalAttr)

// ResourceSparseApplyRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, ms, and mom tensors is protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyRMSPropUseLocking(value bool) ResourceSparseApplyRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the RMSProp algorithm.
//
// Note that in dense implementation of this algorithm, ms and mom will
// update even if the grad is zero, but in this sparse implementation, ms
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon)
//
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var, ms and mom.
//
// Returns the created operation.
func ResourceSparseApplyRMSProp(scope *Scope, var_ tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyRMSProp",
		Input: []tf.Input{
			var_, ms, mom, lr, rho, momentum, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyAdaMaxAttr is an optional argument to ResourceApplyAdaMax.
type ResourceApplyAdaMaxAttr func(optionalAttr)

// ResourceApplyAdaMaxUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdaMaxUseLocking(value bool) ResourceApplyAdaMaxAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the AdaMax algorithm.
//
// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
// v_t <- max(beta2 * v_{t-1}, abs(g))
// variable <- variable - learning_rate / (1 - beta1^t) * m_t / (v_t + epsilon)
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdaMax(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, beta1_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdaMaxAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdaMax",
		Input: []tf.Input{
			var_, m, v, beta1_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyKerasMomentumAttr is an optional argument to ResourceApplyKerasMomentum.
type ResourceApplyKerasMomentumAttr func(optionalAttr)

// ResourceApplyKerasMomentumUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyKerasMomentumUseLocking(value bool) ResourceApplyKerasMomentumAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyKerasMomentumUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, the tensor passed to compute grad will be
// var + momentum * accum, so in the end, the var you get is actually
// var + momentum * accum.
// If not specified, defaults to false
func ResourceApplyKerasMomentumUseNesterov(value bool) ResourceApplyKerasMomentumAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the momentum scheme.
//
// Set use_nesterov = True if you want to use Nesterov momentum.
//
// accum = accum * momentum - lr * grad
// var += accum
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	grad: The gradient.
//	momentum: Momentum. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyKerasMomentum(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, momentum tf.Output, optional ...ResourceApplyKerasMomentumAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyKerasMomentum",
		Input: []tf.Input{
			var_, accum, lr, grad, momentum,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyMomentumAttr is an optional argument to ResourceSparseApplyMomentum.
type ResourceSparseApplyMomentumAttr func(optionalAttr)

// ResourceSparseApplyMomentumUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyMomentumUseLocking(value bool) ResourceSparseApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceSparseApplyMomentumUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, the tensor passed to compute grad will be
// var - lr * momentum * accum, so in the end, the var you get is actually
// var - lr * momentum * accum.
// If not specified, defaults to false
func ResourceSparseApplyMomentumUseNesterov(value bool) ResourceSparseApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update relevant entries in '*var' and '*accum' according to the momentum scheme.
//
// Set use_nesterov = True if you want to use Nesterov momentum.
//
// That is for rows we have grad for, we update var and accum as follows:
//
// accum = accum * momentum + grad
// var -= lr * accum
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	momentum: Momentum. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyMomentum(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, indices tf.Output, momentum tf.Output, optional ...ResourceSparseApplyMomentumAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyMomentum",
		Input: []tf.Input{
			var_, accum, lr, grad, indices, momentum,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyMomentumAttr is an optional argument to ResourceApplyMomentum.
type ResourceApplyMomentumAttr func(optionalAttr)

// ResourceApplyMomentumUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyMomentumUseLocking(value bool) ResourceApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyMomentumUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, the tensor passed to compute grad will be
// var - lr * momentum * accum, so in the end, the var you get is actually
// var - lr * momentum * accum.
// If not specified, defaults to false
func ResourceApplyMomentumUseNesterov(value bool) ResourceApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the momentum scheme.
//
// Set use_nesterov = True if you want to use Nesterov momentum.
//
// accum = accum * momentum + grad
// var -= lr * accum
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	grad: The gradient.
//	momentum: Momentum. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyMomentum(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, momentum tf.Output, optional ...ResourceApplyMomentumAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyMomentum",
		Input: []tf.Input{
			var_, accum, lr, grad, momentum,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyFtrlV2Attr is an optional argument to ResourceSparseApplyFtrlV2.
type ResourceSparseApplyFtrlV2Attr func(optionalAttr)

// ResourceSparseApplyFtrlV2UseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyFtrlV2UseLocking(value bool) ResourceSparseApplyFtrlV2Attr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceSparseApplyFtrlV2MultiplyLinearByLr sets the optional multiply_linear_by_lr attribute to value.
// If not specified, defaults to false
func ResourceSparseApplyFtrlV2MultiplyLinearByLr(value bool) ResourceSparseApplyFtrlV2Attr {
	return func(m optionalAttr) {
		m["multiply_linear_by_lr"] = value
	}
}

// Update relevant entries in '*var' according to the Ftrl-proximal scheme.
//
// That is for rows we have grad for, we update var, accum and linear as follows:
// grad_with_shrinkage = grad + 2 * l2_shrinkage * var
// accum_new = accum + grad_with_shrinkage * grad_with_shrinkage
// linear += grad_with_shrinkage +
//     (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
// accum = accum_new
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	linear: Should be from a Variable().
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 shrinkage regularization. Must be a scalar.
//
//	lr_power: Scaling factor. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyFtrlV2(scope *Scope, var_ tf.Output, accum tf.Output, linear tf.Output, grad tf.Output, indices tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, l2_shrinkage tf.Output, lr_power tf.Output, optional ...ResourceSparseApplyFtrlV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyFtrlV2",
		Input: []tf.Input{
			var_, accum, linear, grad, indices, lr, l1, l2, l2_shrinkage, lr_power,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyFtrlAttr is an optional argument to ResourceSparseApplyFtrl.
type ResourceSparseApplyFtrlAttr func(optionalAttr)

// ResourceSparseApplyFtrlUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyFtrlUseLocking(value bool) ResourceSparseApplyFtrlAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceSparseApplyFtrlMultiplyLinearByLr sets the optional multiply_linear_by_lr attribute to value.
// If not specified, defaults to false
func ResourceSparseApplyFtrlMultiplyLinearByLr(value bool) ResourceSparseApplyFtrlAttr {
	return func(m optionalAttr) {
		m["multiply_linear_by_lr"] = value
	}
}

// Update relevant entries in '*var' according to the Ftrl-proximal scheme.
//
// That is for rows we have grad for, we update var, accum and linear as follows:
// accum_new = accum + grad * grad
// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
// accum = accum_new
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	linear: Should be from a Variable().
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	lr_power: Scaling factor. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyFtrl(scope *Scope, var_ tf.Output, accum tf.Output, linear tf.Output, grad tf.Output, indices tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, lr_power tf.Output, optional ...ResourceSparseApplyFtrlAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyFtrl",
		Input: []tf.Input{
			var_, accum, linear, grad, indices, lr, l1, l2, lr_power,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyAdagradDAAttr is an optional argument to ResourceSparseApplyAdagradDA.
type ResourceSparseApplyAdagradDAAttr func(optionalAttr)

// ResourceSparseApplyAdagradDAUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyAdagradDAUseLocking(value bool) ResourceSparseApplyAdagradDAAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update entries in '*var' and '*accum' according to the proximal adagrad scheme.
//
// Arguments:
//	var_: Should be from a Variable().
//	gradient_accumulator: Should be from a Variable().
//	gradient_squared_accumulator: Should be from a Variable().
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	lr: Learning rate. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	global_step: Training step number. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyAdagradDA(scope *Scope, var_ tf.Output, gradient_accumulator tf.Output, gradient_squared_accumulator tf.Output, grad tf.Output, indices tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, global_step tf.Output, optional ...ResourceSparseApplyAdagradDAAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyAdagradDA",
		Input: []tf.Input{
			var_, gradient_accumulator, gradient_squared_accumulator, grad, indices, lr, l1, l2, global_step,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyAdagradV2Attr is an optional argument to ResourceSparseApplyAdagradV2.
type ResourceSparseApplyAdagradV2Attr func(optionalAttr)

// ResourceSparseApplyAdagradV2UseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyAdagradV2UseLocking(value bool) ResourceSparseApplyAdagradV2Attr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceSparseApplyAdagradV2UpdateSlots sets the optional update_slots attribute to value.
// If not specified, defaults to true
func ResourceSparseApplyAdagradV2UpdateSlots(value bool) ResourceSparseApplyAdagradV2Attr {
	return func(m optionalAttr) {
		m["update_slots"] = value
	}
}

// Update relevant entries in '*var' and '*accum' according to the adagrad scheme.
//
// That is for rows we have grad for, we update var and accum as follows:
// accum += grad * grad
// var -= lr * grad * (1 / sqrt(accum))
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	epsilon: Constant factor. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyAdagradV2(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyAdagradV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyAdagradV2",
		Input: []tf.Input{
			var_, accum, lr, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyAdagradV2Attr is an optional argument to ResourceApplyAdagradV2.
type ResourceApplyAdagradV2Attr func(optionalAttr)

// ResourceApplyAdagradV2UseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdagradV2UseLocking(value bool) ResourceApplyAdagradV2Attr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyAdagradV2UpdateSlots sets the optional update_slots attribute to value.
// If not specified, defaults to true
func ResourceApplyAdagradV2UpdateSlots(value bool) ResourceApplyAdagradV2Attr {
	return func(m optionalAttr) {
		m["update_slots"] = value
	}
}

// Update '*var' according to the adagrad scheme.
//
// accum += grad * grad
// var -= lr * grad * (1 / (sqrt(accum) + epsilon))
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	epsilon: Constant factor. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdagradV2(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdagradV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdagradV2",
		Input: []tf.Input{
			var_, accum, lr, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyAdagradAttr is an optional argument to ResourceApplyAdagrad.
type ResourceApplyAdagradAttr func(optionalAttr)

// ResourceApplyAdagradUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdagradUseLocking(value bool) ResourceApplyAdagradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyAdagradUpdateSlots sets the optional update_slots attribute to value.
// If not specified, defaults to true
func ResourceApplyAdagradUpdateSlots(value bool) ResourceApplyAdagradAttr {
	return func(m optionalAttr) {
		m["update_slots"] = value
	}
}

// Update '*var' according to the adagrad scheme.
//
// accum += grad * grad
// var -= lr * grad * (1 / sqrt(accum))
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdagrad(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, optional ...ResourceApplyAdagradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdagrad",
		Input: []tf.Input{
			var_, accum, lr, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyProximalGradientDescentAttr is an optional argument to ResourceSparseApplyProximalGradientDescent.
type ResourceSparseApplyProximalGradientDescentAttr func(optionalAttr)

// ResourceSparseApplyProximalGradientDescentUseLocking sets the optional use_locking attribute to value.
//
// value: If True, the subtraction will be protected by a lock;
// otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyProximalGradientDescentUseLocking(value bool) ResourceSparseApplyProximalGradientDescentAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Sparse update '*var' as FOBOS algorithm with fixed learning rate.
//
// That is for rows we have grad for, we update var as follows:
// prox_v = var - alpha * grad
// var = sign(prox_v)/(1+alpha*l2) * max{|prox_v|-alpha*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	alpha: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyProximalGradientDescent(scope *Scope, var_ tf.Output, alpha tf.Output, l1 tf.Output, l2 tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyProximalGradientDescentAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyProximalGradientDescent",
		Input: []tf.Input{
			var_, alpha, l1, l2, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyProximalGradientDescentAttr is an optional argument to ResourceApplyProximalGradientDescent.
type ResourceApplyProximalGradientDescentAttr func(optionalAttr)

// ResourceApplyProximalGradientDescentUseLocking sets the optional use_locking attribute to value.
//
// value: If True, the subtraction will be protected by a lock;
// otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyProximalGradientDescentUseLocking(value bool) ResourceApplyProximalGradientDescentAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' as FOBOS algorithm with fixed learning rate.
//
// prox_v = var - alpha * delta
// var = sign(prox_v)/(1+alpha*l2) * max{|prox_v|-alpha*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	alpha: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	delta: The change.
//
// Returns the created operation.
func ResourceApplyProximalGradientDescent(scope *Scope, var_ tf.Output, alpha tf.Output, l1 tf.Output, l2 tf.Output, delta tf.Output, optional ...ResourceApplyProximalGradientDescentAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyProximalGradientDescent",
		Input: []tf.Input{
			var_, alpha, l1, l2, delta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Creates ngrams from ragged string data.
//
// This op accepts a ragged tensor with 1 ragged dimension containing only
// strings and outputs a ragged tensor with 1 ragged dimension containing ngrams
// of that string, joined along the innermost axis.
//
// Arguments:
//	data: The values tensor of the ragged string tensor to make ngrams out of. Must be a
// 1D string tensor.
//	data_splits: The splits tensor of the ragged string tensor to make ngrams out of.
//	separator: The string to append between elements of the token. Use "" for no separator.
//	ngram_widths: The sizes of the ngrams to create.
//	left_pad: The string to use to pad the left side of the ngram sequence. Only used if
// pad_width != 0.
//	right_pad: The string to use to pad the right side of the ngram sequence. Only used if
// pad_width != 0.
//	pad_width: The number of padding elements to add to each side of each
// sequence. Note that padding will never be greater than 'ngram_widths'-1
// regardless of this value. If `pad_width=-1`, then add `max(ngram_widths)-1`
// elements.
//
//
// Returns:
//	ngrams: The values tensor of the output ngrams ragged tensor.
//	ngrams_splits: The splits tensor of the output ngrams ragged tensor.
func StringNGrams(scope *Scope, data tf.Output, data_splits tf.Output, separator string, ngram_widths []int64, left_pad string, right_pad string, pad_width int64, preserve_short_sequences bool) (ngrams tf.Output, ngrams_splits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"separator": separator, "ngram_widths": ngram_widths, "left_pad": left_pad, "right_pad": right_pad, "pad_width": pad_width, "preserve_short_sequences": preserve_short_sequences}
	opspec := tf.OpSpec{
		Type: "StringNGrams",
		Input: []tf.Input{
			data, data_splits,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// UnicodeDecodeWithOffsetsAttr is an optional argument to UnicodeDecodeWithOffsets.
type UnicodeDecodeWithOffsetsAttr func(optionalAttr)

// UnicodeDecodeWithOffsetsErrors sets the optional errors attribute to value.
//
// value: Error handling policy when there is invalid formatting found in the input.
// The value of 'strict' will cause the operation to produce a InvalidArgument
// error on any invalid input formatting. A value of 'replace' (the default) will
// cause the operation to replace any invalid formatting in the input with the
// `replacement_char` codepoint. A value of 'ignore' will cause the operation to
// skip any invalid formatting in the input and produce no corresponding output
// character.
// If not specified, defaults to "replace"
func UnicodeDecodeWithOffsetsErrors(value string) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["errors"] = value
	}
}

// UnicodeDecodeWithOffsetsReplacementChar sets the optional replacement_char attribute to value.
//
// value: The replacement character codepoint to be used in place of any invalid
// formatting in the input when `errors='replace'`. Any valid unicode codepoint may
// be used. The default value is the default unicode replacement character is
// 0xFFFD or U+65533.)
// If not specified, defaults to 65533
func UnicodeDecodeWithOffsetsReplacementChar(value int64) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["replacement_char"] = value
	}
}

// UnicodeDecodeWithOffsetsReplaceControlCharacters sets the optional replace_control_characters attribute to value.
//
// value: Whether to replace the C0 control characters (00-1F) with the
// `replacement_char`. Default is false.
// If not specified, defaults to false
func UnicodeDecodeWithOffsetsReplaceControlCharacters(value bool) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["replace_control_characters"] = value
	}
}

// UnicodeDecodeWithOffsetsTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func UnicodeDecodeWithOffsetsTsplits(value tf.DataType) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Decodes each string in `input` into a sequence of Unicode code points.
//
// The character codepoints for all strings are returned using a single vector
// `char_values`, with strings expanded to characters in row-major order.
// Similarly, the character start byte offsets are returned using a single vector
// `char_to_byte_starts`, with strings expanded in row-major order.
//
// The `row_splits` tensor indicates where the codepoints and start offsets for
// each input string begin and end within the `char_values` and
// `char_to_byte_starts` tensors.  In particular, the values for the `i`th
// string (in row-major order) are stored in the slice
// `[row_splits[i]:row_splits[i+1]]`. Thus:
//
// * `char_values[row_splits[i]+j]` is the Unicode codepoint for the `j`th
//   character in the `i`th string (in row-major order).
// * `char_to_bytes_starts[row_splits[i]+j]` is the start byte offset for the `j`th
//   character in the `i`th string (in row-major order).
// * `row_splits[i+1] - row_splits[i]` is the number of characters in the `i`th
//   string (in row-major order).
//
// Arguments:
//	input: The text to be decoded. Can have any shape. Note that the output is flattened
// to a vector of char values.
//	input_encoding: Text encoding of the input strings. This is any of the encodings supported
// by ICU ucnv algorithmic converters. Examples: `"UTF-16", "US ASCII", "UTF-8"`.
//
// Returns:
//	row_splits: A 1D int32 tensor containing the row splits.
//	char_values: A 1D int32 Tensor containing the decoded codepoints.
//	char_to_byte_starts: A 1D int32 Tensor containing the byte index in the input string where each
// character in `char_values` starts.
func UnicodeDecodeWithOffsets(scope *Scope, input tf.Output, input_encoding string, optional ...UnicodeDecodeWithOffsetsAttr) (row_splits tf.Output, char_values tf.Output, char_to_byte_starts tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_encoding": input_encoding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnicodeDecodeWithOffsets",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// UnicodeTranscodeAttr is an optional argument to UnicodeTranscode.
type UnicodeTranscodeAttr func(optionalAttr)

// UnicodeTranscodeErrors sets the optional errors attribute to value.
//
// value: Error handling policy when there is invalid formatting found in the input.
// The value of 'strict' will cause the operation to produce a InvalidArgument
// error on any invalid input formatting. A value of 'replace' (the default) will
// cause the operation to replace any invalid formatting in the input with the
// `replacement_char` codepoint. A value of 'ignore' will cause the operation to
// skip any invalid formatting in the input and produce no corresponding output
// character.
// If not specified, defaults to "replace"
func UnicodeTranscodeErrors(value string) UnicodeTranscodeAttr {
	return func(m optionalAttr) {
		m["errors"] = value
	}
}

// UnicodeTranscodeReplacementChar sets the optional replacement_char attribute to value.
//
// value: The replacement character codepoint to be used in place of any invalid
// formatting in the input when `errors='replace'`. Any valid unicode codepoint may
// be used. The default value is the default unicode replacement character is
// 0xFFFD or U+65533.)
//
// Note that for UTF-8, passing a replacement character expressible in 1 byte, such
// as ' ', will preserve string alignment to the source since invalid bytes will be
// replaced with a 1-byte replacement. For UTF-16-BE and UTF-16-LE, any 1 or 2 byte
// replacement character will preserve byte alignment to the source.
// If not specified, defaults to 65533
func UnicodeTranscodeReplacementChar(value int64) UnicodeTranscodeAttr {
	return func(m optionalAttr) {
		m["replacement_char"] = value
	}
}

// UnicodeTranscodeReplaceControlCharacters sets the optional replace_control_characters attribute to value.
//
// value: Whether to replace the C0 control characters (00-1F) with the
// `replacement_char`. Default is false.
// If not specified, defaults to false
func UnicodeTranscodeReplaceControlCharacters(value bool) UnicodeTranscodeAttr {
	return func(m optionalAttr) {
		m["replace_control_characters"] = value
	}
}

// Transcode the input text from a source encoding to a destination encoding.
//
// The input is a string tensor of any shape. The output is a string tensor of
// the same shape containing the transcoded strings. Output strings are always
// valid unicode. If the input contains invalid encoding positions, the
// `errors` attribute sets the policy for how to deal with them. If the default
// error-handling policy is used, invalid formatting will be substituted in the
// output by the `replacement_char`. If the errors policy is to `ignore`, any
// invalid encoding positions in the input are skipped and not included in the
// output. If it set to `strict` then any invalid formatting will result in an
// InvalidArgument error.
//
// This operation can be used with `output_encoding = input_encoding` to enforce
// correct formatting for inputs even if they are already in the desired encoding.
//
// If the input is prefixed by a Byte Order Mark needed to determine encoding
// (e.g. if the encoding is UTF-16 and the BOM indicates big-endian), then that
// BOM will be consumed and not emitted into the output. If the input encoding
// is marked with an explicit endianness (e.g. UTF-16-BE), then the BOM is
// interpreted as a non-breaking-space and is preserved in the output (including
// always for UTF-8).
//
// The end result is that if the input is marked as an explicit endianness the
// transcoding is faithful to all codepoints in the source. If it is not marked
// with an explicit endianness, the BOM is not considered part of the string itself
// but as metadata, and so is not preserved in the output.
//
// Examples:
//
// >>> tf.strings.unicode_transcode(["Hello", "TensorFlow", "2.x"], "UTF-8", "UTF-16-BE")
// <tf.Tensor: shape=(3,), dtype=string, numpy=
// array([b'\x00H\x00e\x00l\x00l\x00o',
//        b'\x00T\x00e\x00n\x00s\x00o\x00r\x00F\x00l\x00o\x00w',
//        b'\x002\x00.\x00x'], dtype=object)>
// >>> tf.strings.unicode_transcode(["A", "B", "C"], "US ASCII", "UTF-8").numpy()
// array([b'A', b'B', b'C'], dtype=object)
//
// Arguments:
//	input: The text to be processed. Can have any shape.
//	input_encoding: Text encoding of the input strings. This is any of the encodings supported
// by ICU ucnv algorithmic converters. Examples: `"UTF-16", "US ASCII", "UTF-8"`.
//	output_encoding: The unicode encoding to use in the output. Must be one of
// `"UTF-8", "UTF-16-BE", "UTF-32-BE"`. Multi-byte encodings will be big-endian.
//
// Returns A string tensor containing unicode text encoded using `output_encoding`.
func UnicodeTranscode(scope *Scope, input tf.Output, input_encoding string, output_encoding string, optional ...UnicodeTranscodeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_encoding": input_encoding, "output_encoding": output_encoding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnicodeTranscode",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SubstrAttr is an optional argument to Substr.
type SubstrAttr func(optionalAttr)

// SubstrUnit sets the optional unit attribute to value.
//
// value: The unit that is used to create the substring.  One of: `"BYTE"` (for
// defining position and length by bytes) or `"UTF8_CHAR"` (for the UTF-8
// encoded Unicode code points).  The default is `"BYTE"`. Results are undefined if
// `unit=UTF8_CHAR` and the `input` strings do not contain structurally valid
// UTF-8.
// If not specified, defaults to "BYTE"
func SubstrUnit(value string) SubstrAttr {
	return func(m optionalAttr) {
		m["unit"] = value
	}
}

// Return substrings from `Tensor` of strings.
//
// For each string in the input `Tensor`, creates a substring starting at index
// `pos` with a total length of `len`.
//
// If `len` defines a substring that would extend beyond the length of the input
// string, or if `len` is negative, then as many characters as possible are used.
//
// A negative `pos` indicates distance within the string backwards from the end.
//
// If `pos` specifies an index which is out of range for any of the input strings,
// then an `InvalidArgumentError` is thrown.
//
// `pos` and `len` must have the same shape, otherwise a `ValueError` is thrown on
// Op creation.
//
// *NOTE*: `Substr` supports broadcasting up to two dimensions. More about
// broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// ---
//
// Examples
//
// Using scalar `pos` and `len`:
//
// ```python
// input = [b'Hello', b'World']
// position = 1
// length = 3
//
// output = [b'ell', b'orl']
// ```
//
// Using `pos` and `len` with same shape as `input`:
//
// ```python
// input = [[b'ten', b'eleven', b'twelve'],
//          [b'thirteen', b'fourteen', b'fifteen'],
//          [b'sixteen', b'seventeen', b'eighteen']]
// position = [[1, 2, 3],
//             [1, 2, 3],
//             [1, 2, 3]]
// length =   [[2, 3, 4],
//             [4, 3, 2],
//             [5, 5, 5]]
//
// output = [[b'en', b'eve', b'lve'],
//           [b'hirt', b'urt', b'te'],
//           [b'ixtee', b'vente', b'hteen']]
// ```
//
// Broadcasting `pos` and `len` onto `input`:
//
// ```
// input = [[b'ten', b'eleven', b'twelve'],
//          [b'thirteen', b'fourteen', b'fifteen'],
//          [b'sixteen', b'seventeen', b'eighteen'],
//          [b'nineteen', b'twenty', b'twentyone']]
// position = [1, 2, 3]
// length =   [1, 2, 3]
//
// output = [[b'e', b'ev', b'lve'],
//           [b'h', b'ur', b'tee'],
//           [b'i', b've', b'hte'],
//           [b'i', b'en', b'nty']]
// ```
//
// Broadcasting `input` onto `pos` and `len`:
//
// ```
// input = b'thirteen'
// position = [1, 5, 7]
// length =   [3, 2, 1]
//
// output = [b'hir', b'ee', b'n']
// ```
//
// Raises:
//
//   * `ValueError`: If the first argument cannot be converted to a
//      Tensor of `dtype string`.
//   * `InvalidArgumentError`: If indices are out of range.
//   * `ValueError`: If `pos` and `len` are not the same shape.
//
//
// Arguments:
//	input: Tensor of strings
//	pos: Scalar defining the position of first character in each substring
//	len: Scalar defining the number of characters to include in each substring
//
// Returns Tensor of substrings
func Substr(scope *Scope, input tf.Output, pos tf.Output, len tf.Output, optional ...SubstrAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Substr",
		Input: []tf.Input{
			input, pos, len,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Decode web-safe base64-encoded strings.
//
// Input may or may not have padding at the end. See EncodeBase64 for padding.
// Web-safe means that input must use - and _ instead of + and /.
//
// Arguments:
//	input: Base64 strings to decode.
//
// Returns Decoded strings.
func DecodeBase64(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeBase64",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeBase64Attr is an optional argument to EncodeBase64.
type EncodeBase64Attr func(optionalAttr)

// EncodeBase64Pad sets the optional pad attribute to value.
//
// value: Bool whether padding is applied at the ends.
// If not specified, defaults to false
func EncodeBase64Pad(value bool) EncodeBase64Attr {
	return func(m optionalAttr) {
		m["pad"] = value
	}
}

// Encode strings into web-safe base64 format.
//
// Refer to the following article for more information on base64 format:
// en.wikipedia.org/wiki/Base64. Base64 strings may have padding with '=' at the
// end so that the encoded has length multiple of 4. See Padding section of the
// link above.
//
// Web-safe means that the encoder uses - and _ instead of + and /.
//
// Arguments:
//	input: Strings to be encoded.
//
// Returns Input strings encoded in base64.
func EncodeBase64(scope *Scope, input tf.Output, optional ...EncodeBase64Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeBase64",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringUpperAttr is an optional argument to StringUpper.
type StringUpperAttr func(optionalAttr)

// StringUpperEncoding sets the optional encoding attribute to value.
//
// value: Character encoding of `input`. Allowed values are '' and 'utf-8'.
// Value '' is interpreted as ASCII.
// If not specified, defaults to ""
func StringUpperEncoding(value string) StringUpperAttr {
	return func(m optionalAttr) {
		m["encoding"] = value
	}
}

// Converts all lowercase characters into their respective uppercase replacements.
//
// Example:
//
// >>> tf.strings.upper("CamelCase string and ALL CAPS")
// <tf.Tensor: shape=(), dtype=string, numpy=b'CAMELCASE STRING AND ALL CAPS'>
//
//
// Arguments:
//	input: The input to be upper-cased.
func StringUpper(scope *Scope, input tf.Output, optional ...StringUpperAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringUpper",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringSplitAttr is an optional argument to StringSplit.
type StringSplitAttr func(optionalAttr)

// StringSplitSkipEmpty sets the optional skip_empty attribute to value.
//
// value: A `bool`. If `True`, skip the empty strings from the result.
// If not specified, defaults to true
func StringSplitSkipEmpty(value bool) StringSplitAttr {
	return func(m optionalAttr) {
		m["skip_empty"] = value
	}
}

// Split elements of `input` based on `delimiter` into a `SparseTensor`.
//
// Let N be the size of source (typically N will be the batch size). Split each
// element of `input` based on `delimiter` and return a `SparseTensor`
// containing the splitted tokens. Empty tokens are ignored.
//
// `delimiter` can be empty, or a string of split characters. If `delimiter` is an
//  empty string, each element of `input` is split into individual single-byte
//  character strings, including splitting of UTF-8 multibyte sequences. Otherwise
//  every character of `delimiter` is a potential split point.
//
// For example:
//   N = 2, input[0] is 'hello world' and input[1] is 'a b c', then the output
//   will be
//
//   indices = [0, 0;
//              0, 1;
//              1, 0;
//              1, 1;
//              1, 2]
//   shape = [2, 3]
//   values = ['hello', 'world', 'a', 'b', 'c']
//
// Arguments:
//	input: 1-D. Strings to split.
//	delimiter: 0-D. Delimiter characters (bytes), or empty string.
//
// Returns:
//	indices: A dense matrix of int64 representing the indices of the sparse tensor.
//	values: A vector of strings corresponding to the splited values.
//	shape: a length-2 vector of int64 representing the shape of the sparse
// tensor, where the first value is N and the second value is the maximum number
// of tokens in a single input entry.
func StringSplit(scope *Scope, input tf.Output, delimiter tf.Output, optional ...StringSplitAttr) (indices tf.Output, values tf.Output, shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringSplit",
		Input: []tf.Input{
			input, delimiter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// StringJoinAttr is an optional argument to StringJoin.
type StringJoinAttr func(optionalAttr)

// StringJoinSeparator sets the optional separator attribute to value.
//
// value: string, an optional join separator.
// If not specified, defaults to ""
func StringJoinSeparator(value string) StringJoinAttr {
	return func(m optionalAttr) {
		m["separator"] = value
	}
}

// Joins the strings in the given list of string tensors into one tensor;
//
// with the given separator (default is an empty separator).
//
// Examples:
//
// >>> s = ["hello", "world", "tensorflow"]
// >>> tf.strings.join(s, " ")
// <tf.Tensor: shape=(), dtype=string, numpy=b'hello world tensorflow'>
//
// Arguments:
//	inputs: A list of string tensors.  The tensors must all have the same shape,
// or be scalars.  Scalars may be mixed in; these will be broadcast to the shape
// of non-scalar inputs.
func StringJoin(scope *Scope, inputs []tf.Output, optional ...StringJoinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringJoin",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingProximalAdagradParametersAttr is an optional argument to RetrieveTPUEmbeddingProximalAdagradParameters.
type RetrieveTPUEmbeddingProximalAdagradParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingProximalAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingProximalAdagradParametersTableId(value int64) RetrieveTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingProximalAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingProximalAdagradParametersTableName(value string) RetrieveTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingProximalAdagradParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingProximalAdagradParametersConfig(value string) RetrieveTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve proximal Adagrad embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the proximal Adagrad optimization algorithm.
//	accumulators: Parameter accumulators updated by the proximal Adagrad optimization algorithm.
func RetrieveTPUEmbeddingProximalAdagradParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingProximalAdagradParametersAttr) (parameters tf.Output, accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingProximalAdagradParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ReduceJoinAttr is an optional argument to ReduceJoin.
type ReduceJoinAttr func(optionalAttr)

// ReduceJoinKeepDims sets the optional keep_dims attribute to value.
//
// value: If `True`, retain reduced dimensions with length `1`.
// If not specified, defaults to false
func ReduceJoinKeepDims(value bool) ReduceJoinAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// ReduceJoinSeparator sets the optional separator attribute to value.
//
// value: The separator to use when joining.
// If not specified, defaults to ""
func ReduceJoinSeparator(value string) ReduceJoinAttr {
	return func(m optionalAttr) {
		m["separator"] = value
	}
}

// Joins a string Tensor across the given dimensions.
//
// Computes the string join across dimensions in the given string Tensor of shape
// `[\\(d_0, d_1, ..., d_{n-1}\\)]`.  Returns a new Tensor created by joining the input
// strings with the given separator (default: empty string).  Negative indices are
// counted backwards from the end, with `-1` being equivalent to `n - 1`.  If
// indices are not specified, joins across all dimensions beginning from `n - 1`
// through `0`.
//
// For example:
//
// ```python
// # tensor `a` is [["a", "b"], ["c", "d"]]
// tf.reduce_join(a, 0) ==> ["ac", "bd"]
// tf.reduce_join(a, 1) ==> ["ab", "cd"]
// tf.reduce_join(a, -2) = tf.reduce_join(a, 0) ==> ["ac", "bd"]
// tf.reduce_join(a, -1) = tf.reduce_join(a, 1) ==> ["ab", "cd"]
// tf.reduce_join(a, 0, keep_dims=True) ==> [["ac", "bd"]]
// tf.reduce_join(a, 1, keep_dims=True) ==> [["ab"], ["cd"]]
// tf.reduce_join(a, 0, separator=".") ==> ["a.c", "b.d"]
// tf.reduce_join(a, [0, 1]) ==> "acbd"
// tf.reduce_join(a, [1, 0]) ==> "abcd"
// tf.reduce_join(a, []) ==> [["a", "b"], ["c", "d"]]
// tf.reduce_join(a) = tf.reduce_join(a, [1, 0]) ==> "abcd"
// ```
//
// Arguments:
//	inputs: The input to be joined.  All reduced indices must have non-zero size.
//	reduction_indices: The dimensions to reduce over.  Dimensions are reduced in the
// order specified.  Omitting `reduction_indices` is equivalent to passing
// `[n-1, n-2, ..., 0]`.  Negative indices from `-n` to `-1` are supported.
//
// Returns Has shape equal to that of the input with reduced dimensions removed or
// set to `1` depending on `keep_dims`.
func ReduceJoin(scope *Scope, inputs tf.Output, reduction_indices tf.Output, optional ...ReduceJoinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ReduceJoin",
		Input: []tf.Input{
			inputs, reduction_indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts each string in the input Tensor to its hash mod by a number of buckets.
//
// The hash function is deterministic on the content of the string within the
// process and will never change. However, it is not suitable for cryptography.
// This function may be used when CPU time is scarce and inputs are trusted or
// unimportant. There is a risk of adversaries constructing inputs that all hash
// to the same bucket. To prevent this problem, use a strong hash function with
// `tf.string_to_hash_bucket_strong`.
//
// Examples:
//
// >>> tf.strings.to_hash_bucket_fast(["Hello", "TensorFlow", "2.x"], 3).numpy()
// array([0, 2, 2])
//
// Arguments:
//	input: The strings to assign a hash bucket.
//	num_buckets: The number of buckets.
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToHashBucketFast(scope *Scope, input tf.Output, num_buckets int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "StringToHashBucketFast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StaticRegexReplaceAttr is an optional argument to StaticRegexReplace.
type StaticRegexReplaceAttr func(optionalAttr)

// StaticRegexReplaceReplaceGlobal sets the optional replace_global attribute to value.
//
// value: If True, the replacement is global, otherwise the replacement
// is done only on the first match.
// If not specified, defaults to true
func StaticRegexReplaceReplaceGlobal(value bool) StaticRegexReplaceAttr {
	return func(m optionalAttr) {
		m["replace_global"] = value
	}
}

// Replaces the match of pattern in input with rewrite.
//
// It follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: The text to be processed.
//	pattern: The regular expression to match the input.
//	rewrite: The rewrite to be applied to the matched expression.
//
// Returns The text after applying pattern and rewrite.
func StaticRegexReplace(scope *Scope, input tf.Output, pattern string, rewrite string, optional ...StaticRegexReplaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pattern": pattern, "rewrite": rewrite}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StaticRegexReplace",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RegexReplaceAttr is an optional argument to RegexReplace.
type RegexReplaceAttr func(optionalAttr)

// RegexReplaceReplaceGlobal sets the optional replace_global attribute to value.
//
// value: If True, the replacement is global (that is, all matches of the `pattern` regular
// expression in each input string are rewritten), otherwise the `rewrite`
// substitution is only made for the first `pattern` match.
// If not specified, defaults to true
func RegexReplaceReplaceGlobal(value bool) RegexReplaceAttr {
	return func(m optionalAttr) {
		m["replace_global"] = value
	}
}

// Replaces matches of the `pattern` regular expression in `input` with the
// replacement string provided in `rewrite`.
//
// It follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: The text to be processed.
//	pattern: The regular expression to be matched in the `input` strings.
//	rewrite: The rewrite string to be substituted for the `pattern` expression where it is
// matched in the `input` strings.
//
// Returns The text after applying pattern match and rewrite substitution.
func RegexReplace(scope *Scope, input tf.Output, pattern tf.Output, rewrite tf.Output, optional ...RegexReplaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RegexReplace",
		Input: []tf.Input{
			input, pattern, rewrite,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs deterministic pseudorandom random integers from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[minval, maxval)`.
//
// The outputs are a deterministic function of `shape`, `key`, `counter`, `alg`, `minval` and `maxval`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	key: Key for the counter-based RNG algorithm (shape uint64[1]).
//	counter: Initial counter for the counter-based RNG algorithm (shape uint64[2] or uint64[1] depending on the algorithm). If a larger vector is given, only the needed portion on the left (i.e. [:N]) will be used.
//	alg: The RNG algorithm (shape int32[]).
//	minval: Minimum value (inclusive, scalar).
//	maxval: Maximum value (exclusive, scalar).
//
// Returns Random values with specified shape.
func StatelessRandomUniformIntV2(scope *Scope, shape tf.Output, key tf.Output, counter tf.Output, alg tf.Output, minval tf.Output, maxval tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomUniformIntV2",
		Input: []tf.Input{
			shape, key, counter, alg, minval, maxval,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessTruncatedNormalV2Attr is an optional argument to StatelessTruncatedNormalV2.
type StatelessTruncatedNormalV2Attr func(optionalAttr)

// StatelessTruncatedNormalV2Dtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessTruncatedNormalV2Dtype(value tf.DataType) StatelessTruncatedNormalV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom values from a truncated normal distribution.
//
// The generated values follow a normal distribution with mean 0 and standard
// deviation 1, except that values whose magnitude is more than 2 standard
// deviations from the mean are dropped and re-picked.
//
// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	key: Key for the counter-based RNG algorithm (shape uint64[1]).
//	counter: Initial counter for the counter-based RNG algorithm (shape uint64[2] or uint64[1] depending on the algorithm). If a larger vector is given, only the needed portion on the left (i.e. [:N]) will be used.
//	alg: The RNG algorithm (shape int32[]).
//
// Returns Random values with specified shape.
func StatelessTruncatedNormalV2(scope *Scope, shape tf.Output, key tf.Output, counter tf.Output, alg tf.Output, optional ...StatelessTruncatedNormalV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessTruncatedNormalV2",
		Input: []tf.Input{
			shape, key, counter, alg,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessRandomNormalV2Attr is an optional argument to StatelessRandomNormalV2.
type StatelessRandomNormalV2Attr func(optionalAttr)

// StatelessRandomNormalV2Dtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessRandomNormalV2Dtype(value tf.DataType) StatelessRandomNormalV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	key: Key for the counter-based RNG algorithm (shape uint64[1]).
//	counter: Initial counter for the counter-based RNG algorithm (shape uint64[2] or uint64[1] depending on the algorithm). If a larger vector is given, only the needed portion on the left (i.e. [:N]) will be used.
//	alg: The RNG algorithm (shape int32[]).
//
// Returns Random values with specified shape.
func StatelessRandomNormalV2(scope *Scope, shape tf.Output, key tf.Output, counter tf.Output, alg tf.Output, optional ...StatelessRandomNormalV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomNormalV2",
		Input: []tf.Input{
			shape, key, counter, alg,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessRandomUniformV2Attr is an optional argument to StatelessRandomUniformV2.
type StatelessRandomUniformV2Attr func(optionalAttr)

// StatelessRandomUniformV2Dtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessRandomUniformV2Dtype(value tf.DataType) StatelessRandomUniformV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom random values from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[0, 1)`. The
// lower bound 0 is included in the range, while the upper bound 1 is excluded.
//
// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	key: Key for the counter-based RNG algorithm (shape uint64[1]).
//	counter: Initial counter for the counter-based RNG algorithm (shape uint64[2] or uint64[1] depending on the algorithm). If a larger vector is given, only the needed portion on the left (i.e. [:N]) will be used.
//	alg: The RNG algorithm (shape int32[]).
//
// Returns Random values with specified shape.
func StatelessRandomUniformV2(scope *Scope, shape tf.Output, key tf.Output, counter tf.Output, alg tf.Output, optional ...StatelessRandomUniformV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomUniformV2",
		Input: []tf.Input{
			shape, key, counter, alg,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs deterministic pseudorandom random numbers from a gamma distribution.
//
// Outputs random values from a gamma distribution.
//
// The outputs are a deterministic function of `shape`, `seed`, and `alpha`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//	alpha: The concentration of the gamma distribution. Shape must match the rightmost
// dimensions of `shape`.
//
// Returns Random values with specified shape.
func StatelessRandomGammaV2(scope *Scope, shape tf.Output, seed tf.Output, alpha tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomGammaV2",
		Input: []tf.Input{
			shape, seed, alpha,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessMultinomialAttr is an optional argument to StatelessMultinomial.
type StatelessMultinomialAttr func(optionalAttr)

// StatelessMultinomialOutputDtype sets the optional output_dtype attribute to value.
// If not specified, defaults to DT_INT64
func StatelessMultinomialOutputDtype(value tf.DataType) StatelessMultinomialAttr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// Draws samples from a multinomial distribution.
//
// Arguments:
//	logits: 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
// represents the unnormalized log probabilities for all classes.
//	num_samples: 0-D.  Number of independent samples to draw for each row slice.
//	seed: 2 seeds (shape [2]).
//
// Returns 2-D Tensor with shape `[batch_size, num_samples]`.  Each slice `[i, :]`
// contains the drawn class labels with range `[0, num_classes)`.
func StatelessMultinomial(scope *Scope, logits tf.Output, num_samples tf.Output, seed tf.Output, optional ...StatelessMultinomialAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessMultinomial",
		Input: []tf.Input{
			logits, num_samples, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessRandomNormalAttr is an optional argument to StatelessRandomNormal.
type StatelessRandomNormalAttr func(optionalAttr)

// StatelessRandomNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessRandomNormalDtype(value tf.DataType) StatelessRandomNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// The outputs are a deterministic function of `shape` and `seed`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//
// Returns Random values with specified shape.
func StatelessRandomNormal(scope *Scope, shape tf.Output, seed tf.Output, optional ...StatelessRandomNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomNormal",
		Input: []tf.Input{
			shape, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebug.
type RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugConfig(value string) RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve SGD embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the stochastic gradient descent optimization algorithm.
//	gradient_accumulators: Parameter gradient_accumulators updated by the Adadelta optimization algorithm.
func RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr) (parameters tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// StatelessRandomUniformAttr is an optional argument to StatelessRandomUniform.
type StatelessRandomUniformAttr func(optionalAttr)

// StatelessRandomUniformDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessRandomUniformDtype(value tf.DataType) StatelessRandomUniformAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom random values from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[0, 1)`. The
// lower bound 0 is included in the range, while the upper bound 1 is excluded.
//
// The outputs are a deterministic function of `shape` and `seed`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//
// Returns Random values with specified shape.
func StatelessRandomUniform(scope *Scope, shape tf.Output, seed tf.Output, optional ...StatelessRandomUniformAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomUniform",
		Input: []tf.Input{
			shape, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EnqueueTPUEmbeddingSparseBatchAttr is an optional argument to EnqueueTPUEmbeddingSparseBatch.
type EnqueueTPUEmbeddingSparseBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingSparseBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingSparseBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingSparseBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingSparseBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingSparseBatchCombiners(value []string) EnqueueTPUEmbeddingSparseBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// An op that enqueues TPUEmbedding input indices from a SparseTensor.
//
// This Op eases the porting of code that uses embedding_lookup_sparse(),
// although some Python preprocessing of the SparseTensor arguments to
// embedding_lookup_sparse() is required to produce the arguments to this Op,
// since only a single EnqueueTPUEmbeddingSparseBatch Op is allowed per training
// step.
//
// The tensors at corresponding positions in the three input lists
// must have the same shape, i.e. rank 1 with dim_size() equal to the total
// number of lookups into the table described by the corresponding table_id.
//
// Arguments:
//	sample_indices: A list of rank 1 Tensors specifying the training example and
// feature to which the corresponding embedding_indices and aggregation_weights
// values belong. sample_indices[i] must equal b * nf + f, where nf is the
// number of features from the corresponding table, f is in [0, nf), and
// b is in [0, batch size).
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
//	aggregation_weights: A list of rank 1 Tensors containing per sample -- i.e. per
// (training example, feature) -- aggregation weights.
//	mode_override: A string input that overrides the mode specified in the
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingSparseBatch(scope *Scope, sample_indices []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingSparseBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingSparseBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceScatterNdUpdateAttr is an optional argument to ResourceScatterNdUpdate.
type ResourceScatterNdUpdateAttr func(optionalAttr)

// ResourceScatterNdUpdateUseLocking sets the optional use_locking attribute to value.
//
// value: An optional bool. Defaults to True. If True, the assignment will
// be protected by a lock; otherwise the behavior is undefined,
// but may exhibit less contention.
// If not specified, defaults to true
func ResourceScatterNdUpdateUseLocking(value bool) ResourceScatterNdUpdateAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Applies sparse `updates` to individual values or slices within a given
//
// variable according to `indices`.
//
// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `ref`.
// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
// dimension of `ref`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// ```
// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]].
// ```
//
// For example, say we want to update 4 scattered elements to a rank-1 tensor to
// 8 elements. In Python, that update would look like this:
//
// ```python
//     ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8])
//     indices = tf.constant([[4], [3], [1] ,[7]])
//     updates = tf.constant([9, 10, 11, 12])
//     update = tf.scatter_nd_update(ref, indices, updates)
//     with tf.Session() as sess:
//       print sess.run(update)
// ```
//
// The resulting update to ref would look like this:
//
//     [1, 11, 3, 10, 9, 6, 7, 12]
//
// See `tf.scatter_nd` for more details about how to make updates to
// slices.
//
// Arguments:
//	ref: A resource handle. Must be from a VarHandleOp.
//	indices: A Tensor. Must be one of the following types: int32, int64.
// A tensor of indices into ref.
//	updates: A Tensor. Must have the same type as ref. A tensor of updated
// values to add to ref.
//
// Returns the created operation.
func ResourceScatterNdUpdate(scope *Scope, ref tf.Output, indices tf.Output, updates tf.Output, optional ...ResourceScatterNdUpdateAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterNdUpdate",
		Input: []tf.Input{
			ref, indices, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// An Op to permute tensors across replicated TPU instances.
//
// Each instance supplies its own input.
//
// For example, suppose there are 4 TPU instances: `[A, B, C, D]`. Passing
// source_target_pairs=`[[0,1],[1,2],[2,3],[3,0]]` gets the outputs:
// `[D, A, B, C]`.
//
// Arguments:
//	input: The local input to be permuted. Currently only supports float and
// bfloat16.
//	source_target_pairs: A tensor with shape [num_pairs, 2].
//
// Returns The permuted input.
func CollectivePermute(scope *Scope, input tf.Output, source_target_pairs tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CollectivePermute",
		Input: []tf.Input{
			input, source_target_pairs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFT3DAttr is an optional argument to IRFFT3D.
type IRFFT3DAttr func(optionalAttr)

// IRFFT3DTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFT3DTreal(value tf.DataType) IRFFT3DAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// Inverse 3D real-valued fast Fourier transform.
//
// Computes the inverse 3-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most 3 dimensions of `input`.
//
// The inner-most 3 dimensions of `input` are assumed to be the result of `RFFT3D`:
// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
// from the size of the inner-most 3 dimensions of `input`. If the FFT length used
// to compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along each axis `IRFFT3D` is computed on, if `fft_length` (or
// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A complex tensor.
//	fft_length: An int32 tensor of shape [3]. The FFT length for each dimension.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most 3
//   dimensions of `input` are replaced with the `fft_length` samples of their
//   inverse 3D real Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.irfftn with 3 dimensions.
// @end_compatibility
func IRFFT3D(scope *Scope, input tf.Output, fft_length tf.Output, optional ...IRFFT3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFT3D",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFT2DAttr is an optional argument to IRFFT2D.
type IRFFT2DAttr func(optionalAttr)

// IRFFT2DTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFT2DTreal(value tf.DataType) IRFFT2DAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// Inverse 2D real-valued fast Fourier transform.
//
// Computes the inverse 2-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most 2 dimensions of `input`.
//
// The inner-most 2 dimensions of `input` are assumed to be the result of `RFFT2D`:
// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
// from the size of the inner-most 2 dimensions of `input`. If the FFT length used
// to compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along each axis `IRFFT2D` is computed on, if `fft_length` (or
// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A complex tensor.
//	fft_length: An int32 tensor of shape [2]. The FFT length for each dimension.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most 2
//   dimensions of `input` are replaced with the `fft_length` samples of their
//   inverse 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfft2
// @end_compatibility
func IRFFT2D(scope *Scope, input tf.Output, fft_length tf.Output, optional ...IRFFT2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFT2D",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RFFT2DAttr is an optional argument to RFFT2D.
type RFFT2DAttr func(optionalAttr)

// RFFT2DTcomplex sets the optional Tcomplex attribute to value.
// If not specified, defaults to DT_COMPLEX64
func RFFT2DTcomplex(value tf.DataType) RFFT2DAttr {
	return func(m optionalAttr) {
		m["Tcomplex"] = value
	}
}

// 2D real-valued fast Fourier transform.
//
// Computes the 2-dimensional discrete Fourier transform of a real-valued signal
// over the inner-most 2 dimensions of `input`.
//
// Since the DFT of a real signal is Hermitian-symmetric, `RFFT2D` only returns the
// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
// of `output`: the zero-frequency term, followed by the `fft_length / 2`
// positive-frequency terms.
//
// Along each axis `RFFT2D` is computed on, if `fft_length` is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A float32 tensor.
//	fft_length: An int32 tensor of shape [2]. The FFT length for each dimension.
//
// Returns A complex64 tensor of the same rank as `input`. The inner-most 2
//   dimensions of `input` are replaced with their 2D Fourier transform. The
//   inner-most dimension contains `fft_length / 2 + 1` unique frequency
//   components.
//
// @compatibility(numpy)
// Equivalent to np.fft.rfft2
// @end_compatibility
func RFFT2D(scope *Scope, input tf.Output, fft_length tf.Output, optional ...RFFT2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RFFT2D",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFTAttr is an optional argument to IRFFT.
type IRFFTAttr func(optionalAttr)

// IRFFTTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFTTreal(value tf.DataType) IRFFTAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// Inverse real-valued fast Fourier transform.
//
// Computes the inverse 1-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most dimension of `input`.
//
// The inner-most dimension of `input` is assumed to be the result of `RFFT`: the
// `fft_length / 2 + 1` unique components of the DFT of a real-valued signal. If
// `fft_length` is not provided, it is computed from the size of the inner-most
// dimension of `input` (`fft_length = 2 * (inner - 1)`). If the FFT length used to
// compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along the axis `IRFFT` is computed on, if `fft_length / 2 + 1` is smaller
// than the corresponding dimension of `input`, the dimension is cropped. If it is
// larger, the dimension is padded with zeros.
//
// Arguments:
//	input: A complex tensor.
//	fft_length: An int32 tensor of shape [1]. The FFT length.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most
//   dimension of `input` is replaced with the `fft_length` samples of its inverse
//   1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfft
// @end_compatibility
func IRFFT(scope *Scope, input tf.Output, fft_length tf.Output, optional ...IRFFTAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFT",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RFFTAttr is an optional argument to RFFT.
type RFFTAttr func(optionalAttr)

// RFFTTcomplex sets the optional Tcomplex attribute to value.
// If not specified, defaults to DT_COMPLEX64
func RFFTTcomplex(value tf.DataType) RFFTAttr {
	return func(m optionalAttr) {
		m["Tcomplex"] = value
	}
}

// Real-valued fast Fourier transform.
//
// Computes the 1-dimensional discrete Fourier transform of a real-valued signal
// over the inner-most dimension of `input`.
//
// Since the DFT of a real signal is Hermitian-symmetric, `RFFT` only returns the
// `fft_length / 2 + 1` unique components of the FFT: the zero-frequency term,
// followed by the `fft_length / 2` positive-frequency terms.
//
// Along the axis `RFFT` is computed on, if `fft_length` is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A float32 tensor.
//	fft_length: An int32 tensor of shape [1]. The FFT length.
//
// Returns A complex64 tensor of the same rank as `input`. The inner-most
//   dimension of `input` is replaced with the `fft_length / 2 + 1` unique
//   frequency components of its 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.rfft
// @end_compatibility
func RFFT(scope *Scope, input tf.Output, fft_length tf.Output, optional ...RFFTAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RFFT",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// 3D fast Fourier transform.
//
// Computes the 3-dimensional discrete Fourier transform over the inner-most 3
// dimensions of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 3
//   dimensions of `input` are replaced with their 3D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fftn with 3 dimensions.
// @end_compatibility
func FFT3D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT3D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 2D fast Fourier transform.
//
// Computes the inverse 2-dimensional discrete Fourier transform over the
// inner-most 2 dimensions of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 2
//   dimensions of `input` are replaced with their inverse 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifft2
// @end_compatibility
func IFFT2D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT2D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// 2D fast Fourier transform.
//
// Computes the 2-dimensional discrete Fourier transform over the inner-most
// 2 dimensions of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 2
//   dimensions of `input` are replaced with their 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fft2
// @end_compatibility
func FFT2D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT2D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse fast Fourier transform.
//
// Computes the inverse 1-dimensional discrete Fourier transform over the
// inner-most dimension of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most
//   dimension of `input` is replaced with its inverse 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifft
// @end_compatibility
func IFFT(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Fast Fourier transform.
//
// Computes the 1-dimensional discrete Fourier transform over the inner-most
// dimension of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most
//   dimension of `input` is replaced with its 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fft
// @end_compatibility
func FFT(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes a scalar summary.
//
// Writes scalar `value` at `step` with `tag` using summary `writer`.
//
// Returns the created operation.
func WriteScalarSummary(scope *Scope, writer tf.Output, step tf.Output, tag tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteScalarSummary",
		Input: []tf.Input{
			writer, step, tag, value,
		},
	}
	return scope.AddOperation(opspec)
}

// The gradient of SparseFillEmptyRows.
//
// Takes vectors reverse_index_map, shaped `[N]`, and grad_values,
// shaped `[N_full]`, where `N_full >= N` and copies data into either
// `d_values` or `d_default_value`.  Here `d_values` is shaped `[N]` and
// `d_default_value` is a scalar.
//
//   d_values[j] = grad_values[reverse_index_map[j]]
//   d_default_value = sum_{k : 0 .. N_full - 1} (
//      grad_values[k] * 1{k not in reverse_index_map})
//
// Arguments:
//	reverse_index_map: 1-D.  The reverse index map from SparseFillEmptyRows.
//	grad_values: 1-D.  The gradients from backprop.
//
// Returns:
//	d_values: 1-D.  The backprop into values.
//	d_default_value: 0-D.  The backprop into default_value.
func SparseFillEmptyRowsGrad(scope *Scope, reverse_index_map tf.Output, grad_values tf.Output) (d_values tf.Output, d_default_value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseFillEmptyRowsGrad",
		Input: []tf.Input{
			reverse_index_map, grad_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Fills empty rows in the input 2-D `SparseTensor` with a default value.
//
// The input `SparseTensor` is represented via the tuple of inputs
// (`indices`, `values`, `dense_shape`).  The output `SparseTensor` has the
// same `dense_shape` but with indices `output_indices` and values
// `output_values`.
//
// This op inserts a single entry for every row that doesn't have any values.
// The index is created as `[row, 0, ..., 0]` and the inserted value
// is `default_value`.
//
// For example, suppose `sp_input` has shape `[5, 6]` and non-empty values:
//
//     [0, 1]: a
//     [0, 3]: b
//     [2, 0]: c
//     [3, 1]: d
//
// Rows 1 and 4 are empty, so the output will be of shape `[5, 6]` with values:
//
//     [0, 1]: a
//     [0, 3]: b
//     [1, 0]: default_value
//     [2, 0]: c
//     [3, 1]: d
//     [4, 0]: default_value
//
// The output `SparseTensor` will be in row-major order and will have the
// same shape as the input.
//
// This op also returns an indicator vector shaped `[dense_shape[0]]` such that
//
//     empty_row_indicator[i] = True iff row i was an empty row.
//
// And a reverse index map vector shaped `[indices.shape[0]]` that is used during
// backpropagation,
//
//     reverse_index_map[j] = out_j s.t. indices[j, :] == output_indices[out_j, :]
//
// Arguments:
//	indices: 2-D. the indices of the sparse tensor.
//	values: 1-D. the values of the sparse tensor.
//	dense_shape: 1-D. the shape of the sparse tensor.
//	default_value: 0-D. default value to insert into location `[row, 0, ..., 0]`
//   for rows missing from the input sparse tensor.
// output indices: 2-D. the indices of the filled sparse tensor.
//
// Returns:
//	output_indices
//	output_values: 1-D. the values of the filled sparse tensor.
//	empty_row_indicator: 1-D. whether the dense row was missing in the
// input sparse tensor.
//	reverse_index_map: 1-D. a map from the input indices to the output indices.
func SparseFillEmptyRows(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output, default_value tf.Output) (output_indices tf.Output, output_values tf.Output, empty_row_indicator tf.Output, reverse_index_map tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseFillEmptyRows",
		Input: []tf.Input{
			indices, values, dense_shape, default_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Returns the element-wise min of two SparseTensors.
//
// Assumes the two SparseTensors have the same shape, i.e., no broadcasting.
//
// Arguments:
//	a_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, in the canonical lexicographic ordering.
//	a_values: 1-D.  `N` non-empty values corresponding to `a_indices`.
//	a_shape: 1-D.  Shape of the input SparseTensor.
//	b_indices: counterpart to `a_indices` for the other operand.
//	b_values: counterpart to `a_values` for the other operand; must be of the same dtype.
//	b_shape: counterpart to `a_shape` for the other operand; the two shapes must be equal.
//
// Returns:
//	output_indices: 2-D.  The indices of the output SparseTensor.
//	output_values: 1-D.  The values of the output SparseTensor.
func SparseSparseMinimum(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b_indices tf.Output, b_values tf.Output, b_shape tf.Output) (output_indices tf.Output, output_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSparseMinimum",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b_indices, b_values, b_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns the element-wise max of two SparseTensors.
//
// Assumes the two SparseTensors have the same shape, i.e., no broadcasting.
//
// Arguments:
//	a_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, in the canonical lexicographic ordering.
//	a_values: 1-D.  `N` non-empty values corresponding to `a_indices`.
//	a_shape: 1-D.  Shape of the input SparseTensor.
//	b_indices: counterpart to `a_indices` for the other operand.
//	b_values: counterpart to `a_values` for the other operand; must be of the same dtype.
//	b_shape: counterpart to `a_shape` for the other operand; the two shapes must be equal.
//
// Returns:
//	output_indices: 2-D.  The indices of the output SparseTensor.
//	output_values: 1-D.  The values of the output SparseTensor.
func SparseSparseMaximum(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b_indices tf.Output, b_values tf.Output, b_shape tf.Output) (output_indices tf.Output, output_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSparseMaximum",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b_indices, b_values, b_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Applies softmax to a batched N-D `SparseTensor`.
//
// The inputs represent an N-D SparseTensor  with logical shape `[..., B, C]`
// (where `N >= 2`), and with indices sorted in the canonical lexicographic order.
//
// This op is equivalent to applying the normal `tf.nn.softmax()` to each innermost
// logical submatrix with shape `[B, C]`, but with the catch that *the implicitly
// zero elements do not participate*.  Specifically, the algorithm is equivalent
// to the following:
//
//   (1) Applies `tf.nn.softmax()` to a densified view of each innermost submatrix
//       with shape `[B, C]`, along the size-C dimension;
//   (2) Masks out the original implicitly-zero locations;
//   (3) Renormalizes the remaining elements.
//
// Hence, the `SparseTensor` result has exactly the same non-zero indices and
// shape.
//
// Arguments:
//	sp_indices: 2-D.  `NNZ x R` matrix with the indices of non-empty values in a
// SparseTensor, in canonical ordering.
//	sp_values: 1-D.  `NNZ` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//
// Returns 1-D.  The `NNZ` values for the result `SparseTensor`.
func SparseSoftmax(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSoftmax",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Component-wise divides a SparseTensor by a dense Tensor.
//
// *Limitation*: this Op only broadcasts the dense side to the sparse side, but not
// the other direction.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseDiv(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseDiv",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceMaxAttr is an optional argument to SparseReduceMax.
type SparseReduceMaxAttr func(optionalAttr)

// SparseReduceMaxKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceMaxKeepDims(value bool) SparseReduceMaxAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the max of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_max()`.  In particular, this Op also returns a dense `Tensor`
// instead of a sparse one.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
//
// Returns `R-K`-D.  The reduced Tensor.
func SparseReduceMax(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceMaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceMax",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reshapes a SparseTensor to represent values in a new dense shape.
//
// This operation has the same semantics as reshape on the represented dense
// tensor.  The `input_indices` are recomputed based on the requested `new_shape`.
//
// If one component of `new_shape` is the special value -1, the size of that
// dimension is computed so that the total dense size remains constant.  At
// most one component of `new_shape` can be -1.  The number of dense elements
// implied by `new_shape` must be the same as the number of dense elements
// originally implied by `input_shape`.
//
// Reshaping does not affect the order of values in the SparseTensor.
//
// If the input tensor has rank `R_in` and `N` non-empty values, and `new_shape`
// has length `R_out`, then `input_indices` has shape `[N, R_in]`,
// `input_shape` has length `R_in`, `output_indices` has shape `[N, R_out]`, and
// `output_shape` has length `R_out`.
//
// Arguments:
//	input_indices: 2-D.  `N x R_in` matrix with the indices of non-empty values in a
// SparseTensor.
//	input_shape: 1-D.  `R_in` vector with the input SparseTensor's dense shape.
//	new_shape: 1-D.  `R_out` vector with the requested new dense shape.
//
// Returns:
//	output_indices: 2-D.  `N x R_out` matrix with the updated indices of non-empty
// values in the output SparseTensor.
//	output_shape: 1-D.  `R_out` vector with the full dense shape of the output
// SparseTensor.  This is the same as `new_shape` but with any -1 dimensions
// filled in.
func SparseReshape(scope *Scope, input_indices tf.Output, input_shape tf.Output, new_shape tf.Output) (output_indices tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseReshape",
		Input: []tf.Input{
			input_indices, input_shape, new_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// The gradient operator for the SparseSlice op.
//
// This op takes in the upstream gradient w.r.t. non-empty values of
// the sliced `SparseTensor`, and outputs the gradients w.r.t.
// the non-empty values of input `SparseTensor`.
//
// Arguments:
//	backprop_val_grad: 1-D. The gradient with respect to
// the non-empty values of the sliced `SparseTensor`.
//	input_indices: 2-D.  The `indices` of the input `SparseTensor`.
//	input_start: 1-D. tensor represents the start of the slice.
//	output_indices: 2-D.  The `indices` of the sliced `SparseTensor`.
//
// Returns 1-D. The gradient with respect to the non-empty values of input `SparseTensor`.
func SparseSliceGrad(scope *Scope, backprop_val_grad tf.Output, input_indices tf.Output, input_start tf.Output, output_indices tf.Output) (val_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSliceGrad",
		Input: []tf.Input{
			backprop_val_grad, input_indices, input_start, output_indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates sparse cross from a list of sparse and dense tensors.
//
// The op takes two lists, one of 2D `SparseTensor` and one of 2D `Tensor`, each
// representing features of one feature column. It outputs a 2D `SparseTensor` with
// the batchwise crosses of these features.
//
// For example, if the inputs are
//
//     inputs[0]: SparseTensor with shape = [2, 2]
//     [0, 0]: "a"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
//     inputs[1]: SparseTensor with shape = [2, 1]
//     [0, 0]: "d"
//     [1, 0]: "e"
//
//     inputs[2]: Tensor [["f"], ["g"]]
//
// then the output will be
//
//     shape = [2, 2]
//     [0, 0]: "a_X_d_X_f"
//     [1, 0]: "b_X_e_X_g"
//     [1, 1]: "c_X_e_X_g"
//
// if hashed_output=true then the output will be
//
//     shape = [2, 2]
//     [0, 0]: FingerprintCat64(
//                 Fingerprint64("f"), FingerprintCat64(
//                     Fingerprint64("d"), Fingerprint64("a")))
//     [1, 0]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("b")))
//     [1, 1]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("c")))
//
// Arguments:
//	indices: 2-D.  Indices of each input `SparseTensor`.
//	values: 1-D.   values of each `SparseTensor`.
//	shapes: 1-D.   Shapes of each `SparseTensor`.
//	dense_inputs: 2-D.    Columns represented by dense `Tensor`.
//	num_buckets: It is used if hashed_output is true.
// output = hashed_value%num_buckets if num_buckets > 0 else hashed_value.
//	strong_hash: boolean, if true, siphash with salt will be used instead of farmhash.
//	salt: Specify the salt that will be used by the siphash function.
//
// Returns:
//	output_indices: 2-D.  Indices of the concatenated `SparseTensor`.
//	output_values: 1-D.  Non-empty values of the concatenated or hashed
// `SparseTensor`.
//	output_shape: 1-D.  Shape of the concatenated `SparseTensor`.
func SparseCrossHashed(scope *Scope, indices []tf.Output, values []tf.Output, shapes []tf.Output, dense_inputs []tf.Output, num_buckets tf.Output, strong_hash tf.Output, salt tf.Output) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseCrossHashed",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(values), tf.OutputList(shapes), tf.OutputList(dense_inputs), num_buckets, strong_hash, salt,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Generates sparse cross from a list of sparse and dense tensors.
//
// The op takes two lists, one of 2D `SparseTensor` and one of 2D `Tensor`, each
// representing features of one feature column. It outputs a 2D `SparseTensor` with
// the batchwise crosses of these features.
//
// For example, if the inputs are
//
//     inputs[0]: SparseTensor with shape = [2, 2]
//     [0, 0]: "a"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
//     inputs[1]: SparseTensor with shape = [2, 1]
//     [0, 0]: "d"
//     [1, 0]: "e"
//
//     inputs[2]: Tensor [["f"], ["g"]]
//
// then the output will be
//
//     shape = [2, 2]
//     [0, 0]: "a_X_d_X_f"
//     [1, 0]: "b_X_e_X_g"
//     [1, 1]: "c_X_e_X_g"
//
// if hashed_output=true then the output will be
//
//     shape = [2, 2]
//     [0, 0]: FingerprintCat64(
//                 Fingerprint64("f"), FingerprintCat64(
//                     Fingerprint64("d"), Fingerprint64("a")))
//     [1, 0]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("b")))
//     [1, 1]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("c")))
//
// Arguments:
//	indices: 2-D.  Indices of each input `SparseTensor`.
//	values: 1-D.   values of each `SparseTensor`.
//	shapes: 1-D.   Shapes of each `SparseTensor`.
//	dense_inputs: 2-D.    Columns represented by dense `Tensor`.
//	hashed_output: If true, returns the hash of the cross instead of the string.
// This will allow us avoiding string manipulations.
//	num_buckets: It is used if hashed_output is true.
// output = hashed_value%num_buckets if num_buckets > 0 else hashed_value.
//	hash_key: Specify the hash_key that will be used by the `FingerprintCat64`
// function to combine the crosses fingerprints.
//
//
//
// Returns:
//	output_indices: 2-D.  Indices of the concatenated `SparseTensor`.
//	output_values: 1-D.  Non-empty values of the concatenated or hashed
// `SparseTensor`.
//	output_shape: 1-D.  Shape of the concatenated `SparseTensor`.
func SparseCross(scope *Scope, indices []tf.Output, values []tf.Output, shapes []tf.Output, dense_inputs []tf.Output, hashed_output bool, num_buckets int64, hash_key int64, out_type tf.DataType, internal_type tf.DataType) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"hashed_output": hashed_output, "num_buckets": num_buckets, "hash_key": hash_key, "out_type": out_type, "internal_type": internal_type}
	opspec := tf.OpSpec{
		Type: "SparseCross",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(values), tf.OutputList(shapes), tf.OutputList(dense_inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Concatenates a list of `SparseTensor` along the specified dimension.
//
// Concatenation is with respect to the dense versions of these sparse tensors.
// It is assumed that each input is a `SparseTensor` whose elements are ordered
// along increasing dimension number.
//
// All inputs' shapes must match, except for the concat dimension.  The
// `indices`, `values`, and `shapes` lists must have the same length.
//
// The output shape is identical to the inputs', except along the concat
// dimension, where it is the sum of the inputs' sizes along that dimension.
//
// The output elements will be resorted to preserve the sort order along
// increasing dimension number.
//
// This op runs in `O(M log M)` time, where `M` is the total number of non-empty
// values across all inputs. This is due to the need for an internal sort in
// order to concatenate efficiently across an arbitrary dimension.
//
// For example, if `concat_dim = 1` and the inputs are
//
//     sp_inputs[0]: shape = [2, 3]
//     [0, 2]: "a"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
//     sp_inputs[1]: shape = [2, 4]
//     [0, 1]: "d"
//     [0, 2]: "e"
//
// then the output will be
//
//     shape = [2, 7]
//     [0, 2]: "a"
//     [0, 4]: "d"
//     [0, 5]: "e"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
// Graphically this is equivalent to doing
//
//     [    a] concat [  d e  ] = [    a   d e  ]
//     [b c  ]        [       ]   [b c          ]
//
// Arguments:
//	indices: 2-D.  Indices of each input `SparseTensor`.
//	values: 1-D.  Non-empty values of each `SparseTensor`.
//	shapes: 1-D.  Shapes of each `SparseTensor`.
//	concat_dim: Dimension to concatenate along. Must be in range [-rank, rank),
// where rank is the number of dimensions in each input `SparseTensor`.
//
// Returns:
//	output_indices: 2-D.  Indices of the concatenated `SparseTensor`.
//	output_values: 1-D.  Non-empty values of the concatenated `SparseTensor`.
//	output_shape: 1-D.  Shape of the concatenated `SparseTensor`.
func SparseConcat(scope *Scope, indices []tf.Output, values []tf.Output, shapes []tf.Output, concat_dim int64) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"concat_dim": concat_dim}
	opspec := tf.OpSpec{
		Type: "SparseConcat",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(values), tf.OutputList(shapes),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// SerializeManySparseAttr is an optional argument to SerializeManySparse.
type SerializeManySparseAttr func(optionalAttr)

// SerializeManySparseOutType sets the optional out_type attribute to value.
//
// value: The `dtype` to use for serialization; the supported types are `string`
// (default) and `variant`.
// If not specified, defaults to DT_STRING
func SerializeManySparseOutType(value tf.DataType) SerializeManySparseAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Serialize an `N`-minibatch `SparseTensor` into an `[N, 3]` `Tensor` object.
//
// The `SparseTensor` must have rank `R` greater than 1, and the first dimension
// is treated as the minibatch dimension.  Elements of the `SparseTensor`
// must be sorted in increasing order of this first dimension.  The serialized
// `SparseTensor` objects going into each row of `serialized_sparse` will have
// rank `R-1`.
//
// The minibatch size `N` is extracted from `sparse_shape[0]`.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the minibatch `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the minibatch `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the minibatch `SparseTensor`.
func SerializeManySparse(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...SerializeManySparseAttr) (serialized_sparse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SerializeManySparse",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SerializeSparseAttr is an optional argument to SerializeSparse.
type SerializeSparseAttr func(optionalAttr)

// SerializeSparseOutType sets the optional out_type attribute to value.
//
// value: The `dtype` to use for serialization; the supported types are `string`
// (default) and `variant`.
// If not specified, defaults to DT_STRING
func SerializeSparseOutType(value tf.DataType) SerializeSparseAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Serialize a `SparseTensor` into a `[3]` `Tensor` object.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the `SparseTensor`.
func SerializeSparse(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...SerializeSparseAttr) (serialized_sparse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SerializeSparse",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// The gradient operator for the SparseAdd op.
//
// The SparseAdd op calculates A + B, where A, B, and the sum are all represented
// as `SparseTensor` objects.  This op takes in the upstream gradient w.r.t.
// non-empty values of the sum, and outputs the gradients w.r.t. the non-empty
// values of A and B.
//
// Arguments:
//	backprop_val_grad: 1-D with shape `[nnz(sum)]`.  The gradient with respect to
// the non-empty values of the sum.
//	a_indices: 2-D.  The `indices` of the `SparseTensor` A, size `[nnz(A), ndims]`.
//	b_indices: 2-D.  The `indices` of the `SparseTensor` B, size `[nnz(B), ndims]`.
//	sum_indices: 2-D.  The `indices` of the sum `SparseTensor`, size
// `[nnz(sum), ndims]`.
//
// Returns:
//	a_val_grad: 1-D with shape `[nnz(A)]`. The gradient with respect to the
// non-empty values of A.
//	b_val_grad: 1-D with shape `[nnz(B)]`. The gradient with respect to the
// non-empty values of B.
func SparseAddGrad(scope *Scope, backprop_val_grad tf.Output, a_indices tf.Output, b_indices tf.Output, sum_indices tf.Output) (a_val_grad tf.Output, b_val_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseAddGrad",
		Input: []tf.Input{
			backprop_val_grad, a_indices, b_indices, sum_indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes the sparse Cholesky decomposition of `input`.
//
// Computes the Sparse Cholesky decomposition of a sparse matrix, with the given
// fill-in reducing permutation.
//
// The input sparse matrix and the fill-in reducing permutation `permutation` must
// have compatible shapes. If the sparse matrix has rank 3; with the batch
// dimension `B`, then the `permutation` must be of rank 2; with the same batch
// dimension `B`. There is no support for broadcasting.
//
// Furthermore, each component vector of `permutation` must be of length `N`,
// containing each of the integers {0, 1, ..., N - 1} exactly once, where `N` is
// the number of rows of each component of the sparse matrix.
//
// Each component of the input sparse matrix must represent a symmetric positive
// definite (SPD) matrix; although only the lower triangular part of the matrix is
// read. If any individual component is not SPD, then an InvalidArgument error is
// thrown.
//
// The returned sparse matrix has the same dense shape as the input sparse matrix.
// For each component `A` of the input sparse matrix, the corresponding output
// sparse matrix represents `L`, the lower triangular Cholesky factor satisfying
// the following identity:
//
// ```
//   A = L * Lt
// ```
//
// where Lt denotes the transpose of L (or its conjugate transpose, if `type` is
// `complex64` or `complex128`).
//
// The `type` parameter denotes the type of the matrix elements. The supported
// types are: `float32`, `float64`, `complex64` and `complex128`.
//
// Usage example:
//
// ```python
//     from tensorflow.python.ops.linalg.sparse import sparse_csr_matrix_ops
//
//     a_indices = np.array([[0, 0], [1, 1], [2, 1], [2, 2], [3, 3]])
//     a_values = np.array([1.0, 2.0, 1.0, 3.0, 4.0], np.float32)
//     a_dense_shape = [4, 4]
//
//     with tf.Session() as sess:
//       # Define (COO format) SparseTensor over Numpy array.
//       a_st = tf.sparse.SparseTensor(a_indices, a_values, a_dense_shape)
//
//       # Convert SparseTensors to CSR SparseMatrix.
//       a_sm = sparse_csr_matrix_ops.sparse_tensor_to_csr_sparse_matrix(
//           a_st.indices, a_st.values, a_st.dense_shape)
//
//       # Obtain the Sparse Cholesky factor using AMD Ordering for reducing zero
//       # fill-in (number of structural non-zeros in the sparse Cholesky factor).
//       ordering_amd = sparse_csr_matrix_ops.sparse_matrix_ordering_amd(sparse_matrix)
//       cholesky_sparse_matrices = (
//           sparse_csr_matrix_ops.sparse_matrix_sparse_cholesky(
//               sparse_matrix, ordering_amd, type=tf.float32))
//
//       # Convert the CSRSparseMatrix Cholesky factor to a dense Tensor
//       dense_cholesky = sparse_csr_matrix_ops.csr_sparse_matrix_to_dense(
//           cholesky_sparse_matrices, tf.float32)
//
//       # Evaluate the dense Tensor value.
//       dense_cholesky_value = sess.run(dense_cholesky)
// ```
//
// `dense_cholesky_value` stores the dense Cholesky factor:
//
// ```
//     [[  1.  0.    0.    0.]
//      [  0.  1.41  0.    0.]
//      [  0.  0.70  1.58  0.]
//      [  0.  0.    0.    2.]]
// ```
//
//
// input: A `CSRSparseMatrix`.
// permutation: A `Tensor`.
// type: The type of `input`.
//
// Arguments:
//	input: A `CSRSparseMatrix`.
//	permutation: A fill-in reducing permutation matrix.
//
//
// Returns The sparse Cholesky decompsition of `input`.
func SparseMatrixSparseCholesky(scope *Scope, input tf.Output, permutation tf.Output, type_ tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "SparseMatrixSparseCholesky",
		Input: []tf.Input{
			input, permutation,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseMatrixTransposeAttr is an optional argument to SparseMatrixTranspose.
type SparseMatrixTransposeAttr func(optionalAttr)

// SparseMatrixTransposeConjugate sets the optional conjugate attribute to value.
//
// value: Indicates whether `input` should be conjugated.
// If not specified, defaults to false
func SparseMatrixTransposeConjugate(value bool) SparseMatrixTransposeAttr {
	return func(m optionalAttr) {
		m["conjugate"] = value
	}
}

// Transposes the inner (matrix) dimensions of a CSRSparseMatrix.
//
// Transposes the inner (matrix) dimensions of a SparseMatrix and optionally
// conjugates its values.
//
// Arguments:
//	input: A CSRSparseMatrix.
//
//
// Returns A CSRSparseMatrix.
func SparseMatrixTranspose(scope *Scope, input tf.Output, type_ tf.DataType, optional ...SparseMatrixTransposeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseMatrixTranspose",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Slice a `SparseTensor` based on the `start` and `size`.
//
// For example, if the input is
//
//     input_tensor = shape = [2, 7]
//     [    a   d e  ]
//     [b c          ]
//
// Graphically the output tensors are:
//
//     sparse_slice([0, 0], [2, 4]) = shape = [2, 4]
//     [    a  ]
//     [b c    ]
//
//     sparse_slice([0, 4], [2, 3]) = shape = [2, 3]
//     [ d e  ]
//     [      ]
//
// Arguments:
//	indices: 2-D tensor represents the indices of the sparse tensor.
//	values: 1-D tensor represents the values of the sparse tensor.
//	shape: 1-D. tensor represents the shape of the sparse tensor.
//	start: 1-D. tensor represents the start of the slice.
//	size: 1-D. tensor represents the size of the slice.
// output indices: A list of 1-D tensors represents the indices of the output
// sparse tensors.
//
// Returns:
//	output_indices
//	output_values: A list of 1-D tensors represents the values of the output sparse
// tensors.
//	output_shape: A list of 1-D tensors represents the shape of the output sparse
// tensors.
func SparseSlice(scope *Scope, indices tf.Output, values tf.Output, shape tf.Output, start tf.Output, size tf.Output) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSlice",
		Input: []tf.Input{
			indices, values, shape, start, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// SparseMatrixSparseMatMulAttr is an optional argument to SparseMatrixSparseMatMul.
type SparseMatrixSparseMatMulAttr func(optionalAttr)

// SparseMatrixSparseMatMulTransposeA sets the optional transpose_a attribute to value.
//
// value: Indicates whether `a` should be transposed.
// If not specified, defaults to false
func SparseMatrixSparseMatMulTransposeA(value bool) SparseMatrixSparseMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// SparseMatrixSparseMatMulTransposeB sets the optional transpose_b attribute to value.
//
// value: Indicates whether `b` should be transposed.
// If not specified, defaults to false
func SparseMatrixSparseMatMulTransposeB(value bool) SparseMatrixSparseMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// SparseMatrixSparseMatMulAdjointA sets the optional adjoint_a attribute to value.
//
// value: Indicates whether `a` should be conjugate-transposed.
// If not specified, defaults to false
func SparseMatrixSparseMatMulAdjointA(value bool) SparseMatrixSparseMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_a"] = value
	}
}

// SparseMatrixSparseMatMulAdjointB sets the optional adjoint_b attribute to value.
//
// value: Indicates whether `b` should be conjugate-transposed.
// If not specified, defaults to false
func SparseMatrixSparseMatMulAdjointB(value bool) SparseMatrixSparseMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_b"] = value
	}
}

// Sparse-matrix-multiplies two CSR matrices `a` and `b`.
//
// Performs a matrix multiplication of a sparse matrix `a` with a sparse matrix
// `b`; returns a sparse matrix `a * b`, unless either `a` or `b` is transposed or
// adjointed.
//
// Each matrix may be transposed or adjointed (conjugated and transposed)
// according to the Boolean parameters `transpose_a`, `adjoint_a`, `transpose_b`
// and `adjoint_b`. At most one of `transpose_a` or `adjoint_a` may be True.
// Similarly, at most one of `transpose_b` or `adjoint_b` may be True.
//
// The inputs must have compatible shapes. That is, the inner dimension of `a`
// must be equal to the outer dimension of `b`. This requirement is adjusted
// according to whether either `a` or `b` is transposed or adjointed.
//
// The `type` parameter denotes the type of the matrix elements. Both `a` and `b`
// must have the same type. The supported types are: `float32`, `float64`,
// `complex64` and `complex128`.
//
// Both `a` and `b` must have the same rank. Broadcasting is not supported. If they
// have rank 3, each batch of 2D CSRSparseMatrices within `a` and `b` must have the
// same dense shape.
//
// The sparse matrix product may have numeric (non-structural) zeros.
// TODO(anudhyan): Consider adding a boolean attribute to control whether to prune
// zeros.
//
// Usage example:
//
// ```python
//     from tensorflow.python.ops.linalg.sparse import sparse_csr_matrix_ops
//
//     a_indices = np.array([[0, 0], [2, 3], [2, 4], [3, 0]])
//     a_values = np.array([1.0, 5.0, -1.0, -2.0], np.float32)
//     a_dense_shape = [4, 5]
//
//     b_indices = np.array([[0, 0], [3, 0], [3, 1]])
//     b_values = np.array([2.0, 7.0, 8.0], np.float32)
//     b_dense_shape = [5, 3]
//
//     with tf.Session() as sess:
//       # Define (COO format) Sparse Tensors over Numpy arrays
//       a_st = tf.sparse.SparseTensor(a_indices, a_values, a_dense_shape)
//       b_st = tf.sparse.SparseTensor(b_indices, b_values, b_dense_shape)
//
//       # Convert SparseTensors to CSR SparseMatrix
//       a_sm = sparse_csr_matrix_ops.sparse_tensor_to_csr_sparse_matrix(
//           a_st.indices, a_st.values, a_st.dense_shape)
//       b_sm = sparse_csr_matrix_ops.sparse_tensor_to_csr_sparse_matrix(
//           b_st.indices, b_st.values, b_st.dense_shape)
//
//       # Compute the CSR SparseMatrix matrix multiplication
//       c_sm = sparse_csr_matrix_ops.sparse_matrix_sparse_mat_mul(
//           a=a_sm, b=b_sm, type=tf.float32)
//
//       # Convert the CSR SparseMatrix product to a dense Tensor
//       c_sm_dense = sparse_csr_matrix_ops.csr_sparse_matrix_to_dense(
//           c_sm, tf.float32)
//       # Evaluate the dense Tensor value
//       c_sm_dense_value = sess.run(c_sm_dense)
// ```
//
// `c_sm_dense_value` stores the dense matrix product:
//
// ```
//     [[  2.   0.   0.]
//      [  0.   0.   0.]
//      [ 35.  40.   0.]
//      [ -4.   0.   0.]]
// ```
//
// a: A `CSRSparseMatrix`.
// b: A `CSRSparseMatrix` with the same type and rank as `a`.
// type: The type of both `a` and `b`.
// transpose_a: If True, `a` transposed before multiplication.
// transpose_b: If True, `b` transposed before multiplication.
// adjoint_a: If True, `a` adjointed before multiplication.
// adjoint_b: If True, `b` adjointed before multiplication.
//
// Arguments:
//	a: A CSRSparseMatrix.
//	b: A CSRSparseMatrix.
//
//
// Returns A CSRSparseMatrix.
func SparseMatrixSparseMatMul(scope *Scope, a tf.Output, b tf.Output, type_ tf.DataType, optional ...SparseMatrixSparseMatMulAttr) (c tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseMatrixSparseMatMul",
		Input: []tf.Input{
			a, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Element-wise multiplication of a sparse matrix with a dense tensor.
//
// Returns a sparse matrix.
//
// The dense tensor `b` may be either a scalar; otherwise `a` must be a rank-3
// `SparseMatrix`; in this case `b` must be shaped `[batch_size, 1, 1]` and the
// multiply operation broadcasts.
//
// **NOTE** even if `b` is zero, the sparsity structure of the output does not
// change.
//
// Arguments:
//	a: A CSRSparseMatrix.
//	b: A dense tensor.
//
// Returns A dense output tensor.
func SparseMatrixMul(scope *Scope, a tf.Output, b tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseMatrixMul",
		Input: []tf.Input{
			a, b,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseMatrixMatMulAttr is an optional argument to SparseMatrixMatMul.
type SparseMatrixMatMulAttr func(optionalAttr)

// SparseMatrixMatMulTransposeA sets the optional transpose_a attribute to value.
//
// value: Indicates whether `a` should be transposed.
// If not specified, defaults to false
func SparseMatrixMatMulTransposeA(value bool) SparseMatrixMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// SparseMatrixMatMulTransposeB sets the optional transpose_b attribute to value.
//
// value: Indicates whether `b` should be transposed.
// If not specified, defaults to false
func SparseMatrixMatMulTransposeB(value bool) SparseMatrixMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// SparseMatrixMatMulAdjointA sets the optional adjoint_a attribute to value.
//
// value: Indicates whether `a` should be conjugate-transposed.
// If not specified, defaults to false
func SparseMatrixMatMulAdjointA(value bool) SparseMatrixMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_a"] = value
	}
}

// SparseMatrixMatMulAdjointB sets the optional adjoint_b attribute to value.
//
// value: Indicates whether `b` should be conjugate-transposed.
// If not specified, defaults to false
func SparseMatrixMatMulAdjointB(value bool) SparseMatrixMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_b"] = value
	}
}

// SparseMatrixMatMulTransposeOutput sets the optional transpose_output attribute to value.
//
// value: Transposes the product of `a` and `b`.
// If not specified, defaults to false
func SparseMatrixMatMulTransposeOutput(value bool) SparseMatrixMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_output"] = value
	}
}

// SparseMatrixMatMulConjugateOutput sets the optional conjugate_output attribute to value.
//
// value: Conjugates the product of `a` and `b`.
// If not specified, defaults to false
func SparseMatrixMatMulConjugateOutput(value bool) SparseMatrixMatMulAttr {
	return func(m optionalAttr) {
		m["conjugate_output"] = value
	}
}

// Matrix-multiplies a sparse matrix with a dense matrix.
//
// Returns a dense matrix.
// For inputs A and B, where A is CSR and B is dense; this op returns a dense C;
//
// If transpose_output is false, returns:
// ```
//   C = A . B
// ```
//
// If transpose_output is `true`, returns:
// ```
//   C = transpose(A . B) = transpose(B) . transpose(A)
// ```
// where the transposition is performed along the two innermost (matrix)
// dimensions.
//
// If conjugate_output is `true`, returns:
// ```
//   C = conjugate(A . B) = conjugate(A) . conjugate(B)
// ```
//
// If both conjugate_output and transpose_output are `true`, returns:
// ```
//   C = conjugate(transpose(A . B)) = conjugate(transpose(B)) .
//                                     conjugate(transpose(A))
// ```
//
// Arguments:
//	a: A CSRSparseMatrix.
//	b: A dense tensor.
//
// Returns A dense output tensor.
func SparseMatrixMatMul(scope *Scope, a tf.Output, b tf.Output, optional ...SparseMatrixMatMulAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseMatrixMatMul",
		Input: []tf.Input{
			a, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reads out the CSR components at batch `index`.
//
// This op is meant only for debugging / testing, and its interface is not expected
// to be stable.
//
// Arguments:
//	csr_sparse_matrix: A batched CSRSparseMatrix.
//	index: The index in `csr_sparse_matrix`'s batch.
//
//
// Returns:
//	row_ptrs: An array containing CSR matrix row pointers.
//	col_inds: An array containing CSR matrix column indices.
//	values: An array containing CSR matrix nonzero values.
func CSRSparseMatrixComponents(scope *Scope, csr_sparse_matrix tf.Output, index tf.Output, type_ tf.DataType) (row_ptrs tf.Output, col_inds tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "CSRSparseMatrixComponents",
		Input: []tf.Input{
			csr_sparse_matrix, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Convert a (possibly batched) CSRSparseMatrix to dense.
//
// Arguments:
//	sparse_input: A batched CSRSparseMatrix.
//
//
// Returns A dense tensor.
func CSRSparseMatrixToDense(scope *Scope, sparse_input tf.Output, type_ tf.DataType) (dense_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "CSRSparseMatrixToDense",
		Input: []tf.Input{
			sparse_input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts a SparseTensor to a (possibly batched) CSRSparseMatrix.
//
// Arguments:
//	indices: SparseTensor indices.
//	values: SparseTensor values.
//	dense_shape: SparseTensor dense shape.
//
// Returns A (possibly batched) CSRSparseMatrix.
func SparseTensorToCSRSparseMatrix(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output) (sparse_matrix tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseTensorToCSRSparseMatrix",
		Input: []tf.Input{
			indices, values, dense_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseToSparseSetOperationAttr is an optional argument to SparseToSparseSetOperation.
type SparseToSparseSetOperationAttr func(optionalAttr)

// SparseToSparseSetOperationValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func SparseToSparseSetOperationValidateIndices(value bool) SparseToSparseSetOperationAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Applies set operation along last dimension of 2 `SparseTensor` inputs.
//
// See SetOperationOp::SetOperationFromContext for values of `set_operation`.
//
// If `validate_indices` is `True`, `SparseToSparseSetOperation` validates the
// order and range of `set1` and `set2` indices.
//
// Input `set1` is a `SparseTensor` represented by `set1_indices`, `set1_values`,
// and `set1_shape`. For `set1` ranked `n`, 1st `n-1` dimensions must be the same
// as `set2`. Dimension `n` contains values in a set, duplicates are allowed but
// ignored.
//
// Input `set2` is a `SparseTensor` represented by `set2_indices`, `set2_values`,
// and `set2_shape`. For `set2` ranked `n`, 1st `n-1` dimensions must be the same
// as `set1`. Dimension `n` contains values in a set, duplicates are allowed but
// ignored.
//
// If `validate_indices` is `True`, this op validates the order and range of `set1`
// and `set2` indices.
//
// Output `result` is a `SparseTensor` represented by `result_indices`,
// `result_values`, and `result_shape`. For `set1` and `set2` ranked `n`, this
// has rank `n` and the same 1st `n-1` dimensions as `set1` and `set2`. The `nth`
// dimension contains the result of `set_operation` applied to the corresponding
// `[0...n-1]` dimension of `set`.
//
// Arguments:
//	set1_indices: 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
// order.
//	set1_values: 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
// order.
//	set1_shape: 1D `Tensor`, shape of a `SparseTensor`. `set1_shape[0...n-1]` must
// be the same as `set2_shape[0...n-1]`, `set1_shape[n]` is the
// max set size across `0...n-1` dimensions.
//	set2_indices: 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
// order.
//	set2_values: 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
// order.
//	set2_shape: 1D `Tensor`, shape of a `SparseTensor`. `set2_shape[0...n-1]` must
// be the same as `set1_shape[0...n-1]`, `set2_shape[n]` is the
// max set size across `0...n-1` dimensions.
//
//
// Returns:
//	result_indices: 2D indices of a `SparseTensor`.
//	result_values: 1D values of a `SparseTensor`.
//	result_shape: 1D `Tensor` shape of a `SparseTensor`. `result_shape[0...n-1]` is
// the same as the 1st `n-1` dimensions of `set1` and `set2`, `result_shape[n]`
// is the max result set size across all `0...n-1` dimensions.
func SparseToSparseSetOperation(scope *Scope, set1_indices tf.Output, set1_values tf.Output, set1_shape tf.Output, set2_indices tf.Output, set2_values tf.Output, set2_shape tf.Output, set_operation string, optional ...SparseToSparseSetOperationAttr) (result_indices tf.Output, result_values tf.Output, result_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"set_operation": set_operation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseToSparseSetOperation",
		Input: []tf.Input{
			set1_indices, set1_values, set1_shape, set2_indices, set2_values, set2_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DenseToDenseSetOperationAttr is an optional argument to DenseToDenseSetOperation.
type DenseToDenseSetOperationAttr func(optionalAttr)

// DenseToDenseSetOperationValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func DenseToDenseSetOperationValidateIndices(value bool) DenseToDenseSetOperationAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Applies set operation along last dimension of 2 `Tensor` inputs.
//
// See SetOperationOp::SetOperationFromContext for values of `set_operation`.
//
// Output `result` is a `SparseTensor` represented by `result_indices`,
// `result_values`, and `result_shape`. For `set1` and `set2` ranked `n`, this
// has rank `n` and the same 1st `n-1` dimensions as `set1` and `set2`. The `nth`
// dimension contains the result of `set_operation` applied to the corresponding
// `[0...n-1]` dimension of `set`.
//
// Arguments:
//	set1: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//	set2: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set1`.
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//
//
// Returns:
//	result_indices: 2D indices of a `SparseTensor`.
//	result_values: 1D values of a `SparseTensor`.
//	result_shape: 1D `Tensor` shape of a `SparseTensor`. `result_shape[0...n-1]` is
// the same as the 1st `n-1` dimensions of `set1` and `set2`, `result_shape[n]`
// is the max result set size across all `0...n-1` dimensions.
func DenseToDenseSetOperation(scope *Scope, set1 tf.Output, set2 tf.Output, set_operation string, optional ...DenseToDenseSetOperationAttr) (result_indices tf.Output, result_values tf.Output, result_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"set_operation": set_operation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseToDenseSetOperation",
		Input: []tf.Input{
			set1, set2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RecvAttr is an optional argument to Recv.
type RecvAttr func(optionalAttr)

// RecvClientTerminated sets the optional client_terminated attribute to value.
//
// value: If set to true, this indicates that the node was added
// to the graph as a result of a client-side feed or fetch of Tensor data,
// in which case the corresponding send or recv is expected to be managed
// locally by the caller.
// If not specified, defaults to false
func RecvClientTerminated(value bool) RecvAttr {
	return func(m optionalAttr) {
		m["client_terminated"] = value
	}
}

// Receives the named tensor from send_device on recv_device.
//
// Arguments:
//
//	tensor_name: The name of the tensor to receive.
//	send_device: The name of the device sending the tensor.
//	send_device_incarnation: The current incarnation of send_device.
//	recv_device: The name of the device receiving the tensor.
//
// Returns The tensor to receive.
func Recv(scope *Scope, tensor_type tf.DataType, tensor_name string, send_device string, send_device_incarnation int64, recv_device string, optional ...RecvAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"tensor_type": tensor_type, "tensor_name": tensor_name, "send_device": send_device, "send_device_incarnation": send_device_incarnation, "recv_device": recv_device}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Recv",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes fingerprints of the input strings.
//
// Arguments:
//	input: vector of strings to compute fingerprints on.
//
// Returns a (N,2) shaped matrix where N is the number of elements in the input
// vector. Each row contains the low and high parts of the fingerprint.
func SdcaFprint(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SdcaFprint",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SdcaOptimizerV2Attr is an optional argument to SdcaOptimizerV2.
type SdcaOptimizerV2Attr func(optionalAttr)

// SdcaOptimizerV2Adaptive sets the optional adaptive attribute to value.
//
// value: Whether to use Adaptive SDCA for the inner loop.
// If not specified, defaults to true
func SdcaOptimizerV2Adaptive(value bool) SdcaOptimizerV2Attr {
	return func(m optionalAttr) {
		m["adaptive"] = value
	}
}

// Distributed version of Stochastic Dual Coordinate Ascent (SDCA) optimizer for
//
// linear models with L1 + L2 regularization. As global optimization objective is
// strongly-convex, the optimizer optimizes the dual objective at each step. The
// optimizer applies each update one example at a time. Examples are sampled
// uniformly, and the optimizer is learning rate free and enjoys linear convergence
// rate.
//
// [Proximal Stochastic Dual Coordinate Ascent](http://arxiv.org/pdf/1211.2717v1.pdf).<br>
// Shai Shalev-Shwartz, Tong Zhang. 2012
//
// $$Loss Objective = \sum f_{i} (wx_{i}) + (l2 / 2) * |w|^2 + l1 * |w|$$
//
// [Adding vs. Averaging in Distributed Primal-Dual Optimization](http://arxiv.org/abs/1502.03508).<br>
// Chenxin Ma, Virginia Smith, Martin Jaggi, Michael I. Jordan,
// Peter Richtarik, Martin Takac. 2015
//
// [Stochastic Dual Coordinate Ascent with Adaptive Probabilities](https://arxiv.org/abs/1502.08053).<br>
// Dominik Csiba, Zheng Qu, Peter Richtarik. 2015
//
// Arguments:
//	sparse_example_indices: a list of vectors which contain example indices.
//	sparse_feature_indices: a list of vectors which contain feature indices.
//	sparse_feature_values: a list of vectors which contains feature value
// associated with each feature group.
//	dense_features: a list of matrices which contains the dense feature values.
//	example_weights: a vector which contains the weight associated with each
// example.
//	example_labels: a vector which contains the label/target associated with each
// example.
//	sparse_indices: a list of vectors where each value is the indices which has
// corresponding weights in sparse_weights. This field maybe omitted for the
// dense approach.
//	sparse_weights: a list of vectors where each value is the weight associated with
// a sparse feature group.
//	dense_weights: a list of vectors where the values are the weights associated
// with a dense feature group.
//	example_state_data: a list of vectors containing the example state data.
//	loss_type: Type of the primal loss. Currently SdcaSolver supports logistic,
// squared and hinge losses.
//	l1: Symmetric l1 regularization strength.
//	l2: Symmetric l2 regularization strength.
//	num_loss_partitions: Number of partitions of the global loss function.
//	num_inner_iterations: Number of iterations per mini-batch.
//
// Returns:
//	out_example_state_data: a list of vectors containing the updated example state
// data.
//	out_delta_sparse_weights: a list of vectors where each value is the delta
// weights associated with a sparse feature group.
//	out_delta_dense_weights: a list of vectors where the values are the delta
// weights associated with a dense feature group.
func SdcaOptimizerV2(scope *Scope, sparse_example_indices []tf.Output, sparse_feature_indices []tf.Output, sparse_feature_values []tf.Output, dense_features []tf.Output, example_weights tf.Output, example_labels tf.Output, sparse_indices []tf.Output, sparse_weights []tf.Output, dense_weights []tf.Output, example_state_data tf.Output, loss_type string, l1 float32, l2 float32, num_loss_partitions int64, num_inner_iterations int64, optional ...SdcaOptimizerV2Attr) (out_example_state_data tf.Output, out_delta_sparse_weights []tf.Output, out_delta_dense_weights []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"loss_type": loss_type, "l1": l1, "l2": l2, "num_loss_partitions": num_loss_partitions, "num_inner_iterations": num_inner_iterations}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SdcaOptimizerV2",
		Input: []tf.Input{
			tf.OutputList(sparse_example_indices), tf.OutputList(sparse_feature_indices), tf.OutputList(sparse_feature_values), tf.OutputList(dense_features), example_weights, example_labels, tf.OutputList(sparse_indices), tf.OutputList(sparse_weights), tf.OutputList(dense_weights), example_state_data,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	out_example_state_data = op.Output(idx)
	if out_delta_sparse_weights, idx, err = makeOutputList(op, idx, "out_delta_sparse_weights"); err != nil {
		scope.UpdateErr("SdcaOptimizerV2", err)
		return
	}
	if out_delta_dense_weights, idx, err = makeOutputList(op, idx, "out_delta_dense_weights"); err != nil {
		scope.UpdateErr("SdcaOptimizerV2", err)
		return
	}
	return out_example_state_data, out_delta_sparse_weights, out_delta_dense_weights
}

// SdcaOptimizerAttr is an optional argument to SdcaOptimizer.
type SdcaOptimizerAttr func(optionalAttr)

// SdcaOptimizerAdaptative sets the optional adaptative attribute to value.
//
// value: Whether to use Adaptive SDCA for the inner loop.
// If not specified, defaults to true
func SdcaOptimizerAdaptative(value bool) SdcaOptimizerAttr {
	return func(m optionalAttr) {
		m["adaptative"] = value
	}
}

// Distributed version of Stochastic Dual Coordinate Ascent (SDCA) optimizer for
//
// linear models with L1 + L2 regularization. As global optimization objective is
// strongly-convex, the optimizer optimizes the dual objective at each step. The
// optimizer applies each update one example at a time. Examples are sampled
// uniformly, and the optimizer is learning rate free and enjoys linear convergence
// rate.
//
// [Proximal Stochastic Dual Coordinate Ascent](http://arxiv.org/pdf/1211.2717v1.pdf).<br>
// Shai Shalev-Shwartz, Tong Zhang. 2012
//
// $$Loss Objective = \sum f_{i} (wx_{i}) + (l2 / 2) * |w|^2 + l1 * |w|$$
//
// [Adding vs. Averaging in Distributed Primal-Dual Optimization](http://arxiv.org/abs/1502.03508).<br>
// Chenxin Ma, Virginia Smith, Martin Jaggi, Michael I. Jordan,
// Peter Richtarik, Martin Takac. 2015
//
// [Stochastic Dual Coordinate Ascent with Adaptive Probabilities](https://arxiv.org/abs/1502.08053).<br>
// Dominik Csiba, Zheng Qu, Peter Richtarik. 2015
//
// Arguments:
//	sparse_example_indices: a list of vectors which contain example indices.
//	sparse_feature_indices: a list of vectors which contain feature indices.
//	sparse_feature_values: a list of vectors which contains feature value
// associated with each feature group.
//	dense_features: a list of matrices which contains the dense feature values.
//	example_weights: a vector which contains the weight associated with each
// example.
//	example_labels: a vector which contains the label/target associated with each
// example.
//	sparse_indices: a list of vectors where each value is the indices which has
// corresponding weights in sparse_weights. This field maybe omitted for the
// dense approach.
//	sparse_weights: a list of vectors where each value is the weight associated with
// a sparse feature group.
//	dense_weights: a list of vectors where the values are the weights associated
// with a dense feature group.
//	example_state_data: a list of vectors containing the example state data.
//	loss_type: Type of the primal loss. Currently SdcaSolver supports logistic,
// squared and hinge losses.
//	l1: Symmetric l1 regularization strength.
//	l2: Symmetric l2 regularization strength.
//	num_loss_partitions: Number of partitions of the global loss function.
//	num_inner_iterations: Number of iterations per mini-batch.
//
// Returns:
//	out_example_state_data: a list of vectors containing the updated example state
// data.
//	out_delta_sparse_weights: a list of vectors where each value is the delta
// weights associated with a sparse feature group.
//	out_delta_dense_weights: a list of vectors where the values are the delta
// weights associated with a dense feature group.
func SdcaOptimizer(scope *Scope, sparse_example_indices []tf.Output, sparse_feature_indices []tf.Output, sparse_feature_values []tf.Output, dense_features []tf.Output, example_weights tf.Output, example_labels tf.Output, sparse_indices []tf.Output, sparse_weights []tf.Output, dense_weights []tf.Output, example_state_data tf.Output, loss_type string, l1 float32, l2 float32, num_loss_partitions int64, num_inner_iterations int64, optional ...SdcaOptimizerAttr) (out_example_state_data tf.Output, out_delta_sparse_weights []tf.Output, out_delta_dense_weights []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"loss_type": loss_type, "l1": l1, "l2": l2, "num_loss_partitions": num_loss_partitions, "num_inner_iterations": num_inner_iterations}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SdcaOptimizer",
		Input: []tf.Input{
			tf.OutputList(sparse_example_indices), tf.OutputList(sparse_feature_indices), tf.OutputList(sparse_feature_values), tf.OutputList(dense_features), example_weights, example_labels, tf.OutputList(sparse_indices), tf.OutputList(sparse_weights), tf.OutputList(dense_weights), example_state_data,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	out_example_state_data = op.Output(idx)
	if out_delta_sparse_weights, idx, err = makeOutputList(op, idx, "out_delta_sparse_weights"); err != nil {
		scope.UpdateErr("SdcaOptimizer", err)
		return
	}
	if out_delta_dense_weights, idx, err = makeOutputList(op, idx, "out_delta_dense_weights"); err != nil {
		scope.UpdateErr("SdcaOptimizer", err)
		return
	}
	return out_example_state_data, out_delta_sparse_weights, out_delta_dense_weights
}

// This op consumes a lock created by `MutexLock`.
//
// This op exists to consume a tensor created by `MutexLock` (other than
// direct control dependencies).  It should be the only that consumes the tensor,
// and will raise an error if it is not.  Its only purpose is to keep the
// mutex lock tensor alive until it is consumed by this op.
//
// **NOTE**: This operation must run on the same device as its input.  This may
// be enforced via the `colocate_with` mechanism.
//
// Arguments:
//	mutex_lock: A tensor returned by `MutexLock`.
//
// Returns the created operation.
func ConsumeMutexLock(scope *Scope, mutex_lock tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConsumeMutexLock",
		Input: []tf.Input{
			mutex_lock,
		},
	}
	return scope.AddOperation(opspec)
}

// MutexV2Attr is an optional argument to MutexV2.
type MutexV2Attr func(optionalAttr)

// MutexV2Container sets the optional container attribute to value.
//
// value: If non-empty, this variable is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutexV2Container(value string) MutexV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutexV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this variable is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func MutexV2SharedName(value string) MutexV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a Mutex resource that can be locked by `MutexLock`.
//
// Returns The mutex resource.
func MutexV2(scope *Scope, optional ...MutexV2Attr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutexV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Assigns sparse updates to the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = updates[i, ..., j, ...]
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterUpdate(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterUpdate",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Reduces sparse updates into the variable referenced by `resource` using the `min` operation.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = min(ref[indices, ...], updates[...])
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = min(ref[indices[i], ...], updates[i, ...])
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = min(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions are combined.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterMin(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterMin",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Subtracts sparse updates from the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] -= updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] -= updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] -= updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions add.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterSub(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterSub",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebug.
type RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugConfig(value string) RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve frequency estimator embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the frequency estimator optimization algorithm.
//	last_hit_step: Parameter last_hit_step updated by the frequency estimator optimization
// algorithm.
//	gradient_accumulators: Parameter gradient_accumulators updated by the frequency estimator optimization
// algorithm.
func RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebugAttr) (parameters tf.Output, last_hit_step tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingFrequencyEstimatorParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Adds sparse updates to the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] += updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] += updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] += updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions add.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterAdd(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterAdd",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// VariableShapeAttr is an optional argument to VariableShape.
type VariableShapeAttr func(optionalAttr)

// VariableShapeOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func VariableShapeOutType(value tf.DataType) VariableShapeAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Returns the shape of the variable pointed to by `resource`.
//
// This operation returns a 1-D integer tensor representing the shape of `input`.
//
// For example:
//
// ```
// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
// shape(t) ==> [2, 2, 3]
// ```
func VariableShape(scope *Scope, input tf.Output, optional ...VariableShapeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "VariableShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Advance the counter of a counter-based RNG.
//
// The state of the RNG after
// `rng_read_and_skip(n)` will be the same as that after `uniform([n])`
// (or any other distribution). The actual increment added to the
// counter is an unspecified implementation choice.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	alg: The RNG algorithm.
//	delta: The amount of advancement.
//
// Returns The old value of the resource variable, before incrementing. Since state size is algorithm-dependent, this output will be right-padded with zeros to reach shape int64[3] (the current maximal state size among algorithms).
func RngReadAndSkip(scope *Scope, resource tf.Output, alg tf.Output, delta tf.Output) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RngReadAndSkip",
		Input: []tf.Input{
			resource, alg, delta,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Advance the counter of a counter-based RNG.
//
// The state of the RNG after
// `rng_skip(n)` will be the same as that after `stateful_uniform([n])`
// (or any other distribution). The actual increment added to the
// counter is an unspecified implementation detail.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	delta: The amount of advancement.
//
// Returns the created operation.
func RngSkip(scope *Scope, resource tf.Output, algorithm tf.Output, delta tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RngSkip",
		Input: []tf.Input{
			resource, algorithm, delta,
		},
	}
	return scope.AddOperation(opspec)
}

// StatefulTruncatedNormalAttr is an optional argument to StatefulTruncatedNormal.
type StatefulTruncatedNormalAttr func(optionalAttr)

// StatefulTruncatedNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulTruncatedNormalDtype(value tf.DataType) StatefulTruncatedNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a truncated normal distribution.
//
// The generated values follow a normal distribution with mean 0 and standard
// deviation 1, except that values whose magnitude is more than 2 standard
// deviations from the mean are dropped and re-picked.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//
// Returns Random values with specified shape.
func StatefulTruncatedNormal(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, optional ...StatefulTruncatedNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulTruncatedNormal",
		Input: []tf.Input{
			resource, algorithm, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulStandardNormalV2Attr is an optional argument to StatefulStandardNormalV2.
type StatefulStandardNormalV2Attr func(optionalAttr)

// StatefulStandardNormalV2Dtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulStandardNormalV2Dtype(value tf.DataType) StatefulStandardNormalV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//
// Returns A tensor of the specified shape filled with random normal values.
func StatefulStandardNormalV2(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, optional ...StatefulStandardNormalV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulStandardNormalV2",
		Input: []tf.Input{
			resource, algorithm, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulUniformFullIntAttr is an optional argument to StatefulUniformFullInt.
type StatefulUniformFullIntAttr func(optionalAttr)

// StatefulUniformFullIntDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_UINT64
func StatefulUniformFullIntDtype(value tf.DataType) StatefulUniformFullIntAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random integers from a uniform distribution.
//
// The generated values are uniform integers covering the whole range of `dtype`.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//
// Returns Random values with specified shape.
func StatefulUniformFullInt(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, optional ...StatefulUniformFullIntAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulUniformFullInt",
		Input: []tf.Input{
			resource, algorithm, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the LSTM cell backward propagation for the entire time sequence.
//
// This implementation is to be used in conjunction of BlockLSTMV2.
//
// Arguments:
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
// with zeros beyond this length.
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether to use peephole weights.
//
// Returns:
//	x_grad: The gradient of x to be back-propped.
//	cs_prev_grad: The gradient of cs_prev to be back-propped.
//	h_prev_grad: The gradient of h_prev to be back-propped.
//	w_grad: The gradient for w to be back-propped.
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
//	b_grad: The gradient for w to be back-propped.
func BlockLSTMGradV2(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (x_grad tf.Output, cs_prev_grad tf.Output, h_prev_grad tf.Output, w_grad tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output, b_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "BlockLSTMGradV2",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6), op.Output(7)
}

// Computes the LSTM cell backward propagation for the entire time sequence.
//
// This implementation is to be used in conjunction of LSTMBlock.
//
// Arguments:
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
// with zeros beyond this length.
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether to use peephole weights.
//
// Returns:
//	x_grad: The gradient of x to be back-propped.
//	cs_prev_grad: The gradient of cs_prev to be back-propped.
//	h_prev_grad: The gradient of h_prev to be back-propped.
//	w_grad: The gradient for w to be back-propped.
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
//	b_grad: The gradient for w to be back-propped.
func BlockLSTMGrad(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (x_grad tf.Output, cs_prev_grad tf.Output, h_prev_grad tf.Output, w_grad tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output, b_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "BlockLSTMGrad",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6), op.Output(7)
}

// LSTMBlockCellAttr is an optional argument to LSTMBlockCell.
type LSTMBlockCellAttr func(optionalAttr)

// LSTMBlockCellForgetBias sets the optional forget_bias attribute to value.
//
// value: The forget gate bias.
// If not specified, defaults to 1
func LSTMBlockCellForgetBias(value float32) LSTMBlockCellAttr {
	return func(m optionalAttr) {
		m["forget_bias"] = value
	}
}

// LSTMBlockCellCellClip sets the optional cell_clip attribute to value.
//
// value: Value to clip the 'cs' value to.
// If not specified, defaults to 3
func LSTMBlockCellCellClip(value float32) LSTMBlockCellAttr {
	return func(m optionalAttr) {
		m["cell_clip"] = value
	}
}

// LSTMBlockCellUsePeephole sets the optional use_peephole attribute to value.
//
// value: Whether to use peephole weights.
// If not specified, defaults to false
func LSTMBlockCellUsePeephole(value bool) LSTMBlockCellAttr {
	return func(m optionalAttr) {
		m["use_peephole"] = value
	}
}

// Computes the LSTM cell forward propagation for 1 time step.
//
// This implementation uses 1 weight matrix and 1 bias vector, and there's an
// optional peephole connection.
//
// This kernel op implements the following mathematical equations:
//
// ```python
// xh = [x, h_prev]
// [i, f, ci, o] = xh * w + b
// f = f + forget_bias
//
// if not use_peephole:
//   wci = wcf = wco = 0
//
// i = sigmoid(cs_prev * wci + i)
// f = sigmoid(cs_prev * wcf + f)
// ci = tanh(ci)
//
// cs = ci .* i + cs_prev .* f
// cs = clip(cs, cell_clip)
//
// o = sigmoid(cs * wco + o)
// co = tanh(cs)
// h = co .* o
// ```
//
// Arguments:
//	x: The input to the LSTM cell, shape (batch_size, num_inputs).
//	cs_prev: Value of the cell state at previous time step.
//	h_prev: Output of the previous cell at previous time step.
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//
// Returns:
//	i: The input gate.
//	cs: The cell state before the tanh.
//	f: The forget gate.
//	o: The output gate.
//	ci: The cell input.
//	co: The cell after the tanh.
//	h: The output h vector.
func LSTMBlockCell(scope *Scope, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, optional ...LSTMBlockCellAttr) (i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LSTMBlockCell",
		Input: []tf.Input{
			x, cs_prev, h_prev, w, wci, wcf, wco, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// BlockLSTMAttr is an optional argument to BlockLSTM.
type BlockLSTMAttr func(optionalAttr)

// BlockLSTMForgetBias sets the optional forget_bias attribute to value.
//
// value: The forget gate bias.
// If not specified, defaults to 1
func BlockLSTMForgetBias(value float32) BlockLSTMAttr {
	return func(m optionalAttr) {
		m["forget_bias"] = value
	}
}

// BlockLSTMCellClip sets the optional cell_clip attribute to value.
//
// value: Value to clip the 'cs' value to.
// If not specified, defaults to 3
func BlockLSTMCellClip(value float32) BlockLSTMAttr {
	return func(m optionalAttr) {
		m["cell_clip"] = value
	}
}

// BlockLSTMUsePeephole sets the optional use_peephole attribute to value.
//
// value: Whether to use peephole weights.
// If not specified, defaults to false
func BlockLSTMUsePeephole(value bool) BlockLSTMAttr {
	return func(m optionalAttr) {
		m["use_peephole"] = value
	}
}

// Computes the LSTM cell forward propagation for all the time steps.
//
// This is equivalent to applying LSTMBlockCell in a loop, like so:
//
// ```python
// for x1 in unpack(x):
//   i1, cs1, f1, o1, ci1, co1, h1 = LSTMBlock(
//     x1, cs_prev, h_prev, w, wci, wcf, wco, b)
//   cs_prev = cs1
//   h_prev = h1
//   i.append(i1)
//   cs.append(cs1)
//   f.append(f1)
//   o.append(o1)
//   ci.append(ci1)
//   co.append(co1)
//   h.append(h1)
// return pack(i), pack(cs), pack(f), pack(o), pack(ci), pack(ch), pack(h)
// ```
//
// Arguments:
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
// with zeros beyond this length.
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//
// Returns:
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
func BlockLSTM(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, optional ...BlockLSTMAttr) (i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BlockLSTM",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Computes the GRU cell forward propagation for 1 time step.
//
// Args
//     x: Input to the GRU cell.
//     h_prev: State input from the previous GRU cell.
//     w_ru: Weight matrix for the reset and update gate.
//     w_c: Weight matrix for the cell connection gate.
//     b_ru: Bias vector for the reset and update gate.
//     b_c: Bias vector for the cell connection gate.
//
// Returns
//     r: Output of the reset gate.
//     u: Output of the update gate.
//     c: Output of the cell connection gate.
//     h: Current state of the GRU cell.
//
// Note on notation of the variables:
//
// Concatenation of a and b is represented by a_b
// Element-wise dot product of a and b is represented by ab
// Element-wise dot product is represented by \circ
// Matrix multiplication is represented by *
//
// Biases are initialized with :
// `b_ru` - constant_initializer(1.0)
// `b_c` - constant_initializer(0.0)
//
// This kernel op implements the following mathematical equations:
//
// ```
// x_h_prev = [x, h_prev]
//
// [r_bar u_bar] = x_h_prev * w_ru + b_ru
//
// r = sigmoid(r_bar)
// u = sigmoid(u_bar)
//
// h_prevr = h_prev \circ r
//
// x_h_prevr = [x h_prevr]
//
// c_bar = x_h_prevr * w_c + b_c
// c = tanh(c_bar)
//
// h = (1-u) \circ c + u \circ h_prev
// ```
func GRUBlockCell(scope *Scope, x tf.Output, h_prev tf.Output, w_ru tf.Output, w_c tf.Output, b_ru tf.Output, b_c tf.Output) (r tf.Output, u tf.Output, c tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GRUBlockCell",
		Input: []tf.Input{
			x, h_prev, w_ru, w_c, b_ru, b_c,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Deserialize and concatenate `SparseTensors` from a serialized minibatch.
//
// The input `serialized_sparse` must be a string matrix of shape `[N x 3]` where
// `N` is the minibatch size and the rows correspond to packed outputs of
// `SerializeSparse`.  The ranks of the original `SparseTensor` objects
// must all match.  When the final `SparseTensor` is created, it has rank one
// higher than the ranks of the incoming `SparseTensor` objects
// (they have been concatenated along a new row dimension).
//
// The output `SparseTensor` object's shape values for all dimensions but the
// first are the max across the input `SparseTensor` objects' shape values
// for the corresponding dimensions.  Its first shape value is `N`, the minibatch
// size.
//
// The input `SparseTensor` objects' indices are assumed ordered in
// standard lexicographic order.  If this is not the case, after this
// step run `SparseReorder` to restore index ordering.
//
// For example, if the serialized input is a `[2 x 3]` matrix representing two
// original `SparseTensor` objects:
//
//     index = [ 0]
//             [10]
//             [20]
//     values = [1, 2, 3]
//     shape = [50]
//
// and
//
//     index = [ 2]
//             [10]
//     values = [4, 5]
//     shape = [30]
//
// then the final deserialized `SparseTensor` will be:
//
//     index = [0  0]
//             [0 10]
//             [0 20]
//             [1  2]
//             [1 10]
//     values = [1, 2, 3, 4, 5]
//     shape = [2 50]
//
// Arguments:
//	serialized_sparse: 2-D, The `N` serialized `SparseTensor` objects.
// Must have 3 columns.
//	dtype: The `dtype` of the serialized `SparseTensor` objects.
func DeserializeManySparse(scope *Scope, serialized_sparse tf.Output, dtype tf.DataType) (sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "DeserializeManySparse",
		Input: []tf.Input{
			serialized_sparse,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// PrelinearizeTupleAttr is an optional argument to PrelinearizeTuple.
type PrelinearizeTupleAttr func(optionalAttr)

// PrelinearizeTupleLayouts sets the optional layouts attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence for all the
// tuple shapes in the order the shapes appear in the "shapes" input. The layout
// elements for a sub-shape can be set to -1 in which case the corresponding layout
// will be computed by the infeed operation.
// If not specified, defaults to <>
func PrelinearizeTupleLayouts(value []int64) PrelinearizeTupleAttr {
	return func(m optionalAttr) {
		m["layouts"] = value
	}
}

// An op which linearizes multiple Tensor values to an opaque variant tensor.
//
// Arguments:
//	inputs: A list of tensors that will be provided using the infeed mechanism.
//	shapes: The shapes of each tensor in `inputs`.
func PrelinearizeTuple(scope *Scope, inputs []tf.Output, shapes []tf.Shape, optional ...PrelinearizeTupleAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PrelinearizeTuple",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Op that executes a program with optional in-place variable updates.
//
// It (optionally) reads device variables, loads and executes a TPU program on a
// TPU device, and then (optionally) in-place updates variables using the program
// outputs, as specified in attributes device_var_reads_indices (program input
// indices from directly reading variables) and device_var_updates_indices (program
// output indices used to update variables, -1 means no-update/read-only). Such
// program outputs are consumed by these variables will not appear in the op
// output. For the internal use of the distributed TPU compiler.
func TPUExecuteAndUpdateVariables(scope *Scope, args []tf.Output, key tf.Output, Tresults []tf.DataType, device_var_reads_indices []int64, device_var_updates_indices []int64) (results []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tresults": Tresults, "device_var_reads_indices": device_var_reads_indices, "device_var_updates_indices": device_var_updates_indices}
	opspec := tf.OpSpec{
		Type: "TPUExecuteAndUpdateVariables",
		Input: []tf.Input{
			tf.OutputList(args), key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if results, idx, err = makeOutputList(op, idx, "results"); err != nil {
		scope.UpdateErr("TPUExecuteAndUpdateVariables", err)
		return
	}
	return results
}

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebug.
type RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugConfig(value string) RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve proximal Adagrad embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the proximal Adagrad optimization algorithm.
//	accumulators: Parameter accumulators updated by the proximal Adagrad optimization algorithm.
//	gradient_accumulators: Parameter gradient_accumulators updated by the proximal Adagrad optimization algorithm.
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr) (parameters tf.Output, accumulators tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// StatelessRandomUniformFullIntAttr is an optional argument to StatelessRandomUniformFullInt.
type StatelessRandomUniformFullIntAttr func(optionalAttr)

// StatelessRandomUniformFullIntDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_UINT64
func StatelessRandomUniformFullIntDtype(value tf.DataType) StatelessRandomUniformFullIntAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom random integers from a uniform distribution.
//
// The generated values are uniform integers covering the whole range of `dtype`.
//
// The outputs are a deterministic function of `shape` and `seed`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//
// Returns Random values with specified shape.
func StatelessRandomUniformFullInt(scope *Scope, shape tf.Output, seed tf.Output, optional ...StatelessRandomUniformFullIntAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomUniformFullInt",
		Input: []tf.Input{
			shape, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Calculates the gradient of the SparseMatrixSoftmax op.
//
// Arguments:
//	softmax: A CSRSparseMatrix.
//	grad_softmax: The gradient of `softmax`.
//
//
// Returns The output gradient.
func SparseMatrixSoftmaxGrad(scope *Scope, softmax tf.Output, grad_softmax tf.Output, type_ tf.DataType) (gradient tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "SparseMatrixSoftmaxGrad",
		Input: []tf.Input{
			softmax, grad_softmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the GRU cell back-propagation for 1 time step.
//
// Args
//     x: Input to the GRU cell.
//     h_prev: State input from the previous GRU cell.
//     w_ru: Weight matrix for the reset and update gate.
//     w_c: Weight matrix for the cell connection gate.
//     b_ru: Bias vector for the reset and update gate.
//     b_c: Bias vector for the cell connection gate.
//     r: Output of the reset gate.
//     u: Output of the update gate.
//     c: Output of the cell connection gate.
//     d_h: Gradients of the h_new wrt to objective function.
//
// Returns
//     d_x: Gradients of the x wrt to objective function.
//     d_h_prev: Gradients of the h wrt to objective function.
//     d_c_bar Gradients of the c_bar wrt to objective function.
//     d_r_bar_u_bar Gradients of the r_bar & u_bar wrt to objective function.
//
// This kernel op implements the following mathematical equations:
//
// Note on notation of the variables:
//
// Concatenation of a and b is represented by a_b
// Element-wise dot product of a and b is represented by ab
// Element-wise dot product is represented by \circ
// Matrix multiplication is represented by *
//
// Additional notes for clarity:
//
// `w_ru` can be segmented into 4 different matrices.
// ```
// w_ru = [w_r_x w_u_x
//         w_r_h_prev w_u_h_prev]
// ```
// Similarly, `w_c` can be segmented into 2 different matrices.
// ```
// w_c = [w_c_x w_c_h_prevr]
// ```
// Same goes for biases.
// ```
// b_ru = [b_ru_x b_ru_h]
// b_c = [b_c_x b_c_h]
// ```
// Another note on notation:
// ```
// d_x = d_x_component_1 + d_x_component_2
//
// where d_x_component_1 = d_r_bar * w_r_x^T + d_u_bar * w_r_x^T
// and d_x_component_2 = d_c_bar * w_c_x^T
//
// d_h_prev = d_h_prev_component_1 + d_h_prevr \circ r + d_h \circ u
// where d_h_prev_componenet_1 = d_r_bar * w_r_h_prev^T + d_u_bar * w_r_h_prev^T
// ```
//
// Mathematics behind the Gradients below:
// ```
// d_c_bar = d_h \circ (1-u) \circ (1-c \circ c)
// d_u_bar = d_h \circ (h-c) \circ u \circ (1-u)
//
// d_r_bar_u_bar = [d_r_bar d_u_bar]
//
// [d_x_component_1 d_h_prev_component_1] = d_r_bar_u_bar * w_ru^T
//
// [d_x_component_2 d_h_prevr] = d_c_bar * w_c^T
//
// d_x = d_x_component_1 + d_x_component_2
//
// d_h_prev = d_h_prev_component_1 + d_h_prevr \circ r + u
// ```
// Below calculation is performed in the python wrapper for the Gradients
// (not in the gradient kernel.)
// ```
// d_w_ru = x_h_prevr^T * d_c_bar
//
// d_w_c = x_h_prev^T * d_r_bar_u_bar
//
// d_b_ru = sum of d_r_bar_u_bar along axis = 0
//
// d_b_c = sum of d_c_bar along axis = 0
// ```
func GRUBlockCellGrad(scope *Scope, x tf.Output, h_prev tf.Output, w_ru tf.Output, w_c tf.Output, b_ru tf.Output, b_c tf.Output, r tf.Output, u tf.Output, c tf.Output, d_h tf.Output) (d_x tf.Output, d_h_prev tf.Output, d_c_bar tf.Output, d_r_bar_u_bar tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GRUBlockCellGrad",
		Input: []tf.Input{
			x, h_prev, w_ru, w_c, b_ru, b_c, r, u, c, d_h,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// RandomPoissonV2Attr is an optional argument to RandomPoissonV2.
type RandomPoissonV2Attr func(optionalAttr)

// RandomPoissonV2Seed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomPoissonV2Seed(value int64) RandomPoissonV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomPoissonV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomPoissonV2Seed2(value int64) RandomPoissonV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// RandomPoissonV2Dtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_INT64
func RandomPoissonV2Dtype(value tf.DataType) RandomPoissonV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from the Poisson distribution(s) described by rate.
//
// This op uses two algorithms, depending on rate. If rate >= 10, then
// the algorithm by Hormann is used to acquire samples via
// transformation-rejection.
// See http://www.sciencedirect.com/science/article/pii/0167668793909974.
//
// Otherwise, Knuth's algorithm is used to acquire samples via multiplying uniform
// random variables.
// See Donald E. Knuth (1969). Seminumerical Algorithms. The Art of Computer
// Programming, Volume 2. Addison Wesley
//
// Arguments:
//	shape: 1-D integer tensor. Shape of independent samples to draw from each
// distribution described by the shape parameters given in rate.
//	rate: A tensor in which each scalar is a "rate" parameter describing the
// associated poisson distribution.
//
// Returns A tensor with shape `shape + shape(rate)`. Each slice
// `[:, ..., :, i0, i1, ...iN]` contains the samples drawn for
// `rate[i0, i1, ...iN]`.
func RandomPoissonV2(scope *Scope, shape tf.Output, rate tf.Output, optional ...RandomPoissonV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomPoissonV2",
		Input: []tf.Input{
			shape, rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingCenteredRMSPropParametersAttr is an optional argument to LoadTPUEmbeddingCenteredRMSPropParameters.
type LoadTPUEmbeddingCenteredRMSPropParametersAttr func(optionalAttr)

// LoadTPUEmbeddingCenteredRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingCenteredRMSPropParametersTableId(value int64) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingCenteredRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingCenteredRMSPropParametersTableName(value string) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingCenteredRMSPropParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingCenteredRMSPropParametersConfig(value string) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load centered RMSProp embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the centered RMSProp optimization algorithm.
//	ms: Value of ms used in the centered RMSProp optimization algorithm.
//	mom: Value of mom used in the centered RMSProp optimization algorithm.
//	mg: Value of mg used in the centered RMSProp optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingCenteredRMSPropParameters(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, mg tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingCenteredRMSPropParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingCenteredRMSPropParameters",
		Input: []tf.Input{
			parameters, ms, mom, mg,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// RandomPoissonAttr is an optional argument to RandomPoisson.
type RandomPoissonAttr func(optionalAttr)

// RandomPoissonSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func RandomPoissonSeed(value int64) RandomPoissonAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomPoissonSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func RandomPoissonSeed2(value int64) RandomPoissonAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Use RandomPoissonV2 instead.
//
// DEPRECATED at GraphDef version 25: Replaced by RandomPoissonV2
func RandomPoisson(scope *Scope, shape tf.Output, rate tf.Output, optional ...RandomPoissonAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomPoisson",
		Input: []tf.Input{
			shape, rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the derivative of a Gamma random sample w.r.t. `alpha`.
func RandomGammaGrad(scope *Scope, alpha tf.Output, sample tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RandomGammaGrad",
		Input: []tf.Input{
			alpha, sample,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NonDeterministicIntsAttr is an optional argument to NonDeterministicInts.
type NonDeterministicIntsAttr func(optionalAttr)

// NonDeterministicIntsDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_INT64
func NonDeterministicIntsDtype(value tf.DataType) NonDeterministicIntsAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Non-deterministically generates some integers.
//
// This op may use some OS-provided source of non-determinism (e.g. an RNG), so each execution will give different results.
//
// Arguments:
//	shape: The shape of the output tensor.
//
// Returns Non-deterministic integer values with specified shape.
func NonDeterministicInts(scope *Scope, shape tf.Output, optional ...NonDeterministicIntsAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonDeterministicInts",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MultinomialAttr is an optional argument to Multinomial.
type MultinomialAttr func(optionalAttr)

// MultinomialSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 is set to be non-zero, the internal random number
// generator is seeded by the given seed.  Otherwise, a random seed is used.
// If not specified, defaults to 0
func MultinomialSeed(value int64) MultinomialAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// MultinomialSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func MultinomialSeed2(value int64) MultinomialAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// MultinomialOutputDtype sets the optional output_dtype attribute to value.
// If not specified, defaults to DT_INT64
func MultinomialOutputDtype(value tf.DataType) MultinomialAttr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// Draws samples from a multinomial distribution.
//
// Arguments:
//	logits: 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
// represents the unnormalized log probabilities for all classes.
//	num_samples: 0-D.  Number of independent samples to draw for each row slice.
//
// Returns 2-D Tensor with shape `[batch_size, num_samples]`.  Each slice `[i, :]`
// contains the drawn class labels with range `[0, num_classes)`.
func Multinomial(scope *Scope, logits tf.Output, num_samples tf.Output, optional ...MultinomialAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Multinomial",
		Input: []tf.Input{
			logits, num_samples,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomShuffleAttr is an optional argument to RandomShuffle.
type RandomShuffleAttr func(optionalAttr)

// RandomShuffleSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomShuffleSeed(value int64) RandomShuffleAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomShuffleSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomShuffleSeed2(value int64) RandomShuffleAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Randomly shuffles a tensor along its first dimension.
//
//   The tensor is shuffled along dimension 0, such that each `value[j]` is mapped
//   to one and only one `output[i]`. For example, a mapping that might occur for a
//   3x2 tensor is:
//
// ```
// [[1, 2],       [[5, 6],
//  [3, 4],  ==>   [1, 2],
//  [5, 6]]        [3, 4]]
// ```
//
// Arguments:
//	value: The tensor to be shuffled.
//
// Returns A tensor of same shape and type as `value`, shuffled along its first
// dimension.
func RandomShuffle(scope *Scope, value tf.Output, optional ...RandomShuffleAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomShuffle",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns max(x, y) element-wise.
//
// *NOTE*: `RiscMax` does not supports broadcasting.
//
// Given two input tensors, the `tf.risc_max` operation computes the maximum for every element in the tensor.
//
func RiscMax(scope *Scope, x tf.Output, y tf.Output) (max tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RiscMax",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomUniformIntAttr is an optional argument to RandomUniformInt.
type RandomUniformIntAttr func(optionalAttr)

// RandomUniformIntSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomUniformIntSeed(value int64) RandomUniformIntAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomUniformIntSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomUniformIntSeed2(value int64) RandomUniformIntAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random integers from a uniform distribution.
//
// The generated values are uniform integers in the range `[minval, maxval)`.
// The lower bound `minval` is included in the range, while the upper bound
// `maxval` is excluded.
//
// The random integers are slightly biased unless `maxval - minval` is an exact
// power of two.  The bias is small for values of `maxval - minval` significantly
// smaller than the range of the output (either `2^32` or `2^64`).
//
// Arguments:
//	shape: The shape of the output tensor.
//	minval: 0-D.  Inclusive lower bound on the generated integers.
//	maxval: 0-D.  Exclusive upper bound on the generated integers.
//
// Returns A tensor of the specified shape filled with uniform random integers.
func RandomUniformInt(scope *Scope, shape tf.Output, minval tf.Output, maxval tf.Output, optional ...RandomUniformIntAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomUniformInt",
		Input: []tf.Input{
			shape, minval, maxval,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Create a dense tensor from a ragged tensor, possibly altering its shape.
//
// The `ragged_to_dense` op creates a dense tensor from a list of row partition
// tensors, a value vector, and default values. If the shape is unspecified, the
// minimal shape required to contain all the elements in the ragged tensor (the
// natural shape) will be used. If some dimensions are left unspecified, then the
// size of the natural shape is used in that dimension.
//
// The default_value will be broadcast to the output shape. After that, the values
// from the ragged tensor overwrite the default values. Note that the default_value
// must have less dimensions than the value.
//
// The row partition tensors are in the order of the dimensions.
// At present, the types can be:
// * "ROW_SPLITS": the row_splits tensor from the ragged tensor.
// * "VALUE_ROWIDS": the value_rowids tensor from the ragged tensor.
// * "FIRST_DIM_SIZE": if value_rowids is used for the first dimension, then it
//   is preceded by "FIRST_DIM_SIZE".
//
// Arguments:
//	shape: The desired shape of the output tensor. If left unspecified (empty),
// the minimal shape required to contain all the elements in the ragged tensor
// (the natural shape) will be used. If some dimensions are left unspecified, then
// the size of the natural shape is used in that dimension.
//
// Note that dense dimensions cannot be modified by the shape argument. Trying to
// change the size of a dense dimension will cause the op to fail.
// Examples:
// natural shape: [4, 5, 6]
// shape: -1
// output shape: [4, 5, 6]
//
// natural shape: [4, 5, 6]
// shape: [3, -1, 2]
// output shape: [3, 5, 2]
//
// natural shape: [4, 5, 6]
// shape: [3, 7, 2]
// output shape: [3, 7, 2]
//
//	values: A 1D tensor representing the values of the ragged tensor.
//	default_value: The default_value when the shape is larger than the ragged tensor. The
// default_value is broadcast until it is the shape of the output tensor, and
// then overwritten by values in the ragged tensor. The default value must be
// compatible with this broadcast operation, and must have fewer dimensions than
// the value tensor.
//
//	row_partition_types: The types of the row partition tensors. At present, these can be:
// * "ROW_SPLITS": the row_splits tensor from the ragged tensor.
// * "VALUE_ROWIDS": the value_rowids tensor from the ragged tensor.
// * "FIRST_DIM_SIZE": if value_rowids is used for the first dimension, then it
//   is preceeded by "FIRST_DIM_SIZE".
// The tensors are in the order of the dimensions.
//
// Returns The resulting dense tensor.
func RaggedTensorToTensor(scope *Scope, shape tf.Output, values tf.Output, default_value tf.Output, row_partition_tensors []tf.Output, row_partition_types []string) (result tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"row_partition_types": row_partition_types}
	opspec := tf.OpSpec{
		Type: "RaggedTensorToTensor",
		Input: []tf.Input{
			shape, values, default_value, tf.OutputList(row_partition_tensors),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Helper used to compute the gradient for `RaggedTensorToVariant`.
//
// Computes the gradient for the dense_values input to the RaggedTensorToVariant
// op, given the variant-encoded ragged gradients of the outputs, along with
// the outer row-splits and the shape of the dense-values that were provided as
// inputs to the RaggedTensorToVariant op.
//
// Arguments:
//	encoded_ragged_grad: A `variant` Tensor containing encoded `RaggedTensor` gradients.
//	row_splits: Outermost row-splits that were used as input to the RaggedTensorToVariant op.
//	dense_values_shape: Shape of the dense_values that was used as an input to the
// RaggedTensorToVariant op.
//
//
// Returns Gradient for the dense_values of the RaggedTensorToVariant op.
func RaggedTensorToVariantGradient(scope *Scope, encoded_ragged_grad tf.Output, row_splits tf.Output, dense_values_shape tf.Output, Tvalues tf.DataType) (dense_values_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tvalues": Tvalues}
	opspec := tf.OpSpec{
		Type: "RaggedTensorToVariantGradient",
		Input: []tf.Input{
			encoded_ragged_grad, row_splits, dense_values_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gather ragged slices from `params` axis `0` according to `indices`.
//
// Outputs a `RaggedTensor` output composed from `output_dense_values` and
// `output_nested_splits`, such that:
//
// ```python
// output.shape = indices.shape + params.shape[1:]
// output.ragged_rank = indices.shape.ndims + params.ragged_rank
// output[i...j, d0...dn] = params[indices[i...j], d0...dn]
// ```
//
// where
//
// * `params =
//    ragged.from_nested_row_splits(params_dense_values, params_nested_splits)`
//    provides the values that should be gathered.
// * `indices` ia a dense tensor with dtype `int32` or `int64`, indicating which
//    values should be gathered.
// * `output =
//    ragged.from_nested_row_splits(output_dense_values, output_nested_splits)`
//    is the output tensor.
//
// (Note: This c++ op is used to implement the higher-level python
// `tf.ragged.gather` op, which also supports ragged indices.)
//
//
// Arguments:
//	params_nested_splits: The `nested_row_splits` tensors that define the row-partitioning for the
// `params` RaggedTensor input.
//	params_dense_values: The `flat_values` for the `params` RaggedTensor. There was a terminology change
// at the python level from dense_values to flat_values, so dense_values is the
// deprecated name.
//	indices: Indices in the outermost dimension of `params` of the values that should be
// gathered.
//	OUTPUT_RAGGED_RANK: The ragged rank of the output RaggedTensor. `output_nested_splits` will contain
// this number of `row_splits` tensors. This value should equal
// `indices.shape.ndims + params.ragged_rank - 1`.
//
// Returns:
//	output_nested_splits: The `nested_row_splits` tensors that define the row-partitioning for the
// returned RaggedTensor.
//	output_dense_values: The `flat_values` for the returned RaggedTensor.
func RaggedGather(scope *Scope, params_nested_splits []tf.Output, params_dense_values tf.Output, indices tf.Output, OUTPUT_RAGGED_RANK int64) (output_nested_splits []tf.Output, output_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"OUTPUT_RAGGED_RANK": OUTPUT_RAGGED_RANK}
	opspec := tf.OpSpec{
		Type: "RaggedGather",
		Input: []tf.Input{
			tf.OutputList(params_nested_splits), params_dense_values, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_nested_splits, idx, err = makeOutputList(op, idx, "output_nested_splits"); err != nil {
		scope.UpdateErr("RaggedGather", err)
		return
	}
	output_dense_values = op.Output(idx)
	return output_nested_splits, output_dense_values
}

// StringToNumberAttr is an optional argument to StringToNumber.
type StringToNumberAttr func(optionalAttr)

// StringToNumberOutType sets the optional out_type attribute to value.
//
// value: The numeric type to interpret each string in `string_tensor` as.
// If not specified, defaults to DT_FLOAT
func StringToNumberOutType(value tf.DataType) StringToNumberAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Converts each string in the input Tensor to the specified numeric type.
//
// (Note that int32 overflow results in an error while float overflow
// results in a rounded value.)
//
// Example:
//
// >>> strings = ["5.0", "3.0", "7.0"]
// >>> tf.strings.to_number(strings)
// <tf.Tensor: shape=(3,), dtype=float32, numpy=array([5., 3., 7.], dtype=float32)>
//
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToNumber(scope *Scope, string_tensor tf.Output, optional ...StringToNumberAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringToNumber",
		Input: []tf.Input{
			string_tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert JSON-encoded Example records to binary protocol buffer strings.
//
//
// Note: This is **not** a general purpose JSON parsing op.
//
// This op converts JSON-serialized
// `tf.train.Example` (created with `json_format.MessageToJson`, following the
// [standard JSON mapping](https://developers.google.com/protocol-buffers/docs/proto3#json))
// to a binary-serialized `tf.train.Example` (equivalent to
// `Example.SerializeToString()`) suitable for conversion to tensors with
// `tf.io.parse_example`.
//
// Arguments:
//	json_examples: Each string is a JSON object serialized according to the JSON
// mapping of the Example proto.
//
// Returns Each string is a binary Example protocol buffer corresponding
// to the respective element of `json_examples`.
func DecodeJSONExample(scope *Scope, json_examples tf.Output) (binary_examples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeJSONExample",
		Input: []tf.Input{
			json_examples,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a Tensor into a serialized TensorProto proto.
//
// Arguments:
//	tensor: A Tensor of type `T`.
//
// Returns A serialized TensorProto proto of the input tensor.
func SerializeTensor(scope *Scope, tensor tf.Output) (serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SerializeTensor",
		Input: []tf.Input{
			tensor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a serialized tensorflow.TensorProto proto into a Tensor.
//
// Arguments:
//	serialized: A scalar string containing a serialized TensorProto proto.
//	out_type: The type of the serialized tensor.  The provided type must match the
// type of the serialized tensor and no implicit conversion will take place.
//
// Returns A Tensor of type `out_type`.
func ParseTensor(scope *Scope, serialized tf.Output, out_type tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "ParseTensor",
		Input: []tf.Input{
			serialized,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseSequenceExampleV2Attr is an optional argument to ParseSequenceExampleV2.
type ParseSequenceExampleV2Attr func(optionalAttr)

// ParseSequenceExampleV2NcontextSparse sets the optional Ncontext_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleV2NcontextSparse(value int64) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["Ncontext_sparse"] = value
	}
}

// ParseSequenceExampleV2ContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2ContextSparseTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSequenceExampleV2ContextRaggedValueTypes sets the optional context_ragged_value_types attribute to value.
//
// value: RaggedTensor.value dtypes for the ragged context features.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2ContextRaggedValueTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["context_ragged_value_types"] = value
	}
}

// ParseSequenceExampleV2ContextRaggedSplitTypes sets the optional context_ragged_split_types attribute to value.
//
// value: RaggedTensor.row_split dtypes for the ragged context features.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2ContextRaggedSplitTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["context_ragged_split_types"] = value
	}
}

// ParseSequenceExampleV2ContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2ContextDenseShapes(value []tf.Shape) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSequenceExampleV2NfeatureListSparse sets the optional Nfeature_list_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleV2NfeatureListSparse(value int64) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["Nfeature_list_sparse"] = value
	}
}

// ParseSequenceExampleV2NfeatureListDense sets the optional Nfeature_list_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleV2NfeatureListDense(value int64) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["Nfeature_list_dense"] = value
	}
}

// ParseSequenceExampleV2FeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2FeatureListDenseTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSequenceExampleV2FeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2FeatureListSparseTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSequenceExampleV2FeatureListRaggedValueTypes sets the optional feature_list_ragged_value_types attribute to value.
//
// value: RaggedTensor.value dtypes for the ragged FeatureList features.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2FeatureListRaggedValueTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["feature_list_ragged_value_types"] = value
	}
}

// ParseSequenceExampleV2FeatureListRaggedSplitTypes sets the optional feature_list_ragged_split_types attribute to value.
//
// value: RaggedTensor.row_split dtypes for the ragged FeatureList features.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2FeatureListRaggedSplitTypes(value []tf.DataType) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["feature_list_ragged_split_types"] = value
	}
}

// ParseSequenceExampleV2FeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleV2FeatureListDenseShapes(value []tf.Shape) ParseSequenceExampleV2Attr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a vector of tf.io.SequenceExample protos (as strings) into
// typed tensors.
//
// Arguments:
//	serialized: A scalar or vector containing binary serialized SequenceExample protos.
//	debug_name: A scalar or vector containing the names of the serialized protos.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no name is available.
//	context_sparse_keys: The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: The keys expected in the SequenceExamples' context features associated with
// dense values.
//	context_ragged_keys: The keys expected in the Examples' features associated with context_ragged
// values.
//	feature_list_sparse_keys: The keys expected in the FeatureLists associated with sparse values.
//	feature_list_dense_keys: The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
//	feature_list_ragged_keys: The keys expected in the FeatureLists associated with ragged values.
//	feature_list_dense_missing_assumed_empty: A vector corresponding 1:1 with feature_list_dense_keys, indicating which
// features may be missing from the SequenceExamples.  If the associated
// FeatureList is missing, it is treated as empty.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
func ParseSequenceExampleV2(scope *Scope, serialized tf.Output, debug_name tf.Output, context_sparse_keys tf.Output, context_dense_keys tf.Output, context_ragged_keys tf.Output, feature_list_sparse_keys tf.Output, feature_list_dense_keys tf.Output, feature_list_ragged_keys tf.Output, feature_list_dense_missing_assumed_empty tf.Output, context_dense_defaults []tf.Output, optional ...ParseSequenceExampleV2Attr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, context_ragged_values []tf.Output, context_ragged_row_splits []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output, feature_list_dense_lengths []tf.Output, feature_list_ragged_values []tf.Output, feature_list_ragged_outer_splits []tf.Output, feature_list_ragged_inner_splits []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSequenceExampleV2",
		Input: []tf.Input{
			serialized, debug_name, context_sparse_keys, context_dense_keys, context_ragged_keys, feature_list_sparse_keys, feature_list_dense_keys, feature_list_ragged_keys, feature_list_dense_missing_assumed_empty, tf.OutputList(context_dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if context_ragged_values, idx, err = makeOutputList(op, idx, "context_ragged_values"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if context_ragged_row_splits, idx, err = makeOutputList(op, idx, "context_ragged_row_splits"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_dense_lengths, idx, err = makeOutputList(op, idx, "feature_list_dense_lengths"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_ragged_values, idx, err = makeOutputList(op, idx, "feature_list_ragged_values"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_ragged_outer_splits, idx, err = makeOutputList(op, idx, "feature_list_ragged_outer_splits"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	if feature_list_ragged_inner_splits, idx, err = makeOutputList(op, idx, "feature_list_ragged_inner_splits"); err != nil {
		scope.UpdateErr("ParseSequenceExampleV2", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, context_ragged_values, context_ragged_row_splits, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values, feature_list_dense_lengths, feature_list_ragged_values, feature_list_ragged_outer_splits, feature_list_ragged_inner_splits
}

// Transforms a vector of brain.Example protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A vector containing a batch of binary serialized Example protos.
//	names: A vector containing the names of the serialized protos.
// May contain, for example, table key (descriptive) names for the
// corresponding serialized protos.  These are purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no names are available.
// If non-empty, this vector must be the same length as "serialized".
//	sparse_keys: A list of Nsparse string Tensors (scalars).
// The keys expected in the Examples' features associated with sparse values.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples' features associated with dense values.
//	dense_defaults: A list of Ndense Tensors (some may be empty).
// dense_defaults[j] provides default values
// when the example's feature_map lacks dense_key[j].  If an empty Tensor is
// provided for dense_defaults[j], then the Feature dense_keys[j] is required.
// The input type is inferred from dense_defaults[j], even when it's empty.
// If dense_defaults[j] is not empty, and dense_shapes[j] is fully defined,
// then the shape of dense_defaults[j] must match that of dense_shapes[j].
// If dense_shapes[j] has an undefined major dimension (variable strides dense
// feature), dense_defaults[j] must contain a single element:
// the padding element.
//	sparse_types: A list of Nsparse types; the data types of data in each Feature
// given in sparse_keys.
// Currently the ParseExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	dense_shapes: A list of Ndense shapes; the shapes of data in each Feature
// given in dense_keys.
// The number of elements in the Feature corresponding to dense_key[j]
// must always equal dense_shapes[j].NumEntries().
// If dense_shapes[j] == (D0, D1, ..., DN) then the shape of output
// Tensor dense_values[j] will be (|serialized|, D0, D1, ..., DN):
// The dense outputs are just the inputs row-stacked by batch.
// This works for dense_shapes[j] = (-1, D1, ..., DN).  In this case
// the shape of the output Tensor dense_values[j] will be
// (|serialized|, M, D1, .., DN), where M is the maximum number of blocks
// of elements of length D1 * .... * DN, across all minibatch entries
// in the input.  Any minibatch entry with less than M blocks of elements of
// length D1 * ... * DN will be padded with the corresponding default_value
// scalar element along the second dimension.
func ParseExample(scope *Scope, serialized tf.Output, names tf.Output, sparse_keys []tf.Output, dense_keys []tf.Output, dense_defaults []tf.Output, sparse_types []tf.DataType, dense_shapes []tf.Shape) (sparse_indices []tf.Output, sparse_values []tf.Output, sparse_shapes []tf.Output, dense_values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_types": sparse_types, "dense_shapes": dense_shapes}
	opspec := tf.OpSpec{
		Type: "ParseExample",
		Input: []tf.Input{
			serialized, names, tf.OutputList(sparse_keys), tf.OutputList(dense_keys), tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if sparse_indices, idx, err = makeOutputList(op, idx, "sparse_indices"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	if sparse_values, idx, err = makeOutputList(op, idx, "sparse_values"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	if sparse_shapes, idx, err = makeOutputList(op, idx, "sparse_shapes"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	if dense_values, idx, err = makeOutputList(op, idx, "dense_values"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	return sparse_indices, sparse_values, sparse_shapes, dense_values
}

// DecodeCompressedAttr is an optional argument to DecodeCompressed.
type DecodeCompressedAttr func(optionalAttr)

// DecodeCompressedCompressionType sets the optional compression_type attribute to value.
//
// value: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
// If not specified, defaults to ""
func DecodeCompressedCompressionType(value string) DecodeCompressedAttr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// Decompress strings.
//
// This op decompresses each element of the `bytes` input `Tensor`, which
// is assumed to be compressed using the given `compression_type`.
//
// The `output` is a string `Tensor` of the same shape as `bytes`,
// each element containing the decompressed data from the corresponding
// element in `bytes`.
//
// Arguments:
//	bytes: A Tensor of string which is compressed.
//
// Returns A Tensor with the same shape as input `bytes`, uncompressed
// from bytes.
func DecodeCompressed(scope *Scope, bytes tf.Output, optional ...DecodeCompressedAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCompressed",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr is an optional argument to QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize.
type QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr func(optionalAttr)

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QUINT8
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeOutType(value tf.DataType) QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeDilations(value []int64) QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizePaddingList sets the optional padding_list attribute to value.
// If not specified, defaults to <>
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizePaddingList(value []int64) QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["padding_list"] = value
	}
}

// Computes quantized depthwise Conv2D with Bias, Relu and Requantize.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	bias: The original bias tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	min_freezed_output: The minimum float value of the output tensor.
//	max_freezed_output: The maximum float value of the output tensor.
//	strides: List of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The float value that the minimum quantized output value represents.
//	max_output: The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize(scope *Scope, input tf.Output, filter tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, min_freezed_output tf.Output, max_freezed_output tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize",
		Input: []tf.Input{
			input, filter, bias, min_input, max_input, min_filter, max_filter, min_freezed_output, max_freezed_output,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedDepthwiseConv2DWithBiasAttr is an optional argument to QuantizedDepthwiseConv2DWithBias.
type QuantizedDepthwiseConv2DWithBiasAttr func(optionalAttr)

// QuantizedDepthwiseConv2DWithBiasOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QINT32
func QuantizedDepthwiseConv2DWithBiasOutType(value tf.DataType) QuantizedDepthwiseConv2DWithBiasAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedDepthwiseConv2DWithBiasDilations(value []int64) QuantizedDepthwiseConv2DWithBiasAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes quantized depthwise Conv2D with Bias.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	bias: The original bias tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	strides: List of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The float value that the minimum quantized output value represents.
//	max_output: The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2DWithBias(scope *Scope, input tf.Output, filter tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DWithBiasAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2DWithBias",
		Input: []tf.Input{
			input, filter, bias, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedDepthwiseConv2DAttr is an optional argument to QuantizedDepthwiseConv2D.
type QuantizedDepthwiseConv2DAttr func(optionalAttr)

// QuantizedDepthwiseConv2DOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QINT32
func QuantizedDepthwiseConv2DOutType(value tf.DataType) QuantizedDepthwiseConv2DAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedDepthwiseConv2DDilations(value []int64) QuantizedDepthwiseConv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes quantized depthwise Conv2D.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	strides: List of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The float value that the minimum quantized output value represents.
//	max_output: The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2D(scope *Scope, input tf.Output, filter tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2D",
		Input: []tf.Input{
			input, filter, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedConv2DPerChannelAttr is an optional argument to QuantizedConv2DPerChannel.
type QuantizedConv2DPerChannelAttr func(optionalAttr)

// QuantizedConv2DPerChannelOutType sets the optional out_type attribute to value.
//
// value: The quantized type of output tensor that needs to be converted.
// If not specified, defaults to DT_QINT32
func QuantizedConv2DPerChannelOutType(value tf.DataType) QuantizedConv2DPerChannelAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedConv2DPerChannelDilations sets the optional dilations attribute to value.
//
// value: list of dilation values.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedConv2DPerChannelDilations(value []int64) QuantizedConv2DPerChannelAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes QuantizedConv2D per channel.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	min_input: The minimum value of the input tensor
//	max_input: The maximum value of the input tensor.
//	min_filter: The minimum value of the filter tensor.
//	max_filter: The maximum value of the filter tensor.
//	strides: list of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The minimum value of the final output tensor.
//	max_output: The maximum value of the final output tensor.
func QuantizedConv2DPerChannel(scope *Scope, input tf.Output, filter tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedConv2DPerChannelAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedConv2DPerChannel",
		Input: []tf.Input{
			input, filter, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RetrieveTPUEmbeddingRMSPropParametersAttr is an optional argument to RetrieveTPUEmbeddingRMSPropParameters.
type RetrieveTPUEmbeddingRMSPropParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingRMSPropParametersTableId(value int64) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingRMSPropParametersTableName(value string) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingRMSPropParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingRMSPropParametersConfig(value string) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve RMSProp embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the RMSProp optimization algorithm.
//	ms: Parameter ms updated by the RMSProp optimization algorithm.
//	mom: Parameter mom updated by the RMSProp optimization algorithm.
func RetrieveTPUEmbeddingRMSPropParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingRMSPropParametersAttr) (parameters tf.Output, ms tf.Output, mom tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingRMSPropParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// LoadTPUEmbeddingADAMParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingADAMParametersGradAccumDebug.
type LoadTPUEmbeddingADAMParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingADAMParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingADAMParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingADAMParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingADAMParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load ADAM embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the ADAM optimization algorithm.
//	momenta: Value of momenta used in the ADAM optimization algorithm.
//	velocities: Value of velocities used in the ADAM optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the ADAM optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingADAMParametersGradAccumDebug(scope *Scope, parameters tf.Output, momenta tf.Output, velocities tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingADAMParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingADAMParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, momenta, velocities, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// QuantizedMatMulWithBiasAndReluAttr is an optional argument to QuantizedMatMulWithBiasAndRelu.
type QuantizedMatMulWithBiasAndReluAttr func(optionalAttr)

// QuantizedMatMulWithBiasAndReluToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMatMulWithBiasAndReluToutput(value tf.DataType) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasAndReluTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluTransposeA(value bool) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasAndReluTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluTransposeB(value bool) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasAndReluInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasAndReluInputQuantMode(value string) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Perform a quantized matrix multiplication of  `a` by the matrix `b` with bias
// add and relu fusion.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// multiplication result. The bias size must match inner dimension of `b`. Then do
// relu activation to get non-negative result.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching with inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//
// Returns:
//	out
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedMatMulWithBiasAndRelu(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, optional ...QuantizedMatMulWithBiasAndReluAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBiasAndRelu",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedMatMulWithBiasAttr is an optional argument to QuantizedMatMulWithBias.
type QuantizedMatMulWithBiasAttr func(optionalAttr)

// QuantizedMatMulWithBiasToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMatMulWithBiasToutput(value tf.DataType) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasTransposeA(value bool) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasTransposeB(value bool) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasInputQuantMode(value string) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Performs a quantized matrix multiplication of `a` by the matrix `b` with bias
// add.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// multiplication result. The bias size must match inner dimension of `b`.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//
// Returns:
//	out
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedMatMulWithBias(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, optional ...QuantizedMatMulWithBiasAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBias",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Quantized Batch normalization.
//
// This op is deprecated and will be removed in the future. Prefer
// `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	t_min: The value represented by the lowest quantized input.
//	t_max: The value represented by the highest quantized input.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	m_min: The value represented by the lowest quantized mean.
//	m_max: The value represented by the highest quantized mean.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	v_min: The value represented by the lowest quantized variance.
//	v_max: The value represented by the highest quantized variance.
//	beta: A 1D beta Tensor with size matching the last dimension of t.
// An offset to be added to the normalized tensor.
//	beta_min: The value represented by the lowest quantized offset.
//	beta_max: The value represented by the highest quantized offset.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this tensor will be multiplied
// with the normalized tensor.
//	gamma_min: The value represented by the lowest quantized gamma.
//	gamma_max: The value represented by the highest quantized gamma.
//
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
func QuantizedBatchNormWithGlobalNormalization(scope *Scope, t tf.Output, t_min tf.Output, t_max tf.Output, m tf.Output, m_min tf.Output, m_max tf.Output, v tf.Output, v_min tf.Output, v_max tf.Output, beta tf.Output, beta_min tf.Output, beta_max tf.Output, gamma tf.Output, gamma_min tf.Output, gamma_max tf.Output, out_type tf.DataType, variance_epsilon float32, scale_after_normalization bool) (result tf.Output, result_min tf.Output, result_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type, "variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "QuantizedBatchNormWithGlobalNormalization",
		Input: []tf.Input{
			t, t_min, t_max, m, m_min, m_max, v, v_min, v_max, beta, beta_min, beta_max, gamma, gamma_min, gamma_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedReluXAttr is an optional argument to QuantizedReluX.
type QuantizedReluXAttr func(optionalAttr)

// QuantizedReluXOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedReluXOutType(value tf.DataType) QuantizedReluXAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear X: `min(max(features, 0), max_value)`
//
// Arguments:
//
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns:
//	activations: Has the same output shape as "features".
//	min_activations: The float value that the lowest quantized value represents.
//	max_activations: The float value that the highest quantized value represents.
func QuantizedReluX(scope *Scope, features tf.Output, max_value tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedReluXAttr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedReluX",
		Input: []tf.Input{
			features, max_value, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Produces the average pool of the input tensor for quantized types.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, channels]`.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	ksize: The size of the window for each dimension of the input tensor.
// The length must be 4 to match the number of dimensions of the input.
//	strides: The stride of the sliding window for each dimension of the input
// tensor.  The length must be 4 to match the number of dimensions of the input.
//	padding: The type of padding algorithm to use.
//
// Returns:
//	output
//	min_output: The float value that the lowest quantized output value represents.
//	max_output: The float value that the highest quantized output value represents.
func QuantizedAvgPool(scope *Scope, input tf.Output, min_input tf.Output, max_input tf.Output, ksize []int64, strides []int64, padding string) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "QuantizedAvgPool",
		Input: []tf.Input{
			input, min_input, max_input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FractionalAvgPoolGradAttr is an optional argument to FractionalAvgPoolGrad.
type FractionalAvgPoolGradAttr func(optionalAttr)

// FractionalAvgPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolGradOverlapping(value bool) FractionalAvgPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalAvgPool function.
//
// Unlike FractionalMaxPoolGrad, we don't need to find arg_max for
// FractionalAvgPoolGrad, we just need to evenly back-propagate each element of
// out_backprop to those indices that form the same pooling cell. Therefore, we
// just need to know the shape of original input tensor, instead of the whole
// tensor.
//
// Arguments:
//	orig_input_tensor_shape: Original input tensor shape for `fractional_avg_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
// w.r.t. the output of `fractional_avg_pool`.
//	row_pooling_sequence: row pooling sequence, form pooling region with
// col_pooling_sequence.
//	col_pooling_sequence: column pooling sequence, form pooling region with
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_avg_pool`.
func FractionalAvgPoolGrad(scope *Scope, orig_input_tensor_shape tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalAvgPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPoolGrad",
		Input: []tf.Input{
			orig_input_tensor_shape, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalMaxPoolGradAttr is an optional argument to FractionalMaxPoolGrad.
type FractionalMaxPoolGradAttr func(optionalAttr)

// FractionalMaxPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolGradOverlapping(value bool) FractionalMaxPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalMaxPool function.
//
// Arguments:
//	orig_input: Original input for `fractional_max_pool`
//	orig_output: Original output for `fractional_max_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
// w.r.t. the output of `fractional_max_pool`.
//	row_pooling_sequence: row pooling sequence, form pooling region with
// col_pooling_sequence.
//	col_pooling_sequence: column pooling sequence, form pooling region with
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_max_pool`.
func FractionalMaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalMaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TopKV2Attr is an optional argument to TopKV2.
type TopKV2Attr func(optionalAttr)

// TopKV2Sorted sets the optional sorted attribute to value.
//
// value: If true the resulting `k` elements will be sorted by the values in
// descending order.
// If not specified, defaults to true
func TopKV2Sorted(value bool) TopKV2Attr {
	return func(m optionalAttr) {
		m["sorted"] = value
	}
}

// Finds values and indices of the `k` largest elements for the last dimension.
//
// If the input is a vector (rank-1), finds the `k` largest entries in the vector
// and outputs their values and indices as vectors.  Thus `values[j]` is the
// `j`-th largest entry in `input`, and its index is `indices[j]`.
//
// For matrices (resp. higher rank input), computes the top `k` entries in each
// row (resp. vector along the last dimension).  Thus,
//
//     values.shape = indices.shape = input.shape[:-1] + [k]
//
// If two elements are equal, the lower-index element appears first.
//
// Arguments:
//	input: 1-D or higher with last dimension at least `k`.
//	k: 0-D.  Number of top elements to look for along the last dimension (along each
// row for matrices).
//
// Returns:
//	values: The `k` largest elements along each last dimensional slice.
//	indices: The indices of `values` within the last dimension of `input`.
func TopKV2(scope *Scope, input tf.Output, k tf.Output, optional ...TopKV2Attr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TopKV2",
		Input: []tf.Input{
			input, k,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// TopKAttr is an optional argument to TopK.
type TopKAttr func(optionalAttr)

// TopKSorted sets the optional sorted attribute to value.
//
// value: If true the resulting `k` elements will be sorted by the values in
// descending order.
// If not specified, defaults to true
func TopKSorted(value bool) TopKAttr {
	return func(m optionalAttr) {
		m["sorted"] = value
	}
}

// Finds values and indices of the `k` largest elements for the last dimension.
//
// DEPRECATED at GraphDef version 7: Use TopKV2 instead
//
// If the input is a vector (rank-1), finds the `k` largest entries in the vector
// and outputs their values and indices as vectors.  Thus `values[j]` is the
// `j`-th largest entry in `input`, and its index is `indices[j]`.
//
// For matrices (resp. higher rank input), computes the top `k` entries in each
// row (resp. vector along the last dimension).  Thus,
//
//     values.shape = indices.shape = input.shape[:-1] + [k]
//
// If two elements are equal, the lower-index element appears first.
//
// If `k` varies dynamically, use `TopKV2` below.
//
// Arguments:
//	input: 1-D or higher with last dimension at least `k`.
//	k: Number of top elements to look for along the last dimension (along each
// row for matrices).
//
// Returns:
//	values: The `k` largest elements along each last dimensional slice.
//	indices: The indices of `values` within the last dimension of `input`.
func TopK(scope *Scope, input tf.Output, k int64, optional ...TopKAttr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TopK",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Says whether the targets are in the top `K` predictions.
//
// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
// prediction for the target class is among the top `k` predictions among
// all predictions for example `i`. Note that the behavior of `InTopK` differs
// from the `TopK` op in its handling of ties; if multiple classes have the
// same prediction value and straddle the top-`k` boundary, all of those
// classes are considered to be in the top `k`.
//
// More formally, let
//
//   \\(predictions_i\\) be the predictions for all classes for example `i`,
//   \\(targets_i\\) be the target class for example `i`,
//   \\(out_i\\) be the output for example `i`,
//
// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
//
// Arguments:
//	predictions: A `batch_size` x `classes` tensor.
//	targets: A `batch_size` vector of class ids.
//	k: Number of top elements to look at for computing precision.
//
// Returns Computed precision at `k` as a `bool Tensor`.
func InTopKV2(scope *Scope, predictions tf.Output, targets tf.Output, k tf.Output) (precision tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InTopKV2",
		Input: []tf.Input{
			predictions, targets, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softmax cross entropy cost and gradients to backpropagate.
//
// Unlike `SoftmaxCrossEntropyWithLogits`, this operation does not accept
// a matrix of label probabilities, but rather a single label per row
// of features.  This label is considered to have probability 1.0 for the
// given row.
//
// Inputs are the logits, not probabilities.
//
// Arguments:
//	features: batch_size x num_classes matrix
//	labels: batch_size vector with values in [0, num_classes).
// This is the label for the given minibatch entry.
//
// Returns:
//	loss: Per example loss (batch_size vector).
//	backprop: backpropagated gradients (batch_size x num_classes matrix).
func SparseSoftmaxCrossEntropyWithLogits(scope *Scope, features tf.Output, labels tf.Output) (loss tf.Output, backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSoftmaxCrossEntropyWithLogits",
		Input: []tf.Input{
			features, labels,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes log softmax activations.
//
// For each batch `i` and class `j` we have
//
//     logsoftmax[i, j] = logits[i, j] - log(sum(exp(logits[i])))
//
// Arguments:
//	logits: 2-D with shape `[batch_size, num_classes]`.
//
// Returns Same shape as `logits`.
func LogSoftmax(scope *Scope, logits tf.Output) (logsoftmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogSoftmax",
		Input: []tf.Input{
			logits,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softmax activations.
//
// For each batch `i` and class `j` we have
//
//     $$softmax[i, j] = exp(logits[i, j]) / sum_j(exp(logits[i, j]))$$
//
// Arguments:
//	logits: 2-D with shape `[batch_size, num_classes]`.
//
// Returns Same shape as `logits`.
func Softmax(scope *Scope, logits tf.Output) (softmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softmax",
		Input: []tf.Input{
			logits,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softsign gradients for a softsign operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding softsign operation.
//	features: The features passed as input to the corresponding softsign operation.
//
// Returns The gradients: `gradients / (1 + abs(features)) ** 2`.
func SoftsignGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftsignGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softplus gradients for a softplus operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding softplus operation.
//	features: The features passed as input to the corresponding softplus operation.
//
// Returns The gradients: `gradients / (1 + exp(-features))`.
func SoftplusGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftplusGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the LSTM cell backward propagation for 1 timestep.
//
// This implementation is to be used in conjunction of LSTMBlockCell.
//
// Arguments:
//	x: The input to the LSTM cell, shape (batch_size, num_inputs).
//	cs_prev: The previous cell state.
//	h_prev: The previous h state.
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate.
//	cs: The cell state before the tanh.
//	f: The forget gate.
//	o: The output gate.
//	ci: The cell input.
//	co: The cell after the tanh.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether the cell uses peephole connections.
//
// Returns:
//	cs_prev_grad: The gradient of cs to be back-propped.
//	dicfo: The derivative wrt to [i, cs, f, o].
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
func LSTMBlockCellGrad(scope *Scope, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (cs_prev_grad tf.Output, dicfo tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "LSTMBlockCellGrad",
		Input: []tf.Input{
			x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Computes gradients for the scaled exponential linear (Selu) operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Selu operation.
//	outputs: The outputs of the corresponding Selu operation.
//
// Returns The gradients: `gradients * (outputs + scale * alpha)`
// if outputs < 0, `scale * gradients` otherwise.
func SeluGrad(scope *Scope, gradients tf.Output, outputs tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SeluGrad",
		Input: []tf.Input{
			gradients, outputs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for the exponential linear (Elu) operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Elu operation.
//	outputs: The outputs of the corresponding Elu operation.
//
// Returns The gradients: `gradients * (outputs + 1)` if outputs < 0,
// `gradients` otherwise.
func EluGrad(scope *Scope, gradients tf.Output, outputs tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EluGrad",
		Input: []tf.Input{
			gradients, outputs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LeakyReluGradAttr is an optional argument to LeakyReluGrad.
type LeakyReluGradAttr func(optionalAttr)

// LeakyReluGradAlpha sets the optional alpha attribute to value.
// If not specified, defaults to 0.2
func LeakyReluGradAlpha(value float32) LeakyReluGradAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// Computes rectified linear gradients for a LeakyRelu operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding LeakyRelu operation.
//	features: The features passed as input to the corresponding LeakyRelu operation,
// OR the outputs of that operation (both work equivalently).
//
// Returns `gradients * (features > 0) + alpha * gradients * (features <= 0)`.
func LeakyReluGrad(scope *Scope, gradients tf.Output, features tf.Output, optional ...LeakyReluGradAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LeakyReluGrad",
		Input: []tf.Input{
			gradients, features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes rectified linear 6 gradients for a Relu6 operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Relu6 operation.
//	features: The features passed as input to the corresponding Relu6 operation, or
// its output; using either one produces the same result.
//
// Returns The gradients:
// `gradients * (features > 0) * (features < 6)`.
func Relu6Grad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Relu6Grad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes rectified linear gradients for a Relu operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Relu operation.
//	features: The features passed as input to the corresponding Relu operation, OR
// the outputs of that operation (both work equivalently).
//
// Returns `gradients * (features > 0)`.
func ReluGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReluGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the filter.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
// Must be: `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 3-D with shape `[filter_height, filter_width, depth]`.
func Dilation2DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (filter_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradWithArgmaxAttr is an optional argument to MaxPoolGradGradWithArgmax.
type MaxPoolGradGradWithArgmaxAttr func(optionalAttr)

// MaxPoolGradGradWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolGradGradWithArgmaxIncludeBatchInIndex(value bool) MaxPoolGradGradWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	input: The original input.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
// input of `max_pool`.
//	argmax: The indices of the maximum values chosen for each output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input of `max_pool`.
func MaxPoolGradGradWithArgmax(scope *Scope, input tf.Output, grad tf.Output, argmax tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradWithArgmaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGradWithArgmax",
		Input: []tf.Input{
			input, grad, argmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradWithArgmaxAttr is an optional argument to MaxPoolGradWithArgmax.
type MaxPoolGradWithArgmaxAttr func(optionalAttr)

// MaxPoolGradWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolGradWithArgmaxIncludeBatchInIndex(value bool) MaxPoolGradWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	input: The original input.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
// output of `max_pool`.
//	argmax: The indices of the maximum values chosen for each output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input of `max_pool`.
func MaxPoolGradWithArgmax(scope *Scope, input tf.Output, grad tf.Output, argmax tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradWithArgmaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradWithArgmax",
		Input: []tf.Input{
			input, grad, argmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolWithArgmaxAttr is an optional argument to MaxPoolWithArgmax.
type MaxPoolWithArgmaxAttr func(optionalAttr)

// MaxPoolWithArgmaxTargmax sets the optional Targmax attribute to value.
// If not specified, defaults to DT_INT64
func MaxPoolWithArgmaxTargmax(value tf.DataType) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["Targmax"] = value
	}
}

// MaxPoolWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolWithArgmaxIncludeBatchInIndex(value bool) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Performs max pooling on the input and outputs both max values and indices.
//
// The indices in `argmax` are flattened, so that a maximum value at position
// `[b, y, x, c]` becomes flattened index:
// `(y * width + x) * channels + c` if `include_batch_in_index` is False;
// `((b * height + y) * width + x) * channels + c` if `include_batch_in_index` is True.
//
// The indices returned are always in `[0, height) x [0, width)` before flattening,
// even if padding is involved and the mathematically correct answer is outside
// (either negative or too large).  This is a bug, but fixing it is difficult to do
// in a safe backwards compatible way, especially due to flattening.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns:
//	output: The max pooled output tensor.
//	argmax: 4-D.  The flattened indices of the max values chosen for each output.
func MaxPoolWithArgmax(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolWithArgmaxAttr) (output tf.Output, argmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolWithArgmax",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// MaxPoolGradGradV2Attr is an optional argument to MaxPoolGradGradV2.
type MaxPoolGradGradV2Attr func(optionalAttr)

// MaxPoolGradGradV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradGradV2DataFormat(value string) MaxPoolGradGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGradV2(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolGradGradV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGradV2",
		Input: []tf.Input{
			orig_input, orig_output, grad, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolV2Attr is an optional argument to MaxPoolV2.
type MaxPoolV2Attr func(optionalAttr)

// MaxPoolV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolV2DataFormat(value string) MaxPoolV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs max pooling on the input.
//
// Arguments:
//	input: 4-D input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPoolV2(scope *Scope, input tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolV2",
		Input: []tf.Input{
			input, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LRNGradAttr is an optional argument to LRNGrad.
type LRNGradAttr func(optionalAttr)

// LRNGradDepthRadius sets the optional depth_radius attribute to value.
//
// value: A depth radius.
// If not specified, defaults to 5
func LRNGradDepthRadius(value int64) LRNGradAttr {
	return func(m optionalAttr) {
		m["depth_radius"] = value
	}
}

// LRNGradBias sets the optional bias attribute to value.
//
// value: An offset (usually > 0 to avoid dividing by 0).
// If not specified, defaults to 1
func LRNGradBias(value float32) LRNGradAttr {
	return func(m optionalAttr) {
		m["bias"] = value
	}
}

// LRNGradAlpha sets the optional alpha attribute to value.
//
// value: A scale factor, usually positive.
// If not specified, defaults to 1
func LRNGradAlpha(value float32) LRNGradAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// LRNGradBeta sets the optional beta attribute to value.
//
// value: An exponent.
// If not specified, defaults to 0.5
func LRNGradBeta(value float32) LRNGradAttr {
	return func(m optionalAttr) {
		m["beta"] = value
	}
}

// Gradients for Local Response Normalization.
//
// Arguments:
//	input_grads: 4-D with shape `[batch, height, width, channels]`.
//	input_image: 4-D with shape `[batch, height, width, channels]`.
//	output_image: 4-D with shape `[batch, height, width, channels]`.
//
// Returns The gradients for LRN.
func LRNGrad(scope *Scope, input_grads tf.Output, input_image tf.Output, output_image tf.Output, optional ...LRNGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LRNGrad",
		Input: []tf.Input{
			input_grads, input_image, output_image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DGradGradAttr is an optional argument to MaxPool3DGradGrad.
type MaxPool3DGradGradAttr func(optionalAttr)

// MaxPool3DGradGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DGradGradDataFormat(value string) MaxPool3DGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPool3DGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3DGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyRMSPropAttr is an optional argument to ResourceApplyRMSProp.
type ResourceApplyRMSPropAttr func(optionalAttr)

// ResourceApplyRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, ms, and mom tensors is protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyRMSPropUseLocking(value bool) ResourceApplyRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the RMSProp algorithm.
//
// Note that in dense implementation of this algorithm, ms and mom will
// update even if the grad is zero, but in this sparse implementation, ms
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon)
//
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyRMSProp(scope *Scope, var_ tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyRMSProp",
		Input: []tf.Input{
			var_, ms, mom, lr, rho, momentum, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MaxPool3DGradAttr is an optional argument to MaxPool3DGrad.
type MaxPool3DGradAttr func(optionalAttr)

// MaxPool3DGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DGradDataFormat(value string) MaxPool3DGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of 3D max pooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func MaxPool3DGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3DGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DAttr is an optional argument to MaxPool3D.
type MaxPool3DAttr func(optionalAttr)

// MaxPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DDataFormat(value string) MaxPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D max pooling on the input.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPool3DAttr is an optional argument to AvgPool3D.
type AvgPool3DAttr func(optionalAttr)

// AvgPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func AvgPool3DDataFormat(value string) AvgPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D average pooling on the input.
//
// Each entry in `output` is the mean of the corresponding size `ksize` window in
// `value`.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The average pooled output tensor.
func AvgPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMatMulWithBiasAndReluAndRequantizeAttr is an optional argument to QuantizedMatMulWithBiasAndReluAndRequantize.
type QuantizedMatMulWithBiasAndReluAndRequantizeAttr func(optionalAttr)

// QuantizedMatMulWithBiasAndReluAndRequantizeToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedMatMulWithBiasAndReluAndRequantizeToutput(value tf.DataType) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluAndRequantizeTransposeA(value bool) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluAndRequantizeTransposeB(value bool) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasAndReluAndRequantizeInputQuantMode(value string) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Perform a quantized matrix multiplication of  `a` by the matrix `b` with bias
// add and relu and requantize fusion.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// multiplication result. The bias size must match inner dimension of `b`.  Then do
// relu activation to get non-negative result. Then do requantize operation to get
// final uint8 result.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching with inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//	min_freezed_output: The float value that the highest quantized output value after requantize.
//
//
// Returns:
//	out
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedMatMulWithBiasAndReluAndRequantize(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, min_freezed_output tf.Output, max_freezed_output tf.Output, optional ...QuantizedMatMulWithBiasAndReluAndRequantizeAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBiasAndReluAndRequantize",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b, min_freezed_output, max_freezed_output,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// LRNAttr is an optional argument to LRN.
type LRNAttr func(optionalAttr)

// LRNDepthRadius sets the optional depth_radius attribute to value.
//
// value: 0-D.  Half-width of the 1-D normalization window.
// If not specified, defaults to 5
func LRNDepthRadius(value int64) LRNAttr {
	return func(m optionalAttr) {
		m["depth_radius"] = value
	}
}

// LRNBias sets the optional bias attribute to value.
//
// value: An offset (usually positive to avoid dividing by 0).
// If not specified, defaults to 1
func LRNBias(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["bias"] = value
	}
}

// LRNAlpha sets the optional alpha attribute to value.
//
// value: A scale factor, usually positive.
// If not specified, defaults to 1
func LRNAlpha(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// LRNBeta sets the optional beta attribute to value.
//
// value: An exponent.
// If not specified, defaults to 0.5
func LRNBeta(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["beta"] = value
	}
}

// Local Response Normalization.
//
// The 4-D `input` tensor is treated as a 3-D array of 1-D vectors (along the last
// dimension), and each vector is normalized independently.  Within a given vector,
// each component is divided by the weighted, squared sum of inputs within
// `depth_radius`.  In detail,
//
//     sqr_sum[a, b, c, d] =
//         sum(input[a, b, c, d - depth_radius : d + depth_radius + 1] ** 2)
//     output = input / (bias + alpha * sqr_sum) ** beta
//
// For details, see [Krizhevsky et al., ImageNet classification with deep
// convolutional neural networks (NIPS 2012)](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks).
//
// Arguments:
//	input: 4-D.
func LRN(scope *Scope, input tf.Output, optional ...LRNAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LRN",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropInputV2Attr is an optional argument to Conv3DBackpropInputV2.
type Conv3DBackpropInputV2Attr func(optionalAttr)

// Conv3DBackpropInputV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DBackpropInputV2DataFormat(value string) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropInputV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropInputV2Dilations(value []int64) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the tensor shape of `input`,
// where `input` is a 5-D
// `[batch, depth, rows, cols, in_channels]` tensor.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropInputV2(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropInputV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropInputV2",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterAttr is an optional argument to Conv3DBackpropFilter.
type Conv3DBackpropFilterAttr func(optionalAttr)

// Conv3DBackpropFilterDilations sets the optional dilations attribute to value.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropFilterDilations(value []int64) Conv3DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// DEPRECATED at GraphDef version 10: Use Conv3DBackpropFilterV2
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropInputAttr is an optional argument to Conv3DBackpropInput.
type Conv3DBackpropInputAttr func(optionalAttr)

// Conv3DBackpropInputDilations sets the optional dilations attribute to value.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropInputDilations(value []int64) Conv3DBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the input.
//
// DEPRECATED at GraphDef version 10: Use Conv3DBackpropInputV2
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropInput(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropInput",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DAttr is an optional argument to Conv3D.
type Conv3DAttr func(optionalAttr)

// Conv3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DDataFormat(value string) Conv3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DDilations(value []int64) Conv3DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 3-D convolution given 5-D `input` and `filter` tensors.
//
// In signal processing, cross-correlation is a measure of similarity of
// two waveforms as a function of a time-lag applied to one of them. This
// is also known as a sliding dot product or sliding inner-product.
//
// Our Conv3D implements a form of cross-correlation.
//
// Arguments:
//	input: Shape `[batch, in_depth, in_height, in_width, in_channels]`.
//	filter: Shape `[filter_depth, filter_height, filter_width, in_channels,
// out_channels]`. `in_channels` must match between `input` and `filter`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds a value to the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the incremented value or a subsequent newer one.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignAddVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignAddVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// DepthwiseConv2dNativeBackpropInputAttr is an optional argument to DepthwiseConv2dNativeBackpropInput.
type DepthwiseConv2dNativeBackpropInputAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropInputExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to <>
func DepthwiseConv2dNativeBackpropInputExplicitPaddings(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropInputDataFormat(value string) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func DepthwiseConv2dNativeBackpropInputDilations(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the shape of `input`, based
// on `data_format`.  For example, if `data_format` is 'NHWC' then
//  `input` is a 4-D `[batch, height, width, channels]` tensor.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, depthwise_multiplier]`.
//	out_backprop: 4-D with shape  based on `data_format`.
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape according to `data_format`.  For example, if
// `data_format` is 'NHWC', output shape is `[batch, in_height,
// in_width, in_channels]`.  Gradient w.r.t. the input of the
// convolution.
func DepthwiseConv2dNativeBackpropInput(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropInput",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthwiseConv2dNativeAttr is an optional argument to DepthwiseConv2dNative.
type DepthwiseConv2dNativeAttr func(optionalAttr)

// DepthwiseConv2dNativeExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to <>
func DepthwiseConv2dNativeExplicitPaddings(value []int64) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeDataFormat(value string) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func DepthwiseConv2dNativeDilations(value []int64) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D depthwise convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, channel_multiplier]`, containing
// `in_channels` convolutional filters of depth 1, `depthwise_conv2d` applies
// a different filter to each input channel (expanding from 1 channel to
// `channel_multiplier` channels for each), then concatenates the results
// together. Thus, the output has `in_channels * channel_multiplier` channels.
//
// ```
// for k in 0..in_channels-1
//   for q in 0..channel_multiplier-1
//     output[b, i, j, k * channel_multiplier + q] =
//       sum_{di, dj} input[b, strides[1] * i + di, strides[2] * j + dj, k] *
//                         filter[di, dj, k, q]
// ```
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
// of `input`.
//	padding: The type of padding algorithm to use.
func DepthwiseConv2dNative(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNative",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Component-wise multiplies a SparseTensor by a dense Tensor.
//
// The output locations corresponding to the implicitly zero elements in the sparse
// tensor will be zero (i.e., will not take up storage space), regardless of the
// contents of the dense tensor (even if it's +/-INF and that INF*0 == NaN).
//
// *Limitation*: this Op only broadcasts the dense side to the sparse side, but not
// the other direction.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseMul(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseMul",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Performs a padding as a preprocess during a convolution.
//
// Similar to FusedResizeAndPadConv2d, this op allows for an optimized
// implementation where the spatial padding transformation stage is fused with the
// im2col lookup, but in this case without the bilinear filtering required for
// resizing. Fusing the padding prevents the need to write out the intermediate
// results as whole tensors, reducing memory pressure, and we can get some latency
// gains by merging the transformation calculations.
// The data_format attribute for Conv2D isn't supported by this op, and 'NHWC'
// order is used instead.
// Internally this op uses a single per-graph scratch buffer, which means that it
// will block if multiple versions are being run in parallel. This is because this
// operator is primarily an optimization to minimize memory usage.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
// of `input`. Must be in the same order as the dimension specified with format.
//	padding: The type of padding algorithm to use.
func FusedPadConv2D(scope *Scope, input tf.Output, paddings tf.Output, filter tf.Output, mode string, strides []int64, padding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "FusedPadConv2D",
		Input: []tf.Input{
			input, paddings, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedResizeAndPadConv2DAttr is an optional argument to FusedResizeAndPadConv2D.
type FusedResizeAndPadConv2DAttr func(optionalAttr)

// FusedResizeAndPadConv2DResizeAlignCorners sets the optional resize_align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func FusedResizeAndPadConv2DResizeAlignCorners(value bool) FusedResizeAndPadConv2DAttr {
	return func(m optionalAttr) {
		m["resize_align_corners"] = value
	}
}

// Performs a resize and padding as a preprocess during a convolution.
//
// It's often possible to do spatial transformations more efficiently as part of
// the packing stage of a convolution, so this op allows for an optimized
// implementation where these stages are fused together. This prevents the need to
// write out the intermediate results as whole tensors, reducing memory pressure,
// and we can get some latency gains by merging the transformation calculations.
// The data_format attribute for Conv2D isn't supported by this op, and defaults to
// 'NHWC' order.
// Internally this op uses a single per-graph scratch buffer, which means that it
// will block if multiple versions are being run in parallel. This is because this
// operator is primarily an optimization to minimize memory usage.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	size: A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
// of `input`. Must be in the same order as the dimension specified with format.
//	padding: The type of padding algorithm to use.
func FusedResizeAndPadConv2D(scope *Scope, input tf.Output, size tf.Output, paddings tf.Output, filter tf.Output, mode string, strides []int64, padding string, optional ...FusedResizeAndPadConv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedResizeAndPadConv2D",
		Input: []tf.Input{
			input, size, paddings, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds Tensor 'bias' to Tensor 'input' for Quantized types.
//
// Broadcasts the values of bias on dimensions 0..N-2 of 'input'.
//
// Arguments:
//
//	bias: A 1D bias Tensor with size matching the last dimension of 'input'.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	min_bias: The float value that the lowest quantized bias value represents.
//	max_bias: The float value that the highest quantized bias value represents.
//
//
// Returns:
//	output
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedBiasAdd(scope *Scope, input tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_bias tf.Output, max_bias tf.Output, out_type tf.DataType) (output tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "QuantizedBiasAdd",
		Input: []tf.Input{
			input, bias, min_input, max_input, min_bias, max_bias,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DataFormatVecPermuteAttr is an optional argument to DataFormatVecPermute.
type DataFormatVecPermuteAttr func(optionalAttr)

// DataFormatVecPermuteSrcFormat sets the optional src_format attribute to value.
//
// value: source data format.
// If not specified, defaults to "NHWC"
func DataFormatVecPermuteSrcFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["src_format"] = value
	}
}

// DataFormatVecPermuteDstFormat sets the optional dst_format attribute to value.
//
// value: destination data format.
// If not specified, defaults to "NCHW"
func DataFormatVecPermuteDstFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["dst_format"] = value
	}
}

// Permute input tensor from `src_format` to `dst_format`.
//
// Input tensor must be a vector of size 4, or a 4x2 tensor.
//
// For example, with `src_format` of `NHWC`, `dst_format` of `NCHW`, and inputs:
// ```
// [1, 2, 3, 4]
// ```
// and
// ```
// [[1, 2, 3, 4],
//  [5, 6, 7, 8]]
// ```
// , the outputs will be (respectively):
// ```
// [1, 4, 2, 3]
// ```
// and
// ```
// [[1, 4, 2, 3],
//  [5, 8, 6, 7]]
// ```
//
// Arguments:
//	x: Vector of size 4 or Tensor of shape (4, 2) in source data format.
//
// Returns Vector of size 4 or Tensor of shape (4, 2) in destination data format.
func DataFormatVecPermute(scope *Scope, x tf.Output, optional ...DataFormatVecPermuteAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataFormatVecPermute",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataFormatDimMapAttr is an optional argument to DataFormatDimMap.
type DataFormatDimMapAttr func(optionalAttr)

// DataFormatDimMapSrcFormat sets the optional src_format attribute to value.
//
// value: source data format.
// If not specified, defaults to "NHWC"
func DataFormatDimMapSrcFormat(value string) DataFormatDimMapAttr {
	return func(m optionalAttr) {
		m["src_format"] = value
	}
}

// DataFormatDimMapDstFormat sets the optional dst_format attribute to value.
//
// value: destination data format.
// If not specified, defaults to "NCHW"
func DataFormatDimMapDstFormat(value string) DataFormatDimMapAttr {
	return func(m optionalAttr) {
		m["dst_format"] = value
	}
}

// Returns the dimension index in the destination data format given the one in
//
// the source data format.
//
// Arguments:
//	x: A Tensor with each element as a dimension index in source data format.
// Must be in the range [-4, 4).
//
// Returns A Tensor with each element as a dimension index in destination data format.
func DataFormatDimMap(scope *Scope, x tf.Output, optional ...DataFormatDimMapAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataFormatDimMap",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropFilterAttr is an optional argument to Conv2DBackpropFilter.
type Conv2DBackpropFilterAttr func(optionalAttr)

// Conv2DBackpropFilterUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropFilterUseCudnnOnGpu(value bool) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropFilterExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to <>
func Conv2DBackpropFilterExplicitPaddings(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func Conv2DBackpropFilterDataFormat(value string) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func Conv2DBackpropFilterDilations(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the filter.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, out_channels]` tensor.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution. Must be in the same order as the dimension specified with
// format.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func Conv2DBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds `bias` to `value`.
//
// This is a deprecated version of BiasAdd and will be soon removed.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAddV1(scope *Scope, value tf.Output, bias tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BiasAddV1",
		Input: []tf.Input{
			value, bias,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BiasAddGradAttr is an optional argument to BiasAddGrad.
type BiasAddGradAttr func(optionalAttr)

// BiasAddGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the bias tensor will be added to the last dimension
// of the value tensor.
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// The tensor will be added to "in_channels", the third-to-the-last
//     dimension.
// If not specified, defaults to "NHWC"
func BiasAddGradDataFormat(value string) BiasAddGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// The backward operation for "BiasAdd" on the "bias" tensor.
//
// It accumulates all the values from out_backprop into the feature dimension.
// For NHWC data format, the feature dimension is the last. For NCHW data format,
// the feature dimension is the third-to-last.
//
// Arguments:
//	out_backprop: Any number of dimensions.
//
// Returns 1-D with size the feature dimension of `out_backprop`.
func BiasAddGrad(scope *Scope, out_backprop tf.Output, optional ...BiasAddGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BiasAddGrad",
		Input: []tf.Input{
			out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BiasAddAttr is an optional argument to BiasAdd.
type BiasAddAttr func(optionalAttr)

// BiasAddDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the bias tensor will be added to the last dimension
// of the value tensor.
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// The tensor will be added to "in_channels", the third-to-the-last
//     dimension.
// If not specified, defaults to "NHWC"
func BiasAddDataFormat(value string) BiasAddAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Adds `bias` to `value`.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAdd(scope *Scope, value tf.Output, bias tf.Output, optional ...BiasAddAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BiasAdd",
		Input: []tf.Input{
			value, bias,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormGradV3Attr is an optional argument to FusedBatchNormGradV3.
type FusedBatchNormGradV3Attr func(optionalAttr)

// FusedBatchNormGradV3Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradV3Epsilon(value float32) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradV3DataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradV3DataFormat(value string) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradV3IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradV3IsTraining(value bool) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//	reserve_space_3: When is_training is True, a 1D Tensor for some intermediate results to be reused
// in gradient computation. When is_training is False, a dummy empty Tensor will be
// created.
//
// Returns:
//	x_backprop: A 4D Tensor for the gradient with respect to x.
//	scale_backprop: A 1D Tensor for the gradient with respect to scale.
//	offset_backprop: A 1D Tensor for the gradient with respect to offset.
//	reserve_space_4: Unused placeholder to match the mean input in FusedBatchNorm.
//	reserve_space_5: Unused placeholder to match the variance input
// in FusedBatchNorm.
func FusedBatchNormGradV3(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, reserve_space_3 tf.Output, optional ...FusedBatchNormGradV3Attr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_4 tf.Output, reserve_space_5 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGradV3",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2, reserve_space_3,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Adds up a SparseTensor and a dense Tensor, using these special rules:
//
// (1) Broadcasts the dense side to have the same shape as the sparse side, if
//     eligible;
// (2) Then, only the dense values pointed to by the indices of the SparseTensor
//     participate in the cwise addition.
//
// By these rules, the result is a logical SparseTensor with exactly the same
// indices and shape, but possibly with different non-zero values.  The output of
// this Op is the resultant non-zero values.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseAdd(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseAdd",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gradients for batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. See `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this Tensor will be multiplied
// with the normalized Tensor.
//	backprop: 4D backprop Tensor.
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
//
// Returns:
//	dx: 4D backprop tensor for input.
//	dm: 1D backprop tensor for mean.
//	dv: 1D backprop tensor for variance.
//	db: 1D backprop tensor for beta.
//	dg: 1D backprop tensor for gamma.
func BatchNormWithGlobalNormalizationGrad(scope *Scope, t tf.Output, m tf.Output, v tf.Output, gamma tf.Output, backprop tf.Output, variance_epsilon float32, scale_after_normalization bool) (dx tf.Output, dm tf.Output, dv tf.Output, db tf.Output, dg tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalizationGrad",
		Input: []tf.Input{
			t, m, v, gamma, backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Conv2DAttr is an optional argument to Conv2D.
type Conv2DAttr func(optionalAttr)

// Conv2DUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DUseCudnnOnGpu(value bool) Conv2DAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to <>
func Conv2DExplicitPaddings(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func Conv2DDataFormat(value string) Conv2DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func Conv2DDilations(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`, this op
// performs the following:
//
// 1. Flattens the filter to a 2-D matrix with shape
//    `[filter_height * filter_width * in_channels, output_channels]`.
// 2. Extracts image patches from the input tensor to form a *virtual*
//    tensor of shape `[batch, out_height, out_width,
//    filter_height * filter_width * in_channels]`.
// 3. For each patch, right-multiplies the filter matrix and the image patch
//    vector.
//
// In detail, with the default NHWC format,
//
//     output[b, i, j, k] =
//         sum_{di, dj, q} input[b, strides[1] * i + di, strides[2] * j + dj, q] *
//                         filter[di, dj, q, k]
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//	input: A 4-D tensor. The dimension order is interpreted according to the value
// of `data_format`, see below for details.
//	filter: A 4-D tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`
//	strides: 1-D tensor of length 4.  The stride of the sliding window for each
// dimension of `input`. The dimension order is determined by the value of
// `data_format`, see below for details.
//	padding: The type of padding algorithm to use.
//
// Returns A 4-D tensor. The dimension order is determined by the value of
// `data_format`, see below for details.
func Conv2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// The graph should be constructed so that all inputs have a valid device
// assignment, and the op itself is assigned one of these devices.
//
// input: The input to the reduction.
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
func NcclReduce(scope *Scope, input []tf.Output, reduction string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction}
	opspec := tf.OpSpec{
		Type: "NcclReduce",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedReluAttr is an optional argument to QuantizedRelu.
type QuantizedReluAttr func(optionalAttr)

// QuantizedReluOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedReluOutType(value tf.DataType) QuantizedReluAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear: `max(features, 0)`
//
// Arguments:
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns:
//	activations: Has the same output shape as "features".
//	min_activations: The float value that the lowest quantized value represents.
//	max_activations: The float value that the highest quantized value represents.
func QuantizedRelu(scope *Scope, features tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedReluAttr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedRelu",
		Input: []tf.Input{
			features, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Returns the next representable value of `x1` in the direction of `x2`, element-wise.
//
// This operation returns the same result as the C++ std::nextafter function.
//
// It can also return a subnormal number.
//
// @compatibility(cpp)
// Equivalent to C++ std::nextafter function.
// @end_compatibility
func NextAfter(scope *Scope, x1 tf.Output, x2 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NextAfter",
		Input: []tf.Input{
			x1, x2,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RequantizePerChannelAttr is an optional argument to RequantizePerChannel.
type RequantizePerChannelAttr func(optionalAttr)

// RequantizePerChannelOutType sets the optional out_type attribute to value.
//
// value: The quantized type of output tensor that needs to be converted.
// If not specified, defaults to DT_QUINT8
func RequantizePerChannelOutType(value tf.DataType) RequantizePerChannelAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Requantizes input with min and max values known per channel.
//
// Arguments:
//	input: The original input tensor.
//	input_min: The minimum value of the input tensor
//	input_max: The maximum value of the input tensor.
//	requested_output_min: The minimum value of the output tensor requested.
//	requested_output_max: The maximum value of the output tensor requested.
//
// Returns:
//	output: Output tensor.
//	output_min: The minimum value of the final output tensor
//	output_max: The maximum value of the final output tensor.
func RequantizePerChannel(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, requested_output_min tf.Output, requested_output_max tf.Output, optional ...RequantizePerChannelAttr) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RequantizePerChannel",
		Input: []tf.Input{
			input, input_min, input_max, requested_output_min, requested_output_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Bucketizes 'input' based on 'boundaries'.
//
// For example, if the inputs are
//     boundaries = [0, 10, 100]
//     input = [[-5, 10000]
//              [150,   10]
//              [5,    100]]
//
// then the output will be
//     output = [[0, 3]
//               [3, 2]
//               [1, 3]]
//
// Arguments:
//	input: Any shape of Tensor contains with int or float type.
//	boundaries: A sorted list of floats gives the boundary of the buckets.
//
// Returns Same shape with 'input', each value of input replaced with bucket index.
//
// @compatibility(numpy)
// Equivalent to np.digitize.
// @end_compatibility
func Bucketize(scope *Scope, input tf.Output, boundaries []float32) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"boundaries": boundaries}
	opspec := tf.OpSpec{
		Type: "Bucketize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts each string in the input Tensor to its hash mod by a number of buckets.
//
// The hash function is deterministic on the content of the string within the
// process.
//
// Note that the hash function may change from time to time.
// This functionality will be deprecated and it's recommended to use
// `tf.string_to_hash_bucket_fast()` or `tf.string_to_hash_bucket_strong()`.
//
// Arguments:
//
//	num_buckets: The number of buckets.
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToHashBucket(scope *Scope, string_tensor tf.Output, num_buckets int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "StringToHashBucket",
		Input: []tf.Input{
			string_tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softsign: `features / (abs(features) + 1)`.
func Softsign(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softsign",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedAddAttr is an optional argument to QuantizedAdd.
type QuantizedAddAttr func(optionalAttr)

// QuantizedAddToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedAddToutput(value tf.DataType) QuantizedAddAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// Returns x + y element-wise, working on quantized buffers.
//
// Arguments:
//
//
//	min_x: The float value that the lowest quantized `x` value represents.
//	max_x: The float value that the highest quantized `x` value represents.
//	min_y: The float value that the lowest quantized `y` value represents.
//	max_y: The float value that the highest quantized `y` value represents.
//
// Returns:
//	z
//	min_z: The float value that the lowest quantized output value represents.
//	max_z: The float value that the highest quantized output value represents.
//
// *NOTE*: `QuantizedAdd` supports limited forms of broadcasting. More about
// broadcasting [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func QuantizedAdd(scope *Scope, x tf.Output, y tf.Output, min_x tf.Output, max_x tf.Output, min_y tf.Output, max_y tf.Output, optional ...QuantizedAddAttr) (z tf.Output, min_z tf.Output, max_z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedAdd",
		Input: []tf.Input{
			x, y, min_x, max_x, min_y, max_y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedMatMulAttr is an optional argument to QuantizedMatMul.
type QuantizedMatMulAttr func(optionalAttr)

// QuantizedMatMulToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMatMulToutput(value tf.DataType) QuantizedMatMulAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulTransposeA(value bool) QuantizedMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulTransposeB(value bool) QuantizedMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulTactivation sets the optional Tactivation attribute to value.
//
// value: The type of output produced by activation function
// following this operation.
// If not specified, defaults to DT_QUINT8
func QuantizedMatMulTactivation(value tf.DataType) QuantizedMatMulAttr {
	return func(m optionalAttr) {
		m["Tactivation"] = value
	}
}

// Perform a quantized matrix multiplication of  `a` by the matrix `b`.
//
// The inputs must be two-dimensional matrices and the inner dimension of
// `a` (after being transposed if `transpose_a` is non-zero) must match the
// outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero).
//
// Arguments:
//	a: Must be a two-dimensional tensor.
//	b: Must be a two-dimensional tensor.
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//
// Returns:
//	out
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedMatMul(scope *Scope, a tf.Output, b tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, optional ...QuantizedMatMulAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMul",
		Input: []tf.Input{
			a, b, min_a, max_a, min_b, max_b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// CumulativeLogsumexpAttr is an optional argument to CumulativeLogsumexp.
type CumulativeLogsumexpAttr func(optionalAttr)

// CumulativeLogsumexpExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumulative log-sum-exp.
// If not specified, defaults to false
func CumulativeLogsumexpExclusive(value bool) CumulativeLogsumexpAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumulativeLogsumexpReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumulativeLogsumexpReverse(value bool) CumulativeLogsumexpAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative product of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumulative log-sum-exp,
// which means that the first
// element of the input is identical to the first element of the output:
// ```python
// tf.math.cumulative_logsumexp([a, b, c])  # => [a, log(exp(a) + exp(b)), log(exp(a) + exp(b) + exp(c))]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumulative log-sum-exp is
// performed instead:
// ```python
// tf.cumulative_logsumexp([a, b, c], exclusive=True)  # => [-inf, a, log(exp(a) * exp(b))]
// ```
// Note that the neutral element of the log-sum-exp operation is `-inf`,
// however, for performance reasons, the minimal value representable by the
// floating point type is used instead.
//
// By setting the `reverse` kwarg to `True`, the cumulative log-sum-exp is performed in the
// opposite direction.
//
// Arguments:
//	x: A `Tensor`. Must be one of the following types: `float16`, `float32`, `float64`.
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
// `[-rank(x), rank(x))`.
func CumulativeLogsumexp(scope *Scope, x tf.Output, axis tf.Output, optional ...CumulativeLogsumexpAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CumulativeLogsumexp",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CumprodAttr is an optional argument to Cumprod.
type CumprodAttr func(optionalAttr)

// CumprodExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumprod.
// If not specified, defaults to false
func CumprodExclusive(value bool) CumprodAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumprodReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumprodReverse(value bool) CumprodAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative product of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumprod, which means that the first
// element of the input is identical to the first element of the output:
//
// ```python
// tf.cumprod([a, b, c])  # => [a, a * b, a * b * c]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumprod is
// performed instead:
//
// ```python
// tf.cumprod([a, b, c], exclusive=True)  # => [1, a, a * b]
// ```
//
// By setting the `reverse` kwarg to `True`, the cumprod is performed in the
// opposite direction:
//
// ```python
// tf.cumprod([a, b, c], reverse=True)  # => [a * b * c, b * c, c]
// ```
//
// This is more efficient than using separate `tf.reverse` ops.
//
// The `reverse` and `exclusive` kwargs can also be combined:
//
// ```python
// tf.cumprod([a, b, c], exclusive=True, reverse=True)  # => [b * c, c, 1]
// ```
//
// Arguments:
//	x: A `Tensor`. Must be one of the following types: `float32`, `float64`,
// `int64`, `int32`, `uint8`, `uint16`, `int16`, `int8`, `complex64`,
// `complex128`, `qint8`, `quint8`, `qint32`, `half`.
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
// `[-rank(x), rank(x))`.
func Cumprod(scope *Scope, x tf.Output, axis tf.Output, optional ...CumprodAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cumprod",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Performs gradient updates of embedding tables.
//
// Arguments:
//	inputs: A TensorList of gradients with which to update embedding tables.
// This argument has the same length and shapes as the return value of
// RecvTPUEmbeddingActivations, but contains gradients of the model's loss
// with respect to the embedding activations. The embedding tables are updated
// from these gradients via the optimizer specified in the TPU embedding
// configuration given to tpu.initialize_system.
//	learning_rates: A TensorList of float32 scalars, one for each dynamic learning
// rate tag: see the comments in
// //third_party/tensorflow/core/protobuf/tpu/optimization_parameters.proto.
// Multiple tables can share the same dynamic learning rate tag as specified
// in the configuration. If the learning rates for all tables are constant,
// this list should be empty.
//	config: Serialized TPUEmbeddingConfiguration proto.
//
// Returns the created operation.
func SendTPUEmbeddingGradients(scope *Scope, inputs []tf.Output, learning_rates []tf.Output, config string) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "SendTPUEmbeddingGradients",
		Input: []tf.Input{
			tf.OutputList(inputs), tf.OutputList(learning_rates),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// CumsumAttr is an optional argument to Cumsum.
type CumsumAttr func(optionalAttr)

// CumsumExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumsum.
// If not specified, defaults to false
func CumsumExclusive(value bool) CumsumAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumsumReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumsumReverse(value bool) CumsumAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative sum of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumsum, which means that the first
// element of the input is identical to the first element of the output:
//
// ```python
// tf.cumsum([a, b, c])  # => [a, a + b, a + b + c]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumsum is
// performed instead:
//
// ```python
// tf.cumsum([a, b, c], exclusive=True)  # => [0, a, a + b]
// ```
//
// By setting the `reverse` kwarg to `True`, the cumsum is performed in the
// opposite direction:
//
// ```python
// tf.cumsum([a, b, c], reverse=True)  # => [a + b + c, b + c, c]
// ```
//
// This is more efficient than using separate `tf.reverse` ops.
//
// The `reverse` and `exclusive` kwargs can also be combined:
//
// ```python
// tf.cumsum([a, b, c], exclusive=True, reverse=True)  # => [b + c, c, 0]
// ```
//
// Arguments:
//	x: A `Tensor`. Must be one of the following types: `float32`, `float64`,
// `int64`, `int32`, `uint8`, `uint16`, `int16`, `int8`, `complex64`,
// `complex128`, `qint8`, `quint8`, `qint32`, `half`.
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
// `[-rank(x), rank(x))`.
func Cumsum(scope *Scope, x tf.Output, axis tf.Output, optional ...CumsumAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cumsum",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RaggedBincountAttr is an optional argument to RaggedBincount.
type RaggedBincountAttr func(optionalAttr)

// RaggedBincountBinaryOutput sets the optional binary_output attribute to value.
//
// value: bool; Whether the kernel should count the appearance or number of occurrences.
// If not specified, defaults to false
func RaggedBincountBinaryOutput(value bool) RaggedBincountAttr {
	return func(m optionalAttr) {
		m["binary_output"] = value
	}
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	splits: 1D int64 `Tensor`.
//	values: 2D int `Tensor`.
//	size: non-negative int scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `input`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size` or 2D `Tensor` with [batch_size, `size`].
// The counts or summed weights for each value in the range [0, size).
func RaggedBincount(scope *Scope, splits tf.Output, values tf.Output, size tf.Output, weights tf.Output, optional ...RaggedBincountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedBincount",
		Input: []tf.Input{
			splits, values, size, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseBincountAttr is an optional argument to SparseBincount.
type SparseBincountAttr func(optionalAttr)

// SparseBincountBinaryOutput sets the optional binary_output attribute to value.
//
// value: bool; Whether the kernel should count the appearance or number of occurrences.
// If not specified, defaults to false
func SparseBincountBinaryOutput(value bool) SparseBincountAttr {
	return func(m optionalAttr) {
		m["binary_output"] = value
	}
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	indices: 2D int64 `Tensor`.
//	values: 1D int `Tensor`.
//	dense_shape: 1D int64 `Tensor`.
//	size: non-negative int scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `input`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size` or 2D `Tensor` with [batch_size, `size`].
// The counts or summed weights for each value in the range [0, size).
func SparseBincount(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output, size tf.Output, weights tf.Output, optional ...SparseBincountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseBincount",
		Input: []tf.Input{
			indices, values, dense_shape, size, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes scaled exponential linear: `scale * alpha * (exp(features) - 1)`
//
// if < 0, `scale * features` otherwise.
//
// To be used together with
// `initializer = tf.variance_scaling_initializer(factor=1.0, mode='FAN_IN')`.
// For correct dropout, use `tf.contrib.nn.alpha_dropout`.
//
// See [Self-Normalizing Neural Networks](https://arxiv.org/abs/1706.02515)
func Selu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Selu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseBincountAttr is an optional argument to DenseBincount.
type DenseBincountAttr func(optionalAttr)

// DenseBincountBinaryOutput sets the optional binary_output attribute to value.
//
// value: bool; Whether the kernel should count the appearance or number of occurrences.
// If not specified, defaults to false
func DenseBincountBinaryOutput(value bool) DenseBincountAttr {
	return func(m optionalAttr) {
		m["binary_output"] = value
	}
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	input: 1D or 2D int `Tensor`.
//	size: non-negative int scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `arr`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size` or 2D `Tensor` with [batch_size, `size`].
// The counts or summed weights for each value in the range [0, size).
func DenseBincount(scope *Scope, input tf.Output, size tf.Output, weights tf.Output, optional ...DenseBincountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseBincount",
		Input: []tf.Input{
			input, size, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	arr: int32 `Tensor`.
//	size: non-negative int32 scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `arr`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size`. The counts or summed weights for
// each value in the range [0, size).
func Bincount(scope *Scope, arr tf.Output, size tf.Output, weights tf.Output) (bins tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Bincount",
		Input: []tf.Input{
			arr, size, weights,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DestroyResourceOpAttr is an optional argument to DestroyResourceOp.
type DestroyResourceOpAttr func(optionalAttr)

// DestroyResourceOpIgnoreLookupError sets the optional ignore_lookup_error attribute to value.
//
// value: whether to ignore the error when the resource
// doesn't exist.
// If not specified, defaults to true
func DestroyResourceOpIgnoreLookupError(value bool) DestroyResourceOpAttr {
	return func(m optionalAttr) {
		m["ignore_lookup_error"] = value
	}
}

// Deletes the resource specified by the handle.
//
// All subsequent operations using the resource will result in a NotFound
// error status.
//
// Arguments:
//	resource: handle to the resource to delete.
//
// Returns the created operation.
func DestroyResourceOp(scope *Scope, resource tf.Output, optional ...DestroyResourceOpAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DestroyResourceOp",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// HistogramFixedWidthAttr is an optional argument to HistogramFixedWidth.
type HistogramFixedWidthAttr func(optionalAttr)

// HistogramFixedWidthDtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_INT32
func HistogramFixedWidthDtype(value tf.DataType) HistogramFixedWidthAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Return histogram of values.
//
// Given the tensor `values`, this operation returns a rank 1 histogram counting
// the number of entries in `values` that fall into every bin.  The bins are
// equal width and determined by the arguments `value_range` and `nbins`.
//
// ```python
// # Bins will be:  (-inf, 1), [1, 2), [2, 3), [3, 4), [4, inf)
// nbins = 5
// value_range = [0.0, 5.0]
// new_values = [-1.0, 0.0, 1.5, 2.0, 5.0, 15]
//
// with tf.get_default_session() as sess:
//   hist = tf.histogram_fixed_width(new_values, value_range, nbins=5)
//   variables.global_variables_initializer().run()
//   sess.run(hist) => [2, 1, 1, 0, 2]
// ```
//
// Arguments:
//	values: Numeric `Tensor`.
//	value_range: Shape [2] `Tensor` of same `dtype` as `values`.
// values <= value_range[0] will be mapped to hist[0],
// values >= value_range[1] will be mapped to hist[-1].
//	nbins: Scalar `int32 Tensor`.  Number of histogram bins.
//
// Returns A 1-D `Tensor` holding histogram of values.
func HistogramFixedWidth(scope *Scope, values tf.Output, value_range tf.Output, nbins tf.Output, optional ...HistogramFixedWidthAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "HistogramFixedWidth",
		Input: []tf.Input{
			values, value_range, nbins,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the pairwise cross product.
//
// `a` and `b` must be the same shape; they can either be simple 3-element vectors,
// or any shape where the innermost dimension is 3. In the latter case, each pair
// of corresponding 3-element vectors is cross-multiplied independently.
//
// Arguments:
//	a: A tensor containing 3-element vectors.
//	b: Another tensor, of same type and shape as `a`.
//
// Returns Pairwise cross product of the vectors in `a` and `b`.
func Cross(scope *Scope, a tf.Output, b tf.Output) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cross",
		Input: []tf.Input{
			a, b,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the complex conjugate of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// complex numbers that are the complex conjugate of each element in `input`. The
// complex numbers in `input` must be of the form \\(a + bj\\), where *a* is the
// real part and *b* is the imaginary part.
//
// The complex conjugate returned by this operation is of the form \\(a - bj\\).
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.conj(input) ==> [-2.25 - 4.75j, 3.25 - 5.75j]
// ```
func Conj(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Conj",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AngleAttr is an optional argument to Angle.
type AngleAttr func(optionalAttr)

// AngleTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func AngleTout(value tf.DataType) AngleAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the argument of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the argument of each element in `input`. All elements in
// `input` must be complex numbers of the form \\(a + bj\\), where *a*
// is the real part and *b* is the imaginary part.
//
// The argument returned by this operation is of the form \\(atan2(b, a)\\).
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.angle(input) ==> [2.0132, 1.056]
// ```
//
// @compatibility(numpy)
// Equivalent to np.angle.
// @end_compatibility
func Angle(scope *Scope, input tf.Output, optional ...AngleAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Angle",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ImagAttr is an optional argument to Imag.
type ImagAttr func(optionalAttr)

// ImagTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func ImagTout(value tf.DataType) ImagAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the imaginary part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the imaginary part of each element in `input`. All
// elements in `input` must be complex numbers of the form \\(a + bj\\), where *a*
// is the real part and *b* is the imaginary part returned by this operation.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.imag(input) ==> [4.75, 5.75]
// ```
func Imag(scope *Scope, input tf.Output, optional ...ImagAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Imag",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates values in an interval.
//
// A sequence of `num` evenly-spaced values are generated beginning at `start`.
// If `num > 1`, the values in the sequence increase by `stop - start / num - 1`,
// so that the last one is exactly `stop`.
//
// For example:
//
// ```
// tf.linspace(10.0, 12.0, 3, name="linspace") => [ 10.0  11.0  12.0]
// ```
//
// Arguments:
//	start: 0-D tensor. First entry in the range.
//	stop: 0-D tensor. Last entry in the range.
//	num: 0-D tensor. Number of values to generate.
//
// Returns 1-D. The generated values.
func LinSpace(scope *Scope, start tf.Output, stop tf.Output, num tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LinSpace",
		Input: []tf.Input{
			start, stop, num,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AnyAttr is an optional argument to Any.
type AnyAttr func(optionalAttr)

// AnyKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func AnyKeepDims(value bool) AnyAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the "logical or" of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Any(scope *Scope, input tf.Output, axis tf.Output, optional ...AnyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Any",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the input.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
// Must be: `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, depth]`.
func Dilation2DBackpropInput(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (in_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropInput",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AllAttr is an optional argument to All.
type AllAttr func(optionalAttr)

// AllKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func AllKeepDims(value bool) AllAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the "logical and" of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func All(scope *Scope, input tf.Output, axis tf.Output, optional ...AllAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "All",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for SparseSegmentSqrtN.
//
// Returns tensor "output" with same shape as grad, except for dimension 0 whose
// value is output_dim0.
//
// Arguments:
//	grad: gradient propagated to the SparseSegmentSqrtN op.
//	indices: indices passed to the corresponding SparseSegmentSqrtN op.
//	segment_ids: segment_ids passed to the corresponding SparseSegmentSqrtN op.
//	output_dim0: dimension 0 of "data" passed to SparseSegmentSqrtN op.
func SparseSegmentSqrtNGrad(scope *Scope, grad tf.Output, indices tf.Output, segment_ids tf.Output, output_dim0 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSqrtNGrad",
		Input: []tf.Input{
			grad, indices, segment_ids, output_dim0,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the mean along sparse segments of a tensor.
//
// See `tf.sparse.segment_sum` for usage examples.
//
// Like `SegmentMean`, but `segment_ids` can have rank less than `data`'s first
// dimension, selecting a subset of dimension 0, specified by `indices`.
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SparseSegmentMean(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentMean",
		Input: []tf.Input{
			data, indices, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for SparseSegmentSum.
//
// Returns tensor "output" with same shape as grad, except for dimension 0 whose
// value is output_dim0.
//
// Arguments:
//	grad: gradient propagated to the SparseSegmentSum op.
//	indices: indices passed to the corresponding SparseSegmentSum op.
//	segment_ids: segment_ids passed to the corresponding SparseSegmentSum op.
//	output_dim0: dimension 0 of "data" passed to SparseSegmentSum op.
func SparseSegmentSumGrad(scope *Scope, grad tf.Output, indices tf.Output, segment_ids tf.Output, output_dim0 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSumGrad",
		Input: []tf.Input{
			grad, indices, segment_ids, output_dim0,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sum along sparse segments of a tensor.
//
// Like `SparseSegmentSum`, but allows missing ids in `segment_ids`. If an id is
// missing, the `output` tensor at that position will be zeroed.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/sparse#Segmentation)
// for an explanation of segments.
//
// For example:
//
// ```python
// c = tf.constant([[1,2,3,4], [-1,-2,-3,-4], [5,6,7,8]])
//
// tf.sparse_segment_sum_with_num_segments(
//     c, tf.constant([0, 1]), tf.constant([0, 0]), num_segments=3)
// # => [[0 0 0 0]
// #     [0 0 0 0]
// #     [0 0 0 0]]
//
// tf.sparse_segment_sum_with_num_segments(c,
//                                         tf.constant([0, 1]),
//                                         tf.constant([0, 2],
//                                         num_segments=4))
// # => [[ 1  2  3  4]
// #     [ 0  0  0  0]
// #     [-1 -2 -3 -4]
// #     [ 0  0  0  0]]
// ```
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//	num_segments: Should equal the number of distinct segment IDs.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `num_segments`.
func SparseSegmentSumWithNumSegments(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSumWithNumSegments",
		Input: []tf.Input{
			data, indices, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the product along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// This operator is similar to the unsorted segment sum operator found
// [(here)](../../../api_docs/python/math_ops.md#UnsortedSegmentSum).
// Instead of computing the sum over segments, it computes the product of all
// entries belonging to a segment such that:
//
// \\(output_i = \prod_{j...} data[j...]\\) where the product is over tuples
// `j...` such that `segment_ids[j...] == i`.
//
// For example:
//
// ``` python
// c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
// tf.unsorted_segment_prod(c, tf.constant([0, 1, 0]), num_segments=2)
// # ==> [[ 4,  6, 6, 4],
// #       [5,  6, 7, 8]]
// ```
//
// If there is no entry for a given segment ID `i`, it outputs 1.
//
// If the given segment ID `i` is negative, then the corresponding value is
// dropped, and will not be included in the result.
//
// Arguments:
//
//	segment_ids: A tensor whose shape is a prefix of `data.shape`.
//
//
// Returns Has same shape as data, except for the first `segment_ids.rank`
// dimensions, which are replaced with a single dimension which has size
// `num_segments`.
func UnsortedSegmentProd(scope *Scope, data tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnsortedSegmentProd",
		Input: []tf.Input{
			data, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceScatterNdSubAttr is an optional argument to ResourceScatterNdSub.
type ResourceScatterNdSubAttr func(optionalAttr)

// ResourceScatterNdSubUseLocking sets the optional use_locking attribute to value.
//
// value: An optional bool. Defaults to True. If True, the assignment will
// be protected by a lock; otherwise the behavior is undefined,
// but may exhibit less contention.
// If not specified, defaults to true
func ResourceScatterNdSubUseLocking(value bool) ResourceScatterNdSubAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Applies sparse subtraction to individual values or slices in a Variable.
//
// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `ref`.
// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
// dimension of `ref`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// ```
// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
// ```
//
// For example, say we want to subtract 4 scattered elements from a rank-1 tensor
// with 8 elements. In Python, that subtraction would look like this:
//
// ```python
// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
// indices = tf.constant([[4], [3], [1], [7]])
// updates = tf.constant([9, 10, 11, 12])
// sub = tf.scatter_nd_sub(ref, indices, updates)
// with tf.Session() as sess:
//   print sess.run(sub)
// ```
//
// The resulting update to ref would look like this:
//
//     [1, -9, 3, -6, -4, 6, 7, -4]
//
// See `tf.scatter_nd` for more details about how to make updates to
// slices.
//
// Arguments:
//	ref: A resource handle. Must be from a VarHandleOp.
//	indices: A Tensor. Must be one of the following types: int32, int64.
// A tensor of indices into ref.
//	updates: A Tensor. Must have the same type as ref. A tensor of
// values to add to ref.
//
// Returns the created operation.
func ResourceScatterNdSub(scope *Scope, ref tf.Output, indices tf.Output, updates tf.Output, optional ...ResourceScatterNdSubAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterNdSub",
		Input: []tf.Input{
			ref, indices, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the minimum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// This operator is similar to the unsorted segment sum operator found
// [(here)](../../../api_docs/python/math_ops.md#UnsortedSegmentSum).
// Instead of computing the sum over segments, it computes the minimum such that:
//
// \\(output_i = \min_{j...} data_[j...]\\) where min is over tuples `j...` such
// that `segment_ids[j...] == i`.
//
// If the minimum is empty for a given segment ID `i`, it outputs the largest
// possible value for the specific numeric type,
// `output[i] = numeric_limits<T>::max()`.
//
// For example:
//
// ``` python
// c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
// tf.unsorted_segment_min(c, tf.constant([0, 1, 0]), num_segments=2)
// # ==> [[ 1,  2, 2, 1],
// #       [5,  6, 7, 8]]
// ```
//
// If the given segment ID `i` is negative, then the corresponding value is
// dropped, and will not be included in the result.
//
// Arguments:
//
//	segment_ids: A tensor whose shape is a prefix of `data.shape`.
//
//
// Returns Has same shape as data, except for the first `segment_ids.rank`
// dimensions, which are replaced with a single dimension which has size
// `num_segments`.
func UnsortedSegmentMin(scope *Scope, data tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnsortedSegmentMin",
		Input: []tf.Input{
			data, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the maximum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// This operator is similar to the unsorted segment sum operator found
// [(here)](../../../api_docs/python/math_ops.md#UnsortedSegmentSum).
// Instead of computing the sum over segments, it computes the maximum such that:
//
// \\(output_i = \max_{j...} data[j...]\\) where max is over tuples `j...` such
// that `segment_ids[j...] == i`.
//
// If the maximum is empty for a given segment ID `i`, it outputs the smallest
// possible value for the specific numeric type,
// `output[i] = numeric_limits<T>::lowest()`.
//
// If the given segment ID `i` is negative, then the corresponding value is
// dropped, and will not be included in the result.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentMax.png" alt>
// </div>
//
// For example:
//
// ``` python
// c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
// tf.unsorted_segment_max(c, tf.constant([0, 1, 0]), num_segments=2)
// # ==> [[ 4,  3, 3, 4],
// #       [5,  6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A tensor whose shape is a prefix of `data.shape`.
//
//
// Returns Has same shape as data, except for the first `segment_ids.rank`
// dimensions, which are replaced with a single dimension which has size
// `num_segments`.
func UnsortedSegmentMax(scope *Scope, data tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnsortedSegmentMax",
		Input: []tf.Input{
			data, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the minimum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
// that `segment_ids[j] == i`.
//
// If the min is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMin.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_min(c, tf.constant([0, 0, 1]))
// # ==> [[1, 2, 2, 1],
// #      [5, 6, 7, 8]]
// ```
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMin(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMin",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the mean along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \frac{\sum_j data_j}{N}\\) where `mean` is
// over `j` such that `segment_ids[j] == i` and `N` is the total number of
// values summed.
//
// If the mean is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMean.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1.0,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_mean(c, tf.constant([0, 0, 1]))
// # ==> [[2.5, 2.5, 2.5, 2.5],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMean(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMean",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyAdamWithAmsgradAttr is an optional argument to ResourceApplyAdamWithAmsgrad.
type ResourceApplyAdamWithAmsgradAttr func(optionalAttr)

// ResourceApplyAdamWithAmsgradUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdamWithAmsgradUseLocking(value bool) ResourceApplyAdamWithAmsgradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the Adam algorithm.
//
// $$\text{lr}_t := \mathrm{learning_rate} * \sqrt{1 - \beta_2^t} / (1 - \beta_1^t)$$
// $$m_t := \beta_1 * m_{t-1} + (1 - \beta_1) * g$$
// $$v_t := \beta_2 * v_{t-1} + (1 - \beta_2) * g * g$$
// $$\hat{v}_t := max{\hat{v}_{t-1}, v_t}$$
// $$\text{variable} := \text{variable} - \text{lr}_t * m_t / (\sqrt{\hat{v}_t} + \epsilon)$$
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	vhat: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	beta2_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdamWithAmsgrad(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, vhat tf.Output, beta1_power tf.Output, beta2_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdamWithAmsgradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdamWithAmsgrad",
		Input: []tf.Input{
			var_, m, v, vhat, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the sum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \sum_j data_j\\) where sum is over `j` such
// that `segment_ids[j] == i`.
//
// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentSum.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_sum(c, tf.constant([0, 0, 1]))
// # ==> [[5, 5, 5, 5],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentSum(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentSum",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ArgMinAttr is an optional argument to ArgMin.
type ArgMinAttr func(optionalAttr)

// ArgMinOutputType sets the optional output_type attribute to value.
// If not specified, defaults to DT_INT64
func ArgMinOutputType(value tf.DataType) ArgMinAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Returns the index with the smallest value across dimensions of a tensor.
//
// Note that in case of ties the identity of the return value is not guaranteed.
//
// Usage:
//   ```python
//   import tensorflow as tf
//   a = [1, 10, 26.9, 2.8, 166.32, 62.3]
//   b = tf.math.argmin(input = a)
//   c = tf.keras.backend.eval(b)
//   # c = 0
//   # here a[0] = 1 which is the smallest element of a across axis 0
//   ```
//
// Arguments:
//
//	dimension: int32 or int64, must be in the range `[-rank(input), rank(input))`.
// Describes which dimension of the input Tensor to reduce across. For vectors,
// use dimension = 0.
func ArgMin(scope *Scope, input tf.Output, dimension tf.Output, optional ...ArgMinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ArgMin",
		Input: []tf.Input{
			input, dimension,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SumAttr is an optional argument to Sum.
type SumAttr func(optionalAttr)

// SumKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SumKeepDims(value bool) SumAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Sum(scope *Scope, input tf.Output, axis tf.Output, optional ...SumAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Sum",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Selects elements from `x` or `y`, depending on `condition`.
//
// The `x`, and `y` tensors must all have the same shape, and the
// output will also have that shape.
//
// The `condition` tensor must be a scalar if `x` and `y` are scalars.
// If `x` and `y` are vectors or higher rank, then `condition` must be either a
// scalar, a vector with size matching the first dimension of `x`, or must have
// the same shape as `x`.
//
// The `condition` tensor acts as a mask that chooses, based on the value at each
// element, whether the corresponding element / row in the output should be
// taken from `x` (if true) or `y` (if false).
//
// If `condition` is a vector and `x` and `y` are higher rank matrices, then
// it chooses which row (outer dimension) to copy from `x` and `y`.
// If `condition` has the same shape as `x` and `y`, then it chooses which
// element to copy from `x` and `y`.
//
// For example:
//
// ```python
// # 'condition' tensor is [[True,  False]
// #                        [False, True]]
// # 't' is [[1, 2],
// #         [3, 4]]
// # 'e' is [[5, 6],
// #         [7, 8]]
// select(condition, t, e)  # => [[1, 6], [7, 4]]
//
//
// # 'condition' tensor is [True, False]
// # 't' is [[1, 2],
// #         [3, 4]]
// # 'e' is [[5, 6],
// #         [7, 8]]
// select(condition, t, e) ==> [[1, 2],
//                              [7, 8]]
//
// ```
//
// Arguments:
//
//	x: = A `Tensor` which may have the same shape as `condition`.
// If `condition` is rank 1, `x` may have higher rank,
// but its first dimension must match the size of `condition`.
//	y: = A `Tensor` with the same type and shape as `x`.
//
// Returns = A `Tensor` with the same type and shape as `x` and `y`.
func Select(scope *Scope, condition tf.Output, x tf.Output, y tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Select",
		Input: []tf.Input{
			condition, x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of x OR y element-wise.
//
// *NOTE*: `LogicalOr` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs deterministic pseudorandom random numbers from a Poisson distribution.
//
// Outputs random values from a Poisson distribution.
//
// The outputs are a deterministic function of `shape`, `seed`, and `lam`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//	lam: The rate of the Poisson distribution. Shape must match the rightmost dimensions
// of `shape`.
//	dtype: The type of the output.
//
// Returns Random values with specified shape.
func StatelessRandomPoisson(scope *Scope, shape tf.Output, seed tf.Output, lam tf.Output, dtype tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "StatelessRandomPoisson",
		Input: []tf.Input{
			shape, seed, lam,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of `NOT x` element-wise.
//
// Arguments:
//	x: A `Tensor` of type `bool`.
//
// Returns A `Tensor` of type `bool` with the same shape as `x`. The logical negation of `x`.
func LogicalNot(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalNot",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes a graph summary.
//
// Writes TensorFlow graph `tensor` at `step` using summary `writer`.
//
// Returns the created operation.
func WriteGraphSummary(scope *Scope, writer tf.Output, step tf.Output, tensor tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteGraphSummary",
		Input: []tf.Input{
			writer, step, tensor,
		},
	}
	return scope.AddOperation(opspec)
}

// ApproximateEqualAttr is an optional argument to ApproximateEqual.
type ApproximateEqualAttr func(optionalAttr)

// ApproximateEqualTolerance sets the optional tolerance attribute to value.
// If not specified, defaults to 1e-05
func ApproximateEqualTolerance(value float32) ApproximateEqualAttr {
	return func(m optionalAttr) {
		m["tolerance"] = value
	}
}

// Returns the truth value of abs(x-y) < tolerance element-wise.
func ApproximateEqual(scope *Scope, x tf.Output, y tf.Output, optional ...ApproximateEqualAttr) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ApproximateEqual",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EqualAttr is an optional argument to Equal.
type EqualAttr func(optionalAttr)

// EqualIncompatibleShapeError sets the optional incompatible_shape_error attribute to value.
// If not specified, defaults to true
func EqualIncompatibleShapeError(value bool) EqualAttr {
	return func(m optionalAttr) {
		m["incompatible_shape_error"] = value
	}
}

// Returns the truth value of (x == y) element-wise.
//
// *NOTE*: `Equal` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// ```python
// x = tf.constant([2, 4])
// y = tf.constant(2)
// tf.math.equal(x, y) ==> array([True, False])
//
// x = tf.constant([2, 4])
// y = tf.constant([2, 4])
// tf.math.equal(x, y) ==> array([True,  True])
// ```
func Equal(scope *Scope, x tf.Output, y tf.Output, optional ...EqualAttr) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Equal",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x <= y) element-wise.
//
// *NOTE*: `LessEqual` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6])
// y = tf.constant([5])
// tf.math.less_equal(x, y) ==> [True, True, False]
//
// x = tf.constant([5, 4, 6])
// y = tf.constant([5, 6, 6])
// tf.math.less_equal(x, y) ==> [True, True, True]
// ```
func LessEqual(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LessEqual",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x < y) element-wise.
//
// *NOTE*: `Less` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6])
// y = tf.constant([5])
// tf.math.less(x, y) ==> [False, True, False]
//
// x = tf.constant([5, 4, 6])
// y = tf.constant([5, 6, 7])
// tf.math.less(x, y) ==> [False, True, True]
// ```
func Less(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Less",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reduces sparse updates into the variable referenced by `resource` using the `max` operation.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = max(ref[indices, ...], updates[...])
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = max(ref[indices[i], ...], updates[i, ...])
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = max(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions are combined.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterMax(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterMax",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Compute the regularized incomplete beta integral \\(I_x(a, b)\\).
//
// The regularized incomplete beta integral is defined as:
//
//
// \\(I_x(a, b) = \frac{B(x; a, b)}{B(a, b)}\\)
//
// where
//
//
// \\(B(x; a, b) = \int_0^x t^{a-1} (1 - t)^{b-1} dt\\)
//
//
// is the incomplete beta function and \\(B(a, b)\\) is the *complete*
// beta function.
func Betainc(scope *Scope, a tf.Output, b tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Betainc",
		Input: []tf.Input{
			a, b, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the product along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \prod_j data_j\\) where the product is over `j` such
// that `segment_ids[j] == i`.
//
// If the product is empty for a given segment ID `i`, `output[i] = 1`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentProd.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_prod(c, tf.constant([0, 0, 1]))
// # ==> [[4, 6, 6, 4],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentProd(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentProd",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes arctangent of `y/x` element-wise, respecting signs of the arguments.
//
// This is the angle \\( \theta \in [-\pi, \pi] \\) such that
// \\[ x = r \cos(\theta) \\]
// and
// \\[ y = r \sin(\theta) \\]
// where \\(r = \sqrt{x^2 + y^2} \\).
//
// For example:
//
// >>> x = [1., 1.]
// >>> y = [1., -1.]
// >>> print((tf.math.atan2(y,x) * (180 / np.pi)).numpy())
// [ 45. -45.]
//
//
func Atan2(scope *Scope, y tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atan2",
		Input: []tf.Input{
			y, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the polygamma function \\(\psi^{(n)}(x)\\).
//
// The polygamma function is defined as:
//
//
// \\(\psi^{(a)}(x) = \frac{d^a}{dx^a} \psi(x)\\)
//
// where \\(\psi(x)\\) is the digamma function.
// The polygamma function is defined only for non-negative integer orders \\a\\.
func Polygamma(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Polygamma",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceSumAttr is an optional argument to SparseReduceSum.
type SparseReduceSumAttr func(optionalAttr)

// SparseReduceSumKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceSumKeepDims(value bool) SparseReduceSumAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_sum()`.  In particular, this Op also returns a dense `Tensor`
// instead of a sparse one.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
//
// Returns `R-K`-D.  The reduced Tensor.
func SparseReduceSum(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceSumAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceSum",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the Hurwitz zeta function \\(\zeta(x, q)\\).
//
// The Hurwitz zeta function is defined as:
//
//
// \\(\zeta(x, q) = \sum_{n=0}^{\infty} (q + n)^{-x}\\)
func Zeta(scope *Scope, x tf.Output, q tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Zeta",
		Input: []tf.Input{
			x, q,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringSplitV2Attr is an optional argument to StringSplitV2.
type StringSplitV2Attr func(optionalAttr)

// StringSplitV2Maxsplit sets the optional maxsplit attribute to value.
//
// value: An `int`. If `maxsplit > 0`, limit of the split of the result.
// If not specified, defaults to -1
func StringSplitV2Maxsplit(value int64) StringSplitV2Attr {
	return func(m optionalAttr) {
		m["maxsplit"] = value
	}
}

// Split elements of `source` based on `sep` into a `SparseTensor`.
//
// Let N be the size of source (typically N will be the batch size). Split each
// element of `source` based on `sep` and return a `SparseTensor`
// containing the split tokens. Empty tokens are ignored.
//
// For example, N = 2, source[0] is 'hello world' and source[1] is 'a b c',
// then the output will be
// ```
// st.indices = [0, 0;
//               0, 1;
//               1, 0;
//               1, 1;
//               1, 2]
// st.shape = [2, 3]
// st.values = ['hello', 'world', 'a', 'b', 'c']
// ```
//
// If `sep` is given, consecutive delimiters are not grouped together and are
// deemed to delimit empty strings. For example, source of `"1<>2<><>3"` and
// sep of `"<>"` returns `["1", "2", "", "3"]`. If `sep` is None or an empty
// string, consecutive whitespace are regarded as a single separator, and the
// result will contain no empty strings at the startor end if the string has
// leading or trailing whitespace.
//
// Note that the above mentioned behavior matches python's str.split.
//
// Arguments:
//	input: `1-D` string `Tensor`, the strings to split.
//	sep: `0-D` string `Tensor`, the delimiter character.
func StringSplitV2(scope *Scope, input tf.Output, sep tf.Output, optional ...StringSplitV2Attr) (indices tf.Output, values tf.Output, shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringSplitV2",
		Input: []tf.Input{
			input, sep,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Compute the lower regularized incomplete Gamma function `P(a, x)`.
//
// The lower regularized incomplete Gamma function is defined as:
//
//
// \\(P(a, x) = gamma(a, x) / Gamma(a) = 1 - Q(a, x)\\)
//
// where
//
// \\(gamma(a, x) = \\int_{0}^{x} t^{a-1} exp(-t) dt\\)
//
// is the lower incomplete Gamma function.
//
// Note, above `Q(a, x)` (`Igammac`) is the upper regularized complete
// Gamma function.
func Igamma(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Igamma",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the upper regularized incomplete Gamma function `Q(a, x)`.
//
// The upper regularized incomplete Gamma function is defined as:
//
// \\(Q(a, x) = Gamma(a, x) / Gamma(a) = 1 - P(a, x)\\)
//
// where
//
// \\(Gamma(a, x) = \int_{x}^{\infty} t^{a-1} exp(-t) dt\\)
//
// is the upper incomplete Gamma function.
//
// Note, above `P(a, x)` (`Igamma`) is the lower regularized complete
// Gamma function.
func Igammac(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Igammac",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise remainder of division. This emulates C semantics in that
//
// the result here is consistent with a truncating divide. E.g. `truncate(x / y) *
// y + truncate_mod(x, y) = x`.
//
// *NOTE*: `TruncateMod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func TruncateMod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TruncateMod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise remainder of division. When `x < 0` xor `y < 0` is
//
// true, this follows Python semantics in that the result here is consistent
// with a flooring divide. E.g. `floor(x / y) * y + mod(x, y) = x`.
//
// *NOTE*: `FloorMod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func FloorMod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FloorMod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise remainder of division. This emulates C semantics in that
//
// the result here is consistent with a truncating divide. E.g.
// `tf.truncatediv(x, y) * y + truncate_mod(x, y) = x`.
//
// *NOTE*: `Mod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Mod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Mod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sum along sparse segments of a tensor divided by the sqrt of N.
//
// N is the size of the segment being reduced.
//
// See `tf.sparse.segment_sum` for usage examples.
//
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SparseSegmentSqrtN(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSqrtN",
		Input: []tf.Input{
			data, indices, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the max of x and y (i.e. x > y ? x : y) element-wise.
//
// *NOTE*: `Maximum` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Maximum(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Maximum",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if x == 0, and x / y otherwise, elementwise.
func Xdivy(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Xdivy",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if x == 0, and x * log(y) otherwise, elementwise.
func Xlogy(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Xlogy",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Increments variable pointed to by 'resource' until it reaches 'limit'.
//
// Arguments:
//	resource: Should be from a scalar `Variable` node.
//	limit: If incrementing ref would bring it above limit, instead generates an
// 'OutOfRange' error.
//
//
// Returns A copy of the input before increment. If nothing else modifies the
// input, the values produced will all be distinct.
func ResourceCountUpTo(scope *Scope, resource tf.Output, limit int64, T tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"limit": limit, "T": T}
	opspec := tf.OpSpec{
		Type: "ResourceCountUpTo",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulStandardNormalAttr is an optional argument to StatefulStandardNormal.
type StatefulStandardNormalAttr func(optionalAttr)

// StatefulStandardNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulStandardNormalDtype(value tf.DataType) StatefulStandardNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a normal distribution. This op is deprecated in favor of op 'StatefulStandardNormalV2'
//
// DEPRECATED at GraphDef version 29: Use StatefulStandardNormalV2 instead
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	shape: The shape of the output tensor.
//
// Returns A tensor of the specified shape filled with random normal values.
func StatefulStandardNormal(scope *Scope, resource tf.Output, shape tf.Output, optional ...StatefulStandardNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulStandardNormal",
		Input: []tf.Input{
			resource, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x / y element-wise for real types.
//
// If `x` and `y` are reals, this will return the floating-point division.
//
// *NOTE*: `Div` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func RealDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RealDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x / y element-wise for integer types.
//
// Truncation designates that negative numbers will round fractional quantities
// toward zero. I.e. -7 / 5 = -1. This matches C semantics but it is different
// than Python semantics. See `FloorDiv` for a division function that matches
// Python Semantics.
//
// *NOTE*: `TruncateDiv` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func TruncateDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TruncateDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x // y element-wise.
//
// *NOTE*: `FloorDiv` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func FloorDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FloorDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes a serialized proto summary.
//
// Writes `tensor`, a serialized proto at `step` using summary `writer`.
//
// Returns the created operation.
func WriteRawProtoSummary(scope *Scope, writer tf.Output, step tf.Output, tensor tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteRawProtoSummary",
		Input: []tf.Input{
			writer, step, tensor,
		},
	}
	return scope.AddOperation(opspec)
}

// Returns 0 if the denominator is zero.
//
//
// *NOTE*: `DivNoNan` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func DivNoNan(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DivNoNan",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x / y element-wise.
//
// *NOTE*: `Div` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Div(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Div",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Says whether the targets are in the top `K` predictions.
//
// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
// prediction for the target class is among the top `k` predictions among
// all predictions for example `i`. Note that the behavior of `InTopK` differs
// from the `TopK` op in its handling of ties; if multiple classes have the
// same prediction value and straddle the top-`k` boundary, all of those
// classes are considered to be in the top `k`.
//
// More formally, let
//
//   \\(predictions_i\\) be the predictions for all classes for example `i`,
//   \\(targets_i\\) be the target class for example `i`,
//   \\(out_i\\) be the output for example `i`,
//
// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
//
// Arguments:
//	predictions: A `batch_size` x `classes` tensor.
//	targets: A `batch_size` vector of class ids.
//	k: Number of top elements to look at for computing precision.
//
// Returns Computed Precision at `k` as a `bool Tensor`.
func InTopK(scope *Scope, predictions tf.Output, targets tf.Output, k int64) (precision tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	opspec := tf.OpSpec{
		Type: "InTopK",
		Input: []tf.Input{
			predictions, targets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x - y element-wise.
//
// *NOTE*: `Subtract` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Sub(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sub",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AsStringAttr is an optional argument to AsString.
type AsStringAttr func(optionalAttr)

// AsStringPrecision sets the optional precision attribute to value.
//
// value: The post-decimal precision to use for floating point numbers.
// Only used if precision > -1.
// If not specified, defaults to -1
func AsStringPrecision(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["precision"] = value
	}
}

// AsStringScientific sets the optional scientific attribute to value.
//
// value: Use scientific notation for floating point numbers.
// If not specified, defaults to false
func AsStringScientific(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["scientific"] = value
	}
}

// AsStringShortest sets the optional shortest attribute to value.
//
// value: Use shortest representation (either scientific or standard) for
// floating point numbers.
// If not specified, defaults to false
func AsStringShortest(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["shortest"] = value
	}
}

// AsStringWidth sets the optional width attribute to value.
//
// value: Pad pre-decimal numbers to this width.
// Applies to both floating point and integer numbers.
// Only used if width > -1.
// If not specified, defaults to -1
func AsStringWidth(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["width"] = value
	}
}

// AsStringFill sets the optional fill attribute to value.
//
// value: The value to pad if width > -1.  If empty, pads with spaces.
// Another typical value is '0'.  String cannot be longer than 1 character.
// If not specified, defaults to ""
func AsStringFill(value string) AsStringAttr {
	return func(m optionalAttr) {
		m["fill"] = value
	}
}

// Converts each entry in the given tensor to strings.
//
// Supports many numeric types and boolean.
//
// For Unicode, see the
// [https://www.tensorflow.org/tutorials/representation/unicode](Working with Unicode text)
// tutorial.
//
// Examples:
//
// >>> tf.strings.as_string([3, 2])
// <tf.Tensor: shape=(2,), dtype=string, numpy=array([b'3', b'2'], dtype=object)>
// >>> tf.strings.as_string([3.1415926, 2.71828], precision=2).numpy()
// array([b'3.14', b'2.72'], dtype=object)
func AsString(scope *Scope, input tf.Output, optional ...AsStringAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AsString",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterV2Attr is an optional argument to Conv3DBackpropFilterV2.
type Conv3DBackpropFilterV2Attr func(optionalAttr)

// Conv3DBackpropFilterV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DBackpropFilterV2DataFormat(value string) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropFilterV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropFilterV2Dilations(value []int64) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 5-D
// `[filter_depth, filter_height, filter_width, in_channels, out_channels]`
// tensor.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilterV2(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilterV2",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x + y element-wise.
//
// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func AddV2(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AddV2",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise integer closest to x.
//
// If the result is midway between two representable values,
// the even representable is chosen.
// For example:
//
// ```
// rint(-1.5) ==> -2.0
// rint(0.5000001) ==> 1.0
// rint([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0]) ==> [-2., -2., -0., 0., 2., 2., 2.]
// ```
func Rint(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Rint",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise smallest integer not less than x.
func Ceil(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Ceil",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise largest integer not greater than x.
func Floor(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Floor",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns an element-wise indication of the sign of a number.
//
// `y = sign(x) = -1` if `x < 0`; 0 if `x == 0`; 1 if `x > 0`.
//
// For complex numbers, `y = sign(x) = x / |x|` if `x != 0`, otherwise `y = 0`.
//
// Example usage:
// >>> tf.math.sign([0., 2., -3.])
// <tf.Tensor: shape=(3,), dtype=float32, numpy=array([ 0.,  1., -1.], dtype=float32)>
func Sign(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sign",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are finite.
//
// @compatibility(numpy)
// Equivalent to np.isfinite
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, 4.8, 6.8, np.inf, np.nan])
// tf.math.is_finite(x) ==> [True, True, True, False, False]
// ```
func IsFinite(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsFinite",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are Inf.
//
// @compatibility(numpy)
// Equivalent to np.isinf
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, np.inf, 6.8, np.inf])
// tf.math.is_inf(x) ==> [False, True, False, True]
// ```
func IsInf(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsInf",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are NaN.
//
// @compatibility(numpy)
// Equivalent to np.isnan
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, np.nan, 6.8, np.nan, np.inf])
// tf.math.is_nan(x) ==> [False, True, False, True, False]
// ```
func IsNan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsNan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the trignometric inverse tangent of x element-wise.
//
// The `tf.math.atan` operation returns the inverse of `tf.math.tan`, such that
// if `y = tf.math.tan(x)` then, `x = tf.math.atan(y)`.
//
// **Note**: The output of `tf.math.atan` will lie within the invertible range
// of tan, i.e (-pi/2, pi/2).
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.tan(x) # [1.731261, 0.99920404]
//
// tf.math.atan(y) # [1.047, 0.785] = x
// ```
//
func Atan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyProximalAdagradAttr is an optional argument to ResourceApplyProximalAdagrad.
type ResourceApplyProximalAdagradAttr func(optionalAttr)

// ResourceApplyProximalAdagradUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyProximalAdagradUseLocking(value bool) ResourceApplyProximalAdagradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' and '*accum' according to FOBOS with Adagrad learning rate.
//
// accum += grad * grad
// prox_v = var - lr * grad * (1 / sqrt(accum))
// var = sign(prox_v)/(1+lr*l2) * max{|prox_v|-lr*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyProximalAdagrad(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, grad tf.Output, optional ...ResourceApplyProximalAdagradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyProximalAdagrad",
		Input: []tf.Input{
			var_, accum, lr, l1, l2, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Divides sparse updates into the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] /= updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] /= updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] /= updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions multiply.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterDiv(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterDiv",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the trignometric inverse sine of x element-wise.
//
// The `tf.math.asin` operation returns the inverse of `tf.math.sin`, such that
// if `y = tf.math.sin(x)` then, `x = tf.math.asin(y)`.
//
// **Note**: The output of `tf.math.asin` will lie within the invertible range
// of sine, i.e [-pi/2, pi/2].
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.sin(x) # [0.8659266, 0.7068252]
//
// tf.math.asin(y) # [1.047, 0.785] = x
// ```
//
func Asin(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asin",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes a histogram summary.
//
// Writes histogram `values` at `step` with `tag` using summary `writer`.
//
// Returns the created operation.
func WriteHistogramSummary(scope *Scope, writer tf.Output, step tf.Output, tag tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteHistogramSummary",
		Input: []tf.Input{
			writer, step, tag, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes tan of x element-wise.
//
//   Given an input tensor, this function computes tangent of every
//   element in the tensor. Input range is `(-inf, inf)` and
//   output range is `(-inf, inf)`. If input lies outside the boundary, `nan`
//   is returned.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10000, float("inf")])
//   tf.math.tan(x) ==> [nan 0.45231566 -0.5463025 1.5574077 2.572152 -1.7925274 0.32097113 nan]
//   ```
func Tan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Tan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormV2Attr is an optional argument to FusedBatchNormV2.
type FusedBatchNormV2Attr func(optionalAttr)

// FusedBatchNormV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV2Epsilon(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV2ExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormV2ExponentialAvgFactor(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV2DataFormat(value string) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV2IsTraining(value bool) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns:
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNormV2(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV2Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV2",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Computes sine of x element-wise.
//
//   Given an input tensor, this function computes sine of every
//   element in the tensor. Input range is `(-inf, inf)` and
//   output range is `[-1,1]`.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10, float("inf")])
//   tf.math.sin(x) ==> [nan -0.4121185 -0.47942555 0.84147096 0.9320391 -0.87329733 -0.54402107 nan]
//   ```
func Sin(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sin",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingADAMParametersGradAccumDebug.
type RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingADAMParametersGradAccumDebugConfig(value string) RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve ADAM embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the ADAM optimization algorithm.
//	momenta: Parameter momenta updated by the ADAM optimization algorithm.
//	velocities: Parameter velocities updated by the ADAM optimization algorithm.
//	gradient_accumulators: Parameter gradient_accumulators updated by the ADAM optimization algorithm.
func RetrieveTPUEmbeddingADAMParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr) (parameters tf.Output, momenta tf.Output, velocities tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingADAMParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// ResourceApplyAdamAttr is an optional argument to ResourceApplyAdam.
type ResourceApplyAdamAttr func(optionalAttr)

// ResourceApplyAdamUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdamUseLocking(value bool) ResourceApplyAdamAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyAdamUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, uses the nesterov update.
// If not specified, defaults to false
func ResourceApplyAdamUseNesterov(value bool) ResourceApplyAdamAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the Adam algorithm.
//
// $$\text{lr}_t := \mathrm{learning_rate} * \sqrt{1 - \beta_2^t} / (1 - \beta_1^t)$$
// $$m_t := \beta_1 * m_{t-1} + (1 - \beta_1) * g$$
// $$v_t := \beta_2 * v_{t-1} + (1 - \beta_2) * g * g$$
// $$\text{variable} := \text{variable} - \text{lr}_t * m_t / (\sqrt{v_t} + \epsilon)$$
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	beta2_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdam(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, beta1_power tf.Output, beta2_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdamAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdam",
		Input: []tf.Input{
			var_, m, v, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyAdadeltaAttr is an optional argument to ResourceSparseApplyAdadelta.
type ResourceSparseApplyAdadeltaAttr func(optionalAttr)

// ResourceSparseApplyAdadeltaUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyAdadeltaUseLocking(value bool) ResourceSparseApplyAdadeltaAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// var: Should be from a Variable().
//
// Arguments:
//
//	accum: Should be from a Variable().
//	accum_update: : Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	rho: Decay factor. Must be a scalar.
//	epsilon: Constant factor. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyAdadelta(scope *Scope, var_ tf.Output, accum tf.Output, accum_update tf.Output, lr tf.Output, rho tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyAdadeltaAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyAdadelta",
		Input: []tf.Input{
			var_, accum, accum_update, lr, rho, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes sigmoid of `x` element-wise.
//
// Specifically, `y = 1 / (1 + exp(-x))`.
func Sigmoid(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sigmoid",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the complementary error function of `x` element-wise.
func Erfc(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Erfc",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the Approximate Minimum Degree (AMD) ordering of `input`.
//
// Computes the Approximate Minimum Degree (AMD) ordering for a sparse matrix.
//
// The returned permutation may be used to permute the rows and columns of the
// given sparse matrix. This typically results in permuted sparse matrix's sparse
// Cholesky (or other decompositions) in having fewer zero fill-in compared to
// decomposition of the original matrix.
//
// The input sparse matrix may have rank 2 or rank 3. The output Tensor,
// representing would then have rank 1 or 2 respectively, with the same batch
// shape as the input.
//
// Each component of the input sparse matrix must represent a square symmetric
// matrix; only the lower triangular part of the matrix is read. The values of the
// sparse matrix does not affect the returned permutation, only the sparsity
// pattern of the sparse matrix is used. Hence, a single AMD ordering may be
// reused for the Cholesky decompositions of sparse matrices with the same sparsity
// pattern but with possibly different values.
//
// Each batch component of the output permutation represents a permutation of `N`
// elements, where the input sparse matrix components each have `N` rows. That is,
// the component contains each of the integers `{0, .. N-1}` exactly once. The
// `i`th element represents the row index that the `i`th row maps to.
//
// Usage example:
//
// ```python
//     from tensorflow.python.ops.linalg.sparse import sparse_csr_matrix_ops
//
//     a_indices = np.array([[0, 0], [1, 1], [2, 1], [2, 2], [3, 3]])
//     a_values = np.array([1.0, 2.0, 1.0, 3.0, 4.0], np.float32)
//     a_dense_shape = [4, 4]
//
//     with tf.Session() as sess:
//       # Define (COO format) SparseTensor over Numpy array.
//       a_st = tf.sparse.SparseTensor(a_indices, a_values, a_dense_shape)
//
//       # Convert SparseTensors to CSR SparseMatrix.
//       a_sm = sparse_csr_matrix_ops.sparse_tensor_to_csr_sparse_matrix(
//           a_st.indices, a_st.values, a_st.dense_shape)
//
//       # Obtain the AMD Ordering for the CSR SparseMatrix.
//       ordering_amd = sparse_csr_matrix_ops.sparse_matrix_ordering_amd(sparse_matrix)
//
//       ordering_amd_value = sess.run(ordering_amd)
// ```
//
// `ordering_amd_value` stores the AMD ordering: `[1 2 3 0]`.
//
// input: A `CSRSparseMatrix`.
//
// Arguments:
//	input: A `CSRSparseMatrix`.
//
// Returns The Approximate Minimum Degree (AMD) ordering of `input`.
func SparseMatrixOrderingAMD(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseMatrixOrderingAMD",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomStandardNormalAttr is an optional argument to RandomStandardNormal.
type RandomStandardNormalAttr func(optionalAttr)

// RandomStandardNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomStandardNormalSeed(value int64) RandomStandardNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomStandardNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomStandardNormalSeed2(value int64) RandomStandardNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with random normal values.
func RandomStandardNormal(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...RandomStandardNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomStandardNormal",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the [Gauss error function](https://en.wikipedia.org/wiki/Error_function) of `x` element-wise. In statistics, for non-negative values of $x$, the error function has the following interpretation: for a random variable $Y$ that is normally distributed with mean 0 and variance $1/\sqrt{2}$, $erf(x)$ is the probability that $Y$ falls in the range $[−x, x]$.
func Erf(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Erf",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes Psi, the derivative of Lgamma (the log of the absolute value of
//
// `Gamma(x)`), element-wise.
func Digamma(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Digamma",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Serializes the tree ensemble to a proto.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble.
//
// Returns:
//	stamp_token: Stamp token of the tree ensemble resource.
//	tree_ensemble_serialized: Serialized proto of the ensemble.
func BoostedTreesSerializeEnsemble(scope *Scope, tree_ensemble_handle tf.Output) (stamp_token tf.Output, tree_ensemble_serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSerializeEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes inverse hyperbolic cosine of x element-wise.
//
// Given an input tensor, the function computes inverse hyperbolic cosine of every element.
// Input range is `[1, inf]`. It returns `nan` if the input lies outside the range.
//
// ```python
// x = tf.constant([-2, -0.5, 1, 1.2, 200, 10000, float("inf")])
// tf.math.acosh(x) ==> [nan nan 0. 0.62236255 5.9914584 9.903487 inf]
// ```
func Acosh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acosh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic cosine of x element-wise.
//
//   Given an input tensor, this function computes hyperbolic cosine of every
//   element in the tensor. Input range is `[-inf, inf]` and output range
//   is `[1, inf]`.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
//   tf.math.cosh(x) ==> [inf 4.0515420e+03 1.1276259e+00 1.5430807e+00 1.8106556e+00 3.7621956e+00 1.1013233e+04 inf]
//   ```
func Cosh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cosh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes natural logarithm of (1 + x) element-wise.
//
// I.e., \\(y = \log_e (1 + x)\\).
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 5])
// tf.math.log1p(x) ==> [0., 0.4054651, 0.6931472, 1.7917595]
// ```
func Log1p(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log1p",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropInputAttr is an optional argument to Conv2DBackpropInput.
type Conv2DBackpropInputAttr func(optionalAttr)

// Conv2DBackpropInputUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropInputUseCudnnOnGpu(value bool) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropInputExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to <>
func Conv2DBackpropInputExplicitPaddings(value []int64) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropInputDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func Conv2DBackpropInputDataFormat(value string) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropInputDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func Conv2DBackpropInputDilations(value []int64) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the shape of `input`,
// where `input` is a 4-D `[batch, height, width, channels]` tensor.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution. Must be in the same order as the dimension specified with
// format.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, in_channels]`.  Gradient
// w.r.t. the input of the convolution.
func Conv2DBackpropInput(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropInput",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes `exp(x) - 1` element-wise.
//
//   i.e. `exp(x) - 1` or `e^(x) - 1`, where `x` is the input tensor.
//   `e` denotes Euler's number and is approximately equal to 2.718281.
//
//   ```python
//   x = tf.constant(2.0)
//   tf.math.expm1(x) ==> 6.389056
//
//   x = tf.constant([2.0, 8.0])
//   tf.math.expm1(x) ==> array([6.389056, 2979.958], dtype=float32)
//
//   x = tf.constant(1 + 1j)
//   tf.math.expm1(x) ==> (0.46869393991588515+2.2873552871788423j)
//   ```
func Expm1(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Expm1",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes exponential of x element-wise.  \\(y = e^x\\).
//
//   This function computes the exponential of every element in the input tensor.
//   i.e. `exp(x)` or `e^(x)`, where `x` is the input tensor.
//   `e` denotes Euler's number and is approximately equal to 2.718281.
//   Output is positive for any real input.
//
//   ```python
//   x = tf.constant(2.0)
//   tf.math.exp(x) ==> 7.389056
//
//   x = tf.constant([2.0, 8.0])
//   tf.math.exp(x) ==> array([7.389056, 2980.958], dtype=float32)
//   ```
//
//   For complex numbers, the exponential value is calculated as follows:
//
//   ```
//   e^(x+iy) = e^x * e^iy = e^x * (cos y + i sin y)
//   ```
//
//   Let's consider complex number 1+1j as an example.
//   e^1 * (cos 1 + i sin 1) = 2.7182818284590 * (0.54030230586+0.8414709848j)
//
//   ```python
//   x = tf.constant(1 + 1j)
//   tf.math.exp(x) ==> 1.4686939399158851+2.2873552871788423j
//   ```
func Exp(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Exp",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts the given variant tensor to an iterator and stores it in the given resource.
//
// Arguments:
//	resource_handle: A handle to an iterator resource.
//	serialized: A variant tensor storing the state of the iterator contained in the
// resource.
//
// Returns the created operation.
func DeserializeIterator(scope *Scope, resource_handle tf.Output, serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeserializeIterator",
		Input: []tf.Input{
			resource_handle, serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the gradient for the rsqrt of `x` wrt its input.
//
// Specifically, `grad = dy * -0.5 * y^3`, where `y = rsqrt(x)`, and `dy`
// is the corresponding input gradient.
func RsqrtGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RsqrtGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormV3Attr is an optional argument to FusedBatchNormV3.
type FusedBatchNormV3Attr func(optionalAttr)

// FusedBatchNormV3Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV3Epsilon(value float32) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV3ExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormV3ExponentialAvgFactor(value float32) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormV3DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV3DataFormat(value string) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV3IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV3IsTraining(value bool) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns:
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.
//	reserve_space_3: A 1D Tensor for some intermediate results, to be reused in the gradient
// computation for better efficiency.
func FusedBatchNormV3(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV3Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, reserve_space_3 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV3",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5)
}

// QuantizedInstanceNormAttr is an optional argument to QuantizedInstanceNorm.
type QuantizedInstanceNormAttr func(optionalAttr)

// QuantizedInstanceNormOutputRangeGiven sets the optional output_range_given attribute to value.
//
// value: If True, `given_y_min` and `given_y_min`
// and `given_y_max` are used as the output range. Otherwise,
// the implementation computes the output range.
// If not specified, defaults to false
func QuantizedInstanceNormOutputRangeGiven(value bool) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["output_range_given"] = value
	}
}

// QuantizedInstanceNormGivenYMin sets the optional given_y_min attribute to value.
//
// value: Output in `y_min` if `output_range_given` is True.
// If not specified, defaults to 0
func QuantizedInstanceNormGivenYMin(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["given_y_min"] = value
	}
}

// QuantizedInstanceNormGivenYMax sets the optional given_y_max attribute to value.
//
// value: Output in `y_max` if `output_range_given` is True.
// If not specified, defaults to 0
func QuantizedInstanceNormGivenYMax(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["given_y_max"] = value
	}
}

// QuantizedInstanceNormVarianceEpsilon sets the optional variance_epsilon attribute to value.
//
// value: A small float number to avoid dividing by 0.
// If not specified, defaults to 1e-05
func QuantizedInstanceNormVarianceEpsilon(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["variance_epsilon"] = value
	}
}

// QuantizedInstanceNormMinSeparation sets the optional min_separation attribute to value.
//
// value: Minimum value of `y_max - y_min`
// If not specified, defaults to 0.001
func QuantizedInstanceNormMinSeparation(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["min_separation"] = value
	}
}

// Quantized Instance normalization.
//
// Arguments:
//	x: A 4D input Tensor.
//	x_min: The value represented by the lowest quantized input.
//	x_max: The value represented by the highest quantized input.
//
// Returns:
//	y: A 4D Tensor.
//	y_min: The value represented by the lowest quantized output.
//	y_max: The value represented by the highest quantized output.
func QuantizedInstanceNorm(scope *Scope, x tf.Output, x_min tf.Output, x_max tf.Output, optional ...QuantizedInstanceNormAttr) (y tf.Output, y_min tf.Output, y_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedInstanceNorm",
		Input: []tf.Input{
			x, x_min, x_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes reciprocal of square root of x element-wise.
//
// I.e., \\(y = 1 / \sqrt{x}\\).
func Rsqrt(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Rsqrt",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes square root of x element-wise.
//
// I.e., \\(y = \sqrt{x} = x^{1/2}\\).
func Sqrt(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sqrt",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the inverse of `x` wrt its input.
//
// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
// is the corresponding input gradient.
func InvGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reciprocal of x element-wise.
//
// I.e., \\(y = 1 / x\\).
func Inv(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Inv",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Produces a summary of any statistics recorded by the given statistics manager.
func ExperimentalStatsAggregatorSummary(scope *Scope, iterator tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalStatsAggregatorSummary",
		Input: []tf.Input{
			iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulV3Attr is an optional argument to BatchMatMulV3.
type BatchMatMulV3Attr func(optionalAttr)

// BatchMatMulV3AdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV3AdjX(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulV3AdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV3AdjY(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// *NOTE*: `BatchMatMulV3` supports broadcasting in the batch dimensions. More
// about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//	Tout: If not spcified, Tout is the same type to input type.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMulV3(scope *Scope, x tf.Output, y tf.Output, Tout tf.DataType, optional ...BatchMatMulV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMulV3",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RaggedTensorFromVariantAttr is an optional argument to RaggedTensorFromVariant.
type RaggedTensorFromVariantAttr func(optionalAttr)

// RaggedTensorFromVariantTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func RaggedTensorFromVariantTsplits(value tf.DataType) RaggedTensorFromVariantAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Decodes a `variant` Tensor into a `RaggedTensor`.
//
// Decodes the given `variant` Tensor and returns a `RaggedTensor`. The input
// could be a scalar, meaning it encodes a single `RaggedTensor` with ragged_rank
// `output_ragged_rank`. It could also have an arbitrary rank, in which case each
// element is decoded into a `RaggedTensor` with ragged_rank `input_ragged_rank`
// and these are then stacked according to the input shape to output a single
// `RaggedTensor` with ragged_rank `output_ragged_rank`. Each `variant` element in
// the input Tensor is decoded by retrieving from the element a 1-D `variant`
// Tensor with `input_ragged_rank + 1` Tensors, corresponding to the splits and
// values of the decoded `RaggedTensor`. If `input_ragged_rank` is -1, then it is
// inferred as `output_ragged_rank` - `rank(encoded_ragged)`. See
// `RaggedTensorToVariant` for the corresponding encoding logic.
//
//
// Arguments:
//	encoded_ragged: A `variant` Tensor containing encoded `RaggedTensor`s.
//	input_ragged_rank: The ragged rank of each encoded `RaggedTensor` component in the input. If set to
// -1, this is inferred as `output_ragged_rank` - `rank(encoded_ragged)`
//	output_ragged_rank: The expected ragged rank of the output `RaggedTensor`. The following must hold:
// `output_ragged_rank = rank(encoded_ragged) + input_ragged_rank`.
//
//
// Returns:
//	output_nested_splits: A list of one or more Tensors representing the splits of the output
// `RaggedTensor`.
//	output_dense_values: A Tensor representing the values of the output `RaggedTensor`.
func RaggedTensorFromVariant(scope *Scope, encoded_ragged tf.Output, input_ragged_rank int64, output_ragged_rank int64, Tvalues tf.DataType, optional ...RaggedTensorFromVariantAttr) (output_nested_splits []tf.Output, output_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_ragged_rank": input_ragged_rank, "output_ragged_rank": output_ragged_rank, "Tvalues": Tvalues}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedTensorFromVariant",
		Input: []tf.Input{
			encoded_ragged,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_nested_splits, idx, err = makeOutputList(op, idx, "output_nested_splits"); err != nil {
		scope.UpdateErr("RaggedTensorFromVariant", err)
		return
	}
	output_dense_values = op.Output(idx)
	return output_nested_splits, output_dense_values
}

// BatchMatMulAttr is an optional argument to BatchMatMul.
type BatchMatMulAttr func(optionalAttr)

// BatchMatMulAdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjX(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulAdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjY(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMul(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMul",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the element-wise sum of a list of tensors.
//
// `tf.accumulate_n_v2` performs the same operation as `tf.add_n`, but does not
// wait for all of its inputs to be ready before beginning to sum. This can
// save memory if inputs are ready at different times, since minimum temporary
// storage is proportional to the output size rather than the inputs size.
//
// Unlike the original `accumulate_n`, `accumulate_n_v2` is differentiable.
//
// Returns a `Tensor` of same shape and type as the elements of `inputs`.
//
// Arguments:
//	inputs: A list of `Tensor` objects, each with same shape and type.
//	shape: Shape of elements of `inputs`.
func AccumulateNV2(scope *Scope, inputs []tf.Output, shape tf.Shape) (sum tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "AccumulateNV2",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradAttr is an optional argument to MaxPoolGrad.
type MaxPoolGradAttr func(optionalAttr)

// MaxPoolGradExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to <>
func MaxPoolGradExplicitPaddings(value []int64) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// MaxPoolGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradDataFormat(value string) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Rolls the elements of a tensor along an axis.
//
// The elements are shifted positively (towards larger indices) by the offset of
// `shift` along the dimension of `axis`. Negative `shift` values will shift
// elements in the opposite direction. Elements that roll passed the last position
// will wrap around to the first and vice versa. Multiple shifts along multiple
// axes may be specified.
//
// For example:
//
// ```
// # 't' is [0, 1, 2, 3, 4]
// roll(t, shift=2, axis=0) ==> [3, 4, 0, 1, 2]
//
// # shifting along multiple dimensions
// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
// roll(t, shift=[1, -2], axis=[0, 1]) ==> [[7, 8, 9, 5, 6], [2, 3, 4, 0, 1]]
//
// # shifting along the same axis multiple times
// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
// roll(t, shift=[2, -3], axis=[1, 1]) ==> [[1, 2, 3, 4, 0], [6, 7, 8, 9, 5]]
// ```
//
// Arguments:
//
//	shift: Dimension must be 0-D or 1-D. `shift[i]` specifies the number of places by which
// elements are shifted positively (towards larger indices) along the dimension
// specified by `axis[i]`. Negative shifts will roll the elements in the opposite
// direction.
//	axis: Dimension must be 0-D or 1-D. `axis[i]` specifies the dimension that the shift
// `shift[i]` should occur. If the same axis is referenced more than once, the
// total shift for that axis will be the sum of all the shifts that belong to that
// axis.
//
// Returns Has the same shape and size as the input. The elements are shifted
// positively (towards larger indices) by the offsets of `shift` along the
// dimensions of `axis`.
func Roll(scope *Scope, input tf.Output, shift tf.Output, axis tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Roll",
		Input: []tf.Input{
			input, shift, axis,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts a tensor to a scalar predicate.
//
// Converts a tensor to a scalar predicate with the following rules:
//
// - For 0D tensors, truthiness is determined by comparing against a "zero"
//   value. For numerical types it is the obvious zero. For strings it is the
//   empty string.
//
// - For >0D tensors, truthiness is determined by looking at the number of
//   elements. If has zero elements, then the result is false. Otherwise the
//   result is true.
//
// This matches the behavior of If and While for determining if a tensor counts
// as true/false for a branch condition.
func ToBool(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ToBool",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GenerateBoundingBoxProposalsAttr is an optional argument to GenerateBoundingBoxProposals.
type GenerateBoundingBoxProposalsAttr func(optionalAttr)

// GenerateBoundingBoxProposalsPostNmsTopn sets the optional post_nms_topn attribute to value.
//
// value: An integer. Maximum number of rois in the output.
// If not specified, defaults to 300
func GenerateBoundingBoxProposalsPostNmsTopn(value int64) GenerateBoundingBoxProposalsAttr {
	return func(m optionalAttr) {
		m["post_nms_topn"] = value
	}
}

// This op produces Region of Interests from given bounding boxes(bbox_deltas) encoded wrt anchors according to eq.2 in arXiv:1506.01497
//
//       The op selects top `pre_nms_topn` scoring boxes, decodes them with respect to anchors,
//       applies non-maximal suppression on overlapping boxes with higher than
//       `nms_threshold` intersection-over-union (iou) value, discarding boxes where shorter
//       side is less than `min_size`.
//       Inputs:
//       `scores`: A 4D tensor of shape [Batch, Height, Width, Num Anchors] containing the scores per anchor at given position
//       `bbox_deltas`: is a tensor of shape [Batch, Height, Width, 4 x Num Anchors] boxes encoded to each anchor
//       `anchors`: A 1D tensor of shape [4 x Num Anchors], representing the anchors.
//       Outputs:
//       `rois`: output RoIs, a 3D tensor of shape [Batch, post_nms_topn, 4], padded by 0 if less than post_nms_topn candidates found.
//       `roi_probabilities`: probability scores of each roi in 'rois', a 2D tensor of shape [Batch,post_nms_topn], padded with 0 if needed, sorted by scores.
//
// Arguments:
//	scores: A 4-D float tensor of shape `[num_images, height, width, num_achors]` containing scores of the boxes for given anchors, can be unsorted.
//	bbox_deltas: A 4-D float tensor of shape `[num_images, height, width, 4 x num_anchors]`. encoding boxes with respec to each anchor.
// Coordinates are given in the form [dy, dx, dh, dw].
//	image_info: A 2-D float tensor of shape `[num_images, 5]` containing image information Height, Width, Scale.
//	anchors: A 2-D float tensor of shape `[num_anchors, 4]` describing the anchor boxes. Boxes are formatted in the form [y1, x1, y2, x2].
//	nms_threshold: A scalar float tensor for non-maximal-suppression threshold.
//	pre_nms_topn: A scalar int tensor for the number of top scoring boxes to be used as input.
//	min_size: A scalar float tensor. Any box that has a smaller size than min_size will be discarded.
//
// Returns:
//	rois: A 3-D float tensor of shape `[num_images,post_nms_topn,4]` representing the selected
// region of interest boxes. Sorted in descending order in scores.
//	roi_probabilities: A 2-D float tensor of shape `[num_images, post_nms_topn]` representing the score of the
// region of interest box in `rois` tensor at the same index.
func GenerateBoundingBoxProposals(scope *Scope, scores tf.Output, bbox_deltas tf.Output, image_info tf.Output, anchors tf.Output, nms_threshold tf.Output, pre_nms_topn tf.Output, min_size tf.Output, optional ...GenerateBoundingBoxProposalsAttr) (rois tf.Output, roi_probabilities tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GenerateBoundingBoxProposals",
		Input: []tf.Input{
			scores, bbox_deltas, image_info, anchors, nms_threshold, pre_nms_topn, min_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// InitializeTableFromTextFileV2Attr is an optional argument to InitializeTableFromTextFileV2.
type InitializeTableFromTextFileV2Attr func(optionalAttr)

// InitializeTableFromTextFileV2VocabSize sets the optional vocab_size attribute to value.
//
// value: Number of elements of the file, use -1 if unknown.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func InitializeTableFromTextFileV2VocabSize(value int64) InitializeTableFromTextFileV2Attr {
	return func(m optionalAttr) {
		m["vocab_size"] = value
	}
}

// InitializeTableFromTextFileV2Delimiter sets the optional delimiter attribute to value.
//
// value: Delimiter to separate fields in a line.
// If not specified, defaults to "\t"
func InitializeTableFromTextFileV2Delimiter(value string) InitializeTableFromTextFileV2Attr {
	return func(m optionalAttr) {
		m["delimiter"] = value
	}
}

// InitializeTableFromTextFileV2Offset sets the optional offset attribute to value.
// If not specified, defaults to 0
func InitializeTableFromTextFileV2Offset(value int64) InitializeTableFromTextFileV2Attr {
	return func(m optionalAttr) {
		m["offset"] = value
	}
}

// Initializes a table from a text file.
//
// It inserts one key-value pair into the table for each line of the file.
// The key and value is extracted from the whole line content, elements from the
// split line based on `delimiter` or the line number (starting from zero).
// Where to extract the key and value from a line is specified by `key_index` and
// `value_index`.
//
// - A value of -1 means use the line number(starting from zero), expects `int64`.
// - A value of -2 means use the whole line content, expects `string`.
// - A value >= 0 means use the index (starting at zero) of the split line based
//   on `delimiter`.
//
// Arguments:
//	table_handle: Handle to a table which will be initialized.
//	filename: Filename of a vocabulary text file.
//	key_index: Column index in a line to get the table `key` values from.
//	value_index: Column index that represents information of a line to get the table
// `value` values from.
//
// Returns the created operation.
func InitializeTableFromTextFileV2(scope *Scope, table_handle tf.Output, filename tf.Output, key_index int64, value_index int64, optional ...InitializeTableFromTextFileV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_index": key_index, "value_index": value_index}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InitializeTableFromTextFileV2",
		Input: []tf.Input{
			table_handle, filename,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MutableDenseHashTableV2Attr is an optional argument to MutableDenseHashTableV2.
type MutableDenseHashTableV2Attr func(optionalAttr)

// MutableDenseHashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableDenseHashTableV2Container(value string) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableDenseHashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableDenseHashTableV2SharedName(value string) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableDenseHashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
// If not specified, defaults to false
func MutableDenseHashTableV2UseNodeNameSharing(value bool) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// MutableDenseHashTableV2ValueShape sets the optional value_shape attribute to value.
//
// value: The shape of each value.
// If not specified, defaults to <>
func MutableDenseHashTableV2ValueShape(value tf.Shape) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// MutableDenseHashTableV2InitialNumBuckets sets the optional initial_num_buckets attribute to value.
//
// value: The initial number of hash table buckets. Must be a power
// to 2.
// If not specified, defaults to 131072
func MutableDenseHashTableV2InitialNumBuckets(value int64) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["initial_num_buckets"] = value
	}
}

// MutableDenseHashTableV2MaxLoadFactor sets the optional max_load_factor attribute to value.
//
// value: The maximum ratio between number of entries and number of
// buckets before growing the table. Must be between 0 and 1.
// If not specified, defaults to 0.8
func MutableDenseHashTableV2MaxLoadFactor(value float32) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["max_load_factor"] = value
	}
}

// Creates an empty hash table that uses tensors as the backing store.
//
// It uses "open addressing" with quadratic reprobing to resolve
// collisions.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a scalar. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//	empty_key: The key used to represent empty key buckets internally. Must not
// be used in insert or lookup operations.
//
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableDenseHashTableV2(scope *Scope, empty_key tf.Output, deleted_key tf.Output, value_dtype tf.DataType, optional ...MutableDenseHashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableDenseHashTableV2",
		Input: []tf.Input{
			empty_key, deleted_key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MutableHashTableV2Attr is an optional argument to MutableHashTableV2.
type MutableHashTableV2Attr func(optionalAttr)

// MutableHashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableHashTableV2Container(value string) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableHashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableHashTableV2SharedName(value string) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableHashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
//
// value: If true and shared_name is empty, the table is shared
// using the node name.
// If not specified, defaults to false
func MutableHashTableV2UseNodeNameSharing(value bool) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// Creates an empty hash table.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a scalar. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableHashTableV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...MutableHashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableHashTableV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Calculates the prior from the training data (the bias) and fills in the first node with the logits' prior. Returns a boolean indicating whether to continue centering.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble.
//	mean_gradients: A tensor with shape=[logits_dimension] with mean of gradients for a first node.
//	mean_hessians: A tensor with shape=[logits_dimension] mean of hessians for a first node.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//
// Returns Bool, whether to continue bias centering.
func BoostedTreesCenterBias(scope *Scope, tree_ensemble_handle tf.Output, mean_gradients tf.Output, mean_hessians tf.Output, l1 tf.Output, l2 tf.Output) (continue_centering tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCenterBias",
		Input: []tf.Input{
			tree_ensemble_handle, mean_gradients, mean_hessians, l1, l2,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// HashTableV2Attr is an optional argument to HashTableV2.
type HashTableV2Attr func(optionalAttr)

// HashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func HashTableV2Container(value string) HashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// HashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func HashTableV2SharedName(value string) HashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// HashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
//
// value: If true and shared_name is empty, the table is shared
// using the node name.
// If not specified, defaults to false
func HashTableV2UseNodeNameSharing(value bool) HashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// Creates a non-initialized hash table.
//
// This op creates a hash table, specifying the type of its keys and values.
// Before using the table you will have to initialize it.  After initialization the
// table will be immutable.
//
// Arguments:
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func HashTableV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...HashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "HashTableV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Check if the input matches the regex pattern.
//
// The input is a string tensor of any shape. The pattern is a scalar
// string tensor which is applied to every element of the input tensor.
// The boolean values (True or False) of the output tensor indicate
// if the input matches the regex pattern provided.
//
// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Examples:
//
// >>> tf.strings.regex_full_match(["TF lib", "lib TF"], ".*lib$")
// <tf.Tensor: shape=(2,), dtype=bool, numpy=array([ True, False])>
// >>> tf.strings.regex_full_match(["TF lib", "lib TF"], ".*TF$")
// <tf.Tensor: shape=(2,), dtype=bool, numpy=array([False,  True])>
//
// Arguments:
//	input: A string tensor of the text to be processed.
//	pattern: A scalar string tensor containing the regular expression to match the input.
//
// Returns A bool tensor with the same shape as `input`.
func RegexFullMatch(scope *Scope, input tf.Output, pattern tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RegexFullMatch",
		Input: []tf.Input{
			input, pattern,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixDiagV3Attr is an optional argument to MatrixDiagV3.
type MatrixDiagV3Attr func(optionalAttr)

// MatrixDiagV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixDiagV3Align(value string) MatrixDiagV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns a batched diagonal tensor with given batched diagonal values.
//
// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
// and `num_cols` specify the dimension of the innermost matrix of the output. If
// both are not specified, the op assumes the innermost matrix is square and infers
// its size from `k` and the innermost dimension of `diagonal`. If only one of them
// is specified, the op assumes the unspecified value is the smallest possible
// based on other criteria.
//
// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
//
// The second innermost dimension of `diagonal` has double meaning.
// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
// [I, J, ..., M], and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
//     padding_value                             ; otherwise
// ```
//
// Otherwise, `M` is treated as the number of diagonals for the matrix in the
// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//     padding_value                                     ; otherwise
// ```
// where `d = n - m`, `diag_index = [k] - d`, and
// `index_in_diag = n - max(d, 0) + offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//                                            and `d >= 0`) or
//                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//                                            and `d <= 0`)
//          0                          ; otherwise
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// For example:
//
// ```
// # The main diagonal.
// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
//                      [5, 6, 7, 8]])
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
//                                [0, 2, 0, 0],
//                                [0, 0, 3, 0],
//                                [0, 0, 0, 4]],
//                               [[5, 0, 0, 0],
//                                [0, 6, 0, 0],
//                                [0, 0, 7, 0],
//                                [0, 0, 0, 8]]]
//
// # A superdiagonal (per batch).
// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
//                      [4, 5, 6]])
// tf.matrix_diag(diagonal, k = 1)
//   ==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
//         [0, 0, 2, 0],
//         [0, 0, 0, 3],
//         [0, 0, 0, 0]],
//        [[0, 4, 0, 0],
//         [0, 0, 5, 0],
//         [0, 0, 0, 6],
//         [0, 0, 0, 0]]]
//
// # A tridiagonal band (per batch).
// diagonals = np.array([[[0, 8, 9],  # Input shape: (2, 2, 3)
//                        [1, 2, 3],
//                        [4, 5, 0]],
//                       [[0, 2, 3],
//                        [6, 7, 9],
//                        [9, 1, 0]]])
// tf.matrix_diag(diagonals, k = (-1, 1))
//   ==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
//         [4, 2, 9],
//         [0, 5, 3]],
//        [[6, 2, 0],
//         [9, 7, 3],
//         [0, 1, 9]]]
//
// # LEFT_RIGHT alignment.
// diagonals = np.array([[[8, 9, 0],  # Input shape: (2, 2, 3)
//                        [1, 2, 3],
//                        [0, 4, 5]],
//                       [[2, 3, 0],
//                        [6, 7, 9],
//                        [0, 9, 1]]])
// tf.matrix_diag(diagonals, k = (-1, 1), align="LEFT_RIGHT")
//   ==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
//         [4, 2, 9],
//         [0, 5, 3]],
//        [[6, 2, 0],
//         [9, 7, 3],
//         [0, 1, 9]]]
//
// # Rectangular matrix.
// diagonal = np.array([1, 2])  # Input shape: (2)
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
//   ==> [[0, 0, 0, 0],  # Output shape: (3, 4)
//        [1, 0, 0, 0],
//        [0, 2, 0, 0]]
//
// # Rectangular matrix with inferred num_cols and padding_value = 9.
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
//   ==> [[9, 9],  # Output shape: (3, 2)
//        [1, 9],
//        [9, 2]]
//
// ```
//
// Arguments:
//	diagonal: Rank `r`, where `r >= 1`
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//	num_rows: The number of rows of the output matrix. If it is not provided, the op assumes
// the output matrix is a square matrix and infers the matrix size from k and the
// innermost dimension of `diagonal`.
//	num_cols: The number of columns of the output matrix. If it is not provided, the op
// assumes the output matrix is a square matrix and infers the matrix size from
// k and the innermost dimension of `diagonal`.
//	padding_value: The number to fill the area outside the specified diagonal band with.
// Default is 0.
//
// Returns Has rank `r+1` when `k` is an integer or `k[0] == k[1]`, rank `r` otherwise.
func MatrixDiagV3(scope *Scope, diagonal tf.Output, k tf.Output, num_rows tf.Output, num_cols tf.Output, padding_value tf.Output, optional ...MatrixDiagV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagV3",
		Input: []tf.Input{
			diagonal, k, num_rows, num_cols, padding_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high overlaps
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed. N-by-n overlap values are supplied as square matrix,
// which allows for defining a custom overlap criterium (eg. intersection over union,
// intersection over area, etc.).
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//   selected_indices = tf.image.non_max_suppression_with_overlaps(
//       overlaps, scores, max_output_size, overlap_threshold, score_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	overlaps: A 2-D float tensor of shape `[num_boxes, num_boxes]` representing
// the n-by-n box overlap values.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	overlap_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionWithOverlaps(scope *Scope, overlaps tf.Output, scores tf.Output, max_output_size tf.Output, overlap_threshold tf.Output, score_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionWithOverlaps",
		Input: []tf.Input{
			overlaps, scores, max_output_size, overlap_threshold, score_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs all keys and values in the table.
//
// Arguments:
//	table_handle: Handle to the table.
//
//
//
// Returns:
//	keys: Vector of all keys present in the table.
//	values: Tensor of all values in the table. Indexed in parallel with `keys`.
func LookupTableExportV2(scope *Scope, table_handle tf.Output, Tkeys tf.DataType, Tvalues tf.DataType) (keys tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tkeys": Tkeys, "Tvalues": Tvalues}
	opspec := tf.OpSpec{
		Type: "LookupTableExportV2",
		Input: []tf.Input{
			table_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Assigns a new value to a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to return
// this value or a subsequent newer value of the variable.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	value: the value to set the new tensor to use.
//
// Returns the created operation.
func AssignVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// PaddingFIFOQueueV2Attr is an optional argument to PaddingFIFOQueueV2.
type PaddingFIFOQueueV2Attr func(optionalAttr)

// PaddingFIFOQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types.
// Shapes of fixed rank but variable size are allowed by setting
// any shape dimension to -1.  In this case, the inputs' shape may vary along
// the given dimension, and DequeueMany will pad the given dimension with
// zeros up to the maximum shape of all elements in the given batch.
// If the length of this attr is 0, different queue elements may have
// different ranks and shapes, but only one element may be dequeued at a time.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func PaddingFIFOQueueV2Shapes(value []tf.Shape) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// PaddingFIFOQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func PaddingFIFOQueueV2Capacity(value int64) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// PaddingFIFOQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func PaddingFIFOQueueV2Container(value string) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// PaddingFIFOQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func PaddingFIFOQueueV2SharedName(value string) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that produces elements in first-in first-out order.
//
// Variable-size shapes are allowed by setting the corresponding shape dimensions
// to 0 in the shape attr.  In this case DequeueMany will pad up to the maximum
// size of any given element in the minibatch.  See below for details.
//
// Arguments:
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func PaddingFIFOQueueV2(scope *Scope, component_types []tf.DataType, optional ...PaddingFIFOQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddingFIFOQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns whether the given key exists in the map.
//
// input_handle: the input map
// key: the key to check
// has_key: whether the key is already in the map or not
func TensorMapHasKey(scope *Scope, input_handle tf.Output, key tf.Output) (has_key tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorMapHasKey",
		Input: []tf.Input{
			input_handle, key,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a tensor map with item from given key erased.
//
// input_handle: the original map
// output_handle: the map with value from given key removed
// key: the key of the value to be erased
func TensorMapErase(scope *Scope, input_handle tf.Output, key tf.Output, value_dtype tf.DataType) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	opspec := tf.OpSpec{
		Type: "TensorMapErase",
		Input: []tf.Input{
			input_handle, key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradAttr is an optional argument to MaxPoolGradGrad.
type MaxPoolGradGradAttr func(optionalAttr)

// MaxPoolGradGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradGradDataFormat(value string) MaxPoolGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the number of tensors in the input tensor map.
//
// input_handle: the input map
// size: the number of tensors in the map
func TensorMapSize(scope *Scope, input_handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorMapSize",
		Input: []tf.Input{
			input_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorList by indexing into a Tensor.
//
// Each member of the TensorList corresponds to one row of the input tensor,
// specified by the given index (see `tf.gather`).
//
// tensor: The input tensor.
// indices: The indices used to index into the list.
// element_shape: The shape of the elements in the list (can be less specified than
//   the shape of the tensor).
// output_handle: The TensorList.
func TensorListScatter(scope *Scope, tensor tf.Output, indices tf.Output, element_shape tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListScatter",
		Input: []tf.Input{
			tensor, indices, element_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Sets the index-th position of the list to contain the given tensor.
//
// input_handle: the list
// index: the position in the list to which the tensor will be assigned
// item: the element to be assigned to that position
// output_handle: the new list, with the element in the proper position
//
func TensorListSetItem(scope *Scope, input_handle tf.Output, index tf.Output, item tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListSetItem",
		Input: []tf.Input{
			input_handle, index, item,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Clips tensor values to a specified min and max.
//
// Given a tensor `t`, this operation returns a tensor of the same type and
// shape as `t` with its values clipped to `clip_value_min` and `clip_value_max`.
// Any values less than `clip_value_min` are set to `clip_value_min`. Any values
// greater than `clip_value_max` are set to `clip_value_max`.
//
// Arguments:
//	t: A `Tensor`.
//	clip_value_min: A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
// as `t`. The minimum value to clip by.
//	clip_value_max: A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
// as `t`. The maximum value to clip by.
//
// Returns A clipped `Tensor` with the same shape as input 't'.
func ClipByValue(scope *Scope, t tf.Output, clip_value_min tf.Output, clip_value_max tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ClipByValue",
		Input: []tf.Input{
			t, clip_value_min, clip_value_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// List of the given size with empty elements.
//
// element_shape: the shape of the future elements of the list
// num_elements: the number of elements to reserve
// handle: the output list
// element_dtype: the desired type of elements in the list.
func TensorListReserve(scope *Scope, element_shape tf.Output, num_elements tf.Output, element_dtype tf.DataType) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListReserve",
		Input: []tf.Input{
			element_shape, num_elements,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalThreadPoolHandleAttr is an optional argument to ExperimentalThreadPoolHandle.
type ExperimentalThreadPoolHandleAttr func(optionalAttr)

// ExperimentalThreadPoolHandleMaxIntraOpParallelism sets the optional max_intra_op_parallelism attribute to value.
//
// value: The maximum degree of parallelism to use within operations that execute on this
// threadpool.
// If not specified, defaults to 1
func ExperimentalThreadPoolHandleMaxIntraOpParallelism(value int64) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["max_intra_op_parallelism"] = value
	}
}

// ExperimentalThreadPoolHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func ExperimentalThreadPoolHandleContainer(value string) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ExperimentalThreadPoolHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ExperimentalThreadPoolHandleSharedName(value string) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//	num_threads: The number of threads in the thread pool.
//	display_name: A human-readable name for the threads that may be visible in some
// visualizations.
// threadpool.
//
// Returns A resource that can be consumed by one or more ExperimentalThreadPoolDataset
// ops.
func ExperimentalThreadPoolHandle(scope *Scope, num_threads int64, display_name string, optional ...ExperimentalThreadPoolHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_threads": num_threads, "display_name": display_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorList which, when stacked, has the value of `tensor`.
//
// Each tensor in the result list corresponds to one row of the input tensor.
//
// tensor: The input tensor.
// output_handle: The list.
func TensorListFromTensor(scope *Scope, tensor tf.Output, element_shape tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListFromTensor",
		Input: []tf.Input{
			tensor, element_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Concats all tensors in the list along the 0th dimension.
//
// Requires that all tensors have the same shape except the first dimension.
//
// input_handle: The input list.
// element_shape: The shape of the uninitialized elements in the list. If the first
//   dimension is not -1, it is assumed that all list elements have the same
//   leading dim.
// leading_dims: The list of leading dims of uninitialized list elements. Used if
//   the leading dim of input_handle.element_shape or the element_shape input arg
//   is not already set.
// tensor: The concated result.
// lengths: Output tensor containing sizes of the 0th dimension of tensors in the list, used for computing the gradient.
//
func TensorListConcatV2(scope *Scope, input_handle tf.Output, element_shape tf.Output, leading_dims tf.Output, element_dtype tf.DataType) (tensor tf.Output, lengths tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListConcatV2",
		Input: []tf.Input{
			input_handle, element_shape, leading_dims,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// TensorListStackAttr is an optional argument to TensorListStack.
type TensorListStackAttr func(optionalAttr)

// TensorListStackNumElements sets the optional num_elements attribute to value.
// If not specified, defaults to -1
func TensorListStackNumElements(value int64) TensorListStackAttr {
	return func(m optionalAttr) {
		m["num_elements"] = value
	}
}

// Stacks all tensors in the list.
//
// Requires that all tensors have the same shape.
//
// input_handle: the input list
// tensor: the gathered result
// num_elements: optional. If not -1, the number of elements in the list.
//
func TensorListStack(scope *Scope, input_handle tf.Output, element_shape tf.Output, element_dtype tf.DataType, optional ...TensorListStackAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorListStack",
		Input: []tf.Input{
			input_handle, element_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that contains `count` elements from the `input_dataset`.
//
// Arguments:
//
//	count: A scalar representing the number of elements from the `input_dataset`
// that should be taken. A value of `-1` indicates that all of `input_dataset`
// is taken.
//
//
func TakeDataset(scope *Scope, input_dataset tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "TakeDataset",
		Input: []tf.Input{
			input_dataset, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Scatter `updates` into an existing tensor according to `indices`.
//
// This operation creates a new tensor by applying sparse `updates` to the passed
// in `tensor`.
// This operation is very similar to `tf.scatter_nd`, except that the updates are
// scattered onto an existing tensor (as opposed to a zero-tensor). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// If `indices` contains duplicates, then we pick the last update for the index.
//
// If an out of bound index is found on CPU, an error is returned.
//
// **WARNING**: There are some GPU specific semantics for this operation.
// - If an out of bound index is found, the index is ignored.
// - The order in which updates are applied is nondeterministic, so the output
// will be nondeterministic if `indices` contains duplicates.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `shape`.
//
// * `indices` must have at least 2 axes: `(num_updates, index_depth)`.
// * The last axis of `indices` is how deep to index into `tensor` so  this index
//   depth must be less than the rank of `tensor`: `indices.shape[-1] <= tensor.ndim`
//
// if `indices.shape[-1] = tensor.rank` this Op indexes and updates scalar elements.
// if `indices.shape[-1] < tensor.rank` it indexes and updates slices of the input
// `tensor`.
//
// Each `update` has a rank of `tensor.rank - indices.shape[-1]`.
// The overall shape of `updates` is:
//
// ```
// indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
// ```
//
// For usage examples see the python [tf.tensor_scatter_nd_update](
// https://www.tensorflow.org/api_docs/python/tf/tensor_scatter_nd_update) function
//
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor with the given shape and updates applied according
// to the indices.
func TensorScatterUpdate(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterUpdate",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the last element of the input list as well as a list with all but that element.
//
// Fails if the list is empty.
//
// input_handle: the input list
// tensor: the withdrawn last element of the list
// element_dtype: the type of elements in the list
// element_shape: the shape of the output tensor
func TensorListPopBack(scope *Scope, input_handle tf.Output, element_shape tf.Output, element_dtype tf.DataType) (output_handle tf.Output, tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListPopBack",
		Input: []tf.Input{
			input_handle, element_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns the number of tensors in the input tensor list.
//
// input_handle: the input list
// length: the number of tensors in the list
func TensorListLength(scope *Scope, input_handle tf.Output) (length tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListLength",
		Input: []tf.Input{
			input_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the maximum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
// that `segment_ids[j] == i`.
//
// If the max is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMax.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_max(c, tf.constant([0, 0, 1]))
// # ==> [[4, 3, 3, 4],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMax(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMax",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CastAttr is an optional argument to Cast.
type CastAttr func(optionalAttr)

// CastTruncate sets the optional Truncate attribute to value.
// If not specified, defaults to false
func CastTruncate(value bool) CastAttr {
	return func(m optionalAttr) {
		m["Truncate"] = value
	}
}

// Cast x of type SrcT to y of DstT.
func Cast(scope *Scope, x tf.Output, DstT tf.DataType, optional ...CastAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"DstT": DstT}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cast",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MeanAttr is an optional argument to Mean.
type MeanAttr func(optionalAttr)

// MeanKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MeanKeepDims(value bool) MeanAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the mean of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Mean(scope *Scope, input tf.Output, axis tf.Output, optional ...MeanAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Mean",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA ConvGeneralDilated operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
// .
//
// Arguments:
//	lhs: the input tensor
//	rhs: the kernel tensor
//	window_strides: the inter-window strides
//	padding: the padding to apply at the start and end of each input dimensions
//	lhs_dilation: dilation to apply between input elements
//	rhs_dilation: dilation to apply between kernel elements
//	feature_group_count: number of feature groups for grouped convolution.
//	dimension_numbers: a serialized xla::ConvolutionDimensionNumbers proto.
//	precision_config: a serialized xla::PrecisionConfig proto.
//	preferred_element_type: The type of the tensor.
func XlaConvV2(scope *Scope, lhs tf.Output, rhs tf.Output, window_strides tf.Output, padding tf.Output, lhs_dilation tf.Output, rhs_dilation tf.Output, feature_group_count tf.Output, dimension_numbers string, precision_config string, preferred_element_type tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dimension_numbers": dimension_numbers, "precision_config": precision_config, "preferred_element_type": preferred_element_type}
	opspec := tf.OpSpec{
		Type: "XlaConvV2",
		Input: []tf.Input{
			lhs, rhs, window_strides, padding, lhs_dilation, rhs_dilation, feature_group_count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Op that reshards on-device TPU variables to specified state.
//
// Op that reshards on-device TPU variables to specified state. Internal use only.
//
// The sharding state is represented as the key of the compilation that generated
// the sharding/unsharding programs along with the main program. new_format_key
// specifies the desired state, and format_state_var is the current state of the
// variables.
//
// Returns the created operation.
func TPUReshardVariables(scope *Scope, vars []tf.Output, new_format_key tf.Output, format_state_var tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TPUReshardVariables",
		Input: []tf.Input{
			tf.OutputList(vars), new_format_key, format_state_var,
		},
	}
	return scope.AddOperation(opspec)
}

// Returns the cardinality of `input_dataset`.
//
// Returns the cardinality of `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return cardinality for.
//
// Returns The cardinality of `input_dataset`. Named constants are used to represent
// infinite and unknown cardinality.
func DatasetCardinality(scope *Scope, input_dataset tf.Output) (cardinality tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetCardinality",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs random integers from a uniform distribution.
//
// The generated values are uniform integers in the range `[minval, maxval)`.
// The lower bound `minval` is included in the range, while the upper bound
// `maxval` is excluded.
//
// The random integers are slightly biased unless `maxval - minval` is an exact
// power of two.  The bias is small for values of `maxval - minval` significantly
// smaller than the range of the output (either `2^32` or `2^64`).
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//	minval: Minimum value (inclusive, scalar).
//	maxval: Maximum value (exclusive, scalar).
//
// Returns Random values with specified shape.
func StatefulUniformInt(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, minval tf.Output, maxval tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatefulUniformInt",
		Input: []tf.Input{
			resource, algorithm, shape, minval, maxval,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugNumericSummaryAttr is an optional argument to DebugNumericSummary.
type DebugNumericSummaryAttr func(optionalAttr)

// DebugNumericSummaryDeviceName sets the optional device_name attribute to value.
// If not specified, defaults to ""
func DebugNumericSummaryDeviceName(value string) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugNumericSummaryTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugNumericSummaryTensorName(value string) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugNumericSummaryDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//   file:///foo/tfdbg_dump, grpc:://localhost:11011.
// If not specified, defaults to <>
func DebugNumericSummaryDebugUrls(value []string) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugNumericSummaryLowerBound sets the optional lower_bound attribute to value.
//
// value: (float) The lower bound <= which values will be included in the
//   generalized -inf count. Default: -inf.
// If not specified, defaults to -inf
func DebugNumericSummaryLowerBound(value float32) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["lower_bound"] = value
	}
}

// DebugNumericSummaryUpperBound sets the optional upper_bound attribute to value.
//
// value: (float) The upper bound >= which values will be included in the
//   generalized +inf count. Default: +inf.
// If not specified, defaults to inf
func DebugNumericSummaryUpperBound(value float32) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["upper_bound"] = value
	}
}

// DebugNumericSummaryMuteIfHealthy sets the optional mute_if_healthy attribute to value.
//
// value: (bool) Do not send data to the debug URLs unless at least one
//   of elements [2], [3] and [7] (i.e., the nan count and the generalized -inf and
//   inf counts) is non-zero.
// If not specified, defaults to false
func DebugNumericSummaryMuteIfHealthy(value bool) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["mute_if_healthy"] = value
	}
}

// DebugNumericSummaryGatedGrpc sets the optional gated_grpc attribute to value.
//
// value: Whether this op will be gated. If any of the debug_urls of this
//   debug node is of the grpc:// scheme, when the value of this attribute is set
//   to True, the data will not actually be sent via the grpc stream unless this
//   debug op has been enabled at the debug_url. If all of the debug_urls of this
//   debug node are of the grpc:// scheme and the debug op is enabled at none of
//   them, the output will be an empty Tensor.
// If not specified, defaults to false
func DebugNumericSummaryGatedGrpc(value bool) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Debug Numeric Summary Op.
//
// Provide a basic summary of numeric value types, range and distribution.
//
// output: A double tensor of shape [14 + nDimensions], where nDimensions is the
//   number of dimensions of the tensor's shape. The elements of output are:
//   [0]: is initialized (1.0) or not (0.0).
//   [1]: total number of elements
//   [2]: NaN element count
//   [3]: generalized -inf count: elements <= lower_bound. lower_bound is -inf by
//     default.
//   [4]: negative element count (excluding -inf), if lower_bound is the default
//     -inf. Otherwise, this is the count of elements > lower_bound and < 0.
//   [5]: zero element count
//   [6]: positive element count (excluding +inf), if upper_bound is the default
//     +inf. Otherwise, this is the count of elements < upper_bound and > 0.
//   [7]: generalized +inf count, elements >= upper_bound. upper_bound is +inf by
//     default.
// Output elements [1:8] are all zero, if the tensor is uninitialized.
//   [8]: minimum of all non-inf and non-NaN elements.
//        If uninitialized or no such element exists: +inf.
//   [9]: maximum of all non-inf and non-NaN elements.
//        If uninitialized or no such element exists: -inf.
//   [10]: mean of all non-inf and non-NaN elements.
//         If uninitialized or no such element exists: NaN.
//   [11]: variance of all non-inf and non-NaN elements.
//         If uninitialized or no such element exists: NaN.
//   [12]: Data type of the tensor encoded as an enum integer. See the DataType
//         proto for more details.
//   [13]: Number of dimensions of the tensor (ndims).
//   [14+]: Sizes of the dimensions.
//
//
// Arguments:
//	input: Input tensor, non-Reference type.
func DebugNumericSummary(scope *Scope, input tf.Output, optional ...DebugNumericSummaryAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNumericSummary",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An Op to exchange data across TPU replicas.
//
// On each replica, the input is split into `split_count` blocks along
// `split_dimension` and send to the other replicas given group_assignment. After
// receiving `split_count` - 1 blocks from other replicas, we concatenate the
// blocks along `concat_dimension` as the output.
//
// For example, suppose there are 2 TPU replicas:
// replica 0 receives input: `[[A, B]]`
// replica 1 receives input: `[[C, D]]`
//
// group_assignment=`[[0, 1]]`
// concat_dimension=0
// split_dimension=1
// split_count=2
//
// replica 0's output: `[[A], [C]]`
// replica 1's output: `[[B], [D]]`
//
// Arguments:
//	input: The local input to the sum.
//	group_assignment: An int32 tensor with shape
// [num_groups, num_replicas_per_group]. `group_assignment[i]` represents the
// replica ids in the ith subgroup.
//	concat_dimension: The dimension number to concatenate.
//	split_dimension: The dimension number to split.
//	split_count: The number of splits, this number must equal to the sub-group
// size(group_assignment.get_shape()[1])
//
// Returns The exchanged result.
func AllToAll(scope *Scope, input tf.Output, group_assignment tf.Output, concat_dimension int64, split_dimension int64, split_count int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"concat_dimension": concat_dimension, "split_dimension": split_dimension, "split_count": split_count}
	opspec := tf.OpSpec{
		Type: "AllToAll",
		Input: []tf.Input{
			input, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TridiagonalSolveAttr is an optional argument to TridiagonalSolve.
type TridiagonalSolveAttr func(optionalAttr)

// TridiagonalSolvePartialPivoting sets the optional partial_pivoting attribute to value.
//
// value: Whether to apply partial pivoting. Partial pivoting makes the procedure more
// stable, but slower.
// If not specified, defaults to true
func TridiagonalSolvePartialPivoting(value bool) TridiagonalSolveAttr {
	return func(m optionalAttr) {
		m["partial_pivoting"] = value
	}
}

// TridiagonalSolvePerturbSingular sets the optional perturb_singular attribute to value.
// If not specified, defaults to false
func TridiagonalSolvePerturbSingular(value bool) TridiagonalSolveAttr {
	return func(m optionalAttr) {
		m["perturb_singular"] = value
	}
}

// Solves tridiagonal systems of equations.
//
//   Solves tridiagonal systems of equations.
//   Supports batch dimensions and multiple right-hand sides per each left-hand
//   side.
//   On CPU, solution is computed via Gaussian elimination with or without partial
//   pivoting, depending on `partial_pivoting` attribute. On GPU, Nvidia's cuSPARSE
//   library is used: https://docs.nvidia.com/cuda/cusparse/index.html#gtsv
//   Partial pivoting is not yet supported by XLA backends.
//
// Arguments:
//	diagonals: Tensor of shape `[..., 3, M]` whose innermost 2 dimensions represent the
// tridiagonal matrices with three rows being the superdiagonal, diagonals, and
// subdiagonals, in order. The last element of the superdiagonal and the first
// element of the subdiagonal is ignored.
//	rhs: Tensor of shape `[..., M, K]`, representing K right-hand sides per each
// left-hand side.
//
// Returns Tensor of shape `[..., M, K]` containing the solutions
func TridiagonalSolve(scope *Scope, diagonals tf.Output, rhs tf.Output, optional ...TridiagonalSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TridiagonalSolve",
		Input: []tf.Input{
			diagonals, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixTriangularSolveAttr is an optional argument to MatrixTriangularSolve.
type MatrixTriangularSolveAttr func(optionalAttr)

// MatrixTriangularSolveLower sets the optional lower attribute to value.
//
// value: Boolean indicating whether the innermost matrices in `matrix` are
// lower or upper triangular.
// If not specified, defaults to true
func MatrixTriangularSolveLower(value bool) MatrixTriangularSolveAttr {
	return func(m optionalAttr) {
		m["lower"] = value
	}
}

// MatrixTriangularSolveAdjoint sets the optional adjoint attribute to value.
//
// value: Boolean indicating whether to solve with `matrix` or its (block-wise)
//          adjoint.
//
// @compatibility(numpy)
// Equivalent to scipy.linalg.solve_triangular
// @end_compatibility
// If not specified, defaults to false
func MatrixTriangularSolveAdjoint(value bool) MatrixTriangularSolveAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Solves systems of linear equations with upper or lower triangular matrices by backsubstitution.
//
//
// `matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions form
// square matrices. If `lower` is `True` then the strictly upper triangular part
// of each inner-most matrix is assumed to be zero and not accessed.
// If `lower` is False then the strictly lower triangular part of each inner-most
// matrix is assumed to be zero and not accessed.
// `rhs` is a tensor of shape `[..., M, N]`.
//
// The output is a tensor of shape `[..., M, N]`. If `adjoint` is
// `True` then the innermost matrices in `output` satisfy matrix equations
// `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
// If `adjoint` is `False` then the strictly then the  innermost matrices in
// `output` satisfy matrix equations
// `adjoint(matrix[..., i, k]) * output[..., k, j] = rhs[..., i, j]`.
//
// Note, the batch shapes for the inputs only need to broadcast.
//
// Example:
// ```python
//
// a = tf.constant([[3,  0,  0,  0],
//                  [2,  1,  0,  0],
//                  [1,  0,  1,  0],
//                  [1,  1,  1,  1]], dtype=tf.float32)
//
// b = tf.constant([[4],
//                  [2],
//                  [4],
//                  [2]], dtype=tf.float32)
//
// x = tf.linalg.triangular_solve(a, b, lower=True)
// x
// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
// # array([[ 1.3333334 ],
// #        [-0.66666675],
// #        [ 2.6666665 ],
// #        [-1.3333331 ]], dtype=float32)>
//
// # in python3 one can use `a@x`
// tf.matmul(a, x)
// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
// # array([[4.       ],
// #        [2.       ],
// #        [4.       ],
// #        [1.9999999]], dtype=float32)>
// ```
//
// Arguments:
//	matrix: Shape is `[..., M, M]`.
//	rhs: Shape is `[..., M, K]`.
//
// Returns Shape is `[..., M, K]`.
func MatrixTriangularSolve(scope *Scope, matrix tf.Output, rhs tf.Output, optional ...MatrixTriangularSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixTriangularSolve",
		Input: []tf.Input{
			matrix, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Applies sparse addition to `input` using individual values or slices
//
// from `updates` according to indices `indices`.  The updates are non-aliasing:
// `input` is only modified in-place if no other operations will use it.
// Otherwise, a copy of `input` is made.  This operation has a gradient with
// respect to both `input` and `updates`.
//
// `input` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `input`.
// It must be shape \\([d_0, ..., d_{Q-2}, K]\\) where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or `(P-K)`-dimensional slices
// (if `K < P`) along the `K`th dimension of `input`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// $$[d_0, ..., d_{Q-2}, input.shape[K], ..., input.shape[P-1]].$$
//
// For example, say we want to add 4 scattered elements to a rank-1 tensor to 8
// elements. In Python, that addition would look like this:
//
//     input = tf.constant([1, 2, 3, 4, 5, 6, 7, 8])
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     output = tf.scatter_nd_non_aliasing_add(input, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(output))
//
// The resulting value `output` would look like this:
//
//     [1, 13, 3, 14, 14, 6, 7, 20]
//
// See `tf.scatter_nd` for more details about how to make updates to slices.
//
// Arguments:
//	input: A Tensor.
//	indices: A Tensor. Must be one of the following types: `int32`, `int64`.
// A tensor of indices into `input`.
//	updates: A Tensor. Must have the same type as ref. A tensor of updated values
// to add to `input`.
//
// Returns A `Tensor` with the same shape as `input`, containing values of `input`
// updated with `updates`.
func ScatterNdNonAliasingAdd(scope *Scope, input tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ScatterNdNonAliasingAdd",
		Input: []tf.Input{
			input, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ProdAttr is an optional argument to Prod.
type ProdAttr func(optionalAttr)

// ProdKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func ProdKeepDims(value bool) ProdAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the product of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Prod(scope *Scope, input tf.Output, axis tf.Output, optional ...ProdAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Prod",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SampleDistortedBoundingBoxV2Attr is an optional argument to SampleDistortedBoundingBoxV2.
type SampleDistortedBoundingBoxV2Attr func(optionalAttr)

// SampleDistortedBoundingBoxV2Seed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to non-zero, the random number
// generator is seeded by the given `seed`.  Otherwise, it is seeded by a random
// seed.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxV2Seed(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// SampleDistortedBoundingBoxV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxV2Seed2(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// SampleDistortedBoundingBoxV2AspectRatioRange sets the optional aspect_ratio_range attribute to value.
//
// value: The cropped area of the image must have an aspect ratio =
// width / height within this range.
// If not specified, defaults to <f:0.75 f:1.33 >
func SampleDistortedBoundingBoxV2AspectRatioRange(value []float32) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["aspect_ratio_range"] = value
	}
}

// SampleDistortedBoundingBoxV2AreaRange sets the optional area_range attribute to value.
//
// value: The cropped area of the image must contain a fraction of the
// supplied image within this range.
// If not specified, defaults to <f:0.05 f:1 >
func SampleDistortedBoundingBoxV2AreaRange(value []float32) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["area_range"] = value
	}
}

// SampleDistortedBoundingBoxV2MaxAttempts sets the optional max_attempts attribute to value.
//
// value: Number of attempts at generating a cropped region of the image
// of the specified constraints. After `max_attempts` failures, return the entire
// image.
// If not specified, defaults to 100
func SampleDistortedBoundingBoxV2MaxAttempts(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["max_attempts"] = value
	}
}

// SampleDistortedBoundingBoxV2UseImageIfNoBoundingBoxes sets the optional use_image_if_no_bounding_boxes attribute to value.
//
// value: Controls behavior if no bounding boxes supplied.
// If true, assume an implicit bounding box covering the whole input. If false,
// raise an error.
// If not specified, defaults to false
func SampleDistortedBoundingBoxV2UseImageIfNoBoundingBoxes(value bool) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["use_image_if_no_bounding_boxes"] = value
	}
}

// Generate a single randomly distorted bounding box for an image.
//
// Bounding box annotations are often supplied in addition to ground-truth labels
// in image recognition or object localization tasks. A common technique for
// training such a system is to randomly distort an image while preserving
// its content, i.e. *data augmentation*. This Op outputs a randomly distorted
// localization of an object, i.e. bounding box, given an `image_size`,
// `bounding_boxes` and a series of constraints.
//
// The output of this Op is a single bounding box that may be used to crop the
// original image. The output is returned as 3 tensors: `begin`, `size` and
// `bboxes`. The first 2 tensors can be fed directly into `tf.slice` to crop the
// image. The latter may be supplied to `tf.image.draw_bounding_boxes` to visualize
// what the bounding box looks like.
//
// Bounding boxes are supplied and returned as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example,
//
// ```python
//     # Generate a single distorted bounding box.
//     begin, size, bbox_for_draw = tf.image.sample_distorted_bounding_box(
//         tf.shape(image),
//         bounding_boxes=bounding_boxes)
//
//     # Draw the bounding box in an image summary.
//     image_with_box = tf.image.draw_bounding_boxes(tf.expand_dims(image, 0),
//                                                   bbox_for_draw)
//     tf.summary.image('images_with_box', image_with_box)
//
//     # Employ the bounding box to distort the image.
//     distorted_image = tf.slice(image, begin, size)
// ```
//
// Note that if no bounding box information is available, setting
// `use_image_if_no_bounding_boxes = true` will assume there is a single implicit
// bounding box covering the whole image. If `use_image_if_no_bounding_boxes` is
// false and no bounding boxes are supplied, an error is raised.
//
// Arguments:
//	image_size: 1-D, containing `[height, width, channels]`.
//	bounding_boxes: 3-D with shape `[batch, N, 4]` describing the N bounding boxes
// associated with the image.
//	min_object_covered: The cropped area of the image must contain at least this
// fraction of any bounding box supplied. The value of this parameter should be
// non-negative. In the case of 0, the cropped area does not need to overlap
// any of the bounding boxes supplied.
//
// Returns:
//	begin: 1-D, containing `[offset_height, offset_width, 0]`. Provide as input to
// `tf.slice`.
//	size: 1-D, containing `[target_height, target_width, -1]`. Provide as input to
// `tf.slice`.
//	bboxes: 3-D with shape `[1, 1, 4]` containing the distorted bounding box.
// Provide as input to `tf.image.draw_bounding_boxes`.
func SampleDistortedBoundingBoxV2(scope *Scope, image_size tf.Output, bounding_boxes tf.Output, min_object_covered tf.Output, optional ...SampleDistortedBoundingBoxV2Attr) (begin tf.Output, size tf.Output, bboxes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SampleDistortedBoundingBoxV2",
		Input: []tf.Input{
			image_size, bounding_boxes, min_object_covered,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// EigAttr is an optional argument to Eig.
type EigAttr func(optionalAttr)

// EigComputeV sets the optional compute_v attribute to value.
//
// value: If `True` then eigenvectors will be computed and returned in `v`.
// Otherwise, only the eigenvalues will be computed.
// If not specified, defaults to true
func EigComputeV(value bool) EigAttr {
	return func(m optionalAttr) {
		m["compute_v"] = value
	}
}

// Computes the eigen decomposition of one or more square matrices.
//
// Computes the eigenvalues and (optionally) right eigenvectors of each inner matrix in
// `input` such that `input[..., :, :] = v[..., :, :] * diag(e[..., :])`. The eigenvalues
// are sorted in non-decreasing order.
//
// ```python
// # a is a tensor.
// # e is a tensor of eigenvalues.
// # v is a tensor of eigenvectors.
// e, v = eig(a)
// e = eig(a, compute_v=False)
// ```
//
// Arguments:
//	input: `Tensor` input of shape `[N, N]`.
//
//
// Returns:
//	e: Eigenvalues. Shape is `[N]`.
//	v: Eigenvectors. Shape is `[N, N]`.
func Eig(scope *Scope, input tf.Output, Tout tf.DataType, optional ...EigAttr) (e tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Eig",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes the Eigen Decomposition of a batch of square self-adjoint matrices.
//
// DEPRECATED at GraphDef version 11: Use SelfAdjointEigV2 instead.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices, with the same constraints as the single matrix
// SelfAdjointEig.
//
// The result is a [..., M+1, M] matrix with [..., 0,:] containing the
// eigenvalues, and subsequent [...,1:, :] containing the eigenvectors. The eigenvalues
// are sorted in non-decreasing order.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M+1, M]`.
func SelfAdjointEig(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SelfAdjointEig",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reverse mode backpropagated gradient of the Cholesky algorithm.
//
// For an explanation see "Differentiation of the Cholesky algorithm" by
// Iain Murray http://arxiv.org/abs/1602.07527.
//
// Arguments:
//	l: Output of batch Cholesky algorithm l = cholesky(A). Shape is `[..., M, M]`.
// Algorithm depends only on lower triangular part of the innermost matrices of
// this tensor.
//	grad: df/dl where f is some scalar function. Shape is `[..., M, M]`.
// Algorithm depends only on lower triangular part of the innermost matrices of
// this tensor.
//
// Returns Symmetrized version of df/dA . Shape is `[..., M, M]`
func CholeskyGrad(scope *Scope, l tf.Output, grad tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CholeskyGrad",
		Input: []tf.Input{
			l, grad,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Check if the input matches the regex pattern.
//
// The input is a string tensor of any shape. The pattern is the
// regular expression to be matched with every element of the input tensor.
// The boolean values (True or False) of the output tensor indicate
// if the input matches the regex pattern provided.
//
// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: A string tensor of the text to be processed.
//	pattern: The regular expression to match the input.
//
// Returns A bool tensor with the same shape as `input`.
func StaticRegexFullMatch(scope *Scope, input tf.Output, pattern string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pattern": pattern}
	opspec := tf.OpSpec{
		Type: "StaticRegexFullMatch",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseSingleSequenceExampleAttr is an optional argument to ParseSingleSequenceExample.
type ParseSingleSequenceExampleAttr func(optionalAttr)

// ParseSingleSequenceExampleContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleContextSparseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSingleSequenceExampleFeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListDenseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSingleSequenceExampleContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleContextDenseShapes(value []tf.Shape) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSingleSequenceExampleFeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListSparseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSingleSequenceExampleFeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListDenseShapes(value []tf.Shape) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a scalar brain.SequenceExample proto (as strings) into typed tensors.
//
// Arguments:
//	serialized: A scalar containing a binary serialized SequenceExample proto.
//	feature_list_dense_missing_assumed_empty: A vector listing the
// FeatureList keys which may be missing from the SequenceExample.  If the
// associated FeatureList is missing, it is treated as empty.  By default,
// any FeatureList not listed in this vector must exist in the SequenceExample.
//	context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
// The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' context features associated with
// dense values.
//	feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
// (scalars).  The keys expected in the FeatureLists associated with sparse
// values.
//	feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
//	debug_name: A scalar containing the name of the serialized proto.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty scalar if no name is available.
func ParseSingleSequenceExample(scope *Scope, serialized tf.Output, feature_list_dense_missing_assumed_empty tf.Output, context_sparse_keys []tf.Output, context_dense_keys []tf.Output, feature_list_sparse_keys []tf.Output, feature_list_dense_keys []tf.Output, context_dense_defaults []tf.Output, debug_name tf.Output, optional ...ParseSingleSequenceExampleAttr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSingleSequenceExample",
		Input: []tf.Input{
			serialized, feature_list_dense_missing_assumed_empty, tf.OutputList(context_sparse_keys), tf.OutputList(context_dense_keys), tf.OutputList(feature_list_sparse_keys), tf.OutputList(feature_list_dense_keys), tf.OutputList(context_dense_defaults), debug_name,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values
}

// Splits a tensor into a list.
//
// list[i] corresponds to lengths[i] tensors from the input tensor.
// The tensor must have rank at least 1 and contain exactly sum(lengths) elements.
//
// tensor: The input tensor.
// element_shape: A shape compatible with that of elements in the tensor.
// lengths: Vector of sizes of the 0th dimension of tensors in the list.
// output_handle: The list.
func TensorListSplit(scope *Scope, tensor tf.Output, element_shape tf.Output, lengths tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListSplit",
		Input: []tf.Input{
			tensor, element_shape, lengths,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingAdagradParametersAttr is an optional argument to RetrieveTPUEmbeddingAdagradParameters.
type RetrieveTPUEmbeddingAdagradParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingAdagradParametersTableId(value int64) RetrieveTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdagradParametersTableName(value string) RetrieveTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingAdagradParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdagradParametersConfig(value string) RetrieveTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve Adagrad embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the Adagrad optimization algorithm.
//	accumulators: Parameter accumulators updated by the Adagrad optimization algorithm.
func RetrieveTPUEmbeddingAdagradParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingAdagradParametersAttr) (parameters tf.Output, accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingAdagradParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes the sum along sparse segments of a tensor divided by the sqrt of N.
//
// N is the size of the segment being reduced.
//
// Like `SparseSegmentSqrtN`, but allows missing ids in `segment_ids`. If an id is
// missing, the `output` tensor at that position will be zeroed.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//	num_segments: Should equal the number of distinct segment IDs.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SparseSegmentSqrtNWithNumSegments(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSqrtNWithNumSegments",
		Input: []tf.Input{
			data, indices, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the Cholesky decomposition of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices.
//
// The input has to be symmetric and positive definite. Only the lower-triangular
// part of the input will be used for this operation. The upper-triangular part
// will not be read.
//
// The output is a tensor of the same shape as the input
// containing the Cholesky decompositions for all input submatrices `[..., :, :]`.
//
// **Note**: The gradient computation on GPU is faster for large matrices but
// not for large batch dimensions when the submatrices are small. In this
// case it might be faster to use the CPU.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
func Cholesky(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cholesky",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the determinant of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor containing the determinants
// for all input submatrices `[..., :, :]`.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[...]`.
func MatrixDeterminant(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDeterminant",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the set of files matching one or more glob patterns.
//
// Note that this routine only supports wildcard characters in the
// basename portion of the pattern, not in the directory portion.
// Note also that the order of filenames returned is deterministic.
//
// Arguments:
//	pattern: Shell wildcard pattern(s). Scalar or vector of type string.
//
// Returns A vector of matching filenames.
func MatchingFiles(scope *Scope, pattern tf.Output) (filenames tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatchingFiles",
		Input: []tf.Input{
			pattern,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// WriteImageSummaryAttr is an optional argument to WriteImageSummary.
type WriteImageSummaryAttr func(optionalAttr)

// WriteImageSummaryMaxImages sets the optional max_images attribute to value.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func WriteImageSummaryMaxImages(value int64) WriteImageSummaryAttr {
	return func(m optionalAttr) {
		m["max_images"] = value
	}
}

// Writes an image summary.
//
// Writes image `tensor` at `step` with `tag` using summary `writer`.
// `tensor` is image with shape [height, width, channels].
//
// Returns the created operation.
func WriteImageSummary(scope *Scope, writer tf.Output, step tf.Output, tag tf.Output, tensor tf.Output, bad_color tf.Output, optional ...WriteImageSummaryAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "WriteImageSummary",
		Input: []tf.Input{
			writer, step, tag, tensor, bad_color,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MatrixSolveAttr is an optional argument to MatrixSolve.
type MatrixSolveAttr func(optionalAttr)

// MatrixSolveAdjoint sets the optional adjoint attribute to value.
//
// value: Boolean indicating whether to solve with `matrix` or its (block-wise)
// adjoint.
// If not specified, defaults to false
func MatrixSolveAdjoint(value bool) MatrixSolveAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Solves systems of linear equations.
//
// `Matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. `Rhs` is a tensor of shape `[..., M, K]`. The `output` is
// a tensor shape `[..., M, K]`.  If `adjoint` is `False` then each output matrix
// satisfies `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
// If `adjoint` is `True` then each output matrix satisfies
// `adjoint(matrix[..., :, :]) * output[..., :, :] = rhs[..., :, :]`.
//
// Arguments:
//	matrix: Shape is `[..., M, M]`.
//	rhs: Shape is `[..., M, K]`.
//
// Returns Shape is `[..., M, K]`.
func MatrixSolve(scope *Scope, matrix tf.Output, rhs tf.Output, optional ...MatrixSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixSolve",
		Input: []tf.Input{
			matrix, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorArrayConcatV2Attr is an optional argument to TensorArrayConcatV2.
type TensorArrayConcatV2Attr func(optionalAttr)

// TensorArrayConcatV2ElementShapeExcept0 sets the optional element_shape_except0 attribute to value.
// If not specified, defaults to <unknown_rank:true >
func TensorArrayConcatV2ElementShapeExcept0(value tf.Shape) TensorArrayConcatV2Attr {
	return func(m optionalAttr) {
		m["element_shape_except0"] = value
	}
}

// Deprecated. Use TensorArrayConcatV3
func TensorArrayConcatV2(scope *Scope, handle tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayConcatV2Attr) (value tf.Output, lengths tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayConcatV2",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Writes contents to the file at input filename. Creates file and recursively
//
// creates directory if not existing.
//
// Arguments:
//	filename: scalar. The name of the file to which we write the contents.
//	contents: scalar. The content to be written to the output file.
//
// Returns the created operation.
func WriteFile(scope *Scope, filename tf.Output, contents tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteFile",
		Input: []tf.Input{
			filename, contents,
		},
	}
	return scope.AddOperation(opspec)
}

// TruncatedNormalAttr is an optional argument to TruncatedNormal.
type TruncatedNormalAttr func(optionalAttr)

// TruncatedNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func TruncatedNormalSeed(value int64) TruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// TruncatedNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func TruncatedNormalSeed2(value int64) TruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a truncated normal distribution.
//
// The generated values follow a normal distribution with mean 0 and standard
// deviation 1, except that values whose magnitude is more than 2 standard
// deviations from the mean are dropped and re-picked.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with random truncated normal
// values.
func TruncatedNormal(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...TruncatedNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TruncatedNormal",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes requantization range per channel.
//
// Arguments:
//	input: The original input tensor.
//	input_min: The minimum value of the input tensor
//	input_max: The maximum value of the input tensor.
//	clip_value_max: The maximum value of the output that needs to be clipped.
// Example: set this to 6 for Relu6.
//
// Returns:
//	output_min: The minimum value of the final output tensor
//	output_max: The maximum value of the final output tensor.
func RequantizationRangePerChannel(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, clip_value_max float32) (output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"clip_value_max": clip_value_max}
	opspec := tf.OpSpec{
		Type: "RequantizationRangePerChannel",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Creates a dataset that takes a Bernoulli sample of the contents of another dataset.
//
// There is no transformation in the `tf.data` Python API for creating this dataset.
// Instead, it is created as a result of the `filter_with_random_uniform_fusion`
// static optimization. Whether this optimization is performed is determined by the
// `experimental_optimization.filter_with_random_uniform_fusion` option of
// `tf.data.Options`.
//
// Arguments:
//
//	rate: A scalar representing the sample rate. Each element of `input_dataset` is
// retained with this probability, independent of all other elements.
//	seed: A scalar representing seed of random number generator.
//	seed2: A scalar representing seed2 of random number generator.
//
//
func SamplingDataset(scope *Scope, input_dataset tf.Output, rate tf.Output, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "SamplingDataset",
		Input: []tf.Input{
			input_dataset, rate, seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reads and outputs the entire contents of the input filename.
func ReadFile(scope *Scope, filename tf.Output) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReadFile",
		Input: []tf.Input{
			filename,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxVarsPerChannelGradientAttr is an optional argument to FakeQuantWithMinMaxVarsPerChannelGradient.
type FakeQuantWithMinMaxVarsPerChannelGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsPerChannelGradientNumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization; between 2 and 16, inclusive.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsPerChannelGradientNumBits(value int64) FakeQuantWithMinMaxVarsPerChannelGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsPerChannelGradientNarrowRange sets the optional narrow_range attribute to value.
//
// value: Whether to quantize into 2^num_bits - 1 distinct values.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsPerChannelGradientNarrowRange(value bool) FakeQuantWithMinMaxVarsPerChannelGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxVarsPerChannel operation.
//
// Arguments:
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxVars operation,
// shape one of: `[d]`, `[b, d]`,  `[b, h, w, d]`.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxVars operation, shape
//   same as `gradients`.
// min, max: Quantization interval, floats of shape `[d]`.
//
//
//
// Returns:
//	backprops_wrt_input: Backpropagated gradients w.r.t. inputs, shape same as
// `inputs`:
//   `gradients * (inputs >= min && inputs <= max)`.
//	backprop_wrt_min: Backpropagated gradients w.r.t. min parameter, shape `[d]`:
// `sum_per_d(gradients * (inputs < min))`.
//	backprop_wrt_max: Backpropagated gradients w.r.t. max parameter, shape `[d]`:
// `sum_per_d(gradients * (inputs > max))`.
func FakeQuantWithMinMaxVarsPerChannelGradient(scope *Scope, gradients tf.Output, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsPerChannelGradientAttr) (backprops_wrt_input tf.Output, backprop_wrt_min tf.Output, backprop_wrt_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsPerChannelGradient",
		Input: []tf.Input{
			gradients, inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// PrintV2Attr is an optional argument to PrintV2.
type PrintV2Attr func(optionalAttr)

// PrintV2OutputStream sets the optional output_stream attribute to value.
//
// value: A string specifying the output stream or logging level to print to.
// If not specified, defaults to "stderr"
func PrintV2OutputStream(value string) PrintV2Attr {
	return func(m optionalAttr) {
		m["output_stream"] = value
	}
}

// PrintV2End sets the optional end attribute to value.
// If not specified, defaults to "\n"
func PrintV2End(value string) PrintV2Attr {
	return func(m optionalAttr) {
		m["end"] = value
	}
}

// Prints a string scalar.
//
// Prints a string scalar to the desired output_stream.
//
// Arguments:
//	input: The string scalar to print.
//
// Returns the created operation.
func PrintV2(scope *Scope, input tf.Output, optional ...PrintV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PrintV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Restore a Reader to its initial clean state.
//
// Arguments:
//	reader_handle: Handle to a Reader.
//
// Returns the created operation.
func ReaderResetV2(scope *Scope, reader_handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderResetV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Split a `SparseTensor` into `num_split` tensors along one dimension.
//
// If the `shape[split_dim]` is not an integer multiple of `num_split`. Slices
// `[0 : shape[split_dim] % num_split]` gets one extra dimension.
// For example, if `split_dim = 1` and `num_split = 2` and the input is
//
//     input_tensor = shape = [2, 7]
//     [    a   d e  ]
//     [b c          ]
//
// Graphically the output tensors are:
//
//     output_tensor[0] = shape = [2, 4]
//     [    a  ]
//     [b c    ]
//
//     output_tensor[1] = shape = [2, 3]
//     [ d e  ]
//     [      ]
//
// Arguments:
//	split_dim: 0-D.  The dimension along which to split.  Must be in the range
// `[0, rank(shape))`.
//	indices: 2-D tensor represents the indices of the sparse tensor.
//	values: 1-D tensor represents the values of the sparse tensor.
//	shape: 1-D. tensor represents the shape of the sparse tensor.
// output indices: A list of 1-D tensors represents the indices of the output
// sparse tensors.
//	num_split: The number of ways to split.
//
// Returns:
//	output_indices
//	output_values: A list of 1-D tensors represents the values of the output sparse
// tensors.
//	output_shape: A list of 1-D tensors represents the shape of the output sparse
// tensors.
func SparseSplit(scope *Scope, split_dim tf.Output, indices tf.Output, values tf.Output, shape tf.Output, num_split int64) (output_indices []tf.Output, output_values []tf.Output, output_shape []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_split": num_split}
	opspec := tf.OpSpec{
		Type: "SparseSplit",
		Input: []tf.Input{
			split_dim, indices, values, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_indices, idx, err = makeOutputList(op, idx, "output_indices"); err != nil {
		scope.UpdateErr("SparseSplit", err)
		return
	}
	if output_values, idx, err = makeOutputList(op, idx, "output_values"); err != nil {
		scope.UpdateErr("SparseSplit", err)
		return
	}
	if output_shape, idx, err = makeOutputList(op, idx, "output_shape"); err != nil {
		scope.UpdateErr("SparseSplit", err)
		return
	}
	return output_indices, output_values, output_shape
}

// RaggedRangeAttr is an optional argument to RaggedRange.
type RaggedRangeAttr func(optionalAttr)

// RaggedRangeTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func RaggedRangeTsplits(value tf.DataType) RaggedRangeAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Returns a `RaggedTensor` containing the specified sequences of numbers.
//
//
// Returns a `RaggedTensor` `result` composed from `rt_dense_values` and
// `rt_nested_splits`, such that
// `result[i] = range(starts[i], limits[i], deltas[i])`.
//
// ```python
// (rt_nested_splits, rt_dense_values) = ragged_range(
//       starts=[2, 5, 8], limits=[3, 5, 12], deltas=1)
// result = tf.ragged.from_row_splits(rt_dense_values, rt_nested_splits)
// print(result)
// <tf.RaggedTensor [[2], [], [8, 9, 10, 11]] >
// ```
//
// The input tensors `starts`, `limits`, and `deltas` may be scalars or vectors.
// The vector inputs must all have the same size.  Scalar inputs are broadcast
// to match the size of the vector inputs.
//
// Arguments:
//	starts: The starts of each range.
//	limits: The limits of each range.
//	deltas: The deltas of each range.
//
// Returns:
//	rt_nested_splits: The `row_splits` for the returned `RaggedTensor`.
//	rt_dense_values: The `flat_values` for the returned `RaggedTensor`.
func RaggedRange(scope *Scope, starts tf.Output, limits tf.Output, deltas tf.Output, optional ...RaggedRangeAttr) (rt_nested_splits tf.Output, rt_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedRange",
		Input: []tf.Input{
			starts, limits, deltas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes rectified linear 6: `min(max(features, 0), 6)`.
func Relu6(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Relu6",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Produce a string tensor that encodes the state of a Reader.
//
// Not all Readers support being serialized, so this can produce an
// Unimplemented error.
//
// Arguments:
//	reader_handle: Handle to a Reader.
func ReaderSerializeStateV2(scope *Scope, reader_handle tf.Output) (state tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderSerializeStateV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalMaxPoolAttr is an optional argument to FractionalMaxPool.
type FractionalMaxPoolAttr func(optionalAttr)

// FractionalMaxPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalMaxPoolPseudoRandom(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalMaxPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolOverlapping(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalMaxPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalMaxPool node in the computation graph. Mainly used
// in unit test to make FractionalMaxPool deterministic.
// If not specified, defaults to false
func FractionalMaxPoolDeterministic(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalMaxPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalMaxPoolSeed(value int64) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalMaxPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalMaxPoolSeed2(value int64) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional max pooling on the input.
//
// Fractional max pooling is slightly different than regular max pooling.  In
// regular max pooling, you downsize an input set by taking the maximum value of
// smaller N x N subsections of the set (often 2x2), and try to reduce the set by
// a factor of N, where N is an integer.  Fractional max pooling, as you might
// expect from the word "fractional", means that the overall reduction ratio N
// does not have to be an integer.
//
// The sizes of the pooling regions are generated randomly but are fairly uniform.
// For example, let's look at the height dimension, and the constraints on the
// list of rows that will be pool boundaries.
//
// First we define the following:
//
// 1.  input_row_length : the number of rows from the input set
// 2.  output_row_length : which will be smaller than the input
// 3.  alpha = input_row_length / output_row_length : our reduction ratio
// 4.  K = floor(alpha)
// 5.  row_pooling_sequence : this is the result list of pool boundary rows
//
// Then, row_pooling_sequence should satisfy:
//
// 1.  a[0] = 0 : the first value of the sequence is 0
// 2.  a[end] = input_row_length : the last value of the sequence is the size
// 3.  K <= (a[i+1] - a[i]) <= K+1 : all intervals are K or K+1 size
// 4.  length(row_pooling_sequence) = output_row_length+1
//
// For more details on fractional max pooling, see this paper:
// [Benjamin Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071)
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns:
//	output: output tensor after fractional max pooling.
//	row_pooling_sequence: row pooling sequence, needed to calculate gradient.
//	col_pooling_sequence: column pooling sequence, needed to calculate gradient.
func FractionalMaxPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalMaxPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes the reciprocal of x element-wise.
//
// I.e., \\(y = 1 / x\\).
func Reciprocal(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Reciprocal",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the number of work units this Reader has finished processing.
//
// Arguments:
//	reader_handle: Handle to a Reader.
func ReaderNumWorkUnitsCompletedV2(scope *Scope, reader_handle tf.Output) (units_completed tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderNumWorkUnitsCompletedV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeRawAttr is an optional argument to DecodeRaw.
type DecodeRawAttr func(optionalAttr)

// DecodeRawLittleEndian sets the optional little_endian attribute to value.
//
// value: Whether the input `bytes` are in little-endian order.
// Ignored for `out_type` values that are stored in a single byte like
// `uint8`.
// If not specified, defaults to true
func DecodeRawLittleEndian(value bool) DecodeRawAttr {
	return func(m optionalAttr) {
		m["little_endian"] = value
	}
}

// Reinterpret the bytes of a string as a vector of numbers.
//
// Arguments:
//	bytes: All the elements must have the same length.
//
//
// Returns A Tensor with one more dimension than the input `bytes`.  The
// added dimension will have size equal to the length of the elements
// of `bytes` divided by the number of bytes to represent `out_type`.
func DecodeRaw(scope *Scope, bytes tf.Output, out_type tf.DataType, optional ...DecodeRawAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeRaw",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the number of records this Reader has produced.
//
// This is the same as the number of ReaderRead executions that have
// succeeded.
//
// Arguments:
//	reader_handle: Handle to a Reader.
func ReaderNumRecordsProducedV2(scope *Scope, reader_handle tf.Output) (records_produced tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderNumRecordsProducedV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the next record (key, value pair) produced by a Reader.
//
// Will dequeue from the input queue if necessary (e.g. when the
// Reader needs to start reading from a new file since it has finished
// with the previous file).
//
// Arguments:
//	reader_handle: Handle to a Reader.
//	queue_handle: Handle to a Queue, with string work items.
//
// Returns:
//	key: A scalar.
//	value: A scalar.
func ReaderReadV2(scope *Scope, reader_handle tf.Output, queue_handle tf.Output) (key tf.Output, value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderReadV2",
		Input: []tf.Input{
			reader_handle, queue_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes square of x element-wise.
//
// I.e., \\(y = x * x = x^2\\).
func Square(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Square",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return a slice from 'input'.
//
// The output tensor is a tensor with dimensions described by 'size'
// whose values are extracted from 'input' starting at the offsets in
// 'begin'.
//
// *Requirements*:
//   0 <= begin[i] <= begin[i] + size[i] <= Di  for i in [0, n)
//
// Arguments:
//
//	begin: begin[i] specifies the offset into the 'i'th dimension of
// 'input' to slice from.
//	size: size[i] specifies the number of elements of the 'i'th dimension
// of 'input' to slice. If size[i] is -1, all remaining elements in dimension
// i are included in the slice (i.e. this is equivalent to setting
// size[i] = input.dim_size(i) - begin[i]).
func Slice(scope *Scope, input tf.Output, begin tf.Output, size tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Slice",
		Input: []tf.Input{
			input, begin, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TFRecordReaderV2Attr is an optional argument to TFRecordReaderV2.
type TFRecordReaderV2Attr func(optionalAttr)

// TFRecordReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func TFRecordReaderV2Container(value string) TFRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// TFRecordReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func TFRecordReaderV2SharedName(value string) TFRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// TFRecordReaderV2CompressionType sets the optional compression_type attribute to value.
// If not specified, defaults to ""
func TFRecordReaderV2CompressionType(value string) TFRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// A Reader that outputs the records from a TensorFlow Records file.
//
// Returns The handle to reference the Reader.
func TFRecordReaderV2(scope *Scope, optional ...TFRecordReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TFRecordReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IdentityReaderV2Attr is an optional argument to IdentityReaderV2.
type IdentityReaderV2Attr func(optionalAttr)

// IdentityReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func IdentityReaderV2Container(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// IdentityReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func IdentityReaderV2SharedName(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the queued work as both the key and value.
//
// To use, enqueue strings in a Queue.  ReaderRead will take the front
// work string and output (work, work).
//
// Returns The handle to reference the Reader.
func IdentityReaderV2(scope *Scope, optional ...IdentityReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IdentityReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseExampleDatasetAttr is an optional argument to ParseExampleDataset.
type ParseExampleDatasetAttr func(optionalAttr)

// ParseExampleDatasetSloppy sets the optional sloppy attribute to value.
// If not specified, defaults to false
func ParseExampleDatasetSloppy(value bool) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["sloppy"] = value
	}
}

// ParseExampleDatasetRaggedKeys sets the optional ragged_keys attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetRaggedKeys(value []string) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["ragged_keys"] = value
	}
}

// ParseExampleDatasetRaggedValueTypes sets the optional ragged_value_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetRaggedValueTypes(value []tf.DataType) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["ragged_value_types"] = value
	}
}

// ParseExampleDatasetRaggedSplitTypes sets the optional ragged_split_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetRaggedSplitTypes(value []tf.DataType) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["ragged_split_types"] = value
	}
}

// Transforms `input_dataset` containing `Example` protos as vectors of DT_STRING into a dataset of `Tensor` or `SparseTensor` objects representing the parsed features.
//
// Arguments:
//
//
//	dense_defaults: A dict mapping string keys to `Tensor`s.
// The keys of the dict must match the dense_keys of the feature.
//	sparse_keys: A list of string keys in the examples features.
// The results for these keys will be returned as `SparseTensor` objects.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples features associated with dense values.
//	sparse_types: A list of `DTypes` of the same length as `sparse_keys`.
// Only `tf.float32` (`FloatList`), `tf.int64` (`Int64List`),
// and `tf.string` (`BytesList`) are supported.
//	dense_shapes: List of tuples with the same length as `dense_keys`.
// The shape of the data for each dense feature referenced by `dense_keys`.
// Required for any input tensors identified by `dense_keys`.  Must be
// either fully defined, or may contain an unknown first dimension.
// An unknown first dimension means the feature is treated as having
// a variable number of blocks, and the output shape along this dimension
// is considered unknown at graph build time.  Padding is applied for
// minibatch elements smaller than the maximum number of blocks for the
// given feature along this dimension.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
func ParseExampleDataset(scope *Scope, input_dataset tf.Output, num_parallel_calls tf.Output, dense_defaults []tf.Output, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ParseExampleDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseExampleDataset",
		Input: []tf.Input{
			input_dataset, num_parallel_calls, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FixedLengthRecordReaderV2Attr is an optional argument to FixedLengthRecordReaderV2.
type FixedLengthRecordReaderV2Attr func(optionalAttr)

// FixedLengthRecordReaderV2HeaderBytes sets the optional header_bytes attribute to value.
//
// value: Number of bytes in the header, defaults to 0.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2HeaderBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["header_bytes"] = value
	}
}

// FixedLengthRecordReaderV2FooterBytes sets the optional footer_bytes attribute to value.
//
// value: Number of bytes in the footer, defaults to 0.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2FooterBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["footer_bytes"] = value
	}
}

// FixedLengthRecordReaderV2HopBytes sets the optional hop_bytes attribute to value.
//
// value: Number of bytes to hop before each read. Default of 0 means using
// record_bytes.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2HopBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["hop_bytes"] = value
	}
}

// FixedLengthRecordReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2Container(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// FixedLengthRecordReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2SharedName(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// FixedLengthRecordReaderV2Encoding sets the optional encoding attribute to value.
//
// value: The type of encoding for the file. Currently ZLIB and GZIP
// are supported. Defaults to none.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2Encoding(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["encoding"] = value
	}
}

// A Reader that outputs fixed-length records from a file.
//
// Arguments:
//	record_bytes: Number of bytes in the record.
//
// Returns The handle to reference the Reader.
func FixedLengthRecordReaderV2(scope *Scope, record_bytes int64, optional ...FixedLengthRecordReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"record_bytes": record_bytes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedLengthRecordReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Saves input tensors slices to disk.
//
// This is like `Save` except that tensors can be listed in the saved file as being
// a slice of a larger tensor.  `shapes_and_slices` specifies the shape of the
// larger tensor and the slice that this tensor covers. `shapes_and_slices` must
// have as many elements as `tensor_names`.
//
// Elements of the `shapes_and_slices` input must either be:
//
// *  The empty string, in which case the corresponding tensor is
//    saved normally.
// *  A string of the form `dim0 dim1 ... dimN-1 slice-spec` where the
//    `dimI` are the dimensions of the larger tensor and `slice-spec`
//    specifies what part is covered by the tensor to save.
//
// `slice-spec` itself is a `:`-separated list: `slice0:slice1:...:sliceN-1`
// where each `sliceI` is either:
//
// *  The string `-` meaning that the slice covers all indices of this dimension
// *  `start,length` where `start` and `length` are integers.  In that
//    case the slice covers `length` indices starting at `start`.
//
// See also `Save`.
//
// Arguments:
//	filename: Must have a single element. The name of the file to which we write the
// tensor.
//	tensor_names: Shape `[N]`. The names of the tensors to be saved.
//	shapes_and_slices: Shape `[N]`.  The shapes and slice specifications to use when
// saving the tensors.
//	data: `N` tensors to save.
//
// Returns the created operation.
func SaveSlices(scope *Scope, filename tf.Output, tensor_names tf.Output, shapes_and_slices tf.Output, data []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SaveSlices",
		Input: []tf.Input{
			filename, tensor_names, shapes_and_slices, tf.OutputList(data),
		},
	}
	return scope.AddOperation(opspec)
}

// Saves the input tensors to disk.
//
// The size of `tensor_names` must match the number of tensors in `data`. `data[i]`
// is written to `filename` with name `tensor_names[i]`.
//
// See also `SaveSlices`.
//
// Arguments:
//	filename: Must have a single element. The name of the file to which we write
// the tensor.
//	tensor_names: Shape `[N]`. The names of the tensors to be saved.
//	data: `N` tensors to save.
//
// Returns the created operation.
func Save(scope *Scope, filename tf.Output, tensor_names tf.Output, data []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Save",
		Input: []tf.Input{
			filename, tensor_names, tf.OutputList(data),
		},
	}
	return scope.AddOperation(opspec)
}

// MergeV2CheckpointsAttr is an optional argument to MergeV2Checkpoints.
type MergeV2CheckpointsAttr func(optionalAttr)

// MergeV2CheckpointsDeleteOldDirs sets the optional delete_old_dirs attribute to value.
//
// value: see above.
// If not specified, defaults to true
func MergeV2CheckpointsDeleteOldDirs(value bool) MergeV2CheckpointsAttr {
	return func(m optionalAttr) {
		m["delete_old_dirs"] = value
	}
}

// V2 format specific: merges the metadata files of sharded checkpoints.  The
//
// result is one logical checkpoint, with one physical metadata file and renamed
// data files.
//
// Intended for "grouping" multiple checkpoints in a sharded checkpoint setup.
//
// If delete_old_dirs is true, attempts to delete recursively the dirname of each
// path in the input checkpoint_prefixes.  This is useful when those paths are non
// user-facing temporary locations.
//
// Arguments:
//	checkpoint_prefixes: prefixes of V2 checkpoints to merge.
//	destination_prefix: scalar.  The desired final prefix.  Allowed to be the same
// as one of the checkpoint_prefixes.
//
// Returns the created operation.
func MergeV2Checkpoints(scope *Scope, checkpoint_prefixes tf.Output, destination_prefix tf.Output, optional ...MergeV2CheckpointsAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MergeV2Checkpoints",
		Input: []tf.Input{
			checkpoint_prefixes, destination_prefix,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingMomentumParametersAttr is an optional argument to LoadTPUEmbeddingMomentumParameters.
type LoadTPUEmbeddingMomentumParametersAttr func(optionalAttr)

// LoadTPUEmbeddingMomentumParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingMomentumParametersTableId(value int64) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersTableName(value string) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersConfig(value string) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Momentum embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Momentum optimization algorithm.
//	momenta: Value of momenta used in the Momentum optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingMomentumParameters(scope *Scope, parameters tf.Output, momenta tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMomentumParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMomentumParameters",
		Input: []tf.Input{
			parameters, momenta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ImageProjectiveTransformV3Attr is an optional argument to ImageProjectiveTransformV3.
type ImageProjectiveTransformV3Attr func(optionalAttr)

// ImageProjectiveTransformV3FillMode sets the optional fill_mode attribute to value.
//
// value: Fill mode, "REFLECT", "WRAP", "CONSTANT", or "NEAREST".
// If not specified, defaults to "CONSTANT"
func ImageProjectiveTransformV3FillMode(value string) ImageProjectiveTransformV3Attr {
	return func(m optionalAttr) {
		m["fill_mode"] = value
	}
}

// Applies the given transform to each of the images.
//
// If one row of `transforms` is `[a0, a1, a2, b0, b1, b2, c0, c1]`, then it maps
// the *output* point `(x, y)` to a transformed *input* point
// `(x', y') = ((a0 x + a1 y + a2) / k, (b0 x + b1 y + b2) / k)`, where
// `k = c0 x + c1 y + 1`. If the transformed point lays outside of the input
// image, the output pixel is set to fill_value.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	transforms: 2-D Tensor, `[batch, 8]` or `[1, 8]` matrix, where each row corresponds to a 3 x 3
// projective transformation matrix, with the last entry assumed to be 1. If there
// is one row, the same transformation will be applied to all images.
//	output_shape: 1-D Tensor [new_height, new_width].
//	fill_value: float, the value to be filled when fill_mode is constant".
//	interpolation: Interpolation method, "NEAREST" or "BILINEAR".
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ImageProjectiveTransformV3(scope *Scope, images tf.Output, transforms tf.Output, output_shape tf.Output, fill_value tf.Output, interpolation string, optional ...ImageProjectiveTransformV3Attr) (transformed_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"interpolation": interpolation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ImageProjectiveTransformV3",
		Input: []tf.Input{
			images, transforms, output_shape, fill_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of x AND y element-wise.
//
// *NOTE*: `LogicalAnd` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalAnd(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalAnd",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastSendAttr is an optional argument to CollectiveBcastSend.
type CollectiveBcastSendAttr func(optionalAttr)

// CollectiveBcastSendCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastSendCommunicationHint(value string) CollectiveBcastSendAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastSendTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastSendTimeoutSeconds(value float32) CollectiveBcastSendAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Broadcasts a tensor value to one or more other devices.
func CollectiveBcastSend(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, shape tf.Shape, optional ...CollectiveBcastSendAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastSend",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CombinedNonMaxSuppressionAttr is an optional argument to CombinedNonMaxSuppression.
type CombinedNonMaxSuppressionAttr func(optionalAttr)

// CombinedNonMaxSuppressionPadPerClass sets the optional pad_per_class attribute to value.
//
// value: If false, the output nmsed boxes, scores and classes
// are padded/clipped to `max_total_size`. If true, the
// output nmsed boxes, scores and classes are padded to be of length
// `max_size_per_class`*`num_classes`, unless it exceeds `max_total_size` in
// which case it is clipped to `max_total_size`. Defaults to false.
// If not specified, defaults to false
func CombinedNonMaxSuppressionPadPerClass(value bool) CombinedNonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["pad_per_class"] = value
	}
}

// CombinedNonMaxSuppressionClipBoxes sets the optional clip_boxes attribute to value.
//
// value: If true, assume the box coordinates are between [0, 1] and clip the output boxes
// if they fall beyond [0, 1]. If false, do not do clipping and output the box
// coordinates as it is.
// If not specified, defaults to true
func CombinedNonMaxSuppressionClipBoxes(value bool) CombinedNonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["clip_boxes"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// This operation performs non_max_suppression on the inputs per batch, across
// all classes.
// Prunes away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system. Also note that
// this algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is the final boxes, scores and classes tensor
// returned after performing non_max_suppression.
//
// Arguments:
//	boxes: A 4-D float tensor of shape `[batch_size, num_boxes, q, 4]`. If `q` is 1 then
// same boxes are used for all classes otherwise, if `q` is equal to number of
// classes, class-specific boxes are used.
//	scores: A 3-D float tensor of shape `[batch_size, num_boxes, num_classes]`
// representing a single score corresponding to each box (each row of boxes).
//	max_output_size_per_class: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression per class
//	max_total_size: An int32 scalar representing the maximum number of boxes retained over all
// classes. Note that setting this value to a large number may result in OOM error
// depending on the system workload.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns:
//	nmsed_boxes: A [batch_size, max_detections, 4] float32 tensor
// containing the non-max suppressed boxes.
//	nmsed_scores: A [batch_size, max_detections] float32 tensor
// containing the scores for the boxes.
//	nmsed_classes: A [batch_size, max_detections] float32 tensor
// containing the classes for the boxes.
//	valid_detections: A [batch_size] int32 tensor indicating the number of
// valid detections per batch item. Only the top num_detections[i] entries in
// nms_boxes[i], nms_scores[i] and nms_class[i] are valid. The rest of the
// entries are zero paddings.
func CombinedNonMaxSuppression(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size_per_class tf.Output, max_total_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, optional ...CombinedNonMaxSuppressionAttr) (nmsed_boxes tf.Output, nmsed_scores tf.Output, nmsed_classes tf.Output, valid_detections tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CombinedNonMaxSuppression",
		Input: []tf.Input{
			boxes, scores, max_output_size_per_class, max_total_size, iou_threshold, score_threshold,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//   selected_indices = tf.image.non_max_suppression_v2(
//       boxes, scores, max_output_size, iou_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionV2(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV2",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Removes keys and its associated values from a table.
//
// The tensor `keys` must of the same type as the keys of the table. Keys not
// already in the table are silently ignored.
//
// Arguments:
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys of the elements to remove.
//
// Returns the created operation.
func LookupTableRemoveV2(scope *Scope, table_handle tf.Output, keys tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableRemoveV2",
		Input: []tf.Input{
			table_handle, keys,
		},
	}
	return scope.AddOperation(opspec)
}

// NonMaxSuppressionAttr is an optional argument to NonMaxSuppression.
type NonMaxSuppressionAttr func(optionalAttr)

// NonMaxSuppressionIouThreshold sets the optional iou_threshold attribute to value.
//
// value: A float representing the threshold for deciding whether boxes
// overlap too much with respect to IOU.
// If not specified, defaults to 0.5
func NonMaxSuppressionIouThreshold(value float32) NonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["iou_threshold"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//   selected_indices = tf.image.non_max_suppression(
//       boxes, scores, max_output_size, iou_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppression(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, optional ...NonMaxSuppressionAttr) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppression",
		Input: []tf.Input{
			boxes, scores, max_output_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic tangent of `x` element-wise.
//
//   Given an input tensor, this function computes hyperbolic tangent of every
//   element in the tensor. Input range is `[-inf, inf]` and
//   output range is `[-1,1]`.
//
//   >>> x = tf.constant([-float("inf"), -5, -0.5, 1, 1.2, 2, 3, float("inf")])
//   >>> tf.math.tanh(x)
//   <tf.Tensor: shape=(8,), dtype=float32, numpy=
//   array([-1.        , -0.99990916, -0.46211717,  0.7615942 ,  0.8336547 ,
//           0.9640276 ,  0.9950547 ,  1.        ], dtype=float32)>
//
func Tanh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Tanh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OutfeedDequeueAttr is an optional argument to OutfeedDequeue.
type OutfeedDequeueAttr func(optionalAttr)

// OutfeedDequeueDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func OutfeedDequeueDeviceOrdinal(value int64) OutfeedDequeueAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Retrieves a single tensor from the computation outfeed.
//
// This operation will block indefinitely until data is available.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be read from the device outfeed.
func OutfeedDequeue(scope *Scope, dtype tf.DataType, shape tf.Shape, optional ...OutfeedDequeueAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeue",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeGradImageAttr is an optional argument to CropAndResizeGradImage.
type CropAndResizeGradImageAttr func(optionalAttr)

// CropAndResizeGradImageMethod sets the optional method attribute to value.
//
// value: A string specifying the interpolation method. Only 'bilinear' is
// supported for now.
// If not specified, defaults to "bilinear"
func CropAndResizeGradImageMethod(value string) CropAndResizeGradImageAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// Computes the gradient of the crop_and_resize op wrt the input image tensor.
//
// Arguments:
//	grads: A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1] in image height coordinates. We do allow y1 > y2, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//	image_size: A 1-D tensor with value `[batch, image_height, image_width, depth]`
// containing the original image size. Both `image_height` and `image_width` need
// to be positive.
//
//
// Returns A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
func CropAndResizeGradImage(scope *Scope, grads tf.Output, boxes tf.Output, box_ind tf.Output, image_size tf.Output, T tf.DataType, optional ...CropAndResizeGradImageAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResizeGradImage",
		Input: []tf.Input{
			grads, boxes, box_ind, image_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractGlimpseV2Attr is an optional argument to ExtractGlimpseV2.
type ExtractGlimpseV2Attr func(optionalAttr)

// ExtractGlimpseV2Centered sets the optional centered attribute to value.
//
// value: indicates if the offset coordinates are centered relative to
// the image, in which case the (0, 0) offset is relative to the center
// of the input images. If false, the (0,0) offset corresponds to the
// upper left corner of the input images.
// If not specified, defaults to true
func ExtractGlimpseV2Centered(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["centered"] = value
	}
}

// ExtractGlimpseV2Normalized sets the optional normalized attribute to value.
//
// value: indicates if the offset coordinates are normalized.
// If not specified, defaults to true
func ExtractGlimpseV2Normalized(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["normalized"] = value
	}
}

// ExtractGlimpseV2UniformNoise sets the optional uniform_noise attribute to value.
//
// value: indicates if the noise should be generated using a
// uniform distribution or a Gaussian distribution.
// If not specified, defaults to true
func ExtractGlimpseV2UniformNoise(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["uniform_noise"] = value
	}
}

// ExtractGlimpseV2Noise sets the optional noise attribute to value.
//
// value: indicates if the noise should `uniform`, `gaussian`, or
// `zero`. The default is `uniform` which means the noise type
// will be decided by `uniform_noise`.
// If not specified, defaults to "uniform"
func ExtractGlimpseV2Noise(value string) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["noise"] = value
	}
}

// Extracts a glimpse from the input tensor.
//
// Returns a set of windows called glimpses extracted at location
// `offsets` from the input tensor. If the windows only partially
// overlaps the inputs, the non overlapping areas will be filled with
// random noise.
//
// The result is a 4-D tensor of shape `[batch_size, glimpse_height,
// glimpse_width, channels]`. The channels and batch dimensions are the
// same as that of the input tensor. The height and width of the output
// windows are specified in the `size` parameter.
//
// The argument `normalized` and `centered` controls how the windows are built:
//
// * If the coordinates are normalized but not centered, 0.0 and 1.0
//   correspond to the minimum and maximum of each height and width
//   dimension.
// * If the coordinates are both normalized and centered, they range from
//   -1.0 to 1.0. The coordinates (-1.0, -1.0) correspond to the upper
//   left corner, the lower right corner is located at (1.0, 1.0) and the
//   center is at (0, 0).
// * If the coordinates are not normalized they are interpreted as
//   numbers of pixels.
//
// Arguments:
//	input: A 4-D float tensor of shape `[batch_size, height, width, channels]`.
//	size: A 1-D tensor of 2 elements containing the size of the glimpses
// to extract.  The glimpse height must be specified first, following
// by the glimpse width.
//	offsets: A 2-D integer tensor of shape `[batch_size, 2]` containing
// the y, x locations of the center of each window.
//
// Returns A tensor representing the glimpses `[batch_size,
// glimpse_height, glimpse_width, channels]`.
func ExtractGlimpseV2(scope *Scope, input tf.Output, size tf.Output, offsets tf.Output, optional ...ExtractGlimpseV2Attr) (glimpse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractGlimpseV2",
		Input: []tf.Input{
			input, size, offsets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessSampleDistortedBoundingBoxAttr is an optional argument to StatelessSampleDistortedBoundingBox.
type StatelessSampleDistortedBoundingBoxAttr func(optionalAttr)

// StatelessSampleDistortedBoundingBoxAspectRatioRange sets the optional aspect_ratio_range attribute to value.
//
// value: The cropped area of the image must have an aspect ratio =
// width / height within this range.
// If not specified, defaults to <f:0.75 f:1.33 >
func StatelessSampleDistortedBoundingBoxAspectRatioRange(value []float32) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["aspect_ratio_range"] = value
	}
}

// StatelessSampleDistortedBoundingBoxAreaRange sets the optional area_range attribute to value.
//
// value: The cropped area of the image must contain a fraction of the
// supplied image within this range.
// If not specified, defaults to <f:0.05 f:1 >
func StatelessSampleDistortedBoundingBoxAreaRange(value []float32) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["area_range"] = value
	}
}

// StatelessSampleDistortedBoundingBoxMaxAttempts sets the optional max_attempts attribute to value.
//
// value: Number of attempts at generating a cropped region of the image
// of the specified constraints. After `max_attempts` failures, return the entire
// image.
// If not specified, defaults to 100
func StatelessSampleDistortedBoundingBoxMaxAttempts(value int64) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["max_attempts"] = value
	}
}

// StatelessSampleDistortedBoundingBoxUseImageIfNoBoundingBoxes sets the optional use_image_if_no_bounding_boxes attribute to value.
//
// value: Controls behavior if no bounding boxes supplied.
// If true, assume an implicit bounding box covering the whole input. If false,
// raise an error.
// If not specified, defaults to false
func StatelessSampleDistortedBoundingBoxUseImageIfNoBoundingBoxes(value bool) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["use_image_if_no_bounding_boxes"] = value
	}
}

// Generate a randomly distorted bounding box for an image deterministically.
//
// Bounding box annotations are often supplied in addition to ground-truth labels
// in image recognition or object localization tasks. A common technique for
// training such a system is to randomly distort an image while preserving its
// content, i.e. *data augmentation*. This Op, given the same `seed`,
// deterministically outputs a randomly distorted localization of an object, i.e.
// bounding box, given an `image_size`, `bounding_boxes` and a series of
// constraints.
//
// The output of this Op is a single bounding box that may be used to crop the
// original image. The output is returned as 3 tensors: `begin`, `size` and
// `bboxes`. The first 2 tensors can be fed directly into `tf.slice` to crop the
// image. The latter may be supplied to `tf.image.draw_bounding_boxes` to visualize
// what the bounding box looks like.
//
// Bounding boxes are supplied and returned as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// the height of the underlying image.
//
// The output of this Op is guaranteed to be the same given the same `seed` and is
// independent of how many times the function is called, and independent of global
// seed settings (e.g. `tf.random.set_seed`).
//
// Example usage:
//
// >>> image = np.array([[[1], [2], [3]], [[4], [5], [6]], [[7], [8], [9]]])
// >>> bbox = tf.constant(
// ...   [0.0, 0.0, 1.0, 1.0], dtype=tf.float32, shape=[1, 1, 4])
// >>> seed = (1, 2)
// >>> # Generate a single distorted bounding box.
// >>> bbox_begin, bbox_size, bbox_draw = (
// ...   tf.image.stateless_sample_distorted_bounding_box(
// ...     tf.shape(image), bounding_boxes=bbox, seed=seed))
// >>> # Employ the bounding box to distort the image.
// >>> tf.slice(image, bbox_begin, bbox_size)
// <tf.Tensor: shape=(2, 2, 1), dtype=int64, numpy=
// array([[[1],
//         [2]],
//        [[4],
//         [5]]])>
// >>> # Draw the bounding box in an image summary.
// >>> colors = np.array([[1.0, 0.0, 0.0], [0.0, 0.0, 1.0]])
// >>> tf.image.draw_bounding_boxes(
// ...   tf.expand_dims(tf.cast(image, tf.float32),0), bbox_draw, colors)
// <tf.Tensor: shape=(1, 3, 3, 1), dtype=float32, numpy=
// array([[[[1.],
//          [1.],
//          [3.]],
//         [[1.],
//          [1.],
//          [6.]],
//         [[7.],
//          [8.],
//          [9.]]]], dtype=float32)>
//
// Note that if no bounding box information is available, setting
// `use_image_if_no_bounding_boxes = true` will assume there is a single implicit
// bounding box covering the whole image. If `use_image_if_no_bounding_boxes` is
// false and no bounding boxes are supplied, an error is raised.
//
// Arguments:
//	image_size: 1-D, containing `[height, width, channels]`.
//	bounding_boxes: 3-D with shape `[batch, N, 4]` describing the N bounding boxes
// associated with the image.
//	min_object_covered: The cropped area of the image must contain at least this
// fraction of any bounding box supplied. The value of this parameter should be
// non-negative. In the case of 0, the cropped area does not need to overlap
// any of the bounding boxes supplied.
//	seed: 1-D with shape `[2]`. The seed to the random number generator. Must have dtype
// `int32` or `int64`. (When using XLA, only `int32` is allowed.)
//
// Returns:
//	begin: 1-D, containing `[offset_height, offset_width, 0]`. Provide as input to
// `tf.slice`.
//	size: 1-D, containing `[target_height, target_width, -1]`. Provide as input to
// `tf.slice`.
//	bboxes: 3-D with shape `[1, 1, 4]` containing the distorted bounding box.
// Provide as input to `tf.image.draw_bounding_boxes`.
func StatelessSampleDistortedBoundingBox(scope *Scope, image_size tf.Output, bounding_boxes tf.Output, min_object_covered tf.Output, seed tf.Output, optional ...StatelessSampleDistortedBoundingBoxAttr) (begin tf.Output, size tf.Output, bboxes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessSampleDistortedBoundingBox",
		Input: []tf.Input{
			image_size, bounding_boxes, min_object_covered, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// AvgPoolAttr is an optional argument to AvgPool.
type AvgPoolAttr func(optionalAttr)

// AvgPoolDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func AvgPoolDataFormat(value string) AvgPoolAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs average pooling on the input.
//
// Each entry in `output` is the mean of the corresponding size `ksize`
// window in `value`.
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	ksize: The size of the sliding window for each dimension of `value`.
//	strides: The stride of the sliding window for each dimension of `value`.
//	padding: The type of padding algorithm to use.
//
// Returns The average pooled output tensor.
func AvgPool(scope *Scope, value tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPoolAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeImageAttr is an optional argument to DecodeImage.
type DecodeImageAttr func(optionalAttr)

// DecodeImageChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeImageChannels(value int64) DecodeImageAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeImageDtype sets the optional dtype attribute to value.
//
// value: The desired DType of the returned Tensor.
// If not specified, defaults to DT_UINT8
func DecodeImageDtype(value tf.DataType) DecodeImageAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// DecodeImageExpandAnimations sets the optional expand_animations attribute to value.
//
// value: Controls the output shape of the returned op. If True, the returned op will
// produce a 3-D tensor for PNG, JPEG, and BMP files; and a 4-D tensor for all
// GIFs, whether animated or not. If, False, the returned op will produce a 3-D
// tensor for all file types and will truncate animated GIFs to the first frame.
// If not specified, defaults to true
func DecodeImageExpandAnimations(value bool) DecodeImageAttr {
	return func(m optionalAttr) {
		m["expand_animations"] = value
	}
}

// Function for decode_bmp, decode_gif, decode_jpeg, and decode_png.
//
// Detects whether an image is a BMP, GIF, JPEG, or PNG, and performs the
// appropriate operation to convert the input bytes string into a Tensor of type
// dtype.
//
// *NOTE*: decode_gif returns a 4-D array [num_frames, height, width, 3], as
// opposed to decode_bmp, decode_jpeg and decode_png, which return 3-D arrays
// [height, width, num_channels]. Make sure to take this into account when
// constructing your graph if you are intermixing GIF files with BMP, JPEG, and/or
// PNG files. Alternately, set the expand_animations argument of this function to
// False, in which case the op will return 3-dimensional tensors and will truncate
// animated GIF files to the first frame.
//
// *NOTE*: If the first frame of an animated GIF does not occupy the entire
// canvas (maximum frame width x maximum frame height), then it fills the
// unoccupied areas (in the first frame) with zeros (black). For frames after the
// first frame that does not occupy the entire canvas, it uses the previous
// frame to fill the unoccupied areas.
//
// Arguments:
//	contents: 0-D. The encoded image bytes.
//
// Returns 3-D with shape `[height, width, channels]` or 4-D with shape
// `[frame, height, width, channels]`..
func DecodeImage(scope *Scope, contents tf.Output, optional ...DecodeImageAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeImage",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSummaryV2Attr is an optional argument to AudioSummaryV2.
type AudioSummaryV2Attr func(optionalAttr)

// AudioSummaryV2MaxOutputs sets the optional max_outputs attribute to value.
//
// value: Max number of batch elements to generate audio for.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func AudioSummaryV2MaxOutputs(value int64) AudioSummaryV2Attr {
	return func(m optionalAttr) {
		m["max_outputs"] = value
	}
}

// Outputs a `Summary` protocol buffer with audio.
//
// The summary has up to `max_outputs` summary values containing audio. The
// audio is built from `tensor` which must be 3-D with shape `[batch_size,
// frames, channels]` or 2-D with shape `[batch_size, frames]`. The values are
// assumed to be in the range of `[-1.0, 1.0]` with a sample rate of `sample_rate`.
//
// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
// build the `tag` of the summary values:
//
// *  If `max_outputs` is 1, the summary value tag is '*tag*/audio'.
// *  If `max_outputs` is greater than 1, the summary value tags are
//    generated sequentially as '*tag*/audio/0', '*tag*/audio/1', etc.
//
// Arguments:
//	tag: Scalar. Used to build the `tag` attribute of the summary values.
//	tensor: 2-D of shape `[batch_size, frames]`.
//	sample_rate: The sample rate of the signal in hertz.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func AudioSummaryV2(scope *Scope, tag tf.Output, tensor tf.Output, sample_rate tf.Output, optional ...AudioSummaryV2Attr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSummaryV2",
		Input: []tf.Input{
			tag, tensor, sample_rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Draw bounding boxes on a batch of images.
//
// Outputs a copy of `images` but draws on top of the pixels zero or more bounding
// boxes specified by the locations in `boxes`. The coordinates of the each
// bounding box in `boxes` are encoded as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example, if an image is 100 x 200 pixels (height x width) and the bounding
// box is `[0.1, 0.2, 0.5, 0.9]`, the upper-left and bottom-right coordinates of
// the bounding box will be `(40, 10)` to `(100, 50)` (in (x,y) coordinates).
//
// Parts of the bounding box may fall outside the image.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, depth]`. A batch of images.
//	boxes: 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
// boxes.
//	colors: 2-D. A list of RGBA colors to cycle through for the boxes.
//
// Returns 4-D with the same shape as `images`. The batch of input images with
// bounding boxes drawn on the images.
func DrawBoundingBoxesV2(scope *Scope, images tf.Output, boxes tf.Output, colors tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DrawBoundingBoxesV2",
		Input: []tf.Input{
			images, boxes, colors,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the contrast of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last 3 dimensions are
// interpreted as `[height, width, channels]`.  The other dimensions only
// represent a collection of images, such as `[batch, height, width, channels].`
//
// Contrast is adjusted independently for each channel of each image.
//
// For each channel, the Op first computes the mean of the image pixels in the
// channel and then adjusts each component of each pixel to
// `(x - mean) * contrast_factor + mean`.
//
// Arguments:
//	images: Images to adjust.  At least 3-D.
//	contrast_factor: A float multiplier for adjusting contrast.
//
// Returns The contrast-adjusted image or images.
func AdjustContrastv2(scope *Scope, images tf.Output, contrast_factor tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustContrastv2",
		Input: []tf.Input{
			images, contrast_factor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the rank of a tensor.
//
// This operation returns an integer representing the rank of `input`.
//
// For example:
//
// ```
// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
// # shape of tensor 't' is [2, 2, 3]
// rank(t) ==> 3
// ```
//
// **Note**: The rank of a tensor is not the same as the rank of a matrix. The rank
// of a tensor is the number of indices required to uniquely select each element
// of the tensor. Rank is also known as "order", "degree", or "ndims."
func Rank(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Rank",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeJpegAttr is an optional argument to EncodeJpeg.
type EncodeJpegAttr func(optionalAttr)

// EncodeJpegFormat sets the optional format attribute to value.
//
// value: Per pixel image format.
// If not specified, defaults to ""
func EncodeJpegFormat(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["format"] = value
	}
}

// EncodeJpegQuality sets the optional quality attribute to value.
//
// value: Quality of the compression from 0 to 100 (higher is better and slower).
// If not specified, defaults to 95
func EncodeJpegQuality(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["quality"] = value
	}
}

// EncodeJpegProgressive sets the optional progressive attribute to value.
//
// value: If True, create a JPEG that loads progressively (coarse to fine).
// If not specified, defaults to false
func EncodeJpegProgressive(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["progressive"] = value
	}
}

// EncodeJpegOptimizeSize sets the optional optimize_size attribute to value.
//
// value: If True, spend CPU/RAM to reduce size with no quality change.
// If not specified, defaults to false
func EncodeJpegOptimizeSize(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["optimize_size"] = value
	}
}

// EncodeJpegChromaDownsampling sets the optional chroma_downsampling attribute to value.
//
// value: See http://en.wikipedia.org/wiki/Chroma_subsampling.
// If not specified, defaults to true
func EncodeJpegChromaDownsampling(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["chroma_downsampling"] = value
	}
}

// EncodeJpegDensityUnit sets the optional density_unit attribute to value.
//
// value: Unit used to specify `x_density` and `y_density`:
// pixels per inch (`'in'`) or centimeter (`'cm'`).
// If not specified, defaults to "in"
func EncodeJpegDensityUnit(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["density_unit"] = value
	}
}

// EncodeJpegXDensity sets the optional x_density attribute to value.
//
// value: Horizontal pixels per density unit.
// If not specified, defaults to 300
func EncodeJpegXDensity(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["x_density"] = value
	}
}

// EncodeJpegYDensity sets the optional y_density attribute to value.
//
// value: Vertical pixels per density unit.
// If not specified, defaults to 300
func EncodeJpegYDensity(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["y_density"] = value
	}
}

// EncodeJpegXmpMetadata sets the optional xmp_metadata attribute to value.
//
// value: If not empty, embed this XMP metadata in the image header.
// If not specified, defaults to ""
func EncodeJpegXmpMetadata(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["xmp_metadata"] = value
	}
}

// JPEG-encode an image.
//
// `image` is a 3-D uint8 Tensor of shape `[height, width, channels]`.
//
// The attr `format` can be used to override the color format of the encoded
// output.  Values can be:
//
// *   `''`: Use a default format based on the number of channels in the image.
// *   `grayscale`: Output a grayscale JPEG image.  The `channels` dimension
//     of `image` must be 1.
// *   `rgb`: Output an RGB JPEG image. The `channels` dimension
//     of `image` must be 3.
//
// If `format` is not specified or is the empty string, a default format is picked
// in function of the number of channels in `image`:
//
// *   1: Output a grayscale image.
// *   3: Output an RGB image.
//
// Arguments:
//	image: 3-D with shape `[height, width, channels]`.
//
// Returns 0-D. JPEG-encoded image.
func EncodeJpeg(scope *Scope, image tf.Output, optional ...EncodeJpegAttr) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeJpeg",
		Input: []tf.Input{
			image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeAndCropJpegAttr is an optional argument to DecodeAndCropJpeg.
type DecodeAndCropJpegAttr func(optionalAttr)

// DecodeAndCropJpegChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeAndCropJpegChannels(value int64) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeAndCropJpegRatio sets the optional ratio attribute to value.
//
// value: Downscaling ratio.
// If not specified, defaults to 1
func DecodeAndCropJpegRatio(value int64) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["ratio"] = value
	}
}

// DecodeAndCropJpegFancyUpscaling sets the optional fancy_upscaling attribute to value.
//
// value: If true use a slower but nicer upscaling of the
// chroma planes (yuv420/422 only).
// If not specified, defaults to true
func DecodeAndCropJpegFancyUpscaling(value bool) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["fancy_upscaling"] = value
	}
}

// DecodeAndCropJpegTryRecoverTruncated sets the optional try_recover_truncated attribute to value.
//
// value: If true try to recover an image from truncated input.
// If not specified, defaults to false
func DecodeAndCropJpegTryRecoverTruncated(value bool) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["try_recover_truncated"] = value
	}
}

// DecodeAndCropJpegAcceptableFraction sets the optional acceptable_fraction attribute to value.
//
// value: The minimum required fraction of lines before a truncated
// input is accepted.
// If not specified, defaults to 1
func DecodeAndCropJpegAcceptableFraction(value float32) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["acceptable_fraction"] = value
	}
}

// DecodeAndCropJpegDctMethod sets the optional dct_method attribute to value.
//
// value: string specifying a hint about the algorithm used for
// decompression.  Defaults to "" which maps to a system-specific
// default.  Currently valid values are ["INTEGER_FAST",
// "INTEGER_ACCURATE"].  The hint may be ignored (e.g., the internal
// jpeg library changes to a version that does not have that specific
// option.)
// If not specified, defaults to ""
func DecodeAndCropJpegDctMethod(value string) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["dct_method"] = value
	}
}

// Decode and Crop a JPEG-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the JPEG-encoded image.
// *   1: output a grayscale image.
// *   3: output an RGB image.
//
// If needed, the JPEG-encoded image is transformed to match the requested number
// of color channels.
//
// The attr `ratio` allows downscaling the image by an integer factor during
// decoding.  Allowed values are: 1, 2, 4, and 8.  This is much faster than
// downscaling the image later.
//
//
// It is equivalent to a combination of decode and crop, but much faster by only
// decoding partial jpeg image.
//
// Arguments:
//	contents: 0-D.  The JPEG-encoded image.
//	crop_window: 1-D.  The crop window: [crop_y, crop_x, crop_height, crop_width].
//
// Returns 3-D with shape `[height, width, channels]`..
func DecodeAndCropJpeg(scope *Scope, contents tf.Output, crop_window tf.Output, optional ...DecodeAndCropJpegAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeAndCropJpeg",
		Input: []tf.Input{
			contents, crop_window,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeNearestNeighborGradAttr is an optional argument to ResizeNearestNeighborGrad.
type ResizeNearestNeighborGradAttr func(optionalAttr)

// ResizeNearestNeighborGradAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and grad tensors are
// aligned. Defaults to false.
// If not specified, defaults to false
func ResizeNearestNeighborGradAlignCorners(value bool) ResizeNearestNeighborGradAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeNearestNeighborGradHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeNearestNeighborGradHalfPixelCenters(value bool) ResizeNearestNeighborGradAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Computes the gradient of nearest neighbor interpolation.
//
// Arguments:
//	grads: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `orig_height, orig_width`. The
// original input size.
//
// Returns 4-D with shape `[batch, orig_height, orig_width, channels]`. Gradients
// with respect to the input image.
func ResizeNearestNeighborGrad(scope *Scope, grads tf.Output, size tf.Output, optional ...ResizeNearestNeighborGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeNearestNeighborGrad",
		Input: []tf.Input{
			grads, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the logits. It is designed to be used during prediction.
// It traverses all the trees and calculates the final score for each instance.
//
// Arguments:
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
// feature.
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
// shape.
//
// Returns Output rank 2 Tensor containing logits for each example.
func BoostedTreesPredict(scope *Scope, tree_ensemble_handle tf.Output, bucketized_features []tf.Output, logits_dimension int64) (logits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesPredict",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxAttr is an optional argument to Max.
type MaxAttr func(optionalAttr)

// MaxKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MaxKeepDims(value bool) MaxAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the maximum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Max(scope *Scope, input tf.Output, axis tf.Output, optional ...MaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Max",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeBilinearGradAttr is an optional argument to ResizeBilinearGrad.
type ResizeBilinearGradAttr func(optionalAttr)

// ResizeBilinearGradAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and grad tensors are
// aligned. Defaults to false.
// If not specified, defaults to false
func ResizeBilinearGradAlignCorners(value bool) ResizeBilinearGradAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBilinearGradHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBilinearGradHalfPixelCenters(value bool) ResizeBilinearGradAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Computes the gradient of bilinear interpolation.
//
// Arguments:
//	grads: 4-D with shape `[batch, height, width, channels]`.
//	original_image: 4-D with shape `[batch, orig_height, orig_width, channels]`,
// The image tensor that was resized.
//
// Returns 4-D with shape `[batch, orig_height, orig_width, channels]`.
// Gradients with respect to the input image. Input image must have been
// float or double.
func ResizeBilinearGrad(scope *Scope, grads tf.Output, original_image tf.Output, optional ...ResizeBilinearGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBilinearGrad",
		Input: []tf.Input{
			grads, original_image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a list which has the passed-in `Tensor` as last element and the other elements of the given list in `input_handle`.
//
// tensor: The tensor to put on the list.
// input_handle: The old list.
// output_handle: A list with the elements of the old list followed by tensor.
// element_dtype: the type of elements in the list.
// element_shape: a shape compatible with that of elements in the list.
func TensorListPushBack(scope *Scope, input_handle tf.Output, tensor tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListPushBack",
		Input: []tf.Input{
			input_handle, tensor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueWithCountsAttr is an optional argument to UniqueWithCounts.
type UniqueWithCountsAttr func(optionalAttr)

// UniqueWithCountsOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueWithCountsOutIdx(value tf.DataType) UniqueWithCountsAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements in a 1-D tensor.
//
// This operation returns a tensor `y` containing all of the unique elements of `x`
// sorted in the same order that they occur in `x`. This operation also returns a
// tensor `idx` the same size as `x` that contains the index of each value of `x`
// in the unique output `y`. Finally, it returns a third tensor `count` that
// contains the count of each element of `y` in `x`. In other words:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx, count = unique_with_counts(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// count ==> [2, 1, 3, 1, 2]
// ```
//
// Arguments:
//	x: 1-D.
//
// Returns:
//	y: 1-D.
//	idx: 1-D.
//	count: 1-D.
func UniqueWithCounts(scope *Scope, x tf.Output, optional ...UniqueWithCountsAttr) (y tf.Output, idx tf.Output, count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueWithCounts",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResizeBicubicGradAttr is an optional argument to ResizeBicubicGrad.
type ResizeBicubicGradAttr func(optionalAttr)

// ResizeBicubicGradAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and grad tensors are
// aligned. Defaults to false.
// If not specified, defaults to false
func ResizeBicubicGradAlignCorners(value bool) ResizeBicubicGradAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBicubicGradHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBicubicGradHalfPixelCenters(value bool) ResizeBicubicGradAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Computes the gradient of bicubic interpolation.
//
// Arguments:
//	grads: 4-D with shape `[batch, height, width, channels]`.
//	original_image: 4-D with shape `[batch, orig_height, orig_width, channels]`,
// The image tensor that was resized.
//
// Returns 4-D with shape `[batch, orig_height, orig_width, channels]`.
// Gradients with respect to the input image. Input image must have been
// float or double.
func ResizeBicubicGrad(scope *Scope, grads tf.Output, original_image tf.Output, optional ...ResizeBicubicGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBicubicGrad",
		Input: []tf.Input{
			grads, original_image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert one or more images from HSV to RGB.
//
// Outputs a tensor of the same shape as the `images` tensor, containing the RGB
// value of the pixels. The output is only well defined if the value in `images`
// are in `[0,1]`.
//
// See `rgb_to_hsv` for a description of the HSV encoding.
//
// Arguments:
//	images: 1-D or higher rank. HSV data to convert. Last dimension must be size 3.
//
// Returns `images` converted to RGB.
func HSVToRGB(scope *Scope, images tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "HSVToRGB",
		Input: []tf.Input{
			images,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the mean along sparse segments of a tensor.
//
// Like `SparseSegmentMean`, but allows missing ids in `segment_ids`. If an id is
// missing, the `output` tensor at that position will be zeroed.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//	num_segments: Should equal the number of distinct segment IDs.
//
// Returns Has same shape as data, except for dimension 0 which has size
// `num_segments`.
func SparseSegmentMeanWithNumSegments(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentMeanWithNumSegments",
		Input: []tf.Input{
			data, indices, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeBicubicAttr is an optional argument to ResizeBicubic.
type ResizeBicubicAttr func(optionalAttr)

// ResizeBicubicAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func ResizeBicubicAlignCorners(value bool) ResizeBicubicAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBicubicHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBicubicHalfPixelCenters(value bool) ResizeBicubicAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Resize `images` to `size` using bicubic interpolation.
//
// Input images can be of different types but output images are always float.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ResizeBicubic(scope *Scope, images tf.Output, size tf.Output, optional ...ResizeBicubicAttr) (resized_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBicubic",
		Input: []tf.Input{
			images, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeAreaAttr is an optional argument to ResizeArea.
type ResizeAreaAttr func(optionalAttr)

// ResizeAreaAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func ResizeAreaAlignCorners(value bool) ResizeAreaAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// Resize `images` to `size` using area interpolation.
//
// Input images can be of different types but output images are always float.
//
// The range of pixel values for the output image might be slightly different
// from the range for the input image because of limited numerical precision.
// To guarantee an output range, for example `[0.0, 1.0]`, apply
// `tf.clip_by_value` to the output.
//
// Each output pixel is computed by first transforming the pixel's footprint into
// the input tensor and then averaging the pixels that intersect the footprint. An
// input pixel's contribution to the average is weighted by the fraction of its
// area that intersects the footprint.  This is the same as OpenCV's INTER_AREA.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ResizeArea(scope *Scope, images tf.Output, size tf.Output, optional ...ResizeAreaAttr) (resized_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeArea",
		Input: []tf.Input{
			images, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//   This op is used as a placeholder in If branch functions. It doesn't provide a
//   valid output when run, so must either be removed (e.g. replaced with a
//   function input) or guaranteed not to be used (e.g. if mirroring an
//   intermediate output needed for the gradient computation of the other branch).
//
// Arguments:
//	dtype: The type of the output.
//	shape:     The purported shape of the output. This is only used for shape inference;
//     the output will not necessarily have this shape. Can be a partial shape.
//
// Returns     \"Fake\" output value. This should not be consumed by another op.
func FakeParam(scope *Scope, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "FakeParam",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the power of one value to another.
//
// Given a tensor `x` and a tensor `y`, this operation computes \\(x^y\\) for
// corresponding elements in `x` and `y`. For example:
//
// ```
// # tensor 'x' is [[2, 2]], [3, 3]]
// # tensor 'y' is [[8, 16], [2, 3]]
// tf.pow(x, y) ==> [[256, 65536], [9, 27]]
// ```
func Pow(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Pow",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Records the latency of producing `input_dataset` elements in a StatsAggregator.
func LatencyStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "LatencyStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebug.
type LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugConfig(value string) LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load SGD embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the stochastic gradient descent optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the Adadelta optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebug(scope *Scope, parameters tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes natural logarithm of x element-wise.
//
// I.e., \\(y = \log_e x\\).
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 5])
// tf.math.log(x) ==> [-inf, -0.6931472,  0. ,  1.609438]
// ```
func Log(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShardDatasetAttr is an optional argument to ShardDataset.
type ShardDatasetAttr func(optionalAttr)

// ShardDatasetRequireNonEmpty sets the optional require_non_empty attribute to value.
// If not specified, defaults to false
func ShardDatasetRequireNonEmpty(value bool) ShardDatasetAttr {
	return func(m optionalAttr) {
		m["require_non_empty"] = value
	}
}

// Creates a `Dataset` that includes only 1/`num_shards` of this dataset.
//
// Arguments:
//
//	num_shards: An integer representing the number of shards operating in parallel.
//	index: An integer representing the current worker index.
//
//
func ShardDataset(scope *Scope, input_dataset tf.Output, num_shards tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShardDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShardDataset",
		Input: []tf.Input{
			input_dataset, num_shards, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates an all-zeros CSRSparseMatrix with shape `dense_shape`.
//
// Arguments:
//	dense_shape: The desired matrix shape.
//
//
// Returns An empty CSR matrix with shape `dense_shape`.
func SparseMatrixZeros(scope *Scope, dense_shape tf.Output, type_ tf.DataType) (sparse_matrix tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "SparseMatrixZeros",
		Input: []tf.Input{
			dense_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AddManySparseToTensorsMapAttr is an optional argument to AddManySparseToTensorsMap.
type AddManySparseToTensorsMapAttr func(optionalAttr)

// AddManySparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddManySparseToTensorsMapContainer(value string) AddManySparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddManySparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddManySparseToTensorsMapSharedName(value string) AddManySparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add an `N`-minibatch `SparseTensor` to a `SparseTensorsMap`, return `N` handles.
//
// A `SparseTensor` of rank `R` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`, where
//
// ```sparse_indices.shape[1] == sparse_shape.shape[0] == R```
//
// An `N`-minibatch of `SparseTensor` objects is represented as a `SparseTensor`
// having a first `sparse_indices` column taking values between `[0, N)`, where
// the minibatch size `N == sparse_shape[0]`.
//
// The input `SparseTensor` must have rank `R` greater than 1, and the first
// dimension is treated as the minibatch dimension.  Elements of the `SparseTensor`
// must be sorted in increasing order of this first dimension.  The stored
// `SparseTensor` objects pointed to by each row of the output `sparse_handles`
// will have rank `R-1`.
//
// The `SparseTensor` values can then be read out as part of a minibatch by passing
// the given keys as vector elements to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddManySparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the minibatch `SparseTensor`.
// `sparse_indices[:, 0]` must be ordered values in `[0, N)`.
//	sparse_values: 1-D.  The `values` of the minibatch `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the minibatch `SparseTensor`.
// The minibatch size `N == sparse_shape[0]`.
//
// Returns 1-D.  The handles of the `SparseTensor` now stored in the
// `SparseTensorsMap`.  Shape: `[N]`.
func AddManySparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddManySparseToTensorsMapAttr) (sparse_handles tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddManySparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SendAttr is an optional argument to Send.
type SendAttr func(optionalAttr)

// SendClientTerminated sets the optional client_terminated attribute to value.
//
// value: If set to true, this indicates that the node was added
// to the graph as a result of a client-side feed or fetch of Tensor data,
// in which case the corresponding send or recv is expected to be managed
// locally by the caller.
// If not specified, defaults to false
func SendClientTerminated(value bool) SendAttr {
	return func(m optionalAttr) {
		m["client_terminated"] = value
	}
}

// Sends the named tensor from send_device to recv_device.
//
// Arguments:
//	tensor: The tensor to send.
//	tensor_name: The name of the tensor to send.
//	send_device: The name of the device sending the tensor.
//	send_device_incarnation: The current incarnation of send_device.
//	recv_device: The name of the device receiving the tensor.
//
// Returns the created operation.
func Send(scope *Scope, tensor tf.Output, tensor_name string, send_device string, send_device_incarnation int64, recv_device string, optional ...SendAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"tensor_name": tensor_name, "send_device": send_device, "send_device_incarnation": send_device_incarnation, "recv_device": recv_device}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Send",
		Input: []tf.Input{
			tensor,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Elementwise computes the bitwise OR of `x` and `y`.
//
// The result will have those bits set, that are set in `x`, `y` or both. The
// computation is performed on the underlying representations of `x` and `y`.
//
// For example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
//               tf.uint8, tf.uint16, tf.uint32, tf.uint64]
//
// for dtype in dtype_list:
//   lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
//   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//   exp = tf.constant([5, 5, 7, 15], dtype=tf.float32)
//
//   res = bitwise_ops.bitwise_or(lhs, rhs)
//   tf.assert_equal(tf.cast(res,  tf.float32), exp)  # TRUE
// ```
//
func BitwiseOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulV2Attr is an optional argument to BatchMatMulV2.
type BatchMatMulV2Attr func(optionalAttr)

// BatchMatMulV2AdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV2AdjX(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulV2AdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV2AdjY(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// *NOTE*: `BatchMatMulV2` supports broadcasting in the batch dimensions. More
// about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMulV2(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMulV2",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generate a sharded filename. The filename is printf formatted as
//
//    %s-%05d-of-%05d, basename, shard, num_shards.
func ShardedFilename(scope *Scope, basename tf.Output, shard tf.Output, num_shards tf.Output) (filename tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ShardedFilename",
		Input: []tf.Input{
			basename, shard, num_shards,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Calculates the softmax of a CSRSparseMatrix.
//
// Calculate the softmax of the innermost dimensions of a SparseMatrix.
//
// Missing values are treated as `-inf` (i.e., logits of zero probability); and
// the output has the same sparsity structure as the input (though missing values
// in the output may now be treated as having probability zero).
//
// Arguments:
//	logits: A CSRSparseMatrix.
//
//
// Returns A CSRSparseMatrix.
func SparseMatrixSoftmax(scope *Scope, logits tf.Output, type_ tf.DataType) (softmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "SparseMatrixSoftmax",
		Input: []tf.Input{
			logits,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a tree ensemble model and returns a handle to it.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble resource to be created.
//	stamp_token: Token to use as the initial value of the resource stamp.
//	tree_ensemble_serialized: Serialized proto of the tree ensemble.
//
// Returns the created operation.
func BoostedTreesCreateEnsemble(scope *Scope, tree_ensemble_handle tf.Output, stamp_token tf.Output, tree_ensemble_serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCreateEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, stamp_token, tree_ensemble_serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// Encodes an `ExtensionType` value into a `variant` scalar Tensor.
//
// Returns a scalar variant tensor containing a single `CompositeTensorVariant`
// with the specified Tensor components and TypeSpec.
//
// Arguments:
//	components: The component tensors for the extension type value.
//	metadata: String serialization for the TypeSpec.  (Note: the encoding for the TypeSpec
// may change in future versions of TensorFlow.)
//
// Returns A `variant` Tensor that containing the encoded value.
func CompositeTensorVariantFromComponents(scope *Scope, components []tf.Output, metadata string) (encoded tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"metadata": metadata}
	opspec := tf.OpSpec{
		Type: "CompositeTensorVariantFromComponents",
		Input: []tf.Input{
			tf.OutputList(components),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Registers a dataset with the tf.data service.
func RegisterDataset(scope *Scope, dataset tf.Output, address tf.Output, protocol tf.Output, external_state_policy int64) (dataset_id tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"external_state_policy": external_state_policy}
	opspec := tf.OpSpec{
		Type: "RegisterDataset",
		Input: []tf.Input{
			dataset, address, protocol,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataServiceDatasetAttr is an optional argument to DataServiceDataset.
type DataServiceDatasetAttr func(optionalAttr)

// DataServiceDatasetTaskRefreshIntervalHintMs sets the optional task_refresh_interval_hint_ms attribute to value.
// If not specified, defaults to -1
func DataServiceDatasetTaskRefreshIntervalHintMs(value int64) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["task_refresh_interval_hint_ms"] = value
	}
}

// DataServiceDatasetDataTransferProtocol sets the optional data_transfer_protocol attribute to value.
// If not specified, defaults to ""
func DataServiceDatasetDataTransferProtocol(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["data_transfer_protocol"] = value
	}
}

// DataServiceDatasetTargetWorkers sets the optional target_workers attribute to value.
// If not specified, defaults to "AUTO"
func DataServiceDatasetTargetWorkers(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["target_workers"] = value
	}
}

// Creates a dataset that reads data from the tf.data service.
func DataServiceDataset(scope *Scope, dataset_id tf.Output, processing_mode tf.Output, address tf.Output, protocol tf.Output, job_name tf.Output, max_outstanding_requests tf.Output, iteration_counter tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DataServiceDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataServiceDataset",
		Input: []tf.Input{
			dataset_id, processing_mode, address, protocol, job_name, max_outstanding_requests, iteration_counter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A dataset that splits the elements of its input into multiple elements.
func ExperimentalUnbatchDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalUnbatchDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceMaxSparseAttr is an optional argument to SparseReduceMaxSparse.
type SparseReduceMaxSparseAttr func(optionalAttr)

// SparseReduceMaxSparseKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceMaxSparseKeepDims(value bool) SparseReduceMaxSparseAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the max of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_max()`.  In contrast to SparseReduceMax, this Op returns a
// SparseTensor.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
func SparseReduceMaxSparse(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceMaxSparseAttr) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceMaxSparse",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Creates a dataset that caches elements from `input_dataset`.
//
// A CacheDataset will iterate over the input_dataset, and store tensors. If the
// cache already exists, the cache will be used. If the cache is inappropriate
// (e.g. cannot be opened, contains tensors of the wrong shape / size), an error
// will the returned when used.
//
// Arguments:
//
//	filename: A path on the filesystem where we should cache the dataset. Note: this
// will be a directory.
//
//
func CacheDataset(scope *Scope, input_dataset tf.Output, filename tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "CacheDataset",
		Input: []tf.Input{
			input_dataset, filename,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ThreadPoolHandleAttr is an optional argument to ThreadPoolHandle.
type ThreadPoolHandleAttr func(optionalAttr)

// ThreadPoolHandleMaxIntraOpParallelism sets the optional max_intra_op_parallelism attribute to value.
//
// value: The maximum degree of parallelism to use within operations that execute on this
// threadpool.
// If not specified, defaults to 1
func ThreadPoolHandleMaxIntraOpParallelism(value int64) ThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["max_intra_op_parallelism"] = value
	}
}

// ThreadPoolHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func ThreadPoolHandleContainer(value string) ThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ThreadPoolHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ThreadPoolHandleSharedName(value string) ThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//	num_threads: The number of threads in the thread pool.
//	display_name: A human-readable name for the threads that may be visible in some
// visualizations.
// threadpool.
//
// Returns A resource that can be consumed by one or more ExperimentalThreadPoolDataset
// ops.
func ThreadPoolHandle(scope *Scope, num_threads int64, display_name string, optional ...ThreadPoolHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_threads": num_threads, "display_name": display_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ThreadPoolHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator as an Optional variant.
func IteratorGetNextAsOptional(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextAsOptional",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the number of elements in the given table.
//
// Arguments:
//	table_handle: Handle to the table.
//
// Returns Scalar that contains number of elements in the table.
func LookupTableSizeV2(scope *Scope, table_handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableSizeV2",
		Input: []tf.Input{
			table_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that executes a SQL query and emits rows of the result set.
//
// Arguments:
//	driver_name: The database type. Currently, the only supported type is 'sqlite'.
//	data_source_name: A connection string to connect to the database.
//	query: A SQL query to execute.
//
//
func ExperimentalSqlDataset(scope *Scope, driver_name tf.Output, data_source_name tf.Output, query tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSqlDataset",
		Input: []tf.Input{
			driver_name, data_source_name, query,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingProximalAdagradParametersAttr is an optional argument to LoadTPUEmbeddingProximalAdagradParameters.
type LoadTPUEmbeddingProximalAdagradParametersAttr func(optionalAttr)

// LoadTPUEmbeddingProximalAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingProximalAdagradParametersTableId(value int64) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersTableName(value string) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersConfig(value string) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load proximal Adagrad embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the proximal Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the proximal Adagrad optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingProximalAdagradParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingProximalAdagradParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingProximalAdagradParameters",
		Input: []tf.Input{
			parameters, accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Multiplies sparse updates into the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] *= updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] *= updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] *= updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions multiply.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterMul(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterMul",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a dataset that passes a sliding window over `input_dataset`.
//
// Arguments:
//
//	window_size: A scalar representing the number of elements in the
// sliding window.
//	window_shift: A scalar representing the steps moving the sliding window
// forward in one iteration. It must be positive.
//	window_stride: A scalar representing the stride of the input elements of the sliding window.
// It must be positive.
//
//
func ExperimentalSlidingWindowDataset(scope *Scope, input_dataset tf.Output, window_size tf.Output, window_shift tf.Output, window_stride tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSlidingWindowDataset",
		Input: []tf.Input{
			input_dataset, window_size, window_shift, window_stride,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RealAttr is an optional argument to Real.
type RealAttr func(optionalAttr)

// RealTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func RealTout(value tf.DataType) RealAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the real part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the real part of each element in `input`. All elements in
// `input` must be complex numbers of the form \\(a + bj\\), where *a* is the real
//  part returned by this operation and *b* is the imaginary part.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.real(input) ==> [-2.25, 3.25]
// ```
func Real(scope *Scope, input tf.Output, optional ...RealAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Real",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArraySizeV3
//
// DEPRECATED at GraphDef version 26: Use TensorArraySizeV3
func TensorArraySizeV2(scope *Scope, handle tf.Output, flow_in tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySizeV2",
		Input: []tf.Input{
			handle, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ArgMaxAttr is an optional argument to ArgMax.
type ArgMaxAttr func(optionalAttr)

// ArgMaxOutputType sets the optional output_type attribute to value.
// If not specified, defaults to DT_INT64
func ArgMaxOutputType(value tf.DataType) ArgMaxAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Returns the index with the largest value across dimensions of a tensor.
//
// Note that in case of ties the identity of the return value is not guaranteed.
//
// Usage:
//   ```python
//   import tensorflow as tf
//   a = [1, 10, 26.9, 2.8, 166.32, 62.3]
//   b = tf.math.argmax(input = a)
//   c = tf.keras.backend.eval(b)
//   # c = 4
//   # here a[4] = 166.32 which is the largest element of a across axis 0
//   ```
//
// Arguments:
//
//	dimension: int32 or int64, must be in the range `[-rank(input), rank(input))`.
// Describes which dimension of the input Tensor to reduce across. For vectors,
// use dimension = 0.
func ArgMax(scope *Scope, input tf.Output, dimension tf.Output, optional ...ArgMaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ArgMax",
		Input: []tf.Input{
			input, dimension,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reshapes a tensor.
//
// Given `tensor`, this operation returns a tensor that has the same values
// as `tensor` with shape `shape`.
//
// If one component of 1-D tensor `shape` is the special value -1, the size of that
// dimension is computed so that the total size remains constant.  In particular, a
// `shape` of `[-1]` flattens into 1-D.  At most one component of `shape` may be
// unknown.
//
// The `shape` must be 1-D and the operation returns a tensor with shape
// `shape` filled with the values of `tensor`. In this case, the number of elements
// implied by `shape` must be the same as the number of elements in `tensor`.
//
// It is an error if `shape` is not 1-D.
//
// For example:
//
// ```
// # tensor 't' is [1, 2, 3, 4, 5, 6, 7, 8, 9]
// # tensor 't' has shape [9]
// reshape(t, [3, 3]) ==> [[1, 2, 3],
//                         [4, 5, 6],
//                         [7, 8, 9]]
//
// # tensor 't' is [[[1, 1], [2, 2]],
// #                [[3, 3], [4, 4]]]
// # tensor 't' has shape [2, 2, 2]
// reshape(t, [2, 4]) ==> [[1, 1, 2, 2],
//                         [3, 3, 4, 4]]
//
// # tensor 't' is [[[1, 1, 1],
// #                 [2, 2, 2]],
// #                [[3, 3, 3],
// #                 [4, 4, 4]],
// #                [[5, 5, 5],
// #                 [6, 6, 6]]]
// # tensor 't' has shape [3, 2, 3]
// # pass '[-1]' to flatten 't'
// reshape(t, [-1]) ==> [1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6]
//
// # -1 can also be used to infer the shape
//
// # -1 is inferred to be 9:
// reshape(t, [2, -1]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
//                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
// # -1 is inferred to be 2:
// reshape(t, [-1, 9]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
//                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
// # -1 is inferred to be 3:
// reshape(t, [ 2, -1, 3]) ==> [[[1, 1, 1],
//                               [2, 2, 2],
//                               [3, 3, 3]],
//                              [[4, 4, 4],
//                               [5, 5, 5],
//                               [6, 6, 6]]]
//
// # tensor 't' is [7]
// # shape `[]` reshapes to a scalar
// reshape(t, []) ==> 7
// ```
//
// Arguments:
//
//	shape: Defines the shape of the output tensor.
func Reshape(scope *Scope, tensor tf.Output, shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Reshape",
		Input: []tf.Input{
			tensor, shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SnapshotDatasetAttr is an optional argument to SnapshotDataset.
type SnapshotDatasetAttr func(optionalAttr)

// SnapshotDatasetCompression sets the optional compression attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetCompression(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["compression"] = value
	}
}

// SnapshotDatasetReaderPathPrefix sets the optional reader_path_prefix attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetReaderPathPrefix(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["reader_path_prefix"] = value
	}
}

// SnapshotDatasetWriterPathPrefix sets the optional writer_path_prefix attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetWriterPathPrefix(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["writer_path_prefix"] = value
	}
}

// SnapshotDatasetShardSizeBytes sets the optional shard_size_bytes attribute to value.
// If not specified, defaults to 10737418240
func SnapshotDatasetShardSizeBytes(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["shard_size_bytes"] = value
	}
}

// SnapshotDatasetPendingSnapshotExpirySeconds sets the optional pending_snapshot_expiry_seconds attribute to value.
// If not specified, defaults to 86400
func SnapshotDatasetPendingSnapshotExpirySeconds(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["pending_snapshot_expiry_seconds"] = value
	}
}

// SnapshotDatasetNumReaderThreads sets the optional num_reader_threads attribute to value.
// If not specified, defaults to 1
func SnapshotDatasetNumReaderThreads(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["num_reader_threads"] = value
	}
}

// SnapshotDatasetReaderBufferSize sets the optional reader_buffer_size attribute to value.
// If not specified, defaults to 1
func SnapshotDatasetReaderBufferSize(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["reader_buffer_size"] = value
	}
}

// SnapshotDatasetNumWriterThreads sets the optional num_writer_threads attribute to value.
// If not specified, defaults to 1
func SnapshotDatasetNumWriterThreads(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["num_writer_threads"] = value
	}
}

// SnapshotDatasetWriterBufferSize sets the optional writer_buffer_size attribute to value.
// If not specified, defaults to 1
func SnapshotDatasetWriterBufferSize(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["writer_buffer_size"] = value
	}
}

// SnapshotDatasetShuffleOnRead sets the optional shuffle_on_read attribute to value.
// If not specified, defaults to false
func SnapshotDatasetShuffleOnRead(value bool) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["shuffle_on_read"] = value
	}
}

// SnapshotDatasetSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func SnapshotDatasetSeed(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// SnapshotDatasetSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func SnapshotDatasetSeed2(value int64) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// SnapshotDatasetMode sets the optional mode attribute to value.
// If not specified, defaults to "auto"
func SnapshotDatasetMode(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["mode"] = value
	}
}

// SnapshotDatasetSnapshotName sets the optional snapshot_name attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetSnapshotName(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["snapshot_name"] = value
	}
}

// Creates a dataset that will write to / read from a snapshot.
//
// This dataset attempts to determine whether a valid snapshot exists at the
// `snapshot_path`, and reads from the snapshot in lieu of using `input_dataset`.
// If not, it will run the preprocessing pipeline as usual, and write out a
// snapshot of the data processed for future use.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	path: The path we should write snapshots to / read snapshots from.
//
//
func SnapshotDataset(scope *Scope, input_dataset tf.Output, path tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...SnapshotDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SnapshotDataset",
		Input: []tf.Input{
			input_dataset, path,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RebatchDatasetAttr is an optional argument to RebatchDataset.
type RebatchDatasetAttr func(optionalAttr)

// RebatchDatasetUseFallback sets the optional use_fallback attribute to value.
// If not specified, defaults to true
func RebatchDatasetUseFallback(value bool) RebatchDatasetAttr {
	return func(m optionalAttr) {
		m["use_fallback"] = value
	}
}

// Creates a dataset that changes the batch size.
//
// Creates a dataset that changes the batch size of the dataset to current batch
// size // num_workers.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	num_replicas: A scalar representing the number of replicas to distribute this batch across. As
// a result of this transformation the current batch size would end up being
// divided  by this parameter.
//
//
func RebatchDataset(scope *Scope, input_dataset tf.Output, num_replicas tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...RebatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RebatchDataset",
		Input: []tf.Input{
			input_dataset, num_replicas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalRebatchDatasetAttr is an optional argument to ExperimentalRebatchDataset.
type ExperimentalRebatchDatasetAttr func(optionalAttr)

// ExperimentalRebatchDatasetUseFallback sets the optional use_fallback attribute to value.
// If not specified, defaults to true
func ExperimentalRebatchDatasetUseFallback(value bool) ExperimentalRebatchDatasetAttr {
	return func(m optionalAttr) {
		m["use_fallback"] = value
	}
}

// Creates a dataset that changes the batch size.
//
// Creates a dataset that changes the batch size of the dataset to current batch
// size // num_replicas.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	num_replicas: A scalar representing the number of replicas to distribute this batch across. As
// a result of this transformation the current batch size would end up being
// divided  by this parameter.
//
//
func ExperimentalRebatchDataset(scope *Scope, input_dataset tf.Output, num_replicas tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalRebatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalRebatchDataset",
		Input: []tf.Input{
			input_dataset, num_replicas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that contains the unique elements of `input_dataset`.
func UniqueDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "UniqueDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalAvgPoolAttr is an optional argument to FractionalAvgPool.
type FractionalAvgPoolAttr func(optionalAttr)

// FractionalAvgPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalAvgPoolPseudoRandom(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalAvgPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolOverlapping(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalAvgPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalAvgPool node in the computation graph. Mainly used
// in unit test to make FractionalAvgPool deterministic.
// If not specified, defaults to false
func FractionalAvgPoolDeterministic(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalAvgPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalAvgPoolSeed(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalAvgPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalAvgPoolSeed2(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional average pooling on the input.
//
// Fractional average pooling is similar to Fractional max pooling in the pooling
// region generation step. The only difference is that after pooling regions are
// generated, a mean operation is performed instead of a max operation in each
// pooling region.
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns:
//	output: output tensor after fractional avg pooling.
//	row_pooling_sequence: row pooling sequence, needed to calculate gradient.
//	col_pooling_sequence: column pooling sequence, needed to calculate gradient.
func FractionalAvgPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalAvgPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Creates a Dataset that returns pseudorandom numbers.
//
// Creates a Dataset that returns a stream of uniformly distributed
// pseudorandom 64-bit signed integers.
//
// In the TensorFlow Python API, you can instantiate this dataset via the
// class `tf.data.experimental.RandomDataset`.
//
// Instances of this dataset are also created as a result of the
// `hoist_random_uniform` static optimization. Whether this optimization is
// performed is determined by the `experimental_optimization.hoist_random_uniform`
// option of `tf.data.Options`.
//
// Arguments:
//	seed: A scalar seed for the random number generator. If either seed or
// seed2 is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func RandomDataset(scope *Scope, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "RandomDataset",
		Input: []tf.Input{
			seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalIgnoreErrorsDatasetAttr is an optional argument to ExperimentalIgnoreErrorsDataset.
type ExperimentalIgnoreErrorsDatasetAttr func(optionalAttr)

// ExperimentalIgnoreErrorsDatasetLogWarning sets the optional log_warning attribute to value.
// If not specified, defaults to false
func ExperimentalIgnoreErrorsDatasetLogWarning(value bool) ExperimentalIgnoreErrorsDatasetAttr {
	return func(m optionalAttr) {
		m["log_warning"] = value
	}
}

// Creates a dataset that contains the elements of `input_dataset` ignoring errors.
func ExperimentalIgnoreErrorsDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalIgnoreErrorsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalIgnoreErrorsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a Dataset that returns pseudorandom numbers.
//
// Arguments:
//	seed: A scalar seed for the random number generator. If either seed or
// seed2 is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func ExperimentalRandomDataset(scope *Scope, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalRandomDataset",
		Input: []tf.Input{
			seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the main diagonal of the
// innermost matrices.  These will be overwritten by the values in `diagonal`.
//
// The output is computed as follows:
//
// Assume `input` has `k+1` dimensions `[I, J, K, ..., M, N]` and `diagonal` has
// `k` dimensions `[I, J, K, ..., min(M, N)]`.  Then the output is a
// tensor of rank `k+1` with dimensions `[I, J, K, ..., M, N]` where:
//
//   * `output[i, j, k, ..., m, n] = diagonal[i, j, k, ..., n]` for `m == n`.
//   * `output[i, j, k, ..., m, n] = input[i, j, k, ..., m, n]` for `m != n`.
//
// Arguments:
//	input: Rank `k+1`, where `k >= 1`.
//	diagonal: Rank `k`, where `k >= 1`.
//
// Returns Rank `k+1`, with `output.shape = input.shape`.
func MatrixSetDiag(scope *Scope, input tf.Output, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiag",
		Input: []tf.Input{
			input, diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseExampleDatasetV2Attr is an optional argument to ParseExampleDatasetV2.
type ParseExampleDatasetV2Attr func(optionalAttr)

// ParseExampleDatasetV2Deterministic sets the optional deterministic attribute to value.
//
// value: A string indicating the op-level determinism to use. Deterministic controls
// whether the dataset is allowed to return elements out of order if the next
// element to be returned isn't available, but a later element is. Options are
// "true", "false", and "default". "default" indicates that determinism should be
// decided by the `experimental_deterministic` parameter of `tf.data.Options`.
// If not specified, defaults to "default"
func ParseExampleDatasetV2Deterministic(value string) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// ParseExampleDatasetV2RaggedKeys sets the optional ragged_keys attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetV2RaggedKeys(value []string) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["ragged_keys"] = value
	}
}

// ParseExampleDatasetV2RaggedValueTypes sets the optional ragged_value_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetV2RaggedValueTypes(value []tf.DataType) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["ragged_value_types"] = value
	}
}

// ParseExampleDatasetV2RaggedSplitTypes sets the optional ragged_split_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetV2RaggedSplitTypes(value []tf.DataType) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["ragged_split_types"] = value
	}
}

// Transforms `input_dataset` containing `Example` protos as vectors of DT_STRING into a dataset of `Tensor` or `SparseTensor` objects representing the parsed features.
//
// Arguments:
//
//
//	dense_defaults: A dict mapping string keys to `Tensor`s.
// The keys of the dict must match the dense_keys of the feature.
//	sparse_keys: A list of string keys in the examples features.
// The results for these keys will be returned as `SparseTensor` objects.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples features associated with dense values.
//	sparse_types: A list of `DTypes` of the same length as `sparse_keys`.
// Only `tf.float32` (`FloatList`), `tf.int64` (`Int64List`),
// and `tf.string` (`BytesList`) are supported.
//	dense_shapes: List of tuples with the same length as `dense_keys`.
// The shape of the data for each dense feature referenced by `dense_keys`.
// Required for any input tensors identified by `dense_keys`.  Must be
// either fully defined, or may contain an unknown first dimension.
// An unknown first dimension means the feature is treated as having
// a variable number of blocks, and the output shape along this dimension
// is considered unknown at graph build time.  Padding is applied for
// minibatch elements smaller than the maximum number of blocks for the
// given feature along this dimension.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
func ParseExampleDatasetV2(scope *Scope, input_dataset tf.Output, num_parallel_calls tf.Output, dense_defaults []tf.Output, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ParseExampleDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseExampleDatasetV2",
		Input: []tf.Input{
			input_dataset, num_parallel_calls, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RestoreSliceAttr is an optional argument to RestoreSlice.
type RestoreSliceAttr func(optionalAttr)

// RestoreSlicePreferredShard sets the optional preferred_shard attribute to value.
//
// value: Index of file to open first if multiple files match
// `file_pattern`. See the documentation for `Restore`.
// If not specified, defaults to -1
func RestoreSlicePreferredShard(value int64) RestoreSliceAttr {
	return func(m optionalAttr) {
		m["preferred_shard"] = value
	}
}

// Restores a tensor from checkpoint files.
//
// This is like `Restore` except that restored tensor can be listed as filling
// only a slice of a larger tensor.  `shape_and_slice` specifies the shape of the
// larger tensor and the slice that the restored tensor covers.
//
// The `shape_and_slice` input has the same format as the
// elements of the `shapes_and_slices` input of the `SaveSlices` op.
//
// Arguments:
//	file_pattern: Must have a single element. The pattern of the files from
// which we read the tensor.
//	tensor_name: Must have a single element. The name of the tensor to be
// restored.
//	shape_and_slice: Scalar. The shapes and slice specifications to use when
// restoring a tensors.
//	dt: The type of the tensor to be restored.
//
// Returns The restored tensor.
func RestoreSlice(scope *Scope, file_pattern tf.Output, tensor_name tf.Output, shape_and_slice tf.Output, dt tf.DataType, optional ...RestoreSliceAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dt": dt}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RestoreSlice",
		Input: []tf.Input{
			file_pattern, tensor_name, shape_and_slice,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParameterizedTruncatedNormalAttr is an optional argument to ParameterizedTruncatedNormal.
type ParameterizedTruncatedNormalAttr func(optionalAttr)

// ParameterizedTruncatedNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func ParameterizedTruncatedNormalSeed(value int64) ParameterizedTruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// ParameterizedTruncatedNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func ParameterizedTruncatedNormalSeed2(value int64) ParameterizedTruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a normal distribution. The parameters may each be a
//
// scalar which applies to the entire output, or a vector of length shape[0] which
// stores the parameters for each batch.
//
// Arguments:
//	shape: The shape of the output tensor. Batches are indexed by the 0th dimension.
//	means: The mean parameter of each batch.
//	stdevs: The standard deviation parameter of each batch. Must be greater than 0.
//	minvals: The minimum cutoff. May be -infinity.
//	maxvals: The maximum cutoff. May be +infinity, and must be more than the minval
// for each batch.
//
// Returns A matrix of shape num_batches x samples_per_batch, filled with random
// truncated normal values using the parameters for each row.
func ParameterizedTruncatedNormal(scope *Scope, shape tf.Output, means tf.Output, stdevs tf.Output, minvals tf.Output, maxvals tf.Output, optional ...ParameterizedTruncatedNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParameterizedTruncatedNormal",
		Input: []tf.Input{
			shape, means, stdevs, minvals, maxvals,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sign and the log of the absolute value of the determinant of
//
// one or more square matrices.
//
// The input is a tensor of shape `[N, M, M]` whose inner-most 2 dimensions
// form square matrices. The outputs are two tensors containing the signs and
// absolute values of the log determinants for all N input submatrices
// `[..., :, :]` such that `determinant = sign*exp(log_abs_determinant)`.
// The `log_abs_determinant` is computed as `det(P)*sum(log(diag(LU)))` where `LU`
// is the `LU` decomposition of the input and `P` is the corresponding
// permutation matrix.
//
// Arguments:
//	input: Shape is `[N, M, M]`.
//
// Returns:
//	sign: The signs of the log determinants of the inputs. Shape is `[N]`.
//	log_abs_determinant: The logs of the absolute values of the determinants
// of the N input matrices.  Shape is `[N]`.
func LogMatrixDeterminant(scope *Scope, input tf.Output) (sign tf.Output, log_abs_determinant tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogMatrixDeterminant",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// SkipgramAttr is an optional argument to Skipgram.
type SkipgramAttr func(optionalAttr)

// SkipgramWindowSize sets the optional window_size attribute to value.
//
// value: The number of words to predict to the left and right of the target.
// If not specified, defaults to 5
func SkipgramWindowSize(value int64) SkipgramAttr {
	return func(m optionalAttr) {
		m["window_size"] = value
	}
}

// SkipgramMinCount sets the optional min_count attribute to value.
//
// value: The minimum number of word occurrences for it to be included in the
// vocabulary.
// If not specified, defaults to 5
func SkipgramMinCount(value int64) SkipgramAttr {
	return func(m optionalAttr) {
		m["min_count"] = value
	}
}

// SkipgramSubsample sets the optional subsample attribute to value.
//
// value: Threshold for word occurrence. Words that appear with higher
// frequency will be randomly down-sampled. Set to 0 to disable.
// If not specified, defaults to 0.001
func SkipgramSubsample(value float32) SkipgramAttr {
	return func(m optionalAttr) {
		m["subsample"] = value
	}
}

// Parses a text file and creates a batch of examples.
//
// DEPRECATED at GraphDef version 19: Moving word2vec into tensorflow_models/tutorials and deprecating its ops here as a result
//
// Arguments:
//	filename: The corpus's text file name.
//	batch_size: The size of produced batch.
//
// Returns:
//	vocab_word: A vector of words in the corpus.
//	vocab_freq: Frequencies of words. Sorted in the non-ascending order.
//	words_per_epoch: Number of words per epoch in the data file.
//	current_epoch: The current epoch number.
//	total_words_processed: The total number of words processed so far.
//	examples: A vector of word ids.
//	labels: A vector of word ids.
func Skipgram(scope *Scope, filename string, batch_size int64, optional ...SkipgramAttr) (vocab_word tf.Output, vocab_freq tf.Output, words_per_epoch tf.Output, current_epoch tf.Output, total_words_processed tf.Output, examples tf.Output, labels tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"filename": filename, "batch_size": batch_size}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Skipgram",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Records the latency of producing `input_dataset` elements in a StatsAggregator.
func ExperimentalLatencyStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalLatencyStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AddSparseToTensorsMapAttr is an optional argument to AddSparseToTensorsMap.
type AddSparseToTensorsMapAttr func(optionalAttr)

// AddSparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddSparseToTensorsMapContainer(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddSparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddSparseToTensorsMapSharedName(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add a `SparseTensor` to a `SparseTensorsMap` return its handle.
//
// A `SparseTensor` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`.
//
// This operator takes the given `SparseTensor` and adds it to a container
// object (a `SparseTensorsMap`).  A unique key within this container is generated
// in the form of an `int64`, and this is the value that is returned.
//
// The `SparseTensor` can then be read out as part of a minibatch by passing
// the key as a vector element to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddSparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the `SparseTensor`.
//
// Returns 0-D.  The handle of the `SparseTensor` now stored in the
// `SparseTensorsMap`.
func AddSparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddSparseToTensorsMapAttr) (sparse_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddSparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a vector of tf.Example protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A scalar or vector containing binary serialized Example protos.
//	names: A tensor containing the names of the serialized protos.
// Corresponds 1:1 with the `serialized` tensor.
// May contain, for example, table key (descriptive) names for the
// corresponding serialized protos.  These are purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no names are available.
// If non-empty, this tensor must have the same shape as "serialized".
//	sparse_keys: Vector of strings.
// The keys expected in the Examples' features associated with sparse values.
//	dense_keys: Vector of strings.
// The keys expected in the Examples' features associated with dense values.
//	ragged_keys: Vector of strings.
// The keys expected in the Examples' features associated with ragged values.
//	dense_defaults: A list of Tensors (some may be empty).  Corresponds 1:1 with `dense_keys`.
// dense_defaults[j] provides default values
// when the example's feature_map lacks dense_key[j].  If an empty Tensor is
// provided for dense_defaults[j], then the Feature dense_keys[j] is required.
// The input type is inferred from dense_defaults[j], even when it's empty.
// If dense_defaults[j] is not empty, and dense_shapes[j] is fully defined,
// then the shape of dense_defaults[j] must match that of dense_shapes[j].
// If dense_shapes[j] has an undefined major dimension (variable strides dense
// feature), dense_defaults[j] must contain a single element:
// the padding element.
//	num_sparse: The number of sparse keys.
//	sparse_types: A list of `num_sparse` types; the data types of data in each Feature
// given in sparse_keys.
// Currently the ParseExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	ragged_value_types: A list of `num_ragged` types; the data types of data in each Feature
// given in ragged_keys (where `num_ragged = sparse_keys.size()`).
// Currently the ParseExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	ragged_split_types: A list of `num_ragged` types; the data types of row_splits in each Feature
// given in ragged_keys (where `num_ragged = sparse_keys.size()`).
// May be DT_INT32 or DT_INT64.
//	dense_shapes: A list of `num_dense` shapes; the shapes of data in each Feature
// given in dense_keys (where `num_dense = dense_keys.size()`).
// The number of elements in the Feature corresponding to dense_key[j]
// must always equal dense_shapes[j].NumEntries().
// If dense_shapes[j] == (D0, D1, ..., DN) then the shape of output
// Tensor dense_values[j] will be (|serialized|, D0, D1, ..., DN):
// The dense outputs are just the inputs row-stacked by batch.
// This works for dense_shapes[j] = (-1, D1, ..., DN).  In this case
// the shape of the output Tensor dense_values[j] will be
// (|serialized|, M, D1, .., DN), where M is the maximum number of blocks
// of elements of length D1 * .... * DN, across all minibatch entries
// in the input.  Any minibatch entry with less than M blocks of elements of
// length D1 * ... * DN will be padded with the corresponding default_value
// scalar element along the second dimension.
func ParseExampleV2(scope *Scope, serialized tf.Output, names tf.Output, sparse_keys tf.Output, dense_keys tf.Output, ragged_keys tf.Output, dense_defaults []tf.Output, num_sparse int64, sparse_types []tf.DataType, ragged_value_types []tf.DataType, ragged_split_types []tf.DataType, dense_shapes []tf.Shape) (sparse_indices []tf.Output, sparse_values []tf.Output, sparse_shapes []tf.Output, dense_values []tf.Output, ragged_values []tf.Output, ragged_row_splits []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_sparse": num_sparse, "sparse_types": sparse_types, "ragged_value_types": ragged_value_types, "ragged_split_types": ragged_split_types, "dense_shapes": dense_shapes}
	opspec := tf.OpSpec{
		Type: "ParseExampleV2",
		Input: []tf.Input{
			serialized, names, sparse_keys, dense_keys, ragged_keys, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if sparse_indices, idx, err = makeOutputList(op, idx, "sparse_indices"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if sparse_values, idx, err = makeOutputList(op, idx, "sparse_values"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if sparse_shapes, idx, err = makeOutputList(op, idx, "sparse_shapes"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if dense_values, idx, err = makeOutputList(op, idx, "dense_values"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if ragged_values, idx, err = makeOutputList(op, idx, "ragged_values"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if ragged_row_splits, idx, err = makeOutputList(op, idx, "ragged_row_splits"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	return sparse_indices, sparse_values, sparse_shapes, dense_values, ragged_values, ragged_row_splits
}

// Computes the exponential linear function.
//
// The ELU function is defined as:
//
//  * $ e ^ x - 1 $ if $ x < 0 $
//  * $ x $ if $ x >= 0 $
//
// Examples:
//
// >>> tf.nn.elu(1.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=1.0>
// >>> tf.nn.elu(0.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=0.0>
// >>> tf.nn.elu(-1000.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=-1.0>
//
// See [Fast and Accurate Deep Network Learning by Exponential Linear Units (ELUs)
// ](http://arxiv.org/abs/1511.07289)
func Elu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Elu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Records the bytes size of each element of `input_dataset` in a StatsAggregator.
func ExperimentalBytesProducedStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalBytesProducedStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the name of the device on which `resource` has been placed.
func ExperimentalIteratorGetDevice(scope *Scope, resource tf.Output) (device tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalIteratorGetDevice",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the saturation of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last dimension is
// interpreted as channels, and must be three.
//
// The input image is considered in the RGB colorspace. Conceptually, the RGB
// colors are first mapped into HSV. A scale is then applied all the saturation
// values, and then remapped back to RGB colorspace.
//
// Arguments:
//	images: Images to adjust.  At least 3-D.
//	scale: A float scale to add to the saturation.
//
// Returns The hue-adjusted image or images.
func AdjustSaturation(scope *Scope, images tf.Output, scale tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustSaturation",
		Input: []tf.Input{
			images, scale,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the name of the device on which `resource` has been placed.
func IteratorGetDevice(scope *Scope, resource tf.Output) (device tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IteratorGetDevice",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that emits the key-value pairs in one or more LMDB files.
//
// The Lightning Memory-Mapped Database Manager, or LMDB, is an embedded binary
// key-value database. This dataset can read the contents of LMDB database files,
// the names of which generally have the `.mdb` suffix.
//
// Each output element consists of a key-value pair represented as a pair of
// scalar string `Tensor`s, where the first `Tensor` contains the key and the
// second `Tensor` contains the value.
//
// LMDB uses different file formats on big- and little-endian machines.
// `LMDBDataset` can only read files in the format of the host machine.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the binary file(s) to be
// read.
//
//
func LMDBDataset(scope *Scope, filenames tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "LMDBDataset",
		Input: []tf.Input{
			filenames,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixInverseAttr is an optional argument to MatrixInverse.
type MatrixInverseAttr func(optionalAttr)

// MatrixInverseAdjoint sets the optional adjoint attribute to value.
// If not specified, defaults to false
func MatrixInverseAdjoint(value bool) MatrixInverseAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Computes the inverse of one or more square invertible matrices or their adjoints (conjugate transposes).
//
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor of the same shape as the input
// containing the inverse for all input submatrices `[..., :, :]`.
//
// The op uses LU decomposition with partial pivoting to compute the inverses.
//
// If a matrix is not invertible there is no guarantee what the op does. It
// may detect the condition and raise an exception or it may simply return a
// garbage result.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
//
// @compatibility(numpy)
// Equivalent to np.linalg.inv
// @end_compatibility
func MatrixInverse(scope *Scope, input tf.Output, optional ...MatrixInverseAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixInverse",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes acos of x element-wise.
//
//
//   Provided an input tensor, the `tf.math.acos` operation returns the inverse cosine of each element of the tensor. If `y = tf.math.cos(x)` then, `x = tf.math.acos(y)`.
//
//   Input range is `[-1, 1]` and the output has a range of `[0, pi]`.
//
func Acos(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acos",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that batches input elements into a SparseTensor.
//
// Arguments:
//	input_dataset: A handle to an input dataset. Must have a single component.
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	row_shape: A vector representing the dense shape of each row in the produced
// SparseTensor. The shape may be partially specified, using `-1` to indicate
// that a particular dimension should use the maximum size of all batch elements.
//
//
func ExperimentalDenseToSparseBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, row_shape tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalDenseToSparseBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, row_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	thread_pool: A resource produced by the ThreadPoolHandle op.
//
//
func ExperimentalThreadPoolDataset(scope *Scope, input_dataset tf.Output, thread_pool tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, thread_pool,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceSparseApplyCenteredRMSPropAttr is an optional argument to ResourceSparseApplyCenteredRMSProp.
type ResourceSparseApplyCenteredRMSPropAttr func(optionalAttr)

// ResourceSparseApplyCenteredRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, mg, ms, and mom tensors is
// protected by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyCenteredRMSPropUseLocking(value bool) ResourceSparseApplyCenteredRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the centered RMSProp algorithm.
//
// The centered RMSProp algorithm uses an estimate of the centered second moment
// (i.e., the variance) for normalization, as opposed to regular RMSProp, which
// uses the (uncentered) second moment. This often helps with training, but is
// slightly more expensive in terms of computation and memory.
//
// Note that in dense implementation of this algorithm, mg, ms, and mom will
// update even if the grad is zero, but in this sparse implementation, mg, ms,
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// mean_grad = decay * mean_grad + (1-decay) * gradient
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon - mean_grad ** 2)
//
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	mg: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var, ms and mom.
//
// Returns the created operation.
func ResourceSparseApplyCenteredRMSProp(scope *Scope, var_ tf.Output, mg tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyCenteredRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyCenteredRMSProp",
		Input: []tf.Input{
			var_, mg, ms, mom, lr, rho, momentum, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Writes the given dataset to the given file using the TFRecord format.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to write.
//	filename: A scalar string tensor representing the filename to use.
//	compression_type: A scalar string tensor containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//
// Returns the created operation.
func DatasetToTFRecord(scope *Scope, input_dataset tf.Output, filename tf.Output, compression_type tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetToTFRecord",
		Input: []tf.Input{
			input_dataset, filename, compression_type,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a dataset from the given `graph_def`.
//
// Creates a dataset from the provided `graph_def`.
//
// Arguments:
//	graph_def: The graph representation of the dataset (as serialized GraphDef).
//
// Returns A variant tensor representing the dataset.
func DatasetFromGraph(scope *Scope, graph_def tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetFromGraph",
		Input: []tf.Input{
			graph_def,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Interleave the values from the `data` tensors into a single tensor.
//
// Builds a merged tensor such that
//
// ```python
//     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
// ```
//
// For example, if each `indices[m]` is scalar or vector, we have
//
// ```python
//     # Scalar indices:
//     merged[indices[m], ...] = data[m][...]
//
//     # Vector indices:
//     merged[indices[m][i], ...] = data[m][i, ...]
// ```
//
// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
// `constant`, the output shape is
//
//     merged.shape = [max(indices)] + constant
//
// Values are merged in order, so if an index appears in both `indices[m][i]` and
// `indices[n][j]` for `(m,i) < (n,j)` the slice `data[n][j]` will appear in the
// merged result. If you do not need this guarantee, ParallelDynamicStitch might
// perform better on some devices.
//
// For example:
//
// ```python
//     indices[0] = 6
//     indices[1] = [4, 1]
//     indices[2] = [[5, 2], [0, 3]]
//     data[0] = [61, 62]
//     data[1] = [[41, 42], [11, 12]]
//     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
//     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
//               [51, 52], [61, 62]]
// ```
//
// This method can be used to merge partitions created by `dynamic_partition`
// as illustrated on the following example:
//
// ```python
//     # Apply function (increments x_i) on elements for which a certain condition
//     # apply (x_i != -1 in this example).
//     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
//     condition_mask=tf.not_equal(x,tf.constant(-1.))
//     partitioned_data = tf.dynamic_partition(
//         x, tf.cast(condition_mask, tf.int32) , 2)
//     partitioned_data[1] = partitioned_data[1] + 1.0
//     condition_indices = tf.dynamic_partition(
//         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
//     x = tf.dynamic_stitch(condition_indices, partitioned_data)
//     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
//     # unchanged.
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
// </div>
func DynamicStitch(scope *Scope, indices []tf.Output, data []tf.Output) (merged tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DynamicStitch",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(data),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Replaces the contents of the table with the specified keys and values.
//
// The tensor `keys` must be of the same type as the keys of the table.
// The tensor `values` must be of the type of the table values.
//
// Arguments:
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//	values: Values to associate with keys.
//
// Returns the created operation.
func LookupTableImportV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableImportV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Convert the quantized 'input' tensor into a lower-precision 'output', using the
//
// actual distribution of the values to maximize the usage of the lower bit depth
// and adjusting the output min and max ranges accordingly.
//
// [input_min, input_max] are scalar floats that specify the range for the float
// interpretation of the 'input' data. For example, if input_min is -1.0f and
// input_max is 1.0f, and we are dealing with quint16 quantized data, then a 0
// value in the 16-bit data should be interpreted as -1.0f, and a 65535 means 1.0f.
//
// This operator tries to squeeze as much precision as possible into an output with
// a lower bit depth by calculating the actual min and max values found in the
// data. For example, maybe that quint16 input has no values lower than 16,384 and
// none higher than 49,152. That means only half the range is actually needed, all
// the float interpretations are between -0.5f and 0.5f, so if we want to compress
// the data into a quint8 output, we can use that range rather than the theoretical
// -1.0f to 1.0f that is suggested by the input min and max.
//
// In practice, this is most useful for taking output from operations like
// QuantizedMatMul that can produce higher bit-depth outputs than their inputs and
// may have large potential output ranges, but in practice have a distribution of
// input values that only uses a small fraction of the possible range. By feeding
// that output into this operator, we can reduce it from 32 bits down to 8 with
// minimal loss of accuracy.
//
// Arguments:
//
//	input_min: The float value that the minimum quantized input value represents.
//	input_max: The float value that the maximum quantized input value represents.
//	out_type: The type of the output. Should be a lower bit depth than Tinput.
//
// Returns:
//	output
//	output_min: The float value that the minimum quantized output value represents.
//	output_max: The float value that the maximum quantized output value represents.
func QuantizeDownAndShrinkRange(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, out_type tf.DataType) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "QuantizeDownAndShrinkRange",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Tensor contraction according to Einstein summation convention.
//
// Implements generalized Tensor contraction and reduction. Each input Tensor must
// have a corresponding input subscript appearing in the comma-separated left-hand
// side of the equation. The right-hand side of the equation consists of the
// output subscript. The input subscripts and the output subscript should consist
// of zero or more named axis labels and at most one ellipsis (`...`).
//
// The named axis labels may be any single character other than those having
// special meaning, namely `,.->`. The behavior of this Op is undefined if it
// receives an ill-formatted equation; since the validation is done at
// graph-building time, we omit format validation checks at runtime.
//
// Note: This Op is *not* intended to be called by the user; instead users should
// call `tf.einsum` directly. It is a hidden Op used by `tf.einsum`.
//
// Operations are applied to the input(s) according to the following rules:
//
//  (a) Generalized Diagonals: For input dimensions corresponding to axis labels
//      appearing more than once in the same input subscript, we take the
//      generalized (`k`-dimensional) diagonal.
//      For example, in the equation `iii->i` with input shape `[3, 3, 3]`, the
//      generalized diagonal would consist of `3` elements at indices `(0, 0, 0)`,
//      `(1, 1, 1)` and `(2, 2, 2)` to create a Tensor of shape `[3]`.
//
//  (b) Reduction: Axes corresponding to labels appearing only in one input
//      subscript but not in the output subscript are summed over prior to Tensor
//      contraction.
//      For example, in the equation `ab,bc->b`, the axis labels `a` and `c` are
//      the reduction axis labels.
//
//  (c) Batch Dimensions: Axes corresponding to labels appearing in each of the
//      input subscripts and also in the output subscript make up the batch
//      dimensions in Tensor contraction. Unnamed axis labels corresponding to
//      ellipsis (`...`) also correspond to batch dimensions.
//      For example, for the equation denoting batch matrix multiplication,
//      `bij,bjk->bik`, the axis label `b` corresponds to a batch dimension.
//
//  (d) Contraction: In case of binary einsum, axes corresponding to labels
//      appearing in two different inputs (and not in the output) are contracted
//      against each other.
//      Considering the batch matrix multiplication equation again
//      (`bij,bjk->bik`), the contracted axis label is `j`.
//
//  (e) Expand Diagonal: If the output subscripts contain repeated (explicit) axis
//      labels, the opposite operation of (a) is applied. For example, in the
//      equation `i->iii`, and input shape `[3]`, the output of shape `[3, 3, 3]`
//      are all zeros, except for the (generalized) diagonal which is populated
//      with values from the input.
//      Note: This operation is not supported by `np.einsum` or `tf.einsum`; it is
//      provided to enable computing the symbolic gradient of `tf.einsum`.
//
// The output subscripts must contain only labels appearing in at least one of the
// input subscripts. Furthermore, all dimensions mapping to the same axis label
// must be equal.
//
// Any of the input and output subscripts may contain at most a single ellipsis
// (`...`). These ellipsis are mapped against dimensions not corresponding to any
// named axis label. If two inputs contain ellipsis, then they are broadcasted
// according to standard NumPy broadcasting
// [rules](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
// The broadcasted dimensions are placed in the corresponding location of the
// ellipsis in the output subscript. If the broadcasted dimensions are non-empty
// and the output subscripts do not contain ellipsis, then an InvalidArgument error
// is raised.
//
// @compatibility(numpy)
// Similar to [`numpy.einsum`](https://docs.scipy.org/doc/numpy/reference/generated/numpy.einsum.html).
//
// Comparison with `numpy.einsum`:
//
//  * This Op only supports unary and binary forms of `numpy.einsum`.
//  * This Op does not support implicit form. (i.e. equations without `->`).
//  * This Op also supports repeated indices in the output subscript, which is not
//    supported by `numpy.einsum`.
// @end_compatibility
//
//
// Arguments:
//	inputs: List of 1 or 2 Tensors.
//	equation: String describing the Einstein Summation operation; in the format of np.einsum.
//
// Returns Output Tensor with shape depending upon `equation`.
func Einsum(scope *Scope, inputs []tf.Output, equation string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"equation": equation}
	opspec := tf.OpSpec{
		Type: "Einsum",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs a tensor containing the reduction across all input tensors.
//
// Outputs a tensor containing the reduction across all input tensors passed to ops
// within the same `shared_name.
//
// The graph should be constructed so if one op runs with shared_name value `c`,
// then `num_devices` ops will run with shared_name value `c`.  Failure to do so
// will cause the graph execution to fail to complete.
//
// input: the input to the reduction
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
// num_devices: The number of devices participating in this reduction.
// shared_name: Identifier that shared between ops of the same reduction.
func NcclAllReduce(scope *Scope, input tf.Output, reduction string, num_devices int64, shared_name string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction, "num_devices": num_devices, "shared_name": shared_name}
	opspec := tf.OpSpec{
		Type: "NcclAllReduce",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MinAttr is an optional argument to Min.
type MinAttr func(optionalAttr)

// MinKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MinKeepDims(value bool) MinAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the minimum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Min(scope *Scope, input tf.Output, axis tf.Output, optional ...MinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Min",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Get the value of the tensor specified by its handle.
//
// Arguments:
//	handle: The handle for a tensor stored in the session state.
//	dtype: The type of the output value.
//
// Returns The tensor for the given handle.
func GetSessionTensor(scope *Scope, handle tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "GetSessionTensor",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseSequenceExampleAttr is an optional argument to ParseSequenceExample.
type ParseSequenceExampleAttr func(optionalAttr)

// ParseSequenceExampleNcontextSparse sets the optional Ncontext_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNcontextSparse(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Ncontext_sparse"] = value
	}
}

// ParseSequenceExampleNcontextDense sets the optional Ncontext_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNcontextDense(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Ncontext_dense"] = value
	}
}

// ParseSequenceExampleNfeatureListSparse sets the optional Nfeature_list_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNfeatureListSparse(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Nfeature_list_sparse"] = value
	}
}

// ParseSequenceExampleNfeatureListDense sets the optional Nfeature_list_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNfeatureListDense(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Nfeature_list_dense"] = value
	}
}

// ParseSequenceExampleContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleContextSparseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSequenceExampleFeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListDenseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSequenceExampleContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleContextDenseShapes(value []tf.Shape) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSequenceExampleFeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListSparseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSequenceExampleFeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListDenseShapes(value []tf.Shape) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a vector of brain.SequenceExample protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A vector containing binary serialized SequenceExample protos.
//	debug_name: A vector containing the names of the serialized protos.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no name is available.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
//	feature_list_dense_missing_assumed_empty: A vector listing the
// FeatureList keys which may be missing from the SequenceExamples.  If the
// associated FeatureList is missing, it is treated as empty.  By default,
// any FeatureList not listed in this vector must exist in the SequenceExamples.
//	context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
// The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' context features associated with
// dense values.
//	feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
// (scalars).  The keys expected in the FeatureLists associated with sparse
// values.
//	feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
func ParseSequenceExample(scope *Scope, serialized tf.Output, debug_name tf.Output, context_dense_defaults []tf.Output, feature_list_dense_missing_assumed_empty []string, context_sparse_keys []string, context_dense_keys []string, feature_list_sparse_keys []string, feature_list_dense_keys []string, optional ...ParseSequenceExampleAttr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output, feature_list_dense_lengths []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"feature_list_dense_missing_assumed_empty": feature_list_dense_missing_assumed_empty, "context_sparse_keys": context_sparse_keys, "context_dense_keys": context_dense_keys, "feature_list_sparse_keys": feature_list_sparse_keys, "feature_list_dense_keys": feature_list_dense_keys}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSequenceExample",
		Input: []tf.Input{
			serialized, debug_name, tf.OutputList(context_dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_dense_lengths, idx, err = makeOutputList(op, idx, "feature_list_dense_lengths"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values, feature_list_dense_lengths
}

// TPUPartitionedOutputAttr is an optional argument to TPUPartitionedOutput.
type TPUPartitionedOutputAttr func(optionalAttr)

// TPUPartitionedOutputPartitionDim sets the optional partition_dim attribute to value.
//
// value: An integer describles which dimension is partitioned.
// If not specified, defaults to 0
func TPUPartitionedOutputPartitionDim(value int64) TPUPartitionedOutputAttr {
	return func(m optionalAttr) {
		m["partition_dim"] = value
	}
}

// An op that demultiplexes a tensor to be sharded by XLA to a list of partitioned
//
// outputs outside the XLA computation.
//
// Arguments:
//	inputs: A tensor which represents the full shape of partitioned tensors.
//
//
// Returns A list of partitioned inputs which must have the same shape.
func TPUPartitionedOutput(scope *Scope, inputs tf.Output, num_splits int64, optional ...TPUPartitionedOutputAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_splits": num_splits}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TPUPartitionedOutput",
		Input: []tf.Input{
			inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("TPUPartitionedOutput", err)
		return
	}
	return output
}

// The shape of the elements of the given list, as a tensor.
//
//   input_handle: the list
//   element_shape: the shape of elements of the list
func TensorListElementShape(scope *Scope, input_handle tf.Output, shape_type tf.DataType) (element_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape_type": shape_type}
	opspec := tf.OpSpec{
		Type: "TensorListElementShape",
		Input: []tf.Input{
			input_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic sine of x element-wise.
//
//   Given an input tensor, this function computes hyperbolic sine of every
//   element in the tensor. Input range is `[-inf,inf]` and output range
//   is `[-inf,inf]`.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
//   tf.math.sinh(x) ==> [-inf -4.0515420e+03 -5.2109528e-01 1.1752012e+00 1.5094614e+00 3.6268604e+00 1.1013232e+04 inf]
//   ```
func Sinh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sinh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates and returns an empty tensor list.
//
// All list elements must be tensors of dtype element_dtype and shape compatible
// with element_shape.
//
// handle: an empty tensor list.
// element_dtype: the type of elements in the list.
// element_shape: a shape compatible with that of elements in the list.
func EmptyTensorList(scope *Scope, element_shape tf.Output, max_num_elements tf.Output, element_dtype tf.DataType) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "EmptyTensorList",
		Input: []tf.Input{
			element_shape, max_num_elements,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A transformation that asserts which transformations happen next.
//
// This transformation checks whether the camel-case names (i.e. "FlatMap", not
// "flat_map") of the transformations following this transformation match the list
// of names in the `transformations` argument. If there is a mismatch, the
// transformation raises an exception.
//
// The check occurs when iterating over the contents of the dataset, which
// means that the check happens *after* any static optimizations are applied
// to the dataset graph.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
// `AssertNextDataset` passes through the outputs of its input dataset.
//	transformations: A `tf.string` vector `tf.Tensor` identifying the transformations that are
// expected to happen next.
//
//
func AssertNextDataset(scope *Scope, input_dataset tf.Output, transformations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AssertNextDataset",
		Input: []tf.Input{
			input_dataset, transformations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeProtoAttr is an optional argument to EncodeProto.
type EncodeProtoAttr func(optionalAttr)

// EncodeProtoDescriptorSource sets the optional descriptor_source attribute to value.
// If not specified, defaults to "local://"
func EncodeProtoDescriptorSource(value string) EncodeProtoAttr {
	return func(m optionalAttr) {
		m["descriptor_source"] = value
	}
}

// The op serializes protobuf messages provided in the input tensors.
//
// The types of the tensors in `values` must match the schema for the fields
// specified in `field_names`. All the tensors in `values` must have a common
// shape prefix, *batch_shape*.
//
// The `sizes` tensor specifies repeat counts for each field.  The repeat count
// (last dimension) of a each tensor in `values` must be greater than or equal
// to corresponding repeat count in `sizes`.
//
// A `message_type` name must be provided to give context for the field names.
// The actual message descriptor can be looked up either in the linked-in
// descriptor pool or a filename provided by the caller using the
// `descriptor_source` attribute.
//
// For the most part, the mapping between Proto field types and TensorFlow dtypes
// is straightforward. However, there are a few special cases:
//
// - A proto field that contains a submessage or group can only be converted
// to `DT_STRING` (the serialized submessage). This is to reduce the complexity
// of the API. The resulting string can be used as input to another instance of
// the decode_proto op.
//
// - TensorFlow lacks support for unsigned integers. The ops represent uint64
// types as a `DT_INT64` with the same twos-complement bit pattern (the obvious
// way). Unsigned int32 values can be represented exactly by specifying type
// `DT_INT64`, or using twos-complement if the caller specifies `DT_INT32` in
// the `output_types` attribute.
//
// The `descriptor_source` attribute selects the source of protocol
// descriptors to consult when looking up `message_type`. This may be:
//
// - An empty string  or "local://", in which case protocol descriptors are
// created for C++ (not Python) proto definitions linked to the binary.
//
// - A file, in which case protocol descriptors are created from the file,
// which is expected to contain a `FileDescriptorSet` serialized as a string.
// NOTE: You can build a `descriptor_source` file using the `--descriptor_set_out`
// and `--include_imports` options to the protocol compiler `protoc`.
//
// - A "bytes://<bytes>", in which protocol descriptors are created from `<bytes>`,
// which is expected to be a `FileDescriptorSet` serialized as a string.
//
// Arguments:
//	sizes: Tensor of int32 with shape `[batch_shape, len(field_names)]`.
//	values: List of tensors containing values for the corresponding field.
//	field_names: List of strings containing proto field names.
//	message_type: Name of the proto message type to decode.
//
// Returns Tensor of serialized protos with shape `batch_shape`.
func EncodeProto(scope *Scope, sizes tf.Output, values []tf.Output, field_names []string, message_type string, optional ...EncodeProtoAttr) (bytes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"field_names": field_names, "message_type": message_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeProto",
		Input: []tf.Input{
			sizes, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseCountSparseOutputAttr is an optional argument to SparseCountSparseOutput.
type SparseCountSparseOutputAttr func(optionalAttr)

// SparseCountSparseOutputMinlength sets the optional minlength attribute to value.
//
// value: Minimum value to count. Can be set to -1 for no minimum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func SparseCountSparseOutputMinlength(value int64) SparseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["minlength"] = value
	}
}

// SparseCountSparseOutputMaxlength sets the optional maxlength attribute to value.
//
// value: Maximum value to count. Can be set to -1 for no maximum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func SparseCountSparseOutputMaxlength(value int64) SparseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["maxlength"] = value
	}
}

// Performs sparse-output bin counting for a sparse tensor input.
//
//   Counts the number of times each value occurs in the input.
//
// Arguments:
//	indices: Tensor containing the indices of the sparse tensor to count.
//	values: Tensor containing values of the sparse tensor to count.
//	dense_shape: Tensor containing the dense shape of the sparse tensor to count.
//	weights: A Tensor of the same shape as indices containing per-index weight values.
// May also be the empty tensor if no weights are used.
//	binary_output: Whether to output the number of occurrences of each value or 1.
//
// Returns:
//	output_indices: Indices tensor for the resulting sparse tensor object.
//	output_values: Values tensor for the resulting sparse tensor object.
//	output_dense_shape: Shape tensor for the resulting sparse tensor object.
func SparseCountSparseOutput(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output, weights tf.Output, binary_output bool, optional ...SparseCountSparseOutputAttr) (output_indices tf.Output, output_values tf.Output, output_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"binary_output": binary_output}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseCountSparseOutput",
		Input: []tf.Input{
			indices, values, dense_shape, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DebugNumericSummaryV2Attr is an optional argument to DebugNumericSummaryV2.
type DebugNumericSummaryV2Attr func(optionalAttr)

// DebugNumericSummaryV2OutputDtype sets the optional output_dtype attribute to value.
//
// value: Optional. The type of the output. Can be float32 or float64 (default: float32).
// If not specified, defaults to DT_FLOAT
func DebugNumericSummaryV2OutputDtype(value tf.DataType) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// DebugNumericSummaryV2TensorDebugMode sets the optional tensor_debug_mode attribute to value.
//
// value: Tensor debug mode: the mode in which the input tensor is summarized
//   by the op. See the TensorDebugMode enum in
//   tensorflow/core/protobuf/debug_event.proto for details.
//
// Supported values:
//   2 (CURT_HEALTH): Output a float32/64 tensor of shape [2]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element is a bit which is set to 1 if the input tensor has an
//   infinity or nan value, or zero otherwise.
//
//   3 (CONCISE_HEALTH): Output a float32/64 tensor of shape [5]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The
//   remaining four slots are the total number of elements, -infs,
//   +infs, and nans in the input tensor respectively.
//
//   4 (FULL_HEALTH): Output a float32/64 tensor of shape [11]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element is the device_id, if provided, and -1 otherwise. The 3rd
//   element holds the datatype value of the input tensor as according
//   to the enumerated type in tensorflow/core/framework/types.proto.
//   The remaining elements hold the total number of elements, -infs,
//   +infs, nans, negative finite numbers, zeros, and positive finite
//   numbers in the input tensor respectively.
//
//   5 (SHAPE): Output a float32/64 tensor of shape [10]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element holds the datatype value of the input tensor as according
//   to the enumerated type in tensorflow/core/framework/types.proto.
//   The 3rd element holds the rank of the tensor. The 4th element holds
//   the number of elements within the tensor. Finally the remaining 6
//   elements hold the shape of the tensor. If the rank of the tensor
//   is lower than 6, the shape is right padded with zeros. If the rank
//   is greater than 6, the head of the shape is truncated.
//
//   6 (FULL_NUMERICS): Output a float32/64 tensor of shape [22]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element is the device_id, if provided, and -1 otherwise. The 3rd
//   element holds the datatype value of the input tensor as according
//   to the enumerated type in tensorflow/core/framework/types.proto.
//   The 4th element holds the rank of the tensor. The 5th to 11th
//   elements hold the shape of the tensor. If the rank of the tensor
//   is lower than 6, the shape is right padded with zeros. If the rank
//   is greater than 6, the head of the shape is truncated. The 12th to
//   18th elements hold the number of elements, -infs, +infs, nans,
//   denormal floats, negative finite numbers, zeros, and positive
//   finite numbers in the input tensor respectively. The final four
//   elements hold the min value, max value, mean, and variance of the
//   input tensor.
//
//   8 (REDUCE_INF_NAN_THREE_SLOTS): Output a float32/64 tensor of shape
//   [3]. The 1st element is -inf if any elements of the input tensor
//   is -inf, or zero otherwise. The 2nd element is +inf if any elements
//   of the input tensor is +inf, or zero otherwise.  The 3rd element is
//   nan if any element of the input tensor is nan, or zero otherwise.
// If not specified, defaults to -1
func DebugNumericSummaryV2TensorDebugMode(value int64) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["tensor_debug_mode"] = value
	}
}

// DebugNumericSummaryV2TensorId sets the optional tensor_id attribute to value.
//
// value: Optional. An integer identifier for the tensor being summarized by this op.
// If not specified, defaults to -1
func DebugNumericSummaryV2TensorId(value int64) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["tensor_id"] = value
	}
}

// Debug Numeric Summary V2 Op.
//
// Computes a numeric summary of the input tensor. The shape of the output
// depends on the tensor_debug_mode attribute.
// This op is used internally by TensorFlow Debugger (tfdbg) v2.
//
// Arguments:
//	input: Input tensor, to be summarized by the op.
func DebugNumericSummaryV2(scope *Scope, input tf.Output, optional ...DebugNumericSummaryV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNumericSummaryV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QueueCloseV2Attr is an optional argument to QueueCloseV2.
type QueueCloseV2Attr func(optionalAttr)

// QueueCloseV2CancelPendingEnqueues sets the optional cancel_pending_enqueues attribute to value.
//
// value: If true, all pending enqueue requests that are
// blocked on the given queue will be canceled.
// If not specified, defaults to false
func QueueCloseV2CancelPendingEnqueues(value bool) QueueCloseV2Attr {
	return func(m optionalAttr) {
		m["cancel_pending_enqueues"] = value
	}
}

// Closes the given queue.
//
// This operation signals that no more elements will be enqueued in the
// given queue. Subsequent Enqueue(Many) operations will fail.
// Subsequent Dequeue(Many) operations will continue to succeed if
// sufficient elements remain in the queue. Subsequent Dequeue(Many)
// operations that would block will fail immediately.
//
// Arguments:
//	handle: The handle to a queue.
//
// Returns the created operation.
func QueueCloseV2(scope *Scope, handle tf.Output, optional ...QueueCloseV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueCloseV2",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// DebugIdentityV2Attr is an optional argument to DebugIdentityV2.
type DebugIdentityV2Attr func(optionalAttr)

// DebugIdentityV2TfdbgContextId sets the optional tfdbg_context_id attribute to value.
//
// value: A tfdbg-generated ID for the context that the op belongs to,
//   e.g., a concrete compiled tf.function.
// If not specified, defaults to ""
func DebugIdentityV2TfdbgContextId(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tfdbg_context_id"] = value
	}
}

// DebugIdentityV2OpName sets the optional op_name attribute to value.
//
// value: Optional. Name of the op that the debug op is concerned with.
//   Used only for single-tensor trace.
// If not specified, defaults to ""
func DebugIdentityV2OpName(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["op_name"] = value
	}
}

// DebugIdentityV2OutputSlot sets the optional output_slot attribute to value.
//
// value: Optional. Output slot index of the tensor that the debug op
//   is concerned with. Used only for single-tensor trace.
// If not specified, defaults to -1
func DebugIdentityV2OutputSlot(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["output_slot"] = value
	}
}

// DebugIdentityV2TensorDebugMode sets the optional tensor_debug_mode attribute to value.
//
// value: TensorDebugMode enum value. See debug_event.proto for details.
// If not specified, defaults to -1
func DebugIdentityV2TensorDebugMode(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tensor_debug_mode"] = value
	}
}

// DebugIdentityV2DebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g., file:///foo/tfdbg_dump.
// If not specified, defaults to <>
func DebugIdentityV2DebugUrls(value []string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityV2CircularBufferSize sets the optional circular_buffer_size attribute to value.
// If not specified, defaults to 1000
func DebugIdentityV2CircularBufferSize(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["circular_buffer_size"] = value
	}
}

// DebugIdentityV2TfdbgRunId sets the optional tfdbg_run_id attribute to value.
// If not specified, defaults to ""
func DebugIdentityV2TfdbgRunId(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tfdbg_run_id"] = value
	}
}

// Debug Identity V2 Op.
//
// Provides an identity mapping from input to output, while writing the content of
// the input tensor by calling DebugEventsWriter.
//
// The semantics of the input tensor depends on tensor_debug_mode. In typical
// usage, the input tensor comes directly from the user computation only when
// graph_debug_mode is FULL_TENSOR (see protobuf/debug_event.proto for a
// list of all the possible values of graph_debug_mode). For the other debug modes,
// the input tensor should be produced by an additional op or subgraph that
// computes summary information about one or more tensors.
//
// Arguments:
//	input: Input tensor, non-Reference type
func DebugIdentityV2(scope *Scope, input tf.Output, optional ...DebugIdentityV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentityV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs a `Summary` protocol buffer with a tensor and per-plugin data.
//
// Arguments:
//	tag: A string attached to this summary. Used for organization in TensorBoard.
//	tensor: A tensor to serialize.
//	serialized_summary_metadata: A serialized SummaryMetadata proto. Contains plugin
// data.
func TensorSummaryV2(scope *Scope, tag tf.Output, tensor tf.Output, serialized_summary_metadata tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorSummaryV2",
		Input: []tf.Input{
			tag, tensor, serialized_summary_metadata,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Scatters tensor at indices in an input list.
//
// Each member of the TensorList corresponds to one row of the input tensor,
// specified by the given index (see `tf.gather`).
//
// input_handle: The list to scatter into.
// tensor: The input tensor.
// indices: The indices used to index into the list.
// output_handle: The TensorList.
func TensorListScatterIntoExistingList(scope *Scope, input_handle tf.Output, tensor tf.Output, indices tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListScatterIntoExistingList",
		Input: []tf.Input{
			input_handle, tensor, indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugNanCountAttr is an optional argument to DebugNanCount.
type DebugNanCountAttr func(optionalAttr)

// DebugNanCountDeviceName sets the optional device_name attribute to value.
// If not specified, defaults to ""
func DebugNanCountDeviceName(value string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugNanCountTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugNanCountTensorName(value string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugNanCountDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//   file:///foo/tfdbg_dump, grpc:://localhost:11011.
// If not specified, defaults to <>
func DebugNanCountDebugUrls(value []string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugNanCountGatedGrpc sets the optional gated_grpc attribute to value.
//
// value:  Whether this op will be gated. If any of the debug_urls of this
//   debug node is of the grpc:// scheme, when the value of this attribute is set
//   to True, the data will not actually be sent via the grpc stream unless this
//   debug op has been enabled at the debug_url. If all of the debug_urls of this
//   debug node are of the grpc:// scheme and the debug op is enabled at none of
//   them, the output will be an empty Tensor.
// If not specified, defaults to false
func DebugNanCountGatedGrpc(value bool) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Debug NaN Value Counter Op.
//
// Counts number of NaNs in the input tensor, for debugging.
//
// Arguments:
//	input: Input tensor, non-Reference type.
func DebugNanCount(scope *Scope, input tf.Output, optional ...DebugNanCountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNanCount",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugIdentityAttr is an optional argument to DebugIdentity.
type DebugIdentityAttr func(optionalAttr)

// DebugIdentityDeviceName sets the optional device_name attribute to value.
//
// value: Name of the device on which the tensor resides.
// If not specified, defaults to ""
func DebugIdentityDeviceName(value string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugIdentityTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugIdentityTensorName(value string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugIdentityDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//   file:///foo/tfdbg_dump, grpc:://localhost:11011
// If not specified, defaults to <>
func DebugIdentityDebugUrls(value []string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityGatedGrpc sets the optional gated_grpc attribute to value.
//
// value: Whether this op will be gated. If any of the debug_urls of this
//   debug node is of the grpc:// scheme, when the value of this attribute is set
//   to True, the data will not actually be sent via the grpc stream unless this
//   debug op has been enabled at the debug_url. If all of the debug_urls of this
//   debug node are of the grpc:// scheme and the debug op is enabled at none of
//   them, the output will be an empty Tensor.
// If not specified, defaults to false
func DebugIdentityGatedGrpc(value bool) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Arguments:
//	input: Input tensor, non-Reference type
func DebugIdentity(scope *Scope, input tf.Output, optional ...DebugIdentityAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentity",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Sparse addition of two CSR matrices, C = alpha * A + beta * B.
//
// The gradients of SparseMatrixAdd outputs with respect to alpha and beta are not
// currently defined (TensorFlow will return zeros for these entries).
//
// Arguments:
//	a: A CSRSparseMatrix.
//	b: A CSRSparseMatrix.
//	alpha: A constant scalar.
//	beta: A constant scalar.
//
// Returns A CSRSparseMatrix.
func SparseMatrixAdd(scope *Scope, a tf.Output, b tf.Output, alpha tf.Output, beta tf.Output) (c tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseMatrixAdd",
		Input: []tf.Input{
			a, b, alpha, beta,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CopyHostAttr is an optional argument to CopyHost.
type CopyHostAttr func(optionalAttr)

// CopyHostTensorName sets the optional tensor_name attribute to value.
//
// value: The name of the input tensor.
// If not specified, defaults to ""
func CopyHostTensorName(value string) CopyHostAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// CopyHostDebugOpsSpec sets the optional debug_ops_spec attribute to value.
//
// value: A list of debug op spec (op, url, gated_grpc) for attached debug
// ops. Each element of the list has the format
// <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
// as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
// "DebugIdentity;file:///tmp/tfdbg_1;0".
// If not specified, defaults to <>
func CopyHostDebugOpsSpec(value []string) CopyHostAttr {
	return func(m optionalAttr) {
		m["debug_ops_spec"] = value
	}
}

// Copy a tensor to host.
//
// Performs CPU-to-CPU deep-copying of tensor.
// N.B.: If the all downstream attached debug ops are disabled given the current
// gRPC gating status, the output will simply forward the input tensor without
// deep-copying. See the documentation of Debug* ops for more details.
//
// Unlike the Copy Op, this op has HostMemory constraint on its input or output.
//
// Arguments:
//	input: Input tensor.
func CopyHost(scope *Scope, input tf.Output, optional ...CopyHostAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CopyHost",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates fingerprint values.
//
// Generates fingerprint values of `data`.
//
// Fingerprint op considers the first dimension of `data` as the batch dimension,
// and `output[i]` contains the fingerprint value generated from contents in
// `data[i, ...]` for all `i`.
//
// Fingerprint op writes fingerprint values as byte arrays. For example, the
// default method `farmhash64` generates a 64-bit fingerprint value at a time.
// This 8-byte value is written out as an `uint8` array of size 8, in little-endian
// order.
//
// For example, suppose that `data` has data type `DT_INT32` and shape (2, 3, 4),
// and that the fingerprint method is `farmhash64`. In this case, the output shape
// is (2, 8), where 2 is the batch dimension size of `data`, and 8 is the size of
// each fingerprint value in bytes. `output[0, :]` is generated from 12 integers in
// `data[0, :, :]` and similarly `output[1, :]` is generated from other 12 integers
// in `data[1, :, :]`.
//
// Note that this op fingerprints the raw underlying buffer, and it does not
// fingerprint Tensor's metadata such as data type and/or shape. For example, the
// fingerprint values are invariant under reshapes and bitcasts as long as the
// batch dimension remain the same:
//
// ```
// Fingerprint(data) == Fingerprint(Reshape(data, ...))
// Fingerprint(data) == Fingerprint(Bitcast(data, ...))
// ```
//
// For string data, one should expect `Fingerprint(data) !=
// Fingerprint(ReduceJoin(data))` in general.
//
// Arguments:
//	data: Must have rank 1 or higher.
//	method: Fingerprint method used by this op. Currently available method is
// `farmhash::fingerprint64`.
//
// Returns A two-dimensional `Tensor` of type `tf.uint8`. The first dimension equals to
// `data`'s first dimension, and the second dimension size depends on the
// fingerprint algorithm.
func Fingerprint(scope *Scope, data tf.Output, method tf.Output) (fingerprint tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fingerprint",
		Input: []tf.Input{
			data, method,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CopyAttr is an optional argument to Copy.
type CopyAttr func(optionalAttr)

// CopyTensorName sets the optional tensor_name attribute to value.
//
// value: The name of the input tensor.
// If not specified, defaults to ""
func CopyTensorName(value string) CopyAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// CopyDebugOpsSpec sets the optional debug_ops_spec attribute to value.
//
// value: A list of debug op spec (op, url, gated_grpc) for attached debug
// ops. Each element of the list has the format
// <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
// as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
// "DebugIdentity;file:///tmp/tfdbg_1;0".
// If not specified, defaults to <>
func CopyDebugOpsSpec(value []string) CopyAttr {
	return func(m optionalAttr) {
		m["debug_ops_spec"] = value
	}
}

// Copy a tensor from CPU-to-CPU or GPU-to-GPU.
//
// Performs CPU-to-CPU or GPU-to-GPU deep-copying of tensor, depending on the
// device on which the tensor is allocated.
// N.B.: If the all downstream attached debug ops are disabled given the current
// gRPC gating status, the output will simply forward the input tensor without
// deep-copying. See the documentation of Debug* ops for more details.
//
// Unlike the CopyHost Op, this op does not have HostMemory constraint on its
// input or output.
//
// Arguments:
//	input: Input tensor.
func Copy(scope *Scope, input tf.Output, optional ...CopyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Copy",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator.
//
// This operation is a synchronous version IteratorGetNext. It should only be used
// in situations where the iterator does not block the calling thread, or where
// the calling thread is not a member of the thread pool used to execute parallel
// operations (e.g. in eager mode).
func IteratorGetNextSync(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextSync",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNextSync", err)
		return
	}
	return components
}

// Creates a dataset by attaching tf.data.Options to `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	serialized_options: A `tf.string` scalar `tf.Tensor` of serialized `tf.data.Options` protocol buffer.
//
//
func OptionsDataset(scope *Scope, input_dataset tf.Output, serialized_options string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"serialized_options": serialized_options, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "OptionsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractJpegShapeAttr is an optional argument to ExtractJpegShape.
type ExtractJpegShapeAttr func(optionalAttr)

// ExtractJpegShapeOutputType sets the optional output_type attribute to value.
//
// value: (Optional) The output type of the operation (int32 or int64).
// Defaults to int32.
// If not specified, defaults to DT_INT32
func ExtractJpegShapeOutputType(value tf.DataType) ExtractJpegShapeAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Extract the shape information of a JPEG-encoded image.
//
// This op only parses the image header, so it is much faster than DecodeJpeg.
//
// Arguments:
//	contents: 0-D. The JPEG-encoded image.
//
// Returns 1-D. The image shape with format [height, width, channels].
func ExtractJpegShape(scope *Scope, contents tf.Output, optional ...ExtractJpegShapeAttr) (image_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractJpegShape",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorArray for storing the gradients of values in the given handle.
//
// If the given TensorArray gradient already exists, returns a reference to it.
//
// Locks the size of the original TensorArray by disabling its dynamic size flag.
//
// **A note about the input flow_in:**
//
// The handle flow_in forces the execution of the gradient lookup to occur
// only after certain other operations have occurred.  For example, when
// the forward TensorArray is dynamically sized, writes to this TensorArray
// may resize the object.  The gradient TensorArray is statically sized based
// on the size of the forward TensorArray when this operation executes.
// Furthermore, the size of the forward TensorArray is frozen by this call.
// As a result, the flow is used to ensure that the call to generate the gradient
// TensorArray only happens after all writes are executed.
//
// In the case of dynamically sized TensorArrays, gradient computation should
// only be performed on read operations that have themselves been chained via
// flow to occur only after all writes have executed. That way the final size
// of the forward TensorArray is known when this operation is called.
//
// **A note about the source attribute:**
//
// TensorArray gradient calls use an accumulator TensorArray object.  If
// multiple gradients are calculated and run in the same session, the multiple
// gradient nodes may accidentally flow through the same accumulator TensorArray.
// This double counts and generally breaks the TensorArray gradient flow.
//
// The solution is to identify which gradient call this particular
// TensorArray gradient is being called in.  This is performed by identifying
// a unique string (e.g. "gradients", "gradients_1", ...) from the input
// gradient Tensor's name.  This string is used as a suffix when creating
// the TensorArray gradient object here (the attribute `source`).
//
// The attribute `source` is added as a suffix to the forward TensorArray's
// name when performing the creation / lookup, so that each separate gradient
// calculation gets its own TensorArray accumulator.
//
// Arguments:
//	handle: The handle to the forward TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	source: The gradient source string, used to decide which gradient TensorArray
// to return.
func TensorArrayGradV3(scope *Scope, handle tf.Output, flow_in tf.Output, source string) (grad_handle tf.Output, flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradV3",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Produces a string handle for the given MultiDeviceIterator.
//
// Arguments:
//	multi_device_iterator: A MultiDeviceIterator resource.
//
// Returns A string representing the resource.
func MultiDeviceIteratorToStringHandle(scope *Scope, multi_device_iterator tf.Output) (string_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorToStringHandle",
		Input: []tf.Input{
			multi_device_iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizeAndDequantizeV4Attr is an optional argument to QuantizeAndDequantizeV4.
type QuantizeAndDequantizeV4Attr func(optionalAttr)

// QuantizeAndDequantizeV4SignedInput sets the optional signed_input attribute to value.
//
// value: Whether the quantization is signed or unsigned. (actually this parameter should
// have been called <b>`signed_output`</b>)
// If not specified, defaults to true
func QuantizeAndDequantizeV4SignedInput(value bool) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["signed_input"] = value
	}
}

// QuantizeAndDequantizeV4NumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization.
// If not specified, defaults to 8
func QuantizeAndDequantizeV4NumBits(value int64) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// QuantizeAndDequantizeV4RangeGiven sets the optional range_given attribute to value.
//
// value: Whether the range is given or should be determined from the `input` tensor.
// If not specified, defaults to false
func QuantizeAndDequantizeV4RangeGiven(value bool) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["range_given"] = value
	}
}

// QuantizeAndDequantizeV4RoundMode sets the optional round_mode attribute to value.
//
// value: The 'round_mode' attribute controls which rounding tie-breaking algorithm is
// used when rounding float values to their quantized equivalents. The following
// rounding modes are currently supported:
//
// *   HALF_TO_EVEN: this is the default round_mode.
// *   HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
//     rounds up to -7.
//
// If not specified, defaults to "HALF_TO_EVEN"
func QuantizeAndDequantizeV4RoundMode(value string) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["round_mode"] = value
	}
}

// QuantizeAndDequantizeV4NarrowRange sets the optional narrow_range attribute to value.
//
// value: If True, then the absolute value of the quantized minimum value is the same as
// the quantized maximum value, instead of 1 greater.
// i.e. for 8 bit quantization, the minimum value is -127 instead of -128.
// If not specified, defaults to false
func QuantizeAndDequantizeV4NarrowRange(value bool) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// QuantizeAndDequantizeV4Axis sets the optional axis attribute to value.
//
// value: If specified, this axis is treated as a channel or slice axis, and a separate
// quantization range is used for each channel or slice along this axis.
// If not specified, defaults to -1
func QuantizeAndDequantizeV4Axis(value int64) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Quantizes then dequantizes a tensor.
//
// This is almost identical to QuantizeAndDequantizeV2, except that it returns a
// gradient of 1 for inputs that are within the quantization range, or 0 otherwise.
//
// Arguments:
//	input: Tensor to quantize and then dequantize.
//	input_min: If `range_given == True`, this specifies the minimum input value that needs to
// be represented, otherwise it is determined from the min value of the `input`
// tensor.
//	input_max: If `range_given == True`, this specifies the maximum input value that needs to
// be represented, otherwise it is determined from the max value of the `input`
// tensor.
func QuantizeAndDequantizeV4(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, optional ...QuantizeAndDequantizeV4Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantizeV4",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets next element for the provided shard number.
//
// Arguments:
//	multi_device_iterator: A MultiDeviceIterator resource.
//	shard_num: Integer representing which shard to fetch data for.
//	incarnation_id: Which incarnation of the MultiDeviceIterator is running.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
//
// Returns Result of the get_next on the dataset.
func MultiDeviceIteratorGetNextFromShard(scope *Scope, multi_device_iterator tf.Output, shard_num tf.Output, incarnation_id tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorGetNextFromShard",
		Input: []tf.Input{
			multi_device_iterator, shard_num, incarnation_id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("MultiDeviceIteratorGetNextFromShard", err)
		return
	}
	return components
}

// BoostedTreesCalculateBestFeatureSplitAttr is an optional argument to BoostedTreesCalculateBestFeatureSplit.
type BoostedTreesCalculateBestFeatureSplitAttr func(optionalAttr)

// BoostedTreesCalculateBestFeatureSplitSplitType sets the optional split_type attribute to value.
//
// value: A string indicating if this Op should perform inequality split or equality split.
// If not specified, defaults to "inequality"
func BoostedTreesCalculateBestFeatureSplitSplitType(value string) BoostedTreesCalculateBestFeatureSplitAttr {
	return func(m optionalAttr) {
		m["split_type"] = value
	}
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary: A Rank 4 tensor (#shape=[max_splits, feature_dims, bucket, stats_dims]) for accumulated stats summary (gradient/hessian) per node, per dimension, per buckets for each feature.
// The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//	node_ids: A Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains: A Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	feature_dimensions: A Rank 1 tensors indicating the best feature dimension for each feature to split for certain nodes if the feature is multi-dimension. See above for details like shapes and sizes.
//	thresholds: A Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs: A Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs: A Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensors indicating the which direction to go if data is missing. See above for details like shapes and sizes.
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesCalculateBestFeatureSplit(scope *Scope, node_id_range tf.Output, stats_summary tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64, optional ...BoostedTreesCalculateBestFeatureSplitAttr) (node_ids tf.Output, gains tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestFeatureSplit",
		Input: []tf.Input{
			node_id_range, stats_summary, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Wraps the XLA DynamicUpdateSlice operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#dynamicupdateslice
// .
//
// XlaDynamicUpdateSlice generates a result which is the value of the `input`
// operand, with a slice update overwritten at `indices`. The shape of `update`
// determines the shape of the sub-array of the result which is updated. The shape
// of indices must be rank == 1, with dimension size equal to the rank of `input`.
//
// Handling of out-of-bounds slice indices is implementation-defined.
//
// Arguments:
//	input: A `Tensor` of type T.
//	update: A `Tensor` of type T. Same rank as `input`.
//	indices: A vector of indices into `input`. Must have length equal to the rank of
// `input`.
//
// Returns A `Tensor` of type T.
func XlaDynamicUpdateSlice(scope *Scope, input tf.Output, update tf.Output, indices tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaDynamicUpdateSlice",
		Input: []tf.Input{
			input, update, indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for SparseSegmentMean.
//
// Returns tensor "output" with same shape as grad, except for dimension 0 whose
// value is output_dim0.
//
// Arguments:
//	grad: gradient propagated to the SparseSegmentMean op.
//	indices: indices passed to the corresponding SparseSegmentMean op.
//	segment_ids: segment_ids passed to the corresponding SparseSegmentMean op.
//	output_dim0: dimension 0 of "data" passed to SparseSegmentMean op.
func SparseSegmentMeanGrad(scope *Scope, grad tf.Output, indices tf.Output, segment_ids tf.Output, output_dim0 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentMeanGrad",
		Input: []tf.Input{
			grad, indices, segment_ids, output_dim0,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SvdAttr is an optional argument to Svd.
type SvdAttr func(optionalAttr)

// SvdComputeUv sets the optional compute_uv attribute to value.
//
// value: If true, left and right singular vectors will be
// computed and returned in `u` and `v`, respectively.
// If false, `u` and `v` are not set and should never referenced.
// If not specified, defaults to true
func SvdComputeUv(value bool) SvdAttr {
	return func(m optionalAttr) {
		m["compute_uv"] = value
	}
}

// SvdFullMatrices sets the optional full_matrices attribute to value.
//
// value: If true, compute full-sized `u` and `v`. If false
// (the default), compute only the leading `P` singular vectors.
// Ignored if `compute_uv` is `False`.
// If not specified, defaults to false
func SvdFullMatrices(value bool) SvdAttr {
	return func(m optionalAttr) {
		m["full_matrices"] = value
	}
}

// Computes the singular value decompositions of one or more matrices.
//
// Computes the SVD of each inner matrix in `input` such that
// `input[..., :, :] = u[..., :, :] * diag(s[..., :, :]) * transpose(v[..., :, :])`
//
// ```python
// # a is a tensor containing a batch of matrices.
// # s is a tensor of singular values for each matrix.
// # u is the tensor containing the left singular vectors for each matrix.
// # v is the tensor containing the right singular vectors for each matrix.
// s, u, v = svd(a)
// s, _, _ = svd(a, compute_uv=False)
// ```
//
// Arguments:
//	input: A tensor of shape `[..., M, N]` whose inner-most 2 dimensions
// form matrices of size `[M, N]`. Let `P` be the minimum of `M` and `N`.
//
// Returns:
//	s: Singular values. Shape is `[..., P]`.
//	u: Left singular vectors. If `full_matrices` is `False` then shape is
// `[..., M, P]`; if `full_matrices` is `True` then shape is
// `[..., M, M]`. Undefined if `compute_uv` is `False`.
//	v: Left singular vectors. If `full_matrices` is `False` then shape is
// `[..., N, P]`. If `full_matrices` is `True` then shape is `[..., N, N]`.
// Undefined if `compute_uv` is false.
func Svd(scope *Scope, input tf.Output, optional ...SvdAttr) (s tf.Output, u tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Svd",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Determine the script codes of a given tensor of Unicode integer code points.
//
// This operation converts Unicode code points to script codes corresponding to
// each code point. Script codes correspond to International Components for
// Unicode (ICU) UScriptCode values.
//
// See
// [ICU project docs](http://icu-project.org/apiref/icu4c/uscript_8h.html)
// for more details on script codes.
//
// For an example, see the unicode strings guide on [unicode scripts]
// (https://www.tensorflow.org/tutorials/load_data/unicode#representing_unicode).
//
// Returns -1 (USCRIPT_INVALID_CODE) for invalid codepoints. Output shape will
// match input shape.
//
// Examples:
//
// >>> tf.strings.unicode_script([1, 31, 38])
// <tf.Tensor: shape=(3,), dtype=int32, numpy=array([0, 0, 0], dtype=int32)>
//
// Arguments:
//	input: A Tensor of int32 Unicode code points.
//
// Returns A Tensor of int32 script codes corresponding to each input code point.
func UnicodeScript(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnicodeScript",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the value stored in an Optional variant or raises an error if none exists.
func OptionalGetValue(scope *Scope, optional tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "OptionalGetValue",
		Input: []tf.Input{
			optional,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("OptionalGetValue", err)
		return
	}
	return components
}

// DecodeCSVAttr is an optional argument to DecodeCSV.
type DecodeCSVAttr func(optionalAttr)

// DecodeCSVFieldDelim sets the optional field_delim attribute to value.
//
// value: char delimiter to separate fields in a record.
// If not specified, defaults to ","
func DecodeCSVFieldDelim(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["field_delim"] = value
	}
}

// DecodeCSVUseQuoteDelim sets the optional use_quote_delim attribute to value.
//
// value: If false, treats double quotation marks as regular
// characters inside of the string fields (ignoring RFC 4180, Section 2,
// Bullet 5).
// If not specified, defaults to true
func DecodeCSVUseQuoteDelim(value bool) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["use_quote_delim"] = value
	}
}

// DecodeCSVNaValue sets the optional na_value attribute to value.
//
// value: Additional string to recognize as NA/NaN.
// If not specified, defaults to ""
func DecodeCSVNaValue(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["na_value"] = value
	}
}

// DecodeCSVSelectCols sets the optional select_cols attribute to value.
// If not specified, defaults to <>
func DecodeCSVSelectCols(value []int64) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["select_cols"] = value
	}
}

// Convert CSV records to tensors. Each column maps to one tensor.
//
// RFC 4180 format is expected for the CSV records.
// (https://tools.ietf.org/html/rfc4180)
// Note that we allow leading and trailing spaces with int or float field.
//
// Arguments:
//	records: Each string is a record/row in the csv and all records should have
// the same format.
//	record_defaults: One tensor per column of the input record, with either a
// scalar default value for that column or an empty vector if the column is
// required.
//
// Returns Each tensor will have the same shape as records.
func DecodeCSV(scope *Scope, records tf.Output, record_defaults []tf.Output, optional ...DecodeCSVAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCSV",
		Input: []tf.Input{
			records, tf.OutputList(record_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("DecodeCSV", err)
		return
	}
	return output
}

// An op used by XLA SPMD partitioner to switch from automatic partitioning to
//
// manual partitioning. It annotates the input (full-shape, to be automatically
// partitioned) with the same sharding used by manual partitioning, and outputs a
// shard-shaped tensor to be consumed by later manually-partitioned ops. If the
// shape is not evenly partitionable, the padding region will be masked with 0s.
func XlaSpmdFullToShardShape(scope *Scope, input tf.Output, manual_sharding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"manual_sharding": manual_sharding}
	opspec := tf.OpSpec{
		Type: "XlaSpmdFullToShardShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr is an optional argument to RetrieveTPUEmbeddingStochasticGradientDescentParameters.
type RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingStochasticGradientDescentParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingStochasticGradientDescentParametersTableId(value int64) RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingStochasticGradientDescentParametersTableName(value string) RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingStochasticGradientDescentParametersConfig(value string) RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve SGD embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the stochastic gradient descent optimization algorithm.
func RetrieveTPUEmbeddingStochasticGradientDescentParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr) (parameters tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingStochasticGradientDescentParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates an Optional variant with no value.
func OptionalNone(scope *Scope) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalNone",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Retrieve multiple values from the computation outfeed. Device ordinal is a
// tensor allowing dynamic outfeed.
//
// This operation will block indefinitely until data is available. Output `i`
// corresponds to XLA tuple element `i`.
//
// Arguments:
//	device_ordinal: An int scalar tensor, representing the TPU device to use. This should be -1 when
// the Op is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
//	dtypes: The element types of each element in `outputs`.
//	shapes: The shapes of each tensor in `outputs`.
//
// Returns A list of tensors that will be read from the outfeed.
func OutfeedDequeueTupleV2(scope *Scope, device_ordinal tf.Output, dtypes []tf.DataType, shapes []tf.Shape) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes, "shapes": shapes}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeueTupleV2",
		Input: []tf.Input{
			device_ordinal,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("OutfeedDequeueTupleV2", err)
		return
	}
	return outputs
}

// QrAttr is an optional argument to Qr.
type QrAttr func(optionalAttr)

// QrFullMatrices sets the optional full_matrices attribute to value.
//
// value: If true, compute full-sized `q` and `r`. If false
// (the default), compute only the leading `P` columns of `q`.
// If not specified, defaults to false
func QrFullMatrices(value bool) QrAttr {
	return func(m optionalAttr) {
		m["full_matrices"] = value
	}
}

// Computes the QR decompositions of one or more matrices.
//
// Computes the QR decomposition of each inner matrix in `tensor` such that
// `tensor[..., :, :] = q[..., :, :] * r[..., :,:])`
//
// Currently, the gradient for the QR decomposition is well-defined only when
// the first `P` columns of the inner matrix are linearly independent, where
// `P` is the minimum of `M` and `N`, the 2 inner-most dimmensions of `tensor`.
//
// ```python
// # a is a tensor.
// # q is a tensor of orthonormal matrices.
// # r is a tensor of upper triangular matrices.
// q, r = qr(a)
// q_full, r_full = qr(a, full_matrices=True)
// ```
//
// Arguments:
//	input: A tensor of shape `[..., M, N]` whose inner-most 2 dimensions
// form matrices of size `[M, N]`. Let `P` be the minimum of `M` and `N`.
//
// Returns:
//	q: Orthonormal basis for range of `a`. If `full_matrices` is `False` then
// shape is `[..., M, P]`; if `full_matrices` is `True` then shape is
// `[..., M, M]`.
//	r: Triangular factor. If `full_matrices` is `False` then shape is
// `[..., P, N]`. If `full_matrices` is `True` then shape is `[..., M, N]`.
func Qr(scope *Scope, input tf.Output, optional ...QrAttr) (q tf.Output, r tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Qr",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Constructs an Optional variant from a tuple of tensors.
func OptionalFromValue(scope *Scope, components []tf.Output) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalFromValue",
		Input: []tf.Input{
			tf.OutputList(components),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptimizeDatasetV2Attr is an optional argument to OptimizeDatasetV2.
type OptimizeDatasetV2Attr func(optionalAttr)

// OptimizeDatasetV2OptimizationConfigs sets the optional optimization_configs attribute to value.
// If not specified, defaults to <>
func OptimizeDatasetV2OptimizationConfigs(value []string) OptimizeDatasetV2Attr {
	return func(m optionalAttr) {
		m["optimization_configs"] = value
	}
}

// Creates a dataset by applying related optimizations to `input_dataset`.
//
// Creates a dataset by applying related optimizations to `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	optimizations_enabled: A `tf.string` vector `tf.Tensor` identifying user enabled optimizations.
//	optimizations_disabled: A `tf.string` vector `tf.Tensor` identifying user disabled optimizations.
//	optimizations_default: A `tf.string` vector `tf.Tensor` identifying optimizations by default.
//
//
func OptimizeDatasetV2(scope *Scope, input_dataset tf.Output, optimizations_enabled tf.Output, optimizations_disabled tf.Output, optimizations_default tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptimizeDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptimizeDatasetV2",
		Input: []tf.Input{
			input_dataset, optimizations_enabled, optimizations_disabled, optimizations_default,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptimizeDatasetAttr is an optional argument to OptimizeDataset.
type OptimizeDatasetAttr func(optionalAttr)

// OptimizeDatasetOptimizationConfigs sets the optional optimization_configs attribute to value.
// If not specified, defaults to <>
func OptimizeDatasetOptimizationConfigs(value []string) OptimizeDatasetAttr {
	return func(m optionalAttr) {
		m["optimization_configs"] = value
	}
}

// Creates a dataset by applying optimizations to `input_dataset`.
//
// Creates a dataset by applying optimizations to `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	optimizations: A `tf.string` vector `tf.Tensor` identifying optimizations to use.
//
//
func OptimizeDataset(scope *Scope, input_dataset tf.Output, optimizations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptimizeDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptimizeDataset",
		Input: []tf.Input{
			input_dataset, optimizations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Restores tensors from a V2 checkpoint.
//
// For backward compatibility with the V1 format, this Op currently allows
// restoring from a V1 checkpoint as well:
//   - This Op first attempts to find the V2 index file pointed to by "prefix", and
//     if found proceed to read it as a V2 checkpoint;
//   - Otherwise the V1 read path is invoked.
// Relying on this behavior is not recommended, as the ability to fall back to read
// V1 might be deprecated and eventually removed.
//
// By default, restores the named tensors in full.  If the caller wishes to restore
// specific slices of stored tensors, "shape_and_slices" should be non-empty
// strings and correspondingly well-formed.
//
// Callers must ensure all the named tensors are indeed stored in the checkpoint.
//
// Arguments:
//	prefix: Must have a single element.  The prefix of a V2 checkpoint.
//	tensor_names: shape {N}.  The names of the tensors to be restored.
//	shape_and_slices: shape {N}.  The slice specs of the tensors to be restored.
// Empty strings indicate that they are non-partitioned tensors.
//	dtypes: shape {N}.  The list of expected dtype for the tensors.  Must match
// those stored in the checkpoint.
//
// Returns shape {N}.  The restored tensors, whose shapes are read from the
// checkpoint directly.
func RestoreV2(scope *Scope, prefix tf.Output, tensor_names tf.Output, shape_and_slices tf.Output, dtypes []tf.DataType) (tensors []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	opspec := tf.OpSpec{
		Type: "RestoreV2",
		Input: []tf.Input{
			prefix, tensor_names, shape_and_slices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if tensors, idx, err = makeOutputList(op, idx, "tensors"); err != nil {
		scope.UpdateErr("RestoreV2", err)
		return
	}
	return tensors
}

// DatasetToGraphV2Attr is an optional argument to DatasetToGraphV2.
type DatasetToGraphV2Attr func(optionalAttr)

// DatasetToGraphV2ExternalStatePolicy sets the optional external_state_policy attribute to value.
// If not specified, defaults to 0
func DatasetToGraphV2ExternalStatePolicy(value int64) DatasetToGraphV2Attr {
	return func(m optionalAttr) {
		m["external_state_policy"] = value
	}
}

// DatasetToGraphV2StripDeviceAssignment sets the optional strip_device_assignment attribute to value.
// If not specified, defaults to false
func DatasetToGraphV2StripDeviceAssignment(value bool) DatasetToGraphV2Attr {
	return func(m optionalAttr) {
		m["strip_device_assignment"] = value
	}
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraphV2(scope *Scope, input_dataset tf.Output, optional ...DatasetToGraphV2Attr) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraphV2",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DatasetToGraphAttr is an optional argument to DatasetToGraph.
type DatasetToGraphAttr func(optionalAttr)

// DatasetToGraphStatefulWhitelist sets the optional stateful_whitelist attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func DatasetToGraphStatefulWhitelist(value []string) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["stateful_whitelist"] = value
	}
}

// DatasetToGraphAllowStateful sets the optional allow_stateful attribute to value.
// If not specified, defaults to false
func DatasetToGraphAllowStateful(value bool) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["allow_stateful"] = value
	}
}

// DatasetToGraphStripDeviceAssignment sets the optional strip_device_assignment attribute to value.
// If not specified, defaults to false
func DatasetToGraphStripDeviceAssignment(value bool) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["strip_device_assignment"] = value
	}
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraph(scope *Scope, input_dataset tf.Output, optional ...DatasetToGraphAttr) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraph",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractGlimpseAttr is an optional argument to ExtractGlimpse.
type ExtractGlimpseAttr func(optionalAttr)

// ExtractGlimpseCentered sets the optional centered attribute to value.
//
// value: indicates if the offset coordinates are centered relative to
// the image, in which case the (0, 0) offset is relative to the center
// of the input images. If false, the (0,0) offset corresponds to the
// upper left corner of the input images.
// If not specified, defaults to true
func ExtractGlimpseCentered(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["centered"] = value
	}
}

// ExtractGlimpseNormalized sets the optional normalized attribute to value.
//
// value: indicates if the offset coordinates are normalized.
// If not specified, defaults to true
func ExtractGlimpseNormalized(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["normalized"] = value
	}
}

// ExtractGlimpseUniformNoise sets the optional uniform_noise attribute to value.
//
// value: indicates if the noise should be generated using a
// uniform distribution or a Gaussian distribution.
// If not specified, defaults to true
func ExtractGlimpseUniformNoise(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["uniform_noise"] = value
	}
}

// ExtractGlimpseNoise sets the optional noise attribute to value.
//
// value: indicates if the noise should `uniform`, `gaussian`, or
// `zero`. The default is `uniform` which means the noise type
// will be decided by `uniform_noise`.
// If not specified, defaults to "uniform"
func ExtractGlimpseNoise(value string) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["noise"] = value
	}
}

// Extracts a glimpse from the input tensor.
//
// Returns a set of windows called glimpses extracted at location
// `offsets` from the input tensor. If the windows only partially
// overlaps the inputs, the non overlapping areas will be filled with
// random noise.
//
// The result is a 4-D tensor of shape `[batch_size, glimpse_height,
// glimpse_width, channels]`. The channels and batch dimensions are the
// same as that of the input tensor. The height and width of the output
// windows are specified in the `size` parameter.
//
// The argument `normalized` and `centered` controls how the windows are built:
//
// * If the coordinates are normalized but not centered, 0.0 and 1.0
//   correspond to the minimum and maximum of each height and width
//   dimension.
// * If the coordinates are both normalized and centered, they range from
//   -1.0 to 1.0. The coordinates (-1.0, -1.0) correspond to the upper
//   left corner, the lower right corner is located at (1.0, 1.0) and the
//   center is at (0, 0).
// * If the coordinates are not normalized they are interpreted as
//   numbers of pixels.
//
// Arguments:
//	input: A 4-D float tensor of shape `[batch_size, height, width, channels]`.
//	size: A 1-D tensor of 2 elements containing the size of the glimpses
// to extract.  The glimpse height must be specified first, following
// by the glimpse width.
//	offsets: A 2-D integer tensor of shape `[batch_size, 2]` containing
// the y, x locations of the center of each window.
//
// Returns A tensor representing the glimpses `[batch_size,
// glimpse_height, glimpse_width, channels]`.
func ExtractGlimpse(scope *Scope, input tf.Output, size tf.Output, offsets tf.Output, optional ...ExtractGlimpseAttr) (glimpse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractGlimpse",
		Input: []tf.Input{
			input, size, offsets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes the given dataset to the given file using the TFRecord format.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to write.
//	filename: A scalar string tensor representing the filename to use.
//	compression_type: A scalar string tensor containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//
// Returns the created operation.
func ExperimentalDatasetToTFRecord(scope *Scope, input_dataset tf.Output, filename tf.Output, compression_type tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalDatasetToTFRecord",
		Input: []tf.Input{
			input_dataset, filename, compression_type,
		},
	}
	return scope.AddOperation(opspec)
}

// GenerateVocabRemappingAttr is an optional argument to GenerateVocabRemapping.
type GenerateVocabRemappingAttr func(optionalAttr)

// GenerateVocabRemappingOldVocabSize sets the optional old_vocab_size attribute to value.
//
// value: Number of entries in the old vocab file to consider.  If -1,
// use the entire old vocabulary.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func GenerateVocabRemappingOldVocabSize(value int64) GenerateVocabRemappingAttr {
	return func(m optionalAttr) {
		m["old_vocab_size"] = value
	}
}

// Given a path to new and old vocabulary files, returns a remapping Tensor of
//
// length `num_new_vocab`, where `remapping[i]` contains the row number in the old
// vocabulary that corresponds to row `i` in the new vocabulary (starting at line
// `new_vocab_offset` and up to `num_new_vocab` entities), or `-1` if entry `i`
// in the new vocabulary is not in the old vocabulary.  The old vocabulary is
// constrained to the first `old_vocab_size` entries if `old_vocab_size` is not the
// default value of -1.
//
// `num_vocab_offset` enables
// use in the partitioned variable case, and should generally be set through
// examining partitioning info.  The format of the files should be a text file,
// with each line containing a single entity within the vocabulary.
//
// For example, with `new_vocab_file` a text file containing each of the following
// elements on a single line: `[f0, f1, f2, f3]`, old_vocab_file = [f1, f0, f3],
// `num_new_vocab = 3, new_vocab_offset = 1`, the returned remapping would be
// `[0, -1, 2]`.
//
// The op also returns a count of how many entries in the new vocabulary
// were present in the old vocabulary, which is used to calculate the number of
// values to initialize in a weight matrix remapping
//
// This functionality can be used to remap both row vocabularies (typically,
// features) and column vocabularies (typically, classes) from TensorFlow
// checkpoints.  Note that the partitioning logic relies on contiguous vocabularies
// corresponding to div-partitioned variables.  Moreover, the underlying remapping
// uses an IndexTable (as opposed to an inexact CuckooTable), so client code should
// use the corresponding index_table_from_file() as the FeatureColumn framework
// does (as opposed to tf.feature_to_id(), which uses a CuckooTable).
//
// Arguments:
//	new_vocab_file: Path to the new vocab file.
//	old_vocab_file: Path to the old vocab file.
//	new_vocab_offset: How many entries into the new vocab file to start reading.
//	num_new_vocab: Number of entries in the new vocab file to remap.
//
// Returns:
//	remapping: A Tensor of length num_new_vocab where the element at index i
// is equal to the old ID that maps to the new ID i.  This element is -1 for any
// new ID that is not found in the old vocabulary.
//	num_present: Number of new vocab entries found in old vocab.
func GenerateVocabRemapping(scope *Scope, new_vocab_file tf.Output, old_vocab_file tf.Output, new_vocab_offset int64, num_new_vocab int64, optional ...GenerateVocabRemappingAttr) (remapping tf.Output, num_present tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"new_vocab_offset": new_vocab_offset, "num_new_vocab": num_new_vocab}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GenerateVocabRemapping",
		Input: []tf.Input{
			new_vocab_file, old_vocab_file,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. Prefer `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	beta: A 1D beta Tensor with size matching the last dimension of t.
// An offset to be added to the normalized tensor.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this tensor will be multiplied
// with the normalized tensor.
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
func BatchNormWithGlobalNormalization(scope *Scope, t tf.Output, m tf.Output, v tf.Output, beta tf.Output, gamma tf.Output, variance_epsilon float32, scale_after_normalization bool) (result tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalization",
		Input: []tf.Input{
			t, m, v, beta, gamma,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxArgsAttr is an optional argument to FakeQuantWithMinMaxArgs.
type FakeQuantWithMinMaxArgsAttr func(optionalAttr)

// FakeQuantWithMinMaxArgsMin sets the optional min attribute to value.
// If not specified, defaults to -6
func FakeQuantWithMinMaxArgsMin(value float32) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["min"] = value
	}
}

// FakeQuantWithMinMaxArgsMax sets the optional max attribute to value.
// If not specified, defaults to 6
func FakeQuantWithMinMaxArgsMax(value float32) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["max"] = value
	}
}

// FakeQuantWithMinMaxArgsNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxArgsNumBits(value int64) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxArgsNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxArgsNarrowRange(value bool) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor, type float to 'outputs' tensor of same type.
//
// Attributes
//
// *   `[min; max]` define the clamping range for the `inputs` data.
// *   `inputs` values are quantized into the quantization range (
// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
// when it is true) and then de-quantized and output as floats in `[min; max]`
// interval.
// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
//
// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// Quantization is called fake since the output is still in floating point.
func FakeQuantWithMinMaxArgs(scope *Scope, inputs tf.Output, optional ...FakeQuantWithMinMaxArgsAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxArgs",
		Input: []tf.Input{
			inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the static batch size of a dataset sans partial batches.
func ComputeBatchSize(scope *Scope, input_dataset tf.Output) (batch_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ComputeBatchSize",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RaggedCountSparseOutputAttr is an optional argument to RaggedCountSparseOutput.
type RaggedCountSparseOutputAttr func(optionalAttr)

// RaggedCountSparseOutputMinlength sets the optional minlength attribute to value.
//
// value: Minimum value to count. Can be set to -1 for no minimum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RaggedCountSparseOutputMinlength(value int64) RaggedCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["minlength"] = value
	}
}

// RaggedCountSparseOutputMaxlength sets the optional maxlength attribute to value.
//
// value: Maximum value to count. Can be set to -1 for no maximum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RaggedCountSparseOutputMaxlength(value int64) RaggedCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["maxlength"] = value
	}
}

// Performs sparse-output bin counting for a ragged tensor input.
//
//   Counts the number of times each value occurs in the input.
//
// Arguments:
//	splits: Tensor containing the row splits of the ragged tensor to count.
//	values: Tensor containing values of the sparse tensor to count.
//	weights: A Tensor of the same shape as indices containing per-index weight values.
// May also be the empty tensor if no weights are used.
//	binary_output: Whether to output the number of occurrences of each value or 1.
//
// Returns:
//	output_indices: Indices tensor for the resulting sparse tensor object.
//	output_values: Values tensor for the resulting sparse tensor object.
//	output_dense_shape: Shape tensor for the resulting sparse tensor object.
//   END
//   }
//   attr {
//     name: "T"
//     description: <<END
// Dtype of the input values tensor.
func RaggedCountSparseOutput(scope *Scope, splits tf.Output, values tf.Output, weights tf.Output, binary_output bool, optional ...RaggedCountSparseOutputAttr) (output_indices tf.Output, output_values tf.Output, output_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"binary_output": binary_output}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedCountSparseOutput",
		Input: []tf.Input{
			splits, values, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Gets the next output from the given iterator .
func IteratorGetNext(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNext",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNext", err)
		return
	}
	return components
}

// Computes inverse hyperbolic tangent of x element-wise.
//
//   Given an input tensor, this function computes inverse hyperbolic tangent
//   for every element in the tensor. Input range is `[-1,1]` and output range is
//   `[-inf, inf]`. If input is `-1`, output will be `-inf` and if the
//   input is `1`, output will be `inf`. Values outside the range will have
//   `nan` as output.
//
//   ```python
//   x = tf.constant([-float("inf"), -1, -0.5, 1, 0, 0.5, 10, float("inf")])
//   tf.math.atanh(x) ==> [nan -inf -0.54930615 inf  0. 0.54930615 nan nan]
//   ```
func Atanh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atanh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormAttr is an optional argument to FusedBatchNorm.
type FusedBatchNormAttr func(optionalAttr)

// FusedBatchNormEpsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormEpsilon(value float32) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormExponentialAvgFactor(value float32) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormDataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormDataFormat(value string) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormIsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormIsTraining(value bool) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns:
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNorm(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormAttr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNorm",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// SparseMatMulAttr is an optional argument to SparseMatMul.
type SparseMatMulAttr func(optionalAttr)

// SparseMatMulTransposeA sets the optional transpose_a attribute to value.
// If not specified, defaults to false
func SparseMatMulTransposeA(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// SparseMatMulTransposeB sets the optional transpose_b attribute to value.
// If not specified, defaults to false
func SparseMatMulTransposeB(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// SparseMatMulAIsSparse sets the optional a_is_sparse attribute to value.
// If not specified, defaults to false
func SparseMatMulAIsSparse(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["a_is_sparse"] = value
	}
}

// SparseMatMulBIsSparse sets the optional b_is_sparse attribute to value.
// If not specified, defaults to false
func SparseMatMulBIsSparse(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["b_is_sparse"] = value
	}
}

// Multiply matrix "a" by matrix "b".
//
// The inputs must be two-dimensional matrices and the inner dimension of "a" must
// match the outer dimension of "b". Both "a" and "b" must be `Tensor`s not
// `SparseTensor`s.  This op is optimized for the case where at least one of "a" or
// "b" is sparse, in the sense that they have a large proportion of zero values.
// The breakeven for using this versus a dense matrix multiply on one platform was
// 30% zero values in the sparse matrix.
//
// The gradient computation of this operation will only take advantage of sparsity
// in the input gradient when that gradient comes from a Relu.
func SparseMatMul(scope *Scope, a tf.Output, b tf.Output, optional ...SparseMatMulAttr) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseMatMul",
		Input: []tf.Input{
			a, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Resizes the list.
//
//
// input_handle: the input list
// size: size of the output list
//
func TensorListResize(scope *Scope, input_handle tf.Output, size tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListResize",
		Input: []tf.Input{
			input_handle, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes a new iterator from the given `dataset` and stores it in `iterator`.
//
// This operation may be executed multiple times. Each execution will reset the
// iterator in `iterator` to the first element of `dataset`.
//
// Returns the created operation.
func MakeIterator(scope *Scope, dataset tf.Output, iterator tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MakeIterator",
		Input: []tf.Input{
			dataset, iterator,
		},
	}
	return scope.AddOperation(opspec)
}

// IgnoreErrorsDatasetAttr is an optional argument to IgnoreErrorsDataset.
type IgnoreErrorsDatasetAttr func(optionalAttr)

// IgnoreErrorsDatasetLogWarning sets the optional log_warning attribute to value.
// If not specified, defaults to false
func IgnoreErrorsDatasetLogWarning(value bool) IgnoreErrorsDatasetAttr {
	return func(m optionalAttr) {
		m["log_warning"] = value
	}
}

// Creates a dataset that contains the elements of `input_dataset` ignoring errors.
func IgnoreErrorsDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...IgnoreErrorsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IgnoreErrorsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Arguments:
//	multi_device_iterator: A handle to the multi device iterator to delete.
//	iterators: A list of iterator handles (unused). This is added so that automatic control dependencies get added during function tracing that ensure this op runs after all the dependent iterators are deleted.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteMultiDeviceIterator(scope *Scope, multi_device_iterator tf.Output, iterators []tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteMultiDeviceIterator",
		Input: []tf.Input{
			multi_device_iterator, tf.OutputList(iterators), deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// A container for an iterator resource.
//
// Arguments:
//	handle: A handle to the iterator to delete.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteIterator(scope *Scope, handle tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteIterator",
		Input: []tf.Input{
			handle, deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the gradient for the sqrt of `x` wrt its input.
//
// Specifically, `grad = dy * 0.5 / y`, where `y = sqrt(x)`, and `dy`
// is the corresponding input gradient.
func SqrtGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SqrtGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Splits a tensor into `num_split` tensors along one dimension.
//
// Arguments:
//	value: The tensor to split.
//	size_splits: list containing the sizes of each output tensor along the split
// dimension. Must sum to the dimension of value along split_dim.
// Can contain one -1 indicating that dimension is to be inferred.
//	axis: 0-D.  The dimension along which to split.  Must be in the range
// `[-rank(value), rank(value))`.
//
//
// Returns Tensors whose shape matches that of `value`
// except along `axis`, where their sizes are
// `size_splits[i]`.
func SplitV(scope *Scope, value tf.Output, size_splits tf.Output, axis tf.Output, num_split int64) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_split": num_split}
	opspec := tf.OpSpec{
		Type: "SplitV",
		Input: []tf.Input{
			value, size_splits, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("SplitV", err)
		return
	}
	return output
}

// A container for an iterator resource.
//
// Returns:
//	handle: A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
//	deleter: A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousIteratorV2(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIteratorV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Creates a dataset that emits the lines of one or more text files.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the file(s) to be
// read.
//	compression_type: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//	buffer_size: A scalar containing the number of bytes to buffer.
func TextLineDataset(scope *Scope, filenames tf.Output, compression_type tf.Output, buffer_size tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TextLineDataset",
		Input: []tf.Input{
			filenames, compression_type, buffer_size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthwiseConv2dNativeBackpropFilterAttr is an optional argument to DepthwiseConv2dNativeBackpropFilter.
type DepthwiseConv2dNativeBackpropFilterAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropFilterExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to <>
func DepthwiseConv2dNativeBackpropFilterExplicitPaddings(value []int64) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropFilterDataFormat(value string) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func DepthwiseConv2dNativeBackpropFilterDilations(value []int64) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the filter.
//
// Arguments:
//	input: 4-D with shape based on `data_format`.  For example, if
// `data_format` is 'NHWC' then `input` is a 4-D `[batch, in_height,
// in_width, in_channels]` tensor.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, depthwise_multiplier]` tensor.
//	out_backprop: 4-D with shape  based on `data_format`.
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func DepthwiseConv2dNativeBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeAttr is an optional argument to CropAndResize.
type CropAndResizeAttr func(optionalAttr)

// CropAndResizeMethod sets the optional method attribute to value.
//
// value: A string specifying the sampling method for resizing. It can be either
// `"bilinear"` or `"nearest"` and default to `"bilinear"`. Currently two sampling
// methods are supported: Bilinear and Nearest Neighbor.
// If not specified, defaults to "bilinear"
func CropAndResizeMethod(value string) CropAndResizeAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// CropAndResizeExtrapolationValue sets the optional extrapolation_value attribute to value.
//
// value: Value used for extrapolation, when applicable.
// If not specified, defaults to 0
func CropAndResizeExtrapolationValue(value float32) CropAndResizeAttr {
	return func(m optionalAttr) {
		m["extrapolation_value"] = value
	}
}

// Extracts crops from the input image tensor and resizes them.
//
// Extracts crops from the input image tensor and resizes them using bilinear
// sampling or nearest neighbor sampling (possibly with aspect ratio change) to a
// common output size specified by `crop_size`. This is more general than the
// `crop_to_bounding_box` op which extracts a fixed size slice from the input image
// and does not allow resizing or aspect ratio change.
//
// Returns a tensor with `crops` from the input `image` at positions defined at the
// bounding box locations in `boxes`. The cropped boxes are all resized (with
// bilinear or nearest neighbor interpolation) to a fixed
// `size = [crop_height, crop_width]`. The result is a 4-D tensor
// `[num_boxes, crop_height, crop_width, depth]`. The resizing is corner aligned.
// In particular, if `boxes = [[0, 0, 1, 1]]`, the method will give identical
// results to using `tf.image.resize_bilinear()` or
// `tf.image.resize_nearest_neighbor()`(depends on the `method` argument) with
// `align_corners=True`.
//
// Arguments:
//	image: A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
// Both `image_height` and `image_width` need to be positive.
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1]` in image height coordinates. We do allow `y1` > `y2`, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//	crop_size: A 1-D tensor of 2 elements, `size = [crop_height, crop_width]`. All
// cropped image patches are resized to this size. The aspect ratio of the image
// content is not preserved. Both `crop_height` and `crop_width` need to be
// positive.
//
// Returns A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
func CropAndResize(scope *Scope, image tf.Output, boxes tf.Output, box_ind tf.Output, crop_size tf.Output, optional ...CropAndResizeAttr) (crops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResize",
		Input: []tf.Input{
			image, boxes, box_ind, crop_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomUniformAttr is an optional argument to RandomUniform.
type RandomUniformAttr func(optionalAttr)

// RandomUniformSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomUniformSeed(value int64) RandomUniformAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomUniformSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomUniformSeed2(value int64) RandomUniformAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[0, 1)`. The
// lower bound 0 is included in the range, while the upper bound 1 is excluded.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with uniform random values.
func RandomUniform(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...RandomUniformAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomUniform",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for a multi device iterator resource.
//
// Returns:
//	handle: A handle to a multi device iterator that can be passed to a
// "MultiDeviceIteratorGetNextFromShard" op. In contrast to MultiDeviceIterator,
// AnonymousIterator prevents resource sharing by name, and does not keep a
// reference to the resource container.
//	deleter: A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousMultiDeviceIterator(scope *Scope, devices []string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousMultiDeviceIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Provides the time since epoch in seconds.
//
// Returns the timestamp as a `float64` for seconds since the Unix epoch.
//
// Note: the timestamp is computed when the op is executed, not when it is added
// to the graph.
func Timestamp(scope *Scope) (ts tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Timestamp",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMulAttr is an optional argument to QuantizedMul.
type QuantizedMulAttr func(optionalAttr)

// QuantizedMulToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMulToutput(value tf.DataType) QuantizedMulAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// Returns x * y element-wise, working on quantized buffers.
//
// Arguments:
//
//
//	min_x: The float value that the lowest quantized `x` value represents.
//	max_x: The float value that the highest quantized `x` value represents.
//	min_y: The float value that the lowest quantized `y` value represents.
//	max_y: The float value that the highest quantized `y` value represents.
//
// Returns:
//	z
//	min_z: The float value that the lowest quantized output value represents.
//	max_z: The float value that the highest quantized output value represents.
//
// *NOTE*: `QuantizedMul` supports limited forms of broadcasting. More about
// broadcasting [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func QuantizedMul(scope *Scope, x tf.Output, y tf.Output, min_x tf.Output, max_x tf.Output, min_y tf.Output, max_y tf.Output, optional ...QuantizedMulAttr) (z tf.Output, min_z tf.Output, max_z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMul",
		Input: []tf.Input{
			x, y, min_x, max_x, min_y, max_y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ShuffleAndRepeatDatasetAttr is an optional argument to ShuffleAndRepeatDataset.
type ShuffleAndRepeatDatasetAttr func(optionalAttr)

// ShuffleAndRepeatDatasetReshuffleEachIteration sets the optional reshuffle_each_iteration attribute to value.
// If not specified, defaults to true
func ShuffleAndRepeatDatasetReshuffleEachIteration(value bool) ShuffleAndRepeatDatasetAttr {
	return func(m optionalAttr) {
		m["reshuffle_each_iteration"] = value
	}
}

// Creates a dataset that shuffles and repeats elements from `input_dataset`
//
// pseudorandomly.
//
// Arguments:
//
//	buffer_size: The number of output elements to buffer in an iterator over
// this dataset. Compare with the `min_after_dequeue` attr when creating a
// `RandomShuffleQueue`.
//	seed: A scalar seed for the random number generator. If either `seed` or
// `seed2` is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//	count: A scalar representing the number of times the underlying dataset
// should be repeated. The default is `-1`, which results in infinite repetition.
//
//
func ShuffleAndRepeatDataset(scope *Scope, input_dataset tf.Output, buffer_size tf.Output, seed tf.Output, seed2 tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShuffleAndRepeatDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShuffleAndRepeatDataset",
		Input: []tf.Input{
			input_dataset, buffer_size, seed, seed2, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorList by indexing into a Tensor.
//
// Each member of the TensorList corresponds to one row of the input tensor,
// specified by the given index (see `tf.gather`).
//
// tensor: The input tensor.
// indices: The indices used to index into the list.
// element_shape: The shape of the elements in the list (can be less specified than
//   the shape of the tensor).
// num_elements: The size of the output list. Must be large enough to accommodate
//   the largest index in indices. If -1, the list is just large enough to include
//   the largest index in indices.
// output_handle: The TensorList.
func TensorListScatterV2(scope *Scope, tensor tf.Output, indices tf.Output, element_shape tf.Output, num_elements tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListScatterV2",
		Input: []tf.Input{
			tensor, indices, element_shape, num_elements,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeBilinearAttr is an optional argument to ResizeBilinear.
type ResizeBilinearAttr func(optionalAttr)

// ResizeBilinearAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func ResizeBilinearAlignCorners(value bool) ResizeBilinearAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBilinearHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBilinearHalfPixelCenters(value bool) ResizeBilinearAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Resize `images` to `size` using bilinear interpolation.
//
// Input images can be of different types but output images are always float.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ResizeBilinear(scope *Scope, images tf.Output, size tf.Output, optional ...ResizeBilinearAttr) (resized_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBilinear",
		Input: []tf.Input{
			images, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates sparse cross from a list of sparse and dense tensors.
//
// The op takes two lists, one of 2D `SparseTensor` and one of 2D `Tensor`, each
// representing features of one feature column. It outputs a 2D `SparseTensor` with
// the batchwise crosses of these features.
//
// For example, if the inputs are
//
//     inputs[0]: SparseTensor with shape = [2, 2]
//     [0, 0]: "a"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
//     inputs[1]: SparseTensor with shape = [2, 1]
//     [0, 0]: "d"
//     [1, 0]: "e"
//
//     inputs[2]: Tensor [["f"], ["g"]]
//
// then the output will be
//
//     shape = [2, 2]
//     [0, 0]: "a_X_d_X_f"
//     [1, 0]: "b_X_e_X_g"
//     [1, 1]: "c_X_e_X_g"
//
// if hashed_output=true then the output will be
//
//     shape = [2, 2]
//     [0, 0]: FingerprintCat64(
//                 Fingerprint64("f"), FingerprintCat64(
//                     Fingerprint64("d"), Fingerprint64("a")))
//     [1, 0]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("b")))
//     [1, 1]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("c")))
//
// Arguments:
//	indices: 2-D.  Indices of each input `SparseTensor`.
//	values: 1-D.   values of each `SparseTensor`.
//	shapes: 1-D.   Shapes of each `SparseTensor`.
//	dense_inputs: 2-D.    Columns represented by dense `Tensor`.
//	sep: string used when joining a list of string inputs, can be used as separator later.
//
// Returns:
//	output_indices: 2-D.  Indices of the concatenated `SparseTensor`.
//	output_values: 1-D.  Non-empty values of the concatenated or hashed
// `SparseTensor`.
//	output_shape: 1-D.  Shape of the concatenated `SparseTensor`.
func SparseCrossV2(scope *Scope, indices []tf.Output, values []tf.Output, shapes []tf.Output, dense_inputs []tf.Output, sep tf.Output) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseCrossV2",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(values), tf.OutputList(shapes), tf.OutputList(dense_inputs), sep,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// BlockLSTMV2Attr is an optional argument to BlockLSTMV2.
type BlockLSTMV2Attr func(optionalAttr)

// BlockLSTMV2CellClip sets the optional cell_clip attribute to value.
//
// value: Value to clip the 'cs' value to.
// If not specified, defaults to 0
func BlockLSTMV2CellClip(value float32) BlockLSTMV2Attr {
	return func(m optionalAttr) {
		m["cell_clip"] = value
	}
}

// BlockLSTMV2UsePeephole sets the optional use_peephole attribute to value.
//
// value: Whether to use peephole weights.
// If not specified, defaults to false
func BlockLSTMV2UsePeephole(value bool) BlockLSTMV2Attr {
	return func(m optionalAttr) {
		m["use_peephole"] = value
	}
}

// Computes the LSTM cell forward propagation for all the time steps.
//
// This is equivalent to applying LSTMBlockCell in a loop, like so:
//
// ```python
// for x1 in unpack(x):
//   i1, cs1, f1, o1, ci1, co1, h1 = LSTMBlock(
//     x1, cs_prev, h_prev, w, wci, wcf, wco, b)
//   cs_prev = cs1
//   h_prev = h1
//   i.append(i1)
//   cs.append(cs1)
//   f.append(f1)
//   o.append(o1)
//   ci.append(ci1)
//   co.append(co1)
//   h.append(h1)
// return pack(i), pack(cs), pack(f), pack(o), pack(ci), pack(ch), pack(h)
//
// Note that unlike LSTMBlockCell (and BlockLSTM) which uses ICFO gate layout,
// this op uses IFCO. So in order for the following snippet to be equivalent
// all gate-related outputs should be reordered.
// ```
//
// Arguments:
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
// with zeros beyond this length.
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//
// Returns:
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
func BlockLSTMV2(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, optional ...BlockLSTMV2Attr) (i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BlockLSTMV2",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Extract `patches` from `images` and put them in the "depth" output dimension.
//
// Arguments:
//	images: 4-D Tensor with shape `[batch, in_rows, in_cols, depth]`.
//	ksizes: The size of the sliding window for each dimension of `images`.
//	strides: How far the centers of two consecutive patches are in
// the images. Must be: `[1, stride_rows, stride_cols, 1]`.
//	rates: Must be: `[1, rate_rows, rate_cols, 1]`. This is the
// input stride, specifying how far two consecutive patch samples are in the
// input. Equivalent to extracting patches with
// `patch_sizes_eff = patch_sizes + (patch_sizes - 1) * (rates - 1)`, followed by
// subsampling them spatially by a factor of `rates`. This is equivalent to
// `rate` in dilated (a.k.a. Atrous) convolutions.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D Tensor with shape `[batch, out_rows, out_cols, ksize_rows *
// ksize_cols * depth]` containing image patches with size
// `ksize_rows x ksize_cols x depth` vectorized in the "depth" dimension. Note
// `out_rows` and `out_cols` are the dimensions of the output patches.
func ExtractImagePatches(scope *Scope, images tf.Output, ksizes []int64, strides []int64, rates []int64, padding string) (patches tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksizes": ksizes, "strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "ExtractImagePatches",
		Input: []tf.Input{
			images,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Forwards the value of an available tensor from `inputs` to `output`.
//
// `Merge` waits for at least one of the tensors in `inputs` to become available.
// It is usually combined with `Switch` to implement branching.
//
// `Merge` forwards the first tensor to become available to `output`, and sets
// `value_index` to its index in `inputs`.
//
// Arguments:
//	inputs: The input tensors, exactly one of which will become available.
//
// Returns:
//	output: Will be set to the available input tensor.
//	value_index: The index of the chosen input tensor in `inputs`.
func Merge(scope *Scope, inputs []tf.Output) (output tf.Output, value_index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Merge",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// PaddedBatchDatasetV2Attr is an optional argument to PaddedBatchDatasetV2.
type PaddedBatchDatasetV2Attr func(optionalAttr)

// PaddedBatchDatasetV2ParallelCopy sets the optional parallel_copy attribute to value.
// If not specified, defaults to false
func PaddedBatchDatasetV2ParallelCopy(value bool) PaddedBatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["parallel_copy"] = value
	}
}

// Creates a dataset that batches and pads `batch_size` elements from the input.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	padded_shapes: A list of int64 tensors representing the desired padded shapes
// of the corresponding output components. These shapes may be partially
// specified, using `-1` to indicate that a particular dimension should be
// padded to the maximum size of all batch elements.
//	padding_values: A list of scalars containing the padding value to use for
// each of the outputs.
//	drop_remainder: A scalar representing whether the last batch should be dropped in case its size
// is smaller than desired.
//
func PaddedBatchDatasetV2(scope *Scope, input_dataset tf.Output, batch_size tf.Output, padded_shapes []tf.Output, padding_values []tf.Output, drop_remainder tf.Output, output_shapes []tf.Shape, optional ...PaddedBatchDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddedBatchDatasetV2",
		Input: []tf.Input{
			input_dataset, batch_size, tf.OutputList(padded_shapes), tf.OutputList(padding_values), drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNAttr is an optional argument to CudnnRNN.
type CudnnRNNAttr func(optionalAttr)

// CudnnRNNRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNRnnMode(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNInputMode(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNDirection(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNDropout(value float32) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNSeed(value int64) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNSeed2(value int64) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNIsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNIsTraining(value bool) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//   the actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inference or
//   training.
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//   is only produced if is_training is false.
func CudnnRNN(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, optional ...CudnnRNNAttr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNN",
		Input: []tf.Input{
			input, input_h, input_c, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Creates a dataset that batches `batch_size` elements from `input_dataset`.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//
//
func BatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "BatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SetSizeAttr is an optional argument to SetSize.
type SetSizeAttr func(optionalAttr)

// SetSizeValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func SetSizeValidateIndices(value bool) SetSizeAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Number of unique elements along last dimension of input `set`.
//
// Input `set` is a `SparseTensor` represented by `set_indices`, `set_values`,
// and `set_shape`. The last dimension contains values in a set, duplicates are
// allowed but ignored.
//
// If `validate_indices` is `True`, this op validates the order and range of `set`
// indices.
//
// Arguments:
//	set_indices: 2D `Tensor`, indices of a `SparseTensor`.
//	set_values: 1D `Tensor`, values of a `SparseTensor`.
//	set_shape: 1D `Tensor`, shape of a `SparseTensor`.
//
// Returns For `set` ranked `n`, this is a `Tensor` with rank `n-1`, and the same 1st
// `n-1` dimensions as `set`. Each value is the number of unique elements in
// the corresponding `[0...n-1]` dimension of `set`.
func SetSize(scope *Scope, set_indices tf.Output, set_values tf.Output, set_shape tf.Output, optional ...SetSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SetSize",
		Input: []tf.Input{
			set_indices, set_values, set_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//   Combines (nests of) input elements into a dataset of (nests of) windows.
//
//   A "window" is a finite dataset of flat elements of size `size` (or possibly
//   fewer if there are not enough input elements to fill the window and
//   `drop_remainder` evaluates to false).
//
//   The `shift` argument determines the number of input elements by which
//   the window moves on each iteration.  The first element in the `k`th window
//   will be element
//
//   ```
//   1 + (k-1) * shift
//   ```
//
//   of the input dataset. In particular, the first element of the first window
//   will always be the first element of the input dataset.
//
//   If the `stride` parameter is greater than 1, then each window will skip
//   `(stride - 1)` input elements between each element that appears in the
//   window. Output windows will still contain `size` elements regardless of
//   the value of `stride`.
//
//   The `stride` argument determines the stride of the input elements, and the
//   `shift` argument determines the shift of the window.
//
//   For example, letting `{...}` to represent a Dataset:
//
//   - `tf.data.Dataset.range(7).window(2)` produces
//     `{{0, 1}, {2, 3}, {4, 5}, {6}}`
//   - `tf.data.Dataset.range(7).window(3, 2, 1, True)` produces
//     `{{0, 1, 2}, {2, 3, 4}, {4, 5, 6}}`
//   - `tf.data.Dataset.range(7).window(3, 1, 2, True)` produces
//     `{{0, 2, 4}, {1, 3, 5}, {2, 4, 6}}`
//
//   Note that when the `window` transformation is applied to a dataset of
//   nested elements, it produces a dataset of nested windows.
//
//   For example:
//
//   - `tf.data.Dataset.from_tensor_slices((range(4), range(4))).window(2)`
//     produces `{({0, 1}, {0, 1}), ({2, 3}, {2, 3})}`
//   - `tf.data.Dataset.from_tensor_slices({"a": range(4)}).window(2)`
//     produces `{{"a": {0, 1}}, {"a": {2, 3}}}`
//
// Arguments:
//
//	size: An integer scalar, representing the number of elements
// of the input dataset to combine into a window. Must be positive.
//	shift: An integer scalar, representing the number of input elements
// by which the window moves in each iteration.  Defaults to `size`.
// Must be positive.
//	stride: An integer scalar, representing the stride of the input elements
// in the sliding window. Must be positive. The default value of 1 means
// "retain every input element".
//	drop_remainder: A Boolean scalar, representing whether the last window should be
// dropped if its size is smaller than `window_size`.
//
//
func WindowDataset(scope *Scope, input_dataset tf.Output, size tf.Output, shift tf.Output, stride tf.Output, drop_remainder tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpe