# TensorFlow Security Advisories

[![Fuzzing Status](https://oss-fuzz-build-logs.storage.googleapis.com/badges/tensorflow.svg)](https://bugs.chromium.org/p/oss-fuzz/issues/list?sort=-opened&can=1&q=proj:tensorflow)

We regularly publish security advisories about using TensorFlow.

*Note*: In conjunction with these security advisories, we strongly encourage
TensorFlow users to read and understand TensorFlow's security model as outlined
in [SECURITY.md](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md).

| Advisory Number | Type               | Versions affected | Reported by           | Additional Information      |
|-----------------|--------------------|:-----------------:|-----------------------|-----------------------------|
| [TFSA-2020-034](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-034.md)   | Heap out of bounds access in MakeEdge                                              | >= 1.15.0, <= 2.3.0 | (discovered internally)                       |  |
| [TFSA-2020-033](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-033.md)   | CHECK-fail in LSTM with zero-length input                                          | >= 1.15.0, <= 2.3.0 | (discovered internally)                       |  |
| [TFSA-2020-032](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-032.md)   | Heap out of bounds read in filesystem glob matching                                | 2.4.0-rc{0,1,2,3}   | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-031](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-031.md)   | Write to immutable memory region                                                   | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-030](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-030.md)   | Lack of validation in data format attributes                                       | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-029](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-029.md)   | Uninitialized memory access in Eigen types                                         | >= 1.15.0, <= 2.3.0 | (discovered internally)                       |  |
| [TFSA-2020-028](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-028.md)   | Float cast overflow undefined behavior                                             | <= 2.3 | (Reported on GitHub) | [issue report](https://github.com/tensorflow/tensorflow/issues/42129) |
| [TFSA-2020-027](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-027.md)   | Segfault in `tf.quantization.quantize_and_dequantize                              `| <= 2.3 | (Reported on GitHub) | [issue report](https://github.com/tensorflow/tensorflow/issues/42105) |
| [TFSA-2020-026](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-026.md)   | Segfault in `tf.raw_ops.Switch` in eager mode                                      | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-025](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-025.md)   | Undefined behavior in `dlpack.to_dlpack`                                           | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-024](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-024.md)   | Memory leak in `dlpack.to_dlpack`                                                  | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-023](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-023.md)   | Memory corruption in `dlpack.to_dlpack`                                            | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-022](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-022.md)   | Crash due to invalid shape of `grad_values` in SparseFillEmptyRowsGrad             | >= 1.15.0, <= 2.3.0 | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-021](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-021.md)   | Heap buffer overflow in SparseFillEmptyRowsGrad                                    | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-020](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-020.md)   | Heap buffer overflow in weighted sparse count ops                                  | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-019](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-019.md)   | Crash due to invalid splits in SparseCountSparseOutput                             | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-018](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-018.md)   | Heap buffer overflow due to invalid indices in SparseCountSparseOutput             | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-017](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-017.md)   | Abort due to invalid splits in RaggedCountSparseOutput                             | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-016](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-016.md)   | Segfault due to invalid splits in RaggedCountSparseOutput                          | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-015](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-015.md)   | Heap buffer overflow due to invalid splits in RaggedCountSparseOutput              | 2.3.0               | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-014](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-014.md)   | Integer truncation in Shard API usage                                              | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-013](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-013.md)   | Format-string vulnerability in TensorFlow's `as_string`                            | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-012](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-012.md)   | Segfault by calling session-only ops in eager mode                                 | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-011](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-011.md)   | Data leak in `tf.raw_ops.StringNGrams                                             `| >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-010](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-010.md)   | Incomplete validation in TensorFlow's SavedModel's constant nodes causes segfaults | >= 1.15.0, <= 2.3.0 | Shuaike Dong, Alipay Tian Qian Security Lab   | [issue report](https://github.com/tensorflow/tensorflow/issues/41097) |
| [TFSA-2020-009](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-009.md)   | Segfault and data corruption caused by negative indexing in TFLite                 | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-008](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-008.md)   | Data corruption due to dimension mismatch in TFLite                                | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-007](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-007.md)   | Null pointer dereference in TFLite                                                 | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360, variant analysis   |  |
| [TFSA-2020-006](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-006.md)   | Segmentation fault and/or data corruption due to invalid TFLite model              | >= 1.15.0, <= 2.3.0 | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-005](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-005.md)   | Out of bounds access in TFLite operators                                           | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-004](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-004.md)   | Out of bounds access in TFLite implementation of segment sum                       | 2.2.0, 2.3.0        | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-003](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-003.md)   | Denial of service from TFLite implementation of segment sum                        | 2.2.0, 2.3.0        | (variant analysis, Aivul Team from Qihoo 360) |  |
| [TFSA-2020-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-002.md)   | Out of bounds write in TFLite implementation of segment sum                        | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                     |  |
| [TFSA-2020-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-001.md)   | Segmentation fault when converting a Python string to `tf.float16` | >= 1.12.0, <= 2.1 | (found internally) |  |
| [TFSA-2019-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2019-002.md)   | Heap buffer overflow in `UnsortedSegmentSum` | <= 1.14 | (found internally) |  |
| [TFSA-2019-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2019-001.md)   | Null Pointer Dereference Error in Decoding GIF Files | <= 1.12 | Baidu Security Lab |  |
| [TFSA-2018-006](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-006.md)   | Crafted Configuration File results in Invalid Memory Access | <= 1.7 | Blade Team of Tencent |  |
| [TFSA-2018-005](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-005.md)   | Old Snappy Library Usage Resulting in Memcpy Parameter Overlap | <= 1.7 | Blade Team of Tencent |  |
| [TFSA-2018-004](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-004.md)   | Checkpoint Meta File Out-of-Bounds Read | <= 1.7 | Blade Team of Tencent |  |
| [TFSA-2018-003](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-003.md)   | TensorFlow Lite TOCO FlatBuffer Parsing Vulnerability | <= 1.7 | Blade Team of Tencent |  |
| [TFSA-2018-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-002.md)   | GIF File Parsing Null Pointer Dereference Error | <= 1.5 | Blade Team of Tencent |  |
| [TFSA-2018-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-001.md)   | BMP File Parser Out-of-bounds Read | <= 1.6 | Blade Team of Tencent |  |
| -               | Out Of Bounds Read |             <= 1.4 | Blade Team of Tencent | [issue report](https://github.com/tensorflow/tensorflow/issues/14959) |

