# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `radon_contextual_effects_minnesota_halfnormal`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=radon_contextual_effects_minnesota_halfnormal \
  --stan_samples=20000
```
"""

import numpy as np

IDENTITY_COUNTY_EFFECT_MEAN = np.array([
    1.369591126925,
    1.429199546375,
    1.387002967585,
    1.464424104745,
    1.3974416816500002,
    1.3760693444499998,
    1.51363212724,
    1.41885790623,
    1.3402308334900002,
    1.37411700389,
    1.4621094566000001,
    1.410747915025,
    1.4226956992950002,
    1.47028447685,
    1.3634621298199998,
    1.3654561768250002,
    1.3038799382700001,
    1.4150809289799997,
    1.350664381425,
    1.4148151482300002,
    1.437708842805,
    1.2019083646550002,
    1.356374356845,
    1.5058820788599998,
    1.51080020563,
    1.38755386455,
    1.37171472286,
    1.37499791654,
    1.411827915445,
    1.392432326615,
    1.45719288519,
    1.3765370694949999,
    1.47067556081,
    1.3855953171400004,
    1.355155763525,
    1.4759895069450002,
    1.256775057505,
    1.4930117613300002,
    1.414286980255,
    1.4600764939800002,
    1.44745894109,
    1.386269447735,
    1.3860683278450003,
    1.2827523040200002,
    1.29025026929,
    1.3607063844299998,
    1.351195199725,
    1.3366285332049999,
    1.4115117323699997,
    1.423993268425,
    1.471328163045,
    1.4178687145200002,
    1.34359736087,
    1.2559330168,
    1.4421920540950004,
    1.33928505256,
    1.284740506565,
    1.395357467045,
    1.3836275546849996,
    1.36931979686,
    1.4043974759449998,
    1.43225554231,
    1.379252530845,
    1.47163324763,
    1.3579540837250001,
    1.45561614521,
    1.4678627758349998,
    1.4327426859399999,
    1.34946241924,
    1.2065172112049998,
    1.36951253099,
    1.39121423402,
    1.396972311735,
    1.3080390071749999,
    1.4161848091749998,
    1.4139226526799997,
    1.44733993494,
    1.4251137335550002,
    1.2551259167775,
    1.3900362881050001,
    1.48802613494,
    1.41800448764,
    1.3313591477149997,
    1.481399039725,
    1.35811628464,
]).reshape((85,))

IDENTITY_COUNTY_EFFECT_MEAN_STANDARD_ERROR = np.array([
    0.00044240066247013015,
    0.0003623274697258587,
    0.000467446120329379,
    0.0007272022444301067,
    0.0004581827149541065,
    0.0004129170165279406,
    0.0009048369761546262,
    0.0005179637813137002,
    0.0004557929050736222,
    0.00045428450215763346,
    0.0006550572100500181,
    0.00045149222240013976,
    0.000467875479779376,
    0.0006885045959126242,
    0.0004608531305874518,
    0.0004370548598470599,
    0.0006612046966424345,
    0.00046805298345567264,
    0.0002697539339415021,
    0.0004641904456273168,
    0.0005175916467929757,
    0.0011820501484208937,
    0.00047489011931019167,
    0.0009247454962754685,
    0.0008665838194788514,
    0.0002520442486474774,
    0.0004185701675260637,
    0.0004713759618087432,
    0.00046636965984123374,
    0.00038648197560482283,
    0.0006434097485803362,
    0.00040017676641425717,
    0.0007303848127140208,
    0.0004704007980175742,
    0.0004908021548308623,
    0.0008193114868283566,
    0.0008424020862045698,
    0.0009297130179617741,
    0.00048096381647912324,
    0.0006858021224709341,
    0.0005778597267097859,
    0.00044018527258034973,
    0.00047865119782658375,
    0.0007054356624224846,
    0.0006425394937348249,
    0.00041958232854139157,
    0.0004913111984993186,
    0.0004560347291189356,
    0.0004230061376168552,
    0.0005500479506494198,
    0.00075339443557322,
    0.0004944875332201594,
    0.0004941360707208552,
    0.0006771582554737279,
    0.0005784181903814173,
    0.0005222416510205879,
    0.0007243602764629056,
    0.00043350800325440015,
    0.0004554218257632572,
    0.00043128590550203956,
    0.000344689391797511,
    0.0005442605214331624,
    0.00044283192451517685,
    0.0006827524826279923,
    0.0004364359919876632,
    0.0006726398445608166,
    0.000678035371378916,
    0.0005023213429467947,
    0.0004369033990661497,
    0.0006383706061086843,
    0.0003334986094125572,
    0.0003519146504295781,
    0.00043105505383995394,
    0.0006148818038413253,
    0.0004958234600375501,
    0.00047828313156988387,
    0.0005891561866667608,
    0.0005406949975536809,
    0.0009385011303083106,
    0.0002991717560327451,
    0.000901391189198707,
    0.0005157552871820832,
    0.0004389628348820291,
    0.0007119729590609378,
    0.0004385505782063502,
]).reshape((85,))

IDENTITY_COUNTY_EFFECT_STANDARD_DEVIATION = np.array([
    0.1478221843002874,
    0.10119131090461964,
    0.15166827156328622,
    0.14999917796590062,
    0.1469036762816015,
    0.1479629653670923,
    0.13613104365147385,
    0.14962958091722445,
    0.13223929497962017,
    0.1444559125774678,
    0.14832575566366984,
    0.14560513134306804,
    0.1413283938303161,
    0.13256863489043705,
    0.14882277310465142,
    0.15238181926617803,
    0.15657379698852394,
    0.13137286324614816,
    0.08117987120388688,
    0.14910319736766323,
    0.1350690330515568,
    0.1684177800860944,
    0.15469902778895658,
    0.14689280500185292,
    0.13481816467572663,
    0.06906307711775014,
    0.1424389313198612,
    0.14764254947203626,
    0.14947907352715126,
    0.12840058178492747,
    0.14693896261749034,
    0.14459113564144221,
    0.15282594085781506,
    0.15188397889894795,
    0.1453790121759248,
    0.16321280401477306,
    0.14672951797778266,
    0.16075861428008334,
    0.14410155539982267,
    0.15308082595524136,
    0.1386556287038865,
    0.1551404486915699,
    0.13948061083026173,
    0.14621291930501368,
    0.133966356891899,
    0.14206611095993035,
    0.15515576648558718,
    0.1341228098380888,
    0.12545448023337066,
    0.15789188555571348,
    0.15270957004450708,
    0.14892962958199046,
    0.1511936051638361,
    0.11975856869456396,
    0.14167834637232682,
    0.15405353209290235,
    0.14954149168311454,
    0.14649236633573356,
    0.14818726792313022,
    0.15213331485339845,
    0.10366173401021624,
    0.14583666871938458,
    0.1499594508273719,
    0.13378565654427627,
    0.15277602490768896,
    0.13824720662353424,
    0.1336735249542027,
    0.1365581654013424,
    0.14571253126152844,
    0.08478333126632623,
    0.10908421282596976,
    0.12849857581523155,
    0.15216235022577956,
    0.15053582815003444,
    0.1506792706384039,
    0.1474025662523754,
    0.14181296817025896,
    0.1475261872172126,
    0.16207129776953974,
    0.09173002567191572,
    0.16402524287579712,
    0.1580716641604231,
    0.12830283532491119,
    0.13139781002069048,
    0.15285553238767274,
]).reshape((85,))

IDENTITY_COUNTY_EFFECT_MEAN_MEAN = np.array([
    1.392279422,
]).reshape(())

IDENTITY_COUNTY_EFFECT_MEAN_MEAN_STANDARD_ERROR = np.array([
    0.00036505133240959185,
]).reshape(())

IDENTITY_COUNTY_EFFECT_MEAN_STANDARD_DEVIATION = np.array([
    0.050712718961724836,
]).reshape(())

IDENTITY_COUNTY_EFFECT_SCALE_MEAN = np.array([
    0.14457215533950002,
]).reshape(())

IDENTITY_COUNTY_EFFECT_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.0006768983639383711,
]).reshape(())

IDENTITY_COUNTY_EFFECT_SCALE_STANDARD_DEVIATION = np.array([
    0.04918907312743993,
]).reshape(())

IDENTITY_LOG_RADON_SCALE_MEAN = np.array([
    0.75977590157,
]).reshape(())

IDENTITY_LOG_RADON_SCALE_MEAN_STANDARD_ERROR = np.array([
    7.327031648756984e-05,
]).reshape(())

IDENTITY_LOG_RADON_SCALE_STANDARD_DEVIATION = np.array([
    0.018408179814628438,
]).reshape(())

IDENTITY_WEIGHT_MEAN = np.array([
    0.7140640166199999,
    -0.7142173634200001,
    0.39877565798705394,
]).reshape((3,))

IDENTITY_WEIGHT_MEAN_STANDARD_ERROR = np.array([
    0.00032238092978804445,
    0.0002013676034338986,
    0.0012256419602518147,
]).reshape((3,))

IDENTITY_WEIGHT_STANDARD_DEVIATION = np.array([
    0.09035090550779404,
    0.07317535408346594,
    0.20066948570485357,
]).reshape((3,))
