# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `convection_lorenz_bridge_unknown_scales`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=convection_lorenz_bridge_unknown_scales \
  --stan_samples=100000
```
"""

import numpy as np

IDENTITY_INNOVATION_SCALE_MEAN = np.array([
    0.8123676214972999,
]).reshape(())

IDENTITY_INNOVATION_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.01804469115616022,
]).reshape(())

IDENTITY_INNOVATION_SCALE_STANDARD_DEVIATION = np.array([
    0.9712940217076047,
]).reshape(())

IDENTITY_LATENTS_MEAN = np.array([
    -0.22642909273529002,
    -0.5823330316628155,
    -0.4189373876446463,
    -0.2824128261632101,
    -0.7152536589358017,
    -0.4026348958507211,
    -0.3767933925467511,
    -0.874958159024297,
    -0.3831427698174214,
    -0.5417842207250007,
    -1.0714796254534587,
    -0.360975317853925,
    -0.659053020249221,
    -1.3538295046268902,
    -0.3363428882604258,
    -0.76410791621519,
    -1.7061653836646318,
    -0.3064787576289404,
    -0.9361042326306089,
    -2.11384614545312,
    -0.2694921303127244,
    -1.1704894906304242,
    -2.6100377284361183,
    -0.22186189198971648,
    -1.4696086694525001,
    -3.2246095952206604,
    -0.15419159093760393,
    -1.7236087303721388,
    -4.0142059998088,
    -0.05669699731149155,
    -2.208091271609281,
    -4.92292821717762,
    0.07871292665120999,
    -2.772142386826885,
    -6.07647668792538,
    0.28648462464904567,
    -3.4511777283940006,
    -7.50684934168,
    0.6032990453758323,
    -4.278384106609,
    -9.261214245809999,
    1.0846335398525828,
    -5.286846316819999,
    -11.389218253800001,
    1.8148853022942713,
    -6.515418187170001,
    -13.939868341130003,
    2.918349893536508,
    -8.0053163028,
    -16.93861031767,
    4.57553096097918,
    -9.79160545677,
    -20.3603869609,
    7.041323199464401,
    -11.896018702249998,
    -24.070274942399998,
    10.65429584483,
    -14.307673633699997,
    -27.7326445026,
    15.818069271849998,
    -16.950482042699996,
    -30.6851159498,
    22.923282822299996,
    -19.6765880761,
    -31.8104642195,
    32.1239087404,
    -22.095993397199997,
    -29.5612872938,
    42.955667909999995,
    -23.578251778799995,
    -22.3612881523,
    53.7573516532,
    -23.369959571200003,
    -9.750253236590002,
    61.4577798048,
    -20.6656476875,
    6.11011344691884,
    62.7504899193,
    -15.261346566400002,
    20.3719510473,
    56.8859361895,
    -8.08924357152,
    28.794150729500007,
    47.63634421609999,
    -0.6833469861655502,
    31.4008293003,
    40.43875263579999,
    5.748679870559999,
    30.943984377099998,
    37.856285830999994,
]).reshape((30, 3))

IDENTITY_LATENTS_MEAN_STANDARD_ERROR = np.array([
    0.0011563436623500114,
    0.002250878546793191,
    0.004203596630170778,
    0.0015327291393180055,
    0.0015398584971515166,
    0.003926328579148145,
    0.0011492770642557854,
    0.0015420488326846446,
    0.003634418257363442,
    0.001668272801760066,
    0.0018569308776584543,
    0.003365335280683264,
    0.001207115691022263,
    0.0009494835324929524,
    0.003038515477824349,
    0.0006304065185944938,
    0.0005620662609755181,
    0.002803467479901686,
    0.001146076725988299,
    0.0005710629886331179,
    0.0025502908221332315,
    0.0009330006876360337,
    0.0006573636376858105,
    0.0023626956005543213,
    0.0005154164755513844,
    0.0007401093718446308,
    0.0021410620777717266,
    0.003841152264920984,
    0.0006771971776486019,
    0.0019982895086355147,
    0.0020756606191777724,
    0.00133494298393671,
    0.001908035319656032,
    0.0010784061250481228,
    0.0019069705794910212,
    0.0019007198144338682,
    0.0006939796794273232,
    0.0019798607717903143,
    0.0018667171173744695,
    0.0005934218371551073,
    0.0018488578499800219,
    0.0019697763896893423,
    0.000516816135559724,
    0.0015047412745783782,
    0.001986807463909324,
    0.0005495818309569741,
    0.001287308164755208,
    0.0022681088127163053,
    0.0005655821444027328,
    0.001062105506638098,
    0.0023651506311315016,
    0.0007021347226611644,
    0.0009365209539660741,
    0.0024060713015706813,
    0.0009847505421004333,
    0.0007956604786867294,
    0.002575765741584688,
    0.0014418065636960307,
    0.0008751205662116601,
    0.002764962146609529,
    0.00263526560454898,
    0.0012859026674012781,
    0.0029540595907886413,
    0.002636808269941477,
    0.0022577733482582025,
    0.0031895123765541154,
    0.0021497882704495297,
    0.00385423581381443,
    0.002924665078145036,
    0.0019111789854298282,
    0.005507344286476654,
    0.002092294417642819,
    0.001250048153265468,
    0.0060191250159980425,
    0.0020670171215065045,
    0.0027223108713322268,
    0.004378798959405302,
    0.00485715498989929,
    0.0013971898856862954,
    0.0028105098702502457,
    0.0056314118464385445,
    0.0015821619330472318,
    0.004181528508294362,
    0.004364807566788604,
    0.0024450202334578017,
    0.00444737177181793,
    0.0038531782512352918,
    0.0028913285608426318,
    0.003970397641258751,
    0.004618943990089508,
]).reshape((30, 3))

IDENTITY_LATENTS_STANDARD_DEVIATION = np.array([
    0.4350219479651525,
    0.6109730458123828,
    0.802809442418229,
    0.26578467761332675,
    0.4077339038510169,
    0.7762542132491593,
    0.1873027282869429,
    0.33410151643346414,
    0.75166093650935,
    0.18224215897851323,
    0.3228607955978094,
    0.7281403463602681,
    0.15980192169504073,
    0.30319334437190915,
    0.7066052243864794,
    0.13840781725883172,
    0.2998370466879876,
    0.6861846626460977,
    0.14809899152778713,
    0.301866714855405,
    0.6666648822611552,
    0.1408944208363519,
    0.3044501546404696,
    0.6491313944975067,
    0.14605135013288584,
    0.30954956148281076,
    0.6322192236956315,
    0.3168163835178071,
    0.31132897115796443,
    0.6168589123255809,
    0.23843346281914454,
    0.32252309985734495,
    0.6012787368517276,
    0.2124639029579584,
    0.34035936394437083,
    0.5893786654181362,
    0.2078935544254465,
    0.3520366638869223,
    0.5798309246838621,
    0.21022799804457876,
    0.35907802221436314,
    0.5750151739569171,
    0.21473682731455684,
    0.36379661704792665,
    0.5749438147692348,
    0.22080726814339635,
    0.36751204559508427,
    0.5806872093458513,
    0.22681261020650076,
    0.36862570170614173,
    0.5936128245948475,
    0.23255036702386378,
    0.3677987809667846,
    0.6162873000833623,
    0.23763944193592196,
    0.3650444642843205,
    0.6497862687777441,
    0.24168998064465969,
    0.3705075841502075,
    0.6882231943767884,
    0.2518871208725605,
    0.4073137881637735,
    0.7229598004363865,
    0.2479501368806812,
    0.5060773064045402,
    0.7331704995704225,
    0.2342061564238557,
    0.6747522453892381,
    0.6994800917570942,
    0.2576704710729478,
    0.8641036526773391,
    0.6358671677753215,
    0.2818958527699019,
    0.977831600547149,
    0.6656987316843643,
    0.3711234165406388,
    0.941031737213776,
    0.8424482913760782,
    0.3857163873275694,
    0.8918788789380903,
    0.9395395135348741,
    0.3894182714189889,
    0.9462881620939161,
    0.8471186601875613,
    0.39530250501070985,
    0.9697608702645196,
    0.7226144606371117,
    0.4285384109859328,
    0.9415260611152609,
    0.7109257123833563,
]).reshape((30, 3))

IDENTITY_OBSERVATION_SCALE_MEAN = np.array([
    0.7425167442460501,
]).reshape(())

IDENTITY_OBSERVATION_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.0017928928486614876,
]).reshape(())

IDENTITY_OBSERVATION_SCALE_STANDARD_DEVIATION = np.array([
    0.16022239783154718,
]).reshape(())
