# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
# pylint: disable=line-too-long
r"""Daily closing price of the S&P 500 (^GSPC) in USD for 6/25/2010 - 6/24/2020.

Retrieved 6/25/2020 from https://finance.yahoo.com/quote/%5EGSPC/history/.

To regenerate this data:

```python
import pandas as pd
from inference_gym.internal import array_to_source
from inference_gym import using_tensorflow as gym

url = 'https://query1.finance.yahoo.com/v7/finance/download/%5EGSPC?period1=1277424000&period2=1593043200&interval=1d&events=history'
d = pd.read_csv(url)
source = array_to_source.array_to_source(
  'CLOSING_PRICES', d['Close'].values)
with open('/tmp/sp500_closing_prices.py', 'w') as f:
  f.write(source)
```

"""
# pylint: enable=line-too-long


import numpy as np

CLOSING_PRICES = np.array([
    1076.76001,
    1074.569946,
    1041.23999,
    1030.709961,
    1027.369995,
    1022.580017,
    1028.060059,
    1060.27002,
    1070.25,
    1077.959961,
    1078.75,
    1095.339966,
    1095.170044,
    1096.47998,
    1064.880005,
    1071.25,
    1083.47998,
    1069.589966,
    1093.670044,
    1102.660034,
    1115.01001,
    1113.839966,
    1106.130005,
    1101.530029,
    1101.599976,
    1125.859985,
    1120.459961,
    1127.23999,
    1125.810059,
    1121.640015,
    1127.790039,
    1121.060059,
    1089.469971,
    1083.609985,
    1079.25,
    1079.380005,
    1092.540039,
    1094.160034,
    1075.630005,
    1071.689941,
    1067.359985,
    1051.869995,
    1055.329956,
    1047.219971,
    1064.589966,
    1048.920044,
    1049.329956,
    1080.290039,
    1090.099976,
    1104.51001,
    1091.839966,
    1098.869995,
    1104.180054,
    1109.550049,
    1121.900024,
    1121.099976,
    1125.069946,
    1124.660034,
    1125.589966,
    1142.709961,
    1139.780029,
    1134.280029,
    1124.829956,
    1148.670044,
    1142.160034,
    1147.699951,
    1144.72998,
    1141.199951,
    1146.23999,
    1137.030029,
    1160.75,
    1159.969971,
    1158.060059,
    1165.150024,
    1165.319946,
    1169.77002,
    1178.099976,
    1173.810059,
    1176.189941,
    1184.709961,
    1165.900024,
    1178.170044,
    1180.26001,
    1183.079956,
    1185.619995,
    1185.640015,
    1182.449951,
    1183.780029,
    1183.26001,
    1184.380005,
    1193.569946,
    1197.959961,
    1221.060059,
    1225.849976,
    1223.25,
    1213.400024,
    1218.709961,
    1213.540039,
    1199.209961,
    1197.75,
    1178.339966,
    1178.589966,
    1196.689941,
    1199.72998,
    1197.839966,
    1180.72998,
    1198.349976,
    1189.400024,
    1187.76001,
    1180.550049,
    1206.069946,
    1221.530029,
    1224.709961,
    1223.119995,
    1223.75,
    1228.280029,
    1233,
    1240.400024,
    1240.459961,
    1241.589966,
    1235.22998,
    1242.869995,
    1243.910034,
    1247.079956,
    1254.599976,
    1258.839966,
    1256.77002,
    1257.540039,
    1258.51001,
    1259.780029,
    1257.880005,
    1257.640015,
    1271.869995,
    1270.199951,
    1276.560059,
    1273.849976,
    1271.5,
    1269.75,
    1274.47998,
    1285.959961,
    1283.76001,
    1293.23999,
    1295.02002,
    1281.920044,
    1280.26001,
    1283.349976,
    1290.839966,
    1291.180054,
    1296.630005,
    1299.540039,
    1276.339966,
    1286.119995,
    1307.589966,
    1304.030029,
    1307.099976,
    1310.869995,
    1319.050049,
    1324.569946,
    1320.880005,
    1321.869995,
    1329.150024,
    1332.319946,
    1328.01001,
    1336.319946,
    1340.430054,
    1343.01001,
    1315.439941,
    1307.400024,
    1306.099976,
    1319.880005,
    1327.219971,
    1306.329956,
    1308.439941,
    1330.969971,
    1321.150024,
    1310.130005,
    1321.819946,
    1320.02002,
    1295.109985,
    1304.280029,
    1296.390015,
    1281.869995,
    1256.880005,
    1273.719971,
    1279.209961,
    1298.380005,
    1293.77002,
    1297.540039,
    1309.660034,
    1313.800049,
    1310.189941,
    1319.439941,
    1328.26001,
    1325.829956,
    1332.410034,
    1332.869995,
    1332.630005,
    1335.540039,
    1333.51001,
    1328.170044,
    1324.459961,
    1314.160034,
    1314.410034,
    1314.52002,
    1319.680054,
    1305.140015,
    1312.619995,
    1330.359985,
    1337.380005,
    1335.25,
    1347.23999,
    1355.660034,
    1360.47998,
    1363.609985,
    1361.219971,
    1356.619995,
    1347.319946,
    1335.099976,
    1340.199951,
    1346.290039,
    1357.160034,
    1342.079956,
    1348.650024,
    1337.77002,
    1329.469971,
    1328.97998,
    1340.680054,
    1343.599976,
    1333.27002,
    1317.369995,
    1316.280029,
    1320.469971,
    1325.689941,
    1331.099976,
    1345.199951,
    1314.550049,
    1312.939941,
    1300.160034,
    1286.170044,
    1284.939941,
    1279.560059,
    1289,
    1270.97998,
    1271.829956,
    1287.869995,
    1265.420044,
    1267.640015,
    1271.5,
    1278.359985,
    1295.52002,
    1287.140015,
    1283.5,
    1268.449951,
    1280.099976,
    1296.670044,
    1307.410034,
    1320.640015,
    1339.670044,
    1337.880005,
    1339.219971,
    1353.219971,
    1343.800049,
    1319.48999,
    1313.640015,
    1317.719971,
    1308.869995,
    1316.140015,
    1305.439941,
    1326.72998,
    1325.839966,
    1343.800049,
    1345.02002,
    1337.430054,
    1331.939941,
    1304.890015,
    1300.670044,
    1292.280029,
    1286.939941,
    1254.050049,
    1260.339966,
    1200.069946,
    1199.380005,
    1119.459961,
    1172.530029,
    1120.76001,
    1172.640015,
    1178.810059,
    1204.48999,
    1192.76001,
    1193.890015,
    1140.650024,
    1123.530029,
    1123.819946,
    1162.349976,
    1177.599976,
    1159.27002,
    1176.800049,
    1210.079956,
    1212.920044,
    1218.890015,
    1204.420044,
    1173.969971,
    1165.23999,
    1198.619995,
    1185.900024,
    1154.22998,
    1162.27002,
    1172.869995,
    1188.680054,
    1209.109985,
    1216.01001,
    1204.089966,
    1202.089966,
    1166.76001,
    1129.560059,
    1136.430054,
    1162.949951,
    1175.380005,
    1151.060059,
    1160.400024,
    1131.420044,
    1099.22998,
    1123.949951,
    1144.030029,
    1164.969971,
    1155.459961,
    1194.890015,
    1195.540039,
    1207.25,
    1203.660034,
    1224.579956,
    1200.859985,
    1225.380005,
    1209.880005,
    1215.390015,
    1238.25,
    1254.189941,
    1229.050049,
    1242,
    1284.589966,
    1285.089966,
    1253.300049,
    1218.280029,
    1237.900024,
    1261.150024,
    1253.22998,
    1261.119995,
    1275.920044,
    1229.099976,
    1239.699951,
    1263.849976,
    1251.780029,
    1257.810059,
    1236.910034,
    1216.130005,
    1215.650024,
    1192.97998,
    1188.040039,
    1161.790039,
    1158.670044,
    1192.550049,
    1195.189941,
    1246.959961,
    1244.579956,
    1244.280029,
    1257.079956,
    1258.469971,
    1261.01001,
    1234.349976,
    1255.189941,
    1236.469971,
    1225.72998,
    1211.819946,
    1215.75,
    1219.660034,
    1205.349976,
    1241.300049,
    1243.719971,
    1254,
    1265.329956,
    1265.430054,
    1249.640015,
    1263.02002,
    1257.599976,
    1277.060059,
    1277.300049,
    1281.060059,
    1277.810059,
    1280.699951,
    1292.079956,
    1292.47998,
    1295.5,
    1289.089966,
    1293.670044,
    1308.040039,
    1314.5,
    1315.380005,
    1316,
    1314.650024,
    1326.060059,
    1318.430054,
    1316.329956,
    1313.01001,
    1312.410034,
    1324.089966,
    1325.540039,
    1344.900024,
    1344.329956,
    1347.050049,
    1349.959961,
    1351.949951,
    1342.640015,
    1351.77002,
    1350.5,
    1343.22998,
    1358.040039,
    1361.22998,
    1362.209961,
    1357.660034,
    1363.459961,
    1365.73999,
    1367.589966,
    1372.180054,
    1365.680054,
    1374.089966,
    1369.630005,
    1364.329956,
    1343.359985,
    1352.630005,
    1365.910034,
    1370.869995,
    1371.089966,
    1395.949951,
    1394.280029,
    1402.599976,
    1404.170044,
    1409.75,
    1405.52002,
    1402.890015,
    1392.780029,
    1397.109985,
    1416.51001,
    1412.52002,
    1405.540039,
    1403.280029,
    1408.469971,
    1419.040039,
    1413.380005,
    1398.959961,
    1398.079956,
    1382.199951,
    1358.589966,
    1368.709961,
    1387.569946,
    1370.26001,
    1369.569946,
    1390.780029,
    1385.140015,
    1376.920044,
    1378.530029,
    1366.939941,
    1371.969971,
    1390.689941,
    1399.97998,
    1403.359985,
    1397.910034,
    1405.819946,
    1402.310059,
    1391.569946,
    1369.099976,
    1369.579956,
    1363.719971,
    1354.579956,
    1357.98999,
    1353.390015,
    1338.349976,
    1330.660034,
    1324.800049,
    1304.859985,
    1295.219971,
    1315.98999,
    1316.630005,
    1318.859985,
    1320.680054,
    1317.819946,
    1332.420044,
    1313.319946,
    1310.329956,
    1278.040039,
    1278.180054,
    1285.5,
    1315.130005,
    1314.98999,
    1325.660034,
    1308.930054,
    1324.180054,
    1314.880005,
    1329.099976,
    1342.839966,
    1344.780029,
    1357.97998,
    1355.689941,
    1325.51001,
    1335.02002,
    1313.719971,
    1319.98999,
    1331.849976,
    1329.040039,
    1362.160034,
    1365.51001,
    1374.02002,
    1367.579956,
    1354.680054,
    1352.459961,
    1341.469971,
    1341.449951,
    1334.76001,
    1356.780029,
    1353.640015,
    1363.670044,
    1372.780029,
    1376.51001,
    1362.660034,
    1350.52002,
    1338.310059,
    1337.890015,
    1360.02002,
    1385.969971,
    1385.300049,
    1379.319946,
    1375.319946,
    1365,
    1390.98999,
    1394.22998,
    1401.349976,
    1402.219971,
    1402.800049,
    1405.869995,
    1404.109985,
    1403.930054,
    1405.530029,
    1415.51001,
    1418.160034,
    1418.130005,
    1413.170044,
    1413.48999,
    1402.079956,
    1411.130005,
    1410.439941,
    1409.300049,
    1410.48999,
    1399.47998,
    1406.579956,
    1404.939941,
    1403.439941,
    1432.119995,
    1437.920044,
    1429.079956,
    1433.560059,
    1436.560059,
    1459.98999,
    1465.77002,
    1461.189941,
    1459.319946,
    1461.050049,
    1460.26001,
    1460.150024,
    1456.890015,
    1441.589966,
    1433.319946,
    1447.150024,
    1440.670044,
    1444.48999,
    1445.75,
    1450.98999,
    1461.400024,
    1460.930054,
    1455.880005,
    1441.47998,
    1432.560059,
    1432.839966,
    1428.589966,
    1440.130005,
    1454.920044,
    1460.910034,
    1457.339966,
    1433.189941,
    1433.819946,
    1413.109985,
    1408.75,
    1412.969971,
    1411.939941,
    1412.160034,
    1427.589966,
    1414.199951,
    1417.26001,
    1428.390015,
    1394.530029,
    1377.51001,
    1379.849976,
    1380.030029,
    1374.530029,
    1355.48999,
    1353.329956,
    1359.880005,
    1386.890015,
    1387.810059,
    1391.030029,
    1409.150024,
    1406.290039,
    1398.939941,
    1409.930054,
    1415.949951,
    1416.180054,
    1409.459961,
    1407.050049,
    1409.280029,
    1413.939941,
    1418.069946,
    1418.550049,
    1427.839966,
    1428.47998,
    1419.449951,
    1413.579956,
    1430.359985,
    1446.790039,
    1435.810059,
    1443.689941,
    1430.150024,
    1426.660034,
    1419.829956,
    1418.099976,
    1402.430054,
    1426.189941,
    1462.420044,
    1459.369995,
    1466.469971,
    1461.890015,
    1457.150024,
    1461.02002,
    1472.119995,
    1472.050049,
    1470.680054,
    1472.339966,
    1472.630005,
    1480.939941,
    1485.97998,
    1492.560059,
    1494.810059,
    1494.819946,
    1502.959961,
    1500.180054,
    1507.839966,
    1501.959961,
    1498.109985,
    1513.170044,
    1495.709961,
    1511.290039,
    1512.119995,
    1509.390015,
    1517.930054,
    1517.01001,
    1519.430054,
    1520.329956,
    1521.380005,
    1519.790039,
    1530.939941,
    1511.949951,
    1502.420044,
    1515.599976,
    1487.849976,
    1496.939941,
    1515.98999,
    1514.680054,
    1518.199951,
    1525.199951,
    1539.790039,
    1541.459961,
    1544.26001,
    1551.180054,
    1556.219971,
    1552.47998,
    1554.52002,
    1563.22998,
    1560.699951,
    1552.099976,
    1548.339966,
    1558.709961,
    1545.800049,
    1556.890015,
    1551.689941,
    1563.77002,
    1562.849976,
    1569.189941,
    1562.170044,
    1570.25,
    1553.689941,
    1559.97998,
    1553.280029,
    1563.069946,
    1568.609985,
    1587.72998,
    1593.369995,
    1588.849976,
    1552.359985,
    1574.569946,
    1552.01001,
    1541.609985,
    1555.25,
    1562.5,
    1578.780029,
    1578.790039,
    1585.160034,
    1582.23999,
    1593.609985,
    1597.569946,
    1582.699951,
    1597.589966,
    1614.420044,
    1617.5,
    1625.959961,
    1632.689941,
    1626.670044,
    1633.699951,
    1633.77002,
    1650.339966,
    1658.780029,
    1650.469971,
    1667.469971,
    1666.290039,
    1669.160034,
    1655.349976,
    1650.51001,
    1649.599976,
    1660.060059,
    1648.359985,
    1654.410034,
    1630.73999,
    1640.420044,
    1631.380005,
    1608.900024,
    1622.560059,
    1643.380005,
    1642.810059,
    1626.130005,
    1612.52002,
    1636.359985,
    1626.72998,
    1639.040039,
    1651.810059,
    1628.930054,
    1588.189941,
    1592.430054,
    1573.089966,
    1588.030029,
    1603.26001,
    1613.199951,
    1606.280029,
    1614.959961,
    1614.079956,
    1615.410034,
    1631.890015,
    1640.459961,
    1652.319946,
    1652.619995,
    1675.02002,
    1680.189941,
    1682.5,
    1676.26001,
    1680.910034,
    1689.369995,
    1692.089966,
    1695.530029,
    1692.390015,
    1685.939941,
    1690.25,
    1691.650024,
    1685.329956,
    1685.959961,
    1685.72998,
    1706.869995,
    1709.670044,
    1707.140015,
    1697.369995,
    1690.910034,
    1697.47998,
    1691.420044,
    1689.469971,
    1694.160034,
    1685.390015,
    1661.319946,
    1655.829956,
    1646.060059,
    1652.349976,
    1642.800049,
    1656.959961,
    1663.5,
    1656.780029,
    1630.47998,
    1634.959961,
    1638.170044,
    1632.969971,
    1639.77002,
    1653.079956,
    1655.079956,
    1655.170044,
    1671.709961,
    1683.98999,
    1689.130005,
    1683.420044,
    1687.98999,
    1697.599976,
    1704.76001,
    1725.52002,
    1722.339966,
    1709.910034,
    1701.839966,
    1697.420044,
    1692.77002,
    1698.670044,
    1691.75,
    1681.550049,
    1695,
    1693.869995,
    1678.660034,
    1690.5,
    1676.119995,
    1655.449951,
    1656.400024,
    1692.560059,
    1703.199951,
    1710.140015,
    1698.060059,
    1721.540039,
    1733.150024,
    1744.5,
    1744.660034,
    1754.670044,
    1746.380005,
    1752.069946,
    1759.77002,
    1762.109985,
    1771.949951,
    1763.310059,
    1756.540039,
    1761.640015,
    1767.930054,
    1762.969971,
    1770.48999,
    1747.150024,
    1770.609985,
    1771.890015,
    1767.689941,
    1782,
    1790.619995,
    1798.180054,
    1791.530029,
    1787.869995,
    1781.369995,
    1795.849976,
    1804.76001,
    1802.47998,
    1802.75,
    1807.22998,
    1805.810059,
    1800.900024,
    1795.150024,
    1792.810059,
    1785.030029,
    1805.089966,
    1808.369995,
    1802.619995,
    1782.219971,
    1775.5,
    1775.319946,
    1786.540039,
    1781,
    1810.650024,
    1809.599976,
    1818.319946,
    1827.98999,
    1833.319946,
    1842.02002,
    1841.400024,
    1841.069946,
    1848.359985,
    1831.97998,
    1831.369995,
    1826.77002,
    1837.880005,
    1837.48999,
    1838.130005,
    1842.369995,
    1819.199951,
    1838.880005,
    1848.380005,
    1845.890015,
    1838.699951,
    1843.800049,
    1844.859985,
    1828.459961,
    1790.290039,
    1781.560059,
    1792.5,
    1774.199951,
    1794.189941,
    1782.589966,
    1741.890015,
    1755.199951,
    1751.640015,
    1773.430054,
    1797.02002,
    1799.839966,
    1819.75,
    1819.26001,
    1829.829956,
    1838.630005,
    1840.76001,
    1828.75,
    1839.780029,
    1836.25,
    1847.609985,
    1845.119995,
    1845.160034,
    1854.290039,
    1859.449951,
    1845.72998,
    1873.910034,
    1873.810059,
    1877.030029,
    1878.040039,
    1877.170044,
    1867.630005,
    1868.199951,
    1846.339966,
    1841.130005,
    1858.829956,
    1872.25,
    1860.77002,
    1872.01001,
    1866.52002,
    1857.439941,
    1865.619995,
    1852.560059,
    1849.040039,
    1857.619995,
    1872.339966,
    1885.52002,
    1890.900024,
    1888.77002,
    1865.089966,
    1845.040039,
    1851.959961,
    1872.180054,
    1833.079956,
    1815.689941,
    1830.609985,
    1842.97998,
    1862.310059,
    1864.849976,
    1871.890015,
    1879.550049,
    1875.390015,
    1878.609985,
    1863.400024,
    1869.430054,
    1878.329956,
    1883.949951,
    1883.680054,
    1881.140015,
    1884.660034,
    1867.719971,
    1878.209961,
    1875.630005,
    1878.47998,
    1896.650024,
    1897.449951,
    1888.530029,
    1870.849976,
    1877.859985,
    1885.079956,
    1872.829956,
    1888.030029,
    1892.48999,
    1900.530029,
    1911.910034,
    1909.780029,
    1920.030029,
    1923.569946,
    1924.969971,
    1924.23999,
    1927.880005,
    1940.459961,
    1949.439941,
    1951.27002,
    1950.790039,
    1943.890015,
    1930.109985,
    1936.160034,
    1937.780029,
    1941.98999,
    1956.97998,
    1959.47998,
    1962.869995,
    1962.609985,
    1949.97998,
    1959.530029,
    1957.219971,
    1960.959961,
    1960.22998,
    1973.319946,
    1974.619995,
    1985.439941,
    1977.650024,
    1963.709961,
    1972.829956,
    1964.680054,
    1967.569946,
    1977.099976,
    1973.280029,
    1981.569946,
    1958.119995,
    1978.219971,
    1973.630005,
    1983.530029,
    1987.01001,
    1987.97998,
    1978.339966,
    1978.910034,
    1969.949951,
    1970.069946,
    1930.670044,
    1925.150024,
    1938.98999,
    1920.209961,
    1920.23999,
    1909.569946,
    1931.589966,
    1936.920044,
    1933.75,
    1946.719971,
    1955.180054,
    1955.060059,
    1971.73999,
    1981.599976,
    1986.51001,
    1992.369995,
    1988.400024,
    1997.920044,
    2000.02002,
    2000.119995,
    1996.73999,
    2003.369995,
    2002.280029,
    2000.719971,
    1997.650024,
    2007.709961,
    2001.540039,
    1988.439941,
    1995.689941,
    1997.449951,
    1985.540039,
    1984.130005,
    1998.97998,
    2001.569946,
    2011.359985,
    2010.400024,
    1994.290039,
    1982.77002,
    1998.300049,
    1965.98999,
    1982.849976,
    1977.800049,
    1972.290039,
    1946.160034,
    1946.170044,
    1967.900024,
    1964.819946,
    1935.099976,
    1968.890015,
    1928.209961,
    1906.130005,
    1874.73999,
    1877.699951,
    1862.48999,
    1862.76001,
    1886.76001,
    1904.01001,
    1941.280029,
    1927.109985,
    1950.819946,
    1964.579956,
    1961.630005,
    1985.050049,
    1982.300049,
    1994.650024,
    2018.050049,
    2017.810059,
    2012.099976,
    2023.569946,
    2031.209961,
    2031.920044,
    2038.26001,
    2039.680054,
    2038.25,
    2039.329956,
    2039.819946,
    2041.319946,
    2051.800049,
    2048.719971,
    2052.75,
    2063.5,
    2069.409912,
    2067.030029,
    2072.830078,
    2067.560059,
    2053.439941,
    2066.550049,
    2074.330078,
    2071.919922,
    2075.370117,
    2060.310059,
    2059.820068,
    2026.140015,
    2035.329956,
    2002.329956,
    1989.630005,
    1972.73999,
    2012.890015,
    2061.22998,
    2070.649902,
    2078.540039,
    2082.169922,
    2081.879883,
    2088.77002,
    2090.570068,
    2080.350098,
    2058.899902,
    2058.199951,
    2020.579956,
    2002.609985,
    2025.900024,
    2062.139893,
    2044.810059,
    2028.26001,
    2023.030029,
    2011.27002,
    1992.670044,
    2019.420044,
    2022.550049,
    2032.119995,
    2063.149902,
    2051.820068,
    2057.090088,
    2029.550049,
    2002.160034,
    2021.25,
    1994.98999,
    2020.849976,
    2050.030029,
    2041.51001,
    2062.52002,
    2055.469971,
    2046.73999,
    2068.590088,
    2068.530029,
    2088.47998,
    2096.98999,
    2100.340088,
    2099.679932,
    2097.449951,
    2110.300049,
    2109.659912,
    2115.47998,
    2113.860107,
    2110.73999,
    2104.5,
    2117.389893,
    2107.780029,
    2098.530029,
    2101.040039,
    2071.26001,
    2079.429932,
    2044.160034,
    2040.23999,
    2065.949951,
    2053.399902,
    2081.189941,
    2074.280029,
    2099.5,
    2089.27002,
    2108.100098,
    2104.419922,
    2091.5,
    2061.050049,
    2056.149902,
    2061.02002,
    2086.23999,
    2067.889893,
    2059.689941,
    2066.959961,
    2080.620117,
    2076.330078,
    2081.899902,
    2091.179932,
    2102.060059,
    2092.429932,
    2095.840088,
    2106.629883,
    2104.98999,
    2081.179932,
    2100.399902,
    2097.290039,
    2107.959961,
    2112.929932,
    2117.689941,
    2108.919922,
    2114.76001,
    2106.850098,
    2085.51001,
    2108.290039,
    2114.48999,
    2089.459961,
    2080.149902,
    2088,
    2116.100098,
    2105.330078,
    2099.120117,
    2098.47998,
    2121.100098,
    2122.72998,
    2129.199951,
    2127.830078,
    2125.850098,
    2130.820068,
    2126.060059,
    2104.199951,
    2123.47998,
    2120.790039,
    2107.389893,
    2111.72998,
    2109.600098,
    2114.070068,
    2095.840088,
    2092.830078,
    2079.280029,
    2080.149902,
    2105.199951,
    2108.860107,
    2094.110107,
    2084.429932,
    2096.290039,
    2100.439941,
    2121.23999,
    2109.98999,
    2122.850098,
    2124.199951,
    2108.580078,
    2102.310059,
    2101.48999,
    2057.639893,
    2063.110107,
    2077.419922,
    2076.780029,
    2068.76001,
    2081.340088,
    2046.680054,
    2051.310059,
    2076.620117,
    2099.600098,
    2108.949951,
    2107.399902,
    2124.290039,
    2126.639893,
    2128.280029,
    2119.209961,
    2114.149902,
    2102.149902,
    2079.649902,
    2067.639893,
    2093.25,
    2108.570068,
    2108.629883,
    2103.840088,
    2098.040039,
    2093.320068,
    2099.840088,
    2083.560059,
    2077.570068,
    2104.179932,
    2084.070068,
    2086.050049,
    2083.389893,
    2091.540039,
    2102.439941,
    2096.919922,
    2079.610107,
    2035.72998,
    1970.890015,
    1893.209961,
    1867.609985,
    1940.51001,
    1987.660034,
    1988.869995,
    1972.180054,
    1913.849976,
    1948.859985,
    1951.130005,
    1921.219971,
    1969.410034,
    1942.040039,
    1952.290039,
    1961.050049,
    1953.030029,
    1978.089966,
    1995.310059,
    1990.199951,
    1958.030029,
    1966.969971,
    1942.73999,
    1938.76001,
    1932.23999,
    1931.339966,
    1881.77002,
    1884.089966,
    1920.030029,
    1923.819946,
    1951.359985,
    1987.050049,
    1979.920044,
    1995.829956,
    2013.430054,
    2014.890015,
    2017.459961,
    2003.689941,
    1994.23999,
    2023.859985,
    2033.109985,
    2033.660034,
    2030.77002,
    2018.939941,
    2052.51001,
    2075.149902,
    2071.179932,
    2065.889893,
    2090.350098,
    2089.409912,
    2079.360107,
    2104.050049,
    2109.790039,
    2102.310059,
    2099.929932,
    2099.199951,
    2078.580078,
    2081.719971,
    2075,
    2045.969971,
    2023.040039,
    2053.189941,
    2050.439941,
    2083.580078,
    2081.23999,
    2089.169922,
    2086.590088,
    2089.139893,
    2088.870117,
    2090.110107,
    2080.409912,
    2102.629883,
    2079.51001,
    2049.620117,
    2091.689941,
    2077.070068,
    2063.590088,
    2047.619995,
    2052.22998,
    2012.369995,
    2021.939941,
    2043.410034,
    2073.070068,
    2041.890015,
    2005.550049,
    2021.150024,
    2038.969971,
    2064.290039,
    2060.98999,
    2056.5,
    2078.360107,
    2063.360107,
    2043.939941,
    2012.660034,
    2016.709961,
    1990.26001,
    1943.089966,
    1922.030029,
    1923.670044,
    1938.680054,
    1890.280029,
    1921.839966,
    1880.329956,
    1881.329956,
    1859.329956,
    1868.98999,
    1906.900024,
    1877.079956,
    1903.630005,
    1882.949951,
    1893.359985,
    1940.23999,
    1939.380005,
    1903.030029,
    1912.530029,
    1915.449951,
    1880.050049,
    1853.439941,
    1852.209961,
    1851.859985,
    1829.079956,
    1864.780029,
    1895.579956,
    1926.819946,
    1917.829956,
    1917.780029,
    1945.5,
    1921.27002,
    1929.800049,
    1951.699951,
    1948.050049,
    1932.22998,
    1978.349976,
    1986.449951,
    1993.400024,
    1999.98999,
    2001.76001,
    1979.26001,
    1989.26001,
    1989.569946,
    2022.189941,
    2019.640015,
    2015.930054,
    2027.219971,
    2040.589966,
    2049.580078,
    2051.600098,
    2049.800049,
    2036.709961,
    2035.939941,
    2037.050049,
    2055.01001,
    2063.949951,
    2059.73999,
    2072.780029,
    2066.129883,
    2045.170044,
    2066.659912,
    2041.910034,
    2047.599976,
    2041.98999,
    2061.719971,
    2082.419922,
    2082.780029,
    2080.72998,
    2094.340088,
    2100.800049,
    2102.399902,
    2091.47998,
    2091.580078,
    2087.790039,
    2091.699951,
    2095.149902,
    2075.810059,
    2065.300049,
    2081.429932,
    2063.370117,
    2051.120117,
    2050.629883,
    2057.139893,
    2058.689941,
    2084.389893,
    2064.459961,
    2064.110107,
    2046.609985,
    2066.659912,
    2047.209961,
    2047.630005,
    2040.040039,
    2052.320068,
    2048.040039,
    2076.060059,
    2090.540039,
    2090.100098,
    2099.060059,
    2096.949951,
    2099.330078,
    2105.26001,
    2099.129883,
    2109.409912,
    2112.129883,
    2119.120117,
    2115.47998,
    2096.070068,
    2079.060059,
    2075.320068,
    2071.5,
    2077.98999,
    2071.219971,
    2083.25,
    2088.899902,
    2085.449951,
    2113.320068,
    2037.410034,
    2000.540039,
    2036.089966,
    2070.77002,
    2098.860107,
    2102.949951,
    2088.550049,
    2099.72998,
    2097.899902,
    2129.899902,
    2137.159912,
    2152.139893,
    2152.429932,
    2163.75,
    2161.73999,
    2166.889893,
    2163.780029,
    2173.02002,
    2165.169922,
    2175.030029,
    2168.47998,
    2169.179932,
    2166.580078,
    2170.060059,
    2173.600098,
    2170.840088,
    2157.030029,
    2163.790039,
    2164.25,
    2182.870117,
    2180.889893,
    2181.73999,
    2175.48999,
    2185.790039,
    2184.050049,
    2190.149902,
    2178.149902,
    2182.219971,
    2187.02002,
    2183.870117,
    2182.639893,
    2186.899902,
    2175.439941,
    2172.469971,
    2169.040039,
    2180.379883,
    2176.120117,
    2170.949951,
    2170.860107,
    2179.97998,
    2186.47998,
    2186.159912,
    2181.300049,
    2127.810059,
    2159.040039,
    2127.02002,
    2125.77002,
    2147.26001,
    2139.159912,
    2139.120117,
    2139.76001,
    2163.120117,
    2177.179932,
    2164.689941,
    2146.100098,
    2159.929932,
    2171.370117,
    2151.129883,
    2168.27002,
    2161.199951,
    2150.48999,
    2159.72998,
    2160.77002,
    2153.73999,
    2163.659912,
    2136.72998,
    2139.179932,
    2132.550049,
    2132.97998,
    2126.5,
    2139.600098,
    2144.290039,
    2141.340088,
    2141.159912,
    2151.330078,
    2143.159912,
    2139.429932,
    2133.040039,
    2126.409912,
    2126.149902,
    2111.719971,
    2097.939941,
    2088.659912,
    2085.179932,
    2131.52002,
    2139.560059,
    2163.26001,
    2167.47998,
    2164.449951,
    2164.199951,
    2180.389893,
    2176.939941,
    2187.120117,
    2181.899902,
    2198.179932,
    2202.939941,
    2204.719971,
    2213.350098,
    2201.719971,
    2204.659912,
    2198.810059,
    2191.080078,
    2191.949951,
    2204.709961,
    2212.22998,
    2241.350098,
    2246.189941,
    2259.530029,
    2256.959961,
    2271.719971,
    2253.280029,
    2262.030029,
    2258.070068,
    2262.530029,
    2270.76001,
    2265.179932,
    2260.959961,
    2263.790039,
    2268.879883,
    2249.919922,
    2249.26001,
    2238.830078,
    2257.830078,
    2270.75,
    2269,
    2276.97998,
    2268.899902,
    2268.899902,
    2275.320068,
    2270.439941,
    2274.639893,
    2267.889893,
    2271.889893,
    2263.689941,
    2271.310059,
    2265.199951,
    2280.070068,
    2298.370117,
    2296.679932,
    2294.689941,
    2280.899902,
    2278.870117,
    2279.550049,
    2280.850098,
    2297.419922,
    2292.560059,
    2293.080078,
    2294.669922,
    2307.870117,
    2316.100098,
    2328.25,
    2337.580078,
    2349.25,
    2347.219971,
    2351.159912,
    2365.379883,
    2362.820068,
    2363.810059,
    2367.340088,
    2369.75,
    2363.639893,
    2395.959961,
    2381.919922,
    2383.120117,
    2375.310059,
    2368.389893,
    2362.97998,
    2364.870117,
    2372.600098,
    2373.469971,
    2365.449951,
    2385.26001,
    2381.379883,
    2378.25,
    2373.469971,
    2344.02002,
    2348.449951,
    2345.959961,
    2343.97998,
    2341.590088,
    2358.570068,
    2361.129883,
    2368.060059,
    2362.719971,
    2358.840088,
    2360.159912,
    2352.949951,
    2357.48999,
    2355.540039,
    2357.159912,
    2353.780029,
    2344.929932,
    2328.949951,
    2349.01001,
    2342.189941,
    2338.169922,
    2355.840088,
    2348.689941,
    2374.149902,
    2388.610107,
    2387.449951,
    2388.77002,
    2384.199951,
    2388.330078,
    2391.169922,
    2388.129883,
    2389.52002,
    2399.290039,
    2399.379883,
    2396.919922,
    2399.629883,
    2394.439941,
    2390.899902,
    2402.320068,
    2400.669922,
    2357.030029,
    2365.719971,
    2381.72998,
    2394.02002,
    2398.419922,
    2404.389893,
    2415.070068,
    2415.820068,
    2412.909912,
    2411.800049,
    2430.060059,
    2439.070068,
    2436.100098,
    2429.330078,
    2433.139893,
    2433.790039,
    2431.77002,
    2429.389893,
    2440.350098,
    2437.919922,
    2432.459961,
    2433.149902,
    2453.459961,
    2437.030029,
    2435.610107,
    2434.5,
    2438.300049,
    2439.070068,
    2419.379883,
    2440.689941,
    2419.699951,
    2423.409912,
    2429.01001,
    2432.540039,
    2409.75,
    2425.179932,
    2427.429932,
    2425.530029,
    2443.25,
    2447.830078,
    2459.27002,
    2459.139893,
    2460.610107,
    2473.830078,
    2473.449951,
    2472.540039,
    2469.909912,
    2477.129883,
    2477.830078,
    2475.419922,
    2472.100098,
    2470.300049,
    2476.350098,
    2477.570068,
    2472.159912,
    2476.830078,
    2480.909912,
    2474.919922,
    2474.02002,
    2438.209961,
    2441.320068,
    2465.840088,
    2464.610107,
    2468.110107,
    2430.01001,
    2425.550049,
    2428.370117,
    2452.51001,
    2444.040039,
    2438.969971,
    2443.050049,
    2444.23999,
    2446.300049,
    2457.590088,
    2471.649902,
    2476.550049,
    2457.850098,
    2465.540039,
    2465.100098,
    2461.429932,
    2488.110107,
    2496.47998,
    2498.370117,
    2495.620117,
    2500.22998,
    2503.870117,
    2506.649902,
    2508.23999,
    2500.600098,
    2502.219971,
    2496.659912,
    2496.840088,
    2507.040039,
    2510.060059,
    2519.360107,
    2529.120117,
    2534.580078,
    2537.73999,
    2552.070068,
    2549.330078,
    2544.72998,
    2550.639893,
    2555.23999,
    2550.929932,
    2553.169922,
    2557.639893,
    2559.360107,
    2561.26001,
    2562.100098,
    2575.209961,
    2564.97998,
    2569.129883,
    2557.149902,
    2560.399902,
    2581.070068,
    2572.830078,
    2575.26001,
    2579.360107,
    2579.850098,
    2587.840088,
    2591.129883,
    2590.639893,
    2594.379883,
    2584.620117,
    2582.300049,
    2584.840088,
    2578.870117,
    2564.620117,
    2585.639893,
    2578.850098,
    2582.139893,
    2599.030029,
    2597.080078,
    2602.419922,
    2601.419922,
    2627.040039,
    2626.070068,
    2647.580078,
    2642.219971,
    2639.439941,
    2629.570068,
    2629.27002,
    2636.97998,
    2651.5,
    2659.98999,
    2664.110107,
    2662.850098,
    2652.01001,
    2675.810059,
    2690.159912,
    2681.469971,
    2679.25,
    2684.570068,
    2683.340088,
    2680.5,
    2682.620117,
    2687.540039,
    2673.610107,
    2695.810059,
    2713.060059,
    2723.98999,
    2743.149902,
    2747.709961,
    2751.290039,
    2748.22998,
    2767.560059,
    2786.23999,
    2776.419922,
    2802.560059,
    2798.030029,
    2810.300049,
    2832.969971,
    2839.129883,
    2837.540039,
    2839.25,
    2872.870117,
    2853.530029,
    2822.429932,
    2823.810059,
    2821.97998,
    2762.129883,
    2648.939941,
    2695.139893,
    2681.659912,
    2581,
    2619.550049,
    2656,
    2662.939941,
    2698.629883,
    2731.199951,
    2732.219971,
    2716.26001,
    2701.330078,
    2703.959961,
    2747.300049,
    2779.600098,
    2744.280029,
    2713.830078,
    2677.669922,
    2691.25,
    2720.939941,
    2728.120117,
    2726.800049,
    2738.969971,
    2786.570068,
    2783.02002,
    2765.310059,
    2749.47998,
    2747.330078,
    2752.01001,
    2712.919922,
    2716.939941,
    2711.929932,
    2643.689941,
    2588.26001,
    2658.550049,
    2612.620117,
    2605,
    2640.870117,
    2581.879883,
    2614.449951,
    2644.689941,
    2662.840088,
    2604.469971,
    2613.159912,
    2656.870117,
    2642.189941,
    2663.98999,
    2656.300049,
    2677.840088,
    2706.389893,
    2708.639893,
    2693.129883,
    2670.139893,
    2670.290039,
    2634.560059,
    2639.399902,
    2666.939941,
    2669.909912,
    2648.050049,
    2654.800049,
    2635.669922,
    2629.72998,
    2663.419922,
    2672.629883,
    2671.919922,
    2697.790039,
    2723.070068,
    2727.719971,
    2730.129883,
    2711.449951,
    2722.459961,
    2720.129883,
    2712.969971,
    2733.01001,
    2724.439941,
    2733.290039,
    2727.76001,
    2721.330078,
    2689.860107,
    2724.01001,
    2705.27002,
    2734.620117,
    2746.870117,
    2748.800049,
    2772.350098,
    2770.370117,
    2779.030029,
    2782,
    2786.850098,
    2775.629883,
    2782.48999,
    2779.659912,
    2773.75,
    2762.590088,
    2767.320068,
    2749.76001,
    2754.879883,
    2717.070068,
    2723.060059,
    2699.629883,
    2716.310059,
    2718.370117,
    2726.709961,
    2713.219971,
    2736.610107,
    2759.820068,
    2784.169922,
    2793.840088,
    2774.02002,
    2798.290039,
    2801.310059,
    2798.429932,
    2809.550049,
    2815.620117,
    2804.48999,
    2801.830078,
    2806.97998,
    2820.399902,
    2846.070068,
    2837.439941,
    2818.820068,
    2802.600098,
    2816.290039,
    2813.360107,
    2827.219971,
    2840.350098,
    2850.399902,
    2858.449951,
    2857.699951,
    2853.580078,
    2833.280029,
    2821.929932,
    2839.959961,
    2818.370117,
    2840.689941,
    2850.129883,
    2857.050049,
    2862.959961,
    2861.820068,
    2856.97998,
    2874.689941,
    2896.73999,
    2897.52002,
    2914.040039,
    2901.129883,
    2901.52002,
    2896.719971,
    2888.600098,
    2878.050049,
    2871.679932,
    2877.129883,
    2887.889893,
    2888.919922,
    2904.179932,
    2904.97998,
    2888.800049,
    2904.310059,
    2907.949951,
    2930.75,
    2929.669922,
    2919.370117,
    2915.560059,
    2905.969971,
    2914,
    2913.97998,
    2924.590088,
    2923.429932,
    2925.51001,
    2901.610107,
    2885.570068,
    2884.429932,
    2880.340088,
    2785.679932,
    2728.370117,
    2767.129883,
    2750.790039,
    2809.919922,
    2809.209961,
    2768.780029,
    2767.780029,
    2755.879883,
    2740.689941,
    2656.100098,
    2705.570068,
    2658.689941,
    2641.25,
    2682.629883,
    2711.73999,
    2740.370117,
    2723.060059,
    2738.310059,
    2755.449951,
    2813.889893,
    2806.830078,
    2781.01001,
    2726.219971,
    2722.179932,
    2701.580078,
    2730.199951,
    2736.27002,
    2690.72998,
    2641.889893,
    2649.929932,
    2632.560059,
    2673.449951,
    2682.169922,
    2743.790039,
    2737.800049,
    2760.169922,
    2790.370117,
    2700.060059,
    2695.949951,
    2633.080078,
    2637.719971,
    2636.780029,
    2651.070068,
    2650.540039,
    2599.949951,
    2545.939941,
    2546.159912,
    2506.959961,
    2467.419922,
    2416.620117,
    2351.100098,
    2467.699951,
    2488.830078,
    2485.73999,
    2506.850098,
    2510.030029,
    2447.889893,
    2531.939941,
    2549.689941,
    2574.409912,
    2584.959961,
    2596.639893,
    2596.26001,
    2582.610107,
    2610.300049,
    2616.100098,
    2635.959961,
    2670.709961,
    2632.899902,
    2638.699951,
    2642.330078,
    2664.76001,
    2643.850098,
    2640,
    2681.050049,
    2704.100098,
    2706.530029,
    2724.870117,
    2737.699951,
    2731.610107,
    2706.050049,
    2707.879883,
    2709.800049,
    2744.72998,
    2753.030029,
    2745.72998,
    2775.600098,
    2779.76001,
    2784.699951,
    2774.879883,
    2792.669922,
    2796.110107,
    2793.899902,
    2792.379883,
    2784.48999,
    2803.689941,
    2792.810059,
    2789.649902,
    2771.449951,
    2748.929932,
    2743.070068,
    2783.300049,
    2791.52002,
    2810.919922,
    2808.47998,
    2822.47998,
    2832.939941,
    2832.570068,
    2824.22998,
    2854.879883,
    2800.709961,
    2798.360107,
    2818.459961,
    2805.370117,
    2815.439941,
    2834.399902,
    2867.189941,
    2867.23999,
    2873.399902,
    2879.389893,
    2892.73999,
    2895.77002,
    2878.199951,
    2888.209961,
    2888.320068,
    2907.409912,
    2905.580078,
    2907.060059,
    2900.449951,
    2905.030029,
    2907.969971,
    2933.679932,
    2927.25,
    2926.169922,
    2939.879883,
    2943.030029,
    2945.830078,
    2923.72998,
    2917.52002,
    2945.639893,
    2932.469971,
    2884.050049,
    2879.419922,
    2870.719971,
    2881.399902,
    2811.870117,
    2834.409912,
    2850.959961,
    2876.320068,
    2859.530029,
    2840.22998,
    2864.360107,
    2856.27002,
    2822.23999,
    2826.060059,
    2802.389893,
    2783.02002,
    2788.860107,
    2752.060059,
    2744.449951,
    2803.27002,
    2826.149902,
    2843.48999,
    2873.340088,
    2886.72998,
    2885.719971,
    2879.840088,
    2891.639893,
    2886.97998,
    2889.669922,
    2917.75,
    2926.459961,
    2954.179932,
    2950.459961,
    2945.350098,
    2917.379883,
    2913.780029,
    2924.919922,
    2941.76001,
    2964.330078,
    2973.01001,
    2995.820068,
    2990.409912,
    2975.949951,
    2979.629883,
    2993.070068,
    2999.909912,
    3013.77002,
    3014.300049,
    3004.040039,
    2984.419922,
    2995.110107,
    2976.610107,
    2985.030029,
    3005.469971,
    3019.560059,
    3003.669922,
    3025.860107,
    3020.969971,
    3013.179932,
    2980.379883,
    2953.560059,
    2932.050049,
    2844.73999,
    2881.77002,
    2883.97998,
    2938.090088,
    2918.649902,
    2882.699951,
    2926.320068,
    2840.600098,
    2847.600098,
    2888.679932,
    2923.649902,
    2900.51001,
    2924.429932,
    2922.949951,
    2847.110107,
    2878.379883,
    2869.159912,
    2887.939941,
    2924.580078,
    2926.459961,
    2906.27002,
    2937.780029,
    2976,
    2978.709961,
    2978.429932,
    2979.389893,
    3000.929932,
    3009.570068,
    3007.389893,
    2997.959961,
    3005.699951,
    3006.72998,
    3006.790039,
    2992.070068,
    2991.780029,
    2966.600098,
    2984.870117,
    2977.620117,
    2961.790039,
    2976.73999,
    2940.25,
    2887.610107,
    2910.629883,
    2952.01001,
    2938.790039,
    2893.060059,
    2919.399902,
    2938.129883,
    2970.27002,
    2966.149902,
    2995.679932,
    2989.689941,
    2997.949951,
    2986.199951,
    3006.719971,
    2995.98999,
    3004.52002,
    3010.290039,
    3022.550049,
    3039.419922,
    3036.889893,
    3046.77002,
    3037.560059,
    3066.909912,
    3078.27002,
    3074.620117,
    3076.780029,
    3085.179932,
    3093.080078,
    3087.01001,
    3091.840088,
    3094.040039,
    3096.629883,
    3120.459961,
    3122.030029,
    3120.179932,
    3108.459961,
    3103.540039,
    3110.290039,
    3133.639893,
    3140.52002,
    3153.629883,
    3140.97998,
    3113.870117,
    3093.199951,
    3112.76001,
    3117.429932,
    3145.909912,
    3135.959961,
    3132.52002,
    3141.629883,
    3168.570068,
    3168.800049,
    3191.449951,
    3192.52002,
    3191.139893,
    3205.370117,
    3221.219971,
    3224.01001,
    3223.379883,
    3239.909912,
    3240.02002,
    3221.290039,
    3230.780029,
    3257.850098,
    3234.850098,
    3246.280029,
    3237.179932,
    3253.050049,
    3274.699951,
    3265.350098,
    3288.129883,
    3283.149902,
    3289.290039,
    3316.810059,
    3329.620117,
    3320.790039,
    3321.75,
    3325.540039,
    3295.469971,
    3243.629883,
    3276.23999,
    3273.399902,
    3283.659912,
    3225.52002,
    3248.919922,
    3297.590088,
    3334.689941,
    3345.780029,
    3327.709961,
    3352.090088,
    3357.75,
    3379.449951,
    3373.939941,
    3380.159912,
    3370.290039,
    3386.149902,
    3373.22998,
    3337.75,
    3225.889893,
    3128.209961,
    3116.389893,
    2978.76001,
    2954.219971,
    3090.22998,
    3003.370117,
    3130.120117,
    3023.939941,
    2972.370117,
    2746.560059,
    2882.22998,
    2741.379883,
    2480.639893,
    2711.02002,
    2386.129883,
    2529.189941,
    2398.100098,
    2409.389893,
    2304.919922,
    2237.399902,
    2447.330078,
    2475.560059,
    2630.070068,
    2541.469971,
    2626.649902,
    2584.590088,
    2470.5,
    2526.899902,
    2488.649902,
    2663.679932,
    2659.409912,
    2749.97998,
    2789.820068,
    2761.629883,
    2846.060059,
    2783.360107,
    2799.550049,
    2874.560059,
    2823.159912,
    2736.560059,
    2799.310059,
    2797.800049,
    2836.73999,
    2878.47998,
    2863.389893,
    2939.51001,
    2912.429932,
    2830.709961,
    2842.73999,
    2868.439941,
    2848.419922,
    2881.189941,
    2929.800049,
    2930.189941,
    2870.120117,
    2820,
    2852.5,
    2863.699951,
    2953.909912,
    2922.939941,
    2971.610107,
    2948.51001,
    2955.449951,
    2991.77002,
    3036.129883,
    3029.72998,
    3044.310059,
    3055.72998,
    3080.820068,
    3122.870117,
    3112.350098,
    3193.929932,
    3232.389893,
    3207.179932,
    3190.139893,
    3002.100098,
    3041.310059,
    3066.590088,
    3124.73999,
    3113.48999,
    3115.340088,
    3097.73999,
    3117.860107,
    3131.290039,
    3050.330078,
]).reshape((2517,))
