# hendrycks_test

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/hendrycks_test)
*   [Huggingface](https://huggingface.co/datasets/hendrycks_test)


## abstract_algebra


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/abstract_algebra')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## anatomy


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/anatomy')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 135
`'validation'` | 14

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## astronomy


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/astronomy')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 152
`'validation'` | 16

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## business_ethics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/business_ethics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## clinical_knowledge


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/clinical_knowledge')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 265
`'validation'` | 29

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## college_biology


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/college_biology')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 144
`'validation'` | 16

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## college_chemistry


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/college_chemistry')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 8

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## college_computer_science


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/college_computer_science')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## college_mathematics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/college_mathematics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## college_medicine


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/college_medicine')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 173
`'validation'` | 22

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## college_physics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/college_physics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 102
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## computer_security


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/computer_security')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## conceptual_physics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/conceptual_physics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 235
`'validation'` | 26

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## econometrics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/econometrics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 114
`'validation'` | 12

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## electrical_engineering


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/electrical_engineering')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 145
`'validation'` | 16

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## elementary_mathematics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/elementary_mathematics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 378
`'validation'` | 41

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## formal_logic


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/formal_logic')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 126
`'validation'` | 14

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## global_facts


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/global_facts')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 10

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_biology


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_biology')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 310
`'validation'` | 32

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_chemistry


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_chemistry')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 203
`'validation'` | 22

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_computer_science


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_computer_science')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 9

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_european_history


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_european_history')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 165
`'validation'` | 18

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_geography


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_geography')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 198
`'validation'` | 22

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_government_and_politics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_government_and_politics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 193
`'validation'` | 21

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_macroeconomics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_macroeconomics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 390
`'validation'` | 43

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_mathematics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_mathematics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 270
`'validation'` | 29

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_microeconomics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_microeconomics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 238
`'validation'` | 26

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_physics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_physics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 151
`'validation'` | 17

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_psychology


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_psychology')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 545
`'validation'` | 60

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_statistics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_statistics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 216
`'validation'` | 23

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_us_history


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_us_history')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 204
`'validation'` | 22

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## high_school_world_history


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/high_school_world_history')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 237
`'validation'` | 26

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## human_aging


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/human_aging')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 223
`'validation'` | 23

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## human_sexuality


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/human_sexuality')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 131
`'validation'` | 12

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## international_law


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/international_law')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 121
`'validation'` | 13

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## jurisprudence


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/jurisprudence')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 108
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## logical_fallacies


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/logical_fallacies')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 163
`'validation'` | 18

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## machine_learning


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/machine_learning')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 112
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## management


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/management')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 103
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## marketing


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/marketing')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 234
`'validation'` | 25

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## medical_genetics


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/medical_genetics')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## miscellaneous


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/miscellaneous')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 783
`'validation'` | 86

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## moral_disputes


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/moral_disputes')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 346
`'validation'` | 38

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## moral_scenarios


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/moral_scenarios')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 895
`'validation'` | 100

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## nutrition


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/nutrition')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 306
`'validation'` | 33

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## philosophy


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/philosophy')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 311
`'validation'` | 34

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## prehistory


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/prehistory')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 324
`'validation'` | 35

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## professional_accounting


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/professional_accounting')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 282
`'validation'` | 31

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## professional_law


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/professional_law')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 1534
`'validation'` | 170

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## professional_medicine


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/professional_medicine')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 272
`'validation'` | 31

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## professional_psychology


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/professional_psychology')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 612
`'validation'` | 69

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## public_relations


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/public_relations')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 110
`'validation'` | 12

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## security_studies


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/security_studies')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 245
`'validation'` | 27

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## sociology


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/sociology')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 201
`'validation'` | 22

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## us_foreign_policy


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/us_foreign_policy')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 100
`'validation'` | 11

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## virology


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/virology')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 166
`'validation'` | 18

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## world_religions


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:hendrycks_test/world_religions')
```

*   **Description**:

```
This is a massive multitask test consisting of multiple-choice questions from various branches of knowledge, covering 57 tasks including elementary mathematics, US history, computer science, law, and more.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'auxiliary_train'` | 99842
`'dev'` | 5
`'test'` | 171
`'validation'` | 19

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "choices": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "answer": {
        "num_classes": 4,
        "names": [
            "A",
            "B",
            "C",
            "D"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```


