<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="wsc273" />
  <meta itemprop="description" content="WSC273 is a common sense reasoning benchmark that requires the system to read a sentence with an ambiguous pronoun and select the referent of that pronoun from two choices.&#10;It contains the first 273 examples from the Winograd Schema Challenge.&#10;A Winograd schema is a pair of sentences that differ in only one or two words and that contain an ambiguity that is resolved in opposite ways in the two sentences and requires the use of world knowledge and reasoning for its resolution.&#10;The schema takes its name from a well-known example by Terry Winograd: ``The city councilmen refused the demonstrators a permit because they [feared/advocated] violence.&#x27;&#x27;&#10;If the word is ``feared&#x27;&#x27;, then ``they&#x27;&#x27; presumably refers to the city council; if it is ``advocated&#x27;&#x27; then ``they&#x27;&#x27; presumably refers to the demonstrators.&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;wsc273&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/wsc273" />
  <meta itemprop="sameAs" content="https://cs.nyu.edu/faculty/davise/papers/WinogradSchemas/WS.html" />
  <meta itemprop="citation" content="@inproceedings{levesque2012winograd,&#10;  title={The winograd schema challenge},&#10;  author={Levesque, Hector and Davis, Ernest and Morgenstern, Leora},&#10;  booktitle={Thirteenth International Conference on the Principles of Knowledge Representation and Reasoning},&#10;  year={2012},&#10;  organization={Citeseer}&#10;}" />
</div>

# `wsc273`


*   **Description**:

WSC273 is a common sense reasoning benchmark that requires the system to read a
sentence with an ambiguous pronoun and select the referent of that pronoun from
two choices. It contains the first 273 examples from the Winograd Schema
Challenge. A Winograd schema is a pair of sentences that differ in only one or
two words and that contain an ambiguity that is resolved in opposite ways in the
two sentences and requires the use of world knowledge and reasoning for its
resolution. The schema takes its name from a well-known example by Terry
Winograd: `The city councilmen refused the demonstrators a permit because they
[feared/advocated] violence.'' If the word is`feared'', then `they'' presumably
refers to the city council; if it is`advocated'' then ``they'' presumably refers
to the demonstrators.

*   **Homepage**:
    [https://cs.nyu.edu/faculty/davise/papers/WinogradSchemas/WS.html](https://cs.nyu.edu/faculty/davise/papers/WinogradSchemas/WS.html)

*   **Source code**:
    [`tfds.text.wsc273.Wsc273`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/text/wsc273/wsc273.py)

*   **Versions**:

    *   **`1.0.0`** (default): No release notes.

*   **Download size**: `110.58 KiB`

*   **Dataset size**: `87.15 KiB`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    Yes

*   **Splits**:

Split    | Examples
:------- | -------:
`'test'` | 273

*   **Feature structure**:

```python
FeaturesDict({
    'idx': tf.int32,
    'label': tf.int32,
    'option1': Text(shape=(), dtype=tf.string),
    'option1_normalized': Text(shape=(), dtype=tf.string),
    'option2': Text(shape=(), dtype=tf.string),
    'option2_normalized': Text(shape=(), dtype=tf.string),
    'pronoun_end': tf.int32,
    'pronoun_start': tf.int32,
    'pronoun_text': Text(shape=(), dtype=tf.string),
    'text': Text(shape=(), dtype=tf.string),
})
```

*   **Feature documentation**:

Feature            | Class        | Shape | Dtype     | Description
:----------------- | :----------- | :---- | :-------- | :----------
                   | FeaturesDict |       |           |
idx                | Tensor       |       | tf.int32  |
label              | Tensor       |       | tf.int32  |
option1            | Text         |       | tf.string |
option1_normalized | Text         |       | tf.string |
option2            | Text         |       | tf.string |
option2_normalized | Text         |       | tf.string |
pronoun_end        | Tensor       |       | tf.int32  |
pronoun_start      | Tensor       |       | tf.int32  |
pronoun_text       | Text         |       | tf.string |
text               | Text         |       | tf.string |

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `None`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):
    Not supported.

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/wsc273-1.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

*   **Citation**:

```
@inproceedings{levesque2012winograd,
  title={The winograd schema challenge},
  author={Levesque, Hector and Davis, Ernest and Morgenstern, Leora},
  booktitle={Thirteenth International Conference on the Principles of Knowledge Representation and Reasoning},
  year={2012},
  organization={Citeseer}
}
```

