#!/usr/bin/env python

# Setup script for sql

__version__ = "$Revision: 1.9 $"[11:-2]
# $Source: /data/cvsroot/LivingLogic/Python/sql/setup.py,v $

from distutils.core import setup
import textwrap

DESCRIPTION = """
ll-sql provides classes for generating simple SQL insert, delete and update queries.
"""

CLASSIFIERS="""
Development Status :: 5 - Production/Stable
Intended Audience :: Developers
License :: OSI Approved :: Python License (CNRI Python License)
Operating System :: OS Independent
Programming Language :: Python
Topic :: Database
"""

KEYWORDS = """
SQL
query
database
"""

DESCRIPTION = "\n".join(textwrap.wrap(DESCRIPTION.strip(), width=64, replace_whitespace=True))

setup(
	name = "ll-sql",
	version = "0.6",
	description = "A module for generating SQL queries",
	long_description=DESCRIPTION,
	author = "Walter Doerwald",
	author_email = "walter@livinglogic.de",
	url = "http://www.livinglogic.de/Python/sql/",
	download_url = "http://www.livinglogic.de/Python/sql/Download.html",
	license = "Python",
	classifiers=CLASSIFIERS.strip().splitlines(),
	keywords=",".join(KEYWORDS.strip().splitlines()),
	py_modules = ['ll.sql', 'll.__init__'],
	package_dir={"ll": ""}
)
