# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, ADJ, NUM, DET, ADV, ADP, X, VERB, NOUN
from ...symbols import PROPN, PART, INTJ, PRON, SCONJ, AUX, CCONJ

TAG_MAP = {
    "ADJ_Abbr=Yes": {POS: ADJ, "Abbr": "Yes"},
    "ADJ_Degree=Pos|NumForm=Word|NumType=Ord": {
        POS: ADJ,
        "Degree": "Pos",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "ADJ_Degree=Pos": {POS: ADJ, "Degree": "Pos"},
    "ADJ_Degree=Pos|Style=Coll": {POS: ADJ, "Degree": "Pos", "Style": "Coll"},
    "ADJ_Degree=Pos|Style=Expr": {POS: ADJ, "Degree": "Pos", "Style": "Expr"},
    "ADJ_Degree=Sup": {POS: ADJ, "Degree": "Sup"},
    "ADJ_NumForm=Digit|NumType=Ord": {POS: ADJ, "NumForm": "Digit", "NumType": "Ord"},
    "ADJ_NumForm=Word|NumType=Card": {POS: ADJ, "NumForm": "Word", "NumType": "Card"},
    "ADJ_NumForm=Word|NumType=Ord": {POS: ADJ, "NumForm": "Word", "NumType": "Ord"},
    "ADJ_Style=Coll": {POS: ADJ, "Style": "Coll"},
    "ADJ_Style=Expr": {POS: ADJ, "Style": "Expr"},
    "ADP_AdpType=Post|Case=Dat": {POS: ADP, "AdpType": "Post", "Case": "Dat"},
    "ADP_AdpType=Post|Case=Nom": {POS: ADP, "AdpType": "Post", "Case": "Nom"},
    "ADP_AdpType=Post|Number=Plur|Person=3": {
        POS: ADP,
        "AdpType": "Post",
        "Number": "Plur",
        "Person": "3",
    },
    "ADP_AdpType=Post": {POS: ADP, "AdpType": "Post"},
    "ADP_AdpType=Prep": {POS: ADP, "AdpType": "Prep"},
    "ADP_AdpType=Prep|Style=Arch": {POS: ADP, "AdpType": "Prep", "Style": "Arch"},
    "ADV_Degree=Cmp": {POS: ADV, "Degree": "Cmp"},
    "ADV_Degree=Pos": {POS: ADV, "Degree": "Pos"},
    "ADV_Degree=Sup": {POS: ADV, "Degree": "Sup"},
    "ADV_Distance=Dist|PronType=Dem": {POS: ADV, "Distance": "Dist", "PronType": "Dem"},
    "ADV_Distance=Dist|PronType=Exc": {POS: ADV, "Distance": "Dist", "PronType": "Exc"},
    "ADV_Distance=Med|PronType=Dem": {POS: ADV, "Distance": "Med", "PronType": "Dem"},
    "ADV_Distance=Med|PronType=Dem|Style=Coll": {
        POS: ADV,
        "Distance": "Med",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "ADV_NumForm=Word|NumType=Card|PronType=Tot": {
        POS: ADV,
        "NumForm": "Word",
        "NumType": "Card",
        "PronType": "Tot",
    },
    "ADV_PronType=Dem": {POS: ADV, "PronType": "Dem"},
    "ADV_PronType=Exc": {POS: ADV, "PronType": "Exc"},
    "ADV_PronType=Ind": {POS: ADV, "PronType": "Ind"},
    "ADV_PronType=Int": {POS: ADV, "PronType": "Int"},
    "ADV_PronType=Int|Style=Coll": {POS: ADV, "PronType": "Int", "Style": "Coll"},
    "ADV_PronType=Rel": {POS: ADV, "PronType": "Rel"},
    "ADV_Style=Coll": {POS: ADV, "Style": "Coll"},
    "ADV_Style=Rare": {POS: ADV, "Style": "Rare"},
    "AUX_Aspect=Imp|Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "1",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "2",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Imp|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Neg",
        "Tense": "Imp",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Imp|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Tense": "Imp",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Tense=Imp|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Neg",
        "Tense": "Imp",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Tense=Imp|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Tense": "Imp",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Tense=Imp|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Neg",
        "Tense": "Imp",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Tense=Imp|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Tense": "Imp",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin": {
        POS: AUX,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "AUX_Aspect=Imp|VerbForm=Part": {POS: AUX, "Aspect": "Imp", "VerbForm": "Part"},
    "AUX_Aspect=Perf|VerbForm=Part": {POS: AUX, "Aspect": "Perf", "VerbForm": "Part"},
    "AUX_Aspect=Prosp|VerbForm=Part": {POS: AUX, "Aspect": "Prosp", "VerbForm": "Part"},
    "AUX_Polarity=Pos": {POS: AUX, "Polarity": "Pos"},
    "CCONJ_ConjType=Comp": {POS: CCONJ, "ConjType": "Comp"},
    "CCONJ_ConjType=Comp|Style=Coll": {POS: CCONJ, "ConjType": "Comp", "Style": "Coll"},
    "DET_Case=Gen|Distance=Med|Number=Plur|Poss=Yes|PronType=Dem": {
        POS: DET,
        "Case": "Gen",
        "Distance": "Med",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Dem",
    },
    "DET_Case=Gen|Distance=Med|Number=Sing|Poss=Yes|PronType=Dem": {
        POS: DET,
        "Case": "Gen",
        "Distance": "Med",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Dem",
    },
    "DET_Case=Gen|Number=Plur|Person=1|Poss=Yes|PronType=Prs": {
        POS: DET,
        "Case": "Gen",
        "Number": "Plur",
        "Person": "1",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "DET_Case=Gen|Number=Plur|Person=2|Polite=Infm|Poss=Yes|PronType=Prs": {
        POS: DET,
        "Case": "Gen",
        "Number": "Plur",
        "Person": "2",
        "Polite": "Infm",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "DET_Case=Gen|Number=Plur|Person=3|Poss=Yes|PronType=Emp": {
        POS: DET,
        "Case": "Gen",
        "Number": "Plur",
        "Person": "3",
        "Poss": "Yes",
        "PronType": "Emp",
    },
    "DET_Case=Gen|Number=Plur|Person=3|Poss=Yes|PronType=Emp|Reflex=Yes": {
        POS: DET,
        "Case": "Gen",
        "Number": "Plur",
        "Person": "3",
        "Poss": "Yes",
        "PronType": "Emp",
        "Reflex": "Yes",
    },
    "DET_Case=Gen|Number=Sing|Person=1|Poss=Yes|PronType=Prs": {
        POS: DET,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "1",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "DET_Case=Gen|Number=Sing|Person=2|Polite=Infm|Poss=Yes|PronType=Prs": {
        POS: DET,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "2",
        "Polite": "Infm",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "DET_Case=Gen|Number=Sing|Person=3|Poss=Yes|PronType=Emp": {
        POS: DET,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "3",
        "Poss": "Yes",
        "PronType": "Emp",
    },
    "DET_Case=Gen|Number=Sing|Person=3|Poss=Yes|PronType=Emp|Reflex=Yes": {
        POS: DET,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "3",
        "Poss": "Yes",
        "PronType": "Emp",
        "Reflex": "Yes",
    },
    "DET_Case=Gen|Number=Sing|Person=3|Poss=Yes|PronType=Prs": {
        POS: DET,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "3",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "DET_Case=Gen|Number=Sing|Poss=Yes|PronType=Rel": {
        POS: DET,
        "Case": "Gen",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Rel",
    },
    "DET_Distance=Dist|PronType=Dem": {POS: DET, "Distance": "Dist", "PronType": "Dem"},
    "DET_Distance=Dist|PronType=Dem|Style=Coll": {
        POS: DET,
        "Distance": "Dist",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "DET_Distance=Dist|PronType=Dem|Style=Vrnc": {
        POS: DET,
        "Distance": "Dist",
        "PronType": "Dem",
        "Style": "Vrnc",
    },
    "DET_Distance=Med|PronType=Dem": {POS: DET, "Distance": "Med", "PronType": "Dem"},
    "DET_Distance=Med|PronType=Dem|Style=Coll": {
        POS: DET,
        "Distance": "Med",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "DET_Distance=Prox|PronType=Dem": {POS: DET, "Distance": "Prox", "PronType": "Dem"},
    "DET_Distance=Prox|PronType=Dem|Style=Coll": {
        POS: DET,
        "Distance": "Prox",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "DET_PronType=Art": {POS: DET, "PronType": "Art"},
    "DET_PronType=Exc": {POS: DET, "PronType": "Exc"},
    "DET_PronType=Ind": {POS: DET, "PronType": "Ind"},
    "DET_PronType=Int": {POS: DET, "PronType": "Int"},
    "DET_PronType=Tot": {POS: DET, "PronType": "Tot"},
    "DET_PronType=Tot|Style=Arch": {POS: DET, "PronType": "Tot", "Style": "Arch"},
    "INTJ_Style=Vrnc": {POS: INTJ, "Style": "Vrnc"},
    "NOUN_Abbr=Yes|Animacy=Nhum|Case=Dat|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Abbr": "Yes",
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Abbr=Yes|Animacy=Nhum|Case=Nom|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Abbr": "Yes",
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Abl|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Hum|Case=Abl|Definite=Ind|Number=Plur|Style=Slng": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Plur",
        "Style": "Slng",
    },
    "NOUN_Animacy=Hum|Case=Abl|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Def|Number=Plur": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Plur",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Def|Number=Sing": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Def|Number=Sing|Style=Slng": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
        "Style": "Slng",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Ind|Number=Assoc": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Assoc",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Ind|Number=Plur|Style=Coll": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Plur",
        "Style": "Coll",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Ind|Number=Plur|Style=Slng": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Plur",
        "Style": "Slng",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Dat|Definite=Ind|Number=Sing|Style=Arch": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Arch",
    },
    "NOUN_Animacy=Hum|Case=Dat|Number=Sing|Number=Sing|Person=1": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "1",
    },
    "NOUN_Animacy=Hum|Case=Dat|Number=Sing|Number=Sing|Person=1|Style=Coll": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "1",
        "Style": "Coll",
    },
    "NOUN_Animacy=Hum|Case=Ins|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Def|Number=Plur": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Plur",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Def|Number=Plur|Style=Slng": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Plur",
        "Style": "Slng",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Def|Number=Sing": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Def|Number=Sing|Style=Coll": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Sing",
        "Style": "Coll",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Assoc": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Assoc",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Plur|Style=Coll": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Plur",
        "Style": "Coll",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Plur|Style=Slng": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Plur",
        "Style": "Slng",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Plur|Typo=Yes": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Plur",
        "Typo": "Yes",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Hum|Case=Nom|Definite=Ind|Number=Sing|Style=Coll": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Coll",
    },
    "NOUN_Animacy=Hum|Case=Nom|Number=Sing|Number=Sing|Person=1": {
        POS: NOUN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "1",
    },
    "NOUN_Animacy=Nhum|Case=Abl|Definite=Ind|Number=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Abl|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Abl|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Abl|Definite=Ind|Number=Sing|Style=Arch": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Arch",
    },
    "NOUN_Animacy=Nhum|Case=Abl|Number=Sing|Number=Sing|Person=2": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "2",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Sing|NumForm=Digit": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
        "NumForm": "Digit",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Sing|NumForm=Word": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
        "NumForm": "Word",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Sing|Style=Rare": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
        "Style": "Rare",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Def|Number=Sing|Style=Vrnc": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
        "Style": "Vrnc",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Ind|Number=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Ind|Number=Sing|NumForm=Digit": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
        "NumForm": "Digit",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Ind|Number=Sing|Style=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Definite=Ind|Number=Sing|Style=Vrnc": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Vrnc",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Number=Coll|Number=Sing|Person=1": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        # "Number": "Coll",
        "Number": "Sing",
        "Person": "1",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Number=Sing|Number=Sing|Person=1": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "1",
    },
    "NOUN_Animacy=Nhum|Case=Dat|Number=Sing|Number=Sing|Person=2": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "2",
    },
    "NOUN_Animacy=Nhum|Case=Gen|Definite=Ind|Number=Sing|Style=Arch": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Gen",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Arch",
    },
    "NOUN_Animacy=Nhum|Case=Ins|Definite=Ind|Number=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Ins|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Ins|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Ins|Definite=Ind|Number=Sing|Style=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Sing",
        "Style": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Ins|Number=Sing|Number=Sing|Person=1": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Ins",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "1",
    },
    "NOUN_Animacy=Nhum|Case=Loc|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Loc",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Loc|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Loc",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Loc|Number=Sing|Number=Sing|Person=2": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Loc",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "2",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Def|Number=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Def|Number=Plur|Number=Sing|Poss=Yes": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        # "Number": "Plur",
        "Number": "Sing",
        "Poss": "Yes",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Def|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Def|Number=Sing|NumForm=Digit": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Sing",
        "NumForm": "Digit",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Def|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Ind|Number=Coll": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Coll",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Ind|Number=Coll|Typo=Yes": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Coll",
        "Typo": "Yes",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Ind|Number=Plur": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Ind|Number=Sing": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Definite=Ind": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Number=Plur|Number=Sing|Person=2": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        # "Number": "Plur",
        "Number": "Sing",
        "Person": "2",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Number=Sing|Number=Sing|Person=1": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "1",
    },
    "NOUN_Animacy=Nhum|Case=Nom|Number=Sing|Number=Sing|Person=2": {
        POS: NOUN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Number": "Sing",
        "Number": "Sing",
        "Person": "2",
    },
    "NUM_NumForm=Digit|NumType=Card": {POS: NUM, "NumForm": "Digit", "NumType": "Card"},
    "NUM_NumForm=Digit|NumType=Frac|Typo=Yes": {
        POS: NUM,
        "NumForm": "Digit",
        "NumType": "Frac",
        "Typo": "Yes",
    },
    "NUM_NumForm=Digit|NumType=Range": {
        POS: NUM,
        "NumForm": "Digit",
        "NumType": "Range",
    },
    "NUM_NumForm=Word|NumType=Card": {POS: NUM, "NumForm": "Word", "NumType": "Card"},
    "NUM_NumForm=Word|NumType=Dist": {POS: NUM, "NumForm": "Word", "NumType": "Dist"},
    "NUM_NumForm=Word|NumType=Range": {POS: NUM, "NumForm": "Word", "NumType": "Range"},
    "PART_Polarity=Neg": {POS: PART, "Polarity": "Neg"},
    "PRON_Case=Abl|Definite=Ind|Number=Sing|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Abl|Number=Plur|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Abl",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Abl|Number=Sing|Person=2|Polite=Infm|PronType=Prs": {
        POS: PRON,
        "Case": "Abl",
        "Number": "Sing",
        "Person": "2",
        "Polite": "Infm",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Definite=Def|Distance=Dist|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Dat",
        "Definite": "Def",
        "Distance": "Dist",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Dat|Definite=Def|Number=Sing|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Definite=Ind|Number=Sing|PronType=Int": {
        POS: PRON,
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Sing",
        "PronType": "Int",
    },
    "PRON_Case=Dat|Distance=Dist|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Dat",
        "Distance": "Dist",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Dat|Distance=Med|Number=Plur|PronType=Dem": {
        POS: PRON,
        "Case": "Dat",
        "Distance": "Med",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "PRON_Case=Dat|Number=Plur|Person=1|PronType=Prs": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Number=Plur|Person=2|Polite=Infm|PronType=Prs": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Plur",
        "Person": "2",
        "Polite": "Infm",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Number=Plur|Person=3|PronType=Emp|Reflex=Yes": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Emp",
        "Reflex": "Yes",
    },
    "PRON_Case=Dat|Number=Plur|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Number=Plur|PronType=Rcp": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Rcp",
    },
    "PRON_Case=Dat|Number=Sing|Person=1|PronType=Prs": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Number=Sing|Person=2|Polite=Infm|PronType=Prs": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Sing",
        "Person": "2",
        "Polite": "Infm",
        "PronType": "Prs",
    },
    "PRON_Case=Dat|Number=Sing|Person=3|PronType=Emp": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Emp",
    },
    "PRON_Case=Dat|Number=Sing|Person=3|PronType=Emp|Reflex=Yes": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Emp",
        "Reflex": "Yes",
    },
    "PRON_Case=Dat|Number=Sing|PronType=Int": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Int",
    },
    "PRON_Case=Dat|Number=Sing|PronType=Rel": {
        POS: PRON,
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "PRON_Case=Dat|PronType=Tot": {POS: PRON, "Case": "Dat", "PronType": "Tot"},
    "PRON_Case=Gen|Distance=Med|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Gen",
        "Distance": "Med",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Gen|Number=Plur|Person=1|PronType=Prs": {
        POS: PRON,
        "Case": "Gen",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "PRON_Case=Gen|Number=Sing|Person=2|PronType=Prs": {
        POS: PRON,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "PRON_Case=Gen|Number=Sing|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Gen",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Gen|PronType=Tot": {POS: PRON, "Case": "Gen", "PronType": "Tot"},
    "PRON_Case=Ins|Definite=Ind|Number=Sing|PronType=Rel": {
        POS: PRON,
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "PRON_Case=Ins|Distance=Med|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Ins",
        "Distance": "Med",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Loc|Definite=Ind|Number=Sing|PronType=Rel": {
        POS: PRON,
        "Case": "Loc",
        "Definite": "Ind",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "PRON_Case=Loc|Distance=Med|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Loc",
        "Distance": "Med",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Nom|Definite=Def|Distance=Dist|Number=Plur|PronType=Dem": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Def",
        "Distance": "Dist",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "PRON_Case=Nom|Definite=Def|Distance=Med|Number=Sing|PronType=Dem|Style=Coll": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Def",
        "Distance": "Med",
        "Number": "Sing",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "PRON_Case=Nom|Definite=Def|Number=Sing|PronType=Int": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Sing",
        "PronType": "Int",
    },
    "PRON_Case=Nom|Definite=Def|Number=Sing|PronType=Rel": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "PRON_Case=Nom|Definite=Ind|Number=Sing|PronType=Int": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
        "PronType": "Int",
    },
    "PRON_Case=Nom|Definite=Ind|Number=Sing|PronType=Neg": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
        "PronType": "Neg",
    },
    "PRON_Case=Nom|Definite=Ind|Number=Sing|PronType=Rel": {
        POS: PRON,
        "Case": "Nom",
        "Definite": "Ind",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "PRON_Case=Nom|Distance=Dist|Number=Plur|Person=1|PronType=Dem": {
        POS: PRON,
        "Case": "Nom",
        "Distance": "Dist",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Dem",
    },
    "PRON_Case=Nom|Distance=Med|Number=Plur|PronType=Dem": {
        POS: PRON,
        "Case": "Nom",
        "Distance": "Med",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "PRON_Case=Nom|Distance=Med|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Nom",
        "Distance": "Med",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Nom|Distance=Prox|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Case": "Nom",
        "Distance": "Prox",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Case=Nom|Number=Plur|Person=1|PronType=Prs": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "PRON_Case=Nom|Number=Plur|Person=3|PronType=Emp": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Emp",
    },
    "PRON_Case=Nom|Number=Plur|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Nom|Number=Plur|PronType=Rel": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "PRON_Case=Nom|Number=Sing|Number=Plur|Person=3|Person=1|PronType=Emp": {
        POS: PRON,
        "Case": "Nom",
        # "Number": "Sing",
        "Number": "Plur",
        # "Person": "3",
        "Person": "1",
        "PronType": "Emp",
    },
    "PRON_Case=Nom|Number=Sing|Person=1|PronType=Int": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Int",
    },
    "PRON_Case=Nom|Number=Sing|Person=1|PronType=Prs": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "PRON_Case=Nom|Number=Sing|Person=2|Polite=Infm|PronType=Prs": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "Person": "2",
        "Polite": "Infm",
        "PronType": "Prs",
    },
    "PRON_Case=Nom|Number=Sing|Person=3|PronType=Emp": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Emp",
    },
    "PRON_Case=Nom|Number=Sing|Person=3|PronType=Prs": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "PRON_Case=Nom|Number=Sing|PronType=Int": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "PronType": "Int",
    },
    "PRON_Case=Nom|Number=Sing|PronType=Rel": {
        POS: PRON,
        "Case": "Nom",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "PRON_Case=Nom|Person=1|PronType=Tot": {
        POS: PRON,
        "Case": "Nom",
        "Person": "1",
        "PronType": "Tot",
    },
    "PRON_Case=Nom|PronType=Ind": {POS: PRON, "Case": "Nom", "PronType": "Ind"},
    "PRON_Case=Nom|PronType=Tot": {POS: PRON, "Case": "Nom", "PronType": "Tot"},
    "PRON_Distance=Dist|Number=Sing|PronType=Dem": {
        POS: PRON,
        "Distance": "Dist",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "PRON_Distance=Med|PronType=Dem|Style=Coll": {
        POS: PRON,
        "Distance": "Med",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "PRON_Distance=Prox|PronType=Dem|Style=Coll": {
        POS: PRON,
        "Distance": "Prox",
        "PronType": "Dem",
        "Style": "Coll",
    },
    "PRON_Number=Plur|PronType=Rel": {POS: PRON, "Number": "Plur", "PronType": "Rel"},
    "PROPN_Abbr=Yes|Animacy=Hum|Case=Nom|Definite=Ind|NameType=Giv|Number=Sing": {
        POS: PROPN,
        "Abbr": "Yes",
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "PROPN_Abbr=Yes|Animacy=Nhum|Case=Nom|Definite=Ind|NameType=Com|Number=Sing": {
        POS: PROPN,
        "Abbr": "Yes",
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Com",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Dat|Definite=Def|NameType=Sur|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Def",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Dat|Definite=Ind|NameType=Prs|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "NameType": "Prs",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Dat|Definite=Ind|NameType=Sur|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Dat",
        "Definite": "Ind",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Nom|Definite=Def|NameType=Giv|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Def",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Nom|Definite=Def|NameType=Sur|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Def",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Nom|Definite=Ind|NameType=Giv|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "PROPN_Animacy=Hum|Case=Nom|Definite=Ind|NameType=Sur|Number=Sing": {
        POS: PROPN,
        "Animacy": "Hum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "PROPN_Animacy=Nhum|Case=Abl|Definite=Ind|NameType=Geo|Number=Coll": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Coll",
    },
    "PROPN_Animacy=Nhum|Case=Abl|Definite=Ind|NameType=Geo|Number=Sing": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "PROPN_Animacy=Nhum|Case=Abl|Definite=Ind|Number=Plur": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Plur",
    },
    "PROPN_Animacy=Nhum|Case=Dat|Definite=Ind|NameType=Geo|Number=Sing": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "PROPN_Animacy=Nhum|Case=Dat|Definite=Ind|NameType=Geo|Number=Sing|Style=Coll": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Dat",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Sing",
        "Style": "Coll",
    },
    "PROPN_Animacy=Nhum|Case=Loc|Definite=Ind|NameType=Geo|Number=Sing": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Loc",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "PROPN_Animacy=Nhum|Case=Nom|Definite=Def|NameType=Geo|Number=Sing": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "PROPN_Animacy=Nhum|Case=Nom|Definite=Def|NameType=Pro|Number=Sing|Style=Coll": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Def",
        "NameType": "Pro",
        "Number": "Sing",
        "Style": "Coll",
    },
    "PROPN_Animacy=Nhum|Case=Nom|Definite=Ind|NameType=Geo|Number=Coll": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Coll",
    },
    "PROPN_Animacy=Nhum|Case=Nom|Definite=Ind|NameType=Geo|Number=Sing": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "PROPN_Animacy=Nhum|Case=Nom|Definite=Ind|NameType=Geo|Number=Sing|Style=Vrnc": {
        POS: PROPN,
        "Animacy": "Nhum",
        "Case": "Nom",
        "Definite": "Ind",
        "NameType": "Geo",
        "Number": "Sing",
        "Style": "Vrnc",
    },
    "SCONJ_Style=Coll": {POS: SCONJ, "Style": "Coll"},
    "VERB_Aspect=Dur|Polarity=Neg|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Dur",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Dur|Polarity=Pos|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Dur",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Dur|Polarity=Pos|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Dur",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Dur|Polarity=Pos|Subcat=Tran|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Dur",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Dur|Polarity=Pos|Subcat=Tran|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Dur",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "1",
        "Polarity": "Neg",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Subcat=Tran|Tense=Imp|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Imp",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Neg",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Neg",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Imp|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Imp",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Style=Coll|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Style": "Coll",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Style=Vrnc|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Style": "Vrnc",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Subcat=Intr|VerbForm=Part": {
        POS: VERB,
        "Aspect": "Imp",
        "Subcat": "Intr",
        "VerbForm": "Part",
    },
    "VERB_Aspect=Imp|Subcat=Intr|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Imp",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Imp|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Imp",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Imp|Subcat=Tran|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Imp",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Imp|Subcat=Tran|VerbForm=Part|Voice=Cau": {
        POS: VERB,
        "Aspect": "Imp",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Cau",
    },
    "VERB_Aspect=Iter|Case=Ins|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Mid": {
        POS: VERB,
        "Aspect": "Iter",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Mid",
    },
    "VERB_Aspect=Iter|Case=Ins|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Tran|VerbForm=Gdv|Voice=Act": {
        POS: VERB,
        "Aspect": "Iter",
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Gdv",
        "Voice": "Act",
    },
    "VERB_Aspect=Iter": {POS: VERB, "Aspect": "Iter"},
    "VERB_Aspect=Perf|Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Subcat=Intr|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Subcat=Intr|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Subcat=Intr|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Vrnc|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Style": "Vrnc",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Subcat=Intr|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Vrnc|Subcat=Intr|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Neg",
        "Style": "Vrnc",
        "Subcat": "Intr",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Neg",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Past|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Past",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Polarity=Neg|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Perf|Polarity=Pos|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Polarity=Pos|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Perf|Polarity=Pos|Subcat=Tran|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Polarity=Pos|Subcat=Tran|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Perf|Polarity=Pos|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Pos",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Perf",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Perf|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Perf",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Perf|Subcat=Tran|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Perf",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Perf|Subcat=Tran|VerbForm=Part|Voice=Cau": {
        POS: VERB,
        "Aspect": "Perf",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Cau",
    },
    "VERB_Aspect=Prog|Subcat=Intr|VerbForm=Conv|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prog",
        "Subcat": "Intr",
        "VerbForm": "Conv",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Connegative=Yes|Mood=Cnd|Subcat=Tran|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Connegative": "Yes",
        "Mood": "Cnd",
        "Subcat": "Tran",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Plur|Person=3|Polarity=Pos|Style=Vrnc|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Style": "Vrnc",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Plur|Person=3|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Sing|Person=1|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Sing|Person=2|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Pass": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Pass",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Imp|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Imp",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Cnd|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Imp|Number=Sing|Person=2|Subcat=Intr|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Imp",
        "Number": "Sing",
        "Person": "2",
        "Subcat": "Intr",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Imp|Number=Sing|Person=2|Subcat=Tran|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Imp",
        "Number": "Sing",
        "Person": "2",
        "Subcat": "Tran",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Plur|Person=1|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Plur|Person=3|Polarity=Neg|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Plur|Person=3|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=1|Polarity=Neg|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=1|Polarity=Neg|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Neg",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=1|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=1|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "1",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=2|Polarity=Pos|Subcat=Tran|Tense=Imp|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Imp",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=2|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "2",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|Tense=Imp|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Imp",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|Tense=Pres|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=3|Polarity=Pos|Subcat=Intr|VerbForm=Fin|Voice=Pass": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Fin",
        "Voice": "Pass",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Imp|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Imp",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Number=Sing|Person=3|Polarity=Pos|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Mood=Sub|Person=1|Polarity=Neg|Subcat=Tran|Tense=Pres|VerbForm=Fin|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Mood": "Sub",
        "Person": "1",
        "Polarity": "Neg",
        "Subcat": "Tran",
        "Tense": "Pres",
        "VerbForm": "Fin",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Polarity=Pos|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Polarity=Pos|Subcat=Tran|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Aspect=Prosp|Subcat=Intr|VerbForm=Part|Voice=Mid": {
        POS: VERB,
        "Aspect": "Prosp",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Mid",
    },
    "VERB_Aspect=Prosp|Subcat=Intr|VerbForm=Part|Voice=Pass": {
        POS: VERB,
        "Aspect": "Prosp",
        "Subcat": "Intr",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "VERB_Aspect=Prosp|Subcat=Tran|VerbForm=Part|Voice=Act": {
        POS: VERB,
        "Aspect": "Prosp",
        "Subcat": "Tran",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "VERB_Case=Abl|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Mid": {
        POS: VERB,
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Mid",
    },
    "VERB_Case=Abl|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Pass": {
        POS: VERB,
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Pass",
    },
    "VERB_Case=Abl|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Tran|VerbForm=Gdv|Voice=Act": {
        POS: VERB,
        "Case": "Abl",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Gdv",
        "Voice": "Act",
    },
    "VERB_Case=Dat|Definite=Def|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Mid": {
        POS: VERB,
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Mid",
    },
    "VERB_Case=Dat|Definite=Ind|Number=Coll|Polarity=Neg|Subcat=Intr|VerbForm=Gdv|Voice=Pass": {
        POS: VERB,
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Neg",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Pass",
    },
    "VERB_Case=Dat|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Mid": {
        POS: VERB,
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Mid",
    },
    "VERB_Case=Dat|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Tran|VerbForm=Gdv|Voice=Act": {
        POS: VERB,
        "Case": "Dat",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Gdv",
        "Voice": "Act",
    },
    "VERB_Case=Ins|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Mid": {
        POS: VERB,
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Mid",
    },
    "VERB_Case=Ins|Definite=Ind|Number=Coll|Polarity=Pos|Subcat=Tran|VerbForm=Gdv|Voice=Act": {
        POS: VERB,
        "Case": "Ins",
        "Definite": "Ind",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Gdv",
        "Voice": "Act",
    },
    "VERB_Case=Nom|Definite=Def|Number=Coll|Polarity=Pos|Subcat=Intr|VerbForm=Gdv|Voice=Mid": {
        POS: VERB,
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Gdv",
        "Voice": "Mid",
    },
    "VERB_Case=Nom|Definite=Def|Number=Coll|Polarity=Pos|Subcat=Tran|VerbForm=Gdv|Voice=Act": {
        POS: VERB,
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Coll",
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Gdv",
        "Voice": "Act",
    },
    "VERB_Mood=Imp|Number=Sing|Person=2|Subcat=Intr|VerbForm=Fin|Voice=Mid": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Sing",
        "Person": "2",
        "Subcat": "Intr",
        "VerbForm": "Fin",
        "Voice": "Mid",
    },
    "VERB_Polarity=Neg|Subcat=Intr|VerbForm=Inf|Voice=Mid": {
        POS: VERB,
        "Polarity": "Neg",
        "Subcat": "Intr",
        "VerbForm": "Inf",
        "Voice": "Mid",
    },
    "VERB_Polarity=Pos|Style=Coll|Subcat=Tran|VerbForm=Inf|Voice=Act": {
        POS: VERB,
        "Polarity": "Pos",
        "Style": "Coll",
        "Subcat": "Tran",
        "VerbForm": "Inf",
        "Voice": "Act",
    },
    "VERB_Polarity=Pos|Style=Vrnc|Subcat=Tran|VerbForm=Inf|Voice=Act": {
        POS: VERB,
        "Polarity": "Pos",
        "Style": "Vrnc",
        "Subcat": "Tran",
        "VerbForm": "Inf",
        "Voice": "Act",
    },
    "VERB_Polarity=Pos|Subcat=Intr|VerbForm=Inf|Voice=Mid": {
        POS: VERB,
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Inf",
        "Voice": "Mid",
    },
    "VERB_Polarity=Pos|Subcat=Intr|VerbForm=Inf|Voice=Pass": {
        POS: VERB,
        "Polarity": "Pos",
        "Subcat": "Intr",
        "VerbForm": "Inf",
        "Voice": "Pass",
    },
    "VERB_Polarity=Pos|Subcat=Tran|Typo=Yes|VerbForm=Inf|Voice=Act": {
        POS: VERB,
        "Polarity": "Pos",
        "Subcat": "Tran",
        "Typo": "Yes",
        "VerbForm": "Inf",
        "Voice": "Act",
    },
    "VERB_Polarity=Pos|Subcat=Tran|VerbForm=Inf|Voice=Act": {
        POS: VERB,
        "Polarity": "Pos",
        "Subcat": "Tran",
        "VerbForm": "Inf",
        "Voice": "Act",
    },
    "X_Foreign=Yes": {POS: X, "Foreign": "Yes"},
    "X_Style=Vrnc": {POS: X, "Style": "Vrnc"},
}
